package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ProcessRepliedShortMessages invokes the cloudcallcenter.ProcessRepliedShortMessages API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/processrepliedshortmessages.html
func (client *Client) ProcessRepliedShortMessages(request *ProcessRepliedShortMessagesRequest) (response *ProcessRepliedShortMessagesResponse, err error) {
	response = CreateProcessRepliedShortMessagesResponse()
	err = client.DoAction(request, response)
	return
}

// ProcessRepliedShortMessagesWithChan invokes the cloudcallcenter.ProcessRepliedShortMessages API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/processrepliedshortmessages.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ProcessRepliedShortMessagesWithChan(request *ProcessRepliedShortMessagesRequest) (<-chan *ProcessRepliedShortMessagesResponse, <-chan error) {
	responseChan := make(chan *ProcessRepliedShortMessagesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ProcessRepliedShortMessages(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ProcessRepliedShortMessagesWithCallback invokes the cloudcallcenter.ProcessRepliedShortMessages API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/processrepliedshortmessages.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ProcessRepliedShortMessagesWithCallback(request *ProcessRepliedShortMessagesRequest, callback func(response *ProcessRepliedShortMessagesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ProcessRepliedShortMessagesResponse
		var err error
		defer close(result)
		response, err = client.ProcessRepliedShortMessages(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ProcessRepliedShortMessagesRequest is the request struct for api ProcessRepliedShortMessages
type ProcessRepliedShortMessagesRequest struct {
	*requests.RpcRequest
	SmsUpMessage *[]ProcessRepliedShortMessagesSmsUpMessage `position:"Query" name:"SmsUpMessage"  type:"Repeated"`
}

// ProcessRepliedShortMessagesSmsUpMessage is a repeated param struct in ProcessRepliedShortMessagesRequest
type ProcessRepliedShortMessagesSmsUpMessage struct {
	SignName    string `name:"SignName"`
	DestCode    string `name:"DestCode"`
	PhoneNumber string `name:"PhoneNumber"`
	SendTime    string `name:"SendTime"`
	SequenceId  string `name:"SequenceId"`
	Content     string `name:"Content"`
}

// ProcessRepliedShortMessagesResponse is the response struct for api ProcessRepliedShortMessages
type ProcessRepliedShortMessagesResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	WorkflowId     string `json:"WorkflowId" xml:"WorkflowId"`
}

// CreateProcessRepliedShortMessagesRequest creates a request to invoke ProcessRepliedShortMessages API
func CreateProcessRepliedShortMessagesRequest() (request *ProcessRepliedShortMessagesRequest) {
	request = &ProcessRepliedShortMessagesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ProcessRepliedShortMessages", "", "")
	request.Method = requests.POST
	return
}

// CreateProcessRepliedShortMessagesResponse creates a response to parse from ProcessRepliedShortMessages response
func CreateProcessRepliedShortMessagesResponse() (response *ProcessRepliedShortMessagesResponse) {
	response = &ProcessRepliedShortMessagesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
