package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLayer7CCRules invokes the ddoscoo.DescribeLayer7CCRules API synchronously
func (client *Client) DescribeLayer7CCRules(request *DescribeLayer7CCRulesRequest) (response *DescribeLayer7CCRulesResponse, err error) {
	response = CreateDescribeLayer7CCRulesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLayer7CCRulesWithChan invokes the ddoscoo.DescribeLayer7CCRules API asynchronously
func (client *Client) DescribeLayer7CCRulesWithChan(request *DescribeLayer7CCRulesRequest) (<-chan *DescribeLayer7CCRulesResponse, <-chan error) {
	responseChan := make(chan *DescribeLayer7CCRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLayer7CCRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLayer7CCRulesWithCallback invokes the ddoscoo.DescribeLayer7CCRules API asynchronously
func (client *Client) DescribeLayer7CCRulesWithCallback(request *DescribeLayer7CCRulesRequest, callback func(response *DescribeLayer7CCRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLayer7CCRulesResponse
		var err error
		defer close(result)
		response, err = client.DescribeLayer7CCRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLayer7CCRulesRequest is the request struct for api DescribeLayer7CCRules
type DescribeLayer7CCRulesRequest struct {
	*requests.RpcRequest
	Offset          requests.Integer `position:"Query" name:"Offset"`
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	Domain          string           `position:"Query" name:"Domain"`
	PageSize        string           `position:"Query" name:"PageSize"`
}

// DescribeLayer7CCRulesResponse is the response struct for api DescribeLayer7CCRules
type DescribeLayer7CCRulesResponse struct {
	*responses.BaseResponse
	RequestId     string         `json:"RequestId" xml:"RequestId"`
	Total         int64          `json:"Total" xml:"Total"`
	Layer7CCRules []Layer7CCRule `json:"Layer7CCRules" xml:"Layer7CCRules"`
}

// CreateDescribeLayer7CCRulesRequest creates a request to invoke DescribeLayer7CCRules API
func CreateDescribeLayer7CCRulesRequest() (request *DescribeLayer7CCRulesRequest) {
	request = &DescribeLayer7CCRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2017-12-28", "DescribeLayer7CCRules", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeLayer7CCRulesResponse creates a response to parse from DescribeLayer7CCRules response
func CreateDescribeLayer7CCRulesResponse() (response *DescribeLayer7CCRulesResponse) {
	response = &DescribeLayer7CCRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
