package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveDomainFrameRateAndBitRateData invokes the live.DescribeLiveDomainFrameRateAndBitRateData API synchronously
func (client *Client) DescribeLiveDomainFrameRateAndBitRateData(request *DescribeLiveDomainFrameRateAndBitRateDataRequest) (response *DescribeLiveDomainFrameRateAndBitRateDataResponse, err error) {
	response = CreateDescribeLiveDomainFrameRateAndBitRateDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveDomainFrameRateAndBitRateDataWithChan invokes the live.DescribeLiveDomainFrameRateAndBitRateData API asynchronously
func (client *Client) DescribeLiveDomainFrameRateAndBitRateDataWithChan(request *DescribeLiveDomainFrameRateAndBitRateDataRequest) (<-chan *DescribeLiveDomainFrameRateAndBitRateDataResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveDomainFrameRateAndBitRateDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveDomainFrameRateAndBitRateData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveDomainFrameRateAndBitRateDataWithCallback invokes the live.DescribeLiveDomainFrameRateAndBitRateData API asynchronously
func (client *Client) DescribeLiveDomainFrameRateAndBitRateDataWithCallback(request *DescribeLiveDomainFrameRateAndBitRateDataRequest, callback func(response *DescribeLiveDomainFrameRateAndBitRateDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveDomainFrameRateAndBitRateDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveDomainFrameRateAndBitRateData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveDomainFrameRateAndBitRateDataRequest is the request struct for api DescribeLiveDomainFrameRateAndBitRateData
type DescribeLiveDomainFrameRateAndBitRateDataRequest struct {
	*requests.RpcRequest
	QueryTime  string           `position:"Query" name:"QueryTime"`
	DomainName string           `position:"Query" name:"DomainName"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeLiveDomainFrameRateAndBitRateDataResponse is the response struct for api DescribeLiveDomainFrameRateAndBitRateData
type DescribeLiveDomainFrameRateAndBitRateDataResponse struct {
	*responses.BaseResponse
	RequestId                string                                                              `json:"RequestId" xml:"RequestId"`
	FrameRateAndBitRateInfos FrameRateAndBitRateInfosInDescribeLiveDomainFrameRateAndBitRateData `json:"FrameRateAndBitRateInfos" xml:"FrameRateAndBitRateInfos"`
}

// CreateDescribeLiveDomainFrameRateAndBitRateDataRequest creates a request to invoke DescribeLiveDomainFrameRateAndBitRateData API
func CreateDescribeLiveDomainFrameRateAndBitRateDataRequest() (request *DescribeLiveDomainFrameRateAndBitRateDataRequest) {
	request = &DescribeLiveDomainFrameRateAndBitRateDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveDomainFrameRateAndBitRateData", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLiveDomainFrameRateAndBitRateDataResponse creates a response to parse from DescribeLiveDomainFrameRateAndBitRateData response
func CreateDescribeLiveDomainFrameRateAndBitRateDataResponse() (response *DescribeLiveDomainFrameRateAndBitRateDataResponse) {
	response = &DescribeLiveDomainFrameRateAndBitRateDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
