package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeBruteForceSummary invokes the sas.DescribeBruteForceSummary API synchronously
func (client *Client) DescribeBruteForceSummary(request *DescribeBruteForceSummaryRequest) (response *DescribeBruteForceSummaryResponse, err error) {
	response = CreateDescribeBruteForceSummaryResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeBruteForceSummaryWithChan invokes the sas.DescribeBruteForceSummary API asynchronously
func (client *Client) DescribeBruteForceSummaryWithChan(request *DescribeBruteForceSummaryRequest) (<-chan *DescribeBruteForceSummaryResponse, <-chan error) {
	responseChan := make(chan *DescribeBruteForceSummaryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeBruteForceSummary(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeBruteForceSummaryWithCallback invokes the sas.DescribeBruteForceSummary API asynchronously
func (client *Client) DescribeBruteForceSummaryWithCallback(request *DescribeBruteForceSummaryRequest, callback func(response *DescribeBruteForceSummaryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeBruteForceSummaryResponse
		var err error
		defer close(result)
		response, err = client.DescribeBruteForceSummary(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeBruteForceSummaryRequest is the request struct for api DescribeBruteForceSummary
type DescribeBruteForceSummaryRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
}

// DescribeBruteForceSummaryResponse is the response struct for api DescribeBruteForceSummary
type DescribeBruteForceSummaryResponse struct {
	*responses.BaseResponse
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	BruteForceSummary BruteForceSummary `json:"BruteForceSummary" xml:"BruteForceSummary"`
}

// CreateDescribeBruteForceSummaryRequest creates a request to invoke DescribeBruteForceSummary API
func CreateDescribeBruteForceSummaryRequest() (request *DescribeBruteForceSummaryRequest) {
	request = &DescribeBruteForceSummaryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribeBruteForceSummary", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeBruteForceSummaryResponse creates a response to parse from DescribeBruteForceSummary response
func CreateDescribeBruteForceSummaryResponse() (response *DescribeBruteForceSummaryResponse) {
	response = &DescribeBruteForceSummaryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
