package voicenavigator

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifySilenceTimeoutConfig invokes the voicenavigator.ModifySilenceTimeoutConfig API synchronously
func (client *Client) ModifySilenceTimeoutConfig(request *ModifySilenceTimeoutConfigRequest) (response *ModifySilenceTimeoutConfigResponse, err error) {
	response = CreateModifySilenceTimeoutConfigResponse()
	err = client.DoAction(request, response)
	return
}

// ModifySilenceTimeoutConfigWithChan invokes the voicenavigator.ModifySilenceTimeoutConfig API asynchronously
func (client *Client) ModifySilenceTimeoutConfigWithChan(request *ModifySilenceTimeoutConfigRequest) (<-chan *ModifySilenceTimeoutConfigResponse, <-chan error) {
	responseChan := make(chan *ModifySilenceTimeoutConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifySilenceTimeoutConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifySilenceTimeoutConfigWithCallback invokes the voicenavigator.ModifySilenceTimeoutConfig API asynchronously
func (client *Client) ModifySilenceTimeoutConfigWithCallback(request *ModifySilenceTimeoutConfigRequest, callback func(response *ModifySilenceTimeoutConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifySilenceTimeoutConfigResponse
		var err error
		defer close(result)
		response, err = client.ModifySilenceTimeoutConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifySilenceTimeoutConfigRequest is the request struct for api ModifySilenceTimeoutConfig
type ModifySilenceTimeoutConfigRequest struct {
	*requests.RpcRequest
	FinalAction       string           `position:"Query" name:"FinalAction"`
	FinalPrompt       string           `position:"Query" name:"FinalPrompt"`
	Threshold         requests.Integer `position:"Query" name:"Threshold"`
	IntentTrigger     string           `position:"Query" name:"IntentTrigger"`
	Timeout           requests.Integer `position:"Query" name:"Timeout"`
	InstanceId        string           `position:"Query" name:"InstanceId"`
	SourceType        string           `position:"Query" name:"SourceType"`
	FinalActionParams string           `position:"Query" name:"FinalActionParams"`
	Prompt            string           `position:"Query" name:"Prompt"`
}

// ModifySilenceTimeoutConfigResponse is the response struct for api ModifySilenceTimeoutConfig
type ModifySilenceTimeoutConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifySilenceTimeoutConfigRequest creates a request to invoke ModifySilenceTimeoutConfig API
func CreateModifySilenceTimeoutConfigRequest() (request *ModifySilenceTimeoutConfigRequest) {
	request = &ModifySilenceTimeoutConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("VoiceNavigator", "2018-06-12", "ModifySilenceTimeoutConfig", "voicebot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifySilenceTimeoutConfigResponse creates a response to parse from ModifySilenceTimeoutConfig response
func CreateModifySilenceTimeoutConfigResponse() (response *ModifySilenceTimeoutConfigResponse) {
	response = &ModifySilenceTimeoutConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
