//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//

#include "globals.hh"
#include "G4CollisionMesonBaryon.hh"
#include "G4CollisionMesonBaryonElastic.hh"
#include "G4CollisionComposite.hh"
#include "G4VCollision.hh"
#include "G4CollisionVector.hh"
#include "G4KineticTrack.hh"
#include "G4VCrossSectionSource.hh"
#include "G4XNNTotal.hh"
#include "G4Proton.hh"
#include "G4Neutron.hh"
#include "G4PionZero.hh"
#include "G4PionMinus.hh"
#include "G4PionPlus.hh"

#include "G4CollisionMesonBaryonToResonance.hh"
#include "G4CollisionMesonBaryonElastic.hh"

G4CollisionMesonBaryon::G4CollisionMesonBaryon()
{ 
  G4CollisionComposite::AddComponent(new G4CollisionMesonBaryonToResonance()); 
  G4CollisionComposite::AddComponent(new G4CollisionMesonBaryonElastic()); 
}

