<!--
Copyright (c) ONNX Project Contributors

SPDX-License-Identifier: Apache-2.0
-->

# ONNX CI Pipelines

* CI pipelines matrix:

|                                                                                           | When it runs                         | Test                                                                                                                                                                                                                                                                                                 |
|-------------------------------------------------------------------------------------------|--------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| [CI / Test](/.github/workflows/main.yml)                                                  | Every PR                             | ONNX C++ tests Test doc generation Test proto generation Verify node test generation                                                                                                                                                                                                                 |
| [Windows_No_Exception CI](/.github/workflows/win_no_exception_ci.yml)                     | Every PR                             | Only ONNX C++ tests Test selective schema loading                                                                                                                                                                                                                                                    |
| [Lint / Optional Lint](/.github/workflows/lint.yml)                                       | Every PR                             | Not required -- it shows lint warnings for suggestions in PR                                                                                                                                                                                                                                         |
| [Lint / Enforce style](/.github/workflows/lint.yml)                                       | Every PR                             | Required linters Auto-generated files are up to date                                                                                                                                                                                                                                                 |
| [WindowsRelease](/.github/workflows/release_win.yml)                                      | Main branch Release branch Weekly(1) |  Release Windows wheel Verify with different dependency versions - latest and min supported numpy version, latest and min supported protobuf version(2) Verify ONNX with the latest [ONNX Runtime PyPI package](https://pypi.org/project/onnxruntime/)(3).                                           |
| [LinuxRelease_aarch64](/.github/workflows/release_linux_aarch64.yml)                      | Main branch Release branch Weekly    |  Release Linux aarch64 wheel Verify with different dependency versions - latest numpy version, latest and min supported protobuf version Verify ONNX with the latest ONNX Runtime PyPI package                                                                                                       |
| [LinuxRelease_x86_64](/.github/workflows/release_linux_x86_64.yml)                        | Main branch Release branch Weekly    |  Release Linux x86_64 wheel Test TEST_HUB=1(4) Verify with different dependency versions - latest numpy version, latest and min supported protobuf version Verify ONNX with the latest ONNX Runtime PyPI package.                                                                                    |
| [MacRelease](/.github/workflows/release_mac.yml)                                          | Main branch Release branch Weekly    | Release Mac wheel Verify with different dependency versions - latest numpy version, latest and min supported protobuf version Verify ONNX with the latest ONNX Runtime PyPI package. Test source distribution generation Test build with source distribution Release onnx-weekly source distribution |
| [Weekly CI with the latest ONNX and ONNX Model Zoo](/.github/workflows/weekly_mac_ci.yml) | weekly(6)                            | Test latest ONNX checker Test latest ONNX shape inference With all models from [onnx/models](https://github.com/onnx/models)(7)                                                                                                                                                                      |
| [Reuse](/.github/workflows/reuse.yml)                                                     | Every PR                             | Checks for Copyright and License header More information could be found at: https://reuse.software/ If no license is to be added, or the checker does not recognize it, it must be configured under REUSE.toml.                                                                                      |
| [Dependabot](/.github/dependabot.yml)                                                     | Main branch weekly                   | Create PRs for new dependency versions                                                                                                                                                                                                                                                               |

Every PR

* (1) When the release CIs will run:
  * After a PR has been merged into main/rel-* branch
  * Run weekly (Sunday midnight) and publish Python wheel to [onnx-weekly](https://pypi.org/project/onnx-weekly/) package on PyPI [2024.10.23: The current consideration is to delete the packages on pypi only due to running out of disk space. Starting with the oldest packages.]
  * Any PR targeting rel-* branch
  * To manually run them, add a PR label "run release CIs" (only maintainers have permission).
* (2) Minimum supported versions are listed [here](/requirements.txt).
* (3) [Test](/onnx/test/test_with_ort.py) ONNX Python wheel with `onnxruntime.InferenceSession` from latest ONNXRuntime. Please note that ONNX Runtime does not support Windows-x86 thus its verification is skipped.
* (4) TEST_HUB=1 will test [onnx.hub](/onnx/test/hub_test.py) by using this API to download an ONNX model from onnx/models. This test is restricted to only 1 pipeline for saving quota usage.
* (5) Although the build environment is macos-11, use MACOSX_DEPLOYMENT_TARGET=10.12 and -p [macosx_10_12_x86_64](https://github.com/onnx/onnx/blob/2e048660ffa8243596aaf3338e60c7c0575458f2/.github/workflows/release_mac.yml#L74) to force the wheel to support 10.12+.

* (6):
  * The ONNX Model Zoo test will run weekly (Sunday midnight)
  * To manually trigger it, add a PR label "test ONNX Model Zoo" (only maintainers have permission). Please note that it will need a lot of bandwidth to download models through git-lfs API when loading models via [onnx.hub](/docs/Hub.md) so use it with caution.
* (7) Some old deprecated models (opset-1) are [skipped](/workflow_scripts/config.py).
