/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.eclipse.core.internal.runtime.XmlProcessorFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.internal.configurator.IConfigurationConstants;
import org.eclipse.update.internal.configurator.Messages;
import org.eclipse.update.internal.configurator.PluginEntry;
import org.eclipse.update.internal.configurator.Utils;
import org.eclipse.update.internal.configurator.VersionedIdentifier;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PluginParser
extends DefaultHandler
implements IConfigurationConstants {
    private SAXParser parser;
    private PluginEntry pluginEntry;
    private String location;

    public PluginParser() {
        try {
            this.parser = XmlProcessorFactory.createSAXParserWithErrorOnDOCTYPE((boolean)true);
        }
        catch (ParserConfigurationException e) {
            System.out.println(e);
        }
        catch (SAXException e) {
            System.out.println(e);
        }
    }

    public synchronized PluginEntry parse(File pluginFile) throws SAXException, IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream in = new FileInputStream(pluginFile);){
            return this.parse(in, "plugins/" + pluginFile.getParentFile().getName() + "/");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public synchronized PluginEntry parse(InputStream in, String bundleUrl) throws SAXException, IOException {
        try {
            this.location = bundleUrl;
            this.pluginEntry = new PluginEntry();
            this.pluginEntry.setURL(bundleUrl);
            this.parser.parse(new InputSource(in), (DefaultHandler)this);
        }
        catch (ParseCompleteException parseCompleteException) {
            // empty catch block
        }
        return this.pluginEntry;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String tag = localName.trim();
        if (tag.equalsIgnoreCase("plugin")) {
            this.pluginEntry.isFragment(false);
            this.processPlugin(attributes);
            return;
        }
        if (tag.equalsIgnoreCase("fragment")) {
            this.pluginEntry.isFragment(true);
            this.processPlugin(attributes);
            return;
        }
    }

    private void processPlugin(Attributes attributes) throws ParseCompleteException {
        String id = attributes.getValue("id");
        String version = attributes.getValue("version");
        if (id == null || id.trim().length() == 0) {
            id = "_no_id_";
            Utils.log(NLS.bind((String)Messages.PluginParser_plugin_no_id, (Object[])new String[]{this.location}));
        }
        if (version == null || version.trim().length() == 0) {
            version = "0.0.0";
            Utils.log(NLS.bind((String)Messages.PluginParser_plugin_no_version, (Object[])new String[]{this.location}));
        }
        this.pluginEntry.setVersionedIdentifier(new VersionedIdentifier(id, version));
        throw new ParseCompleteException("");
    }

    private static class ParseCompleteException
    extends SAXException {
        private static final long serialVersionUID = 1L;

        public ParseCompleteException(String arg0) {
            super(arg0);
        }
    }
}

