/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.ui.config;

import java.util.ArrayList;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.db2.model.DB2TableColumn;
import org.jkiss.dbeaver.ext.db2.model.DB2TableForeignKey;
import org.jkiss.dbeaver.ext.db2.model.DB2TableForeignKeyColumn;
import org.jkiss.dbeaver.ext.db2.model.DB2TableUniqueKey;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2DeleteUpdateRule;
import org.jkiss.dbeaver.ext.db2.ui.internal.DB2Messages;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectConfigurator;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLForeignKeyManager;
import org.jkiss.dbeaver.model.impl.struct.AbstractTableConstraint;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyModifyRule;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.editors.object.struct.EditForeignKeyPage;

public class DB2ForeignKeyConfigurator
implements DBEObjectConfigurator<DB2TableForeignKey> {
    private static final DBSForeignKeyModifyRule[] FK_RULES;

    static {
        ArrayList<DBSForeignKeyModifyRule> rules = new ArrayList<DBSForeignKeyModifyRule>(DB2DeleteUpdateRule.values().length);
        DB2DeleteUpdateRule[] dB2DeleteUpdateRuleArray = DB2DeleteUpdateRule.values();
        int n = dB2DeleteUpdateRuleArray.length;
        int n2 = 0;
        while (n2 < n) {
            DB2DeleteUpdateRule db2DeleteUpdateRule = dB2DeleteUpdateRuleArray[n2];
            rules.add(db2DeleteUpdateRule.getRule());
            ++n2;
        }
        FK_RULES = rules.toArray(new DBSForeignKeyModifyRule[0]);
    }

    public DB2TableForeignKey configureObject(@NotNull DBRProgressMonitor monitor, @Nullable DBECommandContext commandContext, @Nullable Object container, @NotNull DB2TableForeignKey foreignKey, @NotNull Map<String, Object> options) {
        return (DB2TableForeignKey)UITask.run(() -> {
            EditForeignKeyPage editDialog = new EditForeignKeyPage(DB2Messages.edit_db2_foreign_key_manager_dialog_title, (DBSEntityAssociation)foreignKey, FK_RULES, options);
            if (!editDialog.edit()) {
                return null;
            }
            DBSForeignKeyModifyRule deleteRule = editDialog.getOnDeleteRule();
            DBSForeignKeyModifyRule updateRule = editDialog.getOnUpdateRule();
            DB2TableUniqueKey ukConstraint = (DB2TableUniqueKey)editDialog.getUniqueConstraint();
            foreignKey.setReferencedConstraint(ukConstraint);
            foreignKey.setDb2DeleteRule(DB2DeleteUpdateRule.getDB2RuleFromDBSRule((DBSForeignKeyModifyRule)deleteRule));
            foreignKey.setDb2UpdateRule(DB2DeleteUpdateRule.getDB2RuleFromDBSRule((DBSForeignKeyModifyRule)updateRule));
            ArrayList<DB2TableForeignKeyColumn> columns = new ArrayList<DB2TableForeignKeyColumn>(editDialog.getColumns().size());
            int colIndex = 1;
            for (EditForeignKeyPage.FKColumnInfo tableColumn : editDialog.getColumns()) {
                DB2TableForeignKeyColumn column = new DB2TableForeignKeyColumn((AbstractTableConstraint)foreignKey, (DB2TableColumn)tableColumn.getOrCreateOwnColumn(monitor, commandContext, (DBSEntity)foreignKey.getTable()), Integer.valueOf(colIndex++));
                columns.add(column);
            }
            foreignKey.setAttributeReferences(columns);
            SQLForeignKeyManager.updateForeignKeyName((DBRProgressMonitor)monitor, (AbstractTableConstraint)foreignKey);
            return foreignKey;
        });
    }
}

