/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.cubrid.model.CubridDataSource;
import org.jkiss.dbeaver.ext.cubrid.model.CubridProcedure;
import org.jkiss.dbeaver.ext.cubrid.model.CubridUser;
import org.jkiss.dbeaver.ext.generic.edit.GenericProcedureManager;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;

public class CubridProcedureManager
extends GenericProcedureManager {
    public boolean canCreateObject(@NotNull Object container) {
        CubridUser user = (CubridUser)((Object)container);
        CubridDataSource dataSource = (CubridDataSource)user.getDataSource();
        return dataSource.isShard();
    }

    public boolean canEditObject(GenericProcedure object) {
        return !((CubridDataSource)object.getDataSource()).isShard();
    }

    public boolean canDeleteObject(GenericProcedure object) {
        return !((CubridDataSource)object.getDataSource()).isShard();
    }

    protected GenericProcedure createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object from, Map<String, Object> options) {
        String type = options.get("container").toString();
        DBSProcedureType procedureType = type.equals("Functions") ? DBSProcedureType.FUNCTION : DBSProcedureType.PROCEDURE;
        return new CubridProcedure((GenericStructContainer)container, procedureType);
    }

    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) throws DBCException {
        CubridProcedure procedure = (CubridProcedure)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create Procedure", procedure.getSource()));
    }

    protected void addObjectModifyActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actionList, @NotNull SQLObjectEditor.ObjectChangeCommand objectChangeCommand, @NotNull Map<String, Object> options) {
        CubridProcedure procedure = (CubridProcedure)objectChangeCommand.getObject();
        actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Modify Procedure", procedure.getSource()));
    }
}

