"use strict";
/*
 * ATTENTION: The "eval" devtool has been used (maybe by default in mode: "development").
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
(self["webpackChunk_JUPYTERLAB_CORE_OUTPUT"] = self["webpackChunk_JUPYTERLAB_CORE_OUTPUT"] || []).push([["vendors-node_modules_jupyterlab_debugger_lib_index_js"],{

/***/ "../node_modules/@jupyterlab/debugger/lib/config.js":
/*!**********************************************************!*\
  !*** ../node_modules/@jupyterlab/debugger/lib/config.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   DebuggerConfig: () => (/* binding */ DebuggerConfig)\n/* harmony export */ });\n/* harmony import */ var _hash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./hash */ \"../node_modules/@jupyterlab/debugger/lib/hash.js\");\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n/**\n * A class that holds debugger configuration for all kernels.\n */\nclass DebuggerConfig {\n    constructor() {\n        this._fileParams = new Map();\n        this._hashMethods = new Map();\n    }\n    /**\n     * Returns an id based on the given code.\n     *\n     * @param code The source code.\n     * @param kernel The kernel name from current session.\n     */\n    getCodeId(code, kernel) {\n        const fileParams = this._fileParams.get(kernel);\n        if (!fileParams) {\n            throw new Error(`Kernel (${kernel}) has no tmp file params.`);\n        }\n        const hash = this._hashMethods.get(kernel);\n        if (!hash) {\n            throw new Error(`Kernel (${kernel}) has no hashing params.`);\n        }\n        const { prefix, suffix } = fileParams;\n        return `${prefix}${hash(code)}${suffix}`;\n    }\n    /**\n     * Sets the hash parameters for a kernel.\n     *\n     * @param params - Hashing parameters for a kernel.\n     */\n    setHashParams(params) {\n        const { kernel, method, seed } = params;\n        if (!kernel) {\n            throw new TypeError(`Kernel name is not defined.`);\n        }\n        switch (method) {\n            case 'Murmur2':\n                this._hashMethods.set(kernel, code => (0,_hash__WEBPACK_IMPORTED_MODULE_0__.murmur2)(code, seed).toString());\n                break;\n            default:\n                throw new Error(`Hash method (${method}) is not supported.`);\n        }\n    }\n    /**\n     * Sets the parameters used by the kernel to create temp files (e.g. cells).\n     *\n     * @param params - Temporary file prefix and suffix for a kernel.\n     */\n    setTmpFileParams(params) {\n        const { kernel, prefix, suffix } = params;\n        if (!kernel) {\n            throw new TypeError(`Kernel name is not defined.`);\n        }\n        this._fileParams.set(kernel, { kernel, prefix, suffix });\n    }\n    /**\n     * Gets the parameters used for the temp files (e.e. cells) for a kernel.\n     *\n     * @param kernel - The kernel name from current session.\n     */\n    getTmpFileParams(kernel) {\n        return this._fileParams.get(kernel);\n    }\n}\n//# sourceMappingURL=config.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/debugger/lib/config.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/debugger/lib/debugger.js":
/*!************************************************************!*\
  !*** ../node_modules/@jupyterlab/debugger/lib/debugger.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Debugger: () => (/* binding */ Debugger)\n/* harmony export */ });\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/ui-components */ \"webpack/sharing/consume/default/@jupyterlab/ui-components/@jupyterlab/ui-components\");\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./config */ \"../node_modules/@jupyterlab/debugger/lib/config.js\");\n/* harmony import */ var _dialogs_evaluate__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./dialogs/evaluate */ \"../node_modules/@jupyterlab/debugger/lib/dialogs/evaluate.js\");\n/* harmony import */ var _factory__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./factory */ \"../node_modules/@jupyterlab/debugger/lib/factory.js\");\n/* harmony import */ var _handler__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./handler */ \"../node_modules/@jupyterlab/debugger/lib/handler.js\");\n/* harmony import */ var _handlers_editor__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./handlers/editor */ \"../node_modules/@jupyterlab/debugger/lib/handlers/editor.js\");\n/* harmony import */ var _model__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./model */ \"../node_modules/@jupyterlab/debugger/lib/model.js\");\n/* harmony import */ var _panels_variables_grid__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./panels/variables/grid */ \"../node_modules/@jupyterlab/debugger/lib/panels/variables/grid.js\");\n/* harmony import */ var _panels_variables_mimerenderer__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./panels/variables/mimerenderer */ \"../node_modules/@jupyterlab/debugger/lib/panels/variables/mimerenderer.js\");\n/* harmony import */ var _service__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./service */ \"../node_modules/@jupyterlab/debugger/lib/service.js\");\n/* harmony import */ var _session__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./session */ \"../node_modules/@jupyterlab/debugger/lib/session.js\");\n/* harmony import */ var _sidebar__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./sidebar */ \"../node_modules/@jupyterlab/debugger/lib/sidebar.js\");\n/* harmony import */ var _sources__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./sources */ \"../node_modules/@jupyterlab/debugger/lib/sources.js\");\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\n\n\n\n\n\n\n\n\n\n\n\n/**\n * A namespace for `Debugger` statics.\n */\nvar Debugger;\n(function (Debugger) {\n    /**\n     * Debugger configuration for all kernels.\n     */\n    class Config extends _config__WEBPACK_IMPORTED_MODULE_1__.DebuggerConfig {\n    }\n    Debugger.Config = Config;\n    /**\n     * A handler for a CodeEditor.IEditor.\n     */\n    class EditorHandler extends _handlers_editor__WEBPACK_IMPORTED_MODULE_2__.EditorHandler {\n    }\n    Debugger.EditorHandler = EditorHandler;\n    /**\n     * A handler for debugging a widget.\n     */\n    class Handler extends _handler__WEBPACK_IMPORTED_MODULE_3__.DebuggerHandler {\n    }\n    Debugger.Handler = Handler;\n    /**\n     * A model for a debugger.\n     */\n    class Model extends _model__WEBPACK_IMPORTED_MODULE_4__.DebuggerModel {\n    }\n    Debugger.Model = Model;\n    /**\n     * A widget factory for read only editors.\n     */\n    class ReadOnlyEditorFactory extends _factory__WEBPACK_IMPORTED_MODULE_5__.ReadOnlyEditorFactory {\n    }\n    Debugger.ReadOnlyEditorFactory = ReadOnlyEditorFactory;\n    /**\n     * The main IDebugger implementation.\n     */\n    class Service extends _service__WEBPACK_IMPORTED_MODULE_6__.DebuggerService {\n    }\n    Debugger.Service = Service;\n    /**\n     * A concrete implementation of IDebugger.ISession.\n     */\n    class Session extends _session__WEBPACK_IMPORTED_MODULE_7__.DebuggerSession {\n    }\n    Debugger.Session = Session;\n    /**\n     * The debugger sidebar UI.\n     */\n    class Sidebar extends _sidebar__WEBPACK_IMPORTED_MODULE_8__.DebuggerSidebar {\n    }\n    Debugger.Sidebar = Sidebar;\n    /**\n     * The source and editor manager for a debugger instance.\n     */\n    class Sources extends _sources__WEBPACK_IMPORTED_MODULE_9__.DebuggerSources {\n    }\n    Debugger.Sources = Sources;\n    /**\n     * A data grid that displays variables in a debugger session.\n     */\n    class VariablesGrid extends _panels_variables_grid__WEBPACK_IMPORTED_MODULE_10__.VariablesBodyGrid {\n    }\n    Debugger.VariablesGrid = VariablesGrid;\n    /**\n     * A widget to display data according to its mime type\n     */\n    class VariableRenderer extends _panels_variables_mimerenderer__WEBPACK_IMPORTED_MODULE_11__.VariableMimeRenderer {\n    }\n    Debugger.VariableRenderer = VariableRenderer;\n    /**\n     * The command IDs used by the debugger plugin.\n     */\n    let CommandIDs;\n    (function (CommandIDs) {\n        CommandIDs.debugContinue = 'debugger:continue';\n        CommandIDs.terminate = 'debugger:terminate';\n        CommandIDs.next = 'debugger:next';\n        CommandIDs.showPanel = 'debugger:show-panel';\n        CommandIDs.stepIn = 'debugger:stepIn';\n        CommandIDs.stepOut = 'debugger:stepOut';\n        CommandIDs.inspectVariable = 'debugger:inspect-variable';\n        CommandIDs.renderMimeVariable = 'debugger:render-mime-variable';\n        CommandIDs.evaluate = 'debugger:evaluate';\n        CommandIDs.restartDebug = 'debugger:restart-debug';\n        CommandIDs.pauseOnExceptions = 'debugger:pause-on-exceptions';\n        CommandIDs.copyToClipboard = 'debugger:copy-to-clipboard';\n        CommandIDs.copyToGlobals = 'debugger:copy-to-globals';\n        CommandIDs.openSource = 'debugger:open-source';\n    })(CommandIDs = Debugger.CommandIDs || (Debugger.CommandIDs = {}));\n    /**\n     * The debugger user interface icons.\n     */\n    let Icons;\n    (function (Icons) {\n        Icons.closeAllIcon = _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.closeAllIcon;\n        Icons.evaluateIcon = _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.codeIcon;\n        Icons.continueIcon = _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.runIcon;\n        Icons.pauseIcon = _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.pauseIcon;\n        Icons.stepIntoIcon = _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.stepIntoIcon;\n        Icons.stepOutIcon = _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.stepOutIcon;\n        Icons.stepOverIcon = _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.stepOverIcon;\n        Icons.terminateIcon = _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.stopIcon;\n        Icons.variableIcon = _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.variableIcon;\n        Icons.viewBreakpointIcon = _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.viewBreakpointIcon;\n        Icons.pauseOnExceptionsIcon = _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.pauseIcon;\n    })(Icons = Debugger.Icons || (Debugger.Icons = {}));\n    /**\n     * The debugger dialog helpers.\n     */\n    let Dialogs;\n    (function (Dialogs) {\n        /**\n         * Open a code prompt in a dialog.\n         */\n        Dialogs.getCode = _dialogs_evaluate__WEBPACK_IMPORTED_MODULE_12__.DebuggerEvaluateDialog.getCode;\n    })(Dialogs = Debugger.Dialogs || (Debugger.Dialogs = {}));\n})(Debugger || (Debugger = {}));\n//# sourceMappingURL=debugger.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/debugger/lib/debugger.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/debugger/lib/dialogs/evaluate.js":
/*!********************************************************************!*\
  !*** ../node_modules/@jupyterlab/debugger/lib/dialogs/evaluate.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   DebuggerEvaluateDialog: () => (/* binding */ DebuggerEvaluateDialog)\n/* harmony export */ });\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/apputils */ \"webpack/sharing/consume/default/@jupyterlab/apputils/@jupyterlab/apputils\");\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _jupyterlab_cells__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/cells */ \"webpack/sharing/consume/default/@jupyterlab/cells/@jupyterlab/cells\");\n/* harmony import */ var _jupyterlab_cells__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_cells__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @lumino/widgets */ \"webpack/sharing/consume/default/@lumino/widgets/@lumino/widgets\");\n/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_lumino_widgets__WEBPACK_IMPORTED_MODULE_2__);\n/*\n * Copyright (c) Jupyter Development Team.\n * Distributed under the terms of the Modified BSD License.\n */\n\n\n\n/**\n * A namespace for DebuggerEvaluateDialog statics.\n */\nvar DebuggerEvaluateDialog;\n(function (DebuggerEvaluateDialog) {\n    /**\n     * Create and show a dialog to prompt user for code.\n     *\n     * @param options - The dialog setup options.\n     *\n     * @returns A promise that resolves with whether the dialog was accepted\n     */\n    function getCode(options) {\n        const dialog = new EvaluateDialog({\n            ...options,\n            body: new EvaluateDialogBody(options),\n            buttons: [\n                _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.Dialog.cancelButton({ label: options.cancelLabel }),\n                _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.Dialog.okButton({ label: options.okLabel })\n            ]\n        });\n        return dialog.launch();\n    }\n    DebuggerEvaluateDialog.getCode = getCode;\n})(DebuggerEvaluateDialog || (DebuggerEvaluateDialog = {}));\n/**\n * A dialog to prompt users for code to evaluate.\n */\nclass EvaluateDialog extends _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.Dialog {\n    /**\n     * Handle the DOM events for the Evaluate dialog.\n     *\n     * @param event The DOM event sent to the dialog widget\n     */\n    handleEvent(event) {\n        if (event.type === 'keydown') {\n            const keyboardEvent = event;\n            const { code, shiftKey } = keyboardEvent;\n            if (shiftKey && code === 'Enter') {\n                return this.resolve();\n            }\n            if (code === 'Enter') {\n                return;\n            }\n        }\n        super.handleEvent(event);\n    }\n}\n/**\n * Widget body with a code cell prompt in a dialog\n */\nclass EvaluateDialogBody extends _lumino_widgets__WEBPACK_IMPORTED_MODULE_2__.Widget {\n    /**\n     * CodePromptDialog constructor\n     *\n     * @param options Constructor options\n     */\n    constructor(options) {\n        super();\n        const { contentFactory, rendermime, mimeType } = options;\n        const model = new _jupyterlab_cells__WEBPACK_IMPORTED_MODULE_1__.CodeCellModel();\n        model.mimeType = mimeType !== null && mimeType !== void 0 ? mimeType : '';\n        this._prompt = new _jupyterlab_cells__WEBPACK_IMPORTED_MODULE_1__.CodeCell({\n            contentFactory,\n            rendermime,\n            model,\n            placeholder: false\n        }).initializeState();\n        // explicitly remove the prompt in front of the input area\n        this._prompt.inputArea.promptNode.remove();\n        this.node.appendChild(this._prompt.node);\n    }\n    /**\n     * Get the text specified by the user\n     */\n    getValue() {\n        return this._prompt.model.sharedModel.getSource();\n    }\n    /**\n     *  A message handler invoked on an `'after-attach'` message.\n     */\n    onAfterAttach(msg) {\n        super.onAfterAttach(msg);\n        this._prompt.activate();\n    }\n}\n//# sourceMappingURL=evaluate.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/debugger/lib/dialogs/evaluate.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/debugger/lib/factory.js":
/*!***********************************************************!*\
  !*** ../node_modules/@jupyterlab/debugger/lib/factory.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ReadOnlyEditorFactory: () => (/* binding */ ReadOnlyEditorFactory)\n/* harmony export */ });\n/* harmony import */ var _jupyterlab_codeeditor__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/codeeditor */ \"webpack/sharing/consume/default/@jupyterlab/codeeditor/@jupyterlab/codeeditor\");\n/* harmony import */ var _jupyterlab_codeeditor__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_codeeditor__WEBPACK_IMPORTED_MODULE_0__);\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n/**\n * A widget factory for read only editors.\n */\nclass ReadOnlyEditorFactory {\n    /**\n     * Construct a new editor widget factory.\n     *\n     * @param options The instantiation options for a ReadOnlyEditorFactory.\n     */\n    constructor(options) {\n        this._services = options.editorServices;\n    }\n    /**\n     * Create a new CodeEditorWrapper given a Source.\n     *\n     * @param source The source to create a new editor for.\n     */\n    createNewEditor(source) {\n        const { content, mimeType, path } = source;\n        const factory = this._services.factoryService.newInlineEditor;\n        const mimeTypeService = this._services.mimeTypeService;\n        const model = new _jupyterlab_codeeditor__WEBPACK_IMPORTED_MODULE_0__.CodeEditor.Model({\n            mimeType: mimeType || mimeTypeService.getMimeTypeByFilePath(path)\n        });\n        model.sharedModel.source = content;\n        const editor = new _jupyterlab_codeeditor__WEBPACK_IMPORTED_MODULE_0__.CodeEditorWrapper({\n            editorOptions: {\n                config: {\n                    readOnly: true,\n                    lineNumbers: true\n                }\n            },\n            model,\n            factory\n        });\n        editor.node.setAttribute('data-jp-debugger', 'true');\n        editor.disposed.connect(() => {\n            model.dispose();\n        });\n        return editor;\n    }\n}\n//# sourceMappingURL=factory.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/debugger/lib/factory.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/debugger/lib/handler.js":
/*!***********************************************************!*\
  !*** ../node_modules/@jupyterlab/debugger/lib/handler.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   DebuggerHandler: () => (/* binding */ DebuggerHandler)\n/* harmony export */ });\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/translation */ \"webpack/sharing/consume/default/@jupyterlab/translation/@jupyterlab/translation\");\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/ui-components */ \"webpack/sharing/consume/default/@jupyterlab/ui-components/@jupyterlab/ui-components\");\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _debugger__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./debugger */ \"../node_modules/@jupyterlab/debugger/lib/debugger.js\");\n/* harmony import */ var _handlers_console__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./handlers/console */ \"../node_modules/@jupyterlab/debugger/lib/handlers/console.js\");\n/* harmony import */ var _handlers_file__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./handlers/file */ \"../node_modules/@jupyterlab/debugger/lib/handlers/file.js\");\n/* harmony import */ var _handlers_notebook__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./handlers/notebook */ \"../node_modules/@jupyterlab/debugger/lib/handlers/notebook.js\");\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\n\n\n\n\nconst TOOLBAR_DEBUGGER_ITEM = 'debugger-icon';\n/**\n * Add a bug icon to the widget toolbar to enable and disable debugging.\n *\n * @param widget The widget to add the debug toolbar button to.\n * @param onClick The callback when the toolbar button is clicked.\n */\nfunction updateIconButton(widget, onClick, enabled, pressed, translator = _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__.nullTranslator) {\n    const trans = translator.load('jupyterlab');\n    const icon = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.ToolbarButton({\n        className: 'jp-DebuggerBugButton',\n        icon: _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.bugIcon,\n        tooltip: trans.__('Enable Debugger'),\n        pressedIcon: _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.bugDotIcon,\n        pressedTooltip: trans.__('Disable Debugger'),\n        disabledTooltip: trans.__('Select a kernel that supports debugging to enable debugger'),\n        enabled,\n        pressed,\n        onClick\n    });\n    if (!widget.toolbar.insertBefore('kernelName', TOOLBAR_DEBUGGER_ITEM, icon)) {\n        widget.toolbar.addItem(TOOLBAR_DEBUGGER_ITEM, icon);\n    }\n    return icon;\n}\n/**\n * Updates button state to on/off,\n * adds/removes css class to update styling\n *\n * @param widget the debug button widget\n * @param pressed true if pressed, false otherwise\n * @param enabled true if widget enabled, false otherwise\n * @param onClick click handler\n */\nfunction updateIconButtonState(widget, pressed, enabled = true, onClick) {\n    if (widget) {\n        widget.enabled = enabled;\n        widget.pressed = pressed;\n        if (onClick) {\n            widget.onClick = onClick;\n        }\n    }\n}\n/**\n * A handler for debugging a widget.\n */\nclass DebuggerHandler {\n    /**\n     * Instantiate a new DebuggerHandler.\n     *\n     * @param options The instantiation options for a DebuggerHandler.\n     */\n    constructor(options) {\n        this._handlers = {};\n        this._contextKernelChangedHandlers = {};\n        this._kernelChangedHandlers = {};\n        this._statusChangedHandlers = {};\n        this._iopubMessageHandlers = {};\n        this._iconButtons = {};\n        this._type = options.type;\n        this._shell = options.shell;\n        this._service = options.service;\n    }\n    /**\n     * Get the active widget.\n     */\n    get activeWidget() {\n        return this._activeWidget;\n    }\n    /**\n     * Update a debug handler for the given widget, and\n     * handle kernel changed events.\n     *\n     * @param widget The widget to update.\n     * @param connection The session connection.\n     */\n    async update(widget, connection) {\n        if (!connection) {\n            delete this._kernelChangedHandlers[widget.id];\n            delete this._statusChangedHandlers[widget.id];\n            delete this._iopubMessageHandlers[widget.id];\n            return this.updateWidget(widget, connection);\n        }\n        const kernelChanged = () => {\n            void this.updateWidget(widget, connection);\n        };\n        const kernelChangedHandler = this._kernelChangedHandlers[widget.id];\n        if (kernelChangedHandler) {\n            connection.kernelChanged.disconnect(kernelChangedHandler);\n        }\n        this._kernelChangedHandlers[widget.id] = kernelChanged;\n        connection.kernelChanged.connect(kernelChanged);\n        const statusChanged = (_, status) => {\n            if (status.endsWith('restarting')) {\n                void this.updateWidget(widget, connection);\n            }\n        };\n        const statusChangedHandler = this._statusChangedHandlers[widget.id];\n        if (statusChangedHandler) {\n            connection.statusChanged.disconnect(statusChangedHandler);\n        }\n        connection.statusChanged.connect(statusChanged);\n        this._statusChangedHandlers[widget.id] = statusChanged;\n        const iopubMessage = (_, msg) => {\n            if (this._service.isStarted &&\n                !this._service.hasStoppedThreads() &&\n                msg.parent_header.msg_type ===\n                    'execute_request') {\n                void this._service.displayDefinedVariables();\n            }\n        };\n        const iopubMessageHandler = this._iopubMessageHandlers[widget.id];\n        if (iopubMessageHandler) {\n            connection.iopubMessage.disconnect(iopubMessageHandler);\n        }\n        connection.iopubMessage.connect(iopubMessage);\n        this._iopubMessageHandlers[widget.id] = iopubMessage;\n        this._activeWidget = widget;\n        return this.updateWidget(widget, connection);\n    }\n    /**\n     * Update a debug handler for the given widget, and\n     * handle connection kernel changed events.\n     *\n     * @param widget The widget to update.\n     * @param sessionContext The session context.\n     */\n    async updateContext(widget, sessionContext) {\n        const connectionChanged = () => {\n            const { session: connection } = sessionContext;\n            void this.update(widget, connection);\n        };\n        const contextKernelChangedHandlers = this._contextKernelChangedHandlers[widget.id];\n        if (contextKernelChangedHandlers) {\n            sessionContext.kernelChanged.disconnect(contextKernelChangedHandlers);\n        }\n        this._contextKernelChangedHandlers[widget.id] = connectionChanged;\n        sessionContext.kernelChanged.connect(connectionChanged);\n        return this.update(widget, sessionContext.session);\n    }\n    /**\n     * Update a debug handler for the given widget.\n     *\n     * @param widget The widget to update.\n     * @param connection The session connection.\n     */\n    async updateWidget(widget, connection) {\n        var _a, _b, _c, _d;\n        if (!this._service.model || !connection) {\n            return;\n        }\n        const hasFocus = () => {\n            return this._shell.currentWidget === widget;\n        };\n        const updateAttribute = () => {\n            if (!this._handlers[widget.id]) {\n                widget.node.removeAttribute('data-jp-debugger');\n                return;\n            }\n            widget.node.setAttribute('data-jp-debugger', 'true');\n        };\n        const createHandler = () => {\n            if (this._handlers[widget.id]) {\n                return;\n            }\n            switch (this._type) {\n                case 'notebook':\n                    this._handlers[widget.id] = new _handlers_notebook__WEBPACK_IMPORTED_MODULE_2__.NotebookHandler({\n                        debuggerService: this._service,\n                        widget: widget\n                    });\n                    break;\n                case 'console':\n                    this._handlers[widget.id] = new _handlers_console__WEBPACK_IMPORTED_MODULE_3__.ConsoleHandler({\n                        debuggerService: this._service,\n                        widget: widget\n                    });\n                    break;\n                case 'file':\n                    this._handlers[widget.id] = new _handlers_file__WEBPACK_IMPORTED_MODULE_4__.FileHandler({\n                        debuggerService: this._service,\n                        widget: widget\n                    });\n                    break;\n                default:\n                    throw Error(`No handler for the type ${this._type}`);\n            }\n            updateAttribute();\n        };\n        const removeHandlers = () => {\n            var _a, _b, _c, _d;\n            const handler = this._handlers[widget.id];\n            if (!handler) {\n                return;\n            }\n            handler.dispose();\n            delete this._handlers[widget.id];\n            delete this._kernelChangedHandlers[widget.id];\n            delete this._statusChangedHandlers[widget.id];\n            delete this._iopubMessageHandlers[widget.id];\n            delete this._contextKernelChangedHandlers[widget.id];\n            // Clear the model if the handler being removed corresponds\n            // to the current active debug session, or if the connection\n            // does not have a kernel.\n            if (((_b = (_a = this._service.session) === null || _a === void 0 ? void 0 : _a.connection) === null || _b === void 0 ? void 0 : _b.path) === (connection === null || connection === void 0 ? void 0 : connection.path) ||\n                !((_d = (_c = this._service.session) === null || _c === void 0 ? void 0 : _c.connection) === null || _d === void 0 ? void 0 : _d.kernel)) {\n                const model = this._service.model;\n                model.clear();\n            }\n            updateAttribute();\n        };\n        const addToolbarButton = (enabled = true) => {\n            const debugButton = this._iconButtons[widget.id];\n            if (!debugButton) {\n                this._iconButtons[widget.id] = updateIconButton(widget, toggleDebugging, this._service.isStarted, enabled);\n            }\n            else {\n                updateIconButtonState(debugButton, this._service.isStarted, enabled, toggleDebugging);\n            }\n        };\n        const isDebuggerOn = () => {\n            var _a;\n            return (this._service.isStarted &&\n                ((_a = this._previousConnection) === null || _a === void 0 ? void 0 : _a.id) === (connection === null || connection === void 0 ? void 0 : connection.id));\n        };\n        const stopDebugger = async () => {\n            this._service.session.connection = connection;\n            await this._service.stop();\n        };\n        const startDebugger = async () => {\n            var _a, _b;\n            this._service.session.connection = connection;\n            this._previousConnection = connection;\n            await this._service.restoreState(true);\n            await this._service.displayDefinedVariables();\n            if ((_b = (_a = this._service.session) === null || _a === void 0 ? void 0 : _a.capabilities) === null || _b === void 0 ? void 0 : _b.supportsModulesRequest) {\n                await this._service.displayModules();\n            }\n        };\n        const toggleDebugging = async () => {\n            // bail if the widget doesn't have focus\n            if (!hasFocus()) {\n                return;\n            }\n            const debugButton = this._iconButtons[widget.id];\n            if (isDebuggerOn()) {\n                await stopDebugger();\n                removeHandlers();\n                updateIconButtonState(debugButton, false);\n            }\n            else {\n                await startDebugger();\n                createHandler();\n                updateIconButtonState(debugButton, true);\n            }\n        };\n        addToolbarButton(false);\n        // listen to the disposed signals\n        widget.disposed.connect(async () => {\n            if (isDebuggerOn()) {\n                await stopDebugger();\n            }\n            removeHandlers();\n            delete this._iconButtons[widget.id];\n            delete this._contextKernelChangedHandlers[widget.id];\n        });\n        const debuggingEnabled = await this._service.isAvailable(connection);\n        if (!debuggingEnabled) {\n            removeHandlers();\n            updateIconButtonState(this._iconButtons[widget.id], false, false);\n            return;\n        }\n        // update the active debug session\n        if (!this._service.session) {\n            this._service.session = new _debugger__WEBPACK_IMPORTED_MODULE_5__.Debugger.Session({\n                connection,\n                config: this._service.config\n            });\n        }\n        else {\n            this._previousConnection = ((_a = this._service.session.connection) === null || _a === void 0 ? void 0 : _a.kernel)\n                ? this._service.session.connection\n                : null;\n            this._service.session.connection = connection;\n        }\n        await this._service.restoreState(false);\n        if (this._service.isStarted && !this._service.hasStoppedThreads()) {\n            await this._service.displayDefinedVariables();\n            if ((_c = (_b = this._service.session) === null || _b === void 0 ? void 0 : _b.capabilities) === null || _c === void 0 ? void 0 : _c.supportsModulesRequest) {\n                await this._service.displayModules();\n            }\n        }\n        updateIconButtonState(this._iconButtons[widget.id], this._service.isStarted, true);\n        // check the state of the debug session\n        if (!this._service.isStarted) {\n            removeHandlers();\n            this._service.session.connection = (_d = this._previousConnection) !== null && _d !== void 0 ? _d : connection;\n            await this._service.restoreState(false);\n            return;\n        }\n        // if the debugger is started but there is no handler, create a new one\n        createHandler();\n        this._previousConnection = connection;\n    }\n}\n//# sourceMappingURL=handler.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/debugger/lib/handler.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/debugger/lib/handlers/console.js":
/*!********************************************************************!*\
  !*** ../node_modules/@jupyterlab/debugger/lib/handlers/console.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ConsoleHandler: () => (/* binding */ ConsoleHandler)\n/* harmony export */ });\n/* harmony import */ var _jupyterlab_observables__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/observables */ \"webpack/sharing/consume/default/@jupyterlab/observables/@jupyterlab/observables\");\n/* harmony import */ var _jupyterlab_observables__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_observables__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/signaling */ \"webpack/sharing/consume/default/@lumino/signaling/@lumino/signaling\");\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_signaling__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _handlers_editor__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../handlers/editor */ \"../node_modules/@jupyterlab/debugger/lib/handlers/editor.js\");\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\n\n/**\n * A handler for consoles.\n */\nclass ConsoleHandler {\n    /**\n     * Instantiate a new ConsoleHandler.\n     *\n     * @param options The instantiation options for a ConsoleHandler.\n     */\n    constructor(options) {\n        this._debuggerService = options.debuggerService;\n        this._consolePanel = options.widget;\n        this._cellMap = new _jupyterlab_observables__WEBPACK_IMPORTED_MODULE_0__.ObservableMap();\n        const codeConsole = this._consolePanel.console;\n        if (codeConsole.promptCell) {\n            this._addEditorHandler(codeConsole.promptCell);\n        }\n        codeConsole.promptCellCreated.connect((_, cell) => {\n            this._addEditorHandler(cell);\n        });\n        const addHandlers = () => {\n            for (const cell of codeConsole.cells) {\n                this._addEditorHandler(cell);\n            }\n        };\n        addHandlers();\n        this._consolePanel.console.cells.changed.connect(addHandlers);\n    }\n    /**\n     * Dispose the handler.\n     */\n    dispose() {\n        if (this.isDisposed) {\n            return;\n        }\n        this.isDisposed = true;\n        this._cellMap.values().forEach(handler => handler.dispose());\n        this._cellMap.dispose();\n        _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__.Signal.clearData(this);\n    }\n    /**\n     * Add a new editor handler for the given cell.\n     *\n     * @param cell The cell to add the handler to.\n     */\n    _addEditorHandler(cell) {\n        const modelId = cell.model.id;\n        if (cell.model.type !== 'code' || this._cellMap.has(modelId)) {\n            return;\n        }\n        const codeCell = cell;\n        const editorHandler = new _handlers_editor__WEBPACK_IMPORTED_MODULE_2__.EditorHandler({\n            debuggerService: this._debuggerService,\n            editorReady: async () => {\n                await codeCell.ready;\n                return codeCell.editor;\n            },\n            getEditor: () => codeCell.editor,\n            src: cell.model.sharedModel\n        });\n        codeCell.disposed.connect(() => {\n            this._cellMap.delete(modelId);\n            editorHandler.dispose();\n        });\n        this._cellMap.set(modelId, editorHandler);\n    }\n}\n//# sourceMappingURL=console.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/debugger/lib/handlers/console.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/debugger/lib/handlers/editor.js":
/*!*******************************************************************!*\
  !*** ../node_modules/@jupyterlab/debugger/lib/handlers/editor.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   EditorHandler: () => (/* binding */ EditorHandler)\n/* harmony export */ });\n/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/coreutils */ \"webpack/sharing/consume/default/@jupyterlab/coreutils/@jupyterlab/coreutils\");\n/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/signaling */ \"webpack/sharing/consume/default/@lumino/signaling/@lumino/signaling\");\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_signaling__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _codemirror_state__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @codemirror/state */ \"../node_modules/@codemirror/state/dist/index.js\");\n/* harmony import */ var _codemirror_view__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @codemirror/view */ \"webpack/sharing/consume/default/@codemirror/view/@codemirror/view\");\n/* harmony import */ var _codemirror_view__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_codemirror_view__WEBPACK_IMPORTED_MODULE_2__);\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\n\n\n/**\n * The class name added to the current line.\n */\nconst LINE_HIGHLIGHT_CLASS = 'jp-DebuggerEditor-highlight';\n/**\n * The timeout for listening to editor content changes.\n */\nconst EDITOR_CHANGED_TIMEOUT = 1000;\n/**\n * A handler for a CodeEditor.IEditor.\n */\nclass EditorHandler {\n    /**\n     * Instantiate a new EditorHandler.\n     *\n     * @param options The instantiation options for a EditorHandler.\n     */\n    constructor(options) {\n        var _a, _b, _c, _d;\n        this._src = options.src;\n        this._id = (_c = (_b = (_a = options.debuggerService.session) === null || _a === void 0 ? void 0 : _a.connection) === null || _b === void 0 ? void 0 : _b.id) !== null && _c !== void 0 ? _c : '';\n        this._path = (_d = options.path) !== null && _d !== void 0 ? _d : '';\n        this._debuggerService = options.debuggerService;\n        this._editor = options.getEditor;\n        this._editorMonitor = new _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.ActivityMonitor({\n            signal: this._src.changed,\n            timeout: EDITOR_CHANGED_TIMEOUT\n        });\n        this._editorMonitor.activityStopped.connect(() => {\n            this._sendEditorBreakpoints();\n        }, this);\n        this._debuggerService.model.breakpoints.changed.connect(async () => {\n            const editor = this.editor;\n            if (!editor || editor.isDisposed) {\n                return;\n            }\n            this._addBreakpointsToEditor();\n        });\n        this._debuggerService.model.breakpoints.restored.connect(async () => {\n            const editor = this.editor;\n            if (!editor || editor.isDisposed) {\n                return;\n            }\n            this._addBreakpointsToEditor();\n        });\n        this._debuggerService.model.callstack.currentFrameChanged.connect(() => {\n            const editor = this.editor;\n            if (editor) {\n                EditorHandler.clearHighlight(editor);\n            }\n        });\n        this._breakpointEffect = _codemirror_state__WEBPACK_IMPORTED_MODULE_3__.StateEffect.define({\n            map: (value, mapping) => ({ pos: value.pos.map(v => mapping.mapPos(v)) })\n        });\n        this._breakpointState = _codemirror_state__WEBPACK_IMPORTED_MODULE_3__.StateField.define({\n            create: () => {\n                return _codemirror_state__WEBPACK_IMPORTED_MODULE_3__.RangeSet.empty;\n            },\n            update: (breakpoints, transaction) => {\n                breakpoints = breakpoints.map(transaction.changes);\n                for (let ef of transaction.effects) {\n                    if (ef.is(this._breakpointEffect)) {\n                        let e = ef;\n                        if (e.value.pos.length) {\n                            breakpoints = breakpoints.update({\n                                add: e.value.pos.map(v => Private.breakpointMarker.range(v)),\n                                sort: true\n                            });\n                        }\n                        else {\n                            breakpoints = _codemirror_state__WEBPACK_IMPORTED_MODULE_3__.RangeSet.empty;\n                        }\n                    }\n                }\n                return breakpoints;\n            }\n        });\n        this._gutter = new _codemirror_state__WEBPACK_IMPORTED_MODULE_3__.Compartment();\n        this._highlightDeco = _codemirror_view__WEBPACK_IMPORTED_MODULE_2__.Decoration.line({ class: LINE_HIGHLIGHT_CLASS });\n        this._highlightState = _codemirror_state__WEBPACK_IMPORTED_MODULE_3__.StateField.define({\n            create: () => {\n                return _codemirror_view__WEBPACK_IMPORTED_MODULE_2__.Decoration.none;\n            },\n            update: (highlights, transaction) => {\n                highlights = highlights.map(transaction.changes);\n                for (let ef of transaction.effects) {\n                    if (ef.is(EditorHandler._highlightEffect)) {\n                        let e = ef;\n                        if (e.value.pos.length) {\n                            highlights = highlights.update({\n                                add: e.value.pos.map(v => this._highlightDeco.range(v))\n                            });\n                        }\n                        else {\n                            highlights = _codemirror_view__WEBPACK_IMPORTED_MODULE_2__.Decoration.none;\n                        }\n                    }\n                }\n                return highlights;\n            },\n            provide: f => _codemirror_view__WEBPACK_IMPORTED_MODULE_2__.EditorView.decorations.from(f)\n        });\n        void options.editorReady().then(() => {\n            this._setupEditor();\n        });\n    }\n    /**\n     * The editor\n     */\n    get editor() {\n        return this._editor();\n    }\n    /**\n     * Dispose the handler.\n     */\n    dispose() {\n        if (this.isDisposed) {\n            return;\n        }\n        this._editorMonitor.dispose();\n        this._clearEditor();\n        this.isDisposed = true;\n        _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__.Signal.clearData(this);\n    }\n    /**\n     * Refresh the breakpoints display\n     */\n    refreshBreakpoints() {\n        this._addBreakpointsToEditor();\n    }\n    /**\n     * Setup the editor.\n     */\n    _setupEditor() {\n        const editor = this.editor;\n        if (!editor || editor.isDisposed) {\n            return;\n        }\n        editor.setOption('lineNumbers', true);\n        const breakpointGutter = [\n            this._breakpointState,\n            this._highlightState,\n            _codemirror_state__WEBPACK_IMPORTED_MODULE_3__.Prec.highest((0,_codemirror_view__WEBPACK_IMPORTED_MODULE_2__.gutter)({\n                class: 'cm-breakpoint-gutter',\n                renderEmptyElements: true,\n                markers: v => v.state.field(this._breakpointState),\n                initialSpacer: () => Private.breakpointMarker,\n                domEventHandlers: {\n                    mousedown: (view, line) => {\n                        this._onGutterClick(view, line.from);\n                        return true;\n                    }\n                }\n            }))\n        ];\n        editor.injectExtension(this._gutter.of(breakpointGutter));\n        this._addBreakpointsToEditor();\n    }\n    /**\n     * Clear the editor by removing visual elements and handlers.\n     */\n    _clearEditor() {\n        const editor = this.editor;\n        if (!editor || editor.isDisposed) {\n            return;\n        }\n        EditorHandler.clearHighlight(editor);\n        this._clearGutter(editor);\n        editor.setOption('lineNumbers', false);\n        editor.editor.dispatch({\n            effects: this._gutter.reconfigure([])\n        });\n    }\n    /**\n     * Send the breakpoints from the editor UI via the debug service.\n     */\n    _sendEditorBreakpoints() {\n        var _a;\n        if ((_a = this.editor) === null || _a === void 0 ? void 0 : _a.isDisposed) {\n            return;\n        }\n        const breakpoints = this._getBreakpointsFromEditor().map(lineNumber => {\n            var _a, _b;\n            return Private.createBreakpoint(((_b = (_a = this._debuggerService.session) === null || _a === void 0 ? void 0 : _a.connection) === null || _b === void 0 ? void 0 : _b.name) || '', lineNumber);\n        });\n        void this._debuggerService.updateBreakpoints(this._src.getSource(), breakpoints, this._path);\n    }\n    /**\n     * Handle a click on the gutter.\n     *\n     * @param editor The editor from where the click originated.\n     * @param position The position corresponding to the click event.\n     */\n    _onGutterClick(editor, position) {\n        var _a, _b, _c;\n        if (this._id !== ((_b = (_a = this._debuggerService.session) === null || _a === void 0 ? void 0 : _a.connection) === null || _b === void 0 ? void 0 : _b.id)) {\n            return;\n        }\n        const lineNumber = editor.state.doc.lineAt(position).number;\n        let stateBreakpoints = editor.state.field(this._breakpointState);\n        let hasBreakpoint = false;\n        stateBreakpoints.between(position, position, () => {\n            hasBreakpoint = true;\n        });\n        let breakpoints = this._getBreakpoints();\n        if (hasBreakpoint) {\n            breakpoints = breakpoints.filter(ele => ele.line !== lineNumber);\n        }\n        else {\n            breakpoints.push(Private.createBreakpoint((_c = this._path) !== null && _c !== void 0 ? _c : this._debuggerService.session.connection.name, lineNumber));\n        }\n        breakpoints.sort((a, b) => {\n            return a.line - b.line;\n        });\n        void this._debuggerService.updateBreakpoints(this._src.getSource(), breakpoints, this._path);\n    }\n    /**\n     * Add the breakpoints to the editor.\n     */\n    _addBreakpointsToEditor() {\n        var _a, _b;\n        if (this._id !== ((_b = (_a = this._debuggerService.session) === null || _a === void 0 ? void 0 : _a.connection) === null || _b === void 0 ? void 0 : _b.id)) {\n            return;\n        }\n        const editor = this.editor;\n        const breakpoints = this._getBreakpoints();\n        this._clearGutter(editor);\n        const breakpointPos = breakpoints.map(b => {\n            return editor.state.doc.line(b.line).from;\n        });\n        editor.editor.dispatch({\n            effects: this._breakpointEffect.of({ pos: breakpointPos })\n        });\n    }\n    /**\n     * Retrieve the breakpoints from the editor.\n     */\n    _getBreakpointsFromEditor() {\n        const editor = this.editor;\n        const breakpoints = editor.editor.state.field(this._breakpointState);\n        let lines = [];\n        breakpoints.between(0, editor.doc.length, (from) => {\n            lines.push(editor.doc.lineAt(from).number);\n        });\n        return lines;\n    }\n    _clearGutter(editor) {\n        if (!editor) {\n            return;\n        }\n        const view = editor.editor;\n        view.dispatch({\n            effects: this._breakpointEffect.of({ pos: [] })\n        });\n    }\n    /**\n     * Get the breakpoints for the editor using its content (code),\n     * or its path (if it exists).\n     */\n    _getBreakpoints() {\n        const code = this._src.getSource();\n        return this._debuggerService.model.breakpoints.getBreakpoints(this._path || this._debuggerService.getCodeId(code));\n    }\n}\n/**\n * A namespace for EditorHandler `statics`.\n */\n(function (EditorHandler) {\n    EditorHandler._highlightEffect = _codemirror_state__WEBPACK_IMPORTED_MODULE_3__.StateEffect.define({\n        map: (value, mapping) => ({ pos: value.pos.map(v => mapping.mapPos(v)) })\n    });\n    /**\n     * Highlight the current line of the frame in the given editor.\n     *\n     * @param editor The editor to highlight.\n     * @param line The line number.\n     */\n    function showCurrentLine(editor, line) {\n        clearHighlight(editor);\n        const cmEditor = editor;\n        const linePos = cmEditor.doc.line(line).from;\n        cmEditor.editor.dispatch({\n            effects: EditorHandler._highlightEffect.of({ pos: [linePos] })\n        });\n    }\n    EditorHandler.showCurrentLine = showCurrentLine;\n    /**\n     * Remove all line highlighting indicators for the given editor.\n     *\n     * @param editor The editor to cleanup.\n     */\n    function clearHighlight(editor) {\n        if (!editor || editor.isDisposed) {\n            return;\n        }\n        const cmEditor = editor;\n        cmEditor.editor.dispatch({\n            effects: EditorHandler._highlightEffect.of({ pos: [] })\n        });\n    }\n    EditorHandler.clearHighlight = clearHighlight;\n})(EditorHandler || (EditorHandler = {}));\n/**\n * A namespace for module private data.\n */\nvar Private;\n(function (Private) {\n    /**\n     * Create a marker DOM element for a breakpoint.\n     */\n    Private.breakpointMarker = new (class extends _codemirror_view__WEBPACK_IMPORTED_MODULE_2__.GutterMarker {\n        toDOM() {\n            const marker = document.createTextNode('●');\n            return marker;\n        }\n    })();\n    /**\n     * Create a new breakpoint.\n     *\n     * @param session The name of the session.\n     * @param line The line number of the breakpoint.\n     */\n    function createBreakpoint(session, line) {\n        return {\n            line,\n            verified: true,\n            source: {\n                name: session\n            }\n        };\n    }\n    Private.createBreakpoint = createBreakpoint;\n})(Private || (Private = {}));\n//# sourceMappingURL=editor.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/debugger/lib/handlers/editor.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/debugger/lib/handlers/file.js":
/*!*****************************************************************!*\
  !*** ../node_modules/@jupyterlab/debugger/lib/handlers/file.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   FileHandler: () => (/* binding */ FileHandler)\n/* harmony export */ });\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/signaling */ \"webpack/sharing/consume/default/@lumino/signaling/@lumino/signaling\");\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_signaling__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _handlers_editor__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../handlers/editor */ \"../node_modules/@jupyterlab/debugger/lib/handlers/editor.js\");\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\n/**\n * A handler for files.\n */\nclass FileHandler {\n    /**\n     * Instantiate a new FileHandler.\n     *\n     * @param options The instantiation options for a FileHandler.\n     */\n    constructor(options) {\n        var _a;\n        this._debuggerService = options.debuggerService;\n        this._fileEditor = options.widget.content;\n        this._hasLineNumber =\n            (_a = this._fileEditor.editor.getOption('lineNumbers')) !== null && _a !== void 0 ? _a : false;\n        this._editorHandler = new _handlers_editor__WEBPACK_IMPORTED_MODULE_1__.EditorHandler({\n            debuggerService: this._debuggerService,\n            editorReady: () => Promise.resolve(this._fileEditor.editor),\n            getEditor: () => this._fileEditor.editor,\n            src: this._fileEditor.model.sharedModel\n        });\n    }\n    /**\n     * Dispose the handler.\n     */\n    dispose() {\n        var _a, _b;\n        if (this.isDisposed) {\n            return;\n        }\n        this.isDisposed = true;\n        (_a = this._editorHandler) === null || _a === void 0 ? void 0 : _a.dispose();\n        // Restore editor options\n        (_b = this._editorHandler) === null || _b === void 0 ? void 0 : _b.editor.setOptions({\n            lineNumbers: this._hasLineNumber\n        });\n        _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal.clearData(this);\n    }\n}\n//# sourceMappingURL=file.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/debugger/lib/handlers/file.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/debugger/lib/handlers/notebook.js":
/*!*********************************************************************!*\
  !*** ../node_modules/@jupyterlab/debugger/lib/handlers/notebook.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   NotebookHandler: () => (/* binding */ NotebookHandler)\n/* harmony export */ });\n/* harmony import */ var _jupyterlab_observables__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/observables */ \"webpack/sharing/consume/default/@jupyterlab/observables/@jupyterlab/observables\");\n/* harmony import */ var _jupyterlab_observables__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_observables__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/signaling */ \"webpack/sharing/consume/default/@lumino/signaling/@lumino/signaling\");\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_signaling__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _editor__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./editor */ \"../node_modules/@jupyterlab/debugger/lib/handlers/editor.js\");\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\n\n/**\n * A handler for notebooks.\n */\nclass NotebookHandler {\n    /**\n     * Instantiate a new NotebookHandler.\n     *\n     * @param options The instantiation options for a NotebookHandler.\n     */\n    constructor(options) {\n        this._debuggerService = options.debuggerService;\n        this._notebookPanel = options.widget;\n        this._cellMap = new _jupyterlab_observables__WEBPACK_IMPORTED_MODULE_0__.ObservableMap();\n        const notebook = this._notebookPanel.content;\n        notebook.model.cells.changed.connect(this._onCellsChanged, this);\n        this._onCellsChanged();\n    }\n    /**\n     * Dispose the handler.\n     */\n    dispose() {\n        if (this.isDisposed) {\n            return;\n        }\n        this.isDisposed = true;\n        this._cellMap.values().forEach(handler => {\n            var _a;\n            handler.dispose();\n            // Ensure to restore notebook editor settings\n            (_a = handler.editor) === null || _a === void 0 ? void 0 : _a.setOptions({\n                ...this._notebookPanel.content.editorConfig.code\n            });\n        });\n        this._cellMap.dispose();\n        _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__.Signal.clearData(this);\n    }\n    /**\n     * Handle a notebook cells changed event.\n     */\n    _onCellsChanged(cells, changes) {\n        var _a;\n        this._notebookPanel.content.widgets.forEach(cell => this._addEditorHandler(cell));\n        if ((changes === null || changes === void 0 ? void 0 : changes.type) === 'move') {\n            for (const cell of changes.newValues) {\n                (_a = this._cellMap.get(cell.id)) === null || _a === void 0 ? void 0 : _a.refreshBreakpoints();\n            }\n        }\n    }\n    /**\n     * Add a new editor handler for the given cell.\n     *\n     * @param cell The cell to add the handler to.\n     */\n    _addEditorHandler(cell) {\n        const modelId = cell.model.id;\n        if (cell.model.type !== 'code' || this._cellMap.has(modelId)) {\n            return;\n        }\n        const codeCell = cell;\n        const editorHandler = new _editor__WEBPACK_IMPORTED_MODULE_2__.EditorHandler({\n            debuggerService: this._debuggerService,\n            editorReady: async () => {\n                await codeCell.ready;\n                return codeCell.editor;\n            },\n            getEditor: () => codeCell.editor,\n            src: cell.model.sharedModel\n        });\n        codeCell.disposed.connect(() => {\n            this._cellMap.delete(modelId);\n            editorHandler.dispose();\n        });\n        this._cellMap.set(cell.model.id, editorHandler);\n    }\n}\n//# sourceMappingURL=notebook.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/debugger/lib/handlers/notebook.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/debugger/lib/hash.js":
/*!********************************************************!*\
  !*** ../node_modules/@jupyterlab/debugger/lib/hash.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   murmur2: () => (/* binding */ murmur2)\n/* harmony export */ });\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n// Most of the implementation below is adapted from the following repository:\n// https://github.com/garycourt/murmurhash-js/blob/master/murmurhash2_gc.js\n// Which has the following MIT License:\n//\n// Copyright (c) 2011 Gary Court\n// Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the \"Software\"),\n// to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,\n// and to permit persons to whom the Software is furnished to do so, subject to the following conditions:\n// The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.\n// THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,\n//  TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.\n// The implementation below uses case fallthrough as part of the algorithm.\n/* eslint-disable no-fallthrough */\nconst m = 0x5bd1e995;\nconst encoder = new TextEncoder();\n/**\n * Calculate the murmurhash2 for a given string and seed.\n *\n * @param str The string to calculate the Murmur2 hash for.\n * @param seed The seed.\n *\n * @returns The Murmurhash2 hash.\n */\nfunction murmur2(str, seed) {\n    const data = encoder.encode(str);\n    let len = data.length;\n    let h = seed ^ len;\n    let i = 0;\n    while (len >= 4) {\n        let k = (data[i] & 0xff) |\n            ((data[++i] & 0xff) << 8) |\n            ((data[++i] & 0xff) << 16) |\n            ((data[++i] & 0xff) << 24);\n        k = (k & 0xffff) * m + ((((k >>> 16) * m) & 0xffff) << 16);\n        k ^= k >>> 24;\n        k = (k & 0xffff) * m + ((((k >>> 16) * m) & 0xffff) << 16);\n        h = ((h & 0xffff) * m + ((((h >>> 16) * m) & 0xffff) << 16)) ^ k;\n        len -= 4;\n        ++i;\n    }\n    switch (len) {\n        case 3:\n            h ^= (data[i + 2] & 0xff) << 16;\n        case 2:\n            h ^= (data[i + 1] & 0xff) << 8;\n        case 1:\n            h ^= data[i] & 0xff;\n            h = (h & 0xffff) * m + ((((h >>> 16) * m) & 0xffff) << 16);\n    }\n    h ^= h >>> 13;\n    h = (h & 0xffff) * m + ((((h >>> 16) * m) & 0xffff) << 16);\n    h ^= h >>> 15;\n    return h >>> 0;\n}\n//# sourceMappingURL=hash.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/debugger/lib/hash.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/debugger/lib/index.js":
/*!*********************************************************!*\
  !*** ../node_modules/@jupyterlab/debugger/lib/index.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Debugger: () => (/* reexport safe */ _debugger__WEBPACK_IMPORTED_MODULE_0__.Debugger),\n/* harmony export */   IDebugger: () => (/* reexport safe */ _tokens__WEBPACK_IMPORTED_MODULE_1__.IDebugger),\n/* harmony export */   IDebuggerConfig: () => (/* reexport safe */ _tokens__WEBPACK_IMPORTED_MODULE_1__.IDebuggerConfig),\n/* harmony export */   IDebuggerHandler: () => (/* reexport safe */ _tokens__WEBPACK_IMPORTED_MODULE_1__.IDebuggerHandler),\n/* harmony export */   IDebuggerSidebar: () => (/* reexport safe */ _tokens__WEBPACK_IMPORTED_MODULE_1__.IDebuggerSidebar),\n/* harmony export */   IDebuggerSourceViewer: () => (/* reexport safe */ _tokens__WEBPACK_IMPORTED_MODULE_1__.IDebuggerSourceViewer),\n/* harmony export */   IDebuggerSources: () => (/* reexport safe */ _tokens__WEBPACK_IMPORTED_MODULE_1__.IDebuggerSources)\n/* harmony export */ });\n/* harmony import */ var _debugger__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./debugger */ \"../node_modules/@jupyterlab/debugger/lib/debugger.js\");\n/* harmony import */ var _tokens__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./tokens */ \"../node_modules/@jupyterlab/debugger/lib/tokens.js\");\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n/**\n * @packageDocumentation\n * @module debugger\n */\n\n\n//# sourceMappingURL=index.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/debugger/lib/index.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/debugger/lib/model.js":
/*!*********************************************************!*\
  !*** ../node_modules/@jupyterlab/debugger/lib/model.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   DebuggerModel: () => (/* binding */ DebuggerModel)\n/* harmony export */ });\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/signaling */ \"webpack/sharing/consume/default/@lumino/signaling/@lumino/signaling\");\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_signaling__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _panels_breakpoints_model__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./panels/breakpoints/model */ \"../node_modules/@jupyterlab/debugger/lib/panels/breakpoints/model.js\");\n/* harmony import */ var _panels_callstack_model__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./panels/callstack/model */ \"../node_modules/@jupyterlab/debugger/lib/panels/callstack/model.js\");\n/* harmony import */ var _panels_sources_model__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./panels/sources/model */ \"../node_modules/@jupyterlab/debugger/lib/panels/sources/model.js\");\n/* harmony import */ var _panels_kernelSources_model__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./panels/kernelSources/model */ \"../node_modules/@jupyterlab/debugger/lib/panels/kernelSources/model.js\");\n/* harmony import */ var _panels_variables_model__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./panels/variables/model */ \"../node_modules/@jupyterlab/debugger/lib/panels/variables/model.js\");\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\n\n\n\n\n/**\n * A model for a debugger.\n */\nclass DebuggerModel {\n    /**\n     * Instantiate a new DebuggerModel\n     */\n    constructor() {\n        this._disposed = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal(this);\n        this._isDisposed = false;\n        this._hasRichVariableRendering = false;\n        this._supportCopyToGlobals = false;\n        this._stoppedThreads = new Set();\n        this._title = '-';\n        this._titleChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal(this);\n        this.breakpoints = new _panels_breakpoints_model__WEBPACK_IMPORTED_MODULE_1__.BreakpointsModel();\n        this.callstack = new _panels_callstack_model__WEBPACK_IMPORTED_MODULE_2__.CallstackModel();\n        this.variables = new _panels_variables_model__WEBPACK_IMPORTED_MODULE_3__.VariablesModel();\n        this.sources = new _panels_sources_model__WEBPACK_IMPORTED_MODULE_4__.SourcesModel({\n            currentFrameChanged: this.callstack.currentFrameChanged\n        });\n        this.kernelSources = new _panels_kernelSources_model__WEBPACK_IMPORTED_MODULE_5__.KernelSourcesModel();\n    }\n    /**\n     * A signal emitted when the debugger widget is disposed.\n     */\n    get disposed() {\n        return this._disposed;\n    }\n    /**\n     * Whether the kernel support rich variable rendering based on mime type.\n     */\n    get hasRichVariableRendering() {\n        return this._hasRichVariableRendering;\n    }\n    set hasRichVariableRendering(v) {\n        this._hasRichVariableRendering = v;\n    }\n    /**\n     * Whether the kernel supports the copyToGlobals request.\n     */\n    get supportCopyToGlobals() {\n        return this._supportCopyToGlobals;\n    }\n    set supportCopyToGlobals(v) {\n        this._supportCopyToGlobals = v;\n    }\n    /**\n     * Whether the model is disposed.\n     */\n    get isDisposed() {\n        return this._isDisposed;\n    }\n    /**\n     * The set of threads in stopped state.\n     */\n    get stoppedThreads() {\n        return this._stoppedThreads;\n    }\n    /**\n     * Assigns the parameters to the set of threads in stopped state.\n     */\n    set stoppedThreads(threads) {\n        this._stoppedThreads = threads;\n    }\n    /**\n     * The current debugger title.\n     */\n    get title() {\n        return this._title;\n    }\n    /**\n     * Set the current debugger title.\n     */\n    set title(title) {\n        if (title === this._title) {\n            return;\n        }\n        this._title = title !== null && title !== void 0 ? title : '-';\n        this._titleChanged.emit(title);\n    }\n    /**\n     * A signal emitted when the title changes.\n     */\n    get titleChanged() {\n        return this._titleChanged;\n    }\n    /**\n     * Dispose the model.\n     */\n    dispose() {\n        if (this._isDisposed) {\n            return;\n        }\n        this._isDisposed = true;\n        this.kernelSources.dispose();\n        this._disposed.emit();\n    }\n    /**\n     * Clear the model.\n     */\n    clear() {\n        this._stoppedThreads.clear();\n        const breakpoints = new Map();\n        this.breakpoints.restoreBreakpoints(breakpoints);\n        this.callstack.frames = [];\n        this.variables.scopes = [];\n        this.sources.currentSource = null;\n        this.kernelSources.kernelSources = null;\n        this.title = '-';\n    }\n}\n//# sourceMappingURL=model.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/debugger/lib/model.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/debugger/lib/panels/breakpoints/body.js":
/*!***************************************************************************!*\
  !*** ../node_modules/@jupyterlab/debugger/lib/panels/breakpoints/body.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   BreakpointsBody: () => (/* binding */ BreakpointsBody)\n/* harmony export */ });\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/ui-components */ \"webpack/sharing/consume/default/@jupyterlab/ui-components/@jupyterlab/ui-components\");\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ \"webpack/sharing/consume/default/react/react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\n/**\n * The body for a Breakpoints Panel.\n */\nclass BreakpointsBody extends _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.ReactWidget {\n    /**\n     * Instantiate a new Body for the Breakpoints Panel.\n     *\n     * @param model The model for the breakpoints.\n     */\n    constructor(model) {\n        super();\n        this._model = model;\n        this.addClass('jp-DebuggerBreakpoints-body');\n    }\n    /**\n     * Render the BreakpointsComponent.\n     */\n    render() {\n        return react__WEBPACK_IMPORTED_MODULE_1___default().createElement(BreakpointsComponent, { model: this._model });\n    }\n}\n/**\n * A React component to display a list of breakpoints.\n *\n * @param {object} props The component props.\n * @param props.model The model for the breakpoints.\n */\nconst BreakpointsComponent = ({ model }) => {\n    const [breakpoints, setBreakpoints] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(Array.from(model.breakpoints.entries()));\n    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {\n        const updateBreakpoints = (_, updates) => {\n            setBreakpoints(Array.from(model.breakpoints.entries()));\n        };\n        const restoreBreakpoints = (_) => {\n            setBreakpoints(Array.from(model.breakpoints.entries()));\n        };\n        model.changed.connect(updateBreakpoints);\n        model.restored.connect(restoreBreakpoints);\n        return () => {\n            model.changed.disconnect(updateBreakpoints);\n            model.restored.disconnect(restoreBreakpoints);\n        };\n    });\n    return (react__WEBPACK_IMPORTED_MODULE_1___default().createElement((react__WEBPACK_IMPORTED_MODULE_1___default().Fragment), null, breakpoints.map(entry => (react__WEBPACK_IMPORTED_MODULE_1___default().createElement(BreakpointCellComponent, { key: entry[0], breakpoints: entry[1], model: model })))));\n};\n/**\n * A React Component to display breakpoints grouped by source file.\n *\n * @param {object} props The component props.\n * @param props.breakpoints The list of breakpoints.\n * @param props.model The model for the breakpoints.\n */\nconst BreakpointCellComponent = ({ breakpoints, model }) => {\n    return (react__WEBPACK_IMPORTED_MODULE_1___default().createElement((react__WEBPACK_IMPORTED_MODULE_1___default().Fragment), null, breakpoints\n        .sort((a, b) => {\n        var _a, _b;\n        return ((_a = a.line) !== null && _a !== void 0 ? _a : 0) - ((_b = b.line) !== null && _b !== void 0 ? _b : 0);\n    })\n        .map((breakpoint, index) => {\n        var _a, _b;\n        return (react__WEBPACK_IMPORTED_MODULE_1___default().createElement(BreakpointComponent, { key: ((_b = (_a = breakpoint.source) === null || _a === void 0 ? void 0 : _a.path) !== null && _b !== void 0 ? _b : '') + index, breakpoint: breakpoint, model: model }));\n    })));\n};\n/**\n * A React Component to display a single breakpoint.\n *\n * @param {object} props The component props.\n * @param props.breakpoint The breakpoint.\n * @param props.model The model for the breakpoints.\n */\nconst BreakpointComponent = ({ breakpoint, model }) => {\n    var _a, _b, _c;\n    const moveToEndFirstCharIfSlash = (breakpointSourcePath) => {\n        return breakpointSourcePath[0] === '/'\n            ? breakpointSourcePath.slice(1) + '/'\n            : breakpointSourcePath;\n    };\n    return (react__WEBPACK_IMPORTED_MODULE_1___default().createElement(\"div\", { className: 'jp-DebuggerBreakpoint', onClick: () => model.clicked.emit(breakpoint), title: (_a = breakpoint.source) === null || _a === void 0 ? void 0 : _a.path },\n        react__WEBPACK_IMPORTED_MODULE_1___default().createElement(\"span\", { className: 'jp-DebuggerBreakpoint-marker' }, \"\\u25CF\"),\n        react__WEBPACK_IMPORTED_MODULE_1___default().createElement(\"span\", { className: 'jp-DebuggerBreakpoint-source jp-left-truncated' }, moveToEndFirstCharIfSlash((_c = (_b = breakpoint.source) === null || _b === void 0 ? void 0 : _b.path) !== null && _c !== void 0 ? _c : '')),\n        react__WEBPACK_IMPORTED_MODULE_1___default().createElement(\"span\", { className: 'jp-DebuggerBreakpoint-line' }, breakpoint.line)));\n};\n//# sourceMappingURL=body.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/debugger/lib/panels/breakpoints/body.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/debugger/lib/panels/breakpoints/index.js":
/*!****************************************************************************!*\
  !*** ../node_modules/@jupyterlab/debugger/lib/panels/breakpoints/index.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Breakpoints: () => (/* binding */ Breakpoints)\n/* harmony export */ });\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/apputils */ \"webpack/sharing/consume/default/@jupyterlab/apputils/@jupyterlab/apputils\");\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/translation */ \"webpack/sharing/consume/default/@jupyterlab/translation/@jupyterlab/translation\");\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_translation__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/ui-components */ \"webpack/sharing/consume/default/@jupyterlab/ui-components/@jupyterlab/ui-components\");\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @lumino/signaling */ \"webpack/sharing/consume/default/@lumino/signaling/@lumino/signaling\");\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_lumino_signaling__WEBPACK_IMPORTED_MODULE_3__);\n/* harmony import */ var _body__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./body */ \"../node_modules/@jupyterlab/debugger/lib/panels/breakpoints/body.js\");\n/* harmony import */ var _pauseonexceptions__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./pauseonexceptions */ \"../node_modules/@jupyterlab/debugger/lib/panels/breakpoints/pauseonexceptions.js\");\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\n\n\n\n\n/**\n * A Panel to show a list of breakpoints.\n */\nclass Breakpoints extends _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__.PanelWithToolbar {\n    /**\n     * Instantiate a new Breakpoints Panel.\n     *\n     * @param options The instantiation options for a Breakpoints Panel.\n     */\n    constructor(options) {\n        var _a;\n        super(options);\n        this.clicked = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_3__.Signal(this);\n        const { model, service, commands } = options;\n        const trans = ((_a = options.translator) !== null && _a !== void 0 ? _a : _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_1__.nullTranslator).load('jupyterlab');\n        this.title.label = trans.__('Breakpoints');\n        const body = new _body__WEBPACK_IMPORTED_MODULE_4__.BreakpointsBody(model);\n        this.toolbar.node.setAttribute('aria-label', trans.__('Breakpoints panel toolbar'));\n        this.toolbar.addItem('pauseOnException', new _pauseonexceptions__WEBPACK_IMPORTED_MODULE_5__.PauseOnExceptionsWidget({\n            service: service,\n            commands: commands,\n            icon: _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__.exceptionsIcon,\n            tooltip: trans.__('Pause on exception filter')\n        }));\n        this.toolbar.addItem('closeAll', new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__.ToolbarButton({\n            icon: _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__.closeAllIcon,\n            onClick: async () => {\n                if (model.breakpoints.size === 0) {\n                    return;\n                }\n                const result = await (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.showDialog)({\n                    title: trans.__('Remove All Breakpoints'),\n                    body: trans.__('Are you sure you want to remove all breakpoints?'),\n                    buttons: [\n                        _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.Dialog.okButton({ label: trans.__('Remove breakpoints') }),\n                        _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.Dialog.cancelButton()\n                    ],\n                    hasClose: true\n                });\n                if (result.button.accept) {\n                    return service.clearBreakpoints();\n                }\n            },\n            tooltip: trans.__('Remove All Breakpoints')\n        }));\n        this.addWidget(body);\n        this.addClass('jp-DebuggerBreakpoints');\n    }\n}\n//# sourceMappingURL=index.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/debugger/lib/panels/breakpoints/index.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/debugger/lib/panels/breakpoints/model.js":
/*!****************************************************************************!*\
  !*** ../node_modules/@jupyterlab/debugger/lib/panels/breakpoints/model.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   BreakpointsModel: () => (/* binding */ BreakpointsModel)\n/* harmony export */ });\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/signaling */ \"webpack/sharing/consume/default/@lumino/signaling/@lumino/signaling\");\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_signaling__WEBPACK_IMPORTED_MODULE_0__);\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n/**\n * A model for a list of breakpoints.\n */\nclass BreakpointsModel {\n    constructor() {\n        this._breakpoints = new Map();\n        this._changed = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal(this);\n        this._restored = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal(this);\n        this._clicked = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal(this);\n    }\n    /**\n     * Signal emitted when the model changes.\n     */\n    get changed() {\n        return this._changed;\n    }\n    /**\n     * Signal emitted when the breakpoints are restored.\n     */\n    get restored() {\n        return this._restored;\n    }\n    /**\n     * Signal emitted when a breakpoint is clicked.\n     */\n    get clicked() {\n        return this._clicked;\n    }\n    /**\n     * Get all the breakpoints.\n     */\n    get breakpoints() {\n        return this._breakpoints;\n    }\n    /**\n     * Set the breakpoints for a given id (path).\n     *\n     * @param id The code id (path).\n     * @param breakpoints The list of breakpoints.\n     */\n    setBreakpoints(id, breakpoints) {\n        this._breakpoints.set(id, breakpoints);\n        this._changed.emit(breakpoints);\n    }\n    /**\n     * Get the breakpoints for a given id (path).\n     *\n     * @param id The code id (path).\n     */\n    getBreakpoints(id) {\n        var _a;\n        return (_a = this._breakpoints.get(id)) !== null && _a !== void 0 ? _a : [];\n    }\n    /**\n     * Restore a map of breakpoints.\n     *\n     * @param breakpoints The map of breakpoints\n     */\n    restoreBreakpoints(breakpoints) {\n        this._breakpoints = breakpoints;\n        this._restored.emit();\n    }\n}\n//# sourceMappingURL=model.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/debugger/lib/panels/breakpoints/model.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/debugger/lib/panels/breakpoints/pauseonexceptions.js":
/*!****************************************************************************************!*\
  !*** ../node_modules/@jupyterlab/debugger/lib/panels/breakpoints/pauseonexceptions.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   PauseOnExceptionsMenu: () => (/* binding */ PauseOnExceptionsMenu),\n/* harmony export */   PauseOnExceptionsWidget: () => (/* binding */ PauseOnExceptionsWidget)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"webpack/sharing/consume/default/react/react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/ui-components */ \"webpack/sharing/consume/default/@jupyterlab/ui-components/@jupyterlab/ui-components\");\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__);\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\nconst PAUSE_ON_EXCEPTION_CLASS = 'jp-debugger-pauseOnExceptions';\nconst PAUSE_ON_EXCEPTION_BUTTON_CLASS = 'jp-PauseOnExceptions';\nconst PAUSE_ON_EXCEPTION_MENU_CLASS = 'jp-PauseOnExceptions-menu';\n/**\n * A button which display a menu on click, to select the filter.\n */\nclass PauseOnExceptionsWidget extends _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.ToolbarButton {\n    /**\n     * Constructor of the button.\n     */\n    constructor(props) {\n        super();\n        /**\n         * open menu on click.\n         */\n        this.onclick = () => {\n            this._menu.open(this.node.getBoundingClientRect().left, this.node.getBoundingClientRect().bottom);\n        };\n        this._menu = new PauseOnExceptionsMenu({\n            service: props.service,\n            commands: {\n                registry: props.commands.registry,\n                pauseOnExceptions: props.commands.pauseOnExceptions\n            }\n        });\n        this.node.className = PAUSE_ON_EXCEPTION_CLASS;\n        this._props = props;\n        this._props.className = PAUSE_ON_EXCEPTION_BUTTON_CLASS;\n        this._props.service.eventMessage.connect((_, event) => {\n            if (event.event === 'initialized' || event.event === 'terminated') {\n                this.onChange();\n            }\n        }, this);\n        this._props.enabled = this._props.service.pauseOnExceptionsIsValid();\n        this._props.service.pauseOnExceptionChanged.connect(this.onChange, this);\n    }\n    /**\n     * Called when the debugger is initialized or the filter changed.\n     */\n    onChange() {\n        var _a;\n        const session = this._props.service.session;\n        const exceptionBreakpointFilters = session === null || session === void 0 ? void 0 : session.exceptionBreakpointFilters;\n        this._props.className = PAUSE_ON_EXCEPTION_BUTTON_CLASS;\n        if (((_a = this._props.service.session) === null || _a === void 0 ? void 0 : _a.isStarted) && exceptionBreakpointFilters) {\n            this._props.pressed = session.isPausingOnException();\n            this._props.enabled = true;\n        }\n        else {\n            this._props.enabled = false;\n        }\n        this.update();\n    }\n    render() {\n        return react__WEBPACK_IMPORTED_MODULE_0__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.ToolbarButtonComponent, { ...this._props, onClick: this.onclick });\n    }\n}\n/**\n * A menu with all the available filter from the debugger as entries.\n */\nclass PauseOnExceptionsMenu extends _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.MenuSvg {\n    /**\n     * The constructor of the menu.\n     */\n    constructor(props) {\n        super({ commands: props.commands.registry });\n        this._service = props.service;\n        this._command = props.commands.pauseOnExceptions;\n        props.service.eventMessage.connect((_, event) => {\n            if (event.event === 'initialized') {\n                this._build();\n            }\n        }, this);\n        this._build();\n        this.addClass(PAUSE_ON_EXCEPTION_MENU_CLASS);\n    }\n    _build() {\n        var _a, _b;\n        this.clearItems();\n        const exceptionsBreakpointFilters = (_b = (_a = this._service.session) === null || _a === void 0 ? void 0 : _a.exceptionBreakpointFilters) !== null && _b !== void 0 ? _b : [];\n        exceptionsBreakpointFilters.map((filter, _) => {\n            this.addItem({\n                command: this._command,\n                args: {\n                    filter: filter.filter,\n                    description: filter.description\n                }\n            });\n        });\n    }\n}\n//# sourceMappingURL=pauseonexceptions.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/debugger/lib/panels/breakpoints/pauseonexceptions.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/debugger/lib/panels/callstack/body.js":
/*!*************************************************************************!*\
  !*** ../node_modules/@jupyterlab/debugger/lib/panels/callstack/body.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   CallstackBody: () => (/* binding */ CallstackBody)\n/* harmony export */ });\n/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/coreutils */ \"webpack/sharing/consume/default/@jupyterlab/coreutils/@jupyterlab/coreutils\");\n/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/ui-components */ \"webpack/sharing/consume/default/@jupyterlab/ui-components/@jupyterlab/ui-components\");\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ \"webpack/sharing/consume/default/react/react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\n\n/**\n * The body for a Callstack Panel.\n */\nclass CallstackBody extends _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.ReactWidget {\n    /**\n     * Instantiate a new Body for the Callstack Panel.\n     *\n     * @param model The model for the callstack.\n     */\n    constructor(model) {\n        super();\n        this._model = model;\n        this.addClass('jp-DebuggerCallstack-body');\n    }\n    /**\n     * Render the FramesComponent.\n     */\n    render() {\n        return react__WEBPACK_IMPORTED_MODULE_2___default().createElement(FramesComponent, { model: this._model });\n    }\n}\n/**\n * A React component to display a list of frames in a callstack.\n *\n * @param {object} props The component props.\n * @param props.model The model for the callstack.\n */\nconst FramesComponent = ({ model }) => {\n    const [frames, setFrames] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(model.frames);\n    const [selected, setSelected] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(model.frame);\n    const onSelected = (frame) => {\n        setSelected(frame);\n        model.frame = frame;\n    };\n    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {\n        const updateFrames = () => {\n            setSelected(model.frame);\n            setFrames(model.frames);\n        };\n        model.framesChanged.connect(updateFrames);\n        return () => {\n            model.framesChanged.disconnect(updateFrames);\n        };\n    }, [model]);\n    const toShortLocation = (el) => {\n        var _a;\n        const path = ((_a = el.source) === null || _a === void 0 ? void 0 : _a.path) || '';\n        const base = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.PathExt.basename(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.PathExt.dirname(path));\n        const filename = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.PathExt.basename(path);\n        const shortname = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.PathExt.join(base, filename);\n        return `${shortname}:${el.line}`;\n    };\n    return (react__WEBPACK_IMPORTED_MODULE_2___default().createElement(\"ul\", null, frames.map(ele => {\n        var _a;\n        return (react__WEBPACK_IMPORTED_MODULE_2___default().createElement(\"li\", { key: ele.id, onClick: () => onSelected(ele), className: (selected === null || selected === void 0 ? void 0 : selected.id) === ele.id\n                ? 'selected jp-DebuggerCallstackFrame'\n                : 'jp-DebuggerCallstackFrame' },\n            react__WEBPACK_IMPORTED_MODULE_2___default().createElement(\"span\", { className: 'jp-DebuggerCallstackFrame-name' }, ele.name),\n            react__WEBPACK_IMPORTED_MODULE_2___default().createElement(\"span\", { className: 'jp-DebuggerCallstackFrame-location', title: (_a = ele.source) === null || _a === void 0 ? void 0 : _a.path }, toShortLocation(ele))));\n    })));\n};\n//# sourceMappingURL=body.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/debugger/lib/panels/callstack/body.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/debugger/lib/panels/callstack/index.js":
/*!**************************************************************************!*\
  !*** ../node_modules/@jupyterlab/debugger/lib/panels/callstack/index.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Callstack: () => (/* binding */ Callstack)\n/* harmony export */ });\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/translation */ \"webpack/sharing/consume/default/@jupyterlab/translation/@jupyterlab/translation\");\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/ui-components */ \"webpack/sharing/consume/default/@jupyterlab/ui-components/@jupyterlab/ui-components\");\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _body__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./body */ \"../node_modules/@jupyterlab/debugger/lib/panels/callstack/body.js\");\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\n\n/**\n * A Panel to show a callstack.\n */\nclass Callstack extends _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.PanelWithToolbar {\n    /**\n     * Instantiate a new Callstack Panel.\n     *\n     * @param options The instantiation options for a Callstack Panel.\n     */\n    constructor(options) {\n        var _a;\n        super(options);\n        const { commands, model } = options;\n        const trans = ((_a = options.translator) !== null && _a !== void 0 ? _a : _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__.nullTranslator).load('jupyterlab');\n        this.title.label = trans.__('Callstack');\n        const body = new _body__WEBPACK_IMPORTED_MODULE_2__.CallstackBody(model);\n        this.toolbar.node.setAttribute('aria-label', trans.__('Callstack panel toolbar'));\n        this.toolbar.addItem('continue', new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.CommandToolbarButton({\n            commands: commands.registry,\n            id: commands.continue,\n            label: ''\n        }));\n        this.toolbar.addItem('terminate', new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.CommandToolbarButton({\n            commands: commands.registry,\n            id: commands.terminate,\n            label: ''\n        }));\n        this.toolbar.addItem('step-over', new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.CommandToolbarButton({\n            commands: commands.registry,\n            id: commands.next,\n            label: ''\n        }));\n        this.toolbar.addItem('step-in', new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.CommandToolbarButton({\n            commands: commands.registry,\n            id: commands.stepIn,\n            label: ''\n        }));\n        this.toolbar.addItem('step-out', new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.CommandToolbarButton({\n            commands: commands.registry,\n            id: commands.stepOut,\n            label: ''\n        }));\n        this.toolbar.addItem('evaluate', new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.CommandToolbarButton({\n            commands: commands.registry,\n            id: commands.evaluate,\n            label: ''\n        }));\n        this.addWidget(body);\n        this.addClass('jp-DebuggerCallstack');\n    }\n}\n//# sourceMappingURL=index.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/debugger/lib/panels/callstack/index.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/debugger/lib/panels/callstack/model.js":
/*!**************************************************************************!*\
  !*** ../node_modules/@jupyterlab/debugger/lib/panels/callstack/model.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   CallstackModel: () => (/* binding */ CallstackModel)\n/* harmony export */ });\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/signaling */ \"webpack/sharing/consume/default/@lumino/signaling/@lumino/signaling\");\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_signaling__WEBPACK_IMPORTED_MODULE_0__);\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n/**\n * A model for a callstack.\n */\nclass CallstackModel {\n    constructor() {\n        this._state = [];\n        this._currentFrame = null;\n        this._framesChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal(this);\n        this._currentFrameChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal(this);\n    }\n    /**\n     * Get all the frames.\n     */\n    get frames() {\n        return this._state;\n    }\n    /**\n     * Set the frames.\n     */\n    set frames(newFrames) {\n        this._state = newFrames;\n        const currentFrameId = this.frame !== null ? Private.getFrameId(this.frame) : '';\n        const frame = newFrames.find(frame => Private.getFrameId(frame) === currentFrameId);\n        // Default to the first frame if the previous one can't be found.\n        // Otherwise keep the current frame selected.\n        if (!frame) {\n            this.frame = newFrames[0];\n        }\n        this._framesChanged.emit(newFrames);\n    }\n    /**\n     * Get the current frame.\n     */\n    get frame() {\n        return this._currentFrame;\n    }\n    /**\n     * Set the current frame.\n     */\n    set frame(frame) {\n        this._currentFrame = frame;\n        this._currentFrameChanged.emit(frame);\n    }\n    /**\n     * Signal emitted when the frames have changed.\n     */\n    get framesChanged() {\n        return this._framesChanged;\n    }\n    /**\n     * Signal emitted when the current frame has changed.\n     */\n    get currentFrameChanged() {\n        return this._currentFrameChanged;\n    }\n}\n/**\n * A namespace for private data.\n */\nvar Private;\n(function (Private) {\n    /**\n     * Construct an id for the given frame.\n     *\n     * @param frame The frame.\n     */\n    function getFrameId(frame) {\n        var _a;\n        return `${(_a = frame === null || frame === void 0 ? void 0 : frame.source) === null || _a === void 0 ? void 0 : _a.path}-${frame === null || frame === void 0 ? void 0 : frame.id}`;\n    }\n    Private.getFrameId = getFrameId;\n})(Private || (Private = {}));\n//# sourceMappingURL=model.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/debugger/lib/panels/callstack/model.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/debugger/lib/panels/kernelSources/body.js":
/*!*****************************************************************************!*\
  !*** ../node_modules/@jupyterlab/debugger/lib/panels/kernelSources/body.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   KernelSourcesBody: () => (/* binding */ KernelSourcesBody)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"webpack/sharing/consume/default/react/react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/ui-components */ \"webpack/sharing/consume/default/@jupyterlab/ui-components/@jupyterlab/ui-components\");\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/apputils */ \"webpack/sharing/consume/default/@jupyterlab/apputils/@jupyterlab/apputils\");\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/translation */ \"webpack/sharing/consume/default/@jupyterlab/translation/@jupyterlab/translation\");\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_translation__WEBPACK_IMPORTED_MODULE_3__);\n/* harmony import */ var _filter__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./filter */ \"../node_modules/@jupyterlab/debugger/lib/panels/kernelSources/filter.js\");\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\n\n\n\n\n/**\n * The class name added to the filterbox node.\n */\nconst FILTERBOX_CLASS = 'jp-DebuggerKernelSource-filterBox';\n/**\n * The class name added to hide the filterbox node.\n */\nconst FILTERBOX_HIDDEN_CLASS = 'jp-DebuggerKernelSource-filterBox-hidden';\n/**\n * The class for each source row.\n */\nconst SOURCE_CLASS = 'jp-DebuggerKernelSource-source';\n/**\n * The body for a Sources Panel.\n */\nclass KernelSourcesBody extends _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.ReactWidget {\n    /**\n     * Instantiate a new Body for the KernelSourcesBody widget.\n     *\n     * @param options The instantiation options for a KernelSourcesBody.\n     */\n    constructor(options) {\n        var _a;\n        super();\n        this._showFilter = false;\n        this._model = options.model;\n        this._debuggerService = options.service;\n        this._trans = ((_a = options.translator) !== null && _a !== void 0 ? _a : _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_3__.nullTranslator).load('jupyterlab');\n        this.addClass('jp-DebuggerKernelSources-body');\n    }\n    render() {\n        let filterClass = FILTERBOX_CLASS;\n        if (!this._showFilter) {\n            filterClass += ' ' + FILTERBOX_HIDDEN_CLASS;\n        }\n        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,\n            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", { className: filterClass, key: 'filter' },\n                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_filter__WEBPACK_IMPORTED_MODULE_4__.KernelSourcesFilter, { model: this._model, trans: this._trans })),\n            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.UseSignal, { signal: this._model.changed }, (_, kernelSources) => {\n                const keymap = {};\n                return (kernelSources !== null && kernelSources !== void 0 ? kernelSources : []).map(module => {\n                    var _a;\n                    const name = module.name;\n                    const path = module.path;\n                    const key = name + (keymap[name] = ((_a = keymap[name]) !== null && _a !== void 0 ? _a : 0) + 1).toString();\n                    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", { key: key, title: path, className: SOURCE_CLASS, onClick: () => {\n                            this._debuggerService\n                                .getSource({\n                                sourceReference: 0,\n                                path: path\n                            })\n                                .then(source => {\n                                this._model.open(source);\n                            })\n                                .catch(reason => {\n                                void (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_2__.showErrorMessage)(this._trans.__('Fail to get source'), this._trans.__(\"Fail to get '%1' source:\\n%2\", path, reason));\n                            });\n                        } },\n                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.LabIcon.resolveReact, { icon: _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.openKernelSourceIcon, iconClass: (0,_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.classes)('jp-Icon'), tag: null }),\n                        name));\n                });\n            })));\n    }\n    /**\n     * Show or hide the filter box.\n     */\n    toggleFilterbox() {\n        this._showFilter = !this._showFilter;\n        this.update();\n    }\n}\n//# sourceMappingURL=body.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/debugger/lib/panels/kernelSources/body.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/debugger/lib/panels/kernelSources/filter.js":
/*!*******************************************************************************!*\
  !*** ../node_modules/@jupyterlab/debugger/lib/panels/kernelSources/filter.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   KernelSourcesFilter: () => (/* binding */ KernelSourcesFilter)\n/* harmony export */ });\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/ui-components */ \"webpack/sharing/consume/default/@jupyterlab/ui-components/@jupyterlab/ui-components\");\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ \"webpack/sharing/consume/default/react/react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _jupyter_react_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyter/react-components */ \"webpack/sharing/consume/default/@jupyter/react-components/@jupyter/react-components\");\n/* harmony import */ var _jupyter_react_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyter_react_components__WEBPACK_IMPORTED_MODULE_2__);\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\n\nconst FilterBox = (props) => {\n    const onFilterChange = (e) => {\n        const filter = e.target.value;\n        props.model.filter = filter;\n    };\n    return (react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_jupyter_react_components__WEBPACK_IMPORTED_MODULE_2__.Search, { onChange: onFilterChange, placeholder: props.trans.__('Filter the kernel sources'), value: props.model.filter }));\n};\n/**\n * A widget which hosts a input textbox to filter on file names.\n */\nconst KernelSourcesFilter = (props) => {\n    return (react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.UseSignal, { signal: props.model.filterChanged, initialArgs: props.model.filter }, model => react__WEBPACK_IMPORTED_MODULE_1___default().createElement(FilterBox, { model: props.model, trans: props.trans })));\n};\n//# sourceMappingURL=filter.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/debugger/lib/panels/kernelSources/filter.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/debugger/lib/panels/kernelSources/index.js":
/*!******************************************************************************!*\
  !*** ../node_modules/@jupyterlab/debugger/lib/panels/kernelSources/index.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   KernelSources: () => (/* binding */ KernelSources)\n/* harmony export */ });\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/translation */ \"webpack/sharing/consume/default/@jupyterlab/translation/@jupyterlab/translation\");\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/apputils */ \"webpack/sharing/consume/default/@jupyterlab/apputils/@jupyterlab/apputils\");\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/ui-components */ \"webpack/sharing/consume/default/@jupyterlab/ui-components/@jupyterlab/ui-components\");\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var _body__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./body */ \"../node_modules/@jupyterlab/debugger/lib/panels/kernelSources/body.js\");\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\n\n\n/**\n * A Panel that shows a preview of the source code while debugging.\n */\nclass KernelSources extends _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__.PanelWithToolbar {\n    /**\n     * Instantiate a new Sources preview Panel.\n     *\n     * @param options The Sources instantiation options.\n     */\n    constructor(options) {\n        var _a;\n        super();\n        const { model, service } = options;\n        this._model = model;\n        const trans = ((_a = options.translator) !== null && _a !== void 0 ? _a : _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__.nullTranslator).load('jupyterlab');\n        this.title.label = trans.__('Kernel Sources');\n        this.toolbar.addClass('jp-DebuggerKernelSources-header');\n        this.toolbar.node.setAttribute('aria-label', trans.__('Kernel sources panel toolbar'));\n        this._body = new _body__WEBPACK_IMPORTED_MODULE_3__.KernelSourcesBody({\n            service,\n            model,\n            translator: options.translator\n        });\n        this.toolbar.addItem('open-filter', new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__.ToolbarButton({\n            icon: _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__.searchIcon,\n            onClick: async () => {\n                this._body.toggleFilterbox();\n            },\n            tooltip: trans.__('Toggle search filter')\n        }));\n        this.toolbar.addItem('refresh', new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__.ToolbarButton({\n            icon: _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__.refreshIcon,\n            onClick: () => {\n                this._model.kernelSources = [];\n                void service.displayModules().catch(reason => {\n                    void (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.showErrorMessage)(trans.__('Fail to get kernel sources'), trans.__('Fail to get kernel sources:\\n%2', reason));\n                });\n            },\n            tooltip: trans.__('Refresh kernel sources')\n        }));\n        this.addClass('jp-DebuggerKernelSources-header');\n        this.addWidget(this._body);\n        this.addClass('jp-DebuggerKenelSources');\n    }\n    set filter(filter) {\n        this._model.filter = filter;\n    }\n}\n//# sourceMappingURL=index.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/debugger/lib/panels/kernelSources/index.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/debugger/lib/panels/kernelSources/model.js":
/*!******************************************************************************!*\
  !*** ../node_modules/@jupyterlab/debugger/lib/panels/kernelSources/model.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   KernelSourcesModel: () => (/* binding */ KernelSourcesModel)\n/* harmony export */ });\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/signaling */ \"webpack/sharing/consume/default/@lumino/signaling/@lumino/signaling\");\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_signaling__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _lumino_polling__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/polling */ \"webpack/sharing/consume/default/@lumino/polling/@lumino/polling\");\n/* harmony import */ var _lumino_polling__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_polling__WEBPACK_IMPORTED_MODULE_1__);\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\n/**\n * The rate limit for the filter debouncer\n */\nconst DEBOUNCER_RATE_LIMIT_MS = 500;\nconst compare = (a, b) => {\n    if (a.name < b.name) {\n        return -1;\n    }\n    if (a.name > b.name) {\n        return 1;\n    }\n    return 0;\n};\n/**\n * The model to keep track of the current source being displayed.\n */\nclass KernelSourcesModel {\n    constructor() {\n        this._filteredKernelSources = null;\n        this._filter = '';\n        this._isDisposed = false;\n        this._kernelSources = null;\n        this._changed = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal(this);\n        this._filterChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal(this);\n        this._kernelSourceOpened = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal(this);\n        this.refresh = this.refresh.bind(this);\n        this._refreshDebouncer = new _lumino_polling__WEBPACK_IMPORTED_MODULE_1__.Debouncer(this.refresh, DEBOUNCER_RATE_LIMIT_MS);\n    }\n    /**\n     * Get the filter.\n     */\n    get filter() {\n        return this._filter;\n    }\n    /**\n     * Set the filter.\n     * The update\n     */\n    set filter(filter) {\n        this._filter = filter;\n        this._filterChanged.emit(filter);\n        void this._refreshDebouncer.invoke();\n    }\n    /**\n     * Whether the kernel sources model is disposed or not.\n     */\n    get isDisposed() {\n        return this._isDisposed;\n    }\n    /**\n     * Get the kernel sources.\n     */\n    get kernelSources() {\n        return this._kernelSources;\n    }\n    /**\n     * Set the kernel sources and emit a changed signal.\n     */\n    set kernelSources(kernelSources) {\n        this._kernelSources = kernelSources;\n        this.refresh();\n    }\n    /**\n     * Signal emitted when the current source changes.\n     */\n    get changed() {\n        return this._changed;\n    }\n    /**\n     * Signal emitted when the current source changes.\n     */\n    get filterChanged() {\n        return this._filterChanged;\n    }\n    /**\n     * Signal emitted when a kernel source should be open in the main area.\n     */\n    get kernelSourceOpened() {\n        return this._kernelSourceOpened;\n    }\n    /**\n     * Dispose the kernel sources model\n     */\n    dispose() {\n        if (this._isDisposed) {\n            return;\n        }\n        this._isDisposed = true;\n        this._refreshDebouncer.dispose();\n        _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal.clearData(this);\n    }\n    /**\n     * Open a source in the main area.\n     */\n    open(kernelSource) {\n        this._kernelSourceOpened.emit(kernelSource);\n    }\n    getFilteredKernelSources() {\n        const regexp = new RegExp(this._filter);\n        return this._kernelSources.filter(module => regexp.test(module.name));\n    }\n    refresh() {\n        if (this._kernelSources) {\n            this._filteredKernelSources = this._filter\n                ? this.getFilteredKernelSources()\n                : this._kernelSources;\n            this._filteredKernelSources.sort(compare);\n        }\n        else {\n            this._kernelSources = new Array();\n            this._filteredKernelSources = new Array();\n        }\n        this._changed.emit(this._filteredKernelSources);\n    }\n}\n//# sourceMappingURL=model.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/debugger/lib/panels/kernelSources/model.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/debugger/lib/panels/sources/body.js":
/*!***********************************************************************!*\
  !*** ../node_modules/@jupyterlab/debugger/lib/panels/sources/body.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   SourcesBody: () => (/* binding */ SourcesBody)\n/* harmony export */ });\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/signaling */ \"webpack/sharing/consume/default/@lumino/signaling/@lumino/signaling\");\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_signaling__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/widgets */ \"webpack/sharing/consume/default/@lumino/widgets/@lumino/widgets\");\n/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_widgets__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../.. */ \"../node_modules/@jupyterlab/debugger/lib/debugger.js\");\n/* harmony import */ var _handlers_editor__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../handlers/editor */ \"../node_modules/@jupyterlab/debugger/lib/handlers/editor.js\");\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\n\n\n/**\n * The body for a Sources Panel.\n */\nclass SourcesBody extends _lumino_widgets__WEBPACK_IMPORTED_MODULE_1__.Widget {\n    /**\n     * Instantiate a new Body for the SourcesBody widget.\n     *\n     * @param options The instantiation options for a SourcesBody.\n     */\n    constructor(options) {\n        super();\n        this._model = options.model;\n        this._debuggerService = options.service;\n        this._mimeTypeService = options.editorServices.mimeTypeService;\n        const factory = new ___WEBPACK_IMPORTED_MODULE_2__.Debugger.ReadOnlyEditorFactory({\n            editorServices: options.editorServices\n        });\n        this._editor = factory.createNewEditor({\n            content: '',\n            mimeType: '',\n            path: ''\n        });\n        this._editor.hide();\n        this._model.currentFrameChanged.connect(async (_, frame) => {\n            if (!frame) {\n                this._clearEditor();\n                return;\n            }\n            void this._showSource(frame);\n        });\n        const layout = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_1__.PanelLayout();\n        layout.addWidget(this._editor);\n        this.layout = layout;\n        this.addClass('jp-DebuggerSources-body');\n    }\n    /**\n     * Dispose the sources body widget.\n     */\n    dispose() {\n        var _a;\n        if (this.isDisposed) {\n            return;\n        }\n        (_a = this._editorHandler) === null || _a === void 0 ? void 0 : _a.dispose();\n        _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal.clearData(this);\n        super.dispose();\n    }\n    /**\n     * Clear the content of the source read-only editor.\n     */\n    _clearEditor() {\n        this._model.currentSource = null;\n        this._editor.hide();\n    }\n    /**\n     * Show the content of the source for the given frame.\n     *\n     * @param frame The current frame.\n     */\n    async _showSource(frame) {\n        var _a;\n        const path = (_a = frame.source) === null || _a === void 0 ? void 0 : _a.path;\n        const source = await this._debuggerService.getSource({\n            sourceReference: 0,\n            path\n        });\n        if (!(source === null || source === void 0 ? void 0 : source.content)) {\n            this._clearEditor();\n            return;\n        }\n        if (this._editorHandler) {\n            this._editorHandler.dispose();\n        }\n        const { content, mimeType } = source;\n        const editorMimeType = mimeType || this._mimeTypeService.getMimeTypeByFilePath(path !== null && path !== void 0 ? path : '');\n        this._editor.model.sharedModel.setSource(content);\n        this._editor.model.mimeType = editorMimeType;\n        this._editorHandler = new _handlers_editor__WEBPACK_IMPORTED_MODULE_3__.EditorHandler({\n            debuggerService: this._debuggerService,\n            editorReady: () => Promise.resolve(this._editor.editor),\n            getEditor: () => this._editor.editor,\n            path,\n            src: this._editor.model.sharedModel\n        });\n        this._model.currentSource = {\n            content,\n            mimeType: editorMimeType,\n            path: path !== null && path !== void 0 ? path : ''\n        };\n        requestAnimationFrame(() => {\n            _handlers_editor__WEBPACK_IMPORTED_MODULE_3__.EditorHandler.showCurrentLine(this._editor.editor, frame.line);\n        });\n        this._editor.show();\n    }\n}\n//# sourceMappingURL=body.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/debugger/lib/panels/sources/body.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/debugger/lib/panels/sources/index.js":
/*!************************************************************************!*\
  !*** ../node_modules/@jupyterlab/debugger/lib/panels/sources/index.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Sources: () => (/* binding */ Sources)\n/* harmony export */ });\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/translation */ \"webpack/sharing/consume/default/@jupyterlab/translation/@jupyterlab/translation\");\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/ui-components */ \"webpack/sharing/consume/default/@jupyterlab/ui-components/@jupyterlab/ui-components\");\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ \"webpack/sharing/consume/default/react/react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var _body__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./body */ \"../node_modules/@jupyterlab/debugger/lib/panels/sources/body.js\");\n/* harmony import */ var _sourcepath__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./sourcepath */ \"../node_modules/@jupyterlab/debugger/lib/panels/sources/sourcepath.js\");\n/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n\n\n\n\n/**\n * A Panel that shows a preview of the source code while debugging.\n */\nclass Sources extends _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.PanelWithToolbar {\n    /**\n     * Instantiate a new Sources preview Panel.\n     *\n     * @param options The Sources instantiation options.\n     */\n    constructor(options) {\n        var _a;\n        super();\n        const { model, service, editorServices } = options;\n        const trans = ((_a = options.translator) !== null && _a !== void 0 ? _a : _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__.nullTranslator).load('jupyterlab');\n        this.title.label = trans.__('Source');\n        this.toolbar.addClass('jp-DebuggerSources-header');\n        this.toolbar.node.setAttribute('aria-label', trans.__('Sources preview panel toolbar'));\n        const body = new _body__WEBPACK_IMPORTED_MODULE_3__.SourcesBody({\n            service,\n            model,\n            editorServices\n        });\n        this.toolbar.addItem('open', new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.ToolbarButton({\n            icon: _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.viewBreakpointIcon,\n            onClick: () => model.open(),\n            tooltip: trans.__('Open in the Main Area')\n        }));\n        const sourcePath = _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.ReactWidget.create(react__WEBPACK_IMPORTED_MODULE_2___default().createElement(_sourcepath__WEBPACK_IMPORTED_MODULE_4__.SourcePathComponent, { model: model, trans: trans }));\n        this.toolbar.addItem('sourcePath', sourcePath);\n        this.addClass('jp-DebuggerSources-header');\n        this.addWidget(body);\n        this.addClass('jp-DebuggerSources');\n    }\n}\n//# sourceMappingURL=index.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/debugger/lib/panels/sources/index.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/debugger/lib/panels/sources/model.js":
/*!************************************************************************!*\
  !*** ../node_modules/@jupyterlab/debugger/lib/panels/sources/model.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   SourcesModel: () => (/* binding */ SourcesModel)\n/* harmony export */ });\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/signaling */ \"webpack/sharing/consume/default/@lumino/signaling/@lumino/signaling\");\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_signaling__WEBPACK_IMPORTED_MODULE_0__);\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n/**\n * The model to keep track of the current source being displayed.\n */\nclass SourcesModel {\n    /**\n     * Instantiate a new Sources.Model\n     *\n     * @param options The Sources.Model instantiation options.\n     */\n    constructor(options) {\n        this._currentSourceOpened = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal(this);\n        this._currentSourceChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal(this);\n        this.currentFrameChanged = options.currentFrameChanged;\n    }\n    /**\n     * Signal emitted when a source should be open in the main area.\n     */\n    get currentSourceOpened() {\n        return this._currentSourceOpened;\n    }\n    /**\n     * Signal emitted when the current source changes.\n     */\n    get currentSourceChanged() {\n        return this._currentSourceChanged;\n    }\n    /**\n     * Return the current source.\n     */\n    get currentSource() {\n        return this._currentSource;\n    }\n    /**\n     * Set the current source.\n     *\n     * @param source The source to set as the current source.\n     */\n    set currentSource(source) {\n        this._currentSource = source;\n        this._currentSourceChanged.emit(source);\n    }\n    /**\n     * Open a source in the main area.\n     */\n    open() {\n        this._currentSourceOpened.emit(this._currentSource);\n    }\n}\n//# sourceMappingURL=model.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/debugger/lib/panels/sources/model.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/debugger/lib/panels/sources/sourcepath.js":
/*!*****************************************************************************!*\
  !*** ../node_modules/@jupyterlab/debugger/lib/panels/sources/sourcepath.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   SourcePathComponent: () => (/* binding */ SourcePathComponent)\n/* harmony export */ });\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/ui-components */ \"webpack/sharing/consume/default/@jupyterlab/ui-components/@jupyterlab/ui-components\");\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ \"webpack/sharing/consume/default/react/react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\n/**\n * A React component to display the path to a source.\n *\n * @param {object} props The component props.\n * @param props.model The model for the sources.\n */\nconst SourcePathComponent = ({ model, trans }) => {\n    return (react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.UseSignal, { signal: model.currentSourceChanged, initialSender: model }, (model) => {\n        var _a, _b;\n        return (react__WEBPACK_IMPORTED_MODULE_1___default().createElement(\"span\", { onClick: (event) => {\n                if (event.ctrlKey) {\n                    model === null || model === void 0 ? void 0 : model.open();\n                }\n            }, title: trans.__('Ctrl + click to open in the Main Area'), className: \"jp-DebuggerSources-header-path\" }, (_b = (_a = model === null || model === void 0 ? void 0 : model.currentSource) === null || _a === void 0 ? void 0 : _a.path) !== null && _b !== void 0 ? _b : ''));\n    }));\n};\n//# sourceMappingURL=sourcepath.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/debugger/lib/panels/sources/sourcepath.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/debugger/lib/panels/variables/grid.js":
/*!*************************************************************************!*\
  !*** ../node_modules/@jupyterlab/debugger/lib/panels/variables/grid.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   VariablesBodyGrid: () => (/* binding */ VariablesBodyGrid)\n/* harmony export */ });\n/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/widgets */ \"webpack/sharing/consume/default/@lumino/widgets/@lumino/widgets\");\n/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_widgets__WEBPACK_IMPORTED_MODULE_0__);\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n/**\n * A data grid that displays variables in a debugger session.\n */\nclass VariablesBodyGrid extends _lumino_widgets__WEBPACK_IMPORTED_MODULE_0__.Panel {\n    /**\n     * Instantiate a new VariablesBodyGrid.\n     *\n     * @param options The instantiation options for a VariablesBodyGrid.\n     */\n    constructor(options) {\n        super();\n        this._filter = new Set();\n        this._grid = null;\n        this._pending = null;\n        this.commands = options.commands;\n        this.model = options.model;\n        this.themeManager = options.themeManager;\n        this.translator = options.translator;\n        this.model.changed.connect(() => this.update(), this);\n        this.addClass('jp-DebuggerVariables-body');\n    }\n    /**\n     * The variable filter list.\n     */\n    get filter() {\n        return this._filter;\n    }\n    set filter(filter) {\n        this._filter = filter;\n        this.update();\n    }\n    /**\n     * The current scope of the variables.\n     */\n    get scope() {\n        return this._scope;\n    }\n    set scope(scope) {\n        this._scope = scope;\n        if (scope !== 'Globals') {\n            this.addClass('jp-debuggerVariables-local');\n        }\n        else {\n            this.removeClass('jp-debuggerVariables-local');\n        }\n        this.update();\n    }\n    /**\n     * Load the grid panel implementation and instantiate a grid.\n     */\n    async initialize() {\n        if (this._grid || this._pending) {\n            return;\n        }\n        // Lazily load the datagrid module when the first grid is requested.\n        const { Grid } = await (this._pending = Promise.all(/*! import() */[__webpack_require__.e(\"vendors-node_modules_jupyterlab_debugger_lib_panels_variables_gridpanel_js\"), __webpack_require__.e(\"webpack_sharing_consume_default_lumino_messaging_lumino_messaging\"), __webpack_require__.e(\"webpack_sharing_consume_default_lumino_domutils_lumino_domutils\"), __webpack_require__.e(\"webpack_sharing_consume_default_lumino_dragdrop_lumino_dragdrop\"), __webpack_require__.e(\"webpack_sharing_consume_default_lumino_keyboard_lumino_keyboard\")]).then(__webpack_require__.bind(__webpack_require__, /*! ./gridpanel */ \"../node_modules/@jupyterlab/debugger/lib/panels/variables/gridpanel.js\")));\n        const { commands, model, themeManager, translator } = this;\n        this._grid = new Grid({ commands, model, themeManager, translator });\n        this._grid.addClass('jp-DebuggerVariables-grid');\n        this._pending = null;\n        this.addWidget(this._grid);\n        this.update();\n    }\n    /**\n     * Wait until actually displaying the grid to trigger initialization.\n     */\n    onBeforeShow(msg) {\n        if (!this._grid && !this._pending) {\n            void this.initialize();\n        }\n        super.onBeforeShow(msg);\n    }\n    /**\n     * Handle `update-request` messages.\n     */\n    onUpdateRequest(msg) {\n        var _a;\n        if (this._grid) {\n            const { dataModel } = this._grid;\n            dataModel.filter = this._filter;\n            dataModel.scope = this._scope;\n            dataModel.setData((_a = this.model.scopes) !== null && _a !== void 0 ? _a : []);\n        }\n        super.onUpdateRequest(msg);\n    }\n}\n//# sourceMappingURL=grid.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/debugger/lib/panels/variables/grid.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/debugger/lib/panels/variables/index.js":
/*!**************************************************************************!*\
  !*** ../node_modules/@jupyterlab/debugger/lib/panels/variables/index.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Variables: () => (/* binding */ Variables),\n/* harmony export */   convertType: () => (/* binding */ convertType)\n/* harmony export */ });\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/translation */ \"webpack/sharing/consume/default/@jupyterlab/translation/@jupyterlab/translation\");\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/ui-components */ \"webpack/sharing/consume/default/@jupyterlab/ui-components/@jupyterlab/ui-components\");\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _grid__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./grid */ \"../node_modules/@jupyterlab/debugger/lib/panels/variables/grid.js\");\n/* harmony import */ var _scope__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./scope */ \"../node_modules/@jupyterlab/debugger/lib/panels/variables/scope.js\");\n/* harmony import */ var _tree__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./tree */ \"../node_modules/@jupyterlab/debugger/lib/panels/variables/tree.js\");\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\n\n\n\n/**\n * A Panel to show a variable explorer.\n */\nclass Variables extends _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.PanelWithToolbar {\n    /**\n     * Instantiate a new Variables Panel.\n     *\n     * @param options The instantiation options for a Variables Panel.\n     */\n    constructor(options) {\n        super(options);\n        const { model, service, commands, themeManager } = options;\n        const translator = options.translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__.nullTranslator;\n        const trans = translator.load('jupyterlab');\n        this.title.label = trans.__('Variables');\n        this.toolbar.addClass('jp-DebuggerVariables-toolbar');\n        this.toolbar.node.setAttribute('aria-label', trans.__('Variables toolbar'));\n        this._tree = new _tree__WEBPACK_IMPORTED_MODULE_2__.VariablesBodyTree({\n            model,\n            service,\n            commands,\n            translator\n        });\n        this._table = new _grid__WEBPACK_IMPORTED_MODULE_3__.VariablesBodyGrid({\n            model,\n            commands,\n            themeManager,\n            translator\n        });\n        this._table.hide();\n        this.toolbar.addItem('scope-switcher', new _scope__WEBPACK_IMPORTED_MODULE_4__.ScopeSwitcher({\n            translator,\n            model,\n            tree: this._tree,\n            grid: this._table\n        }));\n        const onViewChange = () => {\n            if (this._table.isHidden) {\n                this._tree.hide();\n                this._table.show();\n                this.node.setAttribute('data-jp-table', 'true');\n                markViewButtonSelection('table');\n            }\n            else {\n                this._tree.show();\n                this._table.hide();\n                this.node.removeAttribute('data-jp-table');\n                markViewButtonSelection('tree');\n            }\n            this.update();\n        };\n        const treeViewButton = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.ToolbarButton({\n            icon: _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.treeViewIcon,\n            className: 'jp-TreeView-Button',\n            onClick: onViewChange,\n            tooltip: trans.__('Tree View')\n        });\n        const tableViewButton = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.ToolbarButton({\n            icon: _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.tableRowsIcon,\n            className: 'jp-TableView-Button',\n            onClick: onViewChange,\n            tooltip: trans.__('Table View')\n        });\n        const markViewButtonSelection = (selectedView) => {\n            tableViewButton.pressed = selectedView !== 'tree';\n            treeViewButton.pressed = !tableViewButton.pressed;\n        };\n        markViewButtonSelection(this._table.isHidden ? 'tree' : 'table');\n        this.toolbar.addItem('view-VariableTreeView', treeViewButton);\n        this.toolbar.addItem('view-VariableTableView', tableViewButton);\n        this.addWidget(this._tree);\n        this.addWidget(this._table);\n        this.addClass('jp-DebuggerVariables');\n    }\n    /**\n     * Set the variable filter for both the tree and table views.\n     */\n    set filter(filter) {\n        this._tree.filter = filter;\n        this._table.filter = filter;\n    }\n    /**\n     * A message handler invoked on a `'resize'` message.\n     *\n     * @param msg The Lumino message to process.\n     */\n    onResize(msg) {\n        super.onResize(msg);\n        this._resizeBody(msg);\n    }\n    /**\n     * Resize the body.\n     *\n     * @param msg The resize message.\n     */\n    _resizeBody(msg) {\n        const height = msg.height - this.toolbar.node.offsetHeight;\n        this._tree.node.style.height = `${height}px`;\n    }\n}\n/**\n * Convert a variable to a primitive type.\n *\n * @param variable The variable.\n */\nconst convertType = (variable) => {\n    var _a, _b;\n    const { type, value } = variable;\n    switch (type) {\n        case 'int':\n            return parseInt(value, 10);\n        case 'float':\n            return parseFloat(value);\n        case 'bool':\n            return value;\n        case 'str':\n            if ((_b = (_a = variable.presentationHint) === null || _a === void 0 ? void 0 : _a.attributes) === null || _b === void 0 ? void 0 : _b.includes('rawString')) {\n                return value.slice(1, value.length - 1);\n            }\n            else {\n                return value;\n            }\n        default:\n            return type !== null && type !== void 0 ? type : value;\n    }\n};\n//# sourceMappingURL=index.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/debugger/lib/panels/variables/index.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/debugger/lib/panels/variables/mimerenderer.js":
/*!*********************************************************************************!*\
  !*** ../node_modules/@jupyterlab/debugger/lib/panels/variables/mimerenderer.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   VariableMimeRenderer: () => (/* binding */ VariableMimeRenderer)\n/* harmony export */ });\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/apputils */ \"webpack/sharing/consume/default/@jupyterlab/apputils/@jupyterlab/apputils\");\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/rendermime */ \"webpack/sharing/consume/default/@jupyterlab/rendermime/@jupyterlab/rendermime\");\n/* harmony import */ var _jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/translation */ \"webpack/sharing/consume/default/@jupyterlab/translation/@jupyterlab/translation\");\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_translation__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @lumino/coreutils */ \"webpack/sharing/consume/default/@lumino/coreutils/@lumino/coreutils\");\n/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_3__);\n/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @lumino/widgets */ \"webpack/sharing/consume/default/@lumino/widgets/@lumino/widgets\");\n/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_lumino_widgets__WEBPACK_IMPORTED_MODULE_4__);\n/* harmony import */ var _hash__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../hash */ \"../node_modules/@jupyterlab/debugger/lib/hash.js\");\n/*\n * Copyright (c) Jupyter Development Team.\n * Distributed under the terms of the Modified BSD License.\n */\n\n\n\n\n\n\nconst RENDERER_PANEL_CLASS = 'jp-VariableRendererPanel';\nconst RENDERER_PANEL_RENDERER_CLASS = 'jp-VariableRendererPanel-renderer';\n/**\n * Debugger variable mime type renderer\n */\nclass VariableMimeRenderer extends _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.MainAreaWidget {\n    /**\n     * Instantiate a new VariableMimeRenderer.\n     */\n    constructor(options) {\n        const { dataLoader, rendermime, translator } = options;\n        const content = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_4__.Panel();\n        const loaded = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_3__.PromiseDelegate();\n        super({\n            content,\n            reveal: Promise.all([dataLoader, loaded.promise])\n        });\n        this.content.addClass(RENDERER_PANEL_CLASS);\n        this.trans = (translator !== null && translator !== void 0 ? translator : _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_2__.nullTranslator).load('jupyterlab');\n        this.dataLoader = dataLoader;\n        this.renderMime = rendermime;\n        this._dataHash = null;\n        this.refresh()\n            .then(() => {\n            loaded.resolve();\n        })\n            .catch(reason => loaded.reject(reason));\n    }\n    /**\n     * Refresh the variable view\n     */\n    async refresh(force = false) {\n        let data = await this.dataLoader();\n        if (Object.keys(data.data).length === 0) {\n            data = {\n                data: {\n                    'text/plain': this.trans.__('The variable is undefined in the active context.')\n                },\n                metadata: {}\n            };\n        }\n        if (data.data) {\n            const hash = (0,_hash__WEBPACK_IMPORTED_MODULE_5__.murmur2)(JSON.stringify(data), 17);\n            if (force || this._dataHash !== hash) {\n                if (this.content.layout) {\n                    this.content.widgets.forEach(w => {\n                        this.content.layout.removeWidget(w);\n                    });\n                }\n                // We trust unconditionally the data as the user is required to\n                // execute the code to load a particular variable in memory\n                const mimeType = this.renderMime.preferredMimeType(data.data, 'any');\n                if (mimeType) {\n                    const widget = this.renderMime.createRenderer(mimeType);\n                    widget.addClass(RENDERER_PANEL_RENDERER_CLASS);\n                    const model = new _jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_1__.MimeModel({ ...data, trusted: true });\n                    this._dataHash = hash;\n                    await widget.renderModel(model);\n                    this.content.addWidget(widget);\n                }\n                else {\n                    this._dataHash = null;\n                    return Promise.reject('Unable to determine the preferred mime type.');\n                }\n            }\n        }\n        else {\n            this._dataHash = null;\n            return Promise.reject('Unable to get a view on the variable.');\n        }\n    }\n}\n//# sourceMappingURL=mimerenderer.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/debugger/lib/panels/variables/mimerenderer.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/debugger/lib/panels/variables/model.js":
/*!**************************************************************************!*\
  !*** ../node_modules/@jupyterlab/debugger/lib/panels/variables/model.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   VariablesModel: () => (/* binding */ VariablesModel)\n/* harmony export */ });\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/signaling */ \"webpack/sharing/consume/default/@lumino/signaling/@lumino/signaling\");\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_signaling__WEBPACK_IMPORTED_MODULE_0__);\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n/**\n * A model for a variable explorer.\n */\nclass VariablesModel {\n    constructor() {\n        this._selectedVariable = null;\n        this._state = [];\n        this._variableExpanded = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal(this);\n        this._changed = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal(this);\n    }\n    /**\n     * Get all the scopes.\n     */\n    get scopes() {\n        return this._state;\n    }\n    /**\n     * Set the scopes.\n     */\n    set scopes(scopes) {\n        this._state = scopes;\n        this._changed.emit();\n    }\n    /**\n     * Signal emitted when the current variable has changed.\n     */\n    get changed() {\n        return this._changed;\n    }\n    /**\n     * Signal emitted when the current variable has been expanded.\n     */\n    get variableExpanded() {\n        return this._variableExpanded;\n    }\n    get selectedVariable() {\n        return this._selectedVariable;\n    }\n    set selectedVariable(selection) {\n        this._selectedVariable = selection;\n    }\n    /**\n     * Expand a variable.\n     *\n     * @param variable The variable to expand.\n     */\n    expandVariable(variable) {\n        this._variableExpanded.emit(variable);\n    }\n}\n//# sourceMappingURL=model.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/debugger/lib/panels/variables/model.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/debugger/lib/panels/variables/scope.js":
/*!**************************************************************************!*\
  !*** ../node_modules/@jupyterlab/debugger/lib/panels/variables/scope.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ScopeSwitcher: () => (/* binding */ ScopeSwitcher)\n/* harmony export */ });\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/translation */ \"webpack/sharing/consume/default/@jupyterlab/translation/@jupyterlab/translation\");\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/ui-components */ \"webpack/sharing/consume/default/@jupyterlab/ui-components/@jupyterlab/ui-components\");\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ \"webpack/sharing/consume/default/react/react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);\n/*\n * Copyright (c) Jupyter Development Team.\n * Distributed under the terms of the Modified BSD License.\n */\n\n\n\n/**\n * A React component to handle scope changes.\n *\n * @param {object} props The component props.\n * @param props.model The variables model.\n * @param props.tree The variables tree widget.\n * @param props.grid The variables grid widget.\n * @param props.trans The translation bundle.\n */\nconst ScopeSwitcherComponent = ({ model, tree, grid, trans }) => {\n    const [value, setValue] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)('-');\n    const scopes = model.scopes;\n    const onChange = (event) => {\n        const value = event.target.value;\n        setValue(value);\n        tree.scope = value;\n        grid.scope = value;\n    };\n    return (react__WEBPACK_IMPORTED_MODULE_2___default().createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.HTMLSelect, { onChange: onChange, value: value, \"aria-label\": trans.__('Scope') }, scopes.map(scope => (react__WEBPACK_IMPORTED_MODULE_2___default().createElement(\"option\", { key: scope.name, value: scope.name }, trans.__(scope.name))))));\n};\n/**\n * A widget to switch between scopes.\n */\nclass ScopeSwitcher extends _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.ReactWidget {\n    /**\n     * Instantiate a new scope switcher.\n     *\n     * @param options The instantiation options for a ScopeSwitcher\n     */\n    constructor(options) {\n        super();\n        const { translator, model, tree, grid } = options;\n        this._model = model;\n        this._tree = tree;\n        this._grid = grid;\n        this._trans = (translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__.nullTranslator).load('jupyterlab');\n    }\n    /**\n     * Render the scope switcher.\n     */\n    render() {\n        return (react__WEBPACK_IMPORTED_MODULE_2___default().createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.UseSignal, { signal: this._model.changed, initialSender: this._model }, () => (react__WEBPACK_IMPORTED_MODULE_2___default().createElement(ScopeSwitcherComponent, { model: this._model, trans: this._trans, tree: this._tree, grid: this._grid }))));\n    }\n}\n//# sourceMappingURL=scope.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/debugger/lib/panels/variables/scope.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/debugger/lib/panels/variables/tree.js":
/*!*************************************************************************!*\
  !*** ../node_modules/@jupyterlab/debugger/lib/panels/variables/tree.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   VariablesBodyTree: () => (/* binding */ VariablesBodyTree)\n/* harmony export */ });\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/translation */ \"webpack/sharing/consume/default/@jupyterlab/translation/@jupyterlab/translation\");\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/ui-components */ \"webpack/sharing/consume/default/@jupyterlab/ui-components/@jupyterlab/ui-components\");\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _jupyter_react_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyter/react-components */ \"webpack/sharing/consume/default/@jupyter/react-components/@jupyter/react-components\");\n/* harmony import */ var _jupyter_react_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyter_react_components__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @lumino/algorithm */ \"webpack/sharing/consume/default/@lumino/algorithm/@lumino/algorithm\");\n/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_lumino_algorithm__WEBPACK_IMPORTED_MODULE_3__);\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react */ \"webpack/sharing/consume/default/react/react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);\n/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! . */ \"../node_modules/@jupyterlab/debugger/lib/panels/variables/index.js\");\n/* harmony import */ var _debugger__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../debugger */ \"../node_modules/@jupyterlab/debugger/lib/debugger.js\");\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\n\n\n\n\n\n/**\n * The body for tree of variables.\n */\nclass VariablesBodyTree extends _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.ReactWidget {\n    /**\n     * Instantiate a new Body for the tree of variables.\n     *\n     * @param options The instantiation options for a VariablesBodyTree.\n     */\n    constructor(options) {\n        super();\n        this._scope = '';\n        this._scopes = [];\n        this._filter = new Set();\n        this._commands = options.commands;\n        this._service = options.service;\n        this._translator = options.translator;\n        const model = (this.model = options.model);\n        model.changed.connect(this._updateScopes, this);\n        this.addClass('jp-DebuggerVariables-body');\n    }\n    /**\n     * Render the VariablesBodyTree.\n     */\n    render() {\n        var _a;\n        const scope = (_a = this._scopes.find(scope => scope.name === this._scope)) !== null && _a !== void 0 ? _a : this._scopes[0];\n        const handleSelectVariable = (variable) => {\n            this.model.selectedVariable = variable;\n        };\n        if ((scope === null || scope === void 0 ? void 0 : scope.name) !== 'Globals') {\n            this.addClass('jp-debuggerVariables-local');\n        }\n        else {\n            this.removeClass('jp-debuggerVariables-local');\n        }\n        return scope ? (react__WEBPACK_IMPORTED_MODULE_4___default().createElement((react__WEBPACK_IMPORTED_MODULE_4___default().Fragment), null,\n            react__WEBPACK_IMPORTED_MODULE_4___default().createElement(_jupyter_react_components__WEBPACK_IMPORTED_MODULE_2__.TreeView, { className: \"jp-TreeView\" },\n                react__WEBPACK_IMPORTED_MODULE_4___default().createElement(VariablesBranch, { key: scope.name, commands: this._commands, service: this._service, data: scope.variables, filter: this._filter, translator: this._translator, handleSelectVariable: handleSelectVariable })))) : (react__WEBPACK_IMPORTED_MODULE_4___default().createElement(\"div\", null));\n    }\n    /**\n     * Set the variable filter list.\n     */\n    set filter(filter) {\n        this._filter = filter;\n        this.update();\n    }\n    /**\n     * Set the current scope\n     */\n    set scope(scope) {\n        this._scope = scope;\n        this.update();\n    }\n    /**\n     * Update the scopes and the tree of variables.\n     *\n     * @param model The variables model.\n     */\n    _updateScopes(model) {\n        if (_lumino_algorithm__WEBPACK_IMPORTED_MODULE_3__.ArrayExt.shallowEqual(this._scopes, model.scopes)) {\n            return;\n        }\n        this._scopes = model.scopes;\n        this.update();\n    }\n}\n/**\n * A React component to display a list of variables.\n *\n * @param {object} props The component props.\n * @param props.data An array of variables.\n * @param props.service The debugger service.\n * @param props.filter Optional variable filter list.\n */\nconst VariablesBranch = (props) => {\n    const { commands, data, service, filter, translator, handleSelectVariable } = props;\n    const [variables, setVariables] = (0,react__WEBPACK_IMPORTED_MODULE_4__.useState)(data);\n    (0,react__WEBPACK_IMPORTED_MODULE_4__.useEffect)(() => {\n        setVariables(data);\n    }, [data]);\n    return (react__WEBPACK_IMPORTED_MODULE_4___default().createElement((react__WEBPACK_IMPORTED_MODULE_4___default().Fragment), null, variables\n        .filter(variable => !(filter || new Set()).has(variable.evaluateName || ''))\n        .map(variable => {\n        const key = `${variable.name}-${variable.evaluateName}-${variable.type}-${variable.value}-${variable.variablesReference}`;\n        return (react__WEBPACK_IMPORTED_MODULE_4___default().createElement(VariableComponent, { key: key, commands: commands, data: variable, service: service, filter: filter, translator: translator, onSelect: handleSelectVariable }));\n    })));\n};\nfunction _prepareDetail(variable) {\n    if (variable.type === 'float' &&\n        (variable.value == 'inf' || variable.value == '-inf')) {\n        return variable.value;\n    }\n    const detail = (0,___WEBPACK_IMPORTED_MODULE_5__.convertType)(variable);\n    if (variable.type === 'float' && isNaN(detail)) {\n        // silence React warning:\n        // `Received NaN for the `children` attribute. If this is expected, cast the value to a string`\n        return 'NaN';\n    }\n    return detail;\n}\n/**\n * A React component to display one node variable in tree.\n *\n * @param {object} props The component props.\n * @param props.data An array of variables.\n * @param props.service The debugger service.\n * @param props.filter Optional variable filter list.\n */\nconst VariableComponent = (props) => {\n    var _a, _b;\n    const { commands, data, service, filter, translator, onSelect } = props;\n    const [variable] = (0,react__WEBPACK_IMPORTED_MODULE_4__.useState)(data);\n    const [showDetailsButton, setShowDetailsButton] = (0,react__WEBPACK_IMPORTED_MODULE_4__.useState)(false);\n    const [expanded, setExpanded] = (0,react__WEBPACK_IMPORTED_MODULE_4__.useState)(false);\n    const [variables, setVariables] = (0,react__WEBPACK_IMPORTED_MODULE_4__.useState)(null);\n    const trans = (0,react__WEBPACK_IMPORTED_MODULE_4__.useMemo)(() => (translator !== null && translator !== void 0 ? translator : _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__.nullTranslator).load('jupyterlab'), [translator]);\n    const onSelection = onSelect !== null && onSelect !== void 0 ? onSelect : (() => void 0);\n    const expandable = (0,react__WEBPACK_IMPORTED_MODULE_4__.useMemo)(() => variable.variablesReference !== 0 || variable.type === 'function', [variable.variablesReference, variable.type]);\n    const details = (0,react__WEBPACK_IMPORTED_MODULE_4__.useMemo)(() => _prepareDetail(variable), [variable]);\n    const hasMimeRenderer = (0,react__WEBPACK_IMPORTED_MODULE_4__.useMemo)(() => ![\n        'special variables',\n        'protected variables',\n        'function variables',\n        'class variables'\n    ].includes(variable.name), [variable.name]);\n    const disableMimeRenderer = (0,react__WEBPACK_IMPORTED_MODULE_4__.useMemo)(() => {\n        var _a;\n        return !service.model.hasRichVariableRendering ||\n            !commands.isEnabled(_debugger__WEBPACK_IMPORTED_MODULE_6__.Debugger.CommandIDs.renderMimeVariable, {\n                name: variable.name,\n                frameID: (_a = service.model.callstack.frame) === null || _a === void 0 ? void 0 : _a.id\n            });\n    }, [\n        service.model.hasRichVariableRendering,\n        variable.name,\n        (_a = service.model.callstack.frame) === null || _a === void 0 ? void 0 : _a.id\n    ]);\n    const fetchChildren = (0,react__WEBPACK_IMPORTED_MODULE_4__.useCallback)(async () => {\n        if (expandable && !variables) {\n            setVariables(await service.inspectVariable(variable.variablesReference));\n        }\n    }, [expandable, service, variable.variablesReference, variables]);\n    const onVariableClicked = (0,react__WEBPACK_IMPORTED_MODULE_4__.useCallback)(async (event) => {\n        const item = (0,_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.getTreeItemElement)(event.target);\n        if (event.currentTarget !== item) {\n            return;\n        }\n        if (!expandable) {\n            return;\n        }\n        setExpanded(!expanded);\n    }, [expandable, expanded]);\n    const onSelectChange = (0,react__WEBPACK_IMPORTED_MODULE_4__.useCallback)((event) => {\n        if (event.currentTarget === event.detail && event.detail.selected) {\n            onSelection(variable);\n        }\n    }, [variable]);\n    const renderVariable = (0,react__WEBPACK_IMPORTED_MODULE_4__.useCallback)(() => {\n        var _a;\n        commands\n            .execute(_debugger__WEBPACK_IMPORTED_MODULE_6__.Debugger.CommandIDs.renderMimeVariable, {\n            name: variable.name,\n            frameID: (_a = service.model.callstack.frame) === null || _a === void 0 ? void 0 : _a.id\n        })\n            .catch(reason => {\n            console.error(`Failed to render variable ${variable === null || variable === void 0 ? void 0 : variable.name}`, reason);\n        });\n    }, [commands, variable.name, (_b = service.model.callstack.frame) === null || _b === void 0 ? void 0 : _b.id]);\n    const onContextMenu = (0,react__WEBPACK_IMPORTED_MODULE_4__.useCallback)((event) => {\n        const item = (0,_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.getTreeItemElement)(event.target);\n        if (event.currentTarget !== item) {\n            return;\n        }\n        onSelection(variable);\n    }, [variable]);\n    return (react__WEBPACK_IMPORTED_MODULE_4___default().createElement(_jupyter_react_components__WEBPACK_IMPORTED_MODULE_2__.TreeItem, { className: \"jp-TreeItem nested\", expanded: expanded, onSelect: onSelectChange, onExpand: fetchChildren, onClick: (e) => onVariableClicked(e), onContextMenu: onContextMenu, onKeyDown: event => {\n            if (event.key == 'Enter') {\n                if (hasMimeRenderer && showDetailsButton) {\n                    onSelection(variable);\n                    renderVariable();\n                }\n            }\n        }, onFocus: event => {\n            setShowDetailsButton(!event.defaultPrevented);\n            event.preventDefault();\n        }, onBlur: event => {\n            setShowDetailsButton(false);\n        }, onMouseOver: (event) => {\n            setShowDetailsButton(!event.defaultPrevented);\n            event.preventDefault();\n        }, onMouseLeave: (event) => {\n            setShowDetailsButton(false);\n        } },\n        react__WEBPACK_IMPORTED_MODULE_4___default().createElement(\"span\", { className: \"jp-DebuggerVariables-name\" }, variable.name),\n        details && (react__WEBPACK_IMPORTED_MODULE_4___default().createElement(\"span\", { className: \"jp-DebuggerVariables-detail\" }, details)),\n        hasMimeRenderer && showDetailsButton && (react__WEBPACK_IMPORTED_MODULE_4___default().createElement(_jupyter_react_components__WEBPACK_IMPORTED_MODULE_2__.Button, { className: \"jp-DebuggerVariables-renderVariable\", appearance: \"stealth\", slot: \"end\", disabled: disableMimeRenderer, onClick: e => {\n                e.stopPropagation();\n                renderVariable();\n            }, title: trans.__('Render variable: %1', variable === null || variable === void 0 ? void 0 : variable.name) },\n            react__WEBPACK_IMPORTED_MODULE_4___default().createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.searchIcon.react, { tag: null }))),\n        variables ? (react__WEBPACK_IMPORTED_MODULE_4___default().createElement(VariablesBranch, { key: variable.name, commands: commands, data: variables, service: service, filter: filter, translator: translator, handleSelectVariable: onSelect })) : (\n        /* Trick to ensure collapse button is displayed\n           when variables are not loaded yet */\n        expandable && react__WEBPACK_IMPORTED_MODULE_4___default().createElement(_jupyter_react_components__WEBPACK_IMPORTED_MODULE_2__.TreeItem, null))));\n};\n//# sourceMappingURL=tree.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/debugger/lib/panels/variables/tree.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/debugger/lib/service.js":
/*!***********************************************************!*\
  !*** ../node_modules/@jupyterlab/debugger/lib/service.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   DebuggerService: () => (/* binding */ DebuggerService)\n/* harmony export */ });\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/translation */ \"webpack/sharing/consume/default/@jupyterlab/translation/@jupyterlab/translation\");\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/signaling */ \"webpack/sharing/consume/default/@lumino/signaling/@lumino/signaling\");\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_signaling__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _debugger__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./debugger */ \"../node_modules/@jupyterlab/debugger/lib/debugger.js\");\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\n\n/**\n * A concrete implementation of the IDebugger interface.\n */\nclass DebuggerService {\n    /**\n     * Instantiate a new DebuggerService.\n     *\n     * @param options The instantiation options for a DebuggerService.\n     */\n    constructor(options) {\n        var _a, _b;\n        this._eventMessage = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__.Signal(this);\n        this._isDisposed = false;\n        this._sessionChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__.Signal(this);\n        this._pauseOnExceptionChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__.Signal(this);\n        this._config = options.config;\n        // Avoids setting session with invalid client\n        // session should be set only when a notebook or\n        // a console get the focus.\n        // TODO: also checks that the notebook or console\n        // runs a kernel with debugging ability\n        this._session = null;\n        this._specsManager = (_a = options.specsManager) !== null && _a !== void 0 ? _a : null;\n        this._model = new _debugger__WEBPACK_IMPORTED_MODULE_2__.Debugger.Model();\n        this._debuggerSources = (_b = options.debuggerSources) !== null && _b !== void 0 ? _b : null;\n        this._trans = (options.translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__.nullTranslator).load('jupyterlab');\n    }\n    /**\n     * Signal emitted for debug event messages.\n     */\n    get eventMessage() {\n        return this._eventMessage;\n    }\n    /**\n     * Get debugger config.\n     */\n    get config() {\n        return this._config;\n    }\n    /**\n     * Whether the debug service is disposed.\n     */\n    get isDisposed() {\n        return this._isDisposed;\n    }\n    /**\n     * Whether the current debugger is started.\n     */\n    get isStarted() {\n        var _a, _b;\n        return (_b = (_a = this._session) === null || _a === void 0 ? void 0 : _a.isStarted) !== null && _b !== void 0 ? _b : false;\n    }\n    /**\n     * A signal emitted when the pause on exception filter changes.\n     */\n    get pauseOnExceptionChanged() {\n        return this._pauseOnExceptionChanged;\n    }\n    /**\n     * Returns the debugger service's model.\n     */\n    get model() {\n        return this._model;\n    }\n    /**\n     * Returns the current debug session.\n     */\n    get session() {\n        return this._session;\n    }\n    /**\n     * Sets the current debug session to the given parameter.\n     *\n     * @param session - the new debugger session.\n     */\n    set session(session) {\n        var _a;\n        if (this._session === session) {\n            return;\n        }\n        if (this._session) {\n            this._session.dispose();\n        }\n        this._session = session;\n        (_a = this._session) === null || _a === void 0 ? void 0 : _a.eventMessage.connect((_, event) => {\n            if (event.event === 'stopped') {\n                this._model.stoppedThreads.clear();\n                this._model.stoppedThreads.add(event.body.threadId);\n                void this._getAllFrames();\n            }\n            else if (event.event === 'continued') {\n                this._model.stoppedThreads.delete(event.body.threadId);\n                this._clearModel();\n                this._clearSignals();\n            }\n            this._eventMessage.emit(event);\n        });\n        this._sessionChanged.emit(session);\n    }\n    /**\n     * Signal emitted upon session changed.\n     */\n    get sessionChanged() {\n        return this._sessionChanged;\n    }\n    /**\n     * Dispose the debug service.\n     */\n    dispose() {\n        if (this.isDisposed) {\n            return;\n        }\n        this._isDisposed = true;\n        _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__.Signal.clearData(this);\n    }\n    /**\n     * Computes an id based on the given code.\n     *\n     * @param code The source code.\n     */\n    getCodeId(code) {\n        var _a, _b, _c, _d;\n        try {\n            return this._config.getCodeId(code, (_d = (_c = (_b = (_a = this.session) === null || _a === void 0 ? void 0 : _a.connection) === null || _b === void 0 ? void 0 : _b.kernel) === null || _c === void 0 ? void 0 : _c.name) !== null && _d !== void 0 ? _d : '');\n        }\n        catch (_e) {\n            return '';\n        }\n    }\n    /**\n     * Whether there exists a thread in stopped state.\n     */\n    hasStoppedThreads() {\n        var _a, _b;\n        return (_b = ((_a = this._model) === null || _a === void 0 ? void 0 : _a.stoppedThreads.size) > 0) !== null && _b !== void 0 ? _b : false;\n    }\n    /**\n     * Request whether debugging is available for the session connection.\n     *\n     * @param connection The session connection.\n     */\n    async isAvailable(connection) {\n        var _a, _b, _c, _d;\n        if (!this._specsManager) {\n            return true;\n        }\n        await this._specsManager.ready;\n        const kernel = connection === null || connection === void 0 ? void 0 : connection.kernel;\n        if (!kernel) {\n            return false;\n        }\n        const name = kernel.name;\n        if (!((_a = this._specsManager.specs) === null || _a === void 0 ? void 0 : _a.kernelspecs[name])) {\n            return true;\n        }\n        return !!((_d = (_c = (_b = this._specsManager.specs.kernelspecs[name]) === null || _b === void 0 ? void 0 : _b.metadata) === null || _c === void 0 ? void 0 : _c['debugger']) !== null && _d !== void 0 ? _d : false);\n    }\n    /**\n     * Clear all the breakpoints for the current session.\n     */\n    async clearBreakpoints() {\n        var _a;\n        if (((_a = this.session) === null || _a === void 0 ? void 0 : _a.isStarted) !== true) {\n            return;\n        }\n        this._model.breakpoints.breakpoints.forEach((_, path, map) => {\n            void this._setBreakpoints([], path);\n        });\n        let bpMap = new Map();\n        this._model.breakpoints.restoreBreakpoints(bpMap);\n    }\n    /**\n     * Continues the execution of the current thread.\n     */\n    async continue() {\n        try {\n            if (!this.session) {\n                throw new Error('No active debugger session');\n            }\n            await this.session.sendRequest('continue', {\n                threadId: this._currentThread()\n            });\n            this._model.stoppedThreads.delete(this._currentThread());\n            this._clearModel();\n            this._clearSignals();\n        }\n        catch (err) {\n            console.error('Error:', err.message);\n        }\n    }\n    /**\n     * Retrieve the content of a source file.\n     *\n     * @param source The source object containing the path to the file.\n     */\n    async getSource(source) {\n        var _a, _b;\n        if (!this.session) {\n            throw new Error('No active debugger session');\n        }\n        const reply = await this.session.sendRequest('source', {\n            source,\n            sourceReference: (_a = source.sourceReference) !== null && _a !== void 0 ? _a : 0\n        });\n        return { ...reply.body, path: (_b = source.path) !== null && _b !== void 0 ? _b : '' };\n    }\n    /**\n     * Evaluate an expression.\n     *\n     * @param expression The expression to evaluate as a string.\n     */\n    async evaluate(expression) {\n        var _a;\n        if (!this.session) {\n            throw new Error('No active debugger session');\n        }\n        const frameId = (_a = this.model.callstack.frame) === null || _a === void 0 ? void 0 : _a.id;\n        const reply = await this.session.sendRequest('evaluate', {\n            context: 'repl',\n            expression,\n            frameId\n        });\n        if (!reply.success) {\n            return null;\n        }\n        // get the frames to retrieve the latest state of the variables\n        this._clearModel();\n        await this._getAllFrames();\n        return reply.body;\n    }\n    /**\n     * Makes the current thread run again for one step.\n     */\n    async next() {\n        try {\n            if (!this.session) {\n                throw new Error('No active debugger session');\n            }\n            await this.session.sendRequest('next', {\n                threadId: this._currentThread()\n            });\n        }\n        catch (err) {\n            console.error('Error:', err.message);\n        }\n    }\n    /**\n     * Request rich representation of a variable.\n     *\n     * @param variableName The variable name to request\n     * @param frameId The current frame id in which to request the variable\n     * @returns The mime renderer data model\n     */\n    async inspectRichVariable(variableName, frameId) {\n        if (!this.session) {\n            throw new Error('No active debugger session');\n        }\n        const reply = await this.session.sendRequest('richInspectVariables', {\n            variableName,\n            frameId\n        });\n        if (reply.success) {\n            return reply.body;\n        }\n        else {\n            throw new Error(reply.message);\n        }\n    }\n    /**\n     * Request variables for a given variable reference.\n     *\n     * @param variablesReference The variable reference to request.\n     */\n    async inspectVariable(variablesReference) {\n        if (!this.session) {\n            throw new Error('No active debugger session');\n        }\n        const reply = await this.session.sendRequest('variables', {\n            variablesReference\n        });\n        if (reply.success) {\n            return reply.body.variables;\n        }\n        else {\n            throw new Error(reply.message);\n        }\n    }\n    /**\n     * Request to set a variable in the global scope.\n     *\n     * @param name The name of the variable.\n     */\n    async copyToGlobals(name) {\n        if (!this.session) {\n            throw new Error('No active debugger session');\n        }\n        if (!this.model.supportCopyToGlobals) {\n            throw new Error('The \"copyToGlobals\" request is not supported by the kernel');\n        }\n        const frames = this.model.callstack.frames;\n        this.session\n            .sendRequest('copyToGlobals', {\n            srcVariableName: name,\n            dstVariableName: name,\n            srcFrameId: frames[0].id\n        })\n            .then(async () => {\n            const scopes = await this._getScopes(frames[0]);\n            const variables = await Promise.all(scopes.map(scope => this._getVariables(scope)));\n            const variableScopes = this._convertScopes(scopes, variables);\n            this._model.variables.scopes = variableScopes;\n        })\n            .catch(reason => {\n            console.error(reason);\n        });\n    }\n    /**\n     * Requests all the defined variables and display them in the\n     * table view.\n     */\n    async displayDefinedVariables() {\n        if (!this.session) {\n            throw new Error('No active debugger session');\n        }\n        const inspectReply = await this.session.sendRequest('inspectVariables', {});\n        const variables = inspectReply.body.variables;\n        const variableScopes = [\n            {\n                name: this._trans.__('Globals'),\n                variables: variables\n            }\n        ];\n        this._model.variables.scopes = variableScopes;\n    }\n    async displayModules() {\n        if (!this.session) {\n            throw new Error('No active debugger session');\n        }\n        const modules = await this.session.sendRequest('modules', {});\n        this._model.kernelSources.kernelSources = modules.body.modules.map(module => {\n            return {\n                name: module.name,\n                path: module.path\n            };\n        });\n    }\n    /**\n     * Restart the debugger.\n     */\n    async restart() {\n        const { breakpoints } = this._model.breakpoints;\n        await this.stop();\n        await this.start();\n        await this._restoreBreakpoints(breakpoints);\n    }\n    /**\n     * Restore the state of a debug session.\n     *\n     * @param autoStart - If true, starts the debugger if it has not been started.\n     */\n    async restoreState(autoStart) {\n        var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k;\n        if (!this.model || !this.session) {\n            return;\n        }\n        const reply = await this.session.restoreState();\n        const { body } = reply;\n        const breakpoints = this._mapBreakpoints(body.breakpoints);\n        const stoppedThreads = new Set(body.stoppedThreads);\n        this._model.hasRichVariableRendering = body.richRendering === true;\n        this._model.supportCopyToGlobals = body.copyToGlobals === true;\n        this._config.setHashParams({\n            kernel: (_d = (_c = (_b = (_a = this.session) === null || _a === void 0 ? void 0 : _a.connection) === null || _b === void 0 ? void 0 : _b.kernel) === null || _c === void 0 ? void 0 : _c.name) !== null && _d !== void 0 ? _d : '',\n            method: body.hashMethod,\n            seed: body.hashSeed\n        });\n        this._config.setTmpFileParams({\n            kernel: (_h = (_g = (_f = (_e = this.session) === null || _e === void 0 ? void 0 : _e.connection) === null || _f === void 0 ? void 0 : _f.kernel) === null || _g === void 0 ? void 0 : _g.name) !== null && _h !== void 0 ? _h : '',\n            prefix: body.tmpFilePrefix,\n            suffix: body.tmpFileSuffix\n        });\n        this._model.stoppedThreads = stoppedThreads;\n        if (!this.isStarted && (autoStart || stoppedThreads.size !== 0)) {\n            await this.start();\n        }\n        if (this.isStarted || autoStart) {\n            this._model.title = this.isStarted\n                ? ((_k = (_j = this.session) === null || _j === void 0 ? void 0 : _j.connection) === null || _k === void 0 ? void 0 : _k.name) || '-'\n                : '-';\n        }\n        if (this._debuggerSources) {\n            const filtered = this._filterBreakpoints(breakpoints);\n            this._model.breakpoints.restoreBreakpoints(filtered);\n        }\n        else {\n            this._model.breakpoints.restoreBreakpoints(breakpoints);\n        }\n        if (stoppedThreads.size !== 0) {\n            await this._getAllFrames();\n        }\n        else if (this.isStarted) {\n            this._clearModel();\n            this._clearSignals();\n        }\n        // Send the currentExceptionFilters to debugger.\n        if (this.session.currentExceptionFilters) {\n            await this.pauseOnExceptions(this.session.currentExceptionFilters);\n        }\n    }\n    /**\n     * Starts a debugger.\n     * Precondition: !isStarted\n     */\n    start() {\n        if (!this.session) {\n            throw new Error('No active debugger session');\n        }\n        return this.session.start();\n    }\n    /**\n     * Makes the current thread pause if possible.\n     */\n    async pause() {\n        try {\n            if (!this.session) {\n                throw new Error('No active debugger session');\n            }\n            await this.session.sendRequest('pause', {\n                threadId: this._currentThread()\n            });\n        }\n        catch (err) {\n            console.error('Error:', err.message);\n        }\n    }\n    /**\n     * Makes the current thread step in a function / method if possible.\n     */\n    async stepIn() {\n        try {\n            if (!this.session) {\n                throw new Error('No active debugger session');\n            }\n            await this.session.sendRequest('stepIn', {\n                threadId: this._currentThread()\n            });\n        }\n        catch (err) {\n            console.error('Error:', err.message);\n        }\n    }\n    /**\n     * Makes the current thread step out a function / method if possible.\n     */\n    async stepOut() {\n        try {\n            if (!this.session) {\n                throw new Error('No active debugger session');\n            }\n            await this.session.sendRequest('stepOut', {\n                threadId: this._currentThread()\n            });\n        }\n        catch (err) {\n            console.error('Error:', err.message);\n        }\n    }\n    /**\n     * Stops the debugger.\n     * Precondition: isStarted\n     */\n    async stop() {\n        if (!this.session) {\n            throw new Error('No active debugger session');\n        }\n        await this.session.stop();\n        if (this._model) {\n            this._model.clear();\n        }\n    }\n    /**\n     * Update all breakpoints at once.\n     *\n     * @param code - The code in the cell where the breakpoints are set.\n     * @param breakpoints - The list of breakpoints to set.\n     * @param path - Optional path to the file where to set the breakpoints.\n     */\n    async updateBreakpoints(code, breakpoints, path) {\n        var _a;\n        if (!((_a = this.session) === null || _a === void 0 ? void 0 : _a.isStarted)) {\n            return;\n        }\n        if (!path) {\n            path = (await this._dumpCell(code)).body.sourcePath;\n        }\n        const state = await this.session.restoreState();\n        const localBreakpoints = breakpoints\n            .filter(({ line }) => typeof line === 'number')\n            .map(({ line }) => ({ line: line }));\n        const remoteBreakpoints = this._mapBreakpoints(state.body.breakpoints);\n        // Set the local copy of breakpoints to reflect only editors that exist.\n        if (this._debuggerSources) {\n            const filtered = this._filterBreakpoints(remoteBreakpoints);\n            this._model.breakpoints.restoreBreakpoints(filtered);\n        }\n        else {\n            this._model.breakpoints.restoreBreakpoints(remoteBreakpoints);\n        }\n        // Removes duplicated breakpoints. It is better to do it here than\n        // in the editor, because the kernel can change the line of a\n        // breakpoint (when you attempt to set a breakpoint on an empty\n        // line for instance).\n        let addedLines = new Set();\n        // Set the kernel's breakpoints for this path.\n        const reply = await this._setBreakpoints(localBreakpoints, path);\n        const updatedBreakpoints = reply.body.breakpoints.filter((val, _, arr) => {\n            const cond1 = arr.findIndex(el => el.line === val.line) > -1;\n            const cond2 = !addedLines.has(val.line);\n            addedLines.add(val.line);\n            return cond1 && cond2;\n        });\n        // Update the local model and finish kernel configuration.\n        this._model.breakpoints.setBreakpoints(path, updatedBreakpoints);\n    }\n    /**\n     * Determines if pausing on exceptions is supported by the kernel\n     */\n    pauseOnExceptionsIsValid() {\n        var _a, _b;\n        if (this.isStarted) {\n            if (((_b = (_a = this.session) === null || _a === void 0 ? void 0 : _a.exceptionBreakpointFilters) === null || _b === void 0 ? void 0 : _b.length) !== 0) {\n                return true;\n            }\n        }\n        return false;\n    }\n    /**\n     * Add or remove a filter from the current used filters.\n     *\n     * @param exceptionFilter - The filter to add or remove from current filters.\n     */\n    async pauseOnExceptionsFilter(exceptionFilter) {\n        var _a;\n        if (!((_a = this.session) === null || _a === void 0 ? void 0 : _a.isStarted)) {\n            return;\n        }\n        let exceptionFilters = this.session.currentExceptionFilters;\n        if (this.session.isPausingOnException(exceptionFilter)) {\n            const index = exceptionFilters.indexOf(exceptionFilter);\n            exceptionFilters.splice(index, 1);\n        }\n        else {\n            exceptionFilters === null || exceptionFilters === void 0 ? void 0 : exceptionFilters.push(exceptionFilter);\n        }\n        await this.pauseOnExceptions(exceptionFilters);\n    }\n    /**\n     * Enable or disable pausing on exceptions.\n     *\n     * @param exceptionFilters - The filters to use for the current debugging session.\n     */\n    async pauseOnExceptions(exceptionFilters) {\n        var _a, _b;\n        if (!((_a = this.session) === null || _a === void 0 ? void 0 : _a.isStarted)) {\n            return;\n        }\n        const exceptionBreakpointFilters = ((_b = this.session.exceptionBreakpointFilters) === null || _b === void 0 ? void 0 : _b.map(e => e.filter)) || [];\n        let options = {\n            filters: []\n        };\n        exceptionFilters.forEach(filter => {\n            if (exceptionBreakpointFilters.includes(filter)) {\n                options.filters.push(filter);\n            }\n        });\n        this.session.currentExceptionFilters = options.filters;\n        await this.session.sendRequest('setExceptionBreakpoints', options);\n        this._pauseOnExceptionChanged.emit();\n    }\n    /**\n     * Get the debugger state\n     *\n     * @returns Debugger state\n     */\n    getDebuggerState() {\n        var _a, _b, _c, _d, _e, _f, _g;\n        const breakpoints = this._model.breakpoints.breakpoints;\n        let cells = [];\n        if (this._debuggerSources) {\n            for (const id of breakpoints.keys()) {\n                const editorList = this._debuggerSources.find({\n                    focus: false,\n                    kernel: (_d = (_c = (_b = (_a = this.session) === null || _a === void 0 ? void 0 : _a.connection) === null || _b === void 0 ? void 0 : _b.kernel) === null || _c === void 0 ? void 0 : _c.name) !== null && _d !== void 0 ? _d : '',\n                    path: (_g = (_f = (_e = this._session) === null || _e === void 0 ? void 0 : _e.connection) === null || _f === void 0 ? void 0 : _f.path) !== null && _g !== void 0 ? _g : '',\n                    source: id\n                });\n                const tmpCells = editorList.map(e => e.src.getSource());\n                cells = cells.concat(tmpCells);\n            }\n        }\n        return { cells, breakpoints };\n    }\n    /**\n     * Restore the debugger state\n     *\n     * @param state Debugger state\n     * @returns Whether the state has been restored successfully or not\n     */\n    async restoreDebuggerState(state) {\n        var _a, _b, _c, _d;\n        await this.start();\n        for (const cell of state.cells) {\n            await this._dumpCell(cell);\n        }\n        const breakpoints = new Map();\n        const kernel = (_d = (_c = (_b = (_a = this.session) === null || _a === void 0 ? void 0 : _a.connection) === null || _b === void 0 ? void 0 : _b.kernel) === null || _c === void 0 ? void 0 : _c.name) !== null && _d !== void 0 ? _d : '';\n        const { prefix, suffix } = this._config.getTmpFileParams(kernel);\n        for (const item of state.breakpoints) {\n            const [id, list] = item;\n            const unsuffixedId = id.substr(0, id.length - suffix.length);\n            const codeHash = unsuffixedId.substr(unsuffixedId.lastIndexOf('/') + 1);\n            const newId = prefix.concat(codeHash).concat(suffix);\n            breakpoints.set(newId, list);\n        }\n        await this._restoreBreakpoints(breakpoints);\n        const config = await this.session.sendRequest('configurationDone', {});\n        await this.restoreState(false);\n        return config.success;\n    }\n    /**\n     * Clear the current model.\n     */\n    _clearModel() {\n        this._model.callstack.frames = [];\n        this._model.variables.scopes = [];\n    }\n    /**\n     * Clear the signals set on the model.\n     */\n    _clearSignals() {\n        this._model.callstack.currentFrameChanged.disconnect(this._onCurrentFrameChanged, this);\n        this._model.variables.variableExpanded.disconnect(this._onVariableExpanded, this);\n    }\n    /**\n     * Map a list of scopes to a list of variables.\n     *\n     * @param scopes The list of scopes.\n     * @param variables The list of variables.\n     */\n    _convertScopes(scopes, variables) {\n        if (!variables || !scopes) {\n            return [];\n        }\n        return scopes.map((scope, i) => {\n            return {\n                name: scope.name,\n                variables: variables[i].map(variable => {\n                    return { ...variable };\n                })\n            };\n        });\n    }\n    /**\n     * Get the current thread from the model.\n     */\n    _currentThread() {\n        var _a;\n        return (_a = this._model.stoppedThreads.values().next().value) !== null && _a !== void 0 ? _a : 1;\n    }\n    /**\n     * Dump the content of a cell.\n     *\n     * @param code The source code to dump.\n     */\n    async _dumpCell(code) {\n        if (!this.session) {\n            throw new Error('No active debugger session');\n        }\n        return this.session.sendRequest('dumpCell', { code });\n    }\n    /**\n     * Filter breakpoints and only return those associated with a known editor.\n     *\n     * @param breakpoints - Map of breakpoints.\n     *\n     */\n    _filterBreakpoints(breakpoints) {\n        if (!this._debuggerSources) {\n            return breakpoints;\n        }\n        let bpMapForRestore = new Map();\n        for (const collection of breakpoints) {\n            const [id, list] = collection;\n            list.forEach(() => {\n                var _a, _b, _c, _d, _e, _f, _g;\n                this._debuggerSources.find({\n                    focus: false,\n                    kernel: (_d = (_c = (_b = (_a = this.session) === null || _a === void 0 ? void 0 : _a.connection) === null || _b === void 0 ? void 0 : _b.kernel) === null || _c === void 0 ? void 0 : _c.name) !== null && _d !== void 0 ? _d : '',\n                    path: (_g = (_f = (_e = this._session) === null || _e === void 0 ? void 0 : _e.connection) === null || _f === void 0 ? void 0 : _f.path) !== null && _g !== void 0 ? _g : '',\n                    source: id\n                }).forEach(() => {\n                    if (list.length > 0) {\n                        bpMapForRestore.set(id, list);\n                    }\n                });\n            });\n        }\n        return bpMapForRestore;\n    }\n    /**\n     * Get all the frames from the kernel.\n     */\n    async _getAllFrames() {\n        this._model.callstack.currentFrameChanged.connect(this._onCurrentFrameChanged, this);\n        this._model.variables.variableExpanded.connect(this._onVariableExpanded, this);\n        const stackFrames = await this._getFrames(this._currentThread());\n        this._model.callstack.frames = stackFrames;\n    }\n    /**\n     * Get all the frames for the given thread id.\n     *\n     * @param threadId The thread id.\n     */\n    async _getFrames(threadId) {\n        if (!this.session) {\n            throw new Error('No active debugger session');\n        }\n        const reply = await this.session.sendRequest('stackTrace', {\n            threadId\n        });\n        const stackFrames = reply.body.stackFrames;\n        return stackFrames;\n    }\n    /**\n     * Get all the scopes for the given frame.\n     *\n     * @param frame The frame.\n     */\n    async _getScopes(frame) {\n        if (!this.session) {\n            throw new Error('No active debugger session');\n        }\n        if (!frame) {\n            return [];\n        }\n        const reply = await this.session.sendRequest('scopes', {\n            frameId: frame.id\n        });\n        return reply.body.scopes;\n    }\n    /**\n     * Get the variables for a given scope.\n     *\n     * @param scope The scope to get variables for.\n     */\n    async _getVariables(scope) {\n        if (!this.session) {\n            throw new Error('No active debugger session');\n        }\n        if (!scope) {\n            return [];\n        }\n        const reply = await this.session.sendRequest('variables', {\n            variablesReference: scope.variablesReference\n        });\n        return reply.body.variables;\n    }\n    /**\n     * Process the list of breakpoints from the server and return as a map.\n     *\n     * @param breakpoints - The list of breakpoints from the kernel.\n     *\n     */\n    _mapBreakpoints(breakpoints) {\n        if (!breakpoints.length) {\n            return new Map();\n        }\n        return breakpoints.reduce((map, val) => {\n            const { breakpoints, source } = val;\n            map.set(source, breakpoints.map(point => ({\n                ...point,\n                source: { path: source },\n                verified: true\n            })));\n            return map;\n        }, new Map());\n    }\n    /**\n     * Handle a change of the current active frame.\n     *\n     * @param _ The callstack model\n     * @param frame The frame.\n     */\n    async _onCurrentFrameChanged(_, frame) {\n        if (!frame) {\n            return;\n        }\n        const scopes = await this._getScopes(frame);\n        const variables = await Promise.all(scopes.map(scope => this._getVariables(scope)));\n        const variableScopes = this._convertScopes(scopes, variables);\n        this._model.variables.scopes = variableScopes;\n    }\n    /**\n     * Handle a variable expanded event and request variables from the kernel.\n     *\n     * @param _ The variables model.\n     * @param variable The expanded variable.\n     */\n    async _onVariableExpanded(_, variable) {\n        if (!this.session) {\n            throw new Error('No active debugger session');\n        }\n        const reply = await this.session.sendRequest('variables', {\n            variablesReference: variable.variablesReference\n        });\n        let newVariable = { ...variable, expanded: true };\n        reply.body.variables.forEach((variable) => {\n            newVariable = { [variable.name]: variable, ...newVariable };\n        });\n        const newScopes = this._model.variables.scopes.map(scope => {\n            const findIndex = scope.variables.findIndex(ele => ele.variablesReference === variable.variablesReference);\n            scope.variables[findIndex] = newVariable;\n            return { ...scope };\n        });\n        this._model.variables.scopes = [...newScopes];\n        return reply.body.variables;\n    }\n    /**\n     * Set the breakpoints for a given file.\n     *\n     * @param breakpoints The list of breakpoints to set.\n     * @param path The path to where to set the breakpoints.\n     */\n    async _setBreakpoints(breakpoints, path) {\n        if (!this.session) {\n            throw new Error('No active debugger session');\n        }\n        return await this.session.sendRequest('setBreakpoints', {\n            breakpoints: breakpoints,\n            source: { path },\n            sourceModified: false\n        });\n    }\n    /**\n     * Re-send the breakpoints to the kernel and update the model.\n     *\n     * @param breakpoints The map of breakpoints to send\n     */\n    async _restoreBreakpoints(breakpoints) {\n        for (const [source, points] of breakpoints) {\n            await this._setBreakpoints(points\n                .filter(({ line }) => typeof line === 'number')\n                .map(({ line }) => ({ line: line })), source);\n        }\n        this._model.breakpoints.restoreBreakpoints(breakpoints);\n    }\n}\n//# sourceMappingURL=service.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/debugger/lib/service.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/debugger/lib/session.js":
/*!***********************************************************!*\
  !*** ../node_modules/@jupyterlab/debugger/lib/session.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   DebuggerSession: () => (/* binding */ DebuggerSession)\n/* harmony export */ });\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/translation */ \"webpack/sharing/consume/default/@jupyterlab/translation/@jupyterlab/translation\");\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/coreutils */ \"webpack/sharing/consume/default/@lumino/coreutils/@lumino/coreutils\");\n/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @lumino/signaling */ \"webpack/sharing/consume/default/@lumino/signaling/@lumino/signaling\");\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_lumino_signaling__WEBPACK_IMPORTED_MODULE_2__);\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\n\n/**\n * A concrete implementation of IDebugger.ISession.\n */\nclass DebuggerSession {\n    /**\n     * Instantiate a new debug session\n     *\n     * @param options - The debug session instantiation options.\n     */\n    constructor(options) {\n        this._seq = 0;\n        this._ready = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__.PromiseDelegate();\n        this._isDisposed = false;\n        this._isStarted = false;\n        this._exceptionPaths = [];\n        this._exceptionBreakpointFilters = [];\n        this._currentExceptionFilters = {};\n        this._disposed = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_2__.Signal(this);\n        this._eventMessage = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_2__.Signal(this);\n        this.connection = options.connection;\n        this._config = options.config;\n        this.translator = options.translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__.nullTranslator;\n    }\n    /**\n     * Whether the debug session is disposed.\n     */\n    get isDisposed() {\n        return this._isDisposed;\n    }\n    /**\n     * Returns the initialize response .\n     */\n    get capabilities() {\n        return this._capabilities;\n    }\n    /**\n     * A signal emitted when the debug session is disposed.\n     */\n    get disposed() {\n        return this._disposed;\n    }\n    /**\n     * Returns the API session connection to connect to a debugger.\n     */\n    get connection() {\n        return this._connection;\n    }\n    /**\n     * Sets the API session connection to connect to a debugger to\n     * the given parameter.\n     *\n     * @param connection - The new API session connection.\n     */\n    set connection(connection) {\n        var _a, _b;\n        if (this._connection) {\n            this._connection.iopubMessage.disconnect(this._handleEvent, this);\n        }\n        this._connection = connection;\n        if (!this._connection) {\n            this._isStarted = false;\n            return;\n        }\n        this._connection.iopubMessage.connect(this._handleEvent, this);\n        this._ready = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__.PromiseDelegate();\n        const future = (_b = (_a = this.connection) === null || _a === void 0 ? void 0 : _a.kernel) === null || _b === void 0 ? void 0 : _b.requestDebug({\n            type: 'request',\n            seq: 0,\n            command: 'debugInfo'\n        });\n        if (future) {\n            future.onReply = (msg) => {\n                this._ready.resolve();\n                future.dispose();\n            };\n        }\n    }\n    /**\n     * Whether the debug session is started.\n     */\n    get isStarted() {\n        return this._isStarted;\n    }\n    /**\n     * Exception paths defined by the debugger\n     */\n    get exceptionPaths() {\n        return this._exceptionPaths;\n    }\n    /**\n     * Exception breakpoint filters defined by the debugger\n     */\n    get exceptionBreakpointFilters() {\n        return this._exceptionBreakpointFilters;\n    }\n    /**\n     * Get current exception filters.\n     */\n    get currentExceptionFilters() {\n        var _a, _b, _c;\n        const kernel = (_c = (_b = (_a = this.connection) === null || _a === void 0 ? void 0 : _a.kernel) === null || _b === void 0 ? void 0 : _b.name) !== null && _c !== void 0 ? _c : '';\n        if (!kernel) {\n            return [];\n        }\n        const tmpFileParams = this._config.getTmpFileParams(kernel);\n        if (!tmpFileParams) {\n            return [];\n        }\n        let prefix = tmpFileParams.prefix;\n        if (Object.keys(this._currentExceptionFilters).includes(prefix)) {\n            return this._currentExceptionFilters[prefix];\n        }\n        return [];\n    }\n    /**\n     * Set current exception filters.\n     */\n    set currentExceptionFilters(exceptionFilters) {\n        var _a, _b, _c;\n        const kernel = (_c = (_b = (_a = this.connection) === null || _a === void 0 ? void 0 : _a.kernel) === null || _b === void 0 ? void 0 : _b.name) !== null && _c !== void 0 ? _c : '';\n        if (!kernel) {\n            return;\n        }\n        const tmpFileParams = this._config.getTmpFileParams(kernel);\n        if (!tmpFileParams) {\n            return;\n        }\n        let prefix = tmpFileParams.prefix;\n        if (exceptionFilters === null) {\n            if (Object.keys(this._currentExceptionFilters).includes(prefix)) {\n                delete this._currentExceptionFilters[prefix];\n            }\n        }\n        else {\n            this._currentExceptionFilters[prefix] = exceptionFilters;\n        }\n    }\n    /**\n     * Signal emitted for debug event messages.\n     */\n    get eventMessage() {\n        return this._eventMessage;\n    }\n    /**\n     * Dispose the debug session.\n     */\n    dispose() {\n        if (this._isDisposed) {\n            return;\n        }\n        this._isDisposed = true;\n        this._disposed.emit();\n        _lumino_signaling__WEBPACK_IMPORTED_MODULE_2__.Signal.clearData(this);\n    }\n    /**\n     * Start a new debug session\n     */\n    async start() {\n        var _a, _b, _c, _d;\n        const initializeResponse = await this.sendRequest('initialize', {\n            clientID: 'jupyterlab',\n            clientName: 'JupyterLab',\n            adapterID: (_c = (_b = (_a = this.connection) === null || _a === void 0 ? void 0 : _a.kernel) === null || _b === void 0 ? void 0 : _b.name) !== null && _c !== void 0 ? _c : '',\n            pathFormat: 'path',\n            linesStartAt1: true,\n            columnsStartAt1: true,\n            supportsVariableType: true,\n            supportsVariablePaging: true,\n            supportsRunInTerminalRequest: true,\n            locale: document.documentElement.lang\n        });\n        if (!initializeResponse.success) {\n            throw new Error(`Could not start the debugger: ${initializeResponse.message}`);\n        }\n        this._capabilities = initializeResponse.body;\n        this._isStarted = true;\n        this._exceptionBreakpointFilters =\n            (_d = initializeResponse.body) === null || _d === void 0 ? void 0 : _d.exceptionBreakpointFilters;\n        await this.sendRequest('attach', {});\n    }\n    /**\n     * Stop the running debug session.\n     */\n    async stop() {\n        this._isStarted = false;\n        await this.sendRequest('disconnect', {\n            restart: false,\n            terminateDebuggee: false\n        });\n    }\n    /**\n     * Restore the state of a debug session.\n     */\n    async restoreState() {\n        var _a;\n        const message = await this.sendRequest('debugInfo', {});\n        this._isStarted = message.body.isStarted;\n        this._exceptionPaths = (_a = message.body) === null || _a === void 0 ? void 0 : _a.exceptionPaths;\n        return message;\n    }\n    /**\n     * Whether the debugger is pausing on exception.\n     *\n     * @param filter - Specify a filter\n     */\n    isPausingOnException(filter) {\n        var _a, _b;\n        if (filter) {\n            return (_b = (_a = this.currentExceptionFilters) === null || _a === void 0 ? void 0 : _a.includes(filter)) !== null && _b !== void 0 ? _b : false;\n        }\n        else {\n            return this.currentExceptionFilters.length > 0;\n        }\n    }\n    /**\n     * Send a custom debug request to the kernel.\n     *\n     * @param command debug command.\n     * @param args arguments for the debug command.\n     */\n    async sendRequest(command, args) {\n        await this._ready.promise;\n        const message = await this._sendDebugMessage({\n            type: 'request',\n            seq: this._seq++,\n            command,\n            arguments: args\n        });\n        return message.content;\n    }\n    /**\n     * Handle debug events sent on the 'iopub' channel.\n     *\n     * @param sender - the emitter of the event.\n     * @param message - the event message.\n     */\n    _handleEvent(sender, message) {\n        const msgType = message.header.msg_type;\n        if (msgType !== 'debug_event') {\n            return;\n        }\n        const event = message.content;\n        this._eventMessage.emit(event);\n    }\n    /**\n     * Send a debug request message to the kernel.\n     *\n     * @param msg debug request message to send to the kernel.\n     */\n    async _sendDebugMessage(msg) {\n        var _a;\n        const kernel = (_a = this.connection) === null || _a === void 0 ? void 0 : _a.kernel;\n        if (!kernel) {\n            return Promise.reject(new Error('A kernel is required to send debug messages.'));\n        }\n        const reply = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__.PromiseDelegate();\n        const future = kernel.requestDebug(msg);\n        future.onReply = (msg) => {\n            reply.resolve(msg);\n        };\n        await future.done;\n        return reply.promise;\n    }\n}\n//# sourceMappingURL=session.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/debugger/lib/session.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/debugger/lib/sidebar.js":
/*!***********************************************************!*\
  !*** ../node_modules/@jupyterlab/debugger/lib/sidebar.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   DebuggerSidebar: () => (/* binding */ DebuggerSidebar)\n/* harmony export */ });\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/translation */ \"webpack/sharing/consume/default/@jupyterlab/translation/@jupyterlab/translation\");\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/ui-components */ \"webpack/sharing/consume/default/@jupyterlab/ui-components/@jupyterlab/ui-components\");\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @lumino/widgets */ \"webpack/sharing/consume/default/@lumino/widgets/@lumino/widgets\");\n/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_lumino_widgets__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var _panels_breakpoints__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./panels/breakpoints */ \"../node_modules/@jupyterlab/debugger/lib/panels/breakpoints/index.js\");\n/* harmony import */ var _panels_callstack__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./panels/callstack */ \"../node_modules/@jupyterlab/debugger/lib/panels/callstack/index.js\");\n/* harmony import */ var _panels_sources__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./panels/sources */ \"../node_modules/@jupyterlab/debugger/lib/panels/sources/index.js\");\n/* harmony import */ var _panels_kernelSources__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./panels/kernelSources */ \"../node_modules/@jupyterlab/debugger/lib/panels/kernelSources/index.js\");\n/* harmony import */ var _panels_variables__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./panels/variables */ \"../node_modules/@jupyterlab/debugger/lib/panels/variables/index.js\");\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\n\n\n\n\n\n\n/**\n * A debugger sidebar.\n */\nclass DebuggerSidebar extends _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.SidePanel {\n    /**\n     * Instantiate a new Debugger.Sidebar\n     *\n     * @param options The instantiation options for a Debugger.Sidebar\n     */\n    constructor(options) {\n        const translator = options.translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__.nullTranslator;\n        super({ translator });\n        this.id = 'jp-debugger-sidebar';\n        this.title.icon = _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.bugIcon;\n        this.addClass('jp-DebuggerSidebar');\n        const { callstackCommands, breakpointsCommands, editorServices, service, themeManager } = options;\n        const model = service.model;\n        this.variables = new _panels_variables__WEBPACK_IMPORTED_MODULE_3__.Variables({\n            model: model.variables,\n            commands: callstackCommands.registry,\n            service,\n            themeManager,\n            translator\n        });\n        this.callstack = new _panels_callstack__WEBPACK_IMPORTED_MODULE_4__.Callstack({\n            commands: callstackCommands,\n            model: model.callstack,\n            translator\n        });\n        this.breakpoints = new _panels_breakpoints__WEBPACK_IMPORTED_MODULE_5__.Breakpoints({\n            service,\n            commands: breakpointsCommands,\n            model: model.breakpoints,\n            translator\n        });\n        this.sources = new _panels_sources__WEBPACK_IMPORTED_MODULE_6__.Sources({\n            model: model.sources,\n            service,\n            editorServices,\n            translator\n        });\n        this.kernelSources = new _panels_kernelSources__WEBPACK_IMPORTED_MODULE_7__.KernelSources({\n            model: model.kernelSources,\n            service,\n            translator\n        });\n        const header = new DebuggerSidebar.Header();\n        this.header.addWidget(header);\n        model.titleChanged.connect((_, title) => {\n            header.title.label = title;\n        });\n        this.content.addClass('jp-DebuggerSidebar-body');\n        this.addWidget(this.variables);\n        this.addWidget(this.callstack);\n        this.addWidget(this.breakpoints);\n        this.addWidget(this.sources);\n        this.addWidget(this.kernelSources);\n    }\n}\n/**\n * A namespace for DebuggerSidebar statics\n */\n(function (DebuggerSidebar) {\n    /**\n     * The header for a debugger sidebar.\n     */\n    class Header extends _lumino_widgets__WEBPACK_IMPORTED_MODULE_2__.Widget {\n        /**\n         * Instantiate a new sidebar header.\n         */\n        constructor() {\n            super({ node: Private.createHeader() });\n            this.title.changed.connect(_ => {\n                this.node.textContent = this.title.label;\n            });\n        }\n    }\n    DebuggerSidebar.Header = Header;\n})(DebuggerSidebar || (DebuggerSidebar = {}));\n/**\n * A namespace for private module data.\n */\nvar Private;\n(function (Private) {\n    /**\n     * Create a sidebar header node.\n     */\n    function createHeader() {\n        const title = document.createElement('h2');\n        title.textContent = '-';\n        title.classList.add('jp-text-truncated');\n        return title;\n    }\n    Private.createHeader = createHeader;\n})(Private || (Private = {}));\n//# sourceMappingURL=sidebar.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/debugger/lib/sidebar.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/debugger/lib/sources.js":
/*!***********************************************************!*\
  !*** ../node_modules/@jupyterlab/debugger/lib/sources.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   DebuggerSources: () => (/* binding */ DebuggerSources)\n/* harmony export */ });\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/apputils */ \"webpack/sharing/consume/default/@jupyterlab/apputils/@jupyterlab/apputils\");\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/ui-components */ \"webpack/sharing/consume/default/@jupyterlab/ui-components/@jupyterlab/ui-components\");\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__);\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\n/**\n * The source and editor manager for a debugger instance.\n */\nclass DebuggerSources {\n    /**\n     * Create a new DebuggerSources instance.\n     *\n     * @param options The instantiation options for a DebuggerSources instance.\n     */\n    constructor(options) {\n        var _a, _b, _c;\n        this._config = options.config;\n        this._shell = options.shell;\n        this._notebookTracker = (_a = options.notebookTracker) !== null && _a !== void 0 ? _a : null;\n        this._consoleTracker = (_b = options.consoleTracker) !== null && _b !== void 0 ? _b : null;\n        this._editorTracker = (_c = options.editorTracker) !== null && _c !== void 0 ? _c : null;\n        this._readOnlyEditorTracker = new _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.WidgetTracker({ namespace: '@jupyterlab/debugger' });\n    }\n    /**\n     * Returns an array of editors for a source matching the current debug\n     * session by iterating through all the widgets in each of the supported\n     * debugger types (i.e., consoles, files, notebooks).\n     *\n     * @param params - The editor search parameters.\n     */\n    find(params) {\n        return [\n            ...this._findInConsoles(params),\n            ...this._findInEditors(params),\n            ...this._findInNotebooks(params),\n            ...this._findInReadOnlyEditors(params)\n        ];\n    }\n    /**\n     * Open a read-only editor in the main area.\n     *\n     * @param params The editor open parameters.\n     */\n    open(params) {\n        const { editorWrapper, label, caption } = params;\n        const widget = new _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.MainAreaWidget({\n            content: editorWrapper\n        });\n        widget.id = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.createDomID();\n        widget.title.label = label;\n        widget.title.closable = true;\n        widget.title.caption = caption;\n        widget.title.icon = _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.textEditorIcon;\n        this._shell.add(widget, 'main', { type: 'Debugger Sources' });\n        void this._readOnlyEditorTracker.add(widget);\n    }\n    /**\n     * Find relevant editors matching the search params in the notebook tracker.\n     *\n     * @param params - The editor search parameters.\n     */\n    _findInNotebooks(params) {\n        if (!this._notebookTracker) {\n            return [];\n        }\n        const { focus, kernel, path, source } = params;\n        const editors = [];\n        this._notebookTracker.forEach(notebookPanel => {\n            const sessionContext = notebookPanel.sessionContext;\n            if (path !== sessionContext.path) {\n                return;\n            }\n            const notebook = notebookPanel.content;\n            if (focus) {\n                notebook.mode = 'command';\n            }\n            const cells = notebookPanel.content.widgets;\n            cells.forEach((cell, i) => {\n                // check the event is for the correct cell\n                const code = cell.model.sharedModel.getSource();\n                const codeId = this._getCodeId(code, kernel);\n                if (!codeId) {\n                    return;\n                }\n                if (source !== codeId) {\n                    return;\n                }\n                if (focus) {\n                    notebook.activeCellIndex = i;\n                    if (notebook.activeCell) {\n                        notebook\n                            .scrollToItem(notebook.activeCellIndex, 'smart')\n                            .catch(reason => {\n                            // no-op\n                        });\n                    }\n                    this._shell.activateById(notebookPanel.id);\n                }\n                editors.push(Object.freeze({\n                    get: () => cell.editor,\n                    reveal: () => notebook.scrollToItem(i, 'smart'),\n                    src: cell.model.sharedModel\n                }));\n            });\n        });\n        return editors;\n    }\n    /**\n     * Find relevant editors matching the search params in the console tracker.\n     *\n     * @param params - The editor search parameters.\n     */\n    _findInConsoles(params) {\n        if (!this._consoleTracker) {\n            return [];\n        }\n        const { focus, kernel, path, source } = params;\n        const editors = [];\n        this._consoleTracker.forEach(consoleWidget => {\n            const sessionContext = consoleWidget.sessionContext;\n            if (path !== sessionContext.path) {\n                return;\n            }\n            const cells = consoleWidget.console.cells;\n            for (const cell of cells) {\n                const code = cell.model.sharedModel.getSource();\n                const codeId = this._getCodeId(code, kernel);\n                if (!codeId) {\n                    break;\n                }\n                if (source !== codeId) {\n                    break;\n                }\n                editors.push(Object.freeze({\n                    get: () => cell.editor,\n                    reveal: () => Promise.resolve(this._shell.activateById(consoleWidget.id)),\n                    src: cell.model.sharedModel\n                }));\n                if (focus) {\n                    this._shell.activateById(consoleWidget.id);\n                }\n            }\n        });\n        return editors;\n    }\n    /**\n     * Find relevant editors matching the search params in the editor tracker.\n     *\n     * @param params - The editor search parameters.\n     */\n    _findInEditors(params) {\n        if (!this._editorTracker) {\n            return [];\n        }\n        const { focus, kernel, path, source } = params;\n        const editors = [];\n        this._editorTracker.forEach(doc => {\n            const fileEditor = doc.content;\n            if (path !== fileEditor.context.path) {\n                return;\n            }\n            const editor = fileEditor.editor;\n            if (!editor) {\n                return;\n            }\n            const code = editor.model.sharedModel.getSource();\n            const codeId = this._getCodeId(code, kernel);\n            if (!codeId) {\n                return;\n            }\n            if (source !== codeId) {\n                return;\n            }\n            editors.push(Object.freeze({\n                get: () => editor,\n                reveal: () => Promise.resolve(this._shell.activateById(doc.id)),\n                src: fileEditor.model.sharedModel\n            }));\n            if (focus) {\n                this._shell.activateById(doc.id);\n            }\n        });\n        return editors;\n    }\n    /**\n     * Find relevant editors matching the search params in the read-only tracker.\n     *\n     * @param params - The editor search parameters.\n     */\n    _findInReadOnlyEditors(params) {\n        const { focus, kernel, source } = params;\n        const editors = [];\n        this._readOnlyEditorTracker.forEach(widget => {\n            var _a;\n            const editor = (_a = widget.content) === null || _a === void 0 ? void 0 : _a.editor;\n            if (!editor) {\n                return;\n            }\n            const code = editor.model.sharedModel.getSource();\n            const codeId = this._getCodeId(code, kernel);\n            if (!codeId) {\n                return;\n            }\n            if (widget.title.caption !== source && source !== codeId) {\n                return;\n            }\n            editors.push(Object.freeze({\n                get: () => editor,\n                reveal: () => Promise.resolve(this._shell.activateById(widget.id)),\n                src: editor.model.sharedModel\n            }));\n            if (focus) {\n                this._shell.activateById(widget.id);\n            }\n        });\n        return editors;\n    }\n    /**\n     * Get the code id for a given source and kernel,\n     * and handle the case of a kernel without parameters.\n     *\n     * @param code The source code.\n     * @param kernel The name of the kernel.\n     */\n    _getCodeId(code, kernel) {\n        try {\n            return this._config.getCodeId(code, kernel);\n        }\n        catch (_a) {\n            return '';\n        }\n    }\n}\n//# sourceMappingURL=sources.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/debugger/lib/sources.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/debugger/lib/tokens.js":
/*!**********************************************************!*\
  !*** ../node_modules/@jupyterlab/debugger/lib/tokens.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   IDebugger: () => (/* binding */ IDebugger),\n/* harmony export */   IDebuggerConfig: () => (/* binding */ IDebuggerConfig),\n/* harmony export */   IDebuggerHandler: () => (/* binding */ IDebuggerHandler),\n/* harmony export */   IDebuggerSidebar: () => (/* binding */ IDebuggerSidebar),\n/* harmony export */   IDebuggerSourceViewer: () => (/* binding */ IDebuggerSourceViewer),\n/* harmony export */   IDebuggerSources: () => (/* binding */ IDebuggerSources)\n/* harmony export */ });\n/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/coreutils */ \"webpack/sharing/consume/default/@lumino/coreutils/@lumino/coreutils\");\n/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__);\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n/**\n * The visual debugger token.\n */\nconst IDebugger = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.Token('@jupyterlab/debugger:IDebugger', 'A debugger user interface.');\n/**\n * The debugger configuration token.\n */\nconst IDebuggerConfig = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.Token('@jupyterlab/debugger:IDebuggerConfig', 'A service to handle the debugger configuration.');\n/**\n * The debugger sources utility token.\n */\nconst IDebuggerSources = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.Token('@jupyterlab/debugger:IDebuggerSources', 'A service to display sources in debug mode.');\n/**\n * The debugger sidebar token.\n */\nconst IDebuggerSidebar = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.Token('@jupyterlab/debugger:IDebuggerSidebar', 'A service for the debugger sidebar.');\n/**\n * The debugger handler token.\n */\nconst IDebuggerHandler = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.Token('@jupyterlab/debugger:IDebuggerHandler', 'A service for handling notebook debugger.');\n/**\n * The source viewer token.\n */\nconst IDebuggerSourceViewer = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.Token('@jupyterlab/debugger:IDebuggerSourceViewer', 'A debugger source viewer.');\n//# sourceMappingURL=tokens.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/debugger/lib/tokens.js?");

/***/ })

}]);