/* SPDX-License-Identifier: GPL-2.0-only */

#include <mipi/panel.h>

struct panel_serializable_data STA_ILI9882T = {
	.edid = {
		.ascii_string = "ILI9882T",
		.manufacturer_name = "STA",
		.panel_bits_per_color = 8,
		.panel_bits_per_pixel = 24,
		.mode = {
			.pixel_clock = 165280,
			.lvds_dual_channel = 0,
			.refresh = 60,
			.ha = 1200, .hbl = 174, .hso = 72, .hspw = 30,
			.va = 1920, .vbl = 80, .vso = 68, .vspw = 2,
			.phsync = '-', .pvsync = '-',
			.x_mm = 141, .y_mm = 226,
		},
	},
	.init = {
		PANEL_DELAY(20),
		PANEL_DCS(0xFF, 0x98, 0x82, 0x01),
		PANEL_DCS(0x00, 0x42),
		PANEL_DCS(0x01, 0x11),
		PANEL_DCS(0x02, 0x00),
		PANEL_DCS(0x03, 0x00),
		PANEL_DCS(0x04, 0x01),
		PANEL_DCS(0x05, 0x11),
		PANEL_DCS(0x06, 0x00),
		PANEL_DCS(0x07, 0x00),
		PANEL_DCS(0x08, 0x80),
		PANEL_DCS(0x09, 0x81),
		PANEL_DCS(0x0A, 0x71),
		PANEL_DCS(0x0B, 0x00),
		PANEL_DCS(0x0C, 0x00),
		PANEL_DCS(0x0E, 0x1A),
		PANEL_DCS(0x24, 0x00),
		PANEL_DCS(0x25, 0x00),
		PANEL_DCS(0x26, 0x00),
		PANEL_DCS(0x27, 0x00),
		PANEL_DCS(0x2C, 0xD4),
		PANEL_DCS(0xB9, 0x40),
		PANEL_DCS(0xB0, 0x11),
		PANEL_DCS(0xE6, 0x32),
		PANEL_DCS(0xD1, 0x30),
		PANEL_DCS(0xD6, 0x55),
		PANEL_DCS(0xD0, 0x01),
		PANEL_DCS(0xE3, 0x93),
		PANEL_DCS(0xE4, 0x00),
		PANEL_DCS(0xE5, 0x80),
		PANEL_DCS(0x31, 0x07),
		PANEL_DCS(0x32, 0x07),
		PANEL_DCS(0x33, 0x07),
		PANEL_DCS(0x34, 0x07),
		PANEL_DCS(0x35, 0x07),
		PANEL_DCS(0x36, 0x01),
		PANEL_DCS(0x37, 0x00),
		PANEL_DCS(0x38, 0x28),
		PANEL_DCS(0x39, 0x29),
		PANEL_DCS(0x3A, 0x11),
		PANEL_DCS(0x3B, 0x13),
		PANEL_DCS(0x3C, 0x15),
		PANEL_DCS(0x3D, 0x17),
		PANEL_DCS(0x3E, 0x09),
		PANEL_DCS(0x3F, 0x0D),
		PANEL_DCS(0x40, 0x02),
		PANEL_DCS(0x41, 0x02),
		PANEL_DCS(0x42, 0x02),
		PANEL_DCS(0x43, 0x02),
		PANEL_DCS(0x44, 0x02),
		PANEL_DCS(0x45, 0x02),
		PANEL_DCS(0x46, 0x02),
		PANEL_DCS(0x47, 0x07),
		PANEL_DCS(0x48, 0x07),
		PANEL_DCS(0x49, 0x07),
		PANEL_DCS(0x4A, 0x07),
		PANEL_DCS(0x4B, 0x07),
		PANEL_DCS(0x4C, 0x01),
		PANEL_DCS(0x4D, 0x00),
		PANEL_DCS(0x4E, 0x28),
		PANEL_DCS(0x4F, 0x29),
		PANEL_DCS(0x50, 0x10),
		PANEL_DCS(0x51, 0x12),
		PANEL_DCS(0x52, 0x14),
		PANEL_DCS(0x53, 0x16),
		PANEL_DCS(0x54, 0x08),
		PANEL_DCS(0x55, 0x0C),
		PANEL_DCS(0x56, 0x02),
		PANEL_DCS(0x57, 0x02),
		PANEL_DCS(0x58, 0x02),
		PANEL_DCS(0x59, 0x02),
		PANEL_DCS(0x5A, 0x02),
		PANEL_DCS(0x5B, 0x02),
		PANEL_DCS(0x5C, 0x02),
		PANEL_DCS(0x61, 0x07),
		PANEL_DCS(0x62, 0x07),
		PANEL_DCS(0x63, 0x07),
		PANEL_DCS(0x64, 0x07),
		PANEL_DCS(0x65, 0x07),
		PANEL_DCS(0x66, 0x01),
		PANEL_DCS(0x67, 0x00),
		PANEL_DCS(0x68, 0x28),
		PANEL_DCS(0x69, 0x29),
		PANEL_DCS(0x6A, 0x16),
		PANEL_DCS(0x6B, 0x14),
		PANEL_DCS(0x6C, 0x12),
		PANEL_DCS(0x6D, 0x10),
		PANEL_DCS(0x6E, 0x0C),
		PANEL_DCS(0x6F, 0x08),
		PANEL_DCS(0x70, 0x02),
		PANEL_DCS(0x71, 0x02),
		PANEL_DCS(0x72, 0x02),
		PANEL_DCS(0x73, 0x02),
		PANEL_DCS(0x74, 0x02),
		PANEL_DCS(0x75, 0x02),
		PANEL_DCS(0x76, 0x02),
		PANEL_DCS(0x77, 0x07),
		PANEL_DCS(0x78, 0x07),
		PANEL_DCS(0x79, 0x07),
		PANEL_DCS(0x7A, 0x07),
		PANEL_DCS(0x7B, 0x07),
		PANEL_DCS(0x7C, 0x01),
		PANEL_DCS(0x7D, 0x00),
		PANEL_DCS(0x7E, 0x28),
		PANEL_DCS(0x7F, 0x29),
		PANEL_DCS(0x80, 0x17),
		PANEL_DCS(0x81, 0x15),
		PANEL_DCS(0x82, 0x13),
		PANEL_DCS(0x83, 0x11),
		PANEL_DCS(0x84, 0x0D),
		PANEL_DCS(0x85, 0x09),
		PANEL_DCS(0x86, 0x02),
		PANEL_DCS(0x87, 0x07),
		PANEL_DCS(0x88, 0x07),
		PANEL_DCS(0x89, 0x07),
		PANEL_DCS(0x8A, 0x07),
		PANEL_DCS(0x8B, 0x07),
		PANEL_DCS(0x8C, 0x07),
		PANEL_DCS(0xFF, 0x98, 0x82, 0x02),
		PANEL_DCS(0x29, 0x3A),
		PANEL_DCS(0x2A, 0x3B),
		PANEL_DCS(0x06, 0x01),
		PANEL_DCS(0x07, 0x01),
		PANEL_DCS(0x08, 0x0C),
		PANEL_DCS(0x09, 0x44),
		PANEL_DCS(0x3C, 0x0A),
		PANEL_DCS(0x39, 0x11),
		PANEL_DCS(0x3D, 0x00),
		PANEL_DCS(0x3A, 0x0C),
		PANEL_DCS(0x3B, 0x44),
		PANEL_DCS(0x53, 0x1F),
		PANEL_DCS(0x5E, 0x40),
		PANEL_DCS(0x84, 0x00),
		PANEL_DCS(0xFF, 0x98, 0x82, 0x03),
		PANEL_DCS(0x20, 0x01),
		PANEL_DCS(0x21, 0x3C),
		PANEL_DCS(0x22, 0xFA),
		PANEL_DCS(0xFF, 0x98, 0x82, 0x0A),
		PANEL_DCS(0xE0, 0x01),
		PANEL_DCS(0xE2, 0x01),
		PANEL_DCS(0xE5, 0x91),
		PANEL_DCS(0xE6, 0x3C),
		PANEL_DCS(0xE7, 0x00),
		PANEL_DCS(0xE8, 0xFA),
		PANEL_DCS(0xFF, 0x98, 0x82, 0x12),
		PANEL_DCS(0x87, 0x2C),
		PANEL_DCS(0xFF, 0x98, 0x82, 0x05),
		PANEL_DCS(0x73, 0xE5),
		PANEL_DCS(0x7F, 0x6B),
		PANEL_DCS(0x6D, 0xA4),
		PANEL_DCS(0x79, 0x54),
		PANEL_DCS(0x69, 0x97),
		PANEL_DCS(0x6A, 0x97),
		PANEL_DCS(0xA5, 0x3F),
		PANEL_DCS(0x61, 0xDA),
		PANEL_DCS(0xA7, 0xF1),
		PANEL_DCS(0x5F, 0x01),
		PANEL_DCS(0x62, 0x3F),
		PANEL_DCS(0x1D, 0x90),
		PANEL_DCS(0x86, 0x87),
		PANEL_DCS(0xFF, 0x98, 0x82, 0x06),
		PANEL_DCS(0xC0, 0x80),
		PANEL_DCS(0xC1, 0x07),
		PANEL_DCS(0xCA, 0x58),
		PANEL_DCS(0xCB, 0x02),
		PANEL_DCS(0xCE, 0x58),
		PANEL_DCS(0xCF, 0x02),
		PANEL_DCS(0x67, 0x60),
		PANEL_DCS(0x10, 0x00),
		PANEL_DCS(0x92, 0x22),
		PANEL_DCS(0xD3, 0x08),
		PANEL_DCS(0xD6, 0x55),
		PANEL_DCS(0xDC, 0x38),
		PANEL_DCS(0xFF, 0x98, 0x82, 0x08),
		PANEL_DCS(0xE0, 0x00, 0x10, 0x2A, 0x4D, 0x61, 0x56, 0x6A, 0x6E,
			0x79, 0x76, 0x8F, 0x95, 0x98, 0xAE, 0xAA, 0xB2, 0xBB,
			0xCE, 0xC6, 0xBD, 0xD5, 0xE2, 0xE8),
		PANEL_DCS(0xE1, 0x00, 0x10, 0x2A, 0x4D, 0x61, 0x56, 0x6A, 0x6E,
			0x79, 0x76, 0x8F, 0x95, 0x98, 0xAE, 0xAA, 0xB2, 0xBB,
			0xCE, 0xC6, 0xBD, 0xD5, 0xE2, 0xE8),
		PANEL_DCS(0xFF, 0x98, 0x82, 0x04),
		PANEL_DCS(0xBA, 0x81),
		PANEL_DCS(0xFF, 0x98, 0x82, 0x0C),
		PANEL_DCS(0x00, 0x02),
		PANEL_DCS(0x01, 0x00),
		PANEL_DCS(0x02, 0x03),
		PANEL_DCS(0x03, 0x01),
		PANEL_DCS(0x04, 0x03),
		PANEL_DCS(0x05, 0x02),
		PANEL_DCS(0x06, 0x04),
		PANEL_DCS(0x07, 0x03),
		PANEL_DCS(0x08, 0x03),
		PANEL_DCS(0x09, 0x04),
		PANEL_DCS(0x0A, 0x04),
		PANEL_DCS(0x0B, 0x05),
		PANEL_DCS(0x0C, 0x04),
		PANEL_DCS(0x0D, 0x06),
		PANEL_DCS(0x0E, 0x05),
		PANEL_DCS(0x0F, 0x07),
		PANEL_DCS(0x10, 0x04),
		PANEL_DCS(0x11, 0x08),
		PANEL_DCS(0x12, 0x05),
		PANEL_DCS(0x13, 0x09),
		PANEL_DCS(0x14, 0x05),
		PANEL_DCS(0x15, 0x0A),
		PANEL_DCS(0x16, 0x06),
		PANEL_DCS(0x17, 0x0B),
		PANEL_DCS(0x18, 0x05),
		PANEL_DCS(0x19, 0x0C),
		PANEL_DCS(0x1A, 0x06),
		PANEL_DCS(0x1B, 0x0D),
		PANEL_DCS(0x1C, 0x06),
		PANEL_DCS(0x1D, 0x0E),
		PANEL_DCS(0x1E, 0x07),
		PANEL_DCS(0x1F, 0x0F),
		PANEL_DCS(0x20, 0x06),
		PANEL_DCS(0x21, 0x10),
		PANEL_DCS(0x22, 0x07),
		PANEL_DCS(0x23, 0x11),
		PANEL_DCS(0x24, 0x07),
		PANEL_DCS(0x25, 0x12),
		PANEL_DCS(0x26, 0x08),
		PANEL_DCS(0x27, 0x13),
		PANEL_DCS(0x28, 0x07),
		PANEL_DCS(0x29, 0x14),
		PANEL_DCS(0x2A, 0x08),
		PANEL_DCS(0x2B, 0x15),
		PANEL_DCS(0x2C, 0x08),
		PANEL_DCS(0x2D, 0x16),
		PANEL_DCS(0x2E, 0x09),
		PANEL_DCS(0x2F, 0x17),
		PANEL_DCS(0x30, 0x08),
		PANEL_DCS(0x31, 0x18),
		PANEL_DCS(0x32, 0x09),
		PANEL_DCS(0x33, 0x19),
		PANEL_DCS(0x34, 0x09),
		PANEL_DCS(0x35, 0x1A),
		PANEL_DCS(0x36, 0x0A),
		PANEL_DCS(0x37, 0x1B),
		PANEL_DCS(0x38, 0x0A),
		PANEL_DCS(0x39, 0x1C),
		PANEL_DCS(0x3A, 0x0A),
		PANEL_DCS(0x3B, 0x1D),
		PANEL_DCS(0x3C, 0x0A),
		PANEL_DCS(0x3D, 0x1E),
		PANEL_DCS(0x3E, 0x0A),
		PANEL_DCS(0x3F, 0x1F),
		PANEL_DCS(0xFF, 0x98, 0x82, 0x04),
		PANEL_DCS(0xBA, 0x01),
		PANEL_DCS(0xFF, 0x98, 0x82, 0x0E),
		PANEL_DCS(0x02, 0x0C),
		PANEL_DCS(0x20, 0x10),
		PANEL_DCS(0x25, 0x16),
		PANEL_DCS(0x26, 0xE0),
		PANEL_DCS(0x27, 0x00),
		PANEL_DCS(0x29, 0x71),
		PANEL_DCS(0x2A, 0x46),
		PANEL_DCS(0x2B, 0x1F),
		PANEL_DCS(0x2D, 0xC7),
		PANEL_DCS(0x31, 0x02),
		PANEL_DCS(0x32, 0xDF),
		PANEL_DCS(0x33, 0x5A),
		PANEL_DCS(0x34, 0xC0),
		PANEL_DCS(0x35, 0x5A),
		PANEL_DCS(0x36, 0xC0),
		PANEL_DCS(0x38, 0x65),
		PANEL_DCS(0x80, 0x3E),
		PANEL_DCS(0x81, 0xA0),
		PANEL_DCS(0xB0, 0x01),
		PANEL_DCS(0xB1, 0xCC),
		PANEL_DCS(0xC0, 0x12),
		PANEL_DCS(0xC2, 0xCC),
		PANEL_DCS(0xC3, 0xCC),
		PANEL_DCS(0xC4, 0xCC),
		PANEL_DCS(0xC5, 0xCC),
		PANEL_DCS(0xC6, 0xCC),
		PANEL_DCS(0xC7, 0xCC),
		PANEL_DCS(0xC8, 0xCC),
		PANEL_DCS(0xC9, 0xCC),
		PANEL_DCS(0x30, 0x00),
		PANEL_DCS(0x00, 0x81),
		PANEL_DCS(0x08, 0x02),
		PANEL_DCS(0x09, 0x00),
		PANEL_DCS(0x07, 0x21),
		PANEL_DCS(0x04, 0x10),
		PANEL_DCS(0xFF, 0x98, 0x82, 0x1E),
		PANEL_DCS(0x60, 0x00),
		PANEL_DCS(0x64, 0x00),
		PANEL_DCS(0x6D, 0x00),
		PANEL_DCS(0xFF, 0x98, 0x82, 0x0B),
		PANEL_DCS(0xA6, 0x44),
		PANEL_DCS(0xA7, 0xB6),
		PANEL_DCS(0xA8, 0x03),
		PANEL_DCS(0xA9, 0x03),
		PANEL_DCS(0xAA, 0x51),
		PANEL_DCS(0xAB, 0x51),
		PANEL_DCS(0xAC, 0x04),
		PANEL_DCS(0xBD, 0x92),
		PANEL_DCS(0xBE, 0xA1),
		PANEL_DCS(0xFF, 0x98, 0x82, 0x05),
		PANEL_DCS(0x86, 0x87),
		PANEL_DCS(0xFF, 0x98, 0x82, 0x06),
		PANEL_DCS(0x92, 0x22),
		PANEL_DCS(0xFF, 0x98, 0x82, 0x00),
		PANEL_DCS(0x11),
		PANEL_DELAY(120),
		PANEL_DCS(0x29),
		PANEL_DELAY(20),
	},
};
