// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mailmanager

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateAddonInstance = "CreateAddonInstance"

// CreateAddonInstanceRequest generates a "aws/request.Request" representing the
// client's request for the CreateAddonInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAddonInstance for more information on using the CreateAddonInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAddonInstanceRequest method.
//	req, resp := client.CreateAddonInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateAddonInstance
func (c *MailManager) CreateAddonInstanceRequest(input *CreateAddonInstanceInput) (req *request.Request, output *CreateAddonInstanceOutput) {
	op := &request.Operation{
		Name:       opCreateAddonInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAddonInstanceInput{}
	}

	output = &CreateAddonInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAddonInstance API operation for MailManager.
//
// Creates an Add On instance for the subscription indicated in the request.
// The resulting Amazon Resource Name (ARN) can be used in a conditional statement
// for a rule set or traffic policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation CreateAddonInstance for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
//   - ServiceQuotaExceededException
//     Occurs when an operation exceeds a predefined service quota or limit.
//
//   - ConflictException
//     The request configuration has conflicts. For details, see the accompanying
//     error message.
//
//   - ResourceNotFoundException
//     Occurs when a requested resource is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateAddonInstance
func (c *MailManager) CreateAddonInstance(input *CreateAddonInstanceInput) (*CreateAddonInstanceOutput, error) {
	req, out := c.CreateAddonInstanceRequest(input)
	return out, req.Send()
}

// CreateAddonInstanceWithContext is the same as CreateAddonInstance with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAddonInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) CreateAddonInstanceWithContext(ctx aws.Context, input *CreateAddonInstanceInput, opts ...request.Option) (*CreateAddonInstanceOutput, error) {
	req, out := c.CreateAddonInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAddonSubscription = "CreateAddonSubscription"

// CreateAddonSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the CreateAddonSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAddonSubscription for more information on using the CreateAddonSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAddonSubscriptionRequest method.
//	req, resp := client.CreateAddonSubscriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateAddonSubscription
func (c *MailManager) CreateAddonSubscriptionRequest(input *CreateAddonSubscriptionInput) (req *request.Request, output *CreateAddonSubscriptionOutput) {
	op := &request.Operation{
		Name:       opCreateAddonSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAddonSubscriptionInput{}
	}

	output = &CreateAddonSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAddonSubscription API operation for MailManager.
//
// Creates a subscription for an Add On representing the acceptance of its terms
// of use and additional pricing. The subscription can then be used to create
// an instance for use in rule sets or traffic policies.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation CreateAddonSubscription for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
//   - ServiceQuotaExceededException
//     Occurs when an operation exceeds a predefined service quota or limit.
//
//   - ConflictException
//     The request configuration has conflicts. For details, see the accompanying
//     error message.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateAddonSubscription
func (c *MailManager) CreateAddonSubscription(input *CreateAddonSubscriptionInput) (*CreateAddonSubscriptionOutput, error) {
	req, out := c.CreateAddonSubscriptionRequest(input)
	return out, req.Send()
}

// CreateAddonSubscriptionWithContext is the same as CreateAddonSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAddonSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) CreateAddonSubscriptionWithContext(ctx aws.Context, input *CreateAddonSubscriptionInput, opts ...request.Option) (*CreateAddonSubscriptionOutput, error) {
	req, out := c.CreateAddonSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateArchive = "CreateArchive"

// CreateArchiveRequest generates a "aws/request.Request" representing the
// client's request for the CreateArchive operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateArchive for more information on using the CreateArchive
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateArchiveRequest method.
//	req, resp := client.CreateArchiveRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateArchive
func (c *MailManager) CreateArchiveRequest(input *CreateArchiveInput) (req *request.Request, output *CreateArchiveOutput) {
	op := &request.Operation{
		Name:       opCreateArchive,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateArchiveInput{}
	}

	output = &CreateArchiveOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateArchive API operation for MailManager.
//
// Creates a new email archive resource for storing and retaining emails.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation CreateArchive for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
//   - AccessDeniedException
//     Occurs when a user is denied access to a specific resource or action.
//
//   - ServiceQuotaExceededException
//     Occurs when an operation exceeds a predefined service quota or limit.
//
//   - ConflictException
//     The request configuration has conflicts. For details, see the accompanying
//     error message.
//
//   - ThrottlingException
//     Occurs when a service's request rate limit is exceeded, resulting in throttling
//     of further requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateArchive
func (c *MailManager) CreateArchive(input *CreateArchiveInput) (*CreateArchiveOutput, error) {
	req, out := c.CreateArchiveRequest(input)
	return out, req.Send()
}

// CreateArchiveWithContext is the same as CreateArchive with the addition of
// the ability to pass a context and additional request options.
//
// See CreateArchive for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) CreateArchiveWithContext(ctx aws.Context, input *CreateArchiveInput, opts ...request.Option) (*CreateArchiveOutput, error) {
	req, out := c.CreateArchiveRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateIngressPoint = "CreateIngressPoint"

// CreateIngressPointRequest generates a "aws/request.Request" representing the
// client's request for the CreateIngressPoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateIngressPoint for more information on using the CreateIngressPoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateIngressPointRequest method.
//	req, resp := client.CreateIngressPointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateIngressPoint
func (c *MailManager) CreateIngressPointRequest(input *CreateIngressPointInput) (req *request.Request, output *CreateIngressPointOutput) {
	op := &request.Operation{
		Name:       opCreateIngressPoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateIngressPointInput{}
	}

	output = &CreateIngressPointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIngressPoint API operation for MailManager.
//
// Provision a new ingress endpoint resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation CreateIngressPoint for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
//   - ServiceQuotaExceededException
//     Occurs when an operation exceeds a predefined service quota or limit.
//
//   - ConflictException
//     The request configuration has conflicts. For details, see the accompanying
//     error message.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateIngressPoint
func (c *MailManager) CreateIngressPoint(input *CreateIngressPointInput) (*CreateIngressPointOutput, error) {
	req, out := c.CreateIngressPointRequest(input)
	return out, req.Send()
}

// CreateIngressPointWithContext is the same as CreateIngressPoint with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIngressPoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) CreateIngressPointWithContext(ctx aws.Context, input *CreateIngressPointInput, opts ...request.Option) (*CreateIngressPointOutput, error) {
	req, out := c.CreateIngressPointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRelay = "CreateRelay"

// CreateRelayRequest generates a "aws/request.Request" representing the
// client's request for the CreateRelay operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRelay for more information on using the CreateRelay
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateRelayRequest method.
//	req, resp := client.CreateRelayRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateRelay
func (c *MailManager) CreateRelayRequest(input *CreateRelayInput) (req *request.Request, output *CreateRelayOutput) {
	op := &request.Operation{
		Name:       opCreateRelay,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRelayInput{}
	}

	output = &CreateRelayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRelay API operation for MailManager.
//
// Creates a relay resource which can be used in rules to relay incoming emails
// to defined relay destinations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation CreateRelay for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
//   - ServiceQuotaExceededException
//     Occurs when an operation exceeds a predefined service quota or limit.
//
//   - ConflictException
//     The request configuration has conflicts. For details, see the accompanying
//     error message.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateRelay
func (c *MailManager) CreateRelay(input *CreateRelayInput) (*CreateRelayOutput, error) {
	req, out := c.CreateRelayRequest(input)
	return out, req.Send()
}

// CreateRelayWithContext is the same as CreateRelay with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRelay for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) CreateRelayWithContext(ctx aws.Context, input *CreateRelayInput, opts ...request.Option) (*CreateRelayOutput, error) {
	req, out := c.CreateRelayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRuleSet = "CreateRuleSet"

// CreateRuleSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateRuleSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRuleSet for more information on using the CreateRuleSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateRuleSetRequest method.
//	req, resp := client.CreateRuleSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateRuleSet
func (c *MailManager) CreateRuleSetRequest(input *CreateRuleSetInput) (req *request.Request, output *CreateRuleSetOutput) {
	op := &request.Operation{
		Name:       opCreateRuleSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRuleSetInput{}
	}

	output = &CreateRuleSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRuleSet API operation for MailManager.
//
// Provision a new rule set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation CreateRuleSet for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
//   - ServiceQuotaExceededException
//     Occurs when an operation exceeds a predefined service quota or limit.
//
//   - ConflictException
//     The request configuration has conflicts. For details, see the accompanying
//     error message.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateRuleSet
func (c *MailManager) CreateRuleSet(input *CreateRuleSetInput) (*CreateRuleSetOutput, error) {
	req, out := c.CreateRuleSetRequest(input)
	return out, req.Send()
}

// CreateRuleSetWithContext is the same as CreateRuleSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRuleSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) CreateRuleSetWithContext(ctx aws.Context, input *CreateRuleSetInput, opts ...request.Option) (*CreateRuleSetOutput, error) {
	req, out := c.CreateRuleSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTrafficPolicy = "CreateTrafficPolicy"

// CreateTrafficPolicyRequest generates a "aws/request.Request" representing the
// client's request for the CreateTrafficPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTrafficPolicy for more information on using the CreateTrafficPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTrafficPolicyRequest method.
//	req, resp := client.CreateTrafficPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateTrafficPolicy
func (c *MailManager) CreateTrafficPolicyRequest(input *CreateTrafficPolicyInput) (req *request.Request, output *CreateTrafficPolicyOutput) {
	op := &request.Operation{
		Name:       opCreateTrafficPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTrafficPolicyInput{}
	}

	output = &CreateTrafficPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTrafficPolicy API operation for MailManager.
//
// Provision a new traffic policy resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation CreateTrafficPolicy for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
//   - ServiceQuotaExceededException
//     Occurs when an operation exceeds a predefined service quota or limit.
//
//   - ConflictException
//     The request configuration has conflicts. For details, see the accompanying
//     error message.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateTrafficPolicy
func (c *MailManager) CreateTrafficPolicy(input *CreateTrafficPolicyInput) (*CreateTrafficPolicyOutput, error) {
	req, out := c.CreateTrafficPolicyRequest(input)
	return out, req.Send()
}

// CreateTrafficPolicyWithContext is the same as CreateTrafficPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTrafficPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) CreateTrafficPolicyWithContext(ctx aws.Context, input *CreateTrafficPolicyInput, opts ...request.Option) (*CreateTrafficPolicyOutput, error) {
	req, out := c.CreateTrafficPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAddonInstance = "DeleteAddonInstance"

// DeleteAddonInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAddonInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAddonInstance for more information on using the DeleteAddonInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAddonInstanceRequest method.
//	req, resp := client.DeleteAddonInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteAddonInstance
func (c *MailManager) DeleteAddonInstanceRequest(input *DeleteAddonInstanceInput) (req *request.Request, output *DeleteAddonInstanceOutput) {
	op := &request.Operation{
		Name:       opDeleteAddonInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAddonInstanceInput{}
	}

	output = &DeleteAddonInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAddonInstance API operation for MailManager.
//
// Deletes an Add On instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation DeleteAddonInstance for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
//   - ConflictException
//     The request configuration has conflicts. For details, see the accompanying
//     error message.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteAddonInstance
func (c *MailManager) DeleteAddonInstance(input *DeleteAddonInstanceInput) (*DeleteAddonInstanceOutput, error) {
	req, out := c.DeleteAddonInstanceRequest(input)
	return out, req.Send()
}

// DeleteAddonInstanceWithContext is the same as DeleteAddonInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAddonInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) DeleteAddonInstanceWithContext(ctx aws.Context, input *DeleteAddonInstanceInput, opts ...request.Option) (*DeleteAddonInstanceOutput, error) {
	req, out := c.DeleteAddonInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAddonSubscription = "DeleteAddonSubscription"

// DeleteAddonSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAddonSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAddonSubscription for more information on using the DeleteAddonSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAddonSubscriptionRequest method.
//	req, resp := client.DeleteAddonSubscriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteAddonSubscription
func (c *MailManager) DeleteAddonSubscriptionRequest(input *DeleteAddonSubscriptionInput) (req *request.Request, output *DeleteAddonSubscriptionOutput) {
	op := &request.Operation{
		Name:       opDeleteAddonSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAddonSubscriptionInput{}
	}

	output = &DeleteAddonSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAddonSubscription API operation for MailManager.
//
// Deletes an Add On subscription.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation DeleteAddonSubscription for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
//   - ConflictException
//     The request configuration has conflicts. For details, see the accompanying
//     error message.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteAddonSubscription
func (c *MailManager) DeleteAddonSubscription(input *DeleteAddonSubscriptionInput) (*DeleteAddonSubscriptionOutput, error) {
	req, out := c.DeleteAddonSubscriptionRequest(input)
	return out, req.Send()
}

// DeleteAddonSubscriptionWithContext is the same as DeleteAddonSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAddonSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) DeleteAddonSubscriptionWithContext(ctx aws.Context, input *DeleteAddonSubscriptionInput, opts ...request.Option) (*DeleteAddonSubscriptionOutput, error) {
	req, out := c.DeleteAddonSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteArchive = "DeleteArchive"

// DeleteArchiveRequest generates a "aws/request.Request" representing the
// client's request for the DeleteArchive operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteArchive for more information on using the DeleteArchive
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteArchiveRequest method.
//	req, resp := client.DeleteArchiveRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteArchive
func (c *MailManager) DeleteArchiveRequest(input *DeleteArchiveInput) (req *request.Request, output *DeleteArchiveOutput) {
	op := &request.Operation{
		Name:       opDeleteArchive,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteArchiveInput{}
	}

	output = &DeleteArchiveOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteArchive API operation for MailManager.
//
// Initiates deletion of an email archive. This changes the archive state to
// pending deletion. In this state, no new emails can be added, and existing
// archived emails become inaccessible (search, export, download). The archive
// and all of its contents will be permanently deleted 30 days after entering
// the pending deletion state, regardless of the configured retention period.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation DeleteArchive for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
//   - AccessDeniedException
//     Occurs when a user is denied access to a specific resource or action.
//
//   - ConflictException
//     The request configuration has conflicts. For details, see the accompanying
//     error message.
//
//   - ThrottlingException
//     Occurs when a service's request rate limit is exceeded, resulting in throttling
//     of further requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteArchive
func (c *MailManager) DeleteArchive(input *DeleteArchiveInput) (*DeleteArchiveOutput, error) {
	req, out := c.DeleteArchiveRequest(input)
	return out, req.Send()
}

// DeleteArchiveWithContext is the same as DeleteArchive with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteArchive for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) DeleteArchiveWithContext(ctx aws.Context, input *DeleteArchiveInput, opts ...request.Option) (*DeleteArchiveOutput, error) {
	req, out := c.DeleteArchiveRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIngressPoint = "DeleteIngressPoint"

// DeleteIngressPointRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIngressPoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIngressPoint for more information on using the DeleteIngressPoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteIngressPointRequest method.
//	req, resp := client.DeleteIngressPointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteIngressPoint
func (c *MailManager) DeleteIngressPointRequest(input *DeleteIngressPointInput) (req *request.Request, output *DeleteIngressPointOutput) {
	op := &request.Operation{
		Name:       opDeleteIngressPoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteIngressPointInput{}
	}

	output = &DeleteIngressPointOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteIngressPoint API operation for MailManager.
//
// Delete an ingress endpoint resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation DeleteIngressPoint for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
//   - ConflictException
//     The request configuration has conflicts. For details, see the accompanying
//     error message.
//
//   - ResourceNotFoundException
//     Occurs when a requested resource is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteIngressPoint
func (c *MailManager) DeleteIngressPoint(input *DeleteIngressPointInput) (*DeleteIngressPointOutput, error) {
	req, out := c.DeleteIngressPointRequest(input)
	return out, req.Send()
}

// DeleteIngressPointWithContext is the same as DeleteIngressPoint with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIngressPoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) DeleteIngressPointWithContext(ctx aws.Context, input *DeleteIngressPointInput, opts ...request.Option) (*DeleteIngressPointOutput, error) {
	req, out := c.DeleteIngressPointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRelay = "DeleteRelay"

// DeleteRelayRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRelay operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRelay for more information on using the DeleteRelay
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteRelayRequest method.
//	req, resp := client.DeleteRelayRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteRelay
func (c *MailManager) DeleteRelayRequest(input *DeleteRelayInput) (req *request.Request, output *DeleteRelayOutput) {
	op := &request.Operation{
		Name:       opDeleteRelay,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRelayInput{}
	}

	output = &DeleteRelayOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRelay API operation for MailManager.
//
// Deletes an existing relay resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation DeleteRelay for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
//   - ConflictException
//     The request configuration has conflicts. For details, see the accompanying
//     error message.
//
//   - ResourceNotFoundException
//     Occurs when a requested resource is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteRelay
func (c *MailManager) DeleteRelay(input *DeleteRelayInput) (*DeleteRelayOutput, error) {
	req, out := c.DeleteRelayRequest(input)
	return out, req.Send()
}

// DeleteRelayWithContext is the same as DeleteRelay with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRelay for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) DeleteRelayWithContext(ctx aws.Context, input *DeleteRelayInput, opts ...request.Option) (*DeleteRelayOutput, error) {
	req, out := c.DeleteRelayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRuleSet = "DeleteRuleSet"

// DeleteRuleSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRuleSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRuleSet for more information on using the DeleteRuleSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteRuleSetRequest method.
//	req, resp := client.DeleteRuleSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteRuleSet
func (c *MailManager) DeleteRuleSetRequest(input *DeleteRuleSetInput) (req *request.Request, output *DeleteRuleSetOutput) {
	op := &request.Operation{
		Name:       opDeleteRuleSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRuleSetInput{}
	}

	output = &DeleteRuleSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRuleSet API operation for MailManager.
//
// Delete a rule set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation DeleteRuleSet for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
//   - ConflictException
//     The request configuration has conflicts. For details, see the accompanying
//     error message.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteRuleSet
func (c *MailManager) DeleteRuleSet(input *DeleteRuleSetInput) (*DeleteRuleSetOutput, error) {
	req, out := c.DeleteRuleSetRequest(input)
	return out, req.Send()
}

// DeleteRuleSetWithContext is the same as DeleteRuleSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRuleSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) DeleteRuleSetWithContext(ctx aws.Context, input *DeleteRuleSetInput, opts ...request.Option) (*DeleteRuleSetOutput, error) {
	req, out := c.DeleteRuleSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTrafficPolicy = "DeleteTrafficPolicy"

// DeleteTrafficPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTrafficPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTrafficPolicy for more information on using the DeleteTrafficPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTrafficPolicyRequest method.
//	req, resp := client.DeleteTrafficPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteTrafficPolicy
func (c *MailManager) DeleteTrafficPolicyRequest(input *DeleteTrafficPolicyInput) (req *request.Request, output *DeleteTrafficPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteTrafficPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTrafficPolicyInput{}
	}

	output = &DeleteTrafficPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTrafficPolicy API operation for MailManager.
//
// Delete a traffic policy resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation DeleteTrafficPolicy for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
//   - ConflictException
//     The request configuration has conflicts. For details, see the accompanying
//     error message.
//
//   - ResourceNotFoundException
//     Occurs when a requested resource is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteTrafficPolicy
func (c *MailManager) DeleteTrafficPolicy(input *DeleteTrafficPolicyInput) (*DeleteTrafficPolicyOutput, error) {
	req, out := c.DeleteTrafficPolicyRequest(input)
	return out, req.Send()
}

// DeleteTrafficPolicyWithContext is the same as DeleteTrafficPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTrafficPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) DeleteTrafficPolicyWithContext(ctx aws.Context, input *DeleteTrafficPolicyInput, opts ...request.Option) (*DeleteTrafficPolicyOutput, error) {
	req, out := c.DeleteTrafficPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAddonInstance = "GetAddonInstance"

// GetAddonInstanceRequest generates a "aws/request.Request" representing the
// client's request for the GetAddonInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAddonInstance for more information on using the GetAddonInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAddonInstanceRequest method.
//	req, resp := client.GetAddonInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetAddonInstance
func (c *MailManager) GetAddonInstanceRequest(input *GetAddonInstanceInput) (req *request.Request, output *GetAddonInstanceOutput) {
	op := &request.Operation{
		Name:       opGetAddonInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAddonInstanceInput{}
	}

	output = &GetAddonInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAddonInstance API operation for MailManager.
//
// Gets detailed information about an Add On instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation GetAddonInstance for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
//   - ResourceNotFoundException
//     Occurs when a requested resource is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetAddonInstance
func (c *MailManager) GetAddonInstance(input *GetAddonInstanceInput) (*GetAddonInstanceOutput, error) {
	req, out := c.GetAddonInstanceRequest(input)
	return out, req.Send()
}

// GetAddonInstanceWithContext is the same as GetAddonInstance with the addition of
// the ability to pass a context and additional request options.
//
// See GetAddonInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) GetAddonInstanceWithContext(ctx aws.Context, input *GetAddonInstanceInput, opts ...request.Option) (*GetAddonInstanceOutput, error) {
	req, out := c.GetAddonInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAddonSubscription = "GetAddonSubscription"

// GetAddonSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the GetAddonSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAddonSubscription for more information on using the GetAddonSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAddonSubscriptionRequest method.
//	req, resp := client.GetAddonSubscriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetAddonSubscription
func (c *MailManager) GetAddonSubscriptionRequest(input *GetAddonSubscriptionInput) (req *request.Request, output *GetAddonSubscriptionOutput) {
	op := &request.Operation{
		Name:       opGetAddonSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAddonSubscriptionInput{}
	}

	output = &GetAddonSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAddonSubscription API operation for MailManager.
//
// Gets detailed information about an Add On subscription.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation GetAddonSubscription for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
//   - ResourceNotFoundException
//     Occurs when a requested resource is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetAddonSubscription
func (c *MailManager) GetAddonSubscription(input *GetAddonSubscriptionInput) (*GetAddonSubscriptionOutput, error) {
	req, out := c.GetAddonSubscriptionRequest(input)
	return out, req.Send()
}

// GetAddonSubscriptionWithContext is the same as GetAddonSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See GetAddonSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) GetAddonSubscriptionWithContext(ctx aws.Context, input *GetAddonSubscriptionInput, opts ...request.Option) (*GetAddonSubscriptionOutput, error) {
	req, out := c.GetAddonSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetArchive = "GetArchive"

// GetArchiveRequest generates a "aws/request.Request" representing the
// client's request for the GetArchive operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetArchive for more information on using the GetArchive
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetArchiveRequest method.
//	req, resp := client.GetArchiveRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetArchive
func (c *MailManager) GetArchiveRequest(input *GetArchiveInput) (req *request.Request, output *GetArchiveOutput) {
	op := &request.Operation{
		Name:       opGetArchive,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetArchiveInput{}
	}

	output = &GetArchiveOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetArchive API operation for MailManager.
//
// Retrieves the full details and current state of a specified email archive.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation GetArchive for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
//   - AccessDeniedException
//     Occurs when a user is denied access to a specific resource or action.
//
//   - ResourceNotFoundException
//     Occurs when a requested resource is not found.
//
//   - ThrottlingException
//     Occurs when a service's request rate limit is exceeded, resulting in throttling
//     of further requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetArchive
func (c *MailManager) GetArchive(input *GetArchiveInput) (*GetArchiveOutput, error) {
	req, out := c.GetArchiveRequest(input)
	return out, req.Send()
}

// GetArchiveWithContext is the same as GetArchive with the addition of
// the ability to pass a context and additional request options.
//
// See GetArchive for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) GetArchiveWithContext(ctx aws.Context, input *GetArchiveInput, opts ...request.Option) (*GetArchiveOutput, error) {
	req, out := c.GetArchiveRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetArchiveExport = "GetArchiveExport"

// GetArchiveExportRequest generates a "aws/request.Request" representing the
// client's request for the GetArchiveExport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetArchiveExport for more information on using the GetArchiveExport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetArchiveExportRequest method.
//	req, resp := client.GetArchiveExportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetArchiveExport
func (c *MailManager) GetArchiveExportRequest(input *GetArchiveExportInput) (req *request.Request, output *GetArchiveExportOutput) {
	op := &request.Operation{
		Name:       opGetArchiveExport,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetArchiveExportInput{}
	}

	output = &GetArchiveExportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetArchiveExport API operation for MailManager.
//
// Retrieves the details and current status of a specific email archive export
// job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation GetArchiveExport for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
//   - AccessDeniedException
//     Occurs when a user is denied access to a specific resource or action.
//
//   - ThrottlingException
//     Occurs when a service's request rate limit is exceeded, resulting in throttling
//     of further requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetArchiveExport
func (c *MailManager) GetArchiveExport(input *GetArchiveExportInput) (*GetArchiveExportOutput, error) {
	req, out := c.GetArchiveExportRequest(input)
	return out, req.Send()
}

// GetArchiveExportWithContext is the same as GetArchiveExport with the addition of
// the ability to pass a context and additional request options.
//
// See GetArchiveExport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) GetArchiveExportWithContext(ctx aws.Context, input *GetArchiveExportInput, opts ...request.Option) (*GetArchiveExportOutput, error) {
	req, out := c.GetArchiveExportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetArchiveMessage = "GetArchiveMessage"

// GetArchiveMessageRequest generates a "aws/request.Request" representing the
// client's request for the GetArchiveMessage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetArchiveMessage for more information on using the GetArchiveMessage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetArchiveMessageRequest method.
//	req, resp := client.GetArchiveMessageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetArchiveMessage
func (c *MailManager) GetArchiveMessageRequest(input *GetArchiveMessageInput) (req *request.Request, output *GetArchiveMessageOutput) {
	op := &request.Operation{
		Name:       opGetArchiveMessage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetArchiveMessageInput{}
	}

	output = &GetArchiveMessageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetArchiveMessage API operation for MailManager.
//
// Returns a pre-signed URL that provides temporary download access to the specific
// email message stored in the archive.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation GetArchiveMessage for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
//   - AccessDeniedException
//     Occurs when a user is denied access to a specific resource or action.
//
//   - ThrottlingException
//     Occurs when a service's request rate limit is exceeded, resulting in throttling
//     of further requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetArchiveMessage
func (c *MailManager) GetArchiveMessage(input *GetArchiveMessageInput) (*GetArchiveMessageOutput, error) {
	req, out := c.GetArchiveMessageRequest(input)
	return out, req.Send()
}

// GetArchiveMessageWithContext is the same as GetArchiveMessage with the addition of
// the ability to pass a context and additional request options.
//
// See GetArchiveMessage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) GetArchiveMessageWithContext(ctx aws.Context, input *GetArchiveMessageInput, opts ...request.Option) (*GetArchiveMessageOutput, error) {
	req, out := c.GetArchiveMessageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetArchiveMessageContent = "GetArchiveMessageContent"

// GetArchiveMessageContentRequest generates a "aws/request.Request" representing the
// client's request for the GetArchiveMessageContent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetArchiveMessageContent for more information on using the GetArchiveMessageContent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetArchiveMessageContentRequest method.
//	req, resp := client.GetArchiveMessageContentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetArchiveMessageContent
func (c *MailManager) GetArchiveMessageContentRequest(input *GetArchiveMessageContentInput) (req *request.Request, output *GetArchiveMessageContentOutput) {
	op := &request.Operation{
		Name:       opGetArchiveMessageContent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetArchiveMessageContentInput{}
	}

	output = &GetArchiveMessageContentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetArchiveMessageContent API operation for MailManager.
//
// Returns the textual content of a specific email message stored in the archive.
// Attachments are not included.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation GetArchiveMessageContent for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
//   - AccessDeniedException
//     Occurs when a user is denied access to a specific resource or action.
//
//   - ThrottlingException
//     Occurs when a service's request rate limit is exceeded, resulting in throttling
//     of further requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetArchiveMessageContent
func (c *MailManager) GetArchiveMessageContent(input *GetArchiveMessageContentInput) (*GetArchiveMessageContentOutput, error) {
	req, out := c.GetArchiveMessageContentRequest(input)
	return out, req.Send()
}

// GetArchiveMessageContentWithContext is the same as GetArchiveMessageContent with the addition of
// the ability to pass a context and additional request options.
//
// See GetArchiveMessageContent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) GetArchiveMessageContentWithContext(ctx aws.Context, input *GetArchiveMessageContentInput, opts ...request.Option) (*GetArchiveMessageContentOutput, error) {
	req, out := c.GetArchiveMessageContentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetArchiveSearch = "GetArchiveSearch"

// GetArchiveSearchRequest generates a "aws/request.Request" representing the
// client's request for the GetArchiveSearch operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetArchiveSearch for more information on using the GetArchiveSearch
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetArchiveSearchRequest method.
//	req, resp := client.GetArchiveSearchRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetArchiveSearch
func (c *MailManager) GetArchiveSearchRequest(input *GetArchiveSearchInput) (req *request.Request, output *GetArchiveSearchOutput) {
	op := &request.Operation{
		Name:       opGetArchiveSearch,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetArchiveSearchInput{}
	}

	output = &GetArchiveSearchOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetArchiveSearch API operation for MailManager.
//
// Retrieves the details and current status of a specific email archive search
// job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation GetArchiveSearch for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
//   - AccessDeniedException
//     Occurs when a user is denied access to a specific resource or action.
//
//   - ThrottlingException
//     Occurs when a service's request rate limit is exceeded, resulting in throttling
//     of further requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetArchiveSearch
func (c *MailManager) GetArchiveSearch(input *GetArchiveSearchInput) (*GetArchiveSearchOutput, error) {
	req, out := c.GetArchiveSearchRequest(input)
	return out, req.Send()
}

// GetArchiveSearchWithContext is the same as GetArchiveSearch with the addition of
// the ability to pass a context and additional request options.
//
// See GetArchiveSearch for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) GetArchiveSearchWithContext(ctx aws.Context, input *GetArchiveSearchInput, opts ...request.Option) (*GetArchiveSearchOutput, error) {
	req, out := c.GetArchiveSearchRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetArchiveSearchResults = "GetArchiveSearchResults"

// GetArchiveSearchResultsRequest generates a "aws/request.Request" representing the
// client's request for the GetArchiveSearchResults operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetArchiveSearchResults for more information on using the GetArchiveSearchResults
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetArchiveSearchResultsRequest method.
//	req, resp := client.GetArchiveSearchResultsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetArchiveSearchResults
func (c *MailManager) GetArchiveSearchResultsRequest(input *GetArchiveSearchResultsInput) (req *request.Request, output *GetArchiveSearchResultsOutput) {
	op := &request.Operation{
		Name:       opGetArchiveSearchResults,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetArchiveSearchResultsInput{}
	}

	output = &GetArchiveSearchResultsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetArchiveSearchResults API operation for MailManager.
//
// Returns the results of a completed email archive search job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation GetArchiveSearchResults for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
//   - AccessDeniedException
//     Occurs when a user is denied access to a specific resource or action.
//
//   - ConflictException
//     The request configuration has conflicts. For details, see the accompanying
//     error message.
//
//   - ThrottlingException
//     Occurs when a service's request rate limit is exceeded, resulting in throttling
//     of further requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetArchiveSearchResults
func (c *MailManager) GetArchiveSearchResults(input *GetArchiveSearchResultsInput) (*GetArchiveSearchResultsOutput, error) {
	req, out := c.GetArchiveSearchResultsRequest(input)
	return out, req.Send()
}

// GetArchiveSearchResultsWithContext is the same as GetArchiveSearchResults with the addition of
// the ability to pass a context and additional request options.
//
// See GetArchiveSearchResults for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) GetArchiveSearchResultsWithContext(ctx aws.Context, input *GetArchiveSearchResultsInput, opts ...request.Option) (*GetArchiveSearchResultsOutput, error) {
	req, out := c.GetArchiveSearchResultsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIngressPoint = "GetIngressPoint"

// GetIngressPointRequest generates a "aws/request.Request" representing the
// client's request for the GetIngressPoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIngressPoint for more information on using the GetIngressPoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetIngressPointRequest method.
//	req, resp := client.GetIngressPointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetIngressPoint
func (c *MailManager) GetIngressPointRequest(input *GetIngressPointInput) (req *request.Request, output *GetIngressPointOutput) {
	op := &request.Operation{
		Name:       opGetIngressPoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetIngressPointInput{}
	}

	output = &GetIngressPointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIngressPoint API operation for MailManager.
//
// Fetch ingress endpoint resource attributes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation GetIngressPoint for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
//   - ResourceNotFoundException
//     Occurs when a requested resource is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetIngressPoint
func (c *MailManager) GetIngressPoint(input *GetIngressPointInput) (*GetIngressPointOutput, error) {
	req, out := c.GetIngressPointRequest(input)
	return out, req.Send()
}

// GetIngressPointWithContext is the same as GetIngressPoint with the addition of
// the ability to pass a context and additional request options.
//
// See GetIngressPoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) GetIngressPointWithContext(ctx aws.Context, input *GetIngressPointInput, opts ...request.Option) (*GetIngressPointOutput, error) {
	req, out := c.GetIngressPointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRelay = "GetRelay"

// GetRelayRequest generates a "aws/request.Request" representing the
// client's request for the GetRelay operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRelay for more information on using the GetRelay
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRelayRequest method.
//	req, resp := client.GetRelayRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetRelay
func (c *MailManager) GetRelayRequest(input *GetRelayInput) (req *request.Request, output *GetRelayOutput) {
	op := &request.Operation{
		Name:       opGetRelay,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRelayInput{}
	}

	output = &GetRelayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRelay API operation for MailManager.
//
// Fetch the relay resource and it's attributes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation GetRelay for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
//   - ResourceNotFoundException
//     Occurs when a requested resource is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetRelay
func (c *MailManager) GetRelay(input *GetRelayInput) (*GetRelayOutput, error) {
	req, out := c.GetRelayRequest(input)
	return out, req.Send()
}

// GetRelayWithContext is the same as GetRelay with the addition of
// the ability to pass a context and additional request options.
//
// See GetRelay for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) GetRelayWithContext(ctx aws.Context, input *GetRelayInput, opts ...request.Option) (*GetRelayOutput, error) {
	req, out := c.GetRelayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRuleSet = "GetRuleSet"

// GetRuleSetRequest generates a "aws/request.Request" representing the
// client's request for the GetRuleSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRuleSet for more information on using the GetRuleSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRuleSetRequest method.
//	req, resp := client.GetRuleSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetRuleSet
func (c *MailManager) GetRuleSetRequest(input *GetRuleSetInput) (req *request.Request, output *GetRuleSetOutput) {
	op := &request.Operation{
		Name:       opGetRuleSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRuleSetInput{}
	}

	output = &GetRuleSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRuleSet API operation for MailManager.
//
// Fetch attributes of a rule set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation GetRuleSet for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
//   - ResourceNotFoundException
//     Occurs when a requested resource is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetRuleSet
func (c *MailManager) GetRuleSet(input *GetRuleSetInput) (*GetRuleSetOutput, error) {
	req, out := c.GetRuleSetRequest(input)
	return out, req.Send()
}

// GetRuleSetWithContext is the same as GetRuleSet with the addition of
// the ability to pass a context and additional request options.
//
// See GetRuleSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) GetRuleSetWithContext(ctx aws.Context, input *GetRuleSetInput, opts ...request.Option) (*GetRuleSetOutput, error) {
	req, out := c.GetRuleSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTrafficPolicy = "GetTrafficPolicy"

// GetTrafficPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetTrafficPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTrafficPolicy for more information on using the GetTrafficPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTrafficPolicyRequest method.
//	req, resp := client.GetTrafficPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetTrafficPolicy
func (c *MailManager) GetTrafficPolicyRequest(input *GetTrafficPolicyInput) (req *request.Request, output *GetTrafficPolicyOutput) {
	op := &request.Operation{
		Name:       opGetTrafficPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTrafficPolicyInput{}
	}

	output = &GetTrafficPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTrafficPolicy API operation for MailManager.
//
// Fetch attributes of a traffic policy resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation GetTrafficPolicy for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
//   - ResourceNotFoundException
//     Occurs when a requested resource is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetTrafficPolicy
func (c *MailManager) GetTrafficPolicy(input *GetTrafficPolicyInput) (*GetTrafficPolicyOutput, error) {
	req, out := c.GetTrafficPolicyRequest(input)
	return out, req.Send()
}

// GetTrafficPolicyWithContext is the same as GetTrafficPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetTrafficPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) GetTrafficPolicyWithContext(ctx aws.Context, input *GetTrafficPolicyInput, opts ...request.Option) (*GetTrafficPolicyOutput, error) {
	req, out := c.GetTrafficPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAddonInstances = "ListAddonInstances"

// ListAddonInstancesRequest generates a "aws/request.Request" representing the
// client's request for the ListAddonInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAddonInstances for more information on using the ListAddonInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAddonInstancesRequest method.
//	req, resp := client.ListAddonInstancesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListAddonInstances
func (c *MailManager) ListAddonInstancesRequest(input *ListAddonInstancesInput) (req *request.Request, output *ListAddonInstancesOutput) {
	op := &request.Operation{
		Name:       opListAddonInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "PageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAddonInstancesInput{}
	}

	output = &ListAddonInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAddonInstances API operation for MailManager.
//
// Lists all Add On instances in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation ListAddonInstances for usage and error information.
//
// Returned Error Types:
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListAddonInstances
func (c *MailManager) ListAddonInstances(input *ListAddonInstancesInput) (*ListAddonInstancesOutput, error) {
	req, out := c.ListAddonInstancesRequest(input)
	return out, req.Send()
}

// ListAddonInstancesWithContext is the same as ListAddonInstances with the addition of
// the ability to pass a context and additional request options.
//
// See ListAddonInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) ListAddonInstancesWithContext(ctx aws.Context, input *ListAddonInstancesInput, opts ...request.Option) (*ListAddonInstancesOutput, error) {
	req, out := c.ListAddonInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAddonInstancesPages iterates over the pages of a ListAddonInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAddonInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAddonInstances operation.
//	pageNum := 0
//	err := client.ListAddonInstancesPages(params,
//	    func(page *mailmanager.ListAddonInstancesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MailManager) ListAddonInstancesPages(input *ListAddonInstancesInput, fn func(*ListAddonInstancesOutput, bool) bool) error {
	return c.ListAddonInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAddonInstancesPagesWithContext same as ListAddonInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) ListAddonInstancesPagesWithContext(ctx aws.Context, input *ListAddonInstancesInput, fn func(*ListAddonInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAddonInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAddonInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAddonInstancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAddonSubscriptions = "ListAddonSubscriptions"

// ListAddonSubscriptionsRequest generates a "aws/request.Request" representing the
// client's request for the ListAddonSubscriptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAddonSubscriptions for more information on using the ListAddonSubscriptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAddonSubscriptionsRequest method.
//	req, resp := client.ListAddonSubscriptionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListAddonSubscriptions
func (c *MailManager) ListAddonSubscriptionsRequest(input *ListAddonSubscriptionsInput) (req *request.Request, output *ListAddonSubscriptionsOutput) {
	op := &request.Operation{
		Name:       opListAddonSubscriptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "PageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAddonSubscriptionsInput{}
	}

	output = &ListAddonSubscriptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAddonSubscriptions API operation for MailManager.
//
// Lists all Add On subscriptions in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation ListAddonSubscriptions for usage and error information.
//
// Returned Error Types:
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListAddonSubscriptions
func (c *MailManager) ListAddonSubscriptions(input *ListAddonSubscriptionsInput) (*ListAddonSubscriptionsOutput, error) {
	req, out := c.ListAddonSubscriptionsRequest(input)
	return out, req.Send()
}

// ListAddonSubscriptionsWithContext is the same as ListAddonSubscriptions with the addition of
// the ability to pass a context and additional request options.
//
// See ListAddonSubscriptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) ListAddonSubscriptionsWithContext(ctx aws.Context, input *ListAddonSubscriptionsInput, opts ...request.Option) (*ListAddonSubscriptionsOutput, error) {
	req, out := c.ListAddonSubscriptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAddonSubscriptionsPages iterates over the pages of a ListAddonSubscriptions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAddonSubscriptions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAddonSubscriptions operation.
//	pageNum := 0
//	err := client.ListAddonSubscriptionsPages(params,
//	    func(page *mailmanager.ListAddonSubscriptionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MailManager) ListAddonSubscriptionsPages(input *ListAddonSubscriptionsInput, fn func(*ListAddonSubscriptionsOutput, bool) bool) error {
	return c.ListAddonSubscriptionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAddonSubscriptionsPagesWithContext same as ListAddonSubscriptionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) ListAddonSubscriptionsPagesWithContext(ctx aws.Context, input *ListAddonSubscriptionsInput, fn func(*ListAddonSubscriptionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAddonSubscriptionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAddonSubscriptionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAddonSubscriptionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListArchiveExports = "ListArchiveExports"

// ListArchiveExportsRequest generates a "aws/request.Request" representing the
// client's request for the ListArchiveExports operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListArchiveExports for more information on using the ListArchiveExports
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListArchiveExportsRequest method.
//	req, resp := client.ListArchiveExportsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListArchiveExports
func (c *MailManager) ListArchiveExportsRequest(input *ListArchiveExportsInput) (req *request.Request, output *ListArchiveExportsOutput) {
	op := &request.Operation{
		Name:       opListArchiveExports,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "PageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListArchiveExportsInput{}
	}

	output = &ListArchiveExportsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListArchiveExports API operation for MailManager.
//
// Returns a list of email archive export jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation ListArchiveExports for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
//   - AccessDeniedException
//     Occurs when a user is denied access to a specific resource or action.
//
//   - ResourceNotFoundException
//     Occurs when a requested resource is not found.
//
//   - ThrottlingException
//     Occurs when a service's request rate limit is exceeded, resulting in throttling
//     of further requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListArchiveExports
func (c *MailManager) ListArchiveExports(input *ListArchiveExportsInput) (*ListArchiveExportsOutput, error) {
	req, out := c.ListArchiveExportsRequest(input)
	return out, req.Send()
}

// ListArchiveExportsWithContext is the same as ListArchiveExports with the addition of
// the ability to pass a context and additional request options.
//
// See ListArchiveExports for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) ListArchiveExportsWithContext(ctx aws.Context, input *ListArchiveExportsInput, opts ...request.Option) (*ListArchiveExportsOutput, error) {
	req, out := c.ListArchiveExportsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListArchiveExportsPages iterates over the pages of a ListArchiveExports operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListArchiveExports method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListArchiveExports operation.
//	pageNum := 0
//	err := client.ListArchiveExportsPages(params,
//	    func(page *mailmanager.ListArchiveExportsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MailManager) ListArchiveExportsPages(input *ListArchiveExportsInput, fn func(*ListArchiveExportsOutput, bool) bool) error {
	return c.ListArchiveExportsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListArchiveExportsPagesWithContext same as ListArchiveExportsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) ListArchiveExportsPagesWithContext(ctx aws.Context, input *ListArchiveExportsInput, fn func(*ListArchiveExportsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListArchiveExportsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListArchiveExportsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListArchiveExportsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListArchiveSearches = "ListArchiveSearches"

// ListArchiveSearchesRequest generates a "aws/request.Request" representing the
// client's request for the ListArchiveSearches operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListArchiveSearches for more information on using the ListArchiveSearches
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListArchiveSearchesRequest method.
//	req, resp := client.ListArchiveSearchesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListArchiveSearches
func (c *MailManager) ListArchiveSearchesRequest(input *ListArchiveSearchesInput) (req *request.Request, output *ListArchiveSearchesOutput) {
	op := &request.Operation{
		Name:       opListArchiveSearches,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "PageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListArchiveSearchesInput{}
	}

	output = &ListArchiveSearchesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListArchiveSearches API operation for MailManager.
//
// Returns a list of email archive search jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation ListArchiveSearches for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
//   - AccessDeniedException
//     Occurs when a user is denied access to a specific resource or action.
//
//   - ResourceNotFoundException
//     Occurs when a requested resource is not found.
//
//   - ThrottlingException
//     Occurs when a service's request rate limit is exceeded, resulting in throttling
//     of further requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListArchiveSearches
func (c *MailManager) ListArchiveSearches(input *ListArchiveSearchesInput) (*ListArchiveSearchesOutput, error) {
	req, out := c.ListArchiveSearchesRequest(input)
	return out, req.Send()
}

// ListArchiveSearchesWithContext is the same as ListArchiveSearches with the addition of
// the ability to pass a context and additional request options.
//
// See ListArchiveSearches for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) ListArchiveSearchesWithContext(ctx aws.Context, input *ListArchiveSearchesInput, opts ...request.Option) (*ListArchiveSearchesOutput, error) {
	req, out := c.ListArchiveSearchesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListArchiveSearchesPages iterates over the pages of a ListArchiveSearches operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListArchiveSearches method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListArchiveSearches operation.
//	pageNum := 0
//	err := client.ListArchiveSearchesPages(params,
//	    func(page *mailmanager.ListArchiveSearchesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MailManager) ListArchiveSearchesPages(input *ListArchiveSearchesInput, fn func(*ListArchiveSearchesOutput, bool) bool) error {
	return c.ListArchiveSearchesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListArchiveSearchesPagesWithContext same as ListArchiveSearchesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) ListArchiveSearchesPagesWithContext(ctx aws.Context, input *ListArchiveSearchesInput, fn func(*ListArchiveSearchesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListArchiveSearchesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListArchiveSearchesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListArchiveSearchesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListArchives = "ListArchives"

// ListArchivesRequest generates a "aws/request.Request" representing the
// client's request for the ListArchives operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListArchives for more information on using the ListArchives
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListArchivesRequest method.
//	req, resp := client.ListArchivesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListArchives
func (c *MailManager) ListArchivesRequest(input *ListArchivesInput) (req *request.Request, output *ListArchivesOutput) {
	op := &request.Operation{
		Name:       opListArchives,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "PageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListArchivesInput{}
	}

	output = &ListArchivesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListArchives API operation for MailManager.
//
// Returns a list of all email archives in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation ListArchives for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
//   - AccessDeniedException
//     Occurs when a user is denied access to a specific resource or action.
//
//   - ThrottlingException
//     Occurs when a service's request rate limit is exceeded, resulting in throttling
//     of further requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListArchives
func (c *MailManager) ListArchives(input *ListArchivesInput) (*ListArchivesOutput, error) {
	req, out := c.ListArchivesRequest(input)
	return out, req.Send()
}

// ListArchivesWithContext is the same as ListArchives with the addition of
// the ability to pass a context and additional request options.
//
// See ListArchives for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) ListArchivesWithContext(ctx aws.Context, input *ListArchivesInput, opts ...request.Option) (*ListArchivesOutput, error) {
	req, out := c.ListArchivesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListArchivesPages iterates over the pages of a ListArchives operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListArchives method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListArchives operation.
//	pageNum := 0
//	err := client.ListArchivesPages(params,
//	    func(page *mailmanager.ListArchivesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MailManager) ListArchivesPages(input *ListArchivesInput, fn func(*ListArchivesOutput, bool) bool) error {
	return c.ListArchivesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListArchivesPagesWithContext same as ListArchivesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) ListArchivesPagesWithContext(ctx aws.Context, input *ListArchivesInput, fn func(*ListArchivesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListArchivesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListArchivesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListArchivesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListIngressPoints = "ListIngressPoints"

// ListIngressPointsRequest generates a "aws/request.Request" representing the
// client's request for the ListIngressPoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIngressPoints for more information on using the ListIngressPoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListIngressPointsRequest method.
//	req, resp := client.ListIngressPointsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListIngressPoints
func (c *MailManager) ListIngressPointsRequest(input *ListIngressPointsInput) (req *request.Request, output *ListIngressPointsOutput) {
	op := &request.Operation{
		Name:       opListIngressPoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "PageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListIngressPointsInput{}
	}

	output = &ListIngressPointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIngressPoints API operation for MailManager.
//
// List all ingress endpoint resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation ListIngressPoints for usage and error information.
//
// Returned Error Types:
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListIngressPoints
func (c *MailManager) ListIngressPoints(input *ListIngressPointsInput) (*ListIngressPointsOutput, error) {
	req, out := c.ListIngressPointsRequest(input)
	return out, req.Send()
}

// ListIngressPointsWithContext is the same as ListIngressPoints with the addition of
// the ability to pass a context and additional request options.
//
// See ListIngressPoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) ListIngressPointsWithContext(ctx aws.Context, input *ListIngressPointsInput, opts ...request.Option) (*ListIngressPointsOutput, error) {
	req, out := c.ListIngressPointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListIngressPointsPages iterates over the pages of a ListIngressPoints operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListIngressPoints method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListIngressPoints operation.
//	pageNum := 0
//	err := client.ListIngressPointsPages(params,
//	    func(page *mailmanager.ListIngressPointsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MailManager) ListIngressPointsPages(input *ListIngressPointsInput, fn func(*ListIngressPointsOutput, bool) bool) error {
	return c.ListIngressPointsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListIngressPointsPagesWithContext same as ListIngressPointsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) ListIngressPointsPagesWithContext(ctx aws.Context, input *ListIngressPointsInput, fn func(*ListIngressPointsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListIngressPointsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListIngressPointsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListIngressPointsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRelays = "ListRelays"

// ListRelaysRequest generates a "aws/request.Request" representing the
// client's request for the ListRelays operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRelays for more information on using the ListRelays
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRelaysRequest method.
//	req, resp := client.ListRelaysRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListRelays
func (c *MailManager) ListRelaysRequest(input *ListRelaysInput) (req *request.Request, output *ListRelaysOutput) {
	op := &request.Operation{
		Name:       opListRelays,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "PageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRelaysInput{}
	}

	output = &ListRelaysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRelays API operation for MailManager.
//
// Lists all the existing relay resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation ListRelays for usage and error information.
//
// Returned Error Types:
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListRelays
func (c *MailManager) ListRelays(input *ListRelaysInput) (*ListRelaysOutput, error) {
	req, out := c.ListRelaysRequest(input)
	return out, req.Send()
}

// ListRelaysWithContext is the same as ListRelays with the addition of
// the ability to pass a context and additional request options.
//
// See ListRelays for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) ListRelaysWithContext(ctx aws.Context, input *ListRelaysInput, opts ...request.Option) (*ListRelaysOutput, error) {
	req, out := c.ListRelaysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRelaysPages iterates over the pages of a ListRelays operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRelays method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRelays operation.
//	pageNum := 0
//	err := client.ListRelaysPages(params,
//	    func(page *mailmanager.ListRelaysOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MailManager) ListRelaysPages(input *ListRelaysInput, fn func(*ListRelaysOutput, bool) bool) error {
	return c.ListRelaysPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRelaysPagesWithContext same as ListRelaysPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) ListRelaysPagesWithContext(ctx aws.Context, input *ListRelaysInput, fn func(*ListRelaysOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRelaysInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRelaysRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRelaysOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRuleSets = "ListRuleSets"

// ListRuleSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListRuleSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRuleSets for more information on using the ListRuleSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRuleSetsRequest method.
//	req, resp := client.ListRuleSetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListRuleSets
func (c *MailManager) ListRuleSetsRequest(input *ListRuleSetsInput) (req *request.Request, output *ListRuleSetsOutput) {
	op := &request.Operation{
		Name:       opListRuleSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "PageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRuleSetsInput{}
	}

	output = &ListRuleSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRuleSets API operation for MailManager.
//
// List rule sets for this account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation ListRuleSets for usage and error information.
//
// Returned Error Types:
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListRuleSets
func (c *MailManager) ListRuleSets(input *ListRuleSetsInput) (*ListRuleSetsOutput, error) {
	req, out := c.ListRuleSetsRequest(input)
	return out, req.Send()
}

// ListRuleSetsWithContext is the same as ListRuleSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListRuleSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) ListRuleSetsWithContext(ctx aws.Context, input *ListRuleSetsInput, opts ...request.Option) (*ListRuleSetsOutput, error) {
	req, out := c.ListRuleSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRuleSetsPages iterates over the pages of a ListRuleSets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRuleSets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRuleSets operation.
//	pageNum := 0
//	err := client.ListRuleSetsPages(params,
//	    func(page *mailmanager.ListRuleSetsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MailManager) ListRuleSetsPages(input *ListRuleSetsInput, fn func(*ListRuleSetsOutput, bool) bool) error {
	return c.ListRuleSetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRuleSetsPagesWithContext same as ListRuleSetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) ListRuleSetsPagesWithContext(ctx aws.Context, input *ListRuleSetsInput, fn func(*ListRuleSetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRuleSetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRuleSetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRuleSetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListTagsForResource
func (c *MailManager) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for MailManager.
//
// Retrieves the list of tags (keys and values) assigned to the resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
//   - ResourceNotFoundException
//     Occurs when a requested resource is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListTagsForResource
func (c *MailManager) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTrafficPolicies = "ListTrafficPolicies"

// ListTrafficPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the ListTrafficPolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTrafficPolicies for more information on using the ListTrafficPolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTrafficPoliciesRequest method.
//	req, resp := client.ListTrafficPoliciesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListTrafficPolicies
func (c *MailManager) ListTrafficPoliciesRequest(input *ListTrafficPoliciesInput) (req *request.Request, output *ListTrafficPoliciesOutput) {
	op := &request.Operation{
		Name:       opListTrafficPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "PageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTrafficPoliciesInput{}
	}

	output = &ListTrafficPoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTrafficPolicies API operation for MailManager.
//
// List traffic policy resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation ListTrafficPolicies for usage and error information.
//
// Returned Error Types:
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListTrafficPolicies
func (c *MailManager) ListTrafficPolicies(input *ListTrafficPoliciesInput) (*ListTrafficPoliciesOutput, error) {
	req, out := c.ListTrafficPoliciesRequest(input)
	return out, req.Send()
}

// ListTrafficPoliciesWithContext is the same as ListTrafficPolicies with the addition of
// the ability to pass a context and additional request options.
//
// See ListTrafficPolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) ListTrafficPoliciesWithContext(ctx aws.Context, input *ListTrafficPoliciesInput, opts ...request.Option) (*ListTrafficPoliciesOutput, error) {
	req, out := c.ListTrafficPoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTrafficPoliciesPages iterates over the pages of a ListTrafficPolicies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTrafficPolicies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTrafficPolicies operation.
//	pageNum := 0
//	err := client.ListTrafficPoliciesPages(params,
//	    func(page *mailmanager.ListTrafficPoliciesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MailManager) ListTrafficPoliciesPages(input *ListTrafficPoliciesInput, fn func(*ListTrafficPoliciesOutput, bool) bool) error {
	return c.ListTrafficPoliciesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTrafficPoliciesPagesWithContext same as ListTrafficPoliciesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) ListTrafficPoliciesPagesWithContext(ctx aws.Context, input *ListTrafficPoliciesInput, fn func(*ListTrafficPoliciesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTrafficPoliciesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTrafficPoliciesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTrafficPoliciesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opStartArchiveExport = "StartArchiveExport"

// StartArchiveExportRequest generates a "aws/request.Request" representing the
// client's request for the StartArchiveExport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartArchiveExport for more information on using the StartArchiveExport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartArchiveExportRequest method.
//	req, resp := client.StartArchiveExportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/StartArchiveExport
func (c *MailManager) StartArchiveExportRequest(input *StartArchiveExportInput) (req *request.Request, output *StartArchiveExportOutput) {
	op := &request.Operation{
		Name:       opStartArchiveExport,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartArchiveExportInput{}
	}

	output = &StartArchiveExportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartArchiveExport API operation for MailManager.
//
// Initiates an export of emails from the specified archive.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation StartArchiveExport for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
//   - AccessDeniedException
//     Occurs when a user is denied access to a specific resource or action.
//
//   - ServiceQuotaExceededException
//     Occurs when an operation exceeds a predefined service quota or limit.
//
//   - ResourceNotFoundException
//     Occurs when a requested resource is not found.
//
//   - ThrottlingException
//     Occurs when a service's request rate limit is exceeded, resulting in throttling
//     of further requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/StartArchiveExport
func (c *MailManager) StartArchiveExport(input *StartArchiveExportInput) (*StartArchiveExportOutput, error) {
	req, out := c.StartArchiveExportRequest(input)
	return out, req.Send()
}

// StartArchiveExportWithContext is the same as StartArchiveExport with the addition of
// the ability to pass a context and additional request options.
//
// See StartArchiveExport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) StartArchiveExportWithContext(ctx aws.Context, input *StartArchiveExportInput, opts ...request.Option) (*StartArchiveExportOutput, error) {
	req, out := c.StartArchiveExportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartArchiveSearch = "StartArchiveSearch"

// StartArchiveSearchRequest generates a "aws/request.Request" representing the
// client's request for the StartArchiveSearch operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartArchiveSearch for more information on using the StartArchiveSearch
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartArchiveSearchRequest method.
//	req, resp := client.StartArchiveSearchRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/StartArchiveSearch
func (c *MailManager) StartArchiveSearchRequest(input *StartArchiveSearchInput) (req *request.Request, output *StartArchiveSearchOutput) {
	op := &request.Operation{
		Name:       opStartArchiveSearch,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartArchiveSearchInput{}
	}

	output = &StartArchiveSearchOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartArchiveSearch API operation for MailManager.
//
// Initiates a search across emails in the specified archive.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation StartArchiveSearch for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
//   - AccessDeniedException
//     Occurs when a user is denied access to a specific resource or action.
//
//   - ServiceQuotaExceededException
//     Occurs when an operation exceeds a predefined service quota or limit.
//
//   - ConflictException
//     The request configuration has conflicts. For details, see the accompanying
//     error message.
//
//   - ResourceNotFoundException
//     Occurs when a requested resource is not found.
//
//   - ThrottlingException
//     Occurs when a service's request rate limit is exceeded, resulting in throttling
//     of further requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/StartArchiveSearch
func (c *MailManager) StartArchiveSearch(input *StartArchiveSearchInput) (*StartArchiveSearchOutput, error) {
	req, out := c.StartArchiveSearchRequest(input)
	return out, req.Send()
}

// StartArchiveSearchWithContext is the same as StartArchiveSearch with the addition of
// the ability to pass a context and additional request options.
//
// See StartArchiveSearch for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) StartArchiveSearchWithContext(ctx aws.Context, input *StartArchiveSearchInput, opts ...request.Option) (*StartArchiveSearchOutput, error) {
	req, out := c.StartArchiveSearchRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopArchiveExport = "StopArchiveExport"

// StopArchiveExportRequest generates a "aws/request.Request" representing the
// client's request for the StopArchiveExport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopArchiveExport for more information on using the StopArchiveExport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopArchiveExportRequest method.
//	req, resp := client.StopArchiveExportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/StopArchiveExport
func (c *MailManager) StopArchiveExportRequest(input *StopArchiveExportInput) (req *request.Request, output *StopArchiveExportOutput) {
	op := &request.Operation{
		Name:       opStopArchiveExport,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopArchiveExportInput{}
	}

	output = &StopArchiveExportOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopArchiveExport API operation for MailManager.
//
// Stops an in-progress export of emails from an archive.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation StopArchiveExport for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
//   - AccessDeniedException
//     Occurs when a user is denied access to a specific resource or action.
//
//   - ThrottlingException
//     Occurs when a service's request rate limit is exceeded, resulting in throttling
//     of further requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/StopArchiveExport
func (c *MailManager) StopArchiveExport(input *StopArchiveExportInput) (*StopArchiveExportOutput, error) {
	req, out := c.StopArchiveExportRequest(input)
	return out, req.Send()
}

// StopArchiveExportWithContext is the same as StopArchiveExport with the addition of
// the ability to pass a context and additional request options.
//
// See StopArchiveExport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) StopArchiveExportWithContext(ctx aws.Context, input *StopArchiveExportInput, opts ...request.Option) (*StopArchiveExportOutput, error) {
	req, out := c.StopArchiveExportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopArchiveSearch = "StopArchiveSearch"

// StopArchiveSearchRequest generates a "aws/request.Request" representing the
// client's request for the StopArchiveSearch operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopArchiveSearch for more information on using the StopArchiveSearch
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopArchiveSearchRequest method.
//	req, resp := client.StopArchiveSearchRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/StopArchiveSearch
func (c *MailManager) StopArchiveSearchRequest(input *StopArchiveSearchInput) (req *request.Request, output *StopArchiveSearchOutput) {
	op := &request.Operation{
		Name:       opStopArchiveSearch,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopArchiveSearchInput{}
	}

	output = &StopArchiveSearchOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopArchiveSearch API operation for MailManager.
//
// Stops an in-progress archive search job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation StopArchiveSearch for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
//   - AccessDeniedException
//     Occurs when a user is denied access to a specific resource or action.
//
//   - ThrottlingException
//     Occurs when a service's request rate limit is exceeded, resulting in throttling
//     of further requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/StopArchiveSearch
func (c *MailManager) StopArchiveSearch(input *StopArchiveSearchInput) (*StopArchiveSearchOutput, error) {
	req, out := c.StopArchiveSearchRequest(input)
	return out, req.Send()
}

// StopArchiveSearchWithContext is the same as StopArchiveSearch with the addition of
// the ability to pass a context and additional request options.
//
// See StopArchiveSearch for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) StopArchiveSearchWithContext(ctx aws.Context, input *StopArchiveSearchInput, opts ...request.Option) (*StopArchiveSearchOutput, error) {
	req, out := c.StopArchiveSearchRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/TagResource
func (c *MailManager) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for MailManager.
//
// Adds one or more tags (keys and values) to a specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
//   - ServiceQuotaExceededException
//     Occurs when an operation exceeds a predefined service quota or limit.
//
//   - ConflictException
//     The request configuration has conflicts. For details, see the accompanying
//     error message.
//
//   - ResourceNotFoundException
//     Occurs when a requested resource is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/TagResource
func (c *MailManager) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/UntagResource
func (c *MailManager) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for MailManager.
//
// Remove one or more tags (keys and values) from a specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
//   - ConflictException
//     The request configuration has conflicts. For details, see the accompanying
//     error message.
//
//   - ResourceNotFoundException
//     Occurs when a requested resource is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/UntagResource
func (c *MailManager) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateArchive = "UpdateArchive"

// UpdateArchiveRequest generates a "aws/request.Request" representing the
// client's request for the UpdateArchive operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateArchive for more information on using the UpdateArchive
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateArchiveRequest method.
//	req, resp := client.UpdateArchiveRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/UpdateArchive
func (c *MailManager) UpdateArchiveRequest(input *UpdateArchiveInput) (req *request.Request, output *UpdateArchiveOutput) {
	op := &request.Operation{
		Name:       opUpdateArchive,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateArchiveInput{}
	}

	output = &UpdateArchiveOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateArchive API operation for MailManager.
//
// Updates the attributes of an existing email archive.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation UpdateArchive for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
//   - AccessDeniedException
//     Occurs when a user is denied access to a specific resource or action.
//
//   - ServiceQuotaExceededException
//     Occurs when an operation exceeds a predefined service quota or limit.
//
//   - ConflictException
//     The request configuration has conflicts. For details, see the accompanying
//     error message.
//
//   - ResourceNotFoundException
//     Occurs when a requested resource is not found.
//
//   - ThrottlingException
//     Occurs when a service's request rate limit is exceeded, resulting in throttling
//     of further requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/UpdateArchive
func (c *MailManager) UpdateArchive(input *UpdateArchiveInput) (*UpdateArchiveOutput, error) {
	req, out := c.UpdateArchiveRequest(input)
	return out, req.Send()
}

// UpdateArchiveWithContext is the same as UpdateArchive with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateArchive for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) UpdateArchiveWithContext(ctx aws.Context, input *UpdateArchiveInput, opts ...request.Option) (*UpdateArchiveOutput, error) {
	req, out := c.UpdateArchiveRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateIngressPoint = "UpdateIngressPoint"

// UpdateIngressPointRequest generates a "aws/request.Request" representing the
// client's request for the UpdateIngressPoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateIngressPoint for more information on using the UpdateIngressPoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateIngressPointRequest method.
//	req, resp := client.UpdateIngressPointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/UpdateIngressPoint
func (c *MailManager) UpdateIngressPointRequest(input *UpdateIngressPointInput) (req *request.Request, output *UpdateIngressPointOutput) {
	op := &request.Operation{
		Name:       opUpdateIngressPoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateIngressPointInput{}
	}

	output = &UpdateIngressPointOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateIngressPoint API operation for MailManager.
//
// Update attributes of a provisioned ingress endpoint resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation UpdateIngressPoint for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
//   - ConflictException
//     The request configuration has conflicts. For details, see the accompanying
//     error message.
//
//   - ResourceNotFoundException
//     Occurs when a requested resource is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/UpdateIngressPoint
func (c *MailManager) UpdateIngressPoint(input *UpdateIngressPointInput) (*UpdateIngressPointOutput, error) {
	req, out := c.UpdateIngressPointRequest(input)
	return out, req.Send()
}

// UpdateIngressPointWithContext is the same as UpdateIngressPoint with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateIngressPoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) UpdateIngressPointWithContext(ctx aws.Context, input *UpdateIngressPointInput, opts ...request.Option) (*UpdateIngressPointOutput, error) {
	req, out := c.UpdateIngressPointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRelay = "UpdateRelay"

// UpdateRelayRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRelay operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRelay for more information on using the UpdateRelay
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateRelayRequest method.
//	req, resp := client.UpdateRelayRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/UpdateRelay
func (c *MailManager) UpdateRelayRequest(input *UpdateRelayInput) (req *request.Request, output *UpdateRelayOutput) {
	op := &request.Operation{
		Name:       opUpdateRelay,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRelayInput{}
	}

	output = &UpdateRelayOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateRelay API operation for MailManager.
//
// Updates the attributes of an existing relay resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation UpdateRelay for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
//   - ConflictException
//     The request configuration has conflicts. For details, see the accompanying
//     error message.
//
//   - ResourceNotFoundException
//     Occurs when a requested resource is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/UpdateRelay
func (c *MailManager) UpdateRelay(input *UpdateRelayInput) (*UpdateRelayOutput, error) {
	req, out := c.UpdateRelayRequest(input)
	return out, req.Send()
}

// UpdateRelayWithContext is the same as UpdateRelay with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRelay for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) UpdateRelayWithContext(ctx aws.Context, input *UpdateRelayInput, opts ...request.Option) (*UpdateRelayOutput, error) {
	req, out := c.UpdateRelayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRuleSet = "UpdateRuleSet"

// UpdateRuleSetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRuleSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRuleSet for more information on using the UpdateRuleSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateRuleSetRequest method.
//	req, resp := client.UpdateRuleSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/UpdateRuleSet
func (c *MailManager) UpdateRuleSetRequest(input *UpdateRuleSetInput) (req *request.Request, output *UpdateRuleSetOutput) {
	op := &request.Operation{
		Name:       opUpdateRuleSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRuleSetInput{}
	}

	output = &UpdateRuleSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateRuleSet API operation for MailManager.
//
// >Update attributes of an already provisioned rule set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation UpdateRuleSet for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
//   - ConflictException
//     The request configuration has conflicts. For details, see the accompanying
//     error message.
//
//   - ResourceNotFoundException
//     Occurs when a requested resource is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/UpdateRuleSet
func (c *MailManager) UpdateRuleSet(input *UpdateRuleSetInput) (*UpdateRuleSetOutput, error) {
	req, out := c.UpdateRuleSetRequest(input)
	return out, req.Send()
}

// UpdateRuleSetWithContext is the same as UpdateRuleSet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRuleSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) UpdateRuleSetWithContext(ctx aws.Context, input *UpdateRuleSetInput, opts ...request.Option) (*UpdateRuleSetOutput, error) {
	req, out := c.UpdateRuleSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTrafficPolicy = "UpdateTrafficPolicy"

// UpdateTrafficPolicyRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTrafficPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTrafficPolicy for more information on using the UpdateTrafficPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateTrafficPolicyRequest method.
//	req, resp := client.UpdateTrafficPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/UpdateTrafficPolicy
func (c *MailManager) UpdateTrafficPolicyRequest(input *UpdateTrafficPolicyInput) (req *request.Request, output *UpdateTrafficPolicyOutput) {
	op := &request.Operation{
		Name:       opUpdateTrafficPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateTrafficPolicyInput{}
	}

	output = &UpdateTrafficPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateTrafficPolicy API operation for MailManager.
//
// Update attributes of an already provisioned traffic policy resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for MailManager's
// API operation UpdateTrafficPolicy for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request validation has failed. For details, see the accompanying error
//     message.
//
//   - ConflictException
//     The request configuration has conflicts. For details, see the accompanying
//     error message.
//
//   - ResourceNotFoundException
//     Occurs when a requested resource is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/UpdateTrafficPolicy
func (c *MailManager) UpdateTrafficPolicy(input *UpdateTrafficPolicyInput) (*UpdateTrafficPolicyOutput, error) {
	req, out := c.UpdateTrafficPolicyRequest(input)
	return out, req.Send()
}

// UpdateTrafficPolicyWithContext is the same as UpdateTrafficPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTrafficPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MailManager) UpdateTrafficPolicyWithContext(ctx aws.Context, input *UpdateTrafficPolicyInput, opts ...request.Option) (*UpdateTrafficPolicyOutput, error) {
	req, out := c.UpdateTrafficPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Occurs when a user is denied access to a specific resource or action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The action to add a header to a message. When executed, this action will
// add the given header to the message.
type AddHeaderAction struct {
	_ struct{} `type:"structure"`

	// The name of the header to add to an email. The header must be prefixed with
	// "X-". Headers are added regardless of whether the header name pre-existed
	// in the email.
	//
	// HeaderName is a required field
	HeaderName *string `min:"1" type:"string" required:"true"`

	// The value of the header to add to the email.
	//
	// HeaderValue is a required field
	HeaderValue *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddHeaderAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddHeaderAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddHeaderAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddHeaderAction"}
	if s.HeaderName == nil {
		invalidParams.Add(request.NewErrParamRequired("HeaderName"))
	}
	if s.HeaderName != nil && len(*s.HeaderName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HeaderName", 1))
	}
	if s.HeaderValue == nil {
		invalidParams.Add(request.NewErrParamRequired("HeaderValue"))
	}
	if s.HeaderValue != nil && len(*s.HeaderValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HeaderValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHeaderName sets the HeaderName field's value.
func (s *AddHeaderAction) SetHeaderName(v string) *AddHeaderAction {
	s.HeaderName = &v
	return s
}

// SetHeaderValue sets the HeaderValue field's value.
func (s *AddHeaderAction) SetHeaderValue(v string) *AddHeaderAction {
	s.HeaderValue = &v
	return s
}

// An Add On instance represents a specific configuration of an Add On.
type AddonInstance struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Add On instance.
	AddonInstanceArn *string `type:"string"`

	// The unique ID of the Add On instance.
	AddonInstanceId *string `min:"4" type:"string"`

	// The name of the Add On for the instance.
	AddonName *string `type:"string"`

	// The subscription ID for the instance.
	AddonSubscriptionId *string `min:"4" type:"string"`

	// The timestamp of when the Add On instance was created.
	CreatedTimestamp *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddonInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddonInstance) GoString() string {
	return s.String()
}

// SetAddonInstanceArn sets the AddonInstanceArn field's value.
func (s *AddonInstance) SetAddonInstanceArn(v string) *AddonInstance {
	s.AddonInstanceArn = &v
	return s
}

// SetAddonInstanceId sets the AddonInstanceId field's value.
func (s *AddonInstance) SetAddonInstanceId(v string) *AddonInstance {
	s.AddonInstanceId = &v
	return s
}

// SetAddonName sets the AddonName field's value.
func (s *AddonInstance) SetAddonName(v string) *AddonInstance {
	s.AddonName = &v
	return s
}

// SetAddonSubscriptionId sets the AddonSubscriptionId field's value.
func (s *AddonInstance) SetAddonSubscriptionId(v string) *AddonInstance {
	s.AddonSubscriptionId = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *AddonInstance) SetCreatedTimestamp(v time.Time) *AddonInstance {
	s.CreatedTimestamp = &v
	return s
}

// A subscription for an Add On representing the acceptance of its terms of
// use and additional pricing.
type AddonSubscription struct {
	_ struct{} `type:"structure"`

	// The name of the Add On.
	AddonName *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Add On subscription.
	AddonSubscriptionArn *string `type:"string"`

	// The unique ID of the Add On subscription.
	AddonSubscriptionId *string `min:"4" type:"string"`

	// The timestamp of when the Add On subscription was created.
	CreatedTimestamp *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddonSubscription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddonSubscription) GoString() string {
	return s.String()
}

// SetAddonName sets the AddonName field's value.
func (s *AddonSubscription) SetAddonName(v string) *AddonSubscription {
	s.AddonName = &v
	return s
}

// SetAddonSubscriptionArn sets the AddonSubscriptionArn field's value.
func (s *AddonSubscription) SetAddonSubscriptionArn(v string) *AddonSubscription {
	s.AddonSubscriptionArn = &v
	return s
}

// SetAddonSubscriptionId sets the AddonSubscriptionId field's value.
func (s *AddonSubscription) SetAddonSubscriptionId(v string) *AddonSubscription {
	s.AddonSubscriptionId = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *AddonSubscription) SetCreatedTimestamp(v time.Time) *AddonSubscription {
	s.CreatedTimestamp = &v
	return s
}

// The result of an analysis can be used in conditions to trigger actions. Analyses
// can inspect the email content and report a certain aspect of the email.
type Analysis struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an Add On.
	//
	// Analyzer is a required field
	Analyzer *string `type:"string" required:"true"`

	// The returned value from an Add On.
	//
	// ResultField is a required field
	ResultField *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Analysis) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Analysis) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Analysis) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Analysis"}
	if s.Analyzer == nil {
		invalidParams.Add(request.NewErrParamRequired("Analyzer"))
	}
	if s.ResultField == nil {
		invalidParams.Add(request.NewErrParamRequired("ResultField"))
	}
	if s.ResultField != nil && len(*s.ResultField) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResultField", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyzer sets the Analyzer field's value.
func (s *Analysis) SetAnalyzer(v string) *Analysis {
	s.Analyzer = &v
	return s
}

// SetResultField sets the ResultField field's value.
func (s *Analysis) SetResultField(v string) *Analysis {
	s.ResultField = &v
	return s
}

// An archive resource for storing and retaining emails.
type Archive struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the archive.
	//
	// ArchiveId is a required field
	ArchiveId *string `min:"1" type:"string" required:"true"`

	// The unique name assigned to the archive.
	ArchiveName *string `min:"1" type:"string"`

	// The current state of the archive:
	//
	//    * ACTIVE – The archive is ready and available for use.
	//
	//    * PENDING_DELETION – The archive has been marked for deletion and will
	//    be permanently deleted in 30 days. No further modifications can be made
	//    in this state.
	ArchiveState *string `type:"string" enum:"ArchiveState"`

	// The timestamp of when the archive was last updated.
	LastUpdatedTimestamp *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Archive) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Archive) GoString() string {
	return s.String()
}

// SetArchiveId sets the ArchiveId field's value.
func (s *Archive) SetArchiveId(v string) *Archive {
	s.ArchiveId = &v
	return s
}

// SetArchiveName sets the ArchiveName field's value.
func (s *Archive) SetArchiveName(v string) *Archive {
	s.ArchiveName = &v
	return s
}

// SetArchiveState sets the ArchiveState field's value.
func (s *Archive) SetArchiveState(v string) *Archive {
	s.ArchiveState = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *Archive) SetLastUpdatedTimestamp(v time.Time) *Archive {
	s.LastUpdatedTimestamp = &v
	return s
}

// The action to archive the email by delivering the email to an Amazon SES
// archive.
type ArchiveAction struct {
	_ struct{} `type:"structure"`

	// A policy that states what to do in the case of failure. The action will fail
	// if there are configuration errors. For example, the specified archive has
	// been deleted.
	ActionFailurePolicy *string `type:"string" enum:"ActionFailurePolicy"`

	// The identifier of the archive to send the email to.
	//
	// TargetArchive is a required field
	TargetArchive *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArchiveAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArchiveAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ArchiveAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ArchiveAction"}
	if s.TargetArchive == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetArchive"))
	}
	if s.TargetArchive != nil && len(*s.TargetArchive) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetArchive", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionFailurePolicy sets the ActionFailurePolicy field's value.
func (s *ArchiveAction) SetActionFailurePolicy(v string) *ArchiveAction {
	s.ActionFailurePolicy = &v
	return s
}

// SetTargetArchive sets the TargetArchive field's value.
func (s *ArchiveAction) SetTargetArchive(v string) *ArchiveAction {
	s.TargetArchive = &v
	return s
}

// A boolean expression to evaluate email attribute values.
type ArchiveBooleanExpression struct {
	_ struct{} `type:"structure"`

	// The email attribute value to evaluate.
	//
	// Evaluate is a required field
	Evaluate *ArchiveBooleanToEvaluate `type:"structure" required:"true"`

	// The boolean operator to use for evaluation.
	//
	// Operator is a required field
	Operator *string `type:"string" required:"true" enum:"ArchiveBooleanOperator"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArchiveBooleanExpression) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArchiveBooleanExpression) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ArchiveBooleanExpression) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ArchiveBooleanExpression"}
	if s.Evaluate == nil {
		invalidParams.Add(request.NewErrParamRequired("Evaluate"))
	}
	if s.Operator == nil {
		invalidParams.Add(request.NewErrParamRequired("Operator"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEvaluate sets the Evaluate field's value.
func (s *ArchiveBooleanExpression) SetEvaluate(v *ArchiveBooleanToEvaluate) *ArchiveBooleanExpression {
	s.Evaluate = v
	return s
}

// SetOperator sets the Operator field's value.
func (s *ArchiveBooleanExpression) SetOperator(v string) *ArchiveBooleanExpression {
	s.Operator = &v
	return s
}

// The attribute to evaluate in a boolean expression.
type ArchiveBooleanToEvaluate struct {
	_ struct{} `type:"structure"`

	// The name of the email attribute to evaluate.
	Attribute *string `type:"string" enum:"ArchiveBooleanEmailAttribute"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArchiveBooleanToEvaluate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArchiveBooleanToEvaluate) GoString() string {
	return s.String()
}

// SetAttribute sets the Attribute field's value.
func (s *ArchiveBooleanToEvaluate) SetAttribute(v string) *ArchiveBooleanToEvaluate {
	s.Attribute = &v
	return s
}

// A filter condition used to include or exclude emails when exporting from
// or searching an archive.
type ArchiveFilterCondition struct {
	_ struct{} `type:"structure"`

	// A boolean expression to evaluate against email attributes.
	BooleanExpression *ArchiveBooleanExpression `type:"structure"`

	// A string expression to evaluate against email attributes.
	StringExpression *ArchiveStringExpression `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArchiveFilterCondition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArchiveFilterCondition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ArchiveFilterCondition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ArchiveFilterCondition"}
	if s.BooleanExpression != nil {
		if err := s.BooleanExpression.Validate(); err != nil {
			invalidParams.AddNested("BooleanExpression", err.(request.ErrInvalidParams))
		}
	}
	if s.StringExpression != nil {
		if err := s.StringExpression.Validate(); err != nil {
			invalidParams.AddNested("StringExpression", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBooleanExpression sets the BooleanExpression field's value.
func (s *ArchiveFilterCondition) SetBooleanExpression(v *ArchiveBooleanExpression) *ArchiveFilterCondition {
	s.BooleanExpression = v
	return s
}

// SetStringExpression sets the StringExpression field's value.
func (s *ArchiveFilterCondition) SetStringExpression(v *ArchiveStringExpression) *ArchiveFilterCondition {
	s.StringExpression = v
	return s
}

// A set of filter conditions to include and/or exclude emails.
type ArchiveFilters struct {
	_ struct{} `type:"structure"`

	// The filter conditions for emails to include.
	Include []*ArchiveFilterCondition `type:"list"`

	// The filter conditions for emails to exclude.
	Unless []*ArchiveFilterCondition `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArchiveFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArchiveFilters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ArchiveFilters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ArchiveFilters"}
	if s.Include != nil {
		for i, v := range s.Include {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Include", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Unless != nil {
		for i, v := range s.Unless {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Unless", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInclude sets the Include field's value.
func (s *ArchiveFilters) SetInclude(v []*ArchiveFilterCondition) *ArchiveFilters {
	s.Include = v
	return s
}

// SetUnless sets the Unless field's value.
func (s *ArchiveFilters) SetUnless(v []*ArchiveFilterCondition) *ArchiveFilters {
	s.Unless = v
	return s
}

// The retention policy for an email archive that specifies how long emails
// are kept before being automatically deleted.
type ArchiveRetention struct {
	_ struct{} `type:"structure"`

	// The enum value sets the period for retaining emails in an archive.
	RetentionPeriod *string `type:"string" enum:"RetentionPeriod"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArchiveRetention) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArchiveRetention) GoString() string {
	return s.String()
}

// SetRetentionPeriod sets the RetentionPeriod field's value.
func (s *ArchiveRetention) SetRetentionPeriod(v string) *ArchiveRetention {
	s.RetentionPeriod = &v
	return s
}

// A string expression to evaluate an email attribute value against one or more
// string values.
type ArchiveStringExpression struct {
	_ struct{} `type:"structure"`

	// The attribute of the email to evaluate.
	//
	// Evaluate is a required field
	Evaluate *ArchiveStringToEvaluate `type:"structure" required:"true"`

	// The operator to use when evaluating the string values.
	//
	// Operator is a required field
	Operator *string `type:"string" required:"true" enum:"ArchiveStringOperator"`

	// The list of string values to evaluate the email attribute against.
	//
	// Values is a required field
	Values []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArchiveStringExpression) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArchiveStringExpression) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ArchiveStringExpression) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ArchiveStringExpression"}
	if s.Evaluate == nil {
		invalidParams.Add(request.NewErrParamRequired("Evaluate"))
	}
	if s.Operator == nil {
		invalidParams.Add(request.NewErrParamRequired("Operator"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEvaluate sets the Evaluate field's value.
func (s *ArchiveStringExpression) SetEvaluate(v *ArchiveStringToEvaluate) *ArchiveStringExpression {
	s.Evaluate = v
	return s
}

// SetOperator sets the Operator field's value.
func (s *ArchiveStringExpression) SetOperator(v string) *ArchiveStringExpression {
	s.Operator = &v
	return s
}

// SetValues sets the Values field's value.
func (s *ArchiveStringExpression) SetValues(v []*string) *ArchiveStringExpression {
	s.Values = v
	return s
}

// Specifies the email attribute to evaluate in a string expression.
type ArchiveStringToEvaluate struct {
	_ struct{} `type:"structure"`

	// The name of the email attribute to evaluate.
	Attribute *string `type:"string" enum:"ArchiveStringEmailAttribute"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArchiveStringToEvaluate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArchiveStringToEvaluate) GoString() string {
	return s.String()
}

// SetAttribute sets the Attribute field's value.
func (s *ArchiveStringToEvaluate) SetAttribute(v string) *ArchiveStringToEvaluate {
	s.Attribute = &v
	return s
}

// The request configuration has conflicts. For details, see the accompanying
// error message.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateAddonInstanceInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of a previously created subscription that an Add On instance
	// is created for. You can only have one instance per subscription.
	//
	// AddonSubscriptionId is a required field
	AddonSubscriptionId *string `min:"4" type:"string" required:"true"`

	// A unique token that Amazon SES uses to recognize subsequent retries of the
	// same request.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The tags used to organize, track, or control access for the resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAddonInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAddonInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAddonInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAddonInstanceInput"}
	if s.AddonSubscriptionId == nil {
		invalidParams.Add(request.NewErrParamRequired("AddonSubscriptionId"))
	}
	if s.AddonSubscriptionId != nil && len(*s.AddonSubscriptionId) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("AddonSubscriptionId", 4))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddonSubscriptionId sets the AddonSubscriptionId field's value.
func (s *CreateAddonInstanceInput) SetAddonSubscriptionId(v string) *CreateAddonInstanceInput {
	s.AddonSubscriptionId = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateAddonInstanceInput) SetClientToken(v string) *CreateAddonInstanceInput {
	s.ClientToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAddonInstanceInput) SetTags(v []*Tag) *CreateAddonInstanceInput {
	s.Tags = v
	return s
}

type CreateAddonInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the Add On instance created by this API.
	//
	// AddonInstanceId is a required field
	AddonInstanceId *string `min:"4" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAddonInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAddonInstanceOutput) GoString() string {
	return s.String()
}

// SetAddonInstanceId sets the AddonInstanceId field's value.
func (s *CreateAddonInstanceOutput) SetAddonInstanceId(v string) *CreateAddonInstanceOutput {
	s.AddonInstanceId = &v
	return s
}

type CreateAddonSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// The name of the Add On to subscribe to. You can only have one subscription
	// for each Add On name.
	//
	// AddonName is a required field
	AddonName *string `type:"string" required:"true"`

	// A unique token that Amazon SES uses to recognize subsequent retries of the
	// same request.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The tags used to organize, track, or control access for the resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAddonSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAddonSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAddonSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAddonSubscriptionInput"}
	if s.AddonName == nil {
		invalidParams.Add(request.NewErrParamRequired("AddonName"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddonName sets the AddonName field's value.
func (s *CreateAddonSubscriptionInput) SetAddonName(v string) *CreateAddonSubscriptionInput {
	s.AddonName = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateAddonSubscriptionInput) SetClientToken(v string) *CreateAddonSubscriptionInput {
	s.ClientToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAddonSubscriptionInput) SetTags(v []*Tag) *CreateAddonSubscriptionInput {
	s.Tags = v
	return s
}

type CreateAddonSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the Add On subscription created by this API.
	//
	// AddonSubscriptionId is a required field
	AddonSubscriptionId *string `min:"4" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAddonSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAddonSubscriptionOutput) GoString() string {
	return s.String()
}

// SetAddonSubscriptionId sets the AddonSubscriptionId field's value.
func (s *CreateAddonSubscriptionOutput) SetAddonSubscriptionId(v string) *CreateAddonSubscriptionOutput {
	s.AddonSubscriptionId = &v
	return s
}

// The request to create a new email archive.
type CreateArchiveInput struct {
	_ struct{} `type:"structure"`

	// A unique name for the new archive.
	//
	// ArchiveName is a required field
	ArchiveName *string `min:"1" type:"string" required:"true"`

	// A unique token Amazon SES uses to recognize retries of this request.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the KMS key for encrypting emails in the
	// archive.
	KmsKeyArn *string `type:"string"`

	// The period for retaining emails in the archive before automatic deletion.
	Retention *ArchiveRetention `type:"structure"`

	// The tags used to organize, track, or control access for the resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateArchiveInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateArchiveInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateArchiveInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateArchiveInput"}
	if s.ArchiveName == nil {
		invalidParams.Add(request.NewErrParamRequired("ArchiveName"))
	}
	if s.ArchiveName != nil && len(*s.ArchiveName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ArchiveName", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArchiveName sets the ArchiveName field's value.
func (s *CreateArchiveInput) SetArchiveName(v string) *CreateArchiveInput {
	s.ArchiveName = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateArchiveInput) SetClientToken(v string) *CreateArchiveInput {
	s.ClientToken = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *CreateArchiveInput) SetKmsKeyArn(v string) *CreateArchiveInput {
	s.KmsKeyArn = &v
	return s
}

// SetRetention sets the Retention field's value.
func (s *CreateArchiveInput) SetRetention(v *ArchiveRetention) *CreateArchiveInput {
	s.Retention = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateArchiveInput) SetTags(v []*Tag) *CreateArchiveInput {
	s.Tags = v
	return s
}

// The response from creating a new email archive.
type CreateArchiveOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the newly created archive.
	//
	// ArchiveId is a required field
	ArchiveId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateArchiveOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateArchiveOutput) GoString() string {
	return s.String()
}

// SetArchiveId sets the ArchiveId field's value.
func (s *CreateArchiveOutput) SetArchiveId(v string) *CreateArchiveOutput {
	s.ArchiveId = &v
	return s
}

type CreateIngressPointInput struct {
	_ struct{} `type:"structure"`

	// A unique token that Amazon SES uses to recognize subsequent retries of the
	// same request.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// If you choose an Authenticated ingress endpoint, you must configure either
	// an SMTP password or a secret ARN.
	IngressPointConfiguration *IngressPointConfiguration `type:"structure"`

	// A user friendly name for an ingress endpoint resource.
	//
	// IngressPointName is a required field
	IngressPointName *string `min:"3" type:"string" required:"true"`

	// The identifier of an existing rule set that you attach to an ingress endpoint
	// resource.
	//
	// RuleSetId is a required field
	RuleSetId *string `min:"1" type:"string" required:"true"`

	// The tags used to organize, track, or control access for the resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags []*Tag `type:"list"`

	// The identifier of an existing traffic policy that you attach to an ingress
	// endpoint resource.
	//
	// TrafficPolicyId is a required field
	TrafficPolicyId *string `min:"1" type:"string" required:"true"`

	// The type of the ingress endpoint to create.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"IngressPointType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIngressPointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIngressPointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateIngressPointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateIngressPointInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.IngressPointName == nil {
		invalidParams.Add(request.NewErrParamRequired("IngressPointName"))
	}
	if s.IngressPointName != nil && len(*s.IngressPointName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("IngressPointName", 3))
	}
	if s.RuleSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleSetId"))
	}
	if s.RuleSetId != nil && len(*s.RuleSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleSetId", 1))
	}
	if s.TrafficPolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("TrafficPolicyId"))
	}
	if s.TrafficPolicyId != nil && len(*s.TrafficPolicyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrafficPolicyId", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.IngressPointConfiguration != nil {
		if err := s.IngressPointConfiguration.Validate(); err != nil {
			invalidParams.AddNested("IngressPointConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateIngressPointInput) SetClientToken(v string) *CreateIngressPointInput {
	s.ClientToken = &v
	return s
}

// SetIngressPointConfiguration sets the IngressPointConfiguration field's value.
func (s *CreateIngressPointInput) SetIngressPointConfiguration(v *IngressPointConfiguration) *CreateIngressPointInput {
	s.IngressPointConfiguration = v
	return s
}

// SetIngressPointName sets the IngressPointName field's value.
func (s *CreateIngressPointInput) SetIngressPointName(v string) *CreateIngressPointInput {
	s.IngressPointName = &v
	return s
}

// SetRuleSetId sets the RuleSetId field's value.
func (s *CreateIngressPointInput) SetRuleSetId(v string) *CreateIngressPointInput {
	s.RuleSetId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateIngressPointInput) SetTags(v []*Tag) *CreateIngressPointInput {
	s.Tags = v
	return s
}

// SetTrafficPolicyId sets the TrafficPolicyId field's value.
func (s *CreateIngressPointInput) SetTrafficPolicyId(v string) *CreateIngressPointInput {
	s.TrafficPolicyId = &v
	return s
}

// SetType sets the Type field's value.
func (s *CreateIngressPointInput) SetType(v string) *CreateIngressPointInput {
	s.Type = &v
	return s
}

type CreateIngressPointOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for a previously created ingress endpoint.
	//
	// IngressPointId is a required field
	IngressPointId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIngressPointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIngressPointOutput) GoString() string {
	return s.String()
}

// SetIngressPointId sets the IngressPointId field's value.
func (s *CreateIngressPointOutput) SetIngressPointId(v string) *CreateIngressPointOutput {
	s.IngressPointId = &v
	return s
}

type CreateRelayInput struct {
	_ struct{} `type:"structure"`

	// Authentication for the relay destination server—specify the secretARN where
	// the SMTP credentials are stored.
	//
	// Authentication is a required field
	Authentication *RelayAuthentication `type:"structure" required:"true"`

	// A unique token that Amazon SES uses to recognize subsequent retries of the
	// same request.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The unique name of the relay resource.
	//
	// RelayName is a required field
	RelayName *string `min:"1" type:"string" required:"true"`

	// The destination relay server address.
	//
	// ServerName is a required field
	ServerName *string `min:"1" type:"string" required:"true"`

	// The destination relay server port.
	//
	// ServerPort is a required field
	ServerPort *int64 `min:"1" type:"integer" required:"true"`

	// The tags used to organize, track, or control access for the resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRelayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRelayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRelayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRelayInput"}
	if s.Authentication == nil {
		invalidParams.Add(request.NewErrParamRequired("Authentication"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.RelayName == nil {
		invalidParams.Add(request.NewErrParamRequired("RelayName"))
	}
	if s.RelayName != nil && len(*s.RelayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RelayName", 1))
	}
	if s.ServerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerName"))
	}
	if s.ServerName != nil && len(*s.ServerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServerName", 1))
	}
	if s.ServerPort == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerPort"))
	}
	if s.ServerPort != nil && *s.ServerPort < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ServerPort", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthentication sets the Authentication field's value.
func (s *CreateRelayInput) SetAuthentication(v *RelayAuthentication) *CreateRelayInput {
	s.Authentication = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateRelayInput) SetClientToken(v string) *CreateRelayInput {
	s.ClientToken = &v
	return s
}

// SetRelayName sets the RelayName field's value.
func (s *CreateRelayInput) SetRelayName(v string) *CreateRelayInput {
	s.RelayName = &v
	return s
}

// SetServerName sets the ServerName field's value.
func (s *CreateRelayInput) SetServerName(v string) *CreateRelayInput {
	s.ServerName = &v
	return s
}

// SetServerPort sets the ServerPort field's value.
func (s *CreateRelayInput) SetServerPort(v int64) *CreateRelayInput {
	s.ServerPort = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRelayInput) SetTags(v []*Tag) *CreateRelayInput {
	s.Tags = v
	return s
}

type CreateRelayOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier of the created relay resource.
	//
	// RelayId is a required field
	RelayId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRelayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRelayOutput) GoString() string {
	return s.String()
}

// SetRelayId sets the RelayId field's value.
func (s *CreateRelayOutput) SetRelayId(v string) *CreateRelayOutput {
	s.RelayId = &v
	return s
}

type CreateRuleSetInput struct {
	_ struct{} `type:"structure"`

	// A unique token that Amazon SES uses to recognize subsequent retries of the
	// same request.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// A user-friendly name for the rule set.
	//
	// RuleSetName is a required field
	RuleSetName *string `min:"1" type:"string" required:"true"`

	// Conditional rules that are evaluated for determining actions on email.
	//
	// Rules is a required field
	Rules []*Rule `type:"list" required:"true"`

	// The tags used to organize, track, or control access for the resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRuleSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRuleSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRuleSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRuleSetInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.RuleSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleSetName"))
	}
	if s.RuleSetName != nil && len(*s.RuleSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleSetName", 1))
	}
	if s.Rules == nil {
		invalidParams.Add(request.NewErrParamRequired("Rules"))
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateRuleSetInput) SetClientToken(v string) *CreateRuleSetInput {
	s.ClientToken = &v
	return s
}

// SetRuleSetName sets the RuleSetName field's value.
func (s *CreateRuleSetInput) SetRuleSetName(v string) *CreateRuleSetInput {
	s.RuleSetName = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *CreateRuleSetInput) SetRules(v []*Rule) *CreateRuleSetInput {
	s.Rules = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRuleSetInput) SetTags(v []*Tag) *CreateRuleSetInput {
	s.Tags = v
	return s
}

type CreateRuleSetOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the created rule set.
	//
	// RuleSetId is a required field
	RuleSetId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRuleSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRuleSetOutput) GoString() string {
	return s.String()
}

// SetRuleSetId sets the RuleSetId field's value.
func (s *CreateRuleSetOutput) SetRuleSetId(v string) *CreateRuleSetOutput {
	s.RuleSetId = &v
	return s
}

type CreateTrafficPolicyInput struct {
	_ struct{} `type:"structure"`

	// A unique token that Amazon SES uses to recognize subsequent retries of the
	// same request.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// Default action instructs the traﬃc policy to either Allow or Deny (block)
	// messages that fall outside of (or not addressed by) the conditions of your
	// policy statements
	//
	// DefaultAction is a required field
	DefaultAction *string `type:"string" required:"true" enum:"AcceptAction"`

	// The maximum message size in bytes of email which is allowed in by this traffic
	// policy—anything larger will be blocked.
	MaxMessageSizeBytes *int64 `min:"1" type:"integer"`

	// Conditional statements for filtering email traffic.
	//
	// PolicyStatements is a required field
	PolicyStatements []*PolicyStatement `type:"list" required:"true"`

	// The tags used to organize, track, or control access for the resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags []*Tag `type:"list"`

	// A user-friendly name for the traffic policy resource.
	//
	// TrafficPolicyName is a required field
	TrafficPolicyName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTrafficPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTrafficPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTrafficPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTrafficPolicyInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DefaultAction == nil {
		invalidParams.Add(request.NewErrParamRequired("DefaultAction"))
	}
	if s.MaxMessageSizeBytes != nil && *s.MaxMessageSizeBytes < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxMessageSizeBytes", 1))
	}
	if s.PolicyStatements == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyStatements"))
	}
	if s.TrafficPolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrafficPolicyName"))
	}
	if s.TrafficPolicyName != nil && len(*s.TrafficPolicyName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TrafficPolicyName", 3))
	}
	if s.PolicyStatements != nil {
		for i, v := range s.PolicyStatements {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PolicyStatements", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateTrafficPolicyInput) SetClientToken(v string) *CreateTrafficPolicyInput {
	s.ClientToken = &v
	return s
}

// SetDefaultAction sets the DefaultAction field's value.
func (s *CreateTrafficPolicyInput) SetDefaultAction(v string) *CreateTrafficPolicyInput {
	s.DefaultAction = &v
	return s
}

// SetMaxMessageSizeBytes sets the MaxMessageSizeBytes field's value.
func (s *CreateTrafficPolicyInput) SetMaxMessageSizeBytes(v int64) *CreateTrafficPolicyInput {
	s.MaxMessageSizeBytes = &v
	return s
}

// SetPolicyStatements sets the PolicyStatements field's value.
func (s *CreateTrafficPolicyInput) SetPolicyStatements(v []*PolicyStatement) *CreateTrafficPolicyInput {
	s.PolicyStatements = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTrafficPolicyInput) SetTags(v []*Tag) *CreateTrafficPolicyInput {
	s.Tags = v
	return s
}

// SetTrafficPolicyName sets the TrafficPolicyName field's value.
func (s *CreateTrafficPolicyInput) SetTrafficPolicyName(v string) *CreateTrafficPolicyInput {
	s.TrafficPolicyName = &v
	return s
}

type CreateTrafficPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the traffic policy resource.
	//
	// TrafficPolicyId is a required field
	TrafficPolicyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTrafficPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTrafficPolicyOutput) GoString() string {
	return s.String()
}

// SetTrafficPolicyId sets the TrafficPolicyId field's value.
func (s *CreateTrafficPolicyOutput) SetTrafficPolicyId(v string) *CreateTrafficPolicyOutput {
	s.TrafficPolicyId = &v
	return s
}

type DeleteAddonInstanceInput struct {
	_ struct{} `type:"structure"`

	// The Add On instance ID to delete.
	//
	// AddonInstanceId is a required field
	AddonInstanceId *string `min:"4" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAddonInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAddonInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAddonInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAddonInstanceInput"}
	if s.AddonInstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("AddonInstanceId"))
	}
	if s.AddonInstanceId != nil && len(*s.AddonInstanceId) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("AddonInstanceId", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddonInstanceId sets the AddonInstanceId field's value.
func (s *DeleteAddonInstanceInput) SetAddonInstanceId(v string) *DeleteAddonInstanceInput {
	s.AddonInstanceId = &v
	return s
}

type DeleteAddonInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAddonInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAddonInstanceOutput) GoString() string {
	return s.String()
}

type DeleteAddonSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// The Add On subscription ID to delete.
	//
	// AddonSubscriptionId is a required field
	AddonSubscriptionId *string `min:"4" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAddonSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAddonSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAddonSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAddonSubscriptionInput"}
	if s.AddonSubscriptionId == nil {
		invalidParams.Add(request.NewErrParamRequired("AddonSubscriptionId"))
	}
	if s.AddonSubscriptionId != nil && len(*s.AddonSubscriptionId) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("AddonSubscriptionId", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddonSubscriptionId sets the AddonSubscriptionId field's value.
func (s *DeleteAddonSubscriptionInput) SetAddonSubscriptionId(v string) *DeleteAddonSubscriptionInput {
	s.AddonSubscriptionId = &v
	return s
}

type DeleteAddonSubscriptionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAddonSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAddonSubscriptionOutput) GoString() string {
	return s.String()
}

// The request to initiate deletion of an email archive.
type DeleteArchiveInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the archive to delete.
	//
	// ArchiveId is a required field
	ArchiveId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteArchiveInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteArchiveInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteArchiveInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteArchiveInput"}
	if s.ArchiveId == nil {
		invalidParams.Add(request.NewErrParamRequired("ArchiveId"))
	}
	if s.ArchiveId != nil && len(*s.ArchiveId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ArchiveId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArchiveId sets the ArchiveId field's value.
func (s *DeleteArchiveInput) SetArchiveId(v string) *DeleteArchiveInput {
	s.ArchiveId = &v
	return s
}

// The response indicating if the archive deletion was successfully initiated.
//
// On success, returns an HTTP 200 status code. On failure, returns an error
// message.
type DeleteArchiveOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteArchiveOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteArchiveOutput) GoString() string {
	return s.String()
}

type DeleteIngressPointInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the ingress endpoint resource that you want to delete.
	//
	// IngressPointId is a required field
	IngressPointId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIngressPointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIngressPointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIngressPointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteIngressPointInput"}
	if s.IngressPointId == nil {
		invalidParams.Add(request.NewErrParamRequired("IngressPointId"))
	}
	if s.IngressPointId != nil && len(*s.IngressPointId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IngressPointId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIngressPointId sets the IngressPointId field's value.
func (s *DeleteIngressPointInput) SetIngressPointId(v string) *DeleteIngressPointInput {
	s.IngressPointId = &v
	return s
}

type DeleteIngressPointOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIngressPointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIngressPointOutput) GoString() string {
	return s.String()
}

type DeleteRelayInput struct {
	_ struct{} `type:"structure"`

	// The unique relay identifier.
	//
	// RelayId is a required field
	RelayId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRelayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRelayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRelayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRelayInput"}
	if s.RelayId == nil {
		invalidParams.Add(request.NewErrParamRequired("RelayId"))
	}
	if s.RelayId != nil && len(*s.RelayId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RelayId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRelayId sets the RelayId field's value.
func (s *DeleteRelayInput) SetRelayId(v string) *DeleteRelayInput {
	s.RelayId = &v
	return s
}

type DeleteRelayOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRelayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRelayOutput) GoString() string {
	return s.String()
}

type DeleteRuleSetInput struct {
	_ struct{} `type:"structure"`

	// The identifier of an existing rule set resource to delete.
	//
	// RuleSetId is a required field
	RuleSetId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRuleSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRuleSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRuleSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRuleSetInput"}
	if s.RuleSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleSetId"))
	}
	if s.RuleSetId != nil && len(*s.RuleSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRuleSetId sets the RuleSetId field's value.
func (s *DeleteRuleSetInput) SetRuleSetId(v string) *DeleteRuleSetInput {
	s.RuleSetId = &v
	return s
}

type DeleteRuleSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRuleSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRuleSetOutput) GoString() string {
	return s.String()
}

type DeleteTrafficPolicyInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the traffic policy that you want to delete.
	//
	// TrafficPolicyId is a required field
	TrafficPolicyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTrafficPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTrafficPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTrafficPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTrafficPolicyInput"}
	if s.TrafficPolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("TrafficPolicyId"))
	}
	if s.TrafficPolicyId != nil && len(*s.TrafficPolicyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrafficPolicyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTrafficPolicyId sets the TrafficPolicyId field's value.
func (s *DeleteTrafficPolicyInput) SetTrafficPolicyId(v string) *DeleteTrafficPolicyInput {
	s.TrafficPolicyId = &v
	return s
}

type DeleteTrafficPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTrafficPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTrafficPolicyOutput) GoString() string {
	return s.String()
}

// This action to delivers an email to a mailbox.
type DeliverToMailboxAction struct {
	_ struct{} `type:"structure"`

	// A policy that states what to do in the case of failure. The action will fail
	// if there are configuration errors. For example, the mailbox ARN is no longer
	// valid.
	ActionFailurePolicy *string `type:"string" enum:"ActionFailurePolicy"`

	// The Amazon Resource Name (ARN) of a WorkMail organization to deliver the
	// email to.
	//
	// MailboxArn is a required field
	MailboxArn *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of an IAM role to use to execute this action.
	// The role must have access to the workmail:DeliverToMailbox API.
	//
	// RoleArn is a required field
	RoleArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeliverToMailboxAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeliverToMailboxAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeliverToMailboxAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeliverToMailboxAction"}
	if s.MailboxArn == nil {
		invalidParams.Add(request.NewErrParamRequired("MailboxArn"))
	}
	if s.MailboxArn != nil && len(*s.MailboxArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MailboxArn", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionFailurePolicy sets the ActionFailurePolicy field's value.
func (s *DeliverToMailboxAction) SetActionFailurePolicy(v string) *DeliverToMailboxAction {
	s.ActionFailurePolicy = &v
	return s
}

// SetMailboxArn sets the MailboxArn field's value.
func (s *DeliverToMailboxAction) SetMailboxArn(v string) *DeliverToMailboxAction {
	s.MailboxArn = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DeliverToMailboxAction) SetRoleArn(v string) *DeliverToMailboxAction {
	s.RoleArn = &v
	return s
}

// This action causes processing to stop and the email to be dropped. If the
// action applies only to certain recipients, only those recipients are dropped,
// and processing continues for other recipients.
type DropAction struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DropAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DropAction) GoString() string {
	return s.String()
}

// The destination configuration for delivering exported email data.
type ExportDestinationConfiguration struct {
	_ struct{} `type:"structure"`

	// Configuration for delivering to an Amazon S3 bucket.
	S3 *S3ExportDestinationConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportDestinationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportDestinationConfiguration) GoString() string {
	return s.String()
}

// SetS3 sets the S3 field's value.
func (s *ExportDestinationConfiguration) SetS3(v *S3ExportDestinationConfiguration) *ExportDestinationConfiguration {
	s.S3 = v
	return s
}

// The current status of an archive export job.
type ExportStatus struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the export job completed (if finished).
	CompletionTimestamp *time.Time `type:"timestamp"`

	// An error message if the export job failed.
	ErrorMessage *string `type:"string"`

	// The current state of the export job.
	State *string `type:"string" enum:"ExportState"`

	// The timestamp of when the export job was submitted.
	SubmissionTimestamp *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportStatus) GoString() string {
	return s.String()
}

// SetCompletionTimestamp sets the CompletionTimestamp field's value.
func (s *ExportStatus) SetCompletionTimestamp(v time.Time) *ExportStatus {
	s.CompletionTimestamp = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *ExportStatus) SetErrorMessage(v string) *ExportStatus {
	s.ErrorMessage = &v
	return s
}

// SetState sets the State field's value.
func (s *ExportStatus) SetState(v string) *ExportStatus {
	s.State = &v
	return s
}

// SetSubmissionTimestamp sets the SubmissionTimestamp field's value.
func (s *ExportStatus) SetSubmissionTimestamp(v time.Time) *ExportStatus {
	s.SubmissionTimestamp = &v
	return s
}

// Summary statuses of an archive export job.
type ExportSummary struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the export job.
	ExportId *string `min:"1" type:"string"`

	// The current status of the export job.
	Status *ExportStatus `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportSummary) GoString() string {
	return s.String()
}

// SetExportId sets the ExportId field's value.
func (s *ExportSummary) SetExportId(v string) *ExportSummary {
	s.ExportId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ExportSummary) SetStatus(v *ExportStatus) *ExportSummary {
	s.Status = v
	return s
}

type GetAddonInstanceInput struct {
	_ struct{} `type:"structure"`

	// The Add On instance ID to retrieve information for.
	//
	// AddonInstanceId is a required field
	AddonInstanceId *string `min:"4" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAddonInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAddonInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAddonInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAddonInstanceInput"}
	if s.AddonInstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("AddonInstanceId"))
	}
	if s.AddonInstanceId != nil && len(*s.AddonInstanceId) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("AddonInstanceId", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddonInstanceId sets the AddonInstanceId field's value.
func (s *GetAddonInstanceInput) SetAddonInstanceId(v string) *GetAddonInstanceInput {
	s.AddonInstanceId = &v
	return s
}

type GetAddonInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Add On instance.
	AddonInstanceArn *string `type:"string"`

	// The name of the Add On provider associated to the subscription of the instance.
	AddonName *string `type:"string"`

	// The subscription ID associated to the instance.
	AddonSubscriptionId *string `min:"4" type:"string"`

	// The timestamp of when the Add On instance was created.
	CreatedTimestamp *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAddonInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAddonInstanceOutput) GoString() string {
	return s.String()
}

// SetAddonInstanceArn sets the AddonInstanceArn field's value.
func (s *GetAddonInstanceOutput) SetAddonInstanceArn(v string) *GetAddonInstanceOutput {
	s.AddonInstanceArn = &v
	return s
}

// SetAddonName sets the AddonName field's value.
func (s *GetAddonInstanceOutput) SetAddonName(v string) *GetAddonInstanceOutput {
	s.AddonName = &v
	return s
}

// SetAddonSubscriptionId sets the AddonSubscriptionId field's value.
func (s *GetAddonInstanceOutput) SetAddonSubscriptionId(v string) *GetAddonInstanceOutput {
	s.AddonSubscriptionId = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *GetAddonInstanceOutput) SetCreatedTimestamp(v time.Time) *GetAddonInstanceOutput {
	s.CreatedTimestamp = &v
	return s
}

type GetAddonSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// The Add On subscription ID to retrieve information for.
	//
	// AddonSubscriptionId is a required field
	AddonSubscriptionId *string `min:"4" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAddonSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAddonSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAddonSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAddonSubscriptionInput"}
	if s.AddonSubscriptionId == nil {
		invalidParams.Add(request.NewErrParamRequired("AddonSubscriptionId"))
	}
	if s.AddonSubscriptionId != nil && len(*s.AddonSubscriptionId) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("AddonSubscriptionId", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddonSubscriptionId sets the AddonSubscriptionId field's value.
func (s *GetAddonSubscriptionInput) SetAddonSubscriptionId(v string) *GetAddonSubscriptionInput {
	s.AddonSubscriptionId = &v
	return s
}

type GetAddonSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// The name of the Add On for the subscription.
	AddonName *string `type:"string"`

	// Amazon Resource Name (ARN) for the subscription.
	AddonSubscriptionArn *string `type:"string"`

	// The timestamp of when the Add On subscription was created.
	CreatedTimestamp *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAddonSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAddonSubscriptionOutput) GoString() string {
	return s.String()
}

// SetAddonName sets the AddonName field's value.
func (s *GetAddonSubscriptionOutput) SetAddonName(v string) *GetAddonSubscriptionOutput {
	s.AddonName = &v
	return s
}

// SetAddonSubscriptionArn sets the AddonSubscriptionArn field's value.
func (s *GetAddonSubscriptionOutput) SetAddonSubscriptionArn(v string) *GetAddonSubscriptionOutput {
	s.AddonSubscriptionArn = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *GetAddonSubscriptionOutput) SetCreatedTimestamp(v time.Time) *GetAddonSubscriptionOutput {
	s.CreatedTimestamp = &v
	return s
}

// The request to retrieve details of a specific archive export job.
type GetArchiveExportInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the export job to get details for.
	//
	// ExportId is a required field
	ExportId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetArchiveExportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetArchiveExportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetArchiveExportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetArchiveExportInput"}
	if s.ExportId == nil {
		invalidParams.Add(request.NewErrParamRequired("ExportId"))
	}
	if s.ExportId != nil && len(*s.ExportId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExportId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExportId sets the ExportId field's value.
func (s *GetArchiveExportInput) SetExportId(v string) *GetArchiveExportInput {
	s.ExportId = &v
	return s
}

// The response containing details of the specified archive export job.
type GetArchiveExportOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the archive the email export was performed from.
	ArchiveId *string `min:"3" type:"string"`

	// Where the exported emails are being delivered.
	ExportDestinationConfiguration *ExportDestinationConfiguration `type:"structure"`

	// The criteria used to filter emails included in the export.
	Filters *ArchiveFilters `type:"structure"`

	// The start of the timestamp range the exported emails cover.
	FromTimestamp *time.Time `type:"timestamp"`

	// The maximum number of email items included in the export.
	MaxResults *int64 `type:"integer"`

	// The current status of the export job.
	Status *ExportStatus `type:"structure"`

	// The end of the date range the exported emails cover.
	ToTimestamp *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetArchiveExportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetArchiveExportOutput) GoString() string {
	return s.String()
}

// SetArchiveId sets the ArchiveId field's value.
func (s *GetArchiveExportOutput) SetArchiveId(v string) *GetArchiveExportOutput {
	s.ArchiveId = &v
	return s
}

// SetExportDestinationConfiguration sets the ExportDestinationConfiguration field's value.
func (s *GetArchiveExportOutput) SetExportDestinationConfiguration(v *ExportDestinationConfiguration) *GetArchiveExportOutput {
	s.ExportDestinationConfiguration = v
	return s
}

// SetFilters sets the Filters field's value.
func (s *GetArchiveExportOutput) SetFilters(v *ArchiveFilters) *GetArchiveExportOutput {
	s.Filters = v
	return s
}

// SetFromTimestamp sets the FromTimestamp field's value.
func (s *GetArchiveExportOutput) SetFromTimestamp(v time.Time) *GetArchiveExportOutput {
	s.FromTimestamp = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetArchiveExportOutput) SetMaxResults(v int64) *GetArchiveExportOutput {
	s.MaxResults = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetArchiveExportOutput) SetStatus(v *ExportStatus) *GetArchiveExportOutput {
	s.Status = v
	return s
}

// SetToTimestamp sets the ToTimestamp field's value.
func (s *GetArchiveExportOutput) SetToTimestamp(v time.Time) *GetArchiveExportOutput {
	s.ToTimestamp = &v
	return s
}

// The request to retrieve details of an email archive.
type GetArchiveInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the archive to retrieve.
	//
	// ArchiveId is a required field
	ArchiveId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetArchiveInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetArchiveInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetArchiveInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetArchiveInput"}
	if s.ArchiveId == nil {
		invalidParams.Add(request.NewErrParamRequired("ArchiveId"))
	}
	if s.ArchiveId != nil && len(*s.ArchiveId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ArchiveId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArchiveId sets the ArchiveId field's value.
func (s *GetArchiveInput) SetArchiveId(v string) *GetArchiveInput {
	s.ArchiveId = &v
	return s
}

// The request to get the textual content of a specific email message stored
// in an archive.
type GetArchiveMessageContentInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the archived email message.
	//
	// ArchivedMessageId is a required field
	ArchivedMessageId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetArchiveMessageContentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetArchiveMessageContentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetArchiveMessageContentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetArchiveMessageContentInput"}
	if s.ArchivedMessageId == nil {
		invalidParams.Add(request.NewErrParamRequired("ArchivedMessageId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArchivedMessageId sets the ArchivedMessageId field's value.
func (s *GetArchiveMessageContentInput) SetArchivedMessageId(v string) *GetArchiveMessageContentInput {
	s.ArchivedMessageId = &v
	return s
}

// The response containing the textual content of the requested archived email
// message.
type GetArchiveMessageContentOutput struct {
	_ struct{} `type:"structure"`

	// The textual body content of the email message.
	Body *MessageBody `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetArchiveMessageContentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetArchiveMessageContentOutput) GoString() string {
	return s.String()
}

// SetBody sets the Body field's value.
func (s *GetArchiveMessageContentOutput) SetBody(v *MessageBody) *GetArchiveMessageContentOutput {
	s.Body = v
	return s
}

// The request to get details of a specific email message stored in an archive.
type GetArchiveMessageInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the archived email message.
	//
	// ArchivedMessageId is a required field
	ArchivedMessageId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetArchiveMessageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetArchiveMessageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetArchiveMessageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetArchiveMessageInput"}
	if s.ArchivedMessageId == nil {
		invalidParams.Add(request.NewErrParamRequired("ArchivedMessageId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArchivedMessageId sets the ArchivedMessageId field's value.
func (s *GetArchiveMessageInput) SetArchivedMessageId(v string) *GetArchiveMessageInput {
	s.ArchivedMessageId = &v
	return s
}

// The response containing details about the requested archived email message.
type GetArchiveMessageOutput struct {
	_ struct{} `type:"structure"`

	// A pre-signed URL to temporarily download the full message content.
	MessageDownloadLink *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetArchiveMessageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetArchiveMessageOutput) GoString() string {
	return s.String()
}

// SetMessageDownloadLink sets the MessageDownloadLink field's value.
func (s *GetArchiveMessageOutput) SetMessageDownloadLink(v string) *GetArchiveMessageOutput {
	s.MessageDownloadLink = &v
	return s
}

// The response containing details of the requested archive.
type GetArchiveOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the archive.
	//
	// ArchiveArn is a required field
	ArchiveArn *string `type:"string" required:"true"`

	// The unique identifier of the archive.
	//
	// ArchiveId is a required field
	ArchiveId *string `min:"1" type:"string" required:"true"`

	// The unique name assigned to the archive.
	//
	// ArchiveName is a required field
	ArchiveName *string `min:"1" type:"string" required:"true"`

	// The current state of the archive:
	//
	//    * ACTIVE – The archive is ready and available for use.
	//
	//    * PENDING_DELETION – The archive has been marked for deletion and will
	//    be permanently deleted in 30 days. No further modifications can be made
	//    in this state.
	//
	// ArchiveState is a required field
	ArchiveState *string `type:"string" required:"true" enum:"ArchiveState"`

	// The timestamp of when the archive was created.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the KMS key used to encrypt the archive.
	KmsKeyArn *string `type:"string"`

	// The timestamp of when the archive was modified.
	LastUpdatedTimestamp *time.Time `type:"timestamp"`

	// The retention period for emails in this archive.
	//
	// Retention is a required field
	Retention *ArchiveRetention `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetArchiveOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetArchiveOutput) GoString() string {
	return s.String()
}

// SetArchiveArn sets the ArchiveArn field's value.
func (s *GetArchiveOutput) SetArchiveArn(v string) *GetArchiveOutput {
	s.ArchiveArn = &v
	return s
}

// SetArchiveId sets the ArchiveId field's value.
func (s *GetArchiveOutput) SetArchiveId(v string) *GetArchiveOutput {
	s.ArchiveId = &v
	return s
}

// SetArchiveName sets the ArchiveName field's value.
func (s *GetArchiveOutput) SetArchiveName(v string) *GetArchiveOutput {
	s.ArchiveName = &v
	return s
}

// SetArchiveState sets the ArchiveState field's value.
func (s *GetArchiveOutput) SetArchiveState(v string) *GetArchiveOutput {
	s.ArchiveState = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *GetArchiveOutput) SetCreatedTimestamp(v time.Time) *GetArchiveOutput {
	s.CreatedTimestamp = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *GetArchiveOutput) SetKmsKeyArn(v string) *GetArchiveOutput {
	s.KmsKeyArn = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *GetArchiveOutput) SetLastUpdatedTimestamp(v time.Time) *GetArchiveOutput {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetRetention sets the Retention field's value.
func (s *GetArchiveOutput) SetRetention(v *ArchiveRetention) *GetArchiveOutput {
	s.Retention = v
	return s
}

// The request to retrieve details of a specific archive search job.
type GetArchiveSearchInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the search job to get details for.
	//
	// SearchId is a required field
	SearchId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetArchiveSearchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetArchiveSearchInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetArchiveSearchInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetArchiveSearchInput"}
	if s.SearchId == nil {
		invalidParams.Add(request.NewErrParamRequired("SearchId"))
	}
	if s.SearchId != nil && len(*s.SearchId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SearchId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSearchId sets the SearchId field's value.
func (s *GetArchiveSearchInput) SetSearchId(v string) *GetArchiveSearchInput {
	s.SearchId = &v
	return s
}

// The response containing details of the specified archive search job.
type GetArchiveSearchOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the archive the email search was performed in.
	ArchiveId *string `min:"3" type:"string"`

	// The criteria used to filter emails included in the search.
	Filters *ArchiveFilters `type:"structure"`

	// The start timestamp of the range the searched emails cover.
	FromTimestamp *time.Time `type:"timestamp"`

	// The maximum number of search results to return.
	MaxResults *int64 `type:"integer"`

	// The current status of the search job.
	Status *SearchStatus `type:"structure"`

	// The end timestamp of the range the searched emails cover.
	ToTimestamp *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetArchiveSearchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetArchiveSearchOutput) GoString() string {
	return s.String()
}

// SetArchiveId sets the ArchiveId field's value.
func (s *GetArchiveSearchOutput) SetArchiveId(v string) *GetArchiveSearchOutput {
	s.ArchiveId = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *GetArchiveSearchOutput) SetFilters(v *ArchiveFilters) *GetArchiveSearchOutput {
	s.Filters = v
	return s
}

// SetFromTimestamp sets the FromTimestamp field's value.
func (s *GetArchiveSearchOutput) SetFromTimestamp(v time.Time) *GetArchiveSearchOutput {
	s.FromTimestamp = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetArchiveSearchOutput) SetMaxResults(v int64) *GetArchiveSearchOutput {
	s.MaxResults = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetArchiveSearchOutput) SetStatus(v *SearchStatus) *GetArchiveSearchOutput {
	s.Status = v
	return s
}

// SetToTimestamp sets the ToTimestamp field's value.
func (s *GetArchiveSearchOutput) SetToTimestamp(v time.Time) *GetArchiveSearchOutput {
	s.ToTimestamp = &v
	return s
}

// The request to retrieve results from a completed archive search job.
type GetArchiveSearchResultsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the completed search job.
	//
	// SearchId is a required field
	SearchId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetArchiveSearchResultsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetArchiveSearchResultsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetArchiveSearchResultsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetArchiveSearchResultsInput"}
	if s.SearchId == nil {
		invalidParams.Add(request.NewErrParamRequired("SearchId"))
	}
	if s.SearchId != nil && len(*s.SearchId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SearchId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSearchId sets the SearchId field's value.
func (s *GetArchiveSearchResultsInput) SetSearchId(v string) *GetArchiveSearchResultsInput {
	s.SearchId = &v
	return s
}

// The response containing search results from a completed archive search.
type GetArchiveSearchResultsOutput struct {
	_ struct{} `type:"structure"`

	// The list of email result objects matching the search criteria.
	Rows []*Row `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetArchiveSearchResultsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetArchiveSearchResultsOutput) GoString() string {
	return s.String()
}

// SetRows sets the Rows field's value.
func (s *GetArchiveSearchResultsOutput) SetRows(v []*Row) *GetArchiveSearchResultsOutput {
	s.Rows = v
	return s
}

type GetIngressPointInput struct {
	_ struct{} `type:"structure"`

	// The identifier of an ingress endpoint.
	//
	// IngressPointId is a required field
	IngressPointId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIngressPointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIngressPointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIngressPointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIngressPointInput"}
	if s.IngressPointId == nil {
		invalidParams.Add(request.NewErrParamRequired("IngressPointId"))
	}
	if s.IngressPointId != nil && len(*s.IngressPointId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IngressPointId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIngressPointId sets the IngressPointId field's value.
func (s *GetIngressPointInput) SetIngressPointId(v string) *GetIngressPointInput {
	s.IngressPointId = &v
	return s
}

type GetIngressPointOutput struct {
	_ struct{} `type:"structure"`

	// The DNS A Record that identifies your ingress endpoint. Configure your DNS
	// Mail Exchange (MX) record with this value to route emails to Mail Manager.
	ARecord *string `type:"string"`

	// The timestamp of when the ingress endpoint was created.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the ingress endpoint resource.
	IngressPointArn *string `type:"string"`

	// The authentication configuration of the ingress endpoint resource.
	IngressPointAuthConfiguration *IngressPointAuthConfiguration `type:"structure"`

	// The identifier of an ingress endpoint resource.
	//
	// IngressPointId is a required field
	IngressPointId *string `min:"1" type:"string" required:"true"`

	// A user friendly name for the ingress endpoint.
	//
	// IngressPointName is a required field
	IngressPointName *string `min:"3" type:"string" required:"true"`

	// The timestamp of when the ingress endpoint was last updated.
	LastUpdatedTimestamp *time.Time `type:"timestamp"`

	// The identifier of a rule set resource associated with the ingress endpoint.
	RuleSetId *string `min:"1" type:"string"`

	// The status of the ingress endpoint resource.
	Status *string `type:"string" enum:"IngressPointStatus"`

	// The identifier of the traffic policy resource associated with the ingress
	// endpoint.
	TrafficPolicyId *string `min:"1" type:"string"`

	// The type of ingress endpoint.
	Type *string `type:"string" enum:"IngressPointType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIngressPointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIngressPointOutput) GoString() string {
	return s.String()
}

// SetARecord sets the ARecord field's value.
func (s *GetIngressPointOutput) SetARecord(v string) *GetIngressPointOutput {
	s.ARecord = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *GetIngressPointOutput) SetCreatedTimestamp(v time.Time) *GetIngressPointOutput {
	s.CreatedTimestamp = &v
	return s
}

// SetIngressPointArn sets the IngressPointArn field's value.
func (s *GetIngressPointOutput) SetIngressPointArn(v string) *GetIngressPointOutput {
	s.IngressPointArn = &v
	return s
}

// SetIngressPointAuthConfiguration sets the IngressPointAuthConfiguration field's value.
func (s *GetIngressPointOutput) SetIngressPointAuthConfiguration(v *IngressPointAuthConfiguration) *GetIngressPointOutput {
	s.IngressPointAuthConfiguration = v
	return s
}

// SetIngressPointId sets the IngressPointId field's value.
func (s *GetIngressPointOutput) SetIngressPointId(v string) *GetIngressPointOutput {
	s.IngressPointId = &v
	return s
}

// SetIngressPointName sets the IngressPointName field's value.
func (s *GetIngressPointOutput) SetIngressPointName(v string) *GetIngressPointOutput {
	s.IngressPointName = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *GetIngressPointOutput) SetLastUpdatedTimestamp(v time.Time) *GetIngressPointOutput {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetRuleSetId sets the RuleSetId field's value.
func (s *GetIngressPointOutput) SetRuleSetId(v string) *GetIngressPointOutput {
	s.RuleSetId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetIngressPointOutput) SetStatus(v string) *GetIngressPointOutput {
	s.Status = &v
	return s
}

// SetTrafficPolicyId sets the TrafficPolicyId field's value.
func (s *GetIngressPointOutput) SetTrafficPolicyId(v string) *GetIngressPointOutput {
	s.TrafficPolicyId = &v
	return s
}

// SetType sets the Type field's value.
func (s *GetIngressPointOutput) SetType(v string) *GetIngressPointOutput {
	s.Type = &v
	return s
}

type GetRelayInput struct {
	_ struct{} `type:"structure"`

	// A unique relay identifier.
	//
	// RelayId is a required field
	RelayId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRelayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRelayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRelayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRelayInput"}
	if s.RelayId == nil {
		invalidParams.Add(request.NewErrParamRequired("RelayId"))
	}
	if s.RelayId != nil && len(*s.RelayId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RelayId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRelayId sets the RelayId field's value.
func (s *GetRelayInput) SetRelayId(v string) *GetRelayInput {
	s.RelayId = &v
	return s
}

type GetRelayOutput struct {
	_ struct{} `type:"structure"`

	// The authentication attribute—contains the secret ARN where the customer
	// relay server credentials are stored.
	Authentication *RelayAuthentication `type:"structure"`

	// The timestamp of when the relay was created.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The timestamp of when relay was last updated.
	LastModifiedTimestamp *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the relay.
	RelayArn *string `type:"string"`

	// The unique relay identifier.
	//
	// RelayId is a required field
	RelayId *string `min:"1" type:"string" required:"true"`

	// The unique name of the relay.
	RelayName *string `min:"1" type:"string"`

	// The destination relay server address.
	ServerName *string `min:"1" type:"string"`

	// The destination relay server port.
	ServerPort *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRelayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRelayOutput) GoString() string {
	return s.String()
}

// SetAuthentication sets the Authentication field's value.
func (s *GetRelayOutput) SetAuthentication(v *RelayAuthentication) *GetRelayOutput {
	s.Authentication = v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *GetRelayOutput) SetCreatedTimestamp(v time.Time) *GetRelayOutput {
	s.CreatedTimestamp = &v
	return s
}

// SetLastModifiedTimestamp sets the LastModifiedTimestamp field's value.
func (s *GetRelayOutput) SetLastModifiedTimestamp(v time.Time) *GetRelayOutput {
	s.LastModifiedTimestamp = &v
	return s
}

// SetRelayArn sets the RelayArn field's value.
func (s *GetRelayOutput) SetRelayArn(v string) *GetRelayOutput {
	s.RelayArn = &v
	return s
}

// SetRelayId sets the RelayId field's value.
func (s *GetRelayOutput) SetRelayId(v string) *GetRelayOutput {
	s.RelayId = &v
	return s
}

// SetRelayName sets the RelayName field's value.
func (s *GetRelayOutput) SetRelayName(v string) *GetRelayOutput {
	s.RelayName = &v
	return s
}

// SetServerName sets the ServerName field's value.
func (s *GetRelayOutput) SetServerName(v string) *GetRelayOutput {
	s.ServerName = &v
	return s
}

// SetServerPort sets the ServerPort field's value.
func (s *GetRelayOutput) SetServerPort(v int64) *GetRelayOutput {
	s.ServerPort = &v
	return s
}

type GetRuleSetInput struct {
	_ struct{} `type:"structure"`

	// The identifier of an existing rule set to be retrieved.
	//
	// RuleSetId is a required field
	RuleSetId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRuleSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRuleSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRuleSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRuleSetInput"}
	if s.RuleSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleSetId"))
	}
	if s.RuleSetId != nil && len(*s.RuleSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRuleSetId sets the RuleSetId field's value.
func (s *GetRuleSetInput) SetRuleSetId(v string) *GetRuleSetInput {
	s.RuleSetId = &v
	return s
}

type GetRuleSetOutput struct {
	_ struct{} `type:"structure"`

	// The date of when then rule set was created.
	//
	// CreatedDate is a required field
	CreatedDate *time.Time `type:"timestamp" required:"true"`

	// The date of when the rule set was last modified.
	//
	// LastModificationDate is a required field
	LastModificationDate *time.Time `type:"timestamp" required:"true"`

	// The Amazon Resource Name (ARN) of the rule set resource.
	//
	// RuleSetArn is a required field
	RuleSetArn *string `type:"string" required:"true"`

	// The identifier of the rule set resource.
	//
	// RuleSetId is a required field
	RuleSetId *string `min:"1" type:"string" required:"true"`

	// A user-friendly name for the rule set resource.
	//
	// RuleSetName is a required field
	RuleSetName *string `min:"1" type:"string" required:"true"`

	// The rules contained in the rule set.
	//
	// Rules is a required field
	Rules []*Rule `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRuleSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRuleSetOutput) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *GetRuleSetOutput) SetCreatedDate(v time.Time) *GetRuleSetOutput {
	s.CreatedDate = &v
	return s
}

// SetLastModificationDate sets the LastModificationDate field's value.
func (s *GetRuleSetOutput) SetLastModificationDate(v time.Time) *GetRuleSetOutput {
	s.LastModificationDate = &v
	return s
}

// SetRuleSetArn sets the RuleSetArn field's value.
func (s *GetRuleSetOutput) SetRuleSetArn(v string) *GetRuleSetOutput {
	s.RuleSetArn = &v
	return s
}

// SetRuleSetId sets the RuleSetId field's value.
func (s *GetRuleSetOutput) SetRuleSetId(v string) *GetRuleSetOutput {
	s.RuleSetId = &v
	return s
}

// SetRuleSetName sets the RuleSetName field's value.
func (s *GetRuleSetOutput) SetRuleSetName(v string) *GetRuleSetOutput {
	s.RuleSetName = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *GetRuleSetOutput) SetRules(v []*Rule) *GetRuleSetOutput {
	s.Rules = v
	return s
}

type GetTrafficPolicyInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the traffic policy resource.
	//
	// TrafficPolicyId is a required field
	TrafficPolicyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTrafficPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTrafficPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTrafficPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTrafficPolicyInput"}
	if s.TrafficPolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("TrafficPolicyId"))
	}
	if s.TrafficPolicyId != nil && len(*s.TrafficPolicyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrafficPolicyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTrafficPolicyId sets the TrafficPolicyId field's value.
func (s *GetTrafficPolicyInput) SetTrafficPolicyId(v string) *GetTrafficPolicyInput {
	s.TrafficPolicyId = &v
	return s
}

type GetTrafficPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the traffic policy was created.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The default action of the traffic policy.
	DefaultAction *string `type:"string" enum:"AcceptAction"`

	// The timestamp of when the traffic policy was last updated.
	LastUpdatedTimestamp *time.Time `type:"timestamp"`

	// The maximum message size in bytes of email which is allowed in by this traffic
	// policy—anything larger will be blocked.
	MaxMessageSizeBytes *int64 `min:"1" type:"integer"`

	// The list of conditions which are in the traffic policy resource.
	PolicyStatements []*PolicyStatement `type:"list"`

	// The Amazon Resource Name (ARN) of the traffic policy resource.
	TrafficPolicyArn *string `type:"string"`

	// The identifier of the traffic policy resource.
	//
	// TrafficPolicyId is a required field
	TrafficPolicyId *string `min:"1" type:"string" required:"true"`

	// A user-friendly name for the traffic policy resource.
	//
	// TrafficPolicyName is a required field
	TrafficPolicyName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTrafficPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTrafficPolicyOutput) GoString() string {
	return s.String()
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *GetTrafficPolicyOutput) SetCreatedTimestamp(v time.Time) *GetTrafficPolicyOutput {
	s.CreatedTimestamp = &v
	return s
}

// SetDefaultAction sets the DefaultAction field's value.
func (s *GetTrafficPolicyOutput) SetDefaultAction(v string) *GetTrafficPolicyOutput {
	s.DefaultAction = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *GetTrafficPolicyOutput) SetLastUpdatedTimestamp(v time.Time) *GetTrafficPolicyOutput {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetMaxMessageSizeBytes sets the MaxMessageSizeBytes field's value.
func (s *GetTrafficPolicyOutput) SetMaxMessageSizeBytes(v int64) *GetTrafficPolicyOutput {
	s.MaxMessageSizeBytes = &v
	return s
}

// SetPolicyStatements sets the PolicyStatements field's value.
func (s *GetTrafficPolicyOutput) SetPolicyStatements(v []*PolicyStatement) *GetTrafficPolicyOutput {
	s.PolicyStatements = v
	return s
}

// SetTrafficPolicyArn sets the TrafficPolicyArn field's value.
func (s *GetTrafficPolicyOutput) SetTrafficPolicyArn(v string) *GetTrafficPolicyOutput {
	s.TrafficPolicyArn = &v
	return s
}

// SetTrafficPolicyId sets the TrafficPolicyId field's value.
func (s *GetTrafficPolicyOutput) SetTrafficPolicyId(v string) *GetTrafficPolicyOutput {
	s.TrafficPolicyId = &v
	return s
}

// SetTrafficPolicyName sets the TrafficPolicyName field's value.
func (s *GetTrafficPolicyOutput) SetTrafficPolicyName(v string) *GetTrafficPolicyOutput {
	s.TrafficPolicyName = &v
	return s
}

// The Add On ARN and its returned value that is evaluated in a policy statement's
// conditional expression to either deny or block the incoming email.
type IngressAnalysis struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an Add On.
	//
	// Analyzer is a required field
	Analyzer *string `type:"string" required:"true"`

	// The returned value from an Add On.
	//
	// ResultField is a required field
	ResultField *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngressAnalysis) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngressAnalysis) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IngressAnalysis) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IngressAnalysis"}
	if s.Analyzer == nil {
		invalidParams.Add(request.NewErrParamRequired("Analyzer"))
	}
	if s.ResultField == nil {
		invalidParams.Add(request.NewErrParamRequired("ResultField"))
	}
	if s.ResultField != nil && len(*s.ResultField) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResultField", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyzer sets the Analyzer field's value.
func (s *IngressAnalysis) SetAnalyzer(v string) *IngressAnalysis {
	s.Analyzer = &v
	return s
}

// SetResultField sets the ResultField field's value.
func (s *IngressAnalysis) SetResultField(v string) *IngressAnalysis {
	s.ResultField = &v
	return s
}

// The structure for a boolean condition matching on the incoming mail.
type IngressBooleanExpression struct {
	_ struct{} `type:"structure"`

	// The operand on which to perform a boolean condition operation.
	//
	// Evaluate is a required field
	Evaluate *IngressBooleanToEvaluate `type:"structure" required:"true"`

	// The matching operator for a boolean condition expression.
	//
	// Operator is a required field
	Operator *string `type:"string" required:"true" enum:"IngressBooleanOperator"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngressBooleanExpression) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngressBooleanExpression) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IngressBooleanExpression) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IngressBooleanExpression"}
	if s.Evaluate == nil {
		invalidParams.Add(request.NewErrParamRequired("Evaluate"))
	}
	if s.Operator == nil {
		invalidParams.Add(request.NewErrParamRequired("Operator"))
	}
	if s.Evaluate != nil {
		if err := s.Evaluate.Validate(); err != nil {
			invalidParams.AddNested("Evaluate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEvaluate sets the Evaluate field's value.
func (s *IngressBooleanExpression) SetEvaluate(v *IngressBooleanToEvaluate) *IngressBooleanExpression {
	s.Evaluate = v
	return s
}

// SetOperator sets the Operator field's value.
func (s *IngressBooleanExpression) SetOperator(v string) *IngressBooleanExpression {
	s.Operator = &v
	return s
}

// The union type representing the allowed types of operands for a boolean condition.
type IngressBooleanToEvaluate struct {
	_ struct{} `type:"structure"`

	// The structure type for a boolean condition stating the Add On ARN and its
	// returned value.
	Analysis *IngressAnalysis `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngressBooleanToEvaluate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngressBooleanToEvaluate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IngressBooleanToEvaluate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IngressBooleanToEvaluate"}
	if s.Analysis != nil {
		if err := s.Analysis.Validate(); err != nil {
			invalidParams.AddNested("Analysis", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalysis sets the Analysis field's value.
func (s *IngressBooleanToEvaluate) SetAnalysis(v *IngressAnalysis) *IngressBooleanToEvaluate {
	s.Analysis = v
	return s
}

// The structure for an IP based condition matching on the incoming mail.
type IngressIpToEvaluate struct {
	_ struct{} `type:"structure"`

	// An enum type representing the allowed attribute types for an IP condition.
	Attribute *string `type:"string" enum:"IngressIpv4Attribute"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngressIpToEvaluate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngressIpToEvaluate) GoString() string {
	return s.String()
}

// SetAttribute sets the Attribute field's value.
func (s *IngressIpToEvaluate) SetAttribute(v string) *IngressIpToEvaluate {
	s.Attribute = &v
	return s
}

// The union type representing the allowed types for the left hand side of an
// IP condition.
type IngressIpv4Expression struct {
	_ struct{} `type:"structure"`

	// The left hand side argument of an IP condition expression.
	//
	// Evaluate is a required field
	Evaluate *IngressIpToEvaluate `type:"structure" required:"true"`

	// The matching operator for an IP condition expression.
	//
	// Operator is a required field
	Operator *string `type:"string" required:"true" enum:"IngressIpOperator"`

	// The right hand side argument of an IP condition expression.
	//
	// Values is a required field
	Values []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngressIpv4Expression) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngressIpv4Expression) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IngressIpv4Expression) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IngressIpv4Expression"}
	if s.Evaluate == nil {
		invalidParams.Add(request.NewErrParamRequired("Evaluate"))
	}
	if s.Operator == nil {
		invalidParams.Add(request.NewErrParamRequired("Operator"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEvaluate sets the Evaluate field's value.
func (s *IngressIpv4Expression) SetEvaluate(v *IngressIpToEvaluate) *IngressIpv4Expression {
	s.Evaluate = v
	return s
}

// SetOperator sets the Operator field's value.
func (s *IngressIpv4Expression) SetOperator(v string) *IngressIpv4Expression {
	s.Operator = &v
	return s
}

// SetValues sets the Values field's value.
func (s *IngressIpv4Expression) SetValues(v []*string) *IngressIpv4Expression {
	s.Values = v
	return s
}

// The structure of an ingress endpoint resource.
type IngressPoint struct {
	_ struct{} `type:"structure"`

	// The DNS A Record that identifies your ingress endpoint. Configure your DNS
	// Mail Exchange (MX) record with this value to route emails to Mail Manager.
	ARecord *string `type:"string"`

	// The identifier of the ingress endpoint resource.
	//
	// IngressPointId is a required field
	IngressPointId *string `min:"1" type:"string" required:"true"`

	// A user friendly name for the ingress endpoint resource.
	//
	// IngressPointName is a required field
	IngressPointName *string `min:"3" type:"string" required:"true"`

	// The status of the ingress endpoint resource.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"IngressPointStatus"`

	// The type of ingress endpoint resource.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"IngressPointType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngressPoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngressPoint) GoString() string {
	return s.String()
}

// SetARecord sets the ARecord field's value.
func (s *IngressPoint) SetARecord(v string) *IngressPoint {
	s.ARecord = &v
	return s
}

// SetIngressPointId sets the IngressPointId field's value.
func (s *IngressPoint) SetIngressPointId(v string) *IngressPoint {
	s.IngressPointId = &v
	return s
}

// SetIngressPointName sets the IngressPointName field's value.
func (s *IngressPoint) SetIngressPointName(v string) *IngressPoint {
	s.IngressPointName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *IngressPoint) SetStatus(v string) *IngressPoint {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *IngressPoint) SetType(v string) *IngressPoint {
	s.Type = &v
	return s
}

// The authentication configuration for the ingress endpoint resource.
type IngressPointAuthConfiguration struct {
	_ struct{} `type:"structure"`

	// The ingress endpoint password configuration for the ingress endpoint resource.
	IngressPointPasswordConfiguration *IngressPointPasswordConfiguration `type:"structure"`

	// The ingress endpoint SecretsManager::Secret ARN configuration for the ingress
	// endpoint resource.
	SecretArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngressPointAuthConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngressPointAuthConfiguration) GoString() string {
	return s.String()
}

// SetIngressPointPasswordConfiguration sets the IngressPointPasswordConfiguration field's value.
func (s *IngressPointAuthConfiguration) SetIngressPointPasswordConfiguration(v *IngressPointPasswordConfiguration) *IngressPointAuthConfiguration {
	s.IngressPointPasswordConfiguration = v
	return s
}

// SetSecretArn sets the SecretArn field's value.
func (s *IngressPointAuthConfiguration) SetSecretArn(v string) *IngressPointAuthConfiguration {
	s.SecretArn = &v
	return s
}

// The configuration of the ingress endpoint resource.
type IngressPointConfiguration struct {
	_ struct{} `type:"structure"`

	// The SecretsManager::Secret ARN of the ingress endpoint resource.
	SecretArn *string `type:"string"`

	// The password of the ingress endpoint resource.
	//
	// SmtpPassword is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by IngressPointConfiguration's
	// String and GoString methods.
	SmtpPassword *string `min:"8" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngressPointConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngressPointConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IngressPointConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IngressPointConfiguration"}
	if s.SmtpPassword != nil && len(*s.SmtpPassword) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("SmtpPassword", 8))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecretArn sets the SecretArn field's value.
func (s *IngressPointConfiguration) SetSecretArn(v string) *IngressPointConfiguration {
	s.SecretArn = &v
	return s
}

// SetSmtpPassword sets the SmtpPassword field's value.
func (s *IngressPointConfiguration) SetSmtpPassword(v string) *IngressPointConfiguration {
	s.SmtpPassword = &v
	return s
}

// The password configuration of the ingress endpoint resource.
type IngressPointPasswordConfiguration struct {
	_ struct{} `type:"structure"`

	// The previous password expiry timestamp of the ingress endpoint resource.
	PreviousSmtpPasswordExpiryTimestamp *time.Time `type:"timestamp"`

	// The previous password version of the ingress endpoint resource.
	PreviousSmtpPasswordVersion *string `type:"string"`

	// The current password expiry timestamp of the ingress endpoint resource.
	SmtpPasswordVersion *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngressPointPasswordConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngressPointPasswordConfiguration) GoString() string {
	return s.String()
}

// SetPreviousSmtpPasswordExpiryTimestamp sets the PreviousSmtpPasswordExpiryTimestamp field's value.
func (s *IngressPointPasswordConfiguration) SetPreviousSmtpPasswordExpiryTimestamp(v time.Time) *IngressPointPasswordConfiguration {
	s.PreviousSmtpPasswordExpiryTimestamp = &v
	return s
}

// SetPreviousSmtpPasswordVersion sets the PreviousSmtpPasswordVersion field's value.
func (s *IngressPointPasswordConfiguration) SetPreviousSmtpPasswordVersion(v string) *IngressPointPasswordConfiguration {
	s.PreviousSmtpPasswordVersion = &v
	return s
}

// SetSmtpPasswordVersion sets the SmtpPasswordVersion field's value.
func (s *IngressPointPasswordConfiguration) SetSmtpPasswordVersion(v string) *IngressPointPasswordConfiguration {
	s.SmtpPasswordVersion = &v
	return s
}

// The structure for a string based condition matching on the incoming mail.
type IngressStringExpression struct {
	_ struct{} `type:"structure"`

	// The left hand side argument of a string condition expression.
	//
	// Evaluate is a required field
	Evaluate *IngressStringToEvaluate `type:"structure" required:"true"`

	// The matching operator for a string condition expression.
	//
	// Operator is a required field
	Operator *string `type:"string" required:"true" enum:"IngressStringOperator"`

	// The right hand side argument of a string condition expression.
	//
	// Values is a required field
	Values []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngressStringExpression) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngressStringExpression) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IngressStringExpression) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IngressStringExpression"}
	if s.Evaluate == nil {
		invalidParams.Add(request.NewErrParamRequired("Evaluate"))
	}
	if s.Operator == nil {
		invalidParams.Add(request.NewErrParamRequired("Operator"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEvaluate sets the Evaluate field's value.
func (s *IngressStringExpression) SetEvaluate(v *IngressStringToEvaluate) *IngressStringExpression {
	s.Evaluate = v
	return s
}

// SetOperator sets the Operator field's value.
func (s *IngressStringExpression) SetOperator(v string) *IngressStringExpression {
	s.Operator = &v
	return s
}

// SetValues sets the Values field's value.
func (s *IngressStringExpression) SetValues(v []*string) *IngressStringExpression {
	s.Values = v
	return s
}

// The union type representing the allowed types for the left hand side of a
// string condition.
type IngressStringToEvaluate struct {
	_ struct{} `type:"structure"`

	// The enum type representing the allowed attribute types for a string condition.
	Attribute *string `type:"string" enum:"IngressStringEmailAttribute"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngressStringToEvaluate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngressStringToEvaluate) GoString() string {
	return s.String()
}

// SetAttribute sets the Attribute field's value.
func (s *IngressStringToEvaluate) SetAttribute(v string) *IngressStringToEvaluate {
	s.Attribute = &v
	return s
}

// The structure for a TLS related condition matching on the incoming mail.
type IngressTlsProtocolExpression struct {
	_ struct{} `type:"structure"`

	// The left hand side argument of a TLS condition expression.
	//
	// Evaluate is a required field
	Evaluate *IngressTlsProtocolToEvaluate `type:"structure" required:"true"`

	// The matching operator for a TLS condition expression.
	//
	// Operator is a required field
	Operator *string `type:"string" required:"true" enum:"IngressTlsProtocolOperator"`

	// The right hand side argument of a TLS condition expression.
	//
	// Value is a required field
	Value *string `type:"string" required:"true" enum:"IngressTlsProtocolAttribute"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngressTlsProtocolExpression) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngressTlsProtocolExpression) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IngressTlsProtocolExpression) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IngressTlsProtocolExpression"}
	if s.Evaluate == nil {
		invalidParams.Add(request.NewErrParamRequired("Evaluate"))
	}
	if s.Operator == nil {
		invalidParams.Add(request.NewErrParamRequired("Operator"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEvaluate sets the Evaluate field's value.
func (s *IngressTlsProtocolExpression) SetEvaluate(v *IngressTlsProtocolToEvaluate) *IngressTlsProtocolExpression {
	s.Evaluate = v
	return s
}

// SetOperator sets the Operator field's value.
func (s *IngressTlsProtocolExpression) SetOperator(v string) *IngressTlsProtocolExpression {
	s.Operator = &v
	return s
}

// SetValue sets the Value field's value.
func (s *IngressTlsProtocolExpression) SetValue(v string) *IngressTlsProtocolExpression {
	s.Value = &v
	return s
}

// The union type representing the allowed types for the left hand side of a
// TLS condition.
type IngressTlsProtocolToEvaluate struct {
	_ struct{} `type:"structure"`

	// The enum type representing the allowed attribute types for the TLS condition.
	Attribute *string `type:"string" enum:"IngressTlsAttribute"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngressTlsProtocolToEvaluate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngressTlsProtocolToEvaluate) GoString() string {
	return s.String()
}

// SetAttribute sets the Attribute field's value.
func (s *IngressTlsProtocolToEvaluate) SetAttribute(v string) *IngressTlsProtocolToEvaluate {
	s.Attribute = &v
	return s
}

type ListAddonInstancesInput struct {
	_ struct{} `type:"structure"`

	// If you received a pagination token from a previous call to this API, you
	// can provide it here to continue paginating through the next page of results.
	NextToken *string `min:"1" type:"string"`

	// The maximum number of ingress endpoint resources that are returned per call.
	// You can use NextToken to obtain further ingress endpoints.
	PageSize *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAddonInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAddonInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAddonInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAddonInstancesInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListAddonInstancesInput) SetNextToken(v string) *ListAddonInstancesInput {
	s.NextToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListAddonInstancesInput) SetPageSize(v int64) *ListAddonInstancesInput {
	s.PageSize = &v
	return s
}

type ListAddonInstancesOutput struct {
	_ struct{} `type:"structure"`

	// The list of ingress endpoints.
	AddonInstances []*AddonInstance `type:"list"`

	// If NextToken is returned, there are more results available. The value of
	// NextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAddonInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAddonInstancesOutput) GoString() string {
	return s.String()
}

// SetAddonInstances sets the AddonInstances field's value.
func (s *ListAddonInstancesOutput) SetAddonInstances(v []*AddonInstance) *ListAddonInstancesOutput {
	s.AddonInstances = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAddonInstancesOutput) SetNextToken(v string) *ListAddonInstancesOutput {
	s.NextToken = &v
	return s
}

type ListAddonSubscriptionsInput struct {
	_ struct{} `type:"structure"`

	// If you received a pagination token from a previous call to this API, you
	// can provide it here to continue paginating through the next page of results.
	NextToken *string `min:"1" type:"string"`

	// The maximum number of ingress endpoint resources that are returned per call.
	// You can use NextToken to obtain further ingress endpoints.
	PageSize *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAddonSubscriptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAddonSubscriptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAddonSubscriptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAddonSubscriptionsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListAddonSubscriptionsInput) SetNextToken(v string) *ListAddonSubscriptionsInput {
	s.NextToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListAddonSubscriptionsInput) SetPageSize(v int64) *ListAddonSubscriptionsInput {
	s.PageSize = &v
	return s
}

type ListAddonSubscriptionsOutput struct {
	_ struct{} `type:"structure"`

	// The list of ingress endpoints.
	AddonSubscriptions []*AddonSubscription `type:"list"`

	// If NextToken is returned, there are more results available. The value of
	// NextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAddonSubscriptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAddonSubscriptionsOutput) GoString() string {
	return s.String()
}

// SetAddonSubscriptions sets the AddonSubscriptions field's value.
func (s *ListAddonSubscriptionsOutput) SetAddonSubscriptions(v []*AddonSubscription) *ListAddonSubscriptionsOutput {
	s.AddonSubscriptions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAddonSubscriptionsOutput) SetNextToken(v string) *ListAddonSubscriptionsOutput {
	s.NextToken = &v
	return s
}

// The request to list archive export jobs in your account.
type ListArchiveExportsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the archive.
	//
	// ArchiveId is a required field
	ArchiveId *string `min:"3" type:"string" required:"true"`

	// If NextToken is returned, there are more results available. The value of
	// NextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page.
	NextToken *string `min:"1" type:"string"`

	// The maximum number of archive export jobs that are returned per call. You
	// can use NextToken to obtain further pages of archives.
	PageSize *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListArchiveExportsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListArchiveExportsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListArchiveExportsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListArchiveExportsInput"}
	if s.ArchiveId == nil {
		invalidParams.Add(request.NewErrParamRequired("ArchiveId"))
	}
	if s.ArchiveId != nil && len(*s.ArchiveId) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ArchiveId", 3))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArchiveId sets the ArchiveId field's value.
func (s *ListArchiveExportsInput) SetArchiveId(v string) *ListArchiveExportsInput {
	s.ArchiveId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListArchiveExportsInput) SetNextToken(v string) *ListArchiveExportsInput {
	s.NextToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListArchiveExportsInput) SetPageSize(v int64) *ListArchiveExportsInput {
	s.PageSize = &v
	return s
}

// The response containing a list of archive export jobs and their statuses.
type ListArchiveExportsOutput struct {
	_ struct{} `type:"structure"`

	// The list of export job identifiers and statuses.
	Exports []*ExportSummary `type:"list"`

	// If present, use to retrieve the next page of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListArchiveExportsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListArchiveExportsOutput) GoString() string {
	return s.String()
}

// SetExports sets the Exports field's value.
func (s *ListArchiveExportsOutput) SetExports(v []*ExportSummary) *ListArchiveExportsOutput {
	s.Exports = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListArchiveExportsOutput) SetNextToken(v string) *ListArchiveExportsOutput {
	s.NextToken = &v
	return s
}

// The request to list archive search jobs in your account.
type ListArchiveSearchesInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the archive.
	//
	// ArchiveId is a required field
	ArchiveId *string `min:"3" type:"string" required:"true"`

	// If NextToken is returned, there are more results available. The value of
	// NextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page.
	NextToken *string `min:"1" type:"string"`

	// The maximum number of archive search jobs that are returned per call. You
	// can use NextToken to obtain further pages of archives.
	PageSize *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListArchiveSearchesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListArchiveSearchesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListArchiveSearchesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListArchiveSearchesInput"}
	if s.ArchiveId == nil {
		invalidParams.Add(request.NewErrParamRequired("ArchiveId"))
	}
	if s.ArchiveId != nil && len(*s.ArchiveId) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ArchiveId", 3))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArchiveId sets the ArchiveId field's value.
func (s *ListArchiveSearchesInput) SetArchiveId(v string) *ListArchiveSearchesInput {
	s.ArchiveId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListArchiveSearchesInput) SetNextToken(v string) *ListArchiveSearchesInput {
	s.NextToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListArchiveSearchesInput) SetPageSize(v int64) *ListArchiveSearchesInput {
	s.PageSize = &v
	return s
}

// The response containing a list of archive search jobs and their statuses.
type ListArchiveSearchesOutput struct {
	_ struct{} `type:"structure"`

	// If present, use to retrieve the next page of results.
	NextToken *string `min:"1" type:"string"`

	// The list of search job identifiers and statuses.
	Searches []*SearchSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListArchiveSearchesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListArchiveSearchesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListArchiveSearchesOutput) SetNextToken(v string) *ListArchiveSearchesOutput {
	s.NextToken = &v
	return s
}

// SetSearches sets the Searches field's value.
func (s *ListArchiveSearchesOutput) SetSearches(v []*SearchSummary) *ListArchiveSearchesOutput {
	s.Searches = v
	return s
}

// The request to list email archives in your account.
type ListArchivesInput struct {
	_ struct{} `type:"structure"`

	// If NextToken is returned, there are more results available. The value of
	// NextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page.
	NextToken *string `min:"1" type:"string"`

	// The maximum number of archives that are returned per call. You can use NextToken
	// to obtain further pages of archives.
	PageSize *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListArchivesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListArchivesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListArchivesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListArchivesInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListArchivesInput) SetNextToken(v string) *ListArchivesInput {
	s.NextToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListArchivesInput) SetPageSize(v int64) *ListArchivesInput {
	s.PageSize = &v
	return s
}

// The response containing a list of your email archives.
type ListArchivesOutput struct {
	_ struct{} `type:"structure"`

	// The list of archive details.
	//
	// Archives is a required field
	Archives []*Archive `type:"list" required:"true"`

	// If present, use to retrieve the next page of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListArchivesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListArchivesOutput) GoString() string {
	return s.String()
}

// SetArchives sets the Archives field's value.
func (s *ListArchivesOutput) SetArchives(v []*Archive) *ListArchivesOutput {
	s.Archives = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListArchivesOutput) SetNextToken(v string) *ListArchivesOutput {
	s.NextToken = &v
	return s
}

type ListIngressPointsInput struct {
	_ struct{} `type:"structure"`

	// If you received a pagination token from a previous call to this API, you
	// can provide it here to continue paginating through the next page of results.
	NextToken *string `min:"1" type:"string"`

	// The maximum number of ingress endpoint resources that are returned per call.
	// You can use NextToken to obtain further ingress endpoints.
	PageSize *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIngressPointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIngressPointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIngressPointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIngressPointsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListIngressPointsInput) SetNextToken(v string) *ListIngressPointsInput {
	s.NextToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListIngressPointsInput) SetPageSize(v int64) *ListIngressPointsInput {
	s.PageSize = &v
	return s
}

type ListIngressPointsOutput struct {
	_ struct{} `type:"structure"`

	// The list of ingress endpoints.
	IngressPoints []*IngressPoint `type:"list"`

	// If NextToken is returned, there are more results available. The value of
	// NextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIngressPointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIngressPointsOutput) GoString() string {
	return s.String()
}

// SetIngressPoints sets the IngressPoints field's value.
func (s *ListIngressPointsOutput) SetIngressPoints(v []*IngressPoint) *ListIngressPointsOutput {
	s.IngressPoints = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIngressPointsOutput) SetNextToken(v string) *ListIngressPointsOutput {
	s.NextToken = &v
	return s
}

type ListRelaysInput struct {
	_ struct{} `type:"structure"`

	// If you received a pagination token from a previous call to this API, you
	// can provide it here to continue paginating through the next page of results.
	NextToken *string `min:"1" type:"string"`

	// The number of relays to be returned in one request.
	PageSize *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRelaysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRelaysInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRelaysInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRelaysInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListRelaysInput) SetNextToken(v string) *ListRelaysInput {
	s.NextToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListRelaysInput) SetPageSize(v int64) *ListRelaysInput {
	s.PageSize = &v
	return s
}

type ListRelaysOutput struct {
	_ struct{} `type:"structure"`

	// If NextToken is returned, there are more results available. The value of
	// NextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page.
	NextToken *string `min:"1" type:"string"`

	// The list of returned relays.
	//
	// Relays is a required field
	Relays []*Relay `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRelaysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRelaysOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRelaysOutput) SetNextToken(v string) *ListRelaysOutput {
	s.NextToken = &v
	return s
}

// SetRelays sets the Relays field's value.
func (s *ListRelaysOutput) SetRelays(v []*Relay) *ListRelaysOutput {
	s.Relays = v
	return s
}

type ListRuleSetsInput struct {
	_ struct{} `type:"structure"`

	// If you received a pagination token from a previous call to this API, you
	// can provide it here to continue paginating through the next page of results.
	NextToken *string `min:"1" type:"string"`

	// The maximum number of rule set resources that are returned per call. You
	// can use NextToken to obtain further rule sets.
	PageSize *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRuleSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRuleSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRuleSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRuleSetsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListRuleSetsInput) SetNextToken(v string) *ListRuleSetsInput {
	s.NextToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListRuleSetsInput) SetPageSize(v int64) *ListRuleSetsInput {
	s.PageSize = &v
	return s
}

type ListRuleSetsOutput struct {
	_ struct{} `type:"structure"`

	// If NextToken is returned, there are more results available. The value of
	// NextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page.
	NextToken *string `min:"1" type:"string"`

	// The list of rule sets.
	//
	// RuleSets is a required field
	RuleSets []*RuleSet `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRuleSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRuleSetsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRuleSetsOutput) SetNextToken(v string) *ListRuleSetsOutput {
	s.NextToken = &v
	return s
}

// SetRuleSets sets the RuleSets field's value.
func (s *ListRuleSetsOutput) SetRuleSets(v []*RuleSet) *ListRuleSetsOutput {
	s.RuleSets = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource to retrieve tags from.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags used to organize, track, or control access for the resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListTrafficPoliciesInput struct {
	_ struct{} `type:"structure"`

	// If you received a pagination token from a previous call to this API, you
	// can provide it here to continue paginating through the next page of results.
	NextToken *string `min:"1" type:"string"`

	// The maximum number of traffic policy resources that are returned per call.
	// You can use NextToken to obtain further traffic policies.
	PageSize *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTrafficPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTrafficPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTrafficPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTrafficPoliciesInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListTrafficPoliciesInput) SetNextToken(v string) *ListTrafficPoliciesInput {
	s.NextToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListTrafficPoliciesInput) SetPageSize(v int64) *ListTrafficPoliciesInput {
	s.PageSize = &v
	return s
}

type ListTrafficPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// If NextToken is returned, there are more results available. The value of
	// NextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page.
	NextToken *string `min:"1" type:"string"`

	// The list of traffic policies.
	TrafficPolicies []*TrafficPolicy `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTrafficPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTrafficPoliciesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTrafficPoliciesOutput) SetNextToken(v string) *ListTrafficPoliciesOutput {
	s.NextToken = &v
	return s
}

// SetTrafficPolicies sets the TrafficPolicies field's value.
func (s *ListTrafficPoliciesOutput) SetTrafficPolicies(v []*TrafficPolicy) *ListTrafficPoliciesOutput {
	s.TrafficPolicies = v
	return s
}

// The textual body content of an email message.
type MessageBody struct {
	_ struct{} `type:"structure"`

	// The HTML body content of the message.
	Html *string `type:"string"`

	// A flag indicating if the email was malformed.
	MessageMalformed *bool `type:"boolean"`

	// The plain text body content of the message.
	Text *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MessageBody) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MessageBody) GoString() string {
	return s.String()
}

// SetHtml sets the Html field's value.
func (s *MessageBody) SetHtml(v string) *MessageBody {
	s.Html = &v
	return s
}

// SetMessageMalformed sets the MessageMalformed field's value.
func (s *MessageBody) SetMessageMalformed(v bool) *MessageBody {
	s.MessageMalformed = &v
	return s
}

// SetText sets the Text field's value.
func (s *MessageBody) SetText(v string) *MessageBody {
	s.Text = &v
	return s
}

// Explicitly indicate that the relay destination server does not require SMTP
// credential authentication.
type NoAuthentication struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoAuthentication) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoAuthentication) GoString() string {
	return s.String()
}

// The email traffic filtering conditions which are contained in a traffic policy
// resource.
type PolicyCondition struct {
	_ struct{} `type:"structure"`

	// This represents a boolean type condition matching on the incoming mail. It
	// performs the boolean operation configured in 'Operator' and evaluates the
	// 'Protocol' object against the 'Value'.
	BooleanExpression *IngressBooleanExpression `type:"structure"`

	// This represents an IP based condition matching on the incoming mail. It performs
	// the operation configured in 'Operator' and evaluates the 'Protocol' object
	// against the 'Value'.
	IpExpression *IngressIpv4Expression `type:"structure"`

	// This represents a string based condition matching on the incoming mail. It
	// performs the string operation configured in 'Operator' and evaluates the
	// 'Protocol' object against the 'Value'.
	StringExpression *IngressStringExpression `type:"structure"`

	// This represents a TLS based condition matching on the incoming mail. It performs
	// the operation configured in 'Operator' and evaluates the 'Protocol' object
	// against the 'Value'.
	TlsExpression *IngressTlsProtocolExpression `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicyCondition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicyCondition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PolicyCondition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PolicyCondition"}
	if s.BooleanExpression != nil {
		if err := s.BooleanExpression.Validate(); err != nil {
			invalidParams.AddNested("BooleanExpression", err.(request.ErrInvalidParams))
		}
	}
	if s.IpExpression != nil {
		if err := s.IpExpression.Validate(); err != nil {
			invalidParams.AddNested("IpExpression", err.(request.ErrInvalidParams))
		}
	}
	if s.StringExpression != nil {
		if err := s.StringExpression.Validate(); err != nil {
			invalidParams.AddNested("StringExpression", err.(request.ErrInvalidParams))
		}
	}
	if s.TlsExpression != nil {
		if err := s.TlsExpression.Validate(); err != nil {
			invalidParams.AddNested("TlsExpression", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBooleanExpression sets the BooleanExpression field's value.
func (s *PolicyCondition) SetBooleanExpression(v *IngressBooleanExpression) *PolicyCondition {
	s.BooleanExpression = v
	return s
}

// SetIpExpression sets the IpExpression field's value.
func (s *PolicyCondition) SetIpExpression(v *IngressIpv4Expression) *PolicyCondition {
	s.IpExpression = v
	return s
}

// SetStringExpression sets the StringExpression field's value.
func (s *PolicyCondition) SetStringExpression(v *IngressStringExpression) *PolicyCondition {
	s.StringExpression = v
	return s
}

// SetTlsExpression sets the TlsExpression field's value.
func (s *PolicyCondition) SetTlsExpression(v *IngressTlsProtocolExpression) *PolicyCondition {
	s.TlsExpression = v
	return s
}

// The structure containing traffic policy conditions and actions.
type PolicyStatement struct {
	_ struct{} `type:"structure"`

	// The action that informs a traffic policy resource to either allow or block
	// the email if it matches a condition in the policy statement.
	//
	// Action is a required field
	Action *string `type:"string" required:"true" enum:"AcceptAction"`

	// The list of conditions to apply to incoming messages for filtering email
	// traffic.
	//
	// Conditions is a required field
	Conditions []*PolicyCondition `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicyStatement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicyStatement) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PolicyStatement) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PolicyStatement"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.Conditions == nil {
		invalidParams.Add(request.NewErrParamRequired("Conditions"))
	}
	if s.Conditions != nil && len(s.Conditions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Conditions", 1))
	}
	if s.Conditions != nil {
		for i, v := range s.Conditions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Conditions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *PolicyStatement) SetAction(v string) *PolicyStatement {
	s.Action = &v
	return s
}

// SetConditions sets the Conditions field's value.
func (s *PolicyStatement) SetConditions(v []*PolicyCondition) *PolicyStatement {
	s.Conditions = v
	return s
}

// The relay resource that can be used as a rule to relay receiving emails to
// the destination relay server.
type Relay struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the relay was last modified.
	LastModifiedTimestamp *time.Time `type:"timestamp"`

	// The unique relay identifier.
	RelayId *string `min:"1" type:"string"`

	// The unique relay name.
	RelayName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Relay) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Relay) GoString() string {
	return s.String()
}

// SetLastModifiedTimestamp sets the LastModifiedTimestamp field's value.
func (s *Relay) SetLastModifiedTimestamp(v time.Time) *Relay {
	s.LastModifiedTimestamp = &v
	return s
}

// SetRelayId sets the RelayId field's value.
func (s *Relay) SetRelayId(v string) *Relay {
	s.RelayId = &v
	return s
}

// SetRelayName sets the RelayName field's value.
func (s *Relay) SetRelayName(v string) *Relay {
	s.RelayName = &v
	return s
}

// The action relays the email via SMTP to another specific SMTP server.
type RelayAction struct {
	_ struct{} `type:"structure"`

	// A policy that states what to do in the case of failure. The action will fail
	// if there are configuration errors. For example, the specified relay has been
	// deleted.
	ActionFailurePolicy *string `type:"string" enum:"ActionFailurePolicy"`

	// This action specifies whether to preserve or replace original mail from address
	// while relaying received emails to a destination server.
	MailFrom *string `type:"string" enum:"MailFrom"`

	// The identifier of the relay resource to be used when relaying an email.
	//
	// Relay is a required field
	Relay *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RelayAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RelayAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RelayAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RelayAction"}
	if s.Relay == nil {
		invalidParams.Add(request.NewErrParamRequired("Relay"))
	}
	if s.Relay != nil && len(*s.Relay) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Relay", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionFailurePolicy sets the ActionFailurePolicy field's value.
func (s *RelayAction) SetActionFailurePolicy(v string) *RelayAction {
	s.ActionFailurePolicy = &v
	return s
}

// SetMailFrom sets the MailFrom field's value.
func (s *RelayAction) SetMailFrom(v string) *RelayAction {
	s.MailFrom = &v
	return s
}

// SetRelay sets the Relay field's value.
func (s *RelayAction) SetRelay(v string) *RelayAction {
	s.Relay = &v
	return s
}

// Authentication for the relay destination server—specify the secretARN where
// the SMTP credentials are stored, or specify an empty NoAuthentication structure
// if the relay destination server does not require SMTP credential authentication.
type RelayAuthentication struct {
	_ struct{} `type:"structure"`

	// Keep an empty structure if the relay destination server does not require
	// SMTP credential authentication.
	NoAuthentication *NoAuthentication `type:"structure"`

	// The ARN of the secret created in secrets manager where the relay server's
	// SMTP credentials are stored.
	SecretArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RelayAuthentication) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RelayAuthentication) GoString() string {
	return s.String()
}

// SetNoAuthentication sets the NoAuthentication field's value.
func (s *RelayAuthentication) SetNoAuthentication(v *NoAuthentication) *RelayAuthentication {
	s.NoAuthentication = v
	return s
}

// SetSecretArn sets the SecretArn field's value.
func (s *RelayAuthentication) SetSecretArn(v string) *RelayAuthentication {
	s.SecretArn = &v
	return s
}

// This action replaces the email envelope recipients with the given list of
// recipients. If the condition of this action applies only to a subset of recipients,
// only those recipients are replaced with the recipients specified in the action.
// The message contents and headers are unaffected by this action, only the
// envelope recipients are updated.
type ReplaceRecipientAction struct {
	_ struct{} `type:"structure"`

	// This action specifies the replacement recipient email addresses to insert.
	ReplaceWith []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReplaceRecipientAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReplaceRecipientAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReplaceRecipientAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReplaceRecipientAction"}
	if s.ReplaceWith != nil && len(s.ReplaceWith) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReplaceWith", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReplaceWith sets the ReplaceWith field's value.
func (s *ReplaceRecipientAction) SetReplaceWith(v []*string) *ReplaceRecipientAction {
	s.ReplaceWith = v
	return s
}

// Occurs when a requested resource is not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A result row containing metadata for an archived email message.
type Row struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the archived message.
	ArchivedMessageId *string `type:"string"`

	// The email addresses in the CC header.
	Cc *string `type:"string"`

	// The date the email was sent.
	Date *string `type:"string"`

	// The email address of the sender.
	From *string `type:"string"`

	// A flag indicating if the email has attachments.
	HasAttachments *bool `type:"boolean"`

	// The email message ID this is a reply to.
	InReplyTo *string `type:"string"`

	// The unique message ID of the email.
	MessageId *string `type:"string"`

	// The received headers from the email delivery path.
	ReceivedHeaders []*string `type:"list"`

	// The timestamp of when the email was received.
	ReceivedTimestamp *time.Time `type:"timestamp"`

	// The subject header value of the email.
	Subject *string `type:"string"`

	// The email addresses in the To header.
	To *string `type:"string"`

	// The user agent that sent the email.
	XMailer *string `type:"string"`

	// The original user agent that sent the email.
	XOriginalMailer *string `type:"string"`

	// The priority level of the email.
	XPriority *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Row) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Row) GoString() string {
	return s.String()
}

// SetArchivedMessageId sets the ArchivedMessageId field's value.
func (s *Row) SetArchivedMessageId(v string) *Row {
	s.ArchivedMessageId = &v
	return s
}

// SetCc sets the Cc field's value.
func (s *Row) SetCc(v string) *Row {
	s.Cc = &v
	return s
}

// SetDate sets the Date field's value.
func (s *Row) SetDate(v string) *Row {
	s.Date = &v
	return s
}

// SetFrom sets the From field's value.
func (s *Row) SetFrom(v string) *Row {
	s.From = &v
	return s
}

// SetHasAttachments sets the HasAttachments field's value.
func (s *Row) SetHasAttachments(v bool) *Row {
	s.HasAttachments = &v
	return s
}

// SetInReplyTo sets the InReplyTo field's value.
func (s *Row) SetInReplyTo(v string) *Row {
	s.InReplyTo = &v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *Row) SetMessageId(v string) *Row {
	s.MessageId = &v
	return s
}

// SetReceivedHeaders sets the ReceivedHeaders field's value.
func (s *Row) SetReceivedHeaders(v []*string) *Row {
	s.ReceivedHeaders = v
	return s
}

// SetReceivedTimestamp sets the ReceivedTimestamp field's value.
func (s *Row) SetReceivedTimestamp(v time.Time) *Row {
	s.ReceivedTimestamp = &v
	return s
}

// SetSubject sets the Subject field's value.
func (s *Row) SetSubject(v string) *Row {
	s.Subject = &v
	return s
}

// SetTo sets the To field's value.
func (s *Row) SetTo(v string) *Row {
	s.To = &v
	return s
}

// SetXMailer sets the XMailer field's value.
func (s *Row) SetXMailer(v string) *Row {
	s.XMailer = &v
	return s
}

// SetXOriginalMailer sets the XOriginalMailer field's value.
func (s *Row) SetXOriginalMailer(v string) *Row {
	s.XOriginalMailer = &v
	return s
}

// SetXPriority sets the XPriority field's value.
func (s *Row) SetXPriority(v string) *Row {
	s.XPriority = &v
	return s
}

// A rule contains conditions, "unless conditions" and actions. For each envelope
// recipient of an email, if all conditions match and none of the "unless conditions"
// match, then all of the actions are executed sequentially. If no conditions
// are provided, the rule always applies and the actions are implicitly executed.
// If only "unless conditions" are provided, the rule applies if the email does
// not match the evaluation of the "unless conditions".
type Rule struct {
	_ struct{} `type:"structure"`

	// The list of actions to execute when the conditions match the incoming email,
	// and none of the "unless conditions" match.
	//
	// Actions is a required field
	Actions []*RuleAction `min:"1" type:"list" required:"true"`

	// The conditions of this rule. All conditions must match the email for the
	// actions to be executed. An empty list of conditions means that all emails
	// match, but are still subject to any "unless conditions"
	Conditions []*RuleCondition `type:"list"`

	// The user-friendly name of the rule.
	Name *string `min:"1" type:"string"`

	// The "unless conditions" of this rule. None of the conditions can match the
	// email for the actions to be executed. If any of these conditions do match
	// the email, then the actions are not executed.
	Unless []*RuleCondition `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Rule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Rule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Rule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Rule"}
	if s.Actions == nil {
		invalidParams.Add(request.NewErrParamRequired("Actions"))
	}
	if s.Actions != nil && len(s.Actions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Actions", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Actions != nil {
		for i, v := range s.Actions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Actions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Conditions != nil {
		for i, v := range s.Conditions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Conditions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Unless != nil {
		for i, v := range s.Unless {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Unless", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActions sets the Actions field's value.
func (s *Rule) SetActions(v []*RuleAction) *Rule {
	s.Actions = v
	return s
}

// SetConditions sets the Conditions field's value.
func (s *Rule) SetConditions(v []*RuleCondition) *Rule {
	s.Conditions = v
	return s
}

// SetName sets the Name field's value.
func (s *Rule) SetName(v string) *Rule {
	s.Name = &v
	return s
}

// SetUnless sets the Unless field's value.
func (s *Rule) SetUnless(v []*RuleCondition) *Rule {
	s.Unless = v
	return s
}

// The action for a rule to take. Only one of the contained actions can be set.
type RuleAction struct {
	_ struct{} `type:"structure"`

	// This action adds a header. This can be used to add arbitrary email headers.
	AddHeader *AddHeaderAction `type:"structure"`

	// This action archives the email. This can be used to deliver an email to an
	// archive.
	Archive *ArchiveAction `type:"structure"`

	// This action delivers an email to a WorkMail mailbox.
	DeliverToMailbox *DeliverToMailboxAction `type:"structure"`

	// This action terminates the evaluation of rules in the rule set.
	Drop *DropAction `type:"structure"`

	// This action relays the email to another SMTP server.
	Relay *RelayAction `type:"structure"`

	// The action replaces certain or all recipients with a different set of recipients.
	ReplaceRecipient *ReplaceRecipientAction `type:"structure"`

	// This action sends the email to the internet.
	Send *SendAction `type:"structure"`

	// This action writes the MIME content of the email to an S3 bucket.
	WriteToS3 *S3Action `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RuleAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RuleAction"}
	if s.AddHeader != nil {
		if err := s.AddHeader.Validate(); err != nil {
			invalidParams.AddNested("AddHeader", err.(request.ErrInvalidParams))
		}
	}
	if s.Archive != nil {
		if err := s.Archive.Validate(); err != nil {
			invalidParams.AddNested("Archive", err.(request.ErrInvalidParams))
		}
	}
	if s.DeliverToMailbox != nil {
		if err := s.DeliverToMailbox.Validate(); err != nil {
			invalidParams.AddNested("DeliverToMailbox", err.(request.ErrInvalidParams))
		}
	}
	if s.Relay != nil {
		if err := s.Relay.Validate(); err != nil {
			invalidParams.AddNested("Relay", err.(request.ErrInvalidParams))
		}
	}
	if s.ReplaceRecipient != nil {
		if err := s.ReplaceRecipient.Validate(); err != nil {
			invalidParams.AddNested("ReplaceRecipient", err.(request.ErrInvalidParams))
		}
	}
	if s.Send != nil {
		if err := s.Send.Validate(); err != nil {
			invalidParams.AddNested("Send", err.(request.ErrInvalidParams))
		}
	}
	if s.WriteToS3 != nil {
		if err := s.WriteToS3.Validate(); err != nil {
			invalidParams.AddNested("WriteToS3", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddHeader sets the AddHeader field's value.
func (s *RuleAction) SetAddHeader(v *AddHeaderAction) *RuleAction {
	s.AddHeader = v
	return s
}

// SetArchive sets the Archive field's value.
func (s *RuleAction) SetArchive(v *ArchiveAction) *RuleAction {
	s.Archive = v
	return s
}

// SetDeliverToMailbox sets the DeliverToMailbox field's value.
func (s *RuleAction) SetDeliverToMailbox(v *DeliverToMailboxAction) *RuleAction {
	s.DeliverToMailbox = v
	return s
}

// SetDrop sets the Drop field's value.
func (s *RuleAction) SetDrop(v *DropAction) *RuleAction {
	s.Drop = v
	return s
}

// SetRelay sets the Relay field's value.
func (s *RuleAction) SetRelay(v *RelayAction) *RuleAction {
	s.Relay = v
	return s
}

// SetReplaceRecipient sets the ReplaceRecipient field's value.
func (s *RuleAction) SetReplaceRecipient(v *ReplaceRecipientAction) *RuleAction {
	s.ReplaceRecipient = v
	return s
}

// SetSend sets the Send field's value.
func (s *RuleAction) SetSend(v *SendAction) *RuleAction {
	s.Send = v
	return s
}

// SetWriteToS3 sets the WriteToS3 field's value.
func (s *RuleAction) SetWriteToS3(v *S3Action) *RuleAction {
	s.WriteToS3 = v
	return s
}

// A boolean expression to be used in a rule condition.
type RuleBooleanExpression struct {
	_ struct{} `type:"structure"`

	// The operand on which to perform a boolean condition operation.
	//
	// Evaluate is a required field
	Evaluate *RuleBooleanToEvaluate `type:"structure" required:"true"`

	// The matching operator for a boolean condition expression.
	//
	// Operator is a required field
	Operator *string `type:"string" required:"true" enum:"RuleBooleanOperator"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleBooleanExpression) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleBooleanExpression) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RuleBooleanExpression) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RuleBooleanExpression"}
	if s.Evaluate == nil {
		invalidParams.Add(request.NewErrParamRequired("Evaluate"))
	}
	if s.Operator == nil {
		invalidParams.Add(request.NewErrParamRequired("Operator"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEvaluate sets the Evaluate field's value.
func (s *RuleBooleanExpression) SetEvaluate(v *RuleBooleanToEvaluate) *RuleBooleanExpression {
	s.Evaluate = v
	return s
}

// SetOperator sets the Operator field's value.
func (s *RuleBooleanExpression) SetOperator(v string) *RuleBooleanExpression {
	s.Operator = &v
	return s
}

// The union type representing the allowed types of operands for a boolean condition.
type RuleBooleanToEvaluate struct {
	_ struct{} `type:"structure"`

	// The boolean type representing the allowed attribute types for an email.
	Attribute *string `type:"string" enum:"RuleBooleanEmailAttribute"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleBooleanToEvaluate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleBooleanToEvaluate) GoString() string {
	return s.String()
}

// SetAttribute sets the Attribute field's value.
func (s *RuleBooleanToEvaluate) SetAttribute(v string) *RuleBooleanToEvaluate {
	s.Attribute = &v
	return s
}

// The conditional expression used to evaluate an email for determining if a
// rule action should be taken.
type RuleCondition struct {
	_ struct{} `type:"structure"`

	// The condition applies to a boolean expression passed in this field.
	BooleanExpression *RuleBooleanExpression `type:"structure"`

	// The condition applies to a DMARC policy expression passed in this field.
	DmarcExpression *RuleDmarcExpression `type:"structure"`

	// The condition applies to an IP address expression passed in this field.
	IpExpression *RuleIpExpression `type:"structure"`

	// The condition applies to a number expression passed in this field.
	NumberExpression *RuleNumberExpression `type:"structure"`

	// The condition applies to a string expression passed in this field.
	StringExpression *RuleStringExpression `type:"structure"`

	// The condition applies to a verdict expression passed in this field.
	VerdictExpression *RuleVerdictExpression `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleCondition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleCondition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RuleCondition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RuleCondition"}
	if s.BooleanExpression != nil {
		if err := s.BooleanExpression.Validate(); err != nil {
			invalidParams.AddNested("BooleanExpression", err.(request.ErrInvalidParams))
		}
	}
	if s.DmarcExpression != nil {
		if err := s.DmarcExpression.Validate(); err != nil {
			invalidParams.AddNested("DmarcExpression", err.(request.ErrInvalidParams))
		}
	}
	if s.IpExpression != nil {
		if err := s.IpExpression.Validate(); err != nil {
			invalidParams.AddNested("IpExpression", err.(request.ErrInvalidParams))
		}
	}
	if s.NumberExpression != nil {
		if err := s.NumberExpression.Validate(); err != nil {
			invalidParams.AddNested("NumberExpression", err.(request.ErrInvalidParams))
		}
	}
	if s.StringExpression != nil {
		if err := s.StringExpression.Validate(); err != nil {
			invalidParams.AddNested("StringExpression", err.(request.ErrInvalidParams))
		}
	}
	if s.VerdictExpression != nil {
		if err := s.VerdictExpression.Validate(); err != nil {
			invalidParams.AddNested("VerdictExpression", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBooleanExpression sets the BooleanExpression field's value.
func (s *RuleCondition) SetBooleanExpression(v *RuleBooleanExpression) *RuleCondition {
	s.BooleanExpression = v
	return s
}

// SetDmarcExpression sets the DmarcExpression field's value.
func (s *RuleCondition) SetDmarcExpression(v *RuleDmarcExpression) *RuleCondition {
	s.DmarcExpression = v
	return s
}

// SetIpExpression sets the IpExpression field's value.
func (s *RuleCondition) SetIpExpression(v *RuleIpExpression) *RuleCondition {
	s.IpExpression = v
	return s
}

// SetNumberExpression sets the NumberExpression field's value.
func (s *RuleCondition) SetNumberExpression(v *RuleNumberExpression) *RuleCondition {
	s.NumberExpression = v
	return s
}

// SetStringExpression sets the StringExpression field's value.
func (s *RuleCondition) SetStringExpression(v *RuleStringExpression) *RuleCondition {
	s.StringExpression = v
	return s
}

// SetVerdictExpression sets the VerdictExpression field's value.
func (s *RuleCondition) SetVerdictExpression(v *RuleVerdictExpression) *RuleCondition {
	s.VerdictExpression = v
	return s
}

// A DMARC policy expression. The condition matches if the given DMARC policy
// matches that of the incoming email.
type RuleDmarcExpression struct {
	_ struct{} `type:"structure"`

	// The operator to apply to the DMARC policy of the incoming email.
	//
	// Operator is a required field
	Operator *string `type:"string" required:"true" enum:"RuleDmarcOperator"`

	// The values to use for the given DMARC policy operator. For the operator EQUALS,
	// if multiple values are given, they are evaluated as an OR. That is, if any
	// of the given values match, the condition is deemed to match. For the operator
	// NOT_EQUALS, if multiple values are given, they are evaluated as an AND. That
	// is, only if the email's DMARC policy is not equal to any of the given values,
	// then the condition is deemed to match.
	//
	// Values is a required field
	Values []*string `min:"1" type:"list" required:"true" enum:"RuleDmarcPolicy"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleDmarcExpression) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleDmarcExpression) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RuleDmarcExpression) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RuleDmarcExpression"}
	if s.Operator == nil {
		invalidParams.Add(request.NewErrParamRequired("Operator"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOperator sets the Operator field's value.
func (s *RuleDmarcExpression) SetOperator(v string) *RuleDmarcExpression {
	s.Operator = &v
	return s
}

// SetValues sets the Values field's value.
func (s *RuleDmarcExpression) SetValues(v []*string) *RuleDmarcExpression {
	s.Values = v
	return s
}

// An IP address expression matching certain IP addresses within a given range
// of IP addresses.
type RuleIpExpression struct {
	_ struct{} `type:"structure"`

	// The IP address to evaluate in this condition.
	//
	// Evaluate is a required field
	Evaluate *RuleIpToEvaluate `type:"structure" required:"true"`

	// The operator to evaluate the IP address.
	//
	// Operator is a required field
	Operator *string `type:"string" required:"true" enum:"RuleIpOperator"`

	// The IP CIDR blocks in format "x.y.z.w/n" (eg 10.0.0.0/8) to match with the
	// email's IP address. For the operator CIDR_MATCHES, if multiple values are
	// given, they are evaluated as an OR. That is, if the IP address is contained
	// within any of the given CIDR ranges, the condition is deemed to match. For
	// NOT_CIDR_MATCHES, if multiple CIDR ranges are given, the condition is deemed
	// to match if the IP address is not contained in any of the given CIDR ranges.
	//
	// Values is a required field
	Values []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleIpExpression) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleIpExpression) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RuleIpExpression) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RuleIpExpression"}
	if s.Evaluate == nil {
		invalidParams.Add(request.NewErrParamRequired("Evaluate"))
	}
	if s.Operator == nil {
		invalidParams.Add(request.NewErrParamRequired("Operator"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEvaluate sets the Evaluate field's value.
func (s *RuleIpExpression) SetEvaluate(v *RuleIpToEvaluate) *RuleIpExpression {
	s.Evaluate = v
	return s
}

// SetOperator sets the Operator field's value.
func (s *RuleIpExpression) SetOperator(v string) *RuleIpExpression {
	s.Operator = &v
	return s
}

// SetValues sets the Values field's value.
func (s *RuleIpExpression) SetValues(v []*string) *RuleIpExpression {
	s.Values = v
	return s
}

// The IP address to evaluate for this condition.
type RuleIpToEvaluate struct {
	_ struct{} `type:"structure"`

	// The attribute of the email to evaluate.
	Attribute *string `type:"string" enum:"RuleIpEmailAttribute"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleIpToEvaluate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleIpToEvaluate) GoString() string {
	return s.String()
}

// SetAttribute sets the Attribute field's value.
func (s *RuleIpToEvaluate) SetAttribute(v string) *RuleIpToEvaluate {
	s.Attribute = &v
	return s
}

// A number expression to match numeric conditions with integers from the incoming
// email.
type RuleNumberExpression struct {
	_ struct{} `type:"structure"`

	// The number to evaluate in a numeric condition expression.
	//
	// Evaluate is a required field
	Evaluate *RuleNumberToEvaluate `type:"structure" required:"true"`

	// The operator for a numeric condition expression.
	//
	// Operator is a required field
	Operator *string `type:"string" required:"true" enum:"RuleNumberOperator"`

	// The value to evaluate in a numeric condition expression.
	//
	// Value is a required field
	Value *float64 `type:"double" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleNumberExpression) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleNumberExpression) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RuleNumberExpression) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RuleNumberExpression"}
	if s.Evaluate == nil {
		invalidParams.Add(request.NewErrParamRequired("Evaluate"))
	}
	if s.Operator == nil {
		invalidParams.Add(request.NewErrParamRequired("Operator"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEvaluate sets the Evaluate field's value.
func (s *RuleNumberExpression) SetEvaluate(v *RuleNumberToEvaluate) *RuleNumberExpression {
	s.Evaluate = v
	return s
}

// SetOperator sets the Operator field's value.
func (s *RuleNumberExpression) SetOperator(v string) *RuleNumberExpression {
	s.Operator = &v
	return s
}

// SetValue sets the Value field's value.
func (s *RuleNumberExpression) SetValue(v float64) *RuleNumberExpression {
	s.Value = &v
	return s
}

// The number to evaluate in a numeric condition expression.
type RuleNumberToEvaluate struct {
	_ struct{} `type:"structure"`

	// An email attribute that is used as the number to evaluate.
	Attribute *string `type:"string" enum:"RuleNumberEmailAttribute"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleNumberToEvaluate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleNumberToEvaluate) GoString() string {
	return s.String()
}

// SetAttribute sets the Attribute field's value.
func (s *RuleNumberToEvaluate) SetAttribute(v string) *RuleNumberToEvaluate {
	s.Attribute = &v
	return s
}

// A rule set contains a list of rules that are evaluated in order. Each rule
// is evaluated sequentially for each email.
type RuleSet struct {
	_ struct{} `type:"structure"`

	// The last modification date of the rule set.
	LastModificationDate *time.Time `type:"timestamp"`

	// The identifier of the rule set.
	RuleSetId *string `min:"1" type:"string"`

	// A user-friendly name for the rule set.
	RuleSetName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleSet) GoString() string {
	return s.String()
}

// SetLastModificationDate sets the LastModificationDate field's value.
func (s *RuleSet) SetLastModificationDate(v time.Time) *RuleSet {
	s.LastModificationDate = &v
	return s
}

// SetRuleSetId sets the RuleSetId field's value.
func (s *RuleSet) SetRuleSetId(v string) *RuleSet {
	s.RuleSetId = &v
	return s
}

// SetRuleSetName sets the RuleSetName field's value.
func (s *RuleSet) SetRuleSetName(v string) *RuleSet {
	s.RuleSetName = &v
	return s
}

// A string expression is evaluated against strings or substrings of the email.
type RuleStringExpression struct {
	_ struct{} `type:"structure"`

	// The string to evaluate in a string condition expression.
	//
	// Evaluate is a required field
	Evaluate *RuleStringToEvaluate `type:"structure" required:"true"`

	// The matching operator for a string condition expression.
	//
	// Operator is a required field
	Operator *string `type:"string" required:"true" enum:"RuleStringOperator"`

	// The string(s) to be evaluated in a string condition expression. For all operators,
	// except for NOT_EQUALS, if multiple values are given, the values are processed
	// as an OR. That is, if any of the values match the email's string using the
	// given operator, the condition is deemed to match. However, for NOT_EQUALS,
	// the condition is only deemed to match if none of the given strings match
	// the email's string.
	//
	// Values is a required field
	Values []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleStringExpression) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleStringExpression) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RuleStringExpression) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RuleStringExpression"}
	if s.Evaluate == nil {
		invalidParams.Add(request.NewErrParamRequired("Evaluate"))
	}
	if s.Operator == nil {
		invalidParams.Add(request.NewErrParamRequired("Operator"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEvaluate sets the Evaluate field's value.
func (s *RuleStringExpression) SetEvaluate(v *RuleStringToEvaluate) *RuleStringExpression {
	s.Evaluate = v
	return s
}

// SetOperator sets the Operator field's value.
func (s *RuleStringExpression) SetOperator(v string) *RuleStringExpression {
	s.Operator = &v
	return s
}

// SetValues sets the Values field's value.
func (s *RuleStringExpression) SetValues(v []*string) *RuleStringExpression {
	s.Values = v
	return s
}

// The string to evaluate in a string condition expression.
type RuleStringToEvaluate struct {
	_ struct{} `type:"structure"`

	// The email attribute to evaluate in a string condition expression.
	Attribute *string `type:"string" enum:"RuleStringEmailAttribute"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleStringToEvaluate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleStringToEvaluate) GoString() string {
	return s.String()
}

// SetAttribute sets the Attribute field's value.
func (s *RuleStringToEvaluate) SetAttribute(v string) *RuleStringToEvaluate {
	s.Attribute = &v
	return s
}

// A verdict expression is evaluated against verdicts of the email.
type RuleVerdictExpression struct {
	_ struct{} `type:"structure"`

	// The verdict to evaluate in a verdict condition expression.
	//
	// Evaluate is a required field
	Evaluate *RuleVerdictToEvaluate `type:"structure" required:"true"`

	// The matching operator for a verdict condition expression.
	//
	// Operator is a required field
	Operator *string `type:"string" required:"true" enum:"RuleVerdictOperator"`

	// The values to match with the email's verdict using the given operator. For
	// the EQUALS operator, if multiple values are given, the condition is deemed
	// to match if any of the given verdicts match that of the email. For the NOT_EQUALS
	// operator, if multiple values are given, the condition is deemed to match
	// of none of the given verdicts match the verdict of the email.
	//
	// Values is a required field
	Values []*string `min:"1" type:"list" required:"true" enum:"RuleVerdict"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleVerdictExpression) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleVerdictExpression) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RuleVerdictExpression) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RuleVerdictExpression"}
	if s.Evaluate == nil {
		invalidParams.Add(request.NewErrParamRequired("Evaluate"))
	}
	if s.Operator == nil {
		invalidParams.Add(request.NewErrParamRequired("Operator"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}
	if s.Evaluate != nil {
		if err := s.Evaluate.Validate(); err != nil {
			invalidParams.AddNested("Evaluate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEvaluate sets the Evaluate field's value.
func (s *RuleVerdictExpression) SetEvaluate(v *RuleVerdictToEvaluate) *RuleVerdictExpression {
	s.Evaluate = v
	return s
}

// SetOperator sets the Operator field's value.
func (s *RuleVerdictExpression) SetOperator(v string) *RuleVerdictExpression {
	s.Operator = &v
	return s
}

// SetValues sets the Values field's value.
func (s *RuleVerdictExpression) SetValues(v []*string) *RuleVerdictExpression {
	s.Values = v
	return s
}

// The verdict to evaluate in a verdict condition expression.
type RuleVerdictToEvaluate struct {
	_ struct{} `type:"structure"`

	// The Add On ARN and its returned value to evaluate in a verdict condition
	// expression.
	Analysis *Analysis `type:"structure"`

	// The email verdict attribute to evaluate in a string verdict expression.
	Attribute *string `type:"string" enum:"RuleVerdictAttribute"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleVerdictToEvaluate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleVerdictToEvaluate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RuleVerdictToEvaluate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RuleVerdictToEvaluate"}
	if s.Analysis != nil {
		if err := s.Analysis.Validate(); err != nil {
			invalidParams.AddNested("Analysis", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalysis sets the Analysis field's value.
func (s *RuleVerdictToEvaluate) SetAnalysis(v *Analysis) *RuleVerdictToEvaluate {
	s.Analysis = v
	return s
}

// SetAttribute sets the Attribute field's value.
func (s *RuleVerdictToEvaluate) SetAttribute(v string) *RuleVerdictToEvaluate {
	s.Attribute = &v
	return s
}

// Writes the MIME content of the email to an S3 bucket.
type S3Action struct {
	_ struct{} `type:"structure"`

	// A policy that states what to do in the case of failure. The action will fail
	// if there are configuration errors. For example, the specified the bucket
	// has been deleted.
	ActionFailurePolicy *string `type:"string" enum:"ActionFailurePolicy"`

	// The Amazon Resource Name (ARN) of the IAM Role to use while writing to S3.
	// This role must have access to the s3:PutObject, kms:Encrypt, and kms:GenerateDataKey
	// APIs for the given bucket.
	//
	// RoleArn is a required field
	RoleArn *string `min:"20" type:"string" required:"true"`

	// The bucket name of the S3 bucket to write to.
	//
	// S3Bucket is a required field
	S3Bucket *string `min:"1" type:"string" required:"true"`

	// The S3 prefix to use for the write to the s3 bucket.
	S3Prefix *string `min:"1" type:"string"`

	// The KMS Key ID to use to encrypt the message in S3.
	S3SseKmsKeyId *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Action) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Action) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Action) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Action"}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.S3Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Bucket"))
	}
	if s.S3Bucket != nil && len(*s.S3Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3Bucket", 1))
	}
	if s.S3Prefix != nil && len(*s.S3Prefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3Prefix", 1))
	}
	if s.S3SseKmsKeyId != nil && len(*s.S3SseKmsKeyId) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("S3SseKmsKeyId", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionFailurePolicy sets the ActionFailurePolicy field's value.
func (s *S3Action) SetActionFailurePolicy(v string) *S3Action {
	s.ActionFailurePolicy = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *S3Action) SetRoleArn(v string) *S3Action {
	s.RoleArn = &v
	return s
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *S3Action) SetS3Bucket(v string) *S3Action {
	s.S3Bucket = &v
	return s
}

// SetS3Prefix sets the S3Prefix field's value.
func (s *S3Action) SetS3Prefix(v string) *S3Action {
	s.S3Prefix = &v
	return s
}

// SetS3SseKmsKeyId sets the S3SseKmsKeyId field's value.
func (s *S3Action) SetS3SseKmsKeyId(v string) *S3Action {
	s.S3SseKmsKeyId = &v
	return s
}

// The configuration for exporting email data to an Amazon S3 bucket.
type S3ExportDestinationConfiguration struct {
	_ struct{} `type:"structure"`

	// The S3 location to deliver the exported email data.
	S3Location *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3ExportDestinationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3ExportDestinationConfiguration) GoString() string {
	return s.String()
}

// SetS3Location sets the S3Location field's value.
func (s *S3ExportDestinationConfiguration) SetS3Location(v string) *S3ExportDestinationConfiguration {
	s.S3Location = &v
	return s
}

// The current status of an archive search job.
type SearchStatus struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the search completed (if finished).
	CompletionTimestamp *time.Time `type:"timestamp"`

	// An error message if the search failed.
	ErrorMessage *string `type:"string"`

	// The current state of the search job.
	State *string `type:"string" enum:"SearchState"`

	// The timestamp of when the search was submitted.
	SubmissionTimestamp *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchStatus) GoString() string {
	return s.String()
}

// SetCompletionTimestamp sets the CompletionTimestamp field's value.
func (s *SearchStatus) SetCompletionTimestamp(v time.Time) *SearchStatus {
	s.CompletionTimestamp = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *SearchStatus) SetErrorMessage(v string) *SearchStatus {
	s.ErrorMessage = &v
	return s
}

// SetState sets the State field's value.
func (s *SearchStatus) SetState(v string) *SearchStatus {
	s.State = &v
	return s
}

// SetSubmissionTimestamp sets the SubmissionTimestamp field's value.
func (s *SearchStatus) SetSubmissionTimestamp(v time.Time) *SearchStatus {
	s.SubmissionTimestamp = &v
	return s
}

// Summary details of an archive search job.
type SearchSummary struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the search job.
	SearchId *string `min:"1" type:"string"`

	// The current status of the search job.
	Status *SearchStatus `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchSummary) GoString() string {
	return s.String()
}

// SetSearchId sets the SearchId field's value.
func (s *SearchSummary) SetSearchId(v string) *SearchSummary {
	s.SearchId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *SearchSummary) SetStatus(v *SearchStatus) *SearchSummary {
	s.Status = v
	return s
}

// Sends the email to the internet using the ses:SendRawEmail API.
type SendAction struct {
	_ struct{} `type:"structure"`

	// A policy that states what to do in the case of failure. The action will fail
	// if there are configuration errors. For example, the caller does not have
	// the permissions to call the sendRawEmail API.
	ActionFailurePolicy *string `type:"string" enum:"ActionFailurePolicy"`

	// The Amazon Resource Name (ARN) of the role to use for this action. This role
	// must have access to the ses:SendRawEmail API.
	//
	// RoleArn is a required field
	RoleArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendAction"}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionFailurePolicy sets the ActionFailurePolicy field's value.
func (s *SendAction) SetActionFailurePolicy(v string) *SendAction {
	s.ActionFailurePolicy = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *SendAction) SetRoleArn(v string) *SendAction {
	s.RoleArn = &v
	return s
}

// Occurs when an operation exceeds a predefined service quota or limit.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request to initiate an export of emails from an archive.
type StartArchiveExportInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the archive to export emails from.
	//
	// ArchiveId is a required field
	ArchiveId *string `min:"3" type:"string" required:"true"`

	// Details on where to deliver the exported email data.
	//
	// ExportDestinationConfiguration is a required field
	ExportDestinationConfiguration *ExportDestinationConfiguration `type:"structure" required:"true"`

	// Criteria to filter which emails are included in the export.
	Filters *ArchiveFilters `type:"structure"`

	// The start of the timestamp range to include emails from.
	//
	// FromTimestamp is a required field
	FromTimestamp *time.Time `type:"timestamp" required:"true"`

	// The maximum number of email items to include in the export.
	MaxResults *int64 `type:"integer"`

	// The end of the timestamp range to include emails from.
	//
	// ToTimestamp is a required field
	ToTimestamp *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartArchiveExportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartArchiveExportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartArchiveExportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartArchiveExportInput"}
	if s.ArchiveId == nil {
		invalidParams.Add(request.NewErrParamRequired("ArchiveId"))
	}
	if s.ArchiveId != nil && len(*s.ArchiveId) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ArchiveId", 3))
	}
	if s.ExportDestinationConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("ExportDestinationConfiguration"))
	}
	if s.FromTimestamp == nil {
		invalidParams.Add(request.NewErrParamRequired("FromTimestamp"))
	}
	if s.ToTimestamp == nil {
		invalidParams.Add(request.NewErrParamRequired("ToTimestamp"))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArchiveId sets the ArchiveId field's value.
func (s *StartArchiveExportInput) SetArchiveId(v string) *StartArchiveExportInput {
	s.ArchiveId = &v
	return s
}

// SetExportDestinationConfiguration sets the ExportDestinationConfiguration field's value.
func (s *StartArchiveExportInput) SetExportDestinationConfiguration(v *ExportDestinationConfiguration) *StartArchiveExportInput {
	s.ExportDestinationConfiguration = v
	return s
}

// SetFilters sets the Filters field's value.
func (s *StartArchiveExportInput) SetFilters(v *ArchiveFilters) *StartArchiveExportInput {
	s.Filters = v
	return s
}

// SetFromTimestamp sets the FromTimestamp field's value.
func (s *StartArchiveExportInput) SetFromTimestamp(v time.Time) *StartArchiveExportInput {
	s.FromTimestamp = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *StartArchiveExportInput) SetMaxResults(v int64) *StartArchiveExportInput {
	s.MaxResults = &v
	return s
}

// SetToTimestamp sets the ToTimestamp field's value.
func (s *StartArchiveExportInput) SetToTimestamp(v time.Time) *StartArchiveExportInput {
	s.ToTimestamp = &v
	return s
}

// The response from initiating an archive export.
type StartArchiveExportOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the initiated export job.
	ExportId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartArchiveExportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartArchiveExportOutput) GoString() string {
	return s.String()
}

// SetExportId sets the ExportId field's value.
func (s *StartArchiveExportOutput) SetExportId(v string) *StartArchiveExportOutput {
	s.ExportId = &v
	return s
}

// The request to initiate a search across emails in an archive.
type StartArchiveSearchInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the archive to search emails in.
	//
	// ArchiveId is a required field
	ArchiveId *string `min:"3" type:"string" required:"true"`

	// Criteria to filter which emails are included in the search results.
	Filters *ArchiveFilters `type:"structure"`

	// The start timestamp of the range to search emails from.
	//
	// FromTimestamp is a required field
	FromTimestamp *time.Time `type:"timestamp" required:"true"`

	// The maximum number of search results to return.
	//
	// MaxResults is a required field
	MaxResults *int64 `type:"integer" required:"true"`

	// The end timestamp of the range to search emails from.
	//
	// ToTimestamp is a required field
	ToTimestamp *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartArchiveSearchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartArchiveSearchInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartArchiveSearchInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartArchiveSearchInput"}
	if s.ArchiveId == nil {
		invalidParams.Add(request.NewErrParamRequired("ArchiveId"))
	}
	if s.ArchiveId != nil && len(*s.ArchiveId) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ArchiveId", 3))
	}
	if s.FromTimestamp == nil {
		invalidParams.Add(request.NewErrParamRequired("FromTimestamp"))
	}
	if s.MaxResults == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxResults"))
	}
	if s.ToTimestamp == nil {
		invalidParams.Add(request.NewErrParamRequired("ToTimestamp"))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArchiveId sets the ArchiveId field's value.
func (s *StartArchiveSearchInput) SetArchiveId(v string) *StartArchiveSearchInput {
	s.ArchiveId = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *StartArchiveSearchInput) SetFilters(v *ArchiveFilters) *StartArchiveSearchInput {
	s.Filters = v
	return s
}

// SetFromTimestamp sets the FromTimestamp field's value.
func (s *StartArchiveSearchInput) SetFromTimestamp(v time.Time) *StartArchiveSearchInput {
	s.FromTimestamp = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *StartArchiveSearchInput) SetMaxResults(v int64) *StartArchiveSearchInput {
	s.MaxResults = &v
	return s
}

// SetToTimestamp sets the ToTimestamp field's value.
func (s *StartArchiveSearchInput) SetToTimestamp(v time.Time) *StartArchiveSearchInput {
	s.ToTimestamp = &v
	return s
}

// The response from initiating an archive search.
type StartArchiveSearchOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the initiated search job.
	SearchId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartArchiveSearchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartArchiveSearchOutput) GoString() string {
	return s.String()
}

// SetSearchId sets the SearchId field's value.
func (s *StartArchiveSearchOutput) SetSearchId(v string) *StartArchiveSearchOutput {
	s.SearchId = &v
	return s
}

// The request to stop an in-progress archive export job.
type StopArchiveExportInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the export job to stop.
	//
	// ExportId is a required field
	ExportId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopArchiveExportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopArchiveExportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopArchiveExportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopArchiveExportInput"}
	if s.ExportId == nil {
		invalidParams.Add(request.NewErrParamRequired("ExportId"))
	}
	if s.ExportId != nil && len(*s.ExportId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExportId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExportId sets the ExportId field's value.
func (s *StopArchiveExportInput) SetExportId(v string) *StopArchiveExportInput {
	s.ExportId = &v
	return s
}

// The response indicating if the request to stop the export job succeeded.
//
// On success, returns an HTTP 200 status code. On failure, returns an error
// message.
type StopArchiveExportOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopArchiveExportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopArchiveExportOutput) GoString() string {
	return s.String()
}

// The request to stop an in-progress archive search job.
type StopArchiveSearchInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the search job to stop.
	//
	// SearchId is a required field
	SearchId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopArchiveSearchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopArchiveSearchInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopArchiveSearchInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopArchiveSearchInput"}
	if s.SearchId == nil {
		invalidParams.Add(request.NewErrParamRequired("SearchId"))
	}
	if s.SearchId != nil && len(*s.SearchId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SearchId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSearchId sets the SearchId field's value.
func (s *StopArchiveSearchInput) SetSearchId(v string) *StopArchiveSearchInput {
	s.SearchId = &v
	return s
}

// The response indicating if the request to stop the search job succeeded.
//
// On success, returns an HTTP 200 status code. On failure, returns an error
// message.
type StopArchiveSearchOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopArchiveSearchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopArchiveSearchOutput) GoString() string {
	return s.String()
}

// A key-value pair (the value is optional), that you can define and assign
// to Amazon Web Services resources.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the key-value tag.
	//
	// Key is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Tag's
	// String and GoString methods.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The value of the key-value tag.
	//
	// Value is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Tag's
	// String and GoString methods.
	//
	// Value is a required field
	Value *string `type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource that you want to tag.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"20" type:"string" required:"true"`

	// The tags used to organize, track, or control access for the resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Occurs when a service's request rate limit is exceeded, resulting in throttling
// of further requests.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The structure of a traffic policy resource which is a container for policy
// statements.
type TrafficPolicy struct {
	_ struct{} `type:"structure"`

	// Default action instructs the traﬃc policy to either Allow or Deny (block)
	// messages that fall outside of (or not addressed by) the conditions of your
	// policy statements
	//
	// DefaultAction is a required field
	DefaultAction *string `type:"string" required:"true" enum:"AcceptAction"`

	// The identifier of the traffic policy resource.
	//
	// TrafficPolicyId is a required field
	TrafficPolicyId *string `min:"1" type:"string" required:"true"`

	// A user-friendly name of the traffic policy resource.
	//
	// TrafficPolicyName is a required field
	TrafficPolicyName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrafficPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrafficPolicy) GoString() string {
	return s.String()
}

// SetDefaultAction sets the DefaultAction field's value.
func (s *TrafficPolicy) SetDefaultAction(v string) *TrafficPolicy {
	s.DefaultAction = &v
	return s
}

// SetTrafficPolicyId sets the TrafficPolicyId field's value.
func (s *TrafficPolicy) SetTrafficPolicyId(v string) *TrafficPolicy {
	s.TrafficPolicyId = &v
	return s
}

// SetTrafficPolicyName sets the TrafficPolicyName field's value.
func (s *TrafficPolicy) SetTrafficPolicyName(v string) *TrafficPolicy {
	s.TrafficPolicyName = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource that you want to untag.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"20" type:"string" required:"true"`

	// The keys of the key-value pairs for the tag or tags you want to remove from
	// the specified resource.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// The request to update properties of an existing email archive.
type UpdateArchiveInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the archive to update.
	//
	// ArchiveId is a required field
	ArchiveId *string `min:"1" type:"string" required:"true"`

	// A new, unique name for the archive.
	ArchiveName *string `min:"1" type:"string"`

	// A new retention period for emails in the archive.
	Retention *ArchiveRetention `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateArchiveInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateArchiveInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateArchiveInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateArchiveInput"}
	if s.ArchiveId == nil {
		invalidParams.Add(request.NewErrParamRequired("ArchiveId"))
	}
	if s.ArchiveId != nil && len(*s.ArchiveId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ArchiveId", 1))
	}
	if s.ArchiveName != nil && len(*s.ArchiveName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ArchiveName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArchiveId sets the ArchiveId field's value.
func (s *UpdateArchiveInput) SetArchiveId(v string) *UpdateArchiveInput {
	s.ArchiveId = &v
	return s
}

// SetArchiveName sets the ArchiveName field's value.
func (s *UpdateArchiveInput) SetArchiveName(v string) *UpdateArchiveInput {
	s.ArchiveName = &v
	return s
}

// SetRetention sets the Retention field's value.
func (s *UpdateArchiveInput) SetRetention(v *ArchiveRetention) *UpdateArchiveInput {
	s.Retention = v
	return s
}

// The response indicating if the archive update succeeded or failed.
//
// On success, returns an HTTP 200 status code. On failure, returns an error
// message.
type UpdateArchiveOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateArchiveOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateArchiveOutput) GoString() string {
	return s.String()
}

type UpdateIngressPointInput struct {
	_ struct{} `type:"structure"`

	// If you choose an Authenticated ingress endpoint, you must configure either
	// an SMTP password or a secret ARN.
	IngressPointConfiguration *IngressPointConfiguration `type:"structure"`

	// The identifier for the ingress endpoint you want to update.
	//
	// IngressPointId is a required field
	IngressPointId *string `min:"1" type:"string" required:"true"`

	// A user friendly name for the ingress endpoint resource.
	IngressPointName *string `min:"3" type:"string"`

	// The identifier of an existing rule set that you attach to an ingress endpoint
	// resource.
	RuleSetId *string `min:"1" type:"string"`

	// The update status of an ingress endpoint.
	StatusToUpdate *string `type:"string" enum:"IngressPointStatusToUpdate"`

	// The identifier of an existing traffic policy that you attach to an ingress
	// endpoint resource.
	TrafficPolicyId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIngressPointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIngressPointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateIngressPointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateIngressPointInput"}
	if s.IngressPointId == nil {
		invalidParams.Add(request.NewErrParamRequired("IngressPointId"))
	}
	if s.IngressPointId != nil && len(*s.IngressPointId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IngressPointId", 1))
	}
	if s.IngressPointName != nil && len(*s.IngressPointName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("IngressPointName", 3))
	}
	if s.RuleSetId != nil && len(*s.RuleSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleSetId", 1))
	}
	if s.TrafficPolicyId != nil && len(*s.TrafficPolicyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrafficPolicyId", 1))
	}
	if s.IngressPointConfiguration != nil {
		if err := s.IngressPointConfiguration.Validate(); err != nil {
			invalidParams.AddNested("IngressPointConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIngressPointConfiguration sets the IngressPointConfiguration field's value.
func (s *UpdateIngressPointInput) SetIngressPointConfiguration(v *IngressPointConfiguration) *UpdateIngressPointInput {
	s.IngressPointConfiguration = v
	return s
}

// SetIngressPointId sets the IngressPointId field's value.
func (s *UpdateIngressPointInput) SetIngressPointId(v string) *UpdateIngressPointInput {
	s.IngressPointId = &v
	return s
}

// SetIngressPointName sets the IngressPointName field's value.
func (s *UpdateIngressPointInput) SetIngressPointName(v string) *UpdateIngressPointInput {
	s.IngressPointName = &v
	return s
}

// SetRuleSetId sets the RuleSetId field's value.
func (s *UpdateIngressPointInput) SetRuleSetId(v string) *UpdateIngressPointInput {
	s.RuleSetId = &v
	return s
}

// SetStatusToUpdate sets the StatusToUpdate field's value.
func (s *UpdateIngressPointInput) SetStatusToUpdate(v string) *UpdateIngressPointInput {
	s.StatusToUpdate = &v
	return s
}

// SetTrafficPolicyId sets the TrafficPolicyId field's value.
func (s *UpdateIngressPointInput) SetTrafficPolicyId(v string) *UpdateIngressPointInput {
	s.TrafficPolicyId = &v
	return s
}

type UpdateIngressPointOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIngressPointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIngressPointOutput) GoString() string {
	return s.String()
}

type UpdateRelayInput struct {
	_ struct{} `type:"structure"`

	// Authentication for the relay destination server—specify the secretARN where
	// the SMTP credentials are stored.
	Authentication *RelayAuthentication `type:"structure"`

	// The unique relay identifier.
	//
	// RelayId is a required field
	RelayId *string `min:"1" type:"string" required:"true"`

	// The name of the relay resource.
	RelayName *string `min:"1" type:"string"`

	// The destination relay server address.
	ServerName *string `min:"1" type:"string"`

	// The destination relay server port.
	ServerPort *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRelayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRelayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRelayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRelayInput"}
	if s.RelayId == nil {
		invalidParams.Add(request.NewErrParamRequired("RelayId"))
	}
	if s.RelayId != nil && len(*s.RelayId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RelayId", 1))
	}
	if s.RelayName != nil && len(*s.RelayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RelayName", 1))
	}
	if s.ServerName != nil && len(*s.ServerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServerName", 1))
	}
	if s.ServerPort != nil && *s.ServerPort < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ServerPort", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthentication sets the Authentication field's value.
func (s *UpdateRelayInput) SetAuthentication(v *RelayAuthentication) *UpdateRelayInput {
	s.Authentication = v
	return s
}

// SetRelayId sets the RelayId field's value.
func (s *UpdateRelayInput) SetRelayId(v string) *UpdateRelayInput {
	s.RelayId = &v
	return s
}

// SetRelayName sets the RelayName field's value.
func (s *UpdateRelayInput) SetRelayName(v string) *UpdateRelayInput {
	s.RelayName = &v
	return s
}

// SetServerName sets the ServerName field's value.
func (s *UpdateRelayInput) SetServerName(v string) *UpdateRelayInput {
	s.ServerName = &v
	return s
}

// SetServerPort sets the ServerPort field's value.
func (s *UpdateRelayInput) SetServerPort(v int64) *UpdateRelayInput {
	s.ServerPort = &v
	return s
}

type UpdateRelayOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRelayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRelayOutput) GoString() string {
	return s.String()
}

type UpdateRuleSetInput struct {
	_ struct{} `type:"structure"`

	// The identifier of a rule set you want to update.
	//
	// RuleSetId is a required field
	RuleSetId *string `min:"1" type:"string" required:"true"`

	// A user-friendly name for the rule set resource.
	RuleSetName *string `min:"1" type:"string"`

	// A new set of rules to replace the current rules of the rule set—these rules
	// will override all the rules of the rule set.
	Rules []*Rule `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRuleSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRuleSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRuleSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRuleSetInput"}
	if s.RuleSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleSetId"))
	}
	if s.RuleSetId != nil && len(*s.RuleSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleSetId", 1))
	}
	if s.RuleSetName != nil && len(*s.RuleSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleSetName", 1))
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRuleSetId sets the RuleSetId field's value.
func (s *UpdateRuleSetInput) SetRuleSetId(v string) *UpdateRuleSetInput {
	s.RuleSetId = &v
	return s
}

// SetRuleSetName sets the RuleSetName field's value.
func (s *UpdateRuleSetInput) SetRuleSetName(v string) *UpdateRuleSetInput {
	s.RuleSetName = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *UpdateRuleSetInput) SetRules(v []*Rule) *UpdateRuleSetInput {
	s.Rules = v
	return s
}

type UpdateRuleSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRuleSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRuleSetOutput) GoString() string {
	return s.String()
}

type UpdateTrafficPolicyInput struct {
	_ struct{} `type:"structure"`

	// Default action instructs the traﬃc policy to either Allow or Deny (block)
	// messages that fall outside of (or not addressed by) the conditions of your
	// policy statements
	DefaultAction *string `type:"string" enum:"AcceptAction"`

	// The maximum message size in bytes of email which is allowed in by this traffic
	// policy—anything larger will be blocked.
	MaxMessageSizeBytes *int64 `min:"1" type:"integer"`

	// The list of conditions to be updated for filtering email traffic.
	PolicyStatements []*PolicyStatement `type:"list"`

	// The identifier of the traffic policy that you want to update.
	//
	// TrafficPolicyId is a required field
	TrafficPolicyId *string `min:"1" type:"string" required:"true"`

	// A user-friendly name for the traffic policy resource.
	TrafficPolicyName *string `min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTrafficPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTrafficPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTrafficPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTrafficPolicyInput"}
	if s.MaxMessageSizeBytes != nil && *s.MaxMessageSizeBytes < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxMessageSizeBytes", 1))
	}
	if s.TrafficPolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("TrafficPolicyId"))
	}
	if s.TrafficPolicyId != nil && len(*s.TrafficPolicyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrafficPolicyId", 1))
	}
	if s.TrafficPolicyName != nil && len(*s.TrafficPolicyName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TrafficPolicyName", 3))
	}
	if s.PolicyStatements != nil {
		for i, v := range s.PolicyStatements {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PolicyStatements", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefaultAction sets the DefaultAction field's value.
func (s *UpdateTrafficPolicyInput) SetDefaultAction(v string) *UpdateTrafficPolicyInput {
	s.DefaultAction = &v
	return s
}

// SetMaxMessageSizeBytes sets the MaxMessageSizeBytes field's value.
func (s *UpdateTrafficPolicyInput) SetMaxMessageSizeBytes(v int64) *UpdateTrafficPolicyInput {
	s.MaxMessageSizeBytes = &v
	return s
}

// SetPolicyStatements sets the PolicyStatements field's value.
func (s *UpdateTrafficPolicyInput) SetPolicyStatements(v []*PolicyStatement) *UpdateTrafficPolicyInput {
	s.PolicyStatements = v
	return s
}

// SetTrafficPolicyId sets the TrafficPolicyId field's value.
func (s *UpdateTrafficPolicyInput) SetTrafficPolicyId(v string) *UpdateTrafficPolicyInput {
	s.TrafficPolicyId = &v
	return s
}

// SetTrafficPolicyName sets the TrafficPolicyName field's value.
func (s *UpdateTrafficPolicyInput) SetTrafficPolicyName(v string) *UpdateTrafficPolicyInput {
	s.TrafficPolicyName = &v
	return s
}

type UpdateTrafficPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTrafficPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTrafficPolicyOutput) GoString() string {
	return s.String()
}

// The request validation has failed. For details, see the accompanying error
// message.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// AcceptActionAllow is a AcceptAction enum value
	AcceptActionAllow = "ALLOW"

	// AcceptActionDeny is a AcceptAction enum value
	AcceptActionDeny = "DENY"
)

// AcceptAction_Values returns all elements of the AcceptAction enum
func AcceptAction_Values() []string {
	return []string{
		AcceptActionAllow,
		AcceptActionDeny,
	}
}

const (
	// ActionFailurePolicyContinue is a ActionFailurePolicy enum value
	ActionFailurePolicyContinue = "CONTINUE"

	// ActionFailurePolicyDrop is a ActionFailurePolicy enum value
	ActionFailurePolicyDrop = "DROP"
)

// ActionFailurePolicy_Values returns all elements of the ActionFailurePolicy enum
func ActionFailurePolicy_Values() []string {
	return []string{
		ActionFailurePolicyContinue,
		ActionFailurePolicyDrop,
	}
}

const (
	// ArchiveBooleanEmailAttributeHasAttachments is a ArchiveBooleanEmailAttribute enum value
	ArchiveBooleanEmailAttributeHasAttachments = "HAS_ATTACHMENTS"
)

// ArchiveBooleanEmailAttribute_Values returns all elements of the ArchiveBooleanEmailAttribute enum
func ArchiveBooleanEmailAttribute_Values() []string {
	return []string{
		ArchiveBooleanEmailAttributeHasAttachments,
	}
}

const (
	// ArchiveBooleanOperatorIsTrue is a ArchiveBooleanOperator enum value
	ArchiveBooleanOperatorIsTrue = "IS_TRUE"

	// ArchiveBooleanOperatorIsFalse is a ArchiveBooleanOperator enum value
	ArchiveBooleanOperatorIsFalse = "IS_FALSE"
)

// ArchiveBooleanOperator_Values returns all elements of the ArchiveBooleanOperator enum
func ArchiveBooleanOperator_Values() []string {
	return []string{
		ArchiveBooleanOperatorIsTrue,
		ArchiveBooleanOperatorIsFalse,
	}
}

const (
	// ArchiveStateActive is a ArchiveState enum value
	ArchiveStateActive = "ACTIVE"

	// ArchiveStatePendingDeletion is a ArchiveState enum value
	ArchiveStatePendingDeletion = "PENDING_DELETION"
)

// ArchiveState_Values returns all elements of the ArchiveState enum
func ArchiveState_Values() []string {
	return []string{
		ArchiveStateActive,
		ArchiveStatePendingDeletion,
	}
}

const (
	// ArchiveStringEmailAttributeTo is a ArchiveStringEmailAttribute enum value
	ArchiveStringEmailAttributeTo = "TO"

	// ArchiveStringEmailAttributeFrom is a ArchiveStringEmailAttribute enum value
	ArchiveStringEmailAttributeFrom = "FROM"

	// ArchiveStringEmailAttributeCc is a ArchiveStringEmailAttribute enum value
	ArchiveStringEmailAttributeCc = "CC"

	// ArchiveStringEmailAttributeSubject is a ArchiveStringEmailAttribute enum value
	ArchiveStringEmailAttributeSubject = "SUBJECT"
)

// ArchiveStringEmailAttribute_Values returns all elements of the ArchiveStringEmailAttribute enum
func ArchiveStringEmailAttribute_Values() []string {
	return []string{
		ArchiveStringEmailAttributeTo,
		ArchiveStringEmailAttributeFrom,
		ArchiveStringEmailAttributeCc,
		ArchiveStringEmailAttributeSubject,
	}
}

const (
	// ArchiveStringOperatorContains is a ArchiveStringOperator enum value
	ArchiveStringOperatorContains = "CONTAINS"
)

// ArchiveStringOperator_Values returns all elements of the ArchiveStringOperator enum
func ArchiveStringOperator_Values() []string {
	return []string{
		ArchiveStringOperatorContains,
	}
}

const (
	// ExportStateQueued is a ExportState enum value
	ExportStateQueued = "QUEUED"

	// ExportStatePreprocessing is a ExportState enum value
	ExportStatePreprocessing = "PREPROCESSING"

	// ExportStateProcessing is a ExportState enum value
	ExportStateProcessing = "PROCESSING"

	// ExportStateCompleted is a ExportState enum value
	ExportStateCompleted = "COMPLETED"

	// ExportStateFailed is a ExportState enum value
	ExportStateFailed = "FAILED"

	// ExportStateCancelled is a ExportState enum value
	ExportStateCancelled = "CANCELLED"
)

// ExportState_Values returns all elements of the ExportState enum
func ExportState_Values() []string {
	return []string{
		ExportStateQueued,
		ExportStatePreprocessing,
		ExportStateProcessing,
		ExportStateCompleted,
		ExportStateFailed,
		ExportStateCancelled,
	}
}

const (
	// IngressBooleanOperatorIsTrue is a IngressBooleanOperator enum value
	IngressBooleanOperatorIsTrue = "IS_TRUE"

	// IngressBooleanOperatorIsFalse is a IngressBooleanOperator enum value
	IngressBooleanOperatorIsFalse = "IS_FALSE"
)

// IngressBooleanOperator_Values returns all elements of the IngressBooleanOperator enum
func IngressBooleanOperator_Values() []string {
	return []string{
		IngressBooleanOperatorIsTrue,
		IngressBooleanOperatorIsFalse,
	}
}

const (
	// IngressIpOperatorCidrMatches is a IngressIpOperator enum value
	IngressIpOperatorCidrMatches = "CIDR_MATCHES"

	// IngressIpOperatorNotCidrMatches is a IngressIpOperator enum value
	IngressIpOperatorNotCidrMatches = "NOT_CIDR_MATCHES"
)

// IngressIpOperator_Values returns all elements of the IngressIpOperator enum
func IngressIpOperator_Values() []string {
	return []string{
		IngressIpOperatorCidrMatches,
		IngressIpOperatorNotCidrMatches,
	}
}

const (
	// IngressIpv4AttributeSenderIp is a IngressIpv4Attribute enum value
	IngressIpv4AttributeSenderIp = "SENDER_IP"
)

// IngressIpv4Attribute_Values returns all elements of the IngressIpv4Attribute enum
func IngressIpv4Attribute_Values() []string {
	return []string{
		IngressIpv4AttributeSenderIp,
	}
}

const (
	// IngressPointStatusProvisioning is a IngressPointStatus enum value
	IngressPointStatusProvisioning = "PROVISIONING"

	// IngressPointStatusDeprovisioning is a IngressPointStatus enum value
	IngressPointStatusDeprovisioning = "DEPROVISIONING"

	// IngressPointStatusUpdating is a IngressPointStatus enum value
	IngressPointStatusUpdating = "UPDATING"

	// IngressPointStatusActive is a IngressPointStatus enum value
	IngressPointStatusActive = "ACTIVE"

	// IngressPointStatusClosed is a IngressPointStatus enum value
	IngressPointStatusClosed = "CLOSED"

	// IngressPointStatusFailed is a IngressPointStatus enum value
	IngressPointStatusFailed = "FAILED"
)

// IngressPointStatus_Values returns all elements of the IngressPointStatus enum
func IngressPointStatus_Values() []string {
	return []string{
		IngressPointStatusProvisioning,
		IngressPointStatusDeprovisioning,
		IngressPointStatusUpdating,
		IngressPointStatusActive,
		IngressPointStatusClosed,
		IngressPointStatusFailed,
	}
}

const (
	// IngressPointStatusToUpdateActive is a IngressPointStatusToUpdate enum value
	IngressPointStatusToUpdateActive = "ACTIVE"

	// IngressPointStatusToUpdateClosed is a IngressPointStatusToUpdate enum value
	IngressPointStatusToUpdateClosed = "CLOSED"
)

// IngressPointStatusToUpdate_Values returns all elements of the IngressPointStatusToUpdate enum
func IngressPointStatusToUpdate_Values() []string {
	return []string{
		IngressPointStatusToUpdateActive,
		IngressPointStatusToUpdateClosed,
	}
}

const (
	// IngressPointTypeOpen is a IngressPointType enum value
	IngressPointTypeOpen = "OPEN"

	// IngressPointTypeAuth is a IngressPointType enum value
	IngressPointTypeAuth = "AUTH"
)

// IngressPointType_Values returns all elements of the IngressPointType enum
func IngressPointType_Values() []string {
	return []string{
		IngressPointTypeOpen,
		IngressPointTypeAuth,
	}
}

const (
	// IngressStringEmailAttributeRecipient is a IngressStringEmailAttribute enum value
	IngressStringEmailAttributeRecipient = "RECIPIENT"
)

// IngressStringEmailAttribute_Values returns all elements of the IngressStringEmailAttribute enum
func IngressStringEmailAttribute_Values() []string {
	return []string{
		IngressStringEmailAttributeRecipient,
	}
}

const (
	// IngressStringOperatorEquals is a IngressStringOperator enum value
	IngressStringOperatorEquals = "EQUALS"

	// IngressStringOperatorNotEquals is a IngressStringOperator enum value
	IngressStringOperatorNotEquals = "NOT_EQUALS"

	// IngressStringOperatorStartsWith is a IngressStringOperator enum value
	IngressStringOperatorStartsWith = "STARTS_WITH"

	// IngressStringOperatorEndsWith is a IngressStringOperator enum value
	IngressStringOperatorEndsWith = "ENDS_WITH"

	// IngressStringOperatorContains is a IngressStringOperator enum value
	IngressStringOperatorContains = "CONTAINS"
)

// IngressStringOperator_Values returns all elements of the IngressStringOperator enum
func IngressStringOperator_Values() []string {
	return []string{
		IngressStringOperatorEquals,
		IngressStringOperatorNotEquals,
		IngressStringOperatorStartsWith,
		IngressStringOperatorEndsWith,
		IngressStringOperatorContains,
	}
}

const (
	// IngressTlsAttributeTlsProtocol is a IngressTlsAttribute enum value
	IngressTlsAttributeTlsProtocol = "TLS_PROTOCOL"
)

// IngressTlsAttribute_Values returns all elements of the IngressTlsAttribute enum
func IngressTlsAttribute_Values() []string {
	return []string{
		IngressTlsAttributeTlsProtocol,
	}
}

const (
	// IngressTlsProtocolAttributeTls12 is a IngressTlsProtocolAttribute enum value
	IngressTlsProtocolAttributeTls12 = "TLS1_2"

	// IngressTlsProtocolAttributeTls13 is a IngressTlsProtocolAttribute enum value
	IngressTlsProtocolAttributeTls13 = "TLS1_3"
)

// IngressTlsProtocolAttribute_Values returns all elements of the IngressTlsProtocolAttribute enum
func IngressTlsProtocolAttribute_Values() []string {
	return []string{
		IngressTlsProtocolAttributeTls12,
		IngressTlsProtocolAttributeTls13,
	}
}

const (
	// IngressTlsProtocolOperatorMinimumTlsVersion is a IngressTlsProtocolOperator enum value
	IngressTlsProtocolOperatorMinimumTlsVersion = "MINIMUM_TLS_VERSION"

	// IngressTlsProtocolOperatorIs is a IngressTlsProtocolOperator enum value
	IngressTlsProtocolOperatorIs = "IS"
)

// IngressTlsProtocolOperator_Values returns all elements of the IngressTlsProtocolOperator enum
func IngressTlsProtocolOperator_Values() []string {
	return []string{
		IngressTlsProtocolOperatorMinimumTlsVersion,
		IngressTlsProtocolOperatorIs,
	}
}

const (
	// MailFromReplace is a MailFrom enum value
	MailFromReplace = "REPLACE"

	// MailFromPreserve is a MailFrom enum value
	MailFromPreserve = "PRESERVE"
)

// MailFrom_Values returns all elements of the MailFrom enum
func MailFrom_Values() []string {
	return []string{
		MailFromReplace,
		MailFromPreserve,
	}
}

const (
	// RetentionPeriodThreeMonths is a RetentionPeriod enum value
	RetentionPeriodThreeMonths = "THREE_MONTHS"

	// RetentionPeriodSixMonths is a RetentionPeriod enum value
	RetentionPeriodSixMonths = "SIX_MONTHS"

	// RetentionPeriodNineMonths is a RetentionPeriod enum value
	RetentionPeriodNineMonths = "NINE_MONTHS"

	// RetentionPeriodOneYear is a RetentionPeriod enum value
	RetentionPeriodOneYear = "ONE_YEAR"

	// RetentionPeriodEighteenMonths is a RetentionPeriod enum value
	RetentionPeriodEighteenMonths = "EIGHTEEN_MONTHS"

	// RetentionPeriodTwoYears is a RetentionPeriod enum value
	RetentionPeriodTwoYears = "TWO_YEARS"

	// RetentionPeriodThirtyMonths is a RetentionPeriod enum value
	RetentionPeriodThirtyMonths = "THIRTY_MONTHS"

	// RetentionPeriodThreeYears is a RetentionPeriod enum value
	RetentionPeriodThreeYears = "THREE_YEARS"

	// RetentionPeriodFourYears is a RetentionPeriod enum value
	RetentionPeriodFourYears = "FOUR_YEARS"

	// RetentionPeriodFiveYears is a RetentionPeriod enum value
	RetentionPeriodFiveYears = "FIVE_YEARS"

	// RetentionPeriodSixYears is a RetentionPeriod enum value
	RetentionPeriodSixYears = "SIX_YEARS"

	// RetentionPeriodSevenYears is a RetentionPeriod enum value
	RetentionPeriodSevenYears = "SEVEN_YEARS"

	// RetentionPeriodEightYears is a RetentionPeriod enum value
	RetentionPeriodEightYears = "EIGHT_YEARS"

	// RetentionPeriodNineYears is a RetentionPeriod enum value
	RetentionPeriodNineYears = "NINE_YEARS"

	// RetentionPeriodTenYears is a RetentionPeriod enum value
	RetentionPeriodTenYears = "TEN_YEARS"

	// RetentionPeriodPermanent is a RetentionPeriod enum value
	RetentionPeriodPermanent = "PERMANENT"
)

// RetentionPeriod_Values returns all elements of the RetentionPeriod enum
func RetentionPeriod_Values() []string {
	return []string{
		RetentionPeriodThreeMonths,
		RetentionPeriodSixMonths,
		RetentionPeriodNineMonths,
		RetentionPeriodOneYear,
		RetentionPeriodEighteenMonths,
		RetentionPeriodTwoYears,
		RetentionPeriodThirtyMonths,
		RetentionPeriodThreeYears,
		RetentionPeriodFourYears,
		RetentionPeriodFiveYears,
		RetentionPeriodSixYears,
		RetentionPeriodSevenYears,
		RetentionPeriodEightYears,
		RetentionPeriodNineYears,
		RetentionPeriodTenYears,
		RetentionPeriodPermanent,
	}
}

const (
	// RuleBooleanEmailAttributeReadReceiptRequested is a RuleBooleanEmailAttribute enum value
	RuleBooleanEmailAttributeReadReceiptRequested = "READ_RECEIPT_REQUESTED"

	// RuleBooleanEmailAttributeTls is a RuleBooleanEmailAttribute enum value
	RuleBooleanEmailAttributeTls = "TLS"

	// RuleBooleanEmailAttributeTlsWrapped is a RuleBooleanEmailAttribute enum value
	RuleBooleanEmailAttributeTlsWrapped = "TLS_WRAPPED"
)

// RuleBooleanEmailAttribute_Values returns all elements of the RuleBooleanEmailAttribute enum
func RuleBooleanEmailAttribute_Values() []string {
	return []string{
		RuleBooleanEmailAttributeReadReceiptRequested,
		RuleBooleanEmailAttributeTls,
		RuleBooleanEmailAttributeTlsWrapped,
	}
}

const (
	// RuleBooleanOperatorIsTrue is a RuleBooleanOperator enum value
	RuleBooleanOperatorIsTrue = "IS_TRUE"

	// RuleBooleanOperatorIsFalse is a RuleBooleanOperator enum value
	RuleBooleanOperatorIsFalse = "IS_FALSE"
)

// RuleBooleanOperator_Values returns all elements of the RuleBooleanOperator enum
func RuleBooleanOperator_Values() []string {
	return []string{
		RuleBooleanOperatorIsTrue,
		RuleBooleanOperatorIsFalse,
	}
}

const (
	// RuleDmarcOperatorEquals is a RuleDmarcOperator enum value
	RuleDmarcOperatorEquals = "EQUALS"

	// RuleDmarcOperatorNotEquals is a RuleDmarcOperator enum value
	RuleDmarcOperatorNotEquals = "NOT_EQUALS"
)

// RuleDmarcOperator_Values returns all elements of the RuleDmarcOperator enum
func RuleDmarcOperator_Values() []string {
	return []string{
		RuleDmarcOperatorEquals,
		RuleDmarcOperatorNotEquals,
	}
}

const (
	// RuleDmarcPolicyNone is a RuleDmarcPolicy enum value
	RuleDmarcPolicyNone = "NONE"

	// RuleDmarcPolicyQuarantine is a RuleDmarcPolicy enum value
	RuleDmarcPolicyQuarantine = "QUARANTINE"

	// RuleDmarcPolicyReject is a RuleDmarcPolicy enum value
	RuleDmarcPolicyReject = "REJECT"
)

// RuleDmarcPolicy_Values returns all elements of the RuleDmarcPolicy enum
func RuleDmarcPolicy_Values() []string {
	return []string{
		RuleDmarcPolicyNone,
		RuleDmarcPolicyQuarantine,
		RuleDmarcPolicyReject,
	}
}

const (
	// RuleIpEmailAttributeSourceIp is a RuleIpEmailAttribute enum value
	RuleIpEmailAttributeSourceIp = "SOURCE_IP"
)

// RuleIpEmailAttribute_Values returns all elements of the RuleIpEmailAttribute enum
func RuleIpEmailAttribute_Values() []string {
	return []string{
		RuleIpEmailAttributeSourceIp,
	}
}

const (
	// RuleIpOperatorCidrMatches is a RuleIpOperator enum value
	RuleIpOperatorCidrMatches = "CIDR_MATCHES"

	// RuleIpOperatorNotCidrMatches is a RuleIpOperator enum value
	RuleIpOperatorNotCidrMatches = "NOT_CIDR_MATCHES"
)

// RuleIpOperator_Values returns all elements of the RuleIpOperator enum
func RuleIpOperator_Values() []string {
	return []string{
		RuleIpOperatorCidrMatches,
		RuleIpOperatorNotCidrMatches,
	}
}

const (
	// RuleNumberEmailAttributeMessageSize is a RuleNumberEmailAttribute enum value
	RuleNumberEmailAttributeMessageSize = "MESSAGE_SIZE"
)

// RuleNumberEmailAttribute_Values returns all elements of the RuleNumberEmailAttribute enum
func RuleNumberEmailAttribute_Values() []string {
	return []string{
		RuleNumberEmailAttributeMessageSize,
	}
}

const (
	// RuleNumberOperatorEquals is a RuleNumberOperator enum value
	RuleNumberOperatorEquals = "EQUALS"

	// RuleNumberOperatorNotEquals is a RuleNumberOperator enum value
	RuleNumberOperatorNotEquals = "NOT_EQUALS"

	// RuleNumberOperatorLessThan is a RuleNumberOperator enum value
	RuleNumberOperatorLessThan = "LESS_THAN"

	// RuleNumberOperatorGreaterThan is a RuleNumberOperator enum value
	RuleNumberOperatorGreaterThan = "GREATER_THAN"

	// RuleNumberOperatorLessThanOrEqual is a RuleNumberOperator enum value
	RuleNumberOperatorLessThanOrEqual = "LESS_THAN_OR_EQUAL"

	// RuleNumberOperatorGreaterThanOrEqual is a RuleNumberOperator enum value
	RuleNumberOperatorGreaterThanOrEqual = "GREATER_THAN_OR_EQUAL"
)

// RuleNumberOperator_Values returns all elements of the RuleNumberOperator enum
func RuleNumberOperator_Values() []string {
	return []string{
		RuleNumberOperatorEquals,
		RuleNumberOperatorNotEquals,
		RuleNumberOperatorLessThan,
		RuleNumberOperatorGreaterThan,
		RuleNumberOperatorLessThanOrEqual,
		RuleNumberOperatorGreaterThanOrEqual,
	}
}

const (
	// RuleStringEmailAttributeMailFrom is a RuleStringEmailAttribute enum value
	RuleStringEmailAttributeMailFrom = "MAIL_FROM"

	// RuleStringEmailAttributeHelo is a RuleStringEmailAttribute enum value
	RuleStringEmailAttributeHelo = "HELO"

	// RuleStringEmailAttributeRecipient is a RuleStringEmailAttribute enum value
	RuleStringEmailAttributeRecipient = "RECIPIENT"

	// RuleStringEmailAttributeSender is a RuleStringEmailAttribute enum value
	RuleStringEmailAttributeSender = "SENDER"

	// RuleStringEmailAttributeFrom is a RuleStringEmailAttribute enum value
	RuleStringEmailAttributeFrom = "FROM"

	// RuleStringEmailAttributeSubject is a RuleStringEmailAttribute enum value
	RuleStringEmailAttributeSubject = "SUBJECT"

	// RuleStringEmailAttributeTo is a RuleStringEmailAttribute enum value
	RuleStringEmailAttributeTo = "TO"

	// RuleStringEmailAttributeCc is a RuleStringEmailAttribute enum value
	RuleStringEmailAttributeCc = "CC"
)

// RuleStringEmailAttribute_Values returns all elements of the RuleStringEmailAttribute enum
func RuleStringEmailAttribute_Values() []string {
	return []string{
		RuleStringEmailAttributeMailFrom,
		RuleStringEmailAttributeHelo,
		RuleStringEmailAttributeRecipient,
		RuleStringEmailAttributeSender,
		RuleStringEmailAttributeFrom,
		RuleStringEmailAttributeSubject,
		RuleStringEmailAttributeTo,
		RuleStringEmailAttributeCc,
	}
}

const (
	// RuleStringOperatorEquals is a RuleStringOperator enum value
	RuleStringOperatorEquals = "EQUALS"

	// RuleStringOperatorNotEquals is a RuleStringOperator enum value
	RuleStringOperatorNotEquals = "NOT_EQUALS"

	// RuleStringOperatorStartsWith is a RuleStringOperator enum value
	RuleStringOperatorStartsWith = "STARTS_WITH"

	// RuleStringOperatorEndsWith is a RuleStringOperator enum value
	RuleStringOperatorEndsWith = "ENDS_WITH"

	// RuleStringOperatorContains is a RuleStringOperator enum value
	RuleStringOperatorContains = "CONTAINS"
)

// RuleStringOperator_Values returns all elements of the RuleStringOperator enum
func RuleStringOperator_Values() []string {
	return []string{
		RuleStringOperatorEquals,
		RuleStringOperatorNotEquals,
		RuleStringOperatorStartsWith,
		RuleStringOperatorEndsWith,
		RuleStringOperatorContains,
	}
}

const (
	// RuleVerdictPass is a RuleVerdict enum value
	RuleVerdictPass = "PASS"

	// RuleVerdictFail is a RuleVerdict enum value
	RuleVerdictFail = "FAIL"

	// RuleVerdictGray is a RuleVerdict enum value
	RuleVerdictGray = "GRAY"

	// RuleVerdictProcessingFailed is a RuleVerdict enum value
	RuleVerdictProcessingFailed = "PROCESSING_FAILED"
)

// RuleVerdict_Values returns all elements of the RuleVerdict enum
func RuleVerdict_Values() []string {
	return []string{
		RuleVerdictPass,
		RuleVerdictFail,
		RuleVerdictGray,
		RuleVerdictProcessingFailed,
	}
}

const (
	// RuleVerdictAttributeSpf is a RuleVerdictAttribute enum value
	RuleVerdictAttributeSpf = "SPF"

	// RuleVerdictAttributeDkim is a RuleVerdictAttribute enum value
	RuleVerdictAttributeDkim = "DKIM"
)

// RuleVerdictAttribute_Values returns all elements of the RuleVerdictAttribute enum
func RuleVerdictAttribute_Values() []string {
	return []string{
		RuleVerdictAttributeSpf,
		RuleVerdictAttributeDkim,
	}
}

const (
	// RuleVerdictOperatorEquals is a RuleVerdictOperator enum value
	RuleVerdictOperatorEquals = "EQUALS"

	// RuleVerdictOperatorNotEquals is a RuleVerdictOperator enum value
	RuleVerdictOperatorNotEquals = "NOT_EQUALS"
)

// RuleVerdictOperator_Values returns all elements of the RuleVerdictOperator enum
func RuleVerdictOperator_Values() []string {
	return []string{
		RuleVerdictOperatorEquals,
		RuleVerdictOperatorNotEquals,
	}
}

const (
	// SearchStateQueued is a SearchState enum value
	SearchStateQueued = "QUEUED"

	// SearchStateRunning is a SearchState enum value
	SearchStateRunning = "RUNNING"

	// SearchStateCompleted is a SearchState enum value
	SearchStateCompleted = "COMPLETED"

	// SearchStateFailed is a SearchState enum value
	SearchStateFailed = "FAILED"

	// SearchStateCancelled is a SearchState enum value
	SearchStateCancelled = "CANCELLED"
)

// SearchState_Values returns all elements of the SearchState enum
func SearchState_Values() []string {
	return []string{
		SearchStateQueued,
		SearchStateRunning,
		SearchStateCompleted,
		SearchStateFailed,
		SearchStateCancelled,
	}
}
