/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import net.sf.saxon.expr.sort.IntIterator;
import net.sf.saxon.expr.sort.IntSet;

public class IntSingletonSet
implements IntSet {
    private int value;

    public IntSingletonSet(int value) {
        this.value = value;
    }

    public void clear() {
        throw new UnsupportedOperationException("IntSingletonSet is immutable");
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean contains(int value) {
        return this.value == value;
    }

    public boolean remove(int value) {
        throw new UnsupportedOperationException("IntSingletonSet is immutable");
    }

    public boolean add(int value) {
        throw new UnsupportedOperationException("IntSingletonSet is immutable");
    }

    public IntIterator iterator() {
        return new IntIterator(){
            boolean gone = false;

            public boolean hasNext() {
                return !this.gone;
            }

            public int next() {
                this.gone = true;
                return IntSingletonSet.this.value;
            }
        };
    }

    public boolean containsAll(IntSet other) {
        if (other.size() > 1) {
            return false;
        }
        IntIterator ii = other.iterator();
        while (ii.hasNext()) {
            if (this.value == ii.next()) continue;
            return false;
        }
        return true;
    }
}

