/*
   This file is part of TALER
   Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 3, or (at your option) any
   later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
   or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
   License for more details.

   You should have received a copy of the GNU General Public License
   along with TALER; see the file COPYING.  If not, see
   <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_lookup_order_charity.h
 * @brief Header for retrieving Donau charity_id and corresponding private key
 *        by Donau URL.
 * @author Bohdan Potuzhnyi
 * @author Vlada Svirsh
 */

#ifndef PG_LOOKUP_ORDER_CHARITY_H
#define PG_LOOKUP_ORDER_CHARITY_H

#include "platform.h"
#include <taler/taler_error_codes.h>
#include <taler/taler_dbevents.h>
#include <taler/taler_pq_lib.h>
#include "donau/donau_service.h"
#include "pg_helper.h"


/**
 * Retrieve the charity’s ID and private key for a given Donau URL.
 *
 * @param cls plugin closure (the Postgres DB handle / struct PostgresClosure *)
 * @param instance_id the instance ID of the merchant
 * @param donau_url base URL of the Donau instance
 * @param[out] charity_id set to the `charity_id` from `merchant_donau_instances`
 * @param[out] charity_priv set to the private key (32 bytes)
 * @param[out] charity_max_per_year set to the maximum amount that can be donated
 * per year to this charity
 * @param[out] charity_receipts_to_date set to the total amount of receipts
 * issued to date
 * @param[out] donau_keys_json set to the JSON object containing the Donau keys
 * @param[out] donau_instance_serial set to the serial number of the Donau instance in DB
 */
enum GNUNET_DB_QueryStatus
TMH_PG_lookup_order_charity (
  void *cls,
  const char *instance_id,
  const char *donau_url,
  uint64_t *charity_id,
  struct DONAU_CharityPrivateKeyP *charity_priv,
  struct TALER_Amount *charity_max_per_year,
  struct TALER_Amount *charity_receipts_to_date,
  json_t **donau_keys_json,
  uint64_t *donau_instance_serial);

#endif /* PG_LOOKUP_ORDER_CHARITY_H */