/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/DocUtils/EnumConvertersXml.h"
#include "Doc/DocXml/CafInstallRequestXml/FullPackageElemXml.h"
#include "Doc/CafInstallRequestDoc/CafInstallRequestDocTypes.h"

#include "Doc/CafInstallRequestDoc/CFullPackageElemDoc.h"
#include "Doc/CafInstallRequestDoc/CInstallProviderJobDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/CafInstallRequestXml/InstallProviderJobXml.h"

using namespace Caf;

void InstallProviderJobXml::add(
	const SmartPtrCInstallProviderJobDoc installProviderJobDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("InstallProviderJobXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(installProviderJobDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string clientIdVal =
			BasePlatform::UuidToString(installProviderJobDoc->getClientId());
		CAF_CM_VALIDATE_STRING(clientIdVal);
		thisXml->addAttribute("clientId", clientIdVal);

		const std::string jobIdVal =
			BasePlatform::UuidToString(installProviderJobDoc->getJobId());
		CAF_CM_VALIDATE_STRING(jobIdVal);
		thisXml->addAttribute("jobId", jobIdVal);

		const std::string providerNamespaceVal = installProviderJobDoc->getProviderNamespace();
		CAF_CM_VALIDATE_STRING(providerNamespaceVal);
		thisXml->addAttribute("providerNamespace", providerNamespaceVal);

		const std::string providerNameVal = installProviderJobDoc->getProviderName();
		CAF_CM_VALIDATE_STRING(providerNameVal);
		thisXml->addAttribute("providerName", providerNameVal);

		const std::string providerVersionVal = installProviderJobDoc->getProviderVersion();
		CAF_CM_VALIDATE_STRING(providerVersionVal);
		thisXml->addAttribute("providerVersion", providerVersionVal);

		const std::string packageOSTypeVal =
			EnumConvertersXml::convertPackageOSTypeToString(installProviderJobDoc->getPackageOSType());
		CAF_CM_VALIDATE_STRING(packageOSTypeVal);
		thisXml->addAttribute("packageOSType", packageOSTypeVal);

		const std::deque<SmartPtrCFullPackageElemDoc> packageValVal =
			installProviderJobDoc->getPackageCollection();
		CAF_CM_VALIDATE_STL(packageValVal);

		if (! packageValVal.empty()) {
			const SmartPtrCXmlElement packageCollectionXml =
				thisXml->createAndAddElement("packageCollection");
			for (TConstIterator<std::deque<SmartPtrCFullPackageElemDoc> > packageValIter(packageValVal);
				packageValIter; packageValIter++) {
				const SmartPtrCXmlElement packageValXml =
						packageCollectionXml->createAndAddElement("package");
				FullPackageElemXml::add(*packageValIter, packageValXml);
			}
		}
	}
	CAF_CM_EXIT;
}

SmartPtrCInstallProviderJobDoc InstallProviderJobXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("InstallProviderJobXml", "parse");

	SmartPtrCInstallProviderJobDoc installProviderJobDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string clientIdStrVal =
			thisXml->findRequiredAttribute("clientId");
		UUID clientIdVal = CAFCOMMON_GUID_NULL;
		BasePlatform::UuidFromString(clientIdStrVal.c_str(), clientIdVal);

		const std::string jobIdStrVal =
			thisXml->findRequiredAttribute("jobId");
		UUID jobIdVal = CAFCOMMON_GUID_NULL;
		BasePlatform::UuidFromString(jobIdStrVal.c_str(), jobIdVal);

		const std::string providerNamespaceStrVal =
			thisXml->findRequiredAttribute("providerNamespace");
		const std::string providerNamespaceVal = providerNamespaceStrVal;

		const std::string providerNameStrVal =
			thisXml->findRequiredAttribute("providerName");
		const std::string providerNameVal = providerNameStrVal;

		const std::string providerVersionStrVal =
			thisXml->findRequiredAttribute("providerVersion");
		const std::string providerVersionVal = providerVersionStrVal;

		const std::string packageOSTypeStrVal =
			thisXml->findRequiredAttribute("packageOSType");
		PACKAGE_OS_TYPE packageOSTypeVal = PACKAGE_OS_NONE;
		if (! packageOSTypeStrVal.empty()) {
			packageOSTypeVal = EnumConvertersXml::convertStringToPackageOSType(packageOSTypeStrVal);
		}

		const SmartPtrCXmlElement packageCollectionXml =
			thisXml->findRequiredChild("packageCollection");
		const CXmlElement::SmartPtrCElementCollection packageValChildrenXml =
				packageCollectionXml->findRequiredChildren("package");

		std::deque<SmartPtrCFullPackageElemDoc> packageValVal;
		if (! packageValChildrenXml.IsNull() && ! packageValChildrenXml->empty()) {
			for (TConstIterator<CXmlElement::CElementCollection> packageValXmlIter(*packageValChildrenXml);
				packageValXmlIter; packageValXmlIter++) {
				const SmartPtrCXmlElement packageValXml = packageValXmlIter->second;
				const SmartPtrCFullPackageElemDoc packageValDoc =
					FullPackageElemXml::parse(packageValXml);
				packageValVal.push_back(packageValDoc);
			}
		}

		installProviderJobDoc.CreateInstance();
		installProviderJobDoc->initialize(
			clientIdVal,
			jobIdVal,
			providerNamespaceVal,
			providerNameVal,
			providerVersionVal,
			packageOSTypeVal,
			packageValVal);
	}
	CAF_CM_EXIT;

	return installProviderJobDoc;
}

