/*
 * Copyright (C) 2011 Google Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

// Export NetworkSimulator for use by other unittests.
function NetworkSimulator()
{
    this._pendingPromises = [];
};

NetworkSimulator.prototype.schedulePromise = function(promise) {
    this._pendingPromises.push(promise);
    return promise;
};

NetworkSimulator.prototype.resolvePromises = function() {
    var self = this;
    return new Promise(function(resolve, reject) {
        var pendingPromises = self._pendingPromises;
        self._pendingPromises = [];
        function all_resolved (results) {
            if (self._pendingPromises.length) {
                resolve(self.resolvePromises());
                return;
            }
            resolve(results);
        }
        Promise.all(pendingPromises).then(all_resolved, all_resolved);
    });
};

NetworkSimulator.prototype.runTest = function(testCase)
{
    var self = this;
    var realNet = window.net;
    return new Promise(function(resolve, reject) {

        // All net.* methods should return promises. This watches all
        // promises generated by test-overridden methods.
        window.net = {};
        ['probe', 'jsonp', 'get', 'post',
         'ajax', 'json', 'xml'].forEach(function(method) {
             if (method in self) {
                 net[method] = function() {
                     return self.schedulePromise(self[method].apply(self, arguments));
                 };
             };
         });

        testCase();
        self.resolvePromises().then(function() {
            window.net = realNet;
            equal(window.net, realNet);
            resolve();
        }).catch(function(e) {
            ok(false, "Failed to finish test: " + e);
        });
    });
};

(function () {

module("net");

// No unit tests yet!

})();
