%{
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <assert.h>
#include <crm/crm.h>
#include <stonithd-config.h>
#include <standalone_config.h>

/* Some distributions can't use the output from flex without help */
#ifndef ECHO
#  define ECHO if(fwrite( yytext, yyleng, 1, yyout ))
#endif

int _line_count = 1;

static void
_unescape(char *val)
{
	size_t x,y;
	int e = 0;

	y = strlen(val);
	for (x = 0; x < y; x++) {
		if (e == 1) {
			if (val[x] == '"') {
				memmove(&val[x-1], &val[x], y-x);
				--y;
				--x;
			}
			e = 0;
		}
		if (val[x] == '\\') {
			e = 1;
		}
	}
	val[y] = 0;
}

%}
%%
"\\\n" {
	++_line_count;
}

[\n] {
	++_line_count;
	return T_ENDL;
}

[ \t]* {}

\#[^\n]* {}

^"device" {
	return T_DEVICE;
}

^"options" {
	return T_OPTIONS;
}

^"priority" {
	return T_PRIO;
}

^"ports" {
	return T_PORTMAP;
}

^"unfence" {
	return T_UNFENCE;
}

"=" {
	return T_EQ;
}

[^ &\|!\t\(\){},;=\"\n\[\]]+ {
	yylval.sval = crm_strdup(yytext);
	return T_VAL;
}

\"(\\\"|[^\"])+\" {
	yylval.sval = crm_strdup(yytext+1);
	yylval.sval[strlen(yytext)-2] = 0;
	/* unescape backslash-quote to be quotes */
	_unescape(yylval.sval);
	return T_VAL;
}

\"\" {
	yylval.sval = NULL;
	return T_VAL;
}

%%

int
yywrap(void)
{
	/* This if block that is never executed is here to
	 * get rid of some compile warnings about
	 * unused autogenerated functions. Probably
	 * not the best solution... but a solution...
	 * unless the compiler optimizes it away and complains
	 * again.  It may be possible to execute some sed
	 * magic to remove the code from the autogenerated .c
	 * file before compile time if this doesn't hold up.*/
	if (0) {
		yyunput(1, NULL);
		input();
	}

	return 1;
}

