/*
 * Copyright 2006-2021 the Pacemaker project contributors
 *
 * The version control history for this file may have further details.
 *
 * This source code is licensed under the GNU Lesser General Public License
 * version 2.1 or later (LGPLv2.1+) WITHOUT ANY WARRANTY.
 */

#ifndef DOXYGEN__H
#  define DOXYGEN__H

/**
 * \file
 * \brief Fake header file that contains doxygen documentation.
 * \author the Pacemaker project contributors
 *
 * The purpose of this file is to provide a file that can be used to create
 * doxygen pages.  It should contain _only_ comment blocks.
 *
 *
 * \defgroup core Core API
 * \defgroup date ISO-8601 Date/Time API
 * \defgroup cib Configuration API
 * \defgroup lrmd Executor API
 * \defgroup pengine Scheduler API
 * \defgroup fencing Fencing API
 * \defgroup pacemaker Pacemaker High-Level API
 */

/**
 * \mainpage
 * Welcome to the developer documentation for The Pacemaker Project!  For more
 * information about Pacemaker, please visit the
 * <a href="https://clusterlabs.org/pacemaker/">project web site</a>.
 *
 * Here are some pointers on where to go from here.
 *
 * Using Pacemaker APIs:
 *  - \ref core
 *  - \ref date
 *  - \ref cib
 *  - \ref lrmd
 *  - \ref pengine
 *  - \ref fencing
 *  - \ref pacemaker
 *
 * Contributing to the Pacemaker Project:
 * - <a
 *   href="https://clusterlabs.org/pacemaker/doc/2.1/Pacemaker_Development/html/">Pacemaker Development</a>
 */

#endif                          /* DOXYGEN__H */
