#!/bin/sh
set -o errexit

###
# Copyright (c) 2015-2021, Antoine Le Gonidec <vv221@dotslashplay.it>
# Copyright (c) 2016-2021, Mopi
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright notice,
# this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright notice,
# this list of conditions and the following disclaimer in the documentation
# and/or other materials provided with the distribution.
#
# This software is provided by the copyright holders and contributors "as is"
# and any express or implied warranties, including, but not limited to, the
# implied warranties of merchantability and fitness for a particular purpose
# are disclaimed. In no event shall the copyright holder or contributors be
# liable for any direct, indirect, incidental, special, exemplary, or
# consequential damages (including, but not limited to, procurement of
# substitute goods or services; loss of use, data, or profits; or business
# interruption) however caused and on any theory of liability, whether in
# contract, strict liability, or tort (including negligence or otherwise)
# arising in any way out of the use of this software, even if advised of the
# possibility of such damage.
###

###
# Nihilumbra
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20210527.7

# Set game-specific variables

GAME_ID='nihilumbra'
GAME_NAME='Nihilumbra'

ARCHIVE_BASE_32BIT_0='Nihilumbra-1.35-linux32.tar.gz'
ARCHIVE_BASE_32BIT_0_MD5='24ba59112bdb95b05651ebe48ec5882d'
ARCHIVE_BASE_32BIT_0_SIZE='2400000'
ARCHIVE_BASE_32BIT_0_VERSION='1.35-humble150122'
ARCHIVE_BASE_32BIT_0_URL='https://www.humblebundle.com/store/nihilumbra'

ARCHIVE_BASE_64BIT_0='Nihilumbra-1.35-linux64.tar.gz'
ARCHIVE_BASE_64BIT_0_MD5='18aa096020cedea4f208ca55f7e5c85f'
ARCHIVE_BASE_64BIT_0_SIZE='2400000'
ARCHIVE_BASE_64BIT_0_VERSION='1.35-humble150122'
ARCHIVE_BASE_64BIT_0_URL='https://www.humblebundle.com/store/nihilumbra'

ARCHIVE_GAME_BIN_PATH_32BIT='Nihilumbra-1.35-linux32'
ARCHIVE_GAME_BIN_PATH_64BIT='Nihilumbra-1.35-linux64'
ARCHIVE_GAME_BIN_FILES='Nihilumbra Nihilumbra_Data/Mono Nihilumbra_Data/Plugins'

ARCHIVE_GAME_DATA_PATH_32BIT='Nihilumbra-1.35-linux32'
ARCHIVE_GAME_DATA_PATH_64BIT='Nihilumbra-1.35-linux64'
ARCHIVE_GAME_DATA_FILES='icon*.png icon*.xpm Nihilumbra_Data'

APP_MAIN_TYPE='native'
APP_MAIN_EXE='Nihilumbra'
APP_MAIN_ICONS_LIST='APP_MAIN_ICON_32 APP_MAIN_ICON_48_PNG APP_MAIN_ICON_48_XPM APP_MAIN_ICON_64 APP_MAIN_ICON_128'
APP_MAIN_ICON_32='icon32x32.png'
APP_MAIN_ICON_48_PNG='icon48x48.png'
APP_MAIN_ICON_48_XPM='icon48x48.xpm'
APP_MAIN_ICON_64='icon64x64.png'
APP_MAIN_ICON_128='icon128x128.png'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH_32BIT='32'
PKG_BIN_ARCH_64BIT='64'
PKG_BIN_DEPS="${PKG_DATA_ID} glibc libstdc++ glx xcursor libxrandr gtk2 freetype libGLU.so.1 libX11.so.6"

# Use a per-session dedicated file for logs

APP_MAIN_PRERUN="$APP_MAIN_PRERUN"'

# Use a per-session dedicated file for logs
mkdir --parents logs
APP_OPTIONS="${APP_OPTIONS} -logFile ./logs/$(date +%F-%R).log"'

# Work around Unity3D poor support for non-US locales

APP_MAIN_PRERUN="$APP_MAIN_PRERUN"'

# Work around Unity3D poor support for non-US locales
export LANG=C'

# Load common functions

target_version='2.14'

if [ -z "$PLAYIT_LIB2" ]; then
	for path in \
		"$PWD" \
		"${XDG_DATA_HOME:="$HOME/.local/share"}/play.it" \
		'/usr/local/share/games/play.it' \
		'/usr/local/share/play.it' \
		'/usr/share/games/play.it' \
		'/usr/share/play.it'
	do
		if [ -e "${path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=play.it-2/lib/libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
set_standard_permissions "${PLAYIT_WORKDIR}/gamedata"
prepare_package_layout

# Get game icon

PKG='PKG_DATA'
icons_get_from_package 'APP_MAIN'

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
