#!/bin/sh
set -o errexit
set -o nounset

# Copy installed files from the system
mkdir --parents \
	"$AUTOPKGTEST_TMP/lib" \
	"$AUTOPKGTEST_TMP/man/man6" \
	"$AUTOPKGTEST_TMP/man/fr/man6"
cp /usr/share/games/play.it/libplayit2.sh "$AUTOPKGTEST_TMP/lib"
cp /usr/games/play.it "$AUTOPKGTEST_TMP"
gunzip --to-stdout --keep /usr/share/man/man6/play.it.6.gz > "$AUTOPKGTEST_TMP/man/man6/play.it.6"
gunzip --to-stdout --keep /usr/share/man/fr/man6/play.it.6.gz > "$AUTOPKGTEST_TMP/man/fr/man6/play.it.6"

# Copy test scripts from the source tree
cp Makefile "$AUTOPKGTEST_TMP"
cp --recursive tests "$AUTOPKGTEST_TMP"

# Prevent the Makefile from trying to rebuild the library and man pages
## TODO: Thes forced rebuilds should probably be dropped upstream
sed --in-place 's#^shellcheck-library: lib/libplayit2.sh$#shellcheck-library:#' "$AUTOPKGTEST_TMP/Makefile"
sed --in-place 's#^man-syntax: man/man6/play.it.6 man/fr/man6/play.it.6$#man-syntax:#' "$AUTOPKGTEST_TMP/Makefile"

# Copy the changelog as the Makefile use it to set a variable (unused in these tests)
## TODO: The Makefile should be updated upstream to only set this variable when required
cp CHANGELOG "$AUTOPKGTEST_TMP"

# Copy the source tree, as it is expected by the shunit2 coverage test
## TODO: This coverage test has no real value, and should probably be dropped upstream
cp --recursive src "$AUTOPKGTEST_TMP"

# Run the tests
cd "$AUTOPKGTEST_TMP"
make check

exit 0
