/*
 * SPDX-FileCopyrightText: Copyright (c) NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef G_NV_NAME_RELEASED_H
#define G_NV_NAME_RELEASED_H

typedef struct _CHIPS_RELEASED {
    unsigned short devID;
    unsigned short subSystemID;
    unsigned short subSystemVendorID;
    const char *name;
} CHIPS_RELEASED;

static const CHIPS_RELEASED sChipsReleased[] = {
    { 0x0040, 0x0205, 0x10de, "(null)" },
    { 0x0091, 0x02c2, 0x10de, "(null)" },
    { 0x00C1, 0x0335, 0x1043, "(null)" },
    { 0x00F9, 0x0334, 0x1043, "(null)" },
    { 0x00F9, 0x0338, 0x1043, "(null)" },
    { 0x0141, 0x0330, 0x1043, "(null)" },
    { 0x0141, 0x0331, 0x1043, "(null)" },
    { 0x0141, 0x9812, 0x1462, "(null)" },
    { 0x0141, 0x9814, 0x1462, "(null)" },
    { 0x0141, 0x3466, 0x1642, "(null)" },
    { 0x0161, 0x02b3, 0x10de, "(null)" },
    { 0x0161, 0x0013, 0x1462, "(null)" },
    { 0x0161, 0x0014, 0x1462, "(null)" },
    { 0x0161, 0x9915, 0x1462, "(null)" },
    { 0x0161, 0x9916, 0x1462, "(null)" },
    { 0x0161, 0x3493, 0x1642, "(null)" },
    { 0x0162, 0x0345, 0x1043, "(null)" },
    { 0x0165, 0x029d, 0x10de, "(null)" },
    { 0x0165, 0x0334, 0x10de, "(null)" },
    { 0x016A, 0x3432, 0x1458, "(null)" },
    { 0x016A, 0x034e, 0x1462, "(null)" },
    { 0x016A, 0x3598, 0x1642, "(null)" },
    { 0x0191, 0x039c, 0x10de, "(null)" },
    { 0x0193, 0x0420, 0x10de, "(null)" },
    { 0x0193, 0x0421, 0x10de, "(null)" },
    { 0x01D1, 0x0394, 0x10de, "(null)" },
    { 0x01D1, 0x342c, 0x1458, "(null)" },
    { 0x01D1, 0x3436, 0x1458, "(null)" },
    { 0x01D1, 0x0344, 0x1462, "(null)" },
    { 0x01D1, 0x0345, 0x1462, "(null)" },
    { 0x01D1, 0x0850, 0x1462, "(null)" },
    { 0x01D1, 0x3598, 0x1642, "(null)" },
    { 0x01D1, 0x3680, 0x1642, "(null)" },
    { 0x01D3, 0x034c, 0x1462, "(null)" },
    { 0x01D3, 0x034d, 0x1462, "(null)" },
    { 0x01D3, 0x1010, 0x174b, "(null)" },
    { 0x01D3, 0x1110, 0x174b, "(null)" },
    { 0x01D3, 0x1120, 0x174b, "(null)" },
    { 0x01D3, 0x1210, 0x174b, "(null)" },
    { 0x0242, 0x1014, 0x17aa, "(null)" },
    { 0x0242, 0x1017, 0x17aa, "(null)" },
    { 0x0242, 0x3013, 0x17aa, "(null)" },
    { 0x0242, 0x1019, 0x1b46, "(null)" },
    { 0x0290, 0x0343, 0x10de, "(null)" },
    { 0x0294, 0x035b, 0x10de, "(null)" },
    { 0x0391, 0x033d, 0x10de, "(null)" },
    { 0x0391, 0x0403, 0x10de, "(null)" },
    { 0x0392, 0x034c, 0x1043, "(null)" },
    { 0x0392, 0x034a, 0x10de, "(null)" },
    { 0x0400, 0x0438, 0x10de, "(null)" },
    { 0x0402, 0x1713, 0x1019, "(null)" },
    { 0x0402, 0x034d, 0x1043, "(null)" },
    { 0x0402, 0x034e, 0x1043, "(null)" },
    { 0x0402, 0x0439, 0x10de, "(null)" },
    { 0x0402, 0x0505, 0x10de, "(null)" },
    { 0x0402, 0x806b, 0x144d, "(null)" },
    { 0x0402, 0x806c, 0x144d, "(null)" },
    { 0x0405, 0x011d, 0x1025, "(null)" },
    { 0x0405, 0x011e, 0x1025, "(null)" },
    { 0x0405, 0x0121, 0x1025, "(null)" },
    { 0x0405, 0x0125, 0x1025, "(null)" },
    { 0x0405, 0x0126, 0x1025, "(null)" },
    { 0x0405, 0x0127, 0x1025, "(null)" },
    { 0x0405, 0x0129, 0x1025, "(null)" },
    { 0x0405, 0x012b, 0x1025, "(null)" },
    { 0x0405, 0x0136, 0x1025, "(null)" },
    { 0x0405, 0x013d, 0x1025, "(null)" },
    { 0x0405, 0x013f, 0x1025, "(null)" },
    { 0x0405, 0x0142, 0x1025, "(null)" },
    { 0x0405, 0x0143, 0x1025, "(null)" },
    { 0x0405, 0x0145, 0x1025, "(null)" },
    { 0x0405, 0x0146, 0x1025, "(null)" },
    { 0x0405, 0x015e, 0x1025, "(null)" },
    { 0x0405, 0x15d2, 0x1043, "(null)" },
    { 0x0405, 0x1634, 0x1043, "(null)" },
    { 0x0405, 0x8227, 0x1071, "(null)" },
    { 0x0405, 0x8230, 0x1071, "(null)" },
    { 0x0405, 0x6740, 0x1462, "(null)" },
    { 0x0406, 0x30f4, 0x103c, "(null)" },
    { 0x0406, 0x3603, 0x103c, "(null)" },
    { 0x0407, 0x22d4, 0x1019, "(null)" },
    { 0x0407, 0x011d, 0x1025, "(null)" },
    { 0x0407, 0x011e, 0x1025, "(null)" },
    { 0x0407, 0x0121, 0x1025, "(null)" },
    { 0x0407, 0x0125, 0x1025, "(null)" },
    { 0x0407, 0x0126, 0x1025, "(null)" },
    { 0x0407, 0x0127, 0x1025, "(null)" },
    { 0x0407, 0x0129, 0x1025, "(null)" },
    { 0x0407, 0x012b, 0x1025, "(null)" },
    { 0x0407, 0x0136, 0x1025, "(null)" },
    { 0x0407, 0x013d, 0x1025, "(null)" },
    { 0x0407, 0x013f, 0x1025, "(null)" },
    { 0x0407, 0x0142, 0x1025, "(null)" },
    { 0x0407, 0x0143, 0x1025, "(null)" },
    { 0x0407, 0x0145, 0x1025, "(null)" },
    { 0x0407, 0x0146, 0x1025, "(null)" },
    { 0x0407, 0x015e, 0x1025, "(null)" },
    { 0x0407, 0x019c, 0x1028, "(null)" },
    { 0x0407, 0x01f1, 0x1028, "(null)" },
    { 0x0407, 0x01f2, 0x1028, "(null)" },
    { 0x0407, 0x0228, 0x1028, "(null)" },
    { 0x0407, 0x0229, 0x1028, "(null)" },
    { 0x0407, 0x022e, 0x1028, "(null)" },
    { 0x0407, 0x1515, 0x1043, "(null)" },
    { 0x0407, 0x1588, 0x1043, "(null)" },
    { 0x0407, 0x1618, 0x1043, "(null)" },
    { 0x0407, 0x1632, 0x1043, "(null)" },
    { 0x0407, 0x17a2, 0x1043, "(null)" },
    { 0x0407, 0x9005, 0x104d, "(null)" },
    { 0x0407, 0x9016, 0x104d, "(null)" },
    { 0x0407, 0x9018, 0x104d, "(null)" },
    { 0x0407, 0x00a0, 0x106b, "(null)" },
    { 0x0407, 0x00a3, 0x106b, "(null)" },
    { 0x0407, 0x00a4, 0x106b, "(null)" },
    { 0x0407, 0x8049, 0x107b, "(null)" },
    { 0x0407, 0x3c04, 0x109f, "(null)" },
    { 0x0407, 0x0040, 0x1170, "(null)" },
    { 0x0407, 0x0001, 0x1179, "(null)" },
    { 0x0407, 0xff00, 0x1179, "(null)" },
    { 0x0407, 0xff10, 0x1179, "(null)" },
    { 0x0407, 0xff13, 0x1179, "(null)" },
    { 0x0407, 0xc02f, 0x144d, "(null)" },
    { 0x0407, 0xc030, 0x144d, "(null)" },
    { 0x0407, 0xc031, 0x144d, "(null)" },
    { 0x0407, 0xc519, 0x144d, "(null)" },
    { 0x0407, 0x3fad, 0x1462, "(null)" },
    { 0x0407, 0x3fbb, 0x1462, "(null)" },
    { 0x0407, 0x3fe9, 0x1462, "(null)" },
    { 0x0407, 0x401b, 0x1462, "(null)" },
    { 0x0407, 0x4327, 0x1462, "(null)" },
    { 0x0407, 0x63f2, 0x1462, "(null)" },
    { 0x0407, 0x0023, 0x14c0, "(null)" },
    { 0x0407, 0x0025, 0x14c0, "(null)" },
    { 0x0407, 0x0770, 0x152d, "(null)" },
    { 0x0407, 0x0573, 0x1558, "(null)" },
    { 0x0407, 0x2200, 0x1558, "(null)" },
    { 0x0407, 0x2201, 0x1558, "(null)" },
    { 0x0407, 0x22d4, 0x1584, "(null)" },
    { 0x0407, 0xc20d, 0x1631, "(null)" },
    { 0x0407, 0xc20e, 0x1631, "(null)" },
    { 0x0407, 0x3d7b, 0x17aa, "(null)" },
    { 0x0407, 0x2089, 0x17c0, "(null)" },
    { 0x0407, 0x208a, 0x17c0, "(null)" },
    { 0x0407, 0x0801, 0x17ff, "(null)" },
    { 0x0407, 0x0091, 0x1854, "(null)" },
    { 0x0407, 0x0115, 0x1854, "(null)" },
    { 0x0407, 0x0116, 0x1854, "(null)" },
    { 0x0407, 0x0117, 0x1854, "(null)" },
    { 0x0407, 0x0118, 0x1854, "(null)" },
    { 0x0407, 0x0119, 0x1854, "(null)" },
    { 0x0407, 0x011a, 0x1854, "(null)" },
    { 0x0407, 0x1402, 0x1a46, "(null)" },
    { 0x0407, 0x0284, 0x1a92, "(null)" },
    { 0x0408, 0x0145, 0x1025, "(null)" },
    { 0x0408, 0x30f4, 0x103c, "(null)" },
    { 0x0408, 0x1902, 0x1043, "(null)" },
    { 0x0409, 0x0145, 0x1025, "(null)" },
    { 0x0409, 0x0146, 0x1025, "(null)" },
    { 0x0409, 0x019b, 0x1028, "(null)" },
    { 0x0409, 0x019c, 0x1028, "(null)" },
    { 0x0409, 0x01f1, 0x1028, "(null)" },
    { 0x0409, 0x1584, 0x1043, "(null)" },
    { 0x0409, 0x1619, 0x1043, "(null)" },
    { 0x0409, 0x16d2, 0x1043, "(null)" },
    { 0x0409, 0x1832, 0x1043, "(null)" },
    { 0x0409, 0xff00, 0x1179, "(null)" },
    { 0x0409, 0x0770, 0x152d, "(null)" },
    { 0x0409, 0x0573, 0x1558, "(null)" },
    { 0x0409, 0x0860, 0x1558, "(null)" },
    { 0x0409, 0x0902, 0x1558, "(null)" },
    { 0x0409, 0x2052, 0x161f, "(null)" },
    { 0x040B, 0x30c3, 0x103c, "(null)" },
    { 0x040C, 0x30c5, 0x103c, "(null)" },
    { 0x040C, 0x1423, 0x10cf, "(null)" },
    { 0x040C, 0x20d9, 0x17aa, "(null)" },
    { 0x040D, 0x019b, 0x1028, "(null)" },
    { 0x040D, 0x30c3, 0x103c, "(null)" },
    { 0x040D, 0x0770, 0x152d, "(null)" },
    { 0x040D, 0x0481, 0x1558, "(null)" },
    { 0x040D, 0x0573, 0x1558, "(null)" },
    { 0x040D, 0x0860, 0x1558, "(null)" },
    { 0x040D, 0x0902, 0x1558, "(null)" },
    { 0x040D, 0x2052, 0x161f, "(null)" },
    { 0x0410, 0x3058, 0x174b, "(null)" },
    { 0x0410, 0x9076, 0x1b0a, "(null)" },
    { 0x0421, 0x8069, 0x144d, "(null)" },
    { 0x0421, 0x806a, 0x144d, "(null)" },
    { 0x0421, 0x8072, 0x144d, "(null)" },
    { 0x0421, 0x0198, 0x1620, "(null)" },
    { 0x0422, 0x8873, 0x1033, "(null)" },
    { 0x0422, 0x88b7, 0x1033, "(null)" },
    { 0x0423, 0x806f, 0x144d, "(null)" },
    { 0x0423, 0x8070, 0x144d, "(null)" },
    { 0x0423, 0x8071, 0x144d, "(null)" },
    { 0x0423, 0x0199, 0x1620, "(null)" },
    { 0x0425, 0x22d0, 0x1019, "(null)" },
    { 0x0425, 0x011d, 0x1025, "(null)" },
    { 0x0425, 0x011e, 0x1025, "(null)" },
    { 0x0425, 0x011f, 0x1025, "(null)" },
    { 0x0425, 0x0121, 0x1025, "(null)" },
    { 0x0425, 0x0125, 0x1025, "(null)" },
    { 0x0425, 0x0126, 0x1025, "(null)" },
    { 0x0425, 0x0127, 0x1025, "(null)" },
    { 0x0425, 0x0129, 0x1025, "(null)" },
    { 0x0425, 0x012b, 0x1025, "(null)" },
    { 0x0425, 0x0136, 0x1025, "(null)" },
    { 0x0425, 0x013d, 0x1025, "(null)" },
    { 0x0425, 0x0142, 0x1025, "(null)" },
    { 0x0425, 0x0143, 0x1025, "(null)" },
    { 0x0425, 0x0145, 0x1025, "(null)" },
    { 0x0425, 0x0146, 0x1025, "(null)" },
    { 0x0425, 0x0275, 0x1028, "(null)" },
    { 0x0425, 0x8875, 0x1033, "(null)" },
    { 0x0425, 0x30cc, 0x103c, "(null)" },
    { 0x0425, 0x1514, 0x1043, "(null)" },
    { 0x0425, 0x1612, 0x1043, "(null)" },
    { 0x0425, 0x1617, 0x1043, "(null)" },
    { 0x0425, 0x826c, 0x1043, "(null)" },
    { 0x0425, 0x9005, 0x104d, "(null)" },
    { 0x0425, 0x8227, 0x1071, "(null)" },
    { 0x0425, 0x8253, 0x1071, "(null)" },
    { 0x0425, 0x0040, 0x1170, "(null)" },
    { 0x0425, 0xc02f, 0x144d, "(null)" },
    { 0x0425, 0xc030, 0x144d, "(null)" },
    { 0x0425, 0xc031, 0x144d, "(null)" },
    { 0x0425, 0xc509, 0x144d, "(null)" },
    { 0x0425, 0xc519, 0x144d, "(null)" },
    { 0x0425, 0x3fad, 0x1462, "(null)" },
    { 0x0425, 0x3fbb, 0x1462, "(null)" },
    { 0x0425, 0x3fe9, 0x1462, "(null)" },
    { 0x0425, 0x401b, 0x1462, "(null)" },
    { 0x0425, 0x4327, 0x1462, "(null)" },
    { 0x0425, 0x2f03, 0x1509, "(null)" },
    { 0x0425, 0x2f04, 0x1509, "(null)" },
    { 0x0425, 0x2f05, 0x1509, "(null)" },
    { 0x0425, 0xc104, 0x1631, "(null)" },
    { 0x0425, 0xc105, 0x1631, "(null)" },
    { 0x0425, 0x1107, 0x1734, "(null)" },
    { 0x0425, 0x110b, 0x1734, "(null)" },
    { 0x0425, 0x110c, 0x1734, "(null)" },
    { 0x0425, 0x2089, 0x17c0, "(null)" },
    { 0x0425, 0x0590, 0x17ff, "(null)" },
    { 0x0425, 0x0090, 0x1854, "(null)" },
    { 0x0425, 0x0094, 0x1854, "(null)" },
    { 0x0425, 0x0098, 0x1854, "(null)" },
    { 0x0425, 0x009f, 0x1854, "(null)" },
    { 0x0425, 0x0106, 0x1854, "(null)" },
    { 0x0425, 0x0109, 0x1854, "(null)" },
    { 0x0425, 0x0115, 0x1854, "(null)" },
    { 0x0425, 0x0116, 0x1854, "(null)" },
    { 0x0425, 0x0117, 0x1854, "(null)" },
    { 0x0425, 0x0118, 0x1854, "(null)" },
    { 0x0425, 0x0119, 0x1854, "(null)" },
    { 0x0425, 0x011a, 0x1854, "(null)" },
    { 0x0425, 0x0120, 0x1854, "(null)" },
    { 0x0426, 0x8897, 0x1033, "(null)" },
    { 0x0426, 0x9005, 0x104d, "(null)" },
    { 0x0426, 0x9016, 0x104d, "(null)" },
    { 0x0426, 0x9017, 0x104d, "(null)" },
    { 0x0426, 0x9018, 0x104d, "(null)" },
    { 0x0426, 0x902d, 0x104d, "(null)" },
    { 0x0426, 0x9030, 0x104d, "(null)" },
    { 0x0426, 0x5584, 0x1991, "(null)" },
    { 0x0427, 0x011d, 0x1025, "(null)" },
    { 0x0427, 0x011e, 0x1025, "(null)" },
    { 0x0427, 0x011f, 0x1025, "(null)" },
    { 0x0427, 0x0121, 0x1025, "(null)" },
    { 0x0427, 0x0125, 0x1025, "(null)" },
    { 0x0427, 0x0126, 0x1025, "(null)" },
    { 0x0427, 0x0127, 0x1025, "(null)" },
    { 0x0427, 0x0129, 0x1025, "(null)" },
    { 0x0427, 0x012b, 0x1025, "(null)" },
    { 0x0427, 0x0136, 0x1025, "(null)" },
    { 0x0427, 0x013d, 0x1025, "(null)" },
    { 0x0427, 0x0142, 0x1025, "(null)" },
    { 0x0427, 0x0143, 0x1025, "(null)" },
    { 0x0427, 0x01f1, 0x1028, "(null)" },
    { 0x0427, 0x01f2, 0x1028, "(null)" },
    { 0x0427, 0x01f3, 0x1028, "(null)" },
    { 0x0427, 0x0209, 0x1028, "(null)" },
    { 0x0427, 0x020a, 0x1028, "(null)" },
    { 0x0427, 0x0227, 0x1028, "(null)" },
    { 0x0427, 0x0228, 0x1028, "(null)" },
    { 0x0427, 0x0229, 0x1028, "(null)" },
    { 0x0427, 0x022e, 0x1028, "(null)" },
    { 0x0427, 0x026f, 0x1028, "(null)" },
    { 0x0427, 0x0273, 0x1028, "(null)" },
    { 0x0427, 0x0286, 0x1028, "(null)" },
    { 0x0427, 0x02b5, 0x1028, "(null)" },
    { 0x0427, 0x30cc, 0x103c, "(null)" },
    { 0x0427, 0x30cd, 0x103c, "(null)" },
    { 0x0427, 0x30cf, 0x103c, "(null)" },
    { 0x0427, 0x30de, 0x103c, "(null)" },
    { 0x0427, 0x17c2, 0x1043, "(null)" },
    { 0x0427, 0x9008, 0x104d, "(null)" },
    { 0x0427, 0x3c03, 0x109f, "(null)" },
    { 0x0427, 0xff10, 0x1179, "(null)" },
    { 0x0427, 0xff13, 0x1179, "(null)" },
    { 0x0427, 0x8068, 0x144d, "(null)" },
    { 0x0427, 0xb04b, 0x144d, "(null)" },
    { 0x0427, 0xc02f, 0x144d, "(null)" },
    { 0x0427, 0xc030, 0x144d, "(null)" },
    { 0x0427, 0xc031, 0x144d, "(null)" },
    { 0x0427, 0xc509, 0x144d, "(null)" },
    { 0x0427, 0xc510, 0x144d, "(null)" },
    { 0x0427, 0xc519, 0x144d, "(null)" },
    { 0x0427, 0x3fe9, 0x1462, "(null)" },
    { 0x0427, 0x401b, 0x1462, "(null)" },
    { 0x0427, 0x4327, 0x1462, "(null)" },
    { 0x0427, 0x0023, 0x14c0, "(null)" },
    { 0x0427, 0x0025, 0x14c0, "(null)" },
    { 0x0427, 0xa00e, 0x14ff, "(null)" },
    { 0x0427, 0x2f04, 0x1509, "(null)" },
    { 0x0427, 0x0763, 0x152d, "(null)" },
    { 0x0427, 0x110b, 0x1734, "(null)" },
    { 0x0427, 0x3862, 0x17aa, "(null)" },
    { 0x0427, 0x39f5, 0x17aa, "(null)" },
    { 0x0427, 0x3d7a, 0x17aa, "(null)" },
    { 0x0427, 0x400c, 0x17aa, "(null)" },
    { 0x0427, 0x208a, 0x17c0, "(null)" },
    { 0x0427, 0x0092, 0x1854, "(null)" },
    { 0x0427, 0x0093, 0x1854, "(null)" },
    { 0x0427, 0x0097, 0x1854, "(null)" },
    { 0x0427, 0x0100, 0x1854, "(null)" },
    { 0x0427, 0x0109, 0x1854, "(null)" },
    { 0x0427, 0x011f, 0x1854, "(null)" },
    { 0x0427, 0x0125, 0x1854, "(null)" },
    { 0x0427, 0x0129, 0x1854, "(null)" },
    { 0x0427, 0x012a, 0x1854, "(null)" },
    { 0x0427, 0x012d, 0x1854, "(null)" },
    { 0x0427, 0x012e, 0x1854, "(null)" },
    { 0x0427, 0xa002, 0x1940, "(null)" },
    { 0x0427, 0x4605, 0x1961, "(null)" },
    { 0x0427, 0x5584, 0x1991, "(null)" },
    { 0x0427, 0x1402, 0x1a46, "(null)" },
    { 0x0428, 0x011d, 0x1025, "(null)" },
    { 0x0428, 0x011e, 0x1025, "(null)" },
    { 0x0428, 0x011f, 0x1025, "(null)" },
    { 0x0428, 0x0121, 0x1025, "(null)" },
    { 0x0428, 0x0125, 0x1025, "(null)" },
    { 0x0428, 0x0126, 0x1025, "(null)" },
    { 0x0428, 0x0127, 0x1025, "(null)" },
    { 0x0428, 0x0129, 0x1025, "(null)" },
    { 0x0428, 0x012b, 0x1025, "(null)" },
    { 0x0428, 0x0136, 0x1025, "(null)" },
    { 0x0428, 0x013d, 0x1025, "(null)" },
    { 0x0428, 0x0142, 0x1025, "(null)" },
    { 0x0428, 0x0143, 0x1025, "(null)" },
    { 0x0428, 0x019b, 0x1028, "(null)" },
    { 0x0428, 0x01f1, 0x1028, "(null)" },
    { 0x0428, 0x01f2, 0x1028, "(null)" },
    { 0x0428, 0x020a, 0x1028, "(null)" },
    { 0x0428, 0x1513, 0x1043, "(null)" },
    { 0x0428, 0x1616, 0x1043, "(null)" },
    { 0x0428, 0x8265, 0x1043, "(null)" },
    { 0x0428, 0xa015, 0x1071, "(null)" },
    { 0x0428, 0x1422, 0x10cf, "(null)" },
    { 0x0428, 0x0001, 0x1179, "(null)" },
    { 0x0428, 0x0002, 0x1179, "(null)" },
    { 0x0428, 0xc510, 0x144d, "(null)" },
    { 0x0428, 0x3fad, 0x1462, "(null)" },
    { 0x0428, 0x3fe9, 0x1462, "(null)" },
    { 0x0428, 0x401b, 0x1462, "(null)" },
    { 0x0428, 0x4327, 0x1462, "(null)" },
    { 0x0428, 0x2f04, 0x1509, "(null)" },
    { 0x0428, 0x0663, 0x1558, "(null)" },
    { 0x0428, 0x0668, 0x1558, "(null)" },
    { 0x0428, 0xc103, 0x1631, "(null)" },
    { 0x0428, 0xc20b, 0x1631, "(null)" },
    { 0x0428, 0x110b, 0x1734, "(null)" },
    { 0x0428, 0x3869, 0x17aa, "(null)" },
    { 0x0428, 0x0593, 0x17ff, "(null)" },
    { 0x0428, 0x0800, 0x17ff, "(null)" },
    { 0x0428, 0x009e, 0x1854, "(null)" },
    { 0x0428, 0x010e, 0x1854, "(null)" },
    { 0x0428, 0x010f, 0x1854, "(null)" },
    { 0x0428, 0x0110, 0x1854, "(null)" },
    { 0x0428, 0x0111, 0x1854, "(null)" },
    { 0x0428, 0x0112, 0x1854, "(null)" },
    { 0x0428, 0x0113, 0x1854, "(null)" },
    { 0x0428, 0x0129, 0x1854, "(null)" },
    { 0x0428, 0x012a, 0x1854, "(null)" },
    { 0x0428, 0x012d, 0x1854, "(null)" },
    { 0x0428, 0x012e, 0x1854, "(null)" },
    { 0x0428, 0x4605, 0x1961, "(null)" },
    { 0x0428, 0x5584, 0x1991, "(null)" },
    { 0x0429, 0x01fe, 0x1028, "(null)" },
    { 0x0429, 0x20d8, 0x17aa, "(null)" },
    { 0x042A, 0x0001, 0x1179, "(null)" },
    { 0x042A, 0x0002, 0x1179, "(null)" },
    { 0x042B, 0x019c, 0x1028, "(null)" },
    { 0x042B, 0x01f9, 0x1028, "(null)" },
    { 0x042B, 0x01fe, 0x1028, "(null)" },
    { 0x042D, 0x019b, 0x1028, "(null)" },
    { 0x042D, 0x01ff, 0x1028, "(null)" },
    { 0x042D, 0x024a, 0x1028, "(null)" },
    { 0x042D, 0x024b, 0x1028, "(null)" },
    { 0x042E, 0x011d, 0x1025, "(null)" },
    { 0x042E, 0x011e, 0x1025, "(null)" },
    { 0x042E, 0x011f, 0x1025, "(null)" },
    { 0x042E, 0x0121, 0x1025, "(null)" },
    { 0x042E, 0x0125, 0x1025, "(null)" },
    { 0x042E, 0x0126, 0x1025, "(null)" },
    { 0x042E, 0x0127, 0x1025, "(null)" },
    { 0x042E, 0x0129, 0x1025, "(null)" },
    { 0x042E, 0x012b, 0x1025, "(null)" },
    { 0x042E, 0x0136, 0x1025, "(null)" },
    { 0x042E, 0x013d, 0x1025, "(null)" },
    { 0x042E, 0x013f, 0x1025, "(null)" },
    { 0x042E, 0x0142, 0x1025, "(null)" },
    { 0x042E, 0x0143, 0x1025, "(null)" },
    { 0x042E, 0x0145, 0x1025, "(null)" },
    { 0x042E, 0x0146, 0x1025, "(null)" },
    { 0x042E, 0x17c2, 0x1043, "(null)" },
    { 0x042E, 0x3871, 0x17aa, "(null)" },
    { 0x042E, 0x3872, 0x17aa, "(null)" },
    { 0x042E, 0x3875, 0x17aa, "(null)" },
    { 0x042E, 0x208a, 0x17c0, "(null)" },
    { 0x042F, 0x0492, 0x10de, "(null)" },
    { 0x05E2, 0x0617, 0x10de, "(null)" },
    { 0x05E3, 0x0000, 0x106b, "(null)" },
    { 0x05E7, 0x0595, 0x10de, "(null)" },
    { 0x05E7, 0x066a, 0x10de, "(null)" },
    { 0x05E7, 0x068f, 0x10de, "(null)" },
    { 0x05E7, 0x0697, 0x10de, "(null)" },
    { 0x05E7, 0x0714, 0x10de, "(null)" },
    { 0x05E7, 0x0743, 0x10de, "(null)" },
    { 0x05FE, 0x0000, 0x106b, "(null)" },
    { 0x0601, 0x9008, 0x1043, "(null)" },
    { 0x0601, 0x9017, 0x1b0a, "(null)" },
    { 0x0603, 0x9044, 0x1b0a, "(null)" },
    { 0x0605, 0x0612, 0x10de, "(null)" },
    { 0x0605, 0x062d, 0x10de, "(null)" },
    { 0x0607, 0x0736, 0x10de, "(null)" },
    { 0x0608, 0x019c, 0x1028, "(null)" },
    { 0x0608, 0xff01, 0x1179, "(null)" },
    { 0x0608, 0x0481, 0x1558, "(null)" },
    { 0x0608, 0x207a, 0x161f, "(null)" },
    { 0x0609, 0x019b, 0x1028, "(null)" },
    { 0x0609, 0x30d4, 0x103c, "(null)" },
    { 0x0609, 0x00a7, 0x106b, "(null)" },
    { 0x0609, 0x0690, 0x107b, "(null)" },
    { 0x0609, 0x0121, 0x1170, "(null)" },
    { 0x0609, 0x0770, 0x152d, "(null)" },
    { 0x060A, 0x0161, 0x1025, "(null)" },
    { 0x060A, 0x0235, 0x1025, "(null)" },
    { 0x060A, 0x02a1, 0x1028, "(null)" },
    { 0x060A, 0x2027, 0x1043, "(null)" },
    { 0x060A, 0x0481, 0x1558, "(null)" },
    { 0x060A, 0x0577, 0x1558, "(null)" },
    { 0x060A, 0x0860, 0x1558, "(null)" },
    { 0x060A, 0x0902, 0x1558, "(null)" },
    { 0x060A, 0x0903, 0x1558, "(null)" },
    { 0x060A, 0x7200, 0x1558, "(null)" },
    { 0x060A, 0x8100, 0x1558, "(null)" },
    { 0x060A, 0x8687, 0x1558, "(null)" },
    { 0x060A, 0x8689, 0x1558, "(null)" },
    { 0x060A, 0x9800, 0x1558, "(null)" },
    { 0x060B, 0x019c, 0x1028, "(null)" },
    { 0x060B, 0x1222, 0x1043, "(null)" },
    { 0x060B, 0x0770, 0x152d, "(null)" },
    { 0x060B, 0x0481, 0x1558, "(null)" },
    { 0x060B, 0x0573, 0x1558, "(null)" },
    { 0x060B, 0x0860, 0x1558, "(null)" },
    { 0x060B, 0x0902, 0x1558, "(null)" },
    { 0x060B, 0x207a, 0x161f, "(null)" },
    { 0x060C, 0x0145, 0x1025, "(null)" },
    { 0x060C, 0x0146, 0x1025, "(null)" },
    { 0x060C, 0x019c, 0x1028, "(null)" },
    { 0x060C, 0x1619, 0x1043, "(null)" },
    { 0x060C, 0x1620, 0x1043, "(null)" },
    { 0x060C, 0x16d6, 0x1043, "(null)" },
    { 0x060C, 0x0121, 0x1170, "(null)" },
    { 0x060C, 0x0770, 0x152d, "(null)" },
    { 0x060C, 0x0481, 0x1558, "(null)" },
    { 0x060C, 0x0573, 0x1558, "(null)" },
    { 0x060C, 0x0860, 0x1558, "(null)" },
    { 0x060C, 0x0902, 0x1558, "(null)" },
    { 0x060F, 0x02a1, 0x1028, "(null)" },
    { 0x060F, 0x043a, 0x1028, "(null)" },
    { 0x060F, 0x070a, 0x1462, "(null)" },
    { 0x060F, 0x1062, 0x1462, "(null)" },
    { 0x060F, 0x0053, 0x14c0, "(null)" },
    { 0x060F, 0x0511, 0x1558, "(null)" },
    { 0x060F, 0x0512, 0x1558, "(null)" },
    { 0x060F, 0x0903, 0x1558, "(null)" },
    { 0x060F, 0x7200, 0x1558, "(null)" },
    { 0x060F, 0x8100, 0x1558, "(null)" },
    { 0x060F, 0x8687, 0x1558, "(null)" },
    { 0x060F, 0x8689, 0x1558, "(null)" },
    { 0x0611, 0x053c, 0x10de, "(null)" },
    { 0x0615, 0x1543, 0x1462, "(null)" },
    { 0x0615, 0x2103, 0x19da, "(null)" },
    { 0x0615, 0x9038, 0x1b0a, "(null)" },
    { 0x0617, 0x019c, 0x1028, "(null)" },
    { 0x0617, 0x1982, 0x1043, "(null)" },
    { 0x0617, 0x2003, 0x1043, "(null)" },
    { 0x0617, 0xff01, 0x1179, "(null)" },
    { 0x0617, 0x0770, 0x152d, "(null)" },
    { 0x0617, 0x0481, 0x1558, "(null)" },
    { 0x0617, 0x0902, 0x1558, "(null)" },
    { 0x0617, 0x207a, 0x161f, "(null)" },
    { 0x0618, 0x028e, 0x1025, "(null)" },
    { 0x0618, 0x02a1, 0x1028, "(null)" },
    { 0x0618, 0x02a2, 0x1028, "(null)" },
    { 0x0618, 0x1a52, 0x1043, "(null)" },
    { 0x0618, 0x2028, 0x1043, "(null)" },
    { 0x0618, 0x202b, 0x1043, "(null)" },
    { 0x0618, 0x2033, 0x1043, "(null)" },
    { 0x0618, 0x0481, 0x1558, "(null)" },
    { 0x0618, 0x0577, 0x1558, "(null)" },
    { 0x0618, 0x0860, 0x1558, "(null)" },
    { 0x0618, 0x0902, 0x1558, "(null)" },
    { 0x0618, 0x0903, 0x1558, "(null)" },
    { 0x0618, 0x8100, 0x1558, "(null)" },
    { 0x0618, 0x8687, 0x1558, "(null)" },
    { 0x0618, 0x8689, 0x1558, "(null)" },
    { 0x0618, 0x9800, 0x1558, "(null)" },
    { 0x061C, 0x019b, 0x1028, "(null)" },
    { 0x061C, 0x16d9, 0x1043, "(null)" },
    { 0x061C, 0x0518, 0x10de, "(null)" },
    { 0x061C, 0x0770, 0x152d, "(null)" },
    { 0x061C, 0x211a, 0x17aa, "(null)" },
    { 0x061D, 0x02ef, 0x1028, "(null)" },
    { 0x061D, 0x1520, 0x103c, "(null)" },
    { 0x061D, 0x0903, 0x1558, "(null)" },
    { 0x061D, 0x5102, 0x1558, "(null)" },
    { 0x061D, 0x7100, 0x1558, "(null)" },
    { 0x061D, 0x7200, 0x1558, "(null)" },
    { 0x061D, 0x8100, 0x1558, "(null)" },
    { 0x061D, 0x8687, 0x1558, "(null)" },
    { 0x061D, 0x8689, 0x1558, "(null)" },
    { 0x061D, 0x214f, 0x17aa, "(null)" },
    { 0x061D, 0x219f, 0x17aa, "(null)" },
    { 0x061E, 0x019c, 0x1028, "(null)" },
    { 0x061E, 0x0251, 0x1028, "(null)" },
    { 0x061E, 0x02ef, 0x1028, "(null)" },
    { 0x061E, 0x0539, 0x103c, "(null)" },
    { 0x061E, 0x0481, 0x1558, "(null)" },
    { 0x061E, 0x0573, 0x1558, "(null)" },
    { 0x061E, 0x0860, 0x1558, "(null)" },
    { 0x061E, 0x0902, 0x1558, "(null)" },
    { 0x061E, 0x2118, 0x17aa, "(null)" },
    { 0x061E, 0x2125, 0x17aa, "(null)" },
    { 0x061F, 0x02ef, 0x1028, "(null)" },
    { 0x061F, 0x1520, 0x103c, "(null)" },
    { 0x061F, 0x0903, 0x1558, "(null)" },
    { 0x061F, 0x7200, 0x1558, "(null)" },
    { 0x061F, 0x8100, 0x1558, "(null)" },
    { 0x061F, 0x8687, 0x1558, "(null)" },
    { 0x061F, 0x8689, 0x1558, "(null)" },
    { 0x061F, 0x214e, 0x17aa, "(null)" },
    { 0x061F, 0x214f, 0x17aa, "(null)" },
    { 0x061F, 0x219f, 0x17aa, "(null)" },
    { 0x061F, 0x21a0, 0x17aa, "(null)" },
    { 0x0622, 0x807a, 0x144d, "(null)" },
    { 0x0622, 0x807b, 0x144d, "(null)" },
    { 0x0622, 0x807c, 0x144d, "(null)" },
    { 0x0622, 0x807d, 0x144d, "(null)" },
    { 0x0622, 0x1275, 0x1462, "(null)" },
    { 0x0622, 0x1043, 0x19da, "(null)" },
    { 0x0623, 0x9015, 0x1b0a, "(null)" },
    { 0x0626, 0x9015, 0x1b0a, "(null)" },
    { 0x0628, 0x19e2, 0x1043, "(null)" },
    { 0x0628, 0x2004, 0x1043, "(null)" },
    { 0x0628, 0x2012, 0x1043, "(null)" },
    { 0x0628, 0x0696, 0x107b, "(null)" },
    { 0x0628, 0xff00, 0x1179, "(null)" },
    { 0x0628, 0x0481, 0x1558, "(null)" },
    { 0x0628, 0x0573, 0x1558, "(null)" },
    { 0x0628, 0x0860, 0x1558, "(null)" },
    { 0x0628, 0x0902, 0x1558, "(null)" },
    { 0x0628, 0x0188, 0x1631, "(null)" },
    { 0x062A, 0x19d2, 0x1043, "(null)" },
    { 0x062A, 0x2002, 0x1043, "(null)" },
    { 0x062A, 0x0696, 0x107b, "(null)" },
    { 0x062A, 0x0001, 0x1179, "(null)" },
    { 0x062A, 0xff00, 0x1179, "(null)" },
    { 0x062A, 0xff01, 0x1179, "(null)" },
    { 0x062A, 0x0481, 0x1558, "(null)" },
    { 0x062B, 0x1992, 0x1043, "(null)" },
    { 0x062B, 0x2014, 0x1043, "(null)" },
    { 0x062B, 0x2016, 0x1043, "(null)" },
    { 0x062B, 0x2019, 0x1043, "(null)" },
    { 0x062B, 0x2020, 0x1043, "(null)" },
    { 0x062B, 0x0696, 0x107b, "(null)" },
    { 0x062B, 0x7220, 0x1462, "(null)" },
    { 0x062B, 0x0481, 0x1558, "(null)" },
    { 0x062B, 0x0573, 0x1558, "(null)" },
    { 0x062B, 0x0860, 0x1558, "(null)" },
    { 0x062B, 0x0902, 0x1558, "(null)" },
    { 0x062C, 0x22d7, 0x1019, "(null)" },
    { 0x062C, 0x2015, 0x1043, "(null)" },
    { 0x062C, 0x2017, 0x1043, "(null)" },
    { 0x062C, 0x0696, 0x107b, "(null)" },
    { 0x062C, 0xff01, 0x1179, "(null)" },
    { 0x062C, 0x0481, 0x1558, "(null)" },
    { 0x062C, 0x0573, 0x1558, "(null)" },
    { 0x062C, 0x0860, 0x1558, "(null)" },
    { 0x062C, 0x0902, 0x1558, "(null)" },
    { 0x062C, 0x0188, 0x1631, "(null)" },
    { 0x062C, 0x1138, 0x1734, "(null)" },
    { 0x062E, 0x0605, 0x106b, "(null)" },
    { 0x0631, 0x1014, 0x1462, "(null)" },
    { 0x0631, 0x1024, 0x1462, "(null)" },
    { 0x0631, 0x0481, 0x1558, "(null)" },
    { 0x0631, 0x0577, 0x1558, "(null)" },
    { 0x0631, 0x0860, 0x1558, "(null)" },
    { 0x0631, 0x0902, 0x1558, "(null)" },
    { 0x0631, 0x0903, 0x1558, "(null)" },
    { 0x0631, 0x9800, 0x1558, "(null)" },
    { 0x0631, 0x2150, 0x17aa, "(null)" },
    { 0x063A, 0x019b, 0x1028, "(null)" },
    { 0x063A, 0x0251, 0x1028, "(null)" },
    { 0x063A, 0x02ef, 0x1028, "(null)" },
    { 0x063A, 0x30ec, 0x103c, "(null)" },
    { 0x063A, 0x0481, 0x1558, "(null)" },
    { 0x063A, 0x0860, 0x1558, "(null)" },
    { 0x063A, 0x0902, 0x1558, "(null)" },
    { 0x063A, 0x2119, 0x17aa, "(null)" },
    { 0x063A, 0x2124, 0x17aa, "(null)" },
    { 0x0640, 0x061b, 0x106b, "(null)" },
    { 0x0640, 0x3796, 0x1642, "(null)" },
    { 0x0640, 0x7045, 0x19da, "(null)" },
    { 0x0644, 0x8077, 0x144d, "(null)" },
    { 0x0644, 0x8078, 0x144d, "(null)" },
    { 0x0644, 0x8079, 0x144d, "(null)" },
    { 0x0644, 0x807e, 0x144d, "(null)" },
    { 0x0644, 0x807f, 0x144d, "(null)" },
    { 0x0644, 0x8080, 0x144d, "(null)" },
    { 0x0644, 0x8081, 0x144d, "(null)" },
    { 0x0644, 0x1330, 0x1462, "(null)" },
    { 0x0644, 0x2045, 0x19da, "(null)" },
    { 0x0645, 0x900c, 0x1b0a, "(null)" },
    { 0x0646, 0x88fc, 0x1033, "(null)" },
    { 0x0646, 0x1330, 0x1462, "(null)" },
    { 0x0646, 0xa330, 0x1462, "(null)" },
    { 0x0646, 0x900c, 0x1b0a, "(null)" },
    { 0x0647, 0x00a9, 0x106b, "(null)" },
    { 0x0647, 0x00b3, 0x106b, "(null)" },
    { 0x0647, 0x00bc, 0x106b, "(null)" },
    { 0x0648, 0x011e, 0x1025, "(null)" },
    { 0x0648, 0x0121, 0x1025, "(null)" },
    { 0x0648, 0x0126, 0x1025, "(null)" },
    { 0x0648, 0x013b, 0x1025, "(null)" },
    { 0x0648, 0x013c, 0x1025, "(null)" },
    { 0x0648, 0x013d, 0x1025, "(null)" },
    { 0x0648, 0x013e, 0x1025, "(null)" },
    { 0x0648, 0x013f, 0x1025, "(null)" },
    { 0x0648, 0x0142, 0x1025, "(null)" },
    { 0x0648, 0x0143, 0x1025, "(null)" },
    { 0x0648, 0x0145, 0x1025, "(null)" },
    { 0x0648, 0x0146, 0x1025, "(null)" },
    { 0x0648, 0x0149, 0x1025, "(null)" },
    { 0x0648, 0x014d, 0x1025, "(null)" },
    { 0x0648, 0x015e, 0x1025, "(null)" },
    { 0x0648, 0x0175, 0x1025, "(null)" },
    { 0x0648, 0x02c0, 0x1028, "(null)" },
    { 0x0648, 0x88d4, 0x1033, "(null)" },
    { 0x0648, 0x88d8, 0x1033, "(null)" },
    { 0x0648, 0x1892, 0x1043, "(null)" },
    { 0x0648, 0x2010, 0x1043, "(null)" },
    { 0x0648, 0x2011, 0x1043, "(null)" },
    { 0x0648, 0x900f, 0x1043, "(null)" },
    { 0x0648, 0x9070, 0x1071, "(null)" },
    { 0x0648, 0x0900, 0x107b, "(null)" },
    { 0x0648, 0x0001, 0x1179, "(null)" },
    { 0x0648, 0xff00, 0x1179, "(null)" },
    { 0x0648, 0xb051, 0x144d, "(null)" },
    { 0x0648, 0xb058, 0x144d, "(null)" },
    { 0x0648, 0xc03f, 0x144d, "(null)" },
    { 0x0648, 0xc044, 0x144d, "(null)" },
    { 0x0648, 0xc520, 0x144d, "(null)" },
    { 0x0648, 0x0773, 0x152d, "(null)" },
    { 0x0648, 0x0776, 0x152d, "(null)" },
    { 0x0648, 0x0481, 0x1558, "(null)" },
    { 0x0648, 0x0860, 0x1558, "(null)" },
    { 0x0648, 0x3877, 0x17aa, "(null)" },
    { 0x0648, 0x3879, 0x17aa, "(null)" },
    { 0x0648, 0x208b, 0x17c0, "(null)" },
    { 0x0648, 0x208c, 0x17c0, "(null)" },
    { 0x0648, 0x1773, 0x1854, "(null)" },
    { 0x0648, 0x1776, 0x1854, "(null)" },
    { 0x0648, 0x5584, 0x1991, "(null)" },
    { 0x0648, 0x001f, 0x1b0a, "(null)" },
    { 0x0649, 0x22d5, 0x1019, "(null)" },
    { 0x0649, 0x011e, 0x1025, "(null)" },
    { 0x0649, 0x0121, 0x1025, "(null)" },
    { 0x0649, 0x0126, 0x1025, "(null)" },
    { 0x0649, 0x013b, 0x1025, "(null)" },
    { 0x0649, 0x013c, 0x1025, "(null)" },
    { 0x0649, 0x013d, 0x1025, "(null)" },
    { 0x0649, 0x013e, 0x1025, "(null)" },
    { 0x0649, 0x013f, 0x1025, "(null)" },
    { 0x0649, 0x0142, 0x1025, "(null)" },
    { 0x0649, 0x0143, 0x1025, "(null)" },
    { 0x0649, 0x0145, 0x1025, "(null)" },
    { 0x0649, 0x0146, 0x1025, "(null)" },
    { 0x0649, 0x0149, 0x1025, "(null)" },
    { 0x0649, 0x014d, 0x1025, "(null)" },
    { 0x0649, 0x015e, 0x1025, "(null)" },
    { 0x0649, 0x0175, 0x1025, "(null)" },
    { 0x0649, 0x017e, 0x1025, "(null)" },
    { 0x0649, 0x0250, 0x1028, "(null)" },
    { 0x0649, 0x0272, 0x1028, "(null)" },
    { 0x0649, 0x30f4, 0x103c, "(null)" },
    { 0x0649, 0x3603, 0x103c, "(null)" },
    { 0x0649, 0x3610, 0x103c, "(null)" },
    { 0x0649, 0x361b, 0x103c, "(null)" },
    { 0x0649, 0x3621, 0x103c, "(null)" },
    { 0x0649, 0x19f2, 0x1043, "(null)" },
    { 0x0649, 0x2001, 0x1043, "(null)" },
    { 0x0649, 0x2005, 0x1043, "(null)" },
    { 0x0649, 0x2006, 0x1043, "(null)" },
    { 0x0649, 0x202d, 0x1043, "(null)" },
    { 0x0649, 0x9013, 0x1043, "(null)" },
    { 0x0649, 0x9040, 0x104d, "(null)" },
    { 0x0649, 0x0800, 0x107b, "(null)" },
    { 0x0649, 0x0900, 0x107b, "(null)" },
    { 0x0649, 0x3c06, 0x109f, "(null)" },
    { 0x0649, 0x0001, 0x1179, "(null)" },
    { 0x0649, 0xff00, 0x1179, "(null)" },
    { 0x0649, 0xff01, 0x1179, "(null)" },
    { 0x0649, 0xc03f, 0x144d, "(null)" },
    { 0x0649, 0xc044, 0x144d, "(null)" },
    { 0x0649, 0xc520, 0x144d, "(null)" },
    { 0x0649, 0x4327, 0x1462, "(null)" },
    { 0x0649, 0x4350, 0x1462, "(null)" },
    { 0x0649, 0x63f2, 0x1462, "(null)" },
    { 0x0649, 0x6510, 0x1462, "(null)" },
    { 0x0649, 0x6520, 0x1462, "(null)" },
    { 0x0649, 0x6710, 0x1462, "(null)" },
    { 0x0649, 0x719a, 0x1462, "(null)" },
    { 0x0649, 0x719b, 0x1462, "(null)" },
    { 0x0649, 0x7220, 0x1462, "(null)" },
    { 0x0649, 0x0031, 0x14c0, "(null)" },
    { 0x0649, 0x3008, 0x1509, "(null)" },
    { 0x0649, 0x0481, 0x1558, "(null)" },
    { 0x0649, 0x0573, 0x1558, "(null)" },
    { 0x0649, 0x0860, 0x1558, "(null)" },
    { 0x0649, 0x1135, 0x1734, "(null)" },
    { 0x0649, 0x115e, 0x1734, "(null)" },
    { 0x0649, 0x0805, 0x17ff, "(null)" },
    { 0x0649, 0x012f, 0x1854, "(null)" },
    { 0x0649, 0x0130, 0x1854, "(null)" },
    { 0x0649, 0x0131, 0x1854, "(null)" },
    { 0x0649, 0x0132, 0x1854, "(null)" },
    { 0x0649, 0x013c, 0x1854, "(null)" },
    { 0x0649, 0x1402, 0x1a46, "(null)" },
    { 0x0649, 0x1405, 0x1a46, "(null)" },
    { 0x0649, 0x001f, 0x1b0a, "(null)" },
    { 0x0649, 0x9024, 0x1b0a, "(null)" },
    { 0x064A, 0x0145, 0x1025, "(null)" },
    { 0x064A, 0x0146, 0x1025, "(null)" },
    { 0x064A, 0x19a2, 0x1043, "(null)" },
    { 0x064A, 0x1a02, 0x1043, "(null)" },
    { 0x064A, 0x2009, 0x1043, "(null)" },
    { 0x064B, 0x3874, 0x17aa, "(null)" },
    { 0x064B, 0x3a27, 0x17aa, "(null)" },
    { 0x064C, 0x1912, 0x1043, "(null)" },
    { 0x064C, 0x2013, 0x1043, "(null)" },
    { 0x064C, 0x2018, 0x1043, "(null)" },
    { 0x064C, 0x2022, 0x1043, "(null)" },
    { 0x064C, 0x1405, 0x1a46, "(null)" },
    { 0x0651, 0xc520, 0x144d, "(null)" },
    { 0x0651, 0x100c, 0x1462, "(null)" },
    { 0x0651, 0x3877, 0x17aa, "(null)" },
    { 0x0651, 0x387b, 0x17aa, "(null)" },
    { 0x0652, 0x0201, 0x1025, "(null)" },
    { 0x0652, 0x0208, 0x1025, "(null)" },
    { 0x0652, 0x020e, 0x1025, "(null)" },
    { 0x0652, 0x021e, 0x1025, "(null)" },
    { 0x0652, 0x0259, 0x1025, "(null)" },
    { 0x0652, 0x0261, 0x1025, "(null)" },
    { 0x0652, 0x0299, 0x1025, "(null)" },
    { 0x0652, 0x3610, 0x103c, "(null)" },
    { 0x0652, 0x361b, 0x103c, "(null)" },
    { 0x0652, 0x1a12, 0x1043, "(null)" },
    { 0x0652, 0x1a42, 0x1043, "(null)" },
    { 0x0652, 0x2021, 0x1043, "(null)" },
    { 0x0652, 0x2023, 0x1043, "(null)" },
    { 0x0652, 0x2024, 0x1043, "(null)" },
    { 0x0652, 0x2025, 0x1043, "(null)" },
    { 0x0652, 0x202c, 0x1043, "(null)" },
    { 0x0652, 0xc03f, 0x144d, "(null)" },
    { 0x0652, 0xc520, 0x144d, "(null)" },
    { 0x0652, 0x100b, 0x1462, "(null)" },
    { 0x0652, 0x100c, 0x1462, "(null)" },
    { 0x0652, 0x1023, 0x1462, "(null)" },
    { 0x0652, 0x1650, 0x1462, "(null)" },
    { 0x0652, 0x4350, 0x1462, "(null)" },
    { 0x0652, 0x4570, 0x1462, "(null)" },
    { 0x0652, 0x003d, 0x14c0, "(null)" },
    { 0x0652, 0x300c, 0x1509, "(null)" },
    { 0x0652, 0x0787, 0x152d, "(null)" },
    { 0x0652, 0x0788, 0x152d, "(null)" },
    { 0x0652, 0x0789, 0x152d, "(null)" },
    { 0x0652, 0x0823, 0x152d, "(null)" },
    { 0x0652, 0x0850, 0x152d, "(null)" },
    { 0x0652, 0x1172, 0x1734, "(null)" },
    { 0x0652, 0x387a, 0x17aa, "(null)" },
    { 0x0652, 0x3882, 0x17aa, "(null)" },
    { 0x0652, 0x0132, 0x1854, "(null)" },
    { 0x0652, 0x0140, 0x1854, "(null)" },
    { 0x0652, 0x0142, 0x1854, "(null)" },
    { 0x0652, 0x1784, 0x1854, "(null)" },
    { 0x0652, 0x1785, 0x1854, "(null)" },
    { 0x0652, 0x1786, 0x1854, "(null)" },
    { 0x0652, 0x1787, 0x1854, "(null)" },
    { 0x0652, 0x1789, 0x1854, "(null)" },
    { 0x0652, 0x1405, 0x1a46, "(null)" },
    { 0x0653, 0x1402, 0x1043, "(null)" },
    { 0x0653, 0x1a42, 0x1043, "(null)" },
    { 0x0653, 0x202d, 0x1043, "(null)" },
    { 0x0654, 0x14a2, 0x1043, "(null)" },
    { 0x0654, 0x14d2, 0x1043, "(null)" },
    { 0x0654, 0x1ad2, 0x1043, "(null)" },
    { 0x0654, 0x2035, 0x1043, "(null)" },
    { 0x0654, 0x2039, 0x1043, "(null)" },
    { 0x0654, 0x203b, 0x1043, "(null)" },
    { 0x0654, 0x10ca, 0x17c0, "(null)" },
    { 0x0655, 0x0633, 0x106b, "(null)" },
    { 0x0656, 0x0693, 0x106b, "(null)" },
    { 0x065A, 0x0250, 0x1028, "(null)" },
    { 0x065C, 0x0250, 0x1028, "(null)" },
    { 0x065C, 0x30e7, 0x103c, "(null)" },
    { 0x065C, 0x058b, 0x10de, "(null)" },
    { 0x065C, 0x1147, 0x1734, "(null)" },
    { 0x06C0, 0x075f, 0x10de, "(null)" },
    { 0x06C4, 0xc000, 0x1458, "(null)" },
    { 0x06CA, 0x048f, 0x1028, "(null)" },
    { 0x06CA, 0x0490, 0x1028, "(null)" },
    { 0x06CA, 0x0053, 0x14c0, "(null)" },
    { 0x06CA, 0x0903, 0x1558, "(null)" },
    { 0x06CA, 0x7200, 0x1558, "(null)" },
    { 0x06CA, 0x8100, 0x1558, "(null)" },
    { 0x06CA, 0x8687, 0x1558, "(null)" },
    { 0x06CA, 0x8689, 0x1558, "(null)" },
    { 0x06CD, 0x079f, 0x10de, "(null)" },
    { 0x06CD, 0xc000, 0x1458, "(null)" },
    { 0x06D1, 0x0771, 0x103c, "(null)" },
    { 0x06D1, 0x0771, 0x10de, "(null)" },
    { 0x06D1, 0x0772, 0x10de, "(null)" },
    { 0x06D2, 0x0774, 0x10de, "(null)" },
    { 0x06D2, 0x0830, 0x10de, "(null)" },
    { 0x06D2, 0x0842, 0x10de, "(null)" },
    { 0x06D2, 0x084d, 0x10de, "(null)" },
    { 0x06D2, 0x088f, 0x10de, "(null)" },
    { 0x06D2, 0x0908, 0x10de, "(null)" },
    { 0x06D8, 0x076f, 0x103c, "(null)" },
    { 0x06D8, 0x076f, 0x10de, "(null)" },
    { 0x06D9, 0x0770, 0x103c, "(null)" },
    { 0x06D9, 0x0770, 0x10de, "(null)" },
    { 0x06DA, 0x081a, 0x1028, "(null)" },
    { 0x06DA, 0x1520, 0x103c, "(null)" },
    { 0x06DD, 0x0780, 0x103c, "(null)" },
    { 0x06DD, 0x0000, 0x106b, "(null)" },
    { 0x06DD, 0x0780, 0x10de, "(null)" },
    { 0x06DE, 0x0773, 0x10de, "(null)" },
    { 0x06DE, 0x082f, 0x10de, "(null)" },
    { 0x06DE, 0x0840, 0x10de, "(null)" },
    { 0x06DE, 0x0842, 0x10de, "(null)" },
    { 0x06DE, 0x0846, 0x10de, "(null)" },
    { 0x06DE, 0x0866, 0x10de, "(null)" },
    { 0x06DE, 0x0907, 0x10de, "(null)" },
    { 0x06DE, 0x091e, 0x10de, "(null)" },
    { 0x06DF, 0x084d, 0x10de, "(null)" },
    { 0x06DF, 0x087f, 0x10de, "(null)" },
    { 0x06E0, 0x3483, 0x1458, "(null)" },
    { 0x06E0, 0x3484, 0x1458, "(null)" },
    { 0x06E0, 0x9004, 0x1b0a, "(null)" },
    { 0x06E0, 0x9008, 0x1b0a, "(null)" },
    { 0x06E1, 0x8073, 0x144d, "(null)" },
    { 0x06E1, 0x8074, 0x144d, "(null)" },
    { 0x06E1, 0x8075, 0x144d, "(null)" },
    { 0x06E1, 0x8076, 0x144d, "(null)" },
    { 0x06E1, 0x3483, 0x1458, "(null)" },
    { 0x06E1, 0x3484, 0x1458, "(null)" },
    { 0x06E1, 0x116b, 0x1462, "(null)" },
    { 0x06E1, 0x0203, 0x1620, "(null)" },
    { 0x06E1, 0x3776, 0x1642, "(null)" },
    { 0x06E2, 0x050f, 0x1043, "(null)" },
    { 0x06E2, 0x0510, 0x1043, "(null)" },
    { 0x06E2, 0x3467, 0x1458, "(null)" },
    { 0x06E2, 0x3478, 0x1458, "(null)" },
    { 0x06E2, 0x3776, 0x1642, "(null)" },
    { 0x06E5, 0x9025, 0x104d, "(null)" },
    { 0x06E6, 0x3483, 0x1458, "(null)" },
    { 0x06E6, 0x3484, 0x1458, "(null)" },
    { 0x06E6, 0x3776, 0x1642, "(null)" },
    { 0x06E6, 0x9004, 0x1b0a, "(null)" },
    { 0x06E6, 0x9008, 0x1b0a, "(null)" },
    { 0x06E6, 0x903e, 0x1b0a, "(null)" },
    { 0x06E8, 0x0262, 0x1028, "(null)" },
    { 0x06E8, 0x0271, 0x1028, "(null)" },
    { 0x06E8, 0x0272, 0x1028, "(null)" },
    { 0x06E8, 0x30f4, 0x103c, "(null)" },
    { 0x06E8, 0x30f7, 0x103c, "(null)" },
    { 0x06E8, 0x3603, 0x103c, "(null)" },
    { 0x06E8, 0x360b, 0x103c, "(null)" },
    { 0x06E8, 0x3621, 0x103c, "(null)" },
    { 0x06E8, 0x3629, 0x103c, "(null)" },
    { 0x06E8, 0x2008, 0x1043, "(null)" },
    { 0x06E8, 0x0900, 0x107b, "(null)" },
    { 0x06E8, 0x0001, 0x1179, "(null)" },
    { 0x06E8, 0xff00, 0x1179, "(null)" },
    { 0x06E8, 0xc041, 0x144d, "(null)" },
    { 0x06E8, 0xc042, 0x144d, "(null)" },
    { 0x06E8, 0xc048, 0x144d, "(null)" },
    { 0x06E8, 0xc04a, 0x144d, "(null)" },
    { 0x06E8, 0xc521, 0x144d, "(null)" },
    { 0x06E8, 0xc524, 0x144d, "(null)" },
    { 0x06E8, 0x0772, 0x152d, "(null)" },
    { 0x06E8, 0x0773, 0x152d, "(null)" },
    { 0x06E8, 0x0774, 0x152d, "(null)" },
    { 0x06E8, 0x0775, 0x152d, "(null)" },
    { 0x06E8, 0x1146, 0x1734, "(null)" },
    { 0x06E8, 0x1772, 0x1854, "(null)" },
    { 0x06E8, 0x1773, 0x1854, "(null)" },
    { 0x06E8, 0x1774, 0x1854, "(null)" },
    { 0x06E8, 0x1775, 0x1854, "(null)" },
    { 0x06E8, 0x4605, 0x1961, "(null)" },
    { 0x06E8, 0x5584, 0x1991, "(null)" },
    { 0x06E8, 0x000e, 0x1b0a, "(null)" },
    { 0x06E9, 0x22d5, 0x1019, "(null)" },
    { 0x06E9, 0x011e, 0x1025, "(null)" },
    { 0x06E9, 0x0121, 0x1025, "(null)" },
    { 0x06E9, 0x0126, 0x1025, "(null)" },
    { 0x06E9, 0x0128, 0x1025, "(null)" },
    { 0x06E9, 0x013b, 0x1025, "(null)" },
    { 0x06E9, 0x013c, 0x1025, "(null)" },
    { 0x06E9, 0x013d, 0x1025, "(null)" },
    { 0x06E9, 0x013e, 0x1025, "(null)" },
    { 0x06E9, 0x013f, 0x1025, "(null)" },
    { 0x06E9, 0x0142, 0x1025, "(null)" },
    { 0x06E9, 0x0143, 0x1025, "(null)" },
    { 0x06E9, 0x0145, 0x1025, "(null)" },
    { 0x06E9, 0x0146, 0x1025, "(null)" },
    { 0x06E9, 0x0149, 0x1025, "(null)" },
    { 0x06E9, 0x014d, 0x1025, "(null)" },
    { 0x06E9, 0x015e, 0x1025, "(null)" },
    { 0x06E9, 0x0167, 0x1025, "(null)" },
    { 0x06E9, 0x0175, 0x1025, "(null)" },
    { 0x06E9, 0x017e, 0x1025, "(null)" },
    { 0x06E9, 0x024b, 0x1025, "(null)" },
    { 0x06E9, 0x02bb, 0x1028, "(null)" },
    { 0x06E9, 0x02bc, 0x1028, "(null)" },
    { 0x06E9, 0x02bd, 0x1028, "(null)" },
    { 0x06E9, 0x02d9, 0x1028, "(null)" },
    { 0x06E9, 0x02de, 0x1028, "(null)" },
    { 0x06E9, 0x1505, 0x103c, "(null)" },
    { 0x06E9, 0x0510, 0x1043, "(null)" },
    { 0x06E9, 0x1972, 0x1043, "(null)" },
    { 0x06E9, 0x19b2, 0x1043, "(null)" },
    { 0x06E9, 0x19c2, 0x1043, "(null)" },
    { 0x06E9, 0x1a62, 0x1043, "(null)" },
    { 0x06E9, 0x2007, 0x1043, "(null)" },
    { 0x06E9, 0x8329, 0x1043, "(null)" },
    { 0x06E9, 0x903f, 0x104d, "(null)" },
    { 0x06E9, 0x9040, 0x104d, "(null)" },
    { 0x06E9, 0x0900, 0x107b, "(null)" },
    { 0x06E9, 0x3c05, 0x109f, "(null)" },
    { 0x06E9, 0x14a7, 0x10cf, "(null)" },
    { 0x06E9, 0x14cf, 0x10cf, "(null)" },
    { 0x06E9, 0xff00, 0x1179, "(null)" },
    { 0x06E9, 0xb051, 0x144d, "(null)" },
    { 0x06E9, 0xc03f, 0x144d, "(null)" },
    { 0x06E9, 0xc041, 0x144d, "(null)" },
    { 0x06E9, 0xc042, 0x144d, "(null)" },
    { 0x06E9, 0xc045, 0x144d, "(null)" },
    { 0x06E9, 0xc048, 0x144d, "(null)" },
    { 0x06E9, 0xc520, 0x144d, "(null)" },
    { 0x06E9, 0x4350, 0x1462, "(null)" },
    { 0x06E9, 0x6510, 0x1462, "(null)" },
    { 0x06E9, 0x6520, 0x1462, "(null)" },
    { 0x06E9, 0x6530, 0x1462, "(null)" },
    { 0x06E9, 0x6710, 0x1462, "(null)" },
    { 0x06E9, 0x7220, 0x1462, "(null)" },
    { 0x06E9, 0x7230, 0x1462, "(null)" },
    { 0x06E9, 0x0033, 0x14c0, "(null)" },
    { 0x06E9, 0xa016, 0x14ff, "(null)" },
    { 0x06E9, 0x0774, 0x152d, "(null)" },
    { 0x06E9, 0x0775, 0x152d, "(null)" },
    { 0x06E9, 0x0802, 0x1558, "(null)" },
    { 0x06E9, 0x0805, 0x1558, "(null)" },
    { 0x06E9, 0x0806, 0x1558, "(null)" },
    { 0x06E9, 0x1137, 0x1734, "(null)" },
    { 0x06E9, 0x2107, 0x17aa, "(null)" },
    { 0x06E9, 0x3873, 0x17aa, "(null)" },
    { 0x06E9, 0x3876, 0x17aa, "(null)" },
    { 0x06E9, 0x3a24, 0x17aa, "(null)" },
    { 0x06E9, 0x208b, 0x17c0, "(null)" },
    { 0x06E9, 0x0802, 0x17ff, "(null)" },
    { 0x06E9, 0x0131, 0x1854, "(null)" },
    { 0x06E9, 0x0132, 0x1854, "(null)" },
    { 0x06E9, 0x013a, 0x1854, "(null)" },
    { 0x06E9, 0x013b, 0x1854, "(null)" },
    { 0x06E9, 0x013d, 0x1854, "(null)" },
    { 0x06E9, 0x013e, 0x1854, "(null)" },
    { 0x06E9, 0x1774, 0x1854, "(null)" },
    { 0x06E9, 0x1775, 0x1854, "(null)" },
    { 0x06E9, 0x0001, 0x1895, "(null)" },
    { 0x06E9, 0x5584, 0x1991, "(null)" },
    { 0x06E9, 0x1402, 0x1a46, "(null)" },
    { 0x06E9, 0x1405, 0x1a46, "(null)" },
    { 0x06E9, 0x000e, 0x1b0a, "(null)" },
    { 0x06E9, 0x006a, 0x1b0a, "(null)" },
    { 0x06E9, 0x200f, 0x1b0a, "(null)" },
    { 0x06E9, 0x9003, 0x1b0a, "(null)" },
    { 0x06E9, 0x9010, 0x1b0a, "(null)" },
    { 0x06E9, 0x9023, 0x1b0a, "(null)" },
    { 0x06E9, 0x8986, 0x4352, "(null)" },
    { 0x06EA, 0x0001, 0x1179, "(null)" },
    { 0x06EA, 0x0002, 0x1179, "(null)" },
    { 0x06EB, 0x0233, 0x1028, "(null)" },
    { 0x06EB, 0x024f, 0x1028, "(null)" },
    { 0x06EB, 0x0001, 0x1179, "(null)" },
    { 0x06EB, 0x3a25, 0x17aa, "(null)" },
    { 0x06EC, 0x0128, 0x1025, "(null)" },
    { 0x06EC, 0x0167, 0x1025, "(null)" },
    { 0x06EC, 0x0200, 0x1025, "(null)" },
    { 0x06EC, 0x0205, 0x1025, "(null)" },
    { 0x06EC, 0x0208, 0x1025, "(null)" },
    { 0x06EC, 0x020a, 0x1025, "(null)" },
    { 0x06EC, 0x020e, 0x1025, "(null)" },
    { 0x06EC, 0x0218, 0x1025, "(null)" },
    { 0x06EC, 0x0219, 0x1025, "(null)" },
    { 0x06EC, 0x021c, 0x1025, "(null)" },
    { 0x06EC, 0x0253, 0x1025, "(null)" },
    { 0x06EC, 0x0260, 0x1025, "(null)" },
    { 0x06EC, 0x306d, 0x103c, "(null)" },
    { 0x06EC, 0x30f4, 0x103c, "(null)" },
    { 0x06EC, 0x30f7, 0x103c, "(null)" },
    { 0x06EC, 0x7010, 0x103c, "(null)" },
    { 0x06EC, 0x1a22, 0x1043, "(null)" },
    { 0x06EC, 0x1a32, 0x1043, "(null)" },
    { 0x06EC, 0x1a72, 0x1043, "(null)" },
    { 0x06EC, 0x2026, 0x1043, "(null)" },
    { 0x06EC, 0xc04f, 0x144d, "(null)" },
    { 0x06EC, 0xc050, 0x144d, "(null)" },
    { 0x06EC, 0xc051, 0x144d, "(null)" },
    { 0x06EC, 0xc520, 0x144d, "(null)" },
    { 0x06EC, 0xc540, 0x144d, "(null)" },
    { 0x06EC, 0x0784, 0x152d, "(null)" },
    { 0x06EC, 0x0785, 0x152d, "(null)" },
    { 0x06EC, 0x0786, 0x152d, "(null)" },
    { 0x06EC, 0x0817, 0x152d, "(null)" },
    { 0x06EC, 0x0802, 0x1558, "(null)" },
    { 0x06EC, 0x0806, 0x1558, "(null)" },
    { 0x06EC, 0x2128, 0x17aa, "(null)" },
    { 0x06EC, 0x3883, 0x17aa, "(null)" },
    { 0x06EC, 0x3884, 0x17aa, "(null)" },
    { 0x06EC, 0x38a1, 0x17aa, "(null)" },
    { 0x06EC, 0x208d, 0x17c0, "(null)" },
    { 0x06EC, 0x0141, 0x1854, "(null)" },
    { 0x06EC, 0x0143, 0x1854, "(null)" },
    { 0x06EC, 0x1781, 0x1854, "(null)" },
    { 0x06EC, 0x1782, 0x1854, "(null)" },
    { 0x06EC, 0x1783, 0x1854, "(null)" },
    { 0x06EC, 0x1784, 0x1854, "(null)" },
    { 0x06EC, 0x1785, 0x1854, "(null)" },
    { 0x06EC, 0x1786, 0x1854, "(null)" },
    { 0x06EC, 0x1787, 0x1854, "(null)" },
    { 0x06EC, 0x1788, 0x1854, "(null)" },
    { 0x06EF, 0x306a, 0x103c, "(null)" },
    { 0x06EF, 0x306c, 0x103c, "(null)" },
    { 0x06EF, 0x7010, 0x103c, "(null)" },
    { 0x06F1, 0x1a82, 0x1043, "(null)" },
    { 0x06F1, 0x1a92, 0x1043, "(null)" },
    { 0x06F1, 0x1ab2, 0x1043, "(null)" },
    { 0x06F1, 0x2032, 0x1043, "(null)" },
    { 0x06F1, 0x1032, 0x1462, "(null)" },
    { 0x06F9, 0x060d, 0x10de, "(null)" },
    { 0x06FB, 0x0234, 0x1028, "(null)" },
    { 0x06FD, 0x062e, 0x10de, "(null)" },
    { 0x06FF, 0x0711, 0x10de, "(null)" },
    { 0x07E1, 0xb04d, 0x144d, "(null)" },
    { 0x07E1, 0xb04e, 0x144d, "(null)" },
    { 0x07E1, 0xb065, 0x144d, "(null)" },
    { 0x07E2, 0xb04b, 0x144d, "(null)" },
    { 0x0844, 0x014a, 0x1025, "(null)" },
    { 0x0844, 0x014d, 0x1025, "(null)" },
    { 0x0844, 0x88cc, 0x1033, "(null)" },
    { 0x0844, 0x0173, 0x107b, "(null)" },
    { 0x0844, 0x6520, 0x1462, "(null)" },
    { 0x0844, 0x6710, 0x1462, "(null)" },
    { 0x0844, 0x6720, 0x1462, "(null)" },
    { 0x0844, 0x208c, 0x17c0, "(null)" },
    { 0x0844, 0x208f, 0x17c0, "(null)" },
    { 0x0844, 0x408f, 0x17c0, "(null)" },
    { 0x0845, 0x360a, 0x103c, "(null)" },
    { 0x0845, 0x6720, 0x1462, "(null)" },
    { 0x084B, 0x0227, 0x1025, "(null)" },
    { 0x084B, 0xe03b, 0x1631, "(null)" },
    { 0x0860, 0x2a8d, 0x103c, "(null)" },
    { 0x0860, 0x2aa1, 0x103c, "(null)" },
    { 0x0861, 0x00ae, 0x106b, "(null)" },
    { 0x0862, 0x0271, 0x1028, "(null)" },
    { 0x0862, 0x02a1, 0x1028, "(null)" },
    { 0x0862, 0x16c2, 0x1043, "(null)" },
    { 0x0862, 0xff00, 0x1179, "(null)" },
    { 0x0862, 0x9800, 0x1558, "(null)" },
    { 0x0863, 0x00aa, 0x106b, "(null)" },
    { 0x0863, 0x00ac, 0x106b, "(null)" },
    { 0x0863, 0x00b0, 0x106b, "(null)" },
    { 0x0863, 0x00b9, 0x106b, "(null)" },
    { 0x0863, 0x00ba, 0x106b, "(null)" },
    { 0x0863, 0x00bb, 0x106b, "(null)" },
    { 0x0863, 0x00bd, 0x106b, "(null)" },
    { 0x0864, 0x2a7c, 0x103c, "(null)" },
    { 0x0866, 0x0160, 0x1025, "(null)" },
    { 0x0866, 0x0271, 0x1028, "(null)" },
    { 0x0866, 0x02ba, 0x1028, "(null)" },
    { 0x0866, 0x1962, 0x1043, "(null)" },
    { 0x0866, 0x8403, 0x1043, "(null)" },
    { 0x0866, 0x00b1, 0x106b, "(null)" },
    { 0x0866, 0x9070, 0x1071, "(null)" },
    { 0x0866, 0x4570, 0x1462, "(null)" },
    { 0x0866, 0x1402, 0x1849, "(null)" },
    { 0x0866, 0x2033, 0x1b0a, "(null)" },
    { 0x0866, 0x2009, 0x2854, "(null)" },
    { 0x0867, 0x00ad, 0x106b, "(null)" },
    { 0x0868, 0x2a8b, 0x103c, "(null)" },
    { 0x0869, 0x00b4, 0x106b, "(null)" },
    { 0x086D, 0xb058, 0x144d, "(null)" },
    { 0x086E, 0x16e2, 0x1043, "(null)" },
    { 0x086E, 0x9070, 0x1071, "(null)" },
    { 0x086E, 0x9072, 0x1071, "(null)" },
    { 0x086E, 0xff00, 0x1179, "(null)" },
    { 0x086E, 0xb051, 0x144d, "(null)" },
    { 0x086E, 0x1012, 0x1462, "(null)" },
    { 0x086E, 0x1019, 0x1462, "(null)" },
    { 0x086E, 0x7621, 0x1462, "(null)" },
    { 0x086E, 0x0577, 0x1558, "(null)" },
    { 0x086E, 0x4006, 0x1b0a, "(null)" },
    { 0x086F, 0x16b2, 0x1043, "(null)" },
    { 0x086F, 0x9515, 0x1071, "(null)" },
    { 0x086F, 0xcb79, 0x10de, "(null)" },
    { 0x086F, 0xb051, 0x144d, "(null)" },
    { 0x086F, 0x1012, 0x1462, "(null)" },
    { 0x086F, 0x1019, 0x1462, "(null)" },
    { 0x086F, 0x101a, 0x1462, "(null)" },
    { 0x086F, 0x71f0, 0x1462, "(null)" },
    { 0x086F, 0xc217, 0x1631, "(null)" },
    { 0x086F, 0x1151, 0x1734, "(null)" },
    { 0x086F, 0x0136, 0x1854, "(null)" },
    { 0x086F, 0x0137, 0x1854, "(null)" },
    { 0x086F, 0x2008, 0x1854, "(null)" },
    { 0x0870, 0x00ab, 0x106b, "(null)" },
    { 0x0872, 0x19b4, 0x1043, "(null)" },
    { 0x0872, 0x1aa2, 0x1043, "(null)" },
    { 0x0872, 0x1c02, 0x1043, "(null)" },
    { 0x0872, 0x1c42, 0x1043, "(null)" },
    { 0x0873, 0x19b4, 0x1043, "(null)" },
    { 0x0873, 0x1c12, 0x1043, "(null)" },
    { 0x0873, 0x1c52, 0x1043, "(null)" },
    { 0x0874, 0x4570, 0x1462, "(null)" },
    { 0x0876, 0x3651, 0x103c, "(null)" },
    { 0x0876, 0x8402, 0x1043, "(null)" },
    { 0x0876, 0xc056, 0x144d, "(null)" },
    { 0x0876, 0x1202, 0x1849, "(null)" },
    { 0x0876, 0x0148, 0x1854, "(null)" },
    { 0x0876, 0x0149, 0x1854, "(null)" },
    { 0x087D, 0x301d, 0x17aa, "(null)" },
    { 0x087F, 0x8434, 0x1043, "(null)" },
    { 0x087F, 0xc056, 0x144d, "(null)" },
    { 0x08A0, 0x00c2, 0x106b, "(null)" },
    { 0x08A0, 0x00ce, 0x106b, "(null)" },
    { 0x08A2, 0x00d4, 0x106b, "(null)" },
    { 0x08A3, 0x00d3, 0x106b, "(null)" },
    { 0x08A4, 0x00c0, 0x106b, "(null)" },
    { 0x0A20, 0x8084, 0x144d, "(null)" },
    { 0x0A20, 0x1910, 0x1462, "(null)" },
    { 0x0A20, 0x1911, 0x1462, "(null)" },
    { 0x0A20, 0x1912, 0x1462, "(null)" },
    { 0x0A20, 0x1118, 0x19da, "(null)" },
    { 0x0A22, 0x8327, 0x1043, "(null)" },
    { 0x0A22, 0x3918, 0x1642, "(null)" },
    { 0x0A22, 0x906c, 0x1b0a, "(null)" },
    { 0x0A22, 0x906d, 0x1b0a, "(null)" },
    { 0x0A23, 0x3918, 0x1642, "(null)" },
    { 0x0A27, 0x1010, 0x1019, "(null)" },
    { 0x0A27, 0x5141, 0x174b, "(null)" },
    { 0x0A28, 0x8897, 0x1033, "(null)" },
    { 0x0A28, 0x363c, 0x103c, "(null)" },
    { 0x0A28, 0x363e, 0x103c, "(null)" },
    { 0x0A28, 0x3659, 0x103c, "(null)" },
    { 0x0A28, 0x365c, 0x103c, "(null)" },
    { 0x0A28, 0x7001, 0x103c, "(null)" },
    { 0x0A28, 0x2031, 0x1043, "(null)" },
    { 0x0A28, 0x9072, 0x1071, "(null)" },
    { 0x0A28, 0xff00, 0x1179, "(null)" },
    { 0x0A28, 0xff15, 0x1179, "(null)" },
    { 0x0A28, 0xff16, 0x1179, "(null)" },
    { 0x0A28, 0xff50, 0x1179, "(null)" },
    { 0x0A28, 0xc064, 0x144d, "(null)" },
    { 0x0A28, 0x0815, 0x152d, "(null)" },
    { 0x0A28, 0x0807, 0x1854, "(null)" },
    { 0x0A28, 0x903b, 0x1b0a, "(null)" },
    { 0x0A29, 0x0318, 0x1025, "(null)" },
    { 0x0A29, 0x035a, 0x1025, "(null)" },
    { 0x0A29, 0x036c, 0x1025, "(null)" },
    { 0x0A29, 0x036d, 0x1025, "(null)" },
    { 0x0A29, 0x0370, 0x1025, "(null)" },
    { 0x0A29, 0x0374, 0x1025, "(null)" },
    { 0x0A29, 0x037c, 0x1025, "(null)" },
    { 0x0A29, 0x040a, 0x1025, "(null)" },
    { 0x0A29, 0x0413, 0x1025, "(null)" },
    { 0x0A29, 0x0415, 0x1025, "(null)" },
    { 0x0A29, 0x0417, 0x1025, "(null)" },
    { 0x0A29, 0x041e, 0x1025, "(null)" },
    { 0x0A29, 0x0424, 0x1025, "(null)" },
    { 0x0A29, 0x0434, 0x1025, "(null)" },
    { 0x0A29, 0x0450, 0x1025, "(null)" },
    { 0x0A29, 0x0464, 0x1025, "(null)" },
    { 0x0A29, 0x0442, 0x1028, "(null)" },
    { 0x0A29, 0x0467, 0x1028, "(null)" },
    { 0x0A29, 0x0468, 0x1028, "(null)" },
    { 0x0A29, 0x046d, 0x1028, "(null)" },
    { 0x0A29, 0x046e, 0x1028, "(null)" },
    { 0x0A29, 0x9067, 0x104d, "(null)" },
    { 0x0A29, 0x00c7, 0x106b, "(null)" },
    { 0x0A29, 0x00c8, 0x106b, "(null)" },
    { 0x0A29, 0x0644, 0x1071, "(null)" },
    { 0x0A29, 0x1583, 0x10cf, "(null)" },
    { 0x0A29, 0x1587, 0x10cf, "(null)" },
    { 0x0A29, 0x0001, 0x1179, "(null)" },
    { 0x0A29, 0xfd22, 0x1179, "(null)" },
    { 0x0A29, 0xfd30, 0x1179, "(null)" },
    { 0x0A29, 0xfd31, 0x1179, "(null)" },
    { 0x0A29, 0xff00, 0x1179, "(null)" },
    { 0x0A29, 0xff16, 0x1179, "(null)" },
    { 0x0A29, 0xff50, 0x1179, "(null)" },
    { 0x0A29, 0xb06d, 0x144d, "(null)" },
    { 0x0A29, 0xb071, 0x144d, "(null)" },
    { 0x0A29, 0xc06a, 0x144d, "(null)" },
    { 0x0A29, 0xc06d, 0x144d, "(null)" },
    { 0x0A29, 0xc075, 0x144d, "(null)" },
    { 0x0A29, 0xc078, 0x144d, "(null)" },
    { 0x0A29, 0xc079, 0x144d, "(null)" },
    { 0x0A29, 0xc08e, 0x144d, "(null)" },
    { 0x0A29, 0xc094, 0x144d, "(null)" },
    { 0x0A29, 0xc551, 0x144d, "(null)" },
    { 0x0A29, 0xc562, 0x144d, "(null)" },
    { 0x0A29, 0x0055, 0x14c0, "(null)" },
    { 0x0A29, 0x4101, 0x1558, "(null)" },
    { 0x0A29, 0x7110, 0x1558, "(null)" },
    { 0x0A29, 0x396c, 0x17aa, "(null)" },
    { 0x0A29, 0x396e, 0x17aa, "(null)" },
    { 0x0A29, 0x010c, 0x17c0, "(null)" },
    { 0x0A29, 0x10d0, 0x17c0, "(null)" },
    { 0x0A29, 0x10d2, 0x17c0, "(null)" },
    { 0x0A29, 0x10d3, 0x17c0, "(null)" },
    { 0x0A29, 0x10d9, 0x17c0, "(null)" },
    { 0x0A29, 0x00b9, 0x1b0a, "(null)" },
    { 0x0A2A, 0x905e, 0x104d, "(null)" },
    { 0x0A2A, 0x0001, 0x1179, "(null)" },
    { 0x0A2A, 0x10ca, 0x17c0, "(null)" },
    { 0x0A2B, 0x905a, 0x104d, "(null)" },
    { 0x0A2B, 0x9072, 0x104d, "(null)" },
    { 0x0A2B, 0x4011, 0x1071, "(null)" },
    { 0x0A2B, 0x500a, 0x1071, "(null)" },
    { 0x0A2B, 0xa038, 0x1071, "(null)" },
    { 0x0A2B, 0x0001, 0x1179, "(null)" },
    { 0x0A2B, 0xfd80, 0x1179, "(null)" },
    { 0x0A2B, 0x0052, 0x14c0, "(null)" },
    { 0x0A2B, 0x00ab, 0x1b0a, "(null)" },
    { 0x0A2C, 0x1521, 0x103c, "(null)" },
    { 0x0A2C, 0x2144, 0x17aa, "(null)" },
    { 0x0A2D, 0x036d, 0x1025, "(null)" },
    { 0x0A2D, 0x0370, 0x1025, "(null)" },
    { 0x0A2D, 0x0374, 0x1025, "(null)" },
    { 0x0A2D, 0x037c, 0x1025, "(null)" },
    { 0x0A2D, 0x0417, 0x1025, "(null)" },
    { 0x0A2D, 0x0487, 0x1025, "(null)" },
    { 0x0A2D, 0x3659, 0x103c, "(null)" },
    { 0x0A2D, 0x365c, 0x103c, "(null)" },
    { 0x0A2D, 0x1312, 0x1043, "(null)" },
    { 0x0A2D, 0x9072, 0x104d, "(null)" },
    { 0x0A2D, 0xc560, 0x144d, "(null)" },
    { 0x0A2D, 0x209b, 0x1b0a, "(null)" },
    { 0x0A34, 0x0201, 0x1025, "(null)" },
    { 0x0A34, 0x020e, 0x1025, "(null)" },
    { 0x0A34, 0x0219, 0x1025, "(null)" },
    { 0x0A34, 0x021e, 0x1025, "(null)" },
    { 0x0A34, 0x0252, 0x1025, "(null)" },
    { 0x0A34, 0x0259, 0x1025, "(null)" },
    { 0x0A34, 0x026b, 0x1025, "(null)" },
    { 0x0A34, 0x0299, 0x1025, "(null)" },
    { 0x0A34, 0x02a2, 0x1028, "(null)" },
    { 0x0A34, 0x1ae2, 0x1043, "(null)" },
    { 0x0A34, 0x202a, 0x1043, "(null)" },
    { 0x0A34, 0x2031, 0x1043, "(null)" },
    { 0x0A34, 0x2034, 0x1043, "(null)" },
    { 0x0A34, 0x2036, 0x1043, "(null)" },
    { 0x0A34, 0x203a, 0x1043, "(null)" },
    { 0x0A34, 0x2040, 0x1043, "(null)" },
    { 0x0A34, 0x9072, 0x1071, "(null)" },
    { 0x0A34, 0x1013, 0x1462, "(null)" },
    { 0x0A34, 0x102e, 0x1462, "(null)" },
    { 0x0A34, 0x1031, 0x1462, "(null)" },
    { 0x0A34, 0x4570, 0x1462, "(null)" },
    { 0x0A34, 0x0828, 0x152d, "(null)" },
    { 0x0A34, 0x3928, 0x1642, "(null)" },
    { 0x0A34, 0x118d, 0x1734, "(null)" },
    { 0x0A34, 0x118e, 0x1734, "(null)" },
    { 0x0A34, 0x38cd, 0x17aa, "(null)" },
    { 0x0A34, 0x38fd, 0x17aa, "(null)" },
    { 0x0A34, 0x38ff, 0x17aa, "(null)" },
    { 0x0A34, 0x10d0, 0x17c0, "(null)" },
    { 0x0A34, 0x208d, 0x17c0, "(null)" },
    { 0x0A35, 0x1242, 0x1043, "(null)" },
    { 0x0A35, 0x1252, 0x1043, "(null)" },
    { 0x0A35, 0x1272, 0x1043, "(null)" },
    { 0x0A35, 0x1292, 0x1043, "(null)" },
    { 0x0A35, 0x14f2, 0x1043, "(null)" },
    { 0x0A35, 0x1f17, 0x1043, "(null)" },
    { 0x0A35, 0x1063, 0x1462, "(null)" },
    { 0x0A35, 0x106d, 0x1462, "(null)" },
    { 0x0A35, 0x1075, 0x1462, "(null)" },
    { 0x0A35, 0x2052, 0x1b0a, "(null)" },
    { 0x0A38, 0x0893, 0x10de, "(null)" },
    { 0x0A3C, 0x040c, 0x1028, "(null)" },
    { 0x0A3C, 0x1521, 0x103c, "(null)" },
    { 0x0A3C, 0x1584, 0x10cf, "(null)" },
    { 0x0A3C, 0x0706, 0x10de, "(null)" },
    { 0x0A3C, 0x0511, 0x1558, "(null)" },
    { 0x0A3C, 0x0512, 0x1558, "(null)" },
    { 0x0A3C, 0x2145, 0x17aa, "(null)" },
    { 0x0A60, 0x8082, 0x144d, "(null)" },
    { 0x0A60, 0x2014, 0x1462, "(null)" },
    { 0x0A60, 0x2180, 0x174b, "(null)" },
    { 0x0A60, 0x9045, 0x1b0a, "(null)" },
    { 0x0A60, 0x9057, 0x1b0a, "(null)" },
    { 0x0A62, 0x1833, 0x1462, "(null)" },
    { 0x0A62, 0x2050, 0x174b, "(null)" },
    { 0x0A62, 0x2052, 0x174b, "(null)" },
    { 0x0A62, 0x5122, 0x174b, "(null)" },
    { 0x0A64, 0x039d, 0x1025, "(null)" },
    { 0x0A64, 0x045e, 0x1025, "(null)" },
    { 0x0A64, 0x063c, 0x1025, "(null)" },
    { 0x0A64, 0x841f, 0x1043, "(null)" },
    { 0x0A64, 0x842f, 0x1043, "(null)" },
    { 0x0A64, 0x8455, 0x1043, "(null)" },
    { 0x0A64, 0x845b, 0x1043, "(null)" },
    { 0x0A64, 0x845e, 0x1043, "(null)" },
    { 0x0A64, 0xac41, 0x1462, "(null)" },
    { 0x0A64, 0x0a64, 0x1849, "(null)" },
    { 0x0A64, 0x00ce, 0x1b0a, "(null)" },
    { 0x0A66, 0x8356, 0x1043, "(null)" },
    { 0x0A66, 0x8368, 0x1043, "(null)" },
    { 0x0A66, 0x1837, 0x1462, "(null)" },
    { 0x0A66, 0x1838, 0x1462, "(null)" },
    { 0x0A66, 0x1839, 0x1462, "(null)" },
    { 0x0A66, 0x3958, 0x1642, "(null)" },
    { 0x0A66, 0x3998, 0x1642, "(null)" },
    { 0x0A66, 0x1122, 0x19da, "(null)" },
    { 0x0A67, 0x9075, 0x1b0a, "(null)" },
    { 0x0A68, 0x3659, 0x103c, "(null)" },
    { 0x0A68, 0x365c, 0x103c, "(null)" },
    { 0x0A68, 0xa036, 0x1071, "(null)" },
    { 0x0A68, 0xc059, 0x144d, "(null)" },
    { 0x0A68, 0xc064, 0x144d, "(null)" },
    { 0x0A68, 0x1032, 0x1462, "(null)" },
    { 0x0A68, 0x1034, 0x1462, "(null)" },
    { 0x0A68, 0x5584, 0x1991, "(null)" },
    { 0x0A69, 0x0418, 0x1028, "(null)" },
    { 0x0A69, 0x3650, 0x103c, "(null)" },
    { 0x0A69, 0xc525, 0x144d, "(null)" },
    { 0x0A69, 0xc544, 0x144d, "(null)" },
    { 0x0A69, 0x3905, 0x17aa, "(null)" },
    { 0x0A6A, 0x0001, 0x1179, "(null)" },
    { 0x0A6A, 0x0002, 0x1179, "(null)" },
    { 0x0A6C, 0x040a, 0x1028, "(null)" },
    { 0x0A6C, 0x040b, 0x1028, "(null)" },
    { 0x0A6C, 0x172b, 0x103c, "(null)" },
    { 0x0A6C, 0x2142, 0x17aa, "(null)" },
    { 0x0A6C, 0x215c, 0x17aa, "(null)" },
    { 0x0A6C, 0x21c0, 0x17aa, "(null)" },
    { 0x0A6C, 0x21cc, 0x17aa, "(null)" },
    { 0x0A6C, 0x21cd, 0x17aa, "(null)" },
    { 0x0A6C, 0x21d4, 0x17aa, "(null)" },
    { 0x0A6C, 0x21d5, 0x17aa, "(null)" },
    { 0x0A6C, 0x21d7, 0x17aa, "(null)" },
    { 0x0A6C, 0x21d8, 0x17aa, "(null)" },
    { 0x0A6C, 0x38a4, 0x17aa, "(null)" },
    { 0x0A6C, 0x391a, 0x17aa, "(null)" },
    { 0x0A6E, 0x0d58, 0x105b, "(null)" },
    { 0x0A6E, 0xff16, 0x1179, "(null)" },
    { 0x0A6E, 0xff17, 0x1179, "(null)" },
    { 0x0A6E, 0x3607, 0x17aa, "(null)" },
    { 0x0A6E, 0x395a, 0x17aa, "(null)" },
    { 0x0A6E, 0x3963, 0x17aa, "(null)" },
    { 0x0A6E, 0x396d, 0x17aa, "(null)" },
    { 0x0A6E, 0x10cf, 0x17c0, "(null)" },
    { 0x0A6F, 0x0470, 0x1025, "(null)" },
    { 0x0A6F, 0x846f, 0x1043, "(null)" },
    { 0x0A6F, 0x8470, 0x1043, "(null)" },
    { 0x0A6F, 0x4003, 0x1297, "(null)" },
    { 0x0A6F, 0x9001, 0x159e, "(null)" },
    { 0x0A70, 0x0370, 0x1025, "(null)" },
    { 0x0A70, 0x0374, 0x1025, "(null)" },
    { 0x0A70, 0x037c, 0x1025, "(null)" },
    { 0x0A70, 0x040a, 0x1025, "(null)" },
    { 0x0A70, 0x0413, 0x1025, "(null)" },
    { 0x0A70, 0x0415, 0x1025, "(null)" },
    { 0x0A70, 0x0417, 0x1025, "(null)" },
    { 0x0A70, 0x041e, 0x1025, "(null)" },
    { 0x0A70, 0x0424, 0x1025, "(null)" },
    { 0x0A70, 0x0452, 0x1025, "(null)" },
    { 0x0A70, 0x0453, 0x1025, "(null)" },
    { 0x0A70, 0x047e, 0x1025, "(null)" },
    { 0x0A70, 0x047d, 0x1028, "(null)" },
    { 0x0A70, 0x0483, 0x1028, "(null)" },
    { 0x0A70, 0x357f, 0x103c, "(null)" },
    { 0x0A70, 0x12d2, 0x1043, "(null)" },
    { 0x0A70, 0x1352, 0x1043, "(null)" },
    { 0x0A70, 0x1362, 0x1043, "(null)" },
    { 0x0A70, 0x1372, 0x1043, "(null)" },
    { 0x0A70, 0x13f2, 0x1043, "(null)" },
    { 0x0A70, 0x1432, 0x1043, "(null)" },
    { 0x0A70, 0x14c2, 0x1043, "(null)" },
    { 0x0A70, 0x1542, 0x1043, "(null)" },
    { 0x0A70, 0x8458, 0x1043, "(null)" },
    { 0x0A70, 0x8459, 0x1043, "(null)" },
    { 0x0A70, 0x907e, 0x104d, "(null)" },
    { 0x0A70, 0x0cdd, 0x105b, "(null)" },
    { 0x0A70, 0x4000, 0x1071, "(null)" },
    { 0x0A70, 0x4001, 0x1071, "(null)" },
    { 0x0A70, 0xb301, 0x1071, "(null)" },
    { 0x0A70, 0xb302, 0x1071, "(null)" },
    { 0x0A70, 0x15b3, 0x10cf, "(null)" },
    { 0x0A70, 0xfd22, 0x1179, "(null)" },
    { 0x0A70, 0xfd30, 0x1179, "(null)" },
    { 0x0A70, 0xfd31, 0x1179, "(null)" },
    { 0x0A70, 0xfd80, 0x1179, "(null)" },
    { 0x0A70, 0xff20, 0x1179, "(null)" },
    { 0x0A70, 0xb06d, 0x144d, "(null)" },
    { 0x0A70, 0xb071, 0x144d, "(null)" },
    { 0x0A70, 0xc078, 0x144d, "(null)" },
    { 0x0A70, 0xc079, 0x144d, "(null)" },
    { 0x0A70, 0xc088, 0x144d, "(null)" },
    { 0x0A70, 0xc08b, 0x144d, "(null)" },
    { 0x0A70, 0xc094, 0x144d, "(null)" },
    { 0x0A70, 0xc557, 0x144d, "(null)" },
    { 0x0A70, 0xc562, 0x144d, "(null)" },
    { 0x0A70, 0xc568, 0x144d, "(null)" },
    { 0x0A70, 0x1100, 0x1458, "(null)" },
    { 0x0A70, 0x1063, 0x1462, "(null)" },
    { 0x0A70, 0x1068, 0x1462, "(null)" },
    { 0x0A70, 0x106d, 0x1462, "(null)" },
    { 0x0A70, 0x1070, 0x1462, "(null)" },
    { 0x0A70, 0x0052, 0x14c0, "(null)" },
    { 0x0A70, 0x3605, 0x17aa, "(null)" },
    { 0x0A70, 0x3617, 0x17aa, "(null)" },
    { 0x0A70, 0x3955, 0x17aa, "(null)" },
    { 0x0A70, 0x3966, 0x17aa, "(null)" },
    { 0x0A70, 0x3968, 0x17aa, "(null)" },
    { 0x0A70, 0x396d, 0x17aa, "(null)" },
    { 0x0A70, 0x3970, 0x17aa, "(null)" },
    { 0x0A70, 0x3971, 0x17aa, "(null)" },
    { 0x0A70, 0x010c, 0x17c0, "(null)" },
    { 0x0A70, 0x0845, 0x1854, "(null)" },
    { 0x0A70, 0x0847, 0x1854, "(null)" },
    { 0x0A70, 0x0849, 0x1854, "(null)" },
    { 0x0A70, 0x2011, 0x1854, "(null)" },
    { 0x0A70, 0x940a, 0x1afa, "(null)" },
    { 0x0A70, 0x00d8, 0x1b0a, "(null)" },
    { 0x0A70, 0x00ec, 0x1b0a, "(null)" },
    { 0x0A70, 0x2065, 0x1b0a, "(null)" },
    { 0x0A70, 0x206f, 0x1b0a, "(null)" },
    { 0x0A70, 0x2090, 0x1b0a, "(null)" },
    { 0x0A70, 0x1001, 0x1bab, "(null)" },
    { 0x0A71, 0x1100, 0x1458, "(null)" },
    { 0x0A71, 0x395a, 0x17aa, "(null)" },
    { 0x0A71, 0x3963, 0x17aa, "(null)" },
    { 0x0A72, 0x041c, 0x1025, "(null)" },
    { 0x0A72, 0x041e, 0x1025, "(null)" },
    { 0x0A72, 0x0434, 0x1025, "(null)" },
    { 0x0A72, 0x0450, 0x1025, "(null)" },
    { 0x0A72, 0x1332, 0x1043, "(null)" },
    { 0x0A72, 0x1372, 0x1043, "(null)" },
    { 0x0A72, 0x0d58, 0x105b, "(null)" },
    { 0x0A72, 0x4000, 0x1071, "(null)" },
    { 0x0A72, 0xb301, 0x1071, "(null)" },
    { 0x0A72, 0xfd31, 0x1179, "(null)" },
    { 0x0A72, 0xfd80, 0x1179, "(null)" },
    { 0x0A72, 0xc078, 0x144d, "(null)" },
    { 0x0A72, 0x4101, 0x1558, "(null)" },
    { 0x0A72, 0x3a02, 0x17aa, "(null)" },
    { 0x0A72, 0x10d2, 0x17c0, "(null)" },
    { 0x0A72, 0x2051, 0x1b0a, "(null)" },
    { 0x0A72, 0x2001, 0x1bfd, "(null)" },
    { 0x0A73, 0x0d58, 0x105b, "(null)" },
    { 0x0A73, 0x0d5e, 0x105b, "(null)" },
    { 0x0A73, 0x3607, 0x17aa, "(null)" },
    { 0x0A73, 0x3610, 0x17aa, "(null)" },
    { 0x0A73, 0x205c, 0x1b0a, "(null)" },
    { 0x0A74, 0x0201, 0x1025, "(null)" },
    { 0x0A74, 0x020e, 0x1025, "(null)" },
    { 0x0A74, 0x0219, 0x1025, "(null)" },
    { 0x0A74, 0x021e, 0x1025, "(null)" },
    { 0x0A74, 0x0252, 0x1025, "(null)" },
    { 0x0A74, 0x0259, 0x1025, "(null)" },
    { 0x0A74, 0x0296, 0x1025, "(null)" },
    { 0x0A74, 0x0299, 0x1025, "(null)" },
    { 0x0A74, 0x0271, 0x1028, "(null)" },
    { 0x0A74, 0x0490, 0x1028, "(null)" },
    { 0x0A74, 0x12a2, 0x1043, "(null)" },
    { 0x0A74, 0x1ac2, 0x1043, "(null)" },
    { 0x0A74, 0x1af2, 0x1043, "(null)" },
    { 0x0A74, 0x1bc2, 0x1043, "(null)" },
    { 0x0A74, 0x2037, 0x1043, "(null)" },
    { 0x0A74, 0x2038, 0x1043, "(null)" },
    { 0x0A74, 0x905e, 0x104d, "(null)" },
    { 0x0A74, 0x0001, 0x1179, "(null)" },
    { 0x0A74, 0x0002, 0x1179, "(null)" },
    { 0x0A74, 0xff00, 0x1179, "(null)" },
    { 0x0A74, 0xff15, 0x1179, "(null)" },
    { 0x0A74, 0xff16, 0x1179, "(null)" },
    { 0x0A74, 0xff40, 0x1179, "(null)" },
    { 0x0A74, 0xff50, 0x1179, "(null)" },
    { 0x0A74, 0xc540, 0x144d, "(null)" },
    { 0x0A74, 0x1015, 0x1462, "(null)" },
    { 0x0A74, 0x1023, 0x1462, "(null)" },
    { 0x0A74, 0x1049, 0x1462, "(null)" },
    { 0x0A74, 0x1051, 0x1462, "(null)" },
    { 0x0A74, 0x4570, 0x1462, "(null)" },
    { 0x0A74, 0x0048, 0x14c0, "(null)" },
    { 0x0A74, 0x0814, 0x152d, "(null)" },
    { 0x0A74, 0x0808, 0x1558, "(null)" },
    { 0x0A74, 0x3940, 0x1642, "(null)" },
    { 0x0A74, 0x2142, 0x17aa, "(null)" },
    { 0x0A74, 0x389f, 0x17aa, "(null)" },
    { 0x0A74, 0x38ce, 0x17aa, "(null)" },
    { 0x0A74, 0x38fe, 0x17aa, "(null)" },
    { 0x0A74, 0x3900, 0x17aa, "(null)" },
    { 0x0A74, 0x10d0, 0x17c0, "(null)" },
    { 0x0A74, 0x208d, 0x17c0, "(null)" },
    { 0x0A74, 0x0800, 0x1854, "(null)" },
    { 0x0A74, 0x0805, 0x1854, "(null)" },
    { 0x0A74, 0x903a, 0x1b0a, "(null)" },
    { 0x0A75, 0x0318, 0x1025, "(null)" },
    { 0x0A75, 0x035a, 0x1025, "(null)" },
    { 0x0A75, 0x0370, 0x1025, "(null)" },
    { 0x0A75, 0x0374, 0x1025, "(null)" },
    { 0x0A75, 0x037c, 0x1025, "(null)" },
    { 0x0A75, 0x040a, 0x1025, "(null)" },
    { 0x0A75, 0x0413, 0x1025, "(null)" },
    { 0x0A75, 0x0415, 0x1025, "(null)" },
    { 0x0A75, 0x0417, 0x1025, "(null)" },
    { 0x0A75, 0x0424, 0x1025, "(null)" },
    { 0x0A75, 0x0452, 0x1025, "(null)" },
    { 0x0A75, 0x0453, 0x1025, "(null)" },
    { 0x0A75, 0x0464, 0x1025, "(null)" },
    { 0x0A75, 0x043f, 0x1028, "(null)" },
    { 0x0A75, 0x0440, 0x1028, "(null)" },
    { 0x0A75, 0x0441, 0x1028, "(null)" },
    { 0x0A75, 0x1c22, 0x1043, "(null)" },
    { 0x0A75, 0x842f, 0x1043, "(null)" },
    { 0x0A75, 0x9067, 0x104d, "(null)" },
    { 0x0A75, 0x9069, 0x104d, "(null)" },
    { 0x0A75, 0x9072, 0x104d, "(null)" },
    { 0x0A75, 0x907a, 0x104d, "(null)" },
    { 0x0A75, 0x0d58, 0x105b, "(null)" },
    { 0x0A75, 0x4000, 0x1071, "(null)" },
    { 0x0A75, 0xb301, 0x1071, "(null)" },
    { 0x0A75, 0x1581, 0x10cf, "(null)" },
    { 0x0A75, 0x1582, 0x10cf, "(null)" },
    { 0x0A75, 0x1586, 0x10cf, "(null)" },
    { 0x0A75, 0x0798, 0x10de, "(null)" },
    { 0x0A75, 0xfd30, 0x1179, "(null)" },
    { 0x0A75, 0xfd80, 0x1179, "(null)" },
    { 0x0A75, 0xff00, 0x1179, "(null)" },
    { 0x0A75, 0xff16, 0x1179, "(null)" },
    { 0x0A75, 0xff17, 0x1179, "(null)" },
    { 0x0A75, 0xff40, 0x1179, "(null)" },
    { 0x0A75, 0xff50, 0x1179, "(null)" },
    { 0x0A75, 0xb06b, 0x144d, "(null)" },
    { 0x0A75, 0xc06a, 0x144d, "(null)" },
    { 0x0A75, 0xc06d, 0x144d, "(null)" },
    { 0x0A75, 0xc075, 0x144d, "(null)" },
    { 0x0A75, 0xc078, 0x144d, "(null)" },
    { 0x0A75, 0xc551, 0x144d, "(null)" },
    { 0x0A75, 0xc552, 0x144d, "(null)" },
    { 0x0A75, 0x0810, 0x152d, "(null)" },
    { 0x0A75, 0x0814, 0x152d, "(null)" },
    { 0x0A75, 0x0822, 0x152d, "(null)" },
    { 0x0A75, 0x0808, 0x1558, "(null)" },
    { 0x0A75, 0x3605, 0x17aa, "(null)" },
    { 0x0A75, 0x392d, 0x17aa, "(null)" },
    { 0x0A75, 0x3955, 0x17aa, "(null)" },
    { 0x0A75, 0x3957, 0x17aa, "(null)" },
    { 0x0A75, 0x3967, 0x17aa, "(null)" },
    { 0x0A75, 0x5958, 0x17aa, "(null)" },
    { 0x0A75, 0x10d0, 0x17c0, "(null)" },
    { 0x0A75, 0x10d2, 0x17c0, "(null)" },
    { 0x0A75, 0x0805, 0x1854, "(null)" },
    { 0x0A75, 0x0821, 0x1854, "(null)" },
    { 0x0A75, 0x5584, 0x1991, "(null)" },
    { 0x0A75, 0x840a, 0x1afa, "(null)" },
    { 0x0A75, 0x9a30, 0x1afa, "(null)" },
    { 0x0A75, 0x00b9, 0x1b0a, "(null)" },
    { 0x0A75, 0x00d8, 0x1b0a, "(null)" },
    { 0x0A75, 0x00ec, 0x1b0a, "(null)" },
    { 0x0A75, 0x2036, 0x1b0a, "(null)" },
    { 0x0A75, 0x2040, 0x1b0a, "(null)" },
    { 0x0A76, 0x8446, 0x1043, "(null)" },
    { 0x0A76, 0x8447, 0x1043, "(null)" },
    { 0x0A76, 0x4003, 0x1297, "(null)" },
    { 0x0A78, 0x0746, 0x10de, "(null)" },
    { 0x0A7A, 0x907e, 0x104d, "(null)" },
    { 0x0A7A, 0xfc50, 0x1179, "(null)" },
    { 0x0A7A, 0xfc61, 0x1179, "(null)" },
    { 0x0A7A, 0xfc71, 0x1179, "(null)" },
    { 0x0A7A, 0xfc90, 0x1179, "(null)" },
    { 0x0A7A, 0xfcc0, 0x1179, "(null)" },
    { 0x0A7A, 0xfcd0, 0x1179, "(null)" },
    { 0x0A7A, 0xfce2, 0x1179, "(null)" },
    { 0x0A7A, 0xfcf2, 0x1179, "(null)" },
    { 0x0A7A, 0xfd16, 0x1179, "(null)" },
    { 0x0A7A, 0xfd40, 0x1179, "(null)" },
    { 0x0A7A, 0xfd50, 0x1179, "(null)" },
    { 0x0A7A, 0xfd52, 0x1179, "(null)" },
    { 0x0A7A, 0xfd61, 0x1179, "(null)" },
    { 0x0A7A, 0xfd71, 0x1179, "(null)" },
    { 0x0A7A, 0xfd92, 0x1179, "(null)" },
    { 0x0A7A, 0xfd96, 0x1179, "(null)" },
    { 0x0A7A, 0xfdd0, 0x1179, "(null)" },
    { 0x0A7A, 0xfdd2, 0x1179, "(null)" },
    { 0x0A7A, 0xfdfe, 0x1179, "(null)" },
    { 0x0A7A, 0xc0a2, 0x144d, "(null)" },
    { 0x0A7A, 0xc0b2, 0x144d, "(null)" },
    { 0x0A7A, 0xc581, 0x144d, "(null)" },
    { 0x0A7A, 0xc587, 0x144d, "(null)" },
    { 0x0A7A, 0xc588, 0x144d, "(null)" },
    { 0x0A7A, 0xc597, 0x144d, "(null)" },
    { 0x0A7A, 0xc606, 0x144d, "(null)" },
    { 0x0A7A, 0xaa51, 0x1462, "(null)" },
    { 0x0A7A, 0xaa58, 0x1462, "(null)" },
    { 0x0A7A, 0xac71, 0x1462, "(null)" },
    { 0x0A7A, 0xac81, 0x1462, "(null)" },
    { 0x0A7A, 0xac82, 0x1462, "(null)" },
    { 0x0A7A, 0xae33, 0x1462, "(null)" },
    { 0x0A7A, 0x3980, 0x1642, "(null)" },
    { 0x0A7A, 0x3950, 0x17aa, "(null)" },
    { 0x0A7A, 0x397d, 0x17aa, "(null)" },
    { 0x0A7A, 0x2091, 0x1b0a, "(null)" },
    { 0x0A7A, 0x90b4, 0x1b0a, "(null)" },
    { 0x0A7A, 0x0003, 0x1bfd, "(null)" },
    { 0x0A7A, 0x8006, 0x1bfd, "(null)" },
    { 0x0A7A, 0x8007, 0x1bfd, "(null)" },
    { 0x0A7B, 0x183d, 0x1462, "(null)" },
    { 0x0A7C, 0x172b, 0x103c, "(null)" },
    { 0x0CA0, 0x3926, 0x1642, "(null)" },
    { 0x0CA2, 0x1915, 0x10de, "(null)" },
    { 0x0CA2, 0x1914, 0x1462, "(null)" },
    { 0x0CA2, 0x1917, 0x1462, "(null)" },
    { 0x0CA2, 0x1918, 0x1462, "(null)" },
    { 0x0CA3, 0x069d, 0x10de, "(null)" },
    { 0x0CA3, 0x3926, 0x1642, "(null)" },
    { 0x0CA9, 0x026b, 0x1025, "(null)" },
    { 0x0CA9, 0x2033, 0x1043, "(null)" },
    { 0x0CA9, 0xff50, 0x1179, "(null)" },
    { 0x0CA9, 0x1024, 0x1462, "(null)" },
    { 0x0CA9, 0x102f, 0x1462, "(null)" },
    { 0x0CA9, 0x1035, 0x1462, "(null)" },
    { 0x0CA9, 0x3942, 0x1642, "(null)" },
    { 0x0CAF, 0x0463, 0x1025, "(null)" },
    { 0x0CAF, 0x0443, 0x1028, "(null)" },
    { 0x0CAF, 0x0465, 0x1028, "(null)" },
    { 0x0CAF, 0x1242, 0x1043, "(null)" },
    { 0x0CAF, 0x1282, 0x1043, "(null)" },
    { 0x0CAF, 0x12b2, 0x1043, "(null)" },
    { 0x0CAF, 0x1342, 0x1043, "(null)" },
    { 0x0CAF, 0x13d2, 0x1043, "(null)" },
    { 0x0CAF, 0x1422, 0x1043, "(null)" },
    { 0x0CAF, 0x1462, 0x1043, "(null)" },
    { 0x0CAF, 0x1482, 0x1043, "(null)" },
    { 0x0CAF, 0x14b2, 0x1043, "(null)" },
    { 0x0CAF, 0x1502, 0x1043, "(null)" },
    { 0x0CAF, 0x1fb2, 0x1043, "(null)" },
    { 0x0CAF, 0x0cdd, 0x105b, "(null)" },
    { 0x0CAF, 0x1585, 0x10cf, "(null)" },
    { 0x0CAF, 0x0782, 0x10de, "(null)" },
    { 0x0CAF, 0xff50, 0x1179, "(null)" },
    { 0x0CAF, 0x0813, 0x152d, "(null)" },
    { 0x0CAF, 0x0831, 0x152d, "(null)" },
    { 0x0CAF, 0x10d0, 0x17c0, "(null)" },
    { 0x0CAF, 0x10d3, 0x17c0, "(null)" },
    { 0x0CAF, 0x0804, 0x1854, "(null)" },
    { 0x0CAF, 0x0832, 0x1854, "(null)" },
    { 0x0CB0, 0x080d, 0x10de, "(null)" },
    { 0x0CB0, 0xfd30, 0x1179, "(null)" },
    { 0x0CB0, 0xff50, 0x1179, "(null)" },
    { 0x0CB0, 0x8687, 0x1558, "(null)" },
    { 0x0CB0, 0x8689, 0x1558, "(null)" },
    { 0x0CB1, 0x203c, 0x1043, "(null)" },
    { 0x0CB1, 0xff50, 0x1179, "(null)" },
    { 0x0CB1, 0x8687, 0x1558, "(null)" },
    { 0x0CB1, 0x8689, 0x1558, "(null)" },
    { 0x0CBC, 0x040c, 0x1028, "(null)" },
    { 0x0CBC, 0x1521, 0x103c, "(null)" },
    { 0x0DC0, 0x1005, 0x1019, "(null)" },
    { 0x0DC0, 0x082d, 0x10de, "(null)" },
    { 0x0DC0, 0x2310, 0x1462, "(null)" },
    { 0x0DC0, 0x2311, 0x1462, "(null)" },
    { 0x0DC0, 0x2312, 0x1462, "(null)" },
    { 0x0DC0, 0x3a28, 0x1642, "(null)" },
    { 0x0DC0, 0x1178, 0x174b, "(null)" },
    { 0x0DC0, 0x2178, 0x174b, "(null)" },
    { 0x0DC4, 0x837a, 0x1043, "(null)" },
    { 0x0DC4, 0xc000, 0x1458, "(null)" },
    { 0x0DC5, 0x1007, 0x1019, "(null)" },
    { 0x0DC5, 0x1011, 0x1019, "(null)" },
    { 0x0DC5, 0x085b, 0x10de, "(null)" },
    { 0x0DC5, 0x1184, 0x174b, "(null)" },
    { 0x0DC6, 0x2362, 0x1462, "(null)" },
    { 0x0DCD, 0x0491, 0x1028, "(null)" },
    { 0x0DCD, 0x04b7, 0x1028, "(null)" },
    { 0x0DCD, 0x04b8, 0x1028, "(null)" },
    { 0x0DCD, 0x1525, 0x1458, "(null)" },
    { 0x0DCD, 0x1532, 0x1458, "(null)" },
    { 0x0DCD, 0x10a2, 0x1462, "(null)" },
    { 0x0DCE, 0x0564, 0x1025, "(null)" },
    { 0x0DCE, 0x0565, 0x1025, "(null)" },
    { 0x0DCE, 0x0566, 0x1025, "(null)" },
    { 0x0DCE, 0x204c, 0x1043, "(null)" },
    { 0x0DCE, 0x204e, 0x1043, "(null)" },
    { 0x0DCE, 0x2051, 0x1043, "(null)" },
    { 0x0DCE, 0x1525, 0x1458, "(null)" },
    { 0x0DCE, 0x1532, 0x1458, "(null)" },
    { 0x0DCE, 0x0875, 0x152d, "(null)" },
    { 0x0DCE, 0x1500, 0x1558, "(null)" },
    { 0x0DCE, 0x1700, 0x1558, "(null)" },
    { 0x0DCE, 0x20a6, 0x1b0a, "(null)" },
    { 0x0DD1, 0x02a2, 0x1028, "(null)" },
    { 0x0DD1, 0x048f, 0x1028, "(null)" },
    { 0x0DD1, 0x0490, 0x1028, "(null)" },
    { 0x0DD1, 0x0491, 0x1028, "(null)" },
    { 0x0DD1, 0x04b9, 0x1028, "(null)" },
    { 0x0DD1, 0x04ba, 0x1028, "(null)" },
    { 0x0DD1, 0x203d, 0x1043, "(null)" },
    { 0x0DD1, 0x2040, 0x1043, "(null)" },
    { 0x0DD1, 0x2041, 0x1043, "(null)" },
    { 0x0DD1, 0x2042, 0x1043, "(null)" },
    { 0x0DD1, 0x2043, 0x1043, "(null)" },
    { 0x0DD1, 0x2044, 0x1043, "(null)" },
    { 0x0DD1, 0x2045, 0x1043, "(null)" },
    { 0x0DD1, 0x2046, 0x1043, "(null)" },
    { 0x0DD1, 0x2047, 0x1043, "(null)" },
    { 0x0DD1, 0x2048, 0x1043, "(null)" },
    { 0x0DD1, 0x204a, 0x1043, "(null)" },
    { 0x0DD1, 0x204b, 0x1043, "(null)" },
    { 0x0DD1, 0x8465, 0x1043, "(null)" },
    { 0x0DD1, 0xfcb0, 0x1179, "(null)" },
    { 0x0DD1, 0xff50, 0x1179, "(null)" },
    { 0x0DD1, 0x1083, 0x1462, "(null)" },
    { 0x0DD1, 0x5102, 0x1558, "(null)" },
    { 0x0DD1, 0x7100, 0x1558, "(null)" },
    { 0x0DD1, 0x7200, 0x1558, "(null)" },
    { 0x0DD1, 0x8100, 0x1558, "(null)" },
    { 0x0DD1, 0x8687, 0x1558, "(null)" },
    { 0x0DD1, 0x3620, 0x17aa, "(null)" },
    { 0x0DD1, 0x10ea, 0x17c0, "(null)" },
    { 0x0DD2, 0x046c, 0x1028, "(null)" },
    { 0x0DD2, 0x0491, 0x1028, "(null)" },
    { 0x0DD2, 0x0854, 0x152d, "(null)" },
    { 0x0DD3, 0x046c, 0x1028, "(null)" },
    { 0x0DD6, 0x04b7, 0x1028, "(null)" },
    { 0x0DD6, 0x04b8, 0x1028, "(null)" },
    { 0x0DD8, 0x084a, 0x103c, "(null)" },
    { 0x0DD8, 0x0914, 0x103c, "(null)" },
    { 0x0DD8, 0x084a, 0x10de, "(null)" },
    { 0x0DD8, 0x0914, 0x10de, "(null)" },
    { 0x0DDA, 0x04a3, 0x1028, "(null)" },
    { 0x0DDA, 0x14a3, 0x1028, "(null)" },
    { 0x0DDA, 0x1631, 0x103c, "(null)" },
    { 0x0DDA, 0x21cf, 0x17aa, "(null)" },
    { 0x0DDA, 0x21d1, 0x17aa, "(null)" },
    { 0x0DE0, 0xc000, 0x1458, "(null)" },
    { 0x0DE0, 0xaa73, 0x1462, "(null)" },
    { 0x0DE1, 0x836d, 0x1043, "(null)" },
    { 0x0DE1, 0xc000, 0x1458, "(null)" },
    { 0x0DE1, 0x2302, 0x1462, "(null)" },
    { 0x0DE1, 0x2303, 0x1462, "(null)" },
    { 0x0DE1, 0x2305, 0x1462, "(null)" },
    { 0x0DE1, 0x3a26, 0x1642, "(null)" },
    { 0x0DE1, 0x3162, 0x19da, "(null)" },
    { 0x0DE2, 0x1004, 0x1019, "(null)" },
    { 0x0DE2, 0x835f, 0x1043, "(null)" },
    { 0x0DE2, 0x2301, 0x1462, "(null)" },
    { 0x0DE2, 0x2302, 0x1462, "(null)" },
    { 0x0DE2, 0x3a26, 0x1642, "(null)" },
    { 0x0DE2, 0x1162, 0x174b, "(null)" },
    { 0x0DE2, 0x2162, 0x174b, "(null)" },
    { 0x0DE2, 0x9083, 0x1b0a, "(null)" },
    { 0x0DE3, 0x9995, 0x1019, "(null)" },
    { 0x0DE3, 0x181b, 0x103c, "(null)" },
    { 0x0DE3, 0x181d, 0x103c, "(null)" },
    { 0x0DE3, 0x189b, 0x103c, "(null)" },
    { 0x0DE3, 0x100d, 0x1043, "(null)" },
    { 0x0DE3, 0x10ac, 0x1043, "(null)" },
    { 0x0DE3, 0x10bc, 0x1043, "(null)" },
    { 0x0DE3, 0x10cc, 0x1043, "(null)" },
    { 0x0DE3, 0x112d, 0x1043, "(null)" },
    { 0x0DE3, 0x1447, 0x1043, "(null)" },
    { 0x0DE3, 0x1477, 0x1043, "(null)" },
    { 0x0DE3, 0x1547, 0x1043, "(null)" },
    { 0x0DE3, 0x1587, 0x1043, "(null)" },
    { 0x0DE3, 0x2137, 0x1043, "(null)" },
    { 0x0DE3, 0x2139, 0x1043, "(null)" },
    { 0x0DE3, 0x21da, 0x1043, "(null)" },
    { 0x0DE3, 0x10b8, 0x1462, "(null)" },
    { 0x0DE3, 0x0950, 0x152d, "(null)" },
    { 0x0DE3, 0x0989, 0x152d, "(null)" },
    { 0x0DE3, 0x0992, 0x152d, "(null)" },
    { 0x0DE3, 0x1006, 0x152d, "(null)" },
    { 0x0DE3, 0x1022, 0x152d, "(null)" },
    { 0x0DE3, 0x2706, 0x1558, "(null)" },
    { 0x0DE3, 0x3901, 0x17aa, "(null)" },
    { 0x0DE3, 0x3902, 0x17aa, "(null)" },
    { 0x0DE3, 0x3904, 0x17aa, "(null)" },
    { 0x0DE3, 0x5001, 0x17aa, "(null)" },
    { 0x0DE3, 0x5003, 0x17aa, "(null)" },
    { 0x0DE3, 0x5007, 0x17aa, "(null)" },
    { 0x0DE3, 0x5012, 0x17aa, "(null)" },
    { 0x0DE3, 0x20dc, 0x1b0a, "(null)" },
    { 0x0DE3, 0x20dd, 0x1b0a, "(null)" },
    { 0x0DE3, 0x20df, 0x1b0a, "(null)" },
    { 0x0DE3, 0x222a, 0x1b0a, "(null)" },
    { 0x0DE5, 0x839a, 0x1043, "(null)" },
    { 0x0DE5, 0x839b, 0x1043, "(null)" },
    { 0x0DE5, 0x2300, 0x1462, "(null)" },
    { 0x0DE5, 0x2309, 0x1462, "(null)" },
    { 0x0DE5, 0x230a, 0x1462, "(null)" },
    { 0x0DE5, 0x230c, 0x1462, "(null)" },
    { 0x0DE5, 0x230d, 0x1462, "(null)" },
    { 0x0DE5, 0x3a26, 0x1642, "(null)" },
    { 0x0DE5, 0x7162, 0x174b, "(null)" },
    { 0x0DE5, 0x90a1, 0x1b0a, "(null)" },
    { 0x0DE5, 0x90a3, 0x1b0a, "(null)" },
    { 0x0DE8, 0x9097, 0x104d, "(null)" },
    { 0x0DE8, 0x175c, 0x10cf, "(null)" },
    { 0x0DE8, 0x1763, 0x10cf, "(null)" },
    { 0x0DE8, 0x1765, 0x10cf, "(null)" },
    { 0x0DE8, 0x1767, 0x10cf, "(null)" },
    { 0x0DE8, 0x1769, 0x10cf, "(null)" },
    { 0x0DE8, 0xc652, 0x144d, "(null)" },
    { 0x0DE8, 0x006a, 0x14c0, "(null)" },
    { 0x0DE8, 0x006b, 0x14c0, "(null)" },
    { 0x0DE8, 0x006d, 0x14c0, "(null)" },
    { 0x0DE8, 0x0924, 0x152d, "(null)" },
    { 0x0DE8, 0x0970, 0x152d, "(null)" },
    { 0x0DE8, 0x0973, 0x152d, "(null)" },
    { 0x0DE8, 0x0975, 0x152d, "(null)" },
    { 0x0DE8, 0x0977, 0x152d, "(null)" },
    { 0x0DE8, 0x21fc, 0x17aa, "(null)" },
    { 0x0DE9, 0x22db, 0x1019, "(null)" },
    { 0x0DE9, 0x9995, 0x1019, "(null)" },
    { 0x0DE9, 0x999d, 0x1019, "(null)" },
    { 0x0DE9, 0x0487, 0x1025, "(null)" },
    { 0x0DE9, 0x0488, 0x1025, "(null)" },
    { 0x0DE9, 0x0505, 0x1025, "(null)" },
    { 0x0DE9, 0x0507, 0x1025, "(null)" },
    { 0x0DE9, 0x0512, 0x1025, "(null)" },
    { 0x0DE9, 0x0573, 0x1025, "(null)" },
    { 0x0DE9, 0x0574, 0x1025, "(null)" },
    { 0x0DE9, 0x0575, 0x1025, "(null)" },
    { 0x0DE9, 0x0646, 0x1025, "(null)" },
    { 0x0DE9, 0x0648, 0x1025, "(null)" },
    { 0x0DE9, 0x064a, 0x1025, "(null)" },
    { 0x0DE9, 0x064c, 0x1025, "(null)" },
    { 0x0DE9, 0x0679, 0x1025, "(null)" },
    { 0x0DE9, 0x067a, 0x1025, "(null)" },
    { 0x0DE9, 0x0680, 0x1025, "(null)" },
    { 0x0DE9, 0x0686, 0x1025, "(null)" },
    { 0x0DE9, 0x0689, 0x1025, "(null)" },
    { 0x0DE9, 0x068b, 0x1025, "(null)" },
    { 0x0DE9, 0x068d, 0x1025, "(null)" },
    { 0x0DE9, 0x068f, 0x1025, "(null)" },
    { 0x0DE9, 0x0692, 0x1025, "(null)" },
    { 0x0DE9, 0x069b, 0x1025, "(null)" },
    { 0x0DE9, 0x069e, 0x1025, "(null)" },
    { 0x0DE9, 0x0702, 0x1025, "(null)" },
    { 0x0DE9, 0x0719, 0x1025, "(null)" },
    { 0x0DE9, 0x0721, 0x1025, "(null)" },
    { 0x0DE9, 0x0722, 0x1025, "(null)" },
    { 0x0DE9, 0x0723, 0x1025, "(null)" },
    { 0x0DE9, 0x0725, 0x1025, "(null)" },
    { 0x0DE9, 0x0728, 0x1025, "(null)" },
    { 0x0DE9, 0x072b, 0x1025, "(null)" },
    { 0x0DE9, 0x072e, 0x1025, "(null)" },
    { 0x0DE9, 0x0732, 0x1025, "(null)" },
    { 0x0DE9, 0x073f, 0x1025, "(null)" },
    { 0x0DE9, 0x0753, 0x1025, "(null)" },
    { 0x0DE9, 0x0754, 0x1025, "(null)" },
    { 0x0DE9, 0x055e, 0x1028, "(null)" },
    { 0x0DE9, 0x0563, 0x1028, "(null)" },
    { 0x0DE9, 0x181a, 0x103c, "(null)" },
    { 0x0DE9, 0x181b, 0x103c, "(null)" },
    { 0x0DE9, 0x181d, 0x103c, "(null)" },
    { 0x0DE9, 0x1837, 0x103c, "(null)" },
    { 0x0DE9, 0x100d, 0x1043, "(null)" },
    { 0x0DE9, 0x10ac, 0x1043, "(null)" },
    { 0x0DE9, 0x10bc, 0x1043, "(null)" },
    { 0x0DE9, 0x10cc, 0x1043, "(null)" },
    { 0x0DE9, 0x1447, 0x1043, "(null)" },
    { 0x0DE9, 0x1477, 0x1043, "(null)" },
    { 0x0DE9, 0x1497, 0x1043, "(null)" },
    { 0x0DE9, 0x1547, 0x1043, "(null)" },
    { 0x0DE9, 0x1587, 0x1043, "(null)" },
    { 0x0DE9, 0x2104, 0x1043, "(null)" },
    { 0x0DE9, 0x2106, 0x1043, "(null)" },
    { 0x0DE9, 0x2110, 0x1043, "(null)" },
    { 0x0DE9, 0x2113, 0x1043, "(null)" },
    { 0x0DE9, 0x2114, 0x1043, "(null)" },
    { 0x0DE9, 0x2128, 0x1043, "(null)" },
    { 0x0DE9, 0x212e, 0x1043, "(null)" },
    { 0x0DE9, 0x212f, 0x1043, "(null)" },
    { 0x0DE9, 0x2131, 0x1043, "(null)" },
    { 0x0DE9, 0x2137, 0x1043, "(null)" },
    { 0x0DE9, 0x8518, 0x1043, "(null)" },
    { 0x0DE9, 0x8523, 0x1043, "(null)" },
    { 0x0DE9, 0xfb01, 0x1179, "(null)" },
    { 0x0DE9, 0xfb11, 0x1179, "(null)" },
    { 0x0DE9, 0xfb12, 0x1179, "(null)" },
    { 0x0DE9, 0xfb62, 0x1179, "(null)" },
    { 0x0DE9, 0xfb69, 0x1179, "(null)" },
    { 0x0DE9, 0xfb6d, 0x1179, "(null)" },
    { 0x0DE9, 0xfb70, 0x1179, "(null)" },
    { 0x0DE9, 0xc0d1, 0x144d, "(null)" },
    { 0x0DE9, 0xc634, 0x144d, "(null)" },
    { 0x0DE9, 0xc650, 0x144d, "(null)" },
    { 0x0DE9, 0xc652, 0x144d, "(null)" },
    { 0x0DE9, 0x109c, 0x1462, "(null)" },
    { 0x0DE9, 0x10a4, 0x1462, "(null)" },
    { 0x0DE9, 0x10aa, 0x1462, "(null)" },
    { 0x0DE9, 0x10b8, 0x1462, "(null)" },
    { 0x0DE9, 0x10ba, 0x1462, "(null)" },
    { 0x0DE9, 0x10ca, 0x1462, "(null)" },
    { 0x0DE9, 0xa962, 0x1462, "(null)" },
    { 0x0DE9, 0xaa32, 0x1462, "(null)" },
    { 0x0DE9, 0xaa59, 0x1462, "(null)" },
    { 0x0DE9, 0xaa73, 0x1462, "(null)" },
    { 0x0DE9, 0xac77, 0x1462, "(null)" },
    { 0x0DE9, 0xac7c, 0x1462, "(null)" },
    { 0x0DE9, 0xac91, 0x1462, "(null)" },
    { 0x0DE9, 0xad31, 0x1462, "(null)" },
    { 0x0DE9, 0xae32, 0x1462, "(null)" },
    { 0x0DE9, 0xae72, 0x1462, "(null)" },
    { 0x0DE9, 0xaf11, 0x1462, "(null)" },
    { 0x0DE9, 0xaf13, 0x1462, "(null)" },
    { 0x0DE9, 0x0065, 0x14c0, "(null)" },
    { 0x0DE9, 0x0066, 0x14c0, "(null)" },
    { 0x0DE9, 0x0969, 0x152d, "(null)" },
    { 0x0DE9, 0x0972, 0x152d, "(null)" },
    { 0x0DE9, 0x0974, 0x152d, "(null)" },
    { 0x0DE9, 0x0976, 0x152d, "(null)" },
    { 0x0DE9, 0x2702, 0x1558, "(null)" },
    { 0x0DE9, 0x2703, 0x1558, "(null)" },
    { 0x0DE9, 0x362b, 0x17aa, "(null)" },
    { 0x0DE9, 0x3901, 0x17aa, "(null)" },
    { 0x0DE9, 0x3902, 0x17aa, "(null)" },
    { 0x0DE9, 0x3903, 0x17aa, "(null)" },
    { 0x0DE9, 0x3904, 0x17aa, "(null)" },
    { 0x0DE9, 0x3977, 0x17aa, "(null)" },
    { 0x0DE9, 0x397d, 0x17aa, "(null)" },
    { 0x0DE9, 0x397f, 0x17aa, "(null)" },
    { 0x0DE9, 0x3983, 0x17aa, "(null)" },
    { 0x0DE9, 0x5001, 0x17aa, "(null)" },
    { 0x0DE9, 0x5003, 0x17aa, "(null)" },
    { 0x0DE9, 0x5007, 0x17aa, "(null)" },
    { 0x0DE9, 0x500f, 0x17aa, "(null)" },
    { 0x0DE9, 0x5012, 0x17aa, "(null)" },
    { 0x0DE9, 0x10e7, 0x17c0, "(null)" },
    { 0x0DE9, 0x10f5, 0x17c0, "(null)" },
    { 0x0DE9, 0x3012, 0x1854, "(null)" },
    { 0x0DE9, 0x3014, 0x1854, "(null)" },
    { 0x0DE9, 0x5584, 0x1991, "(null)" },
    { 0x0DE9, 0x20c6, 0x1b0a, "(null)" },
    { 0x0DE9, 0x20c8, 0x1b0a, "(null)" },
    { 0x0DE9, 0x20dc, 0x1b0a, "(null)" },
    { 0x0DE9, 0x20dd, 0x1b0a, "(null)" },
    { 0x0DE9, 0x20df, 0x1b0a, "(null)" },
    { 0x0DE9, 0x20e4, 0x1b0a, "(null)" },
    { 0x0DE9, 0x20ec, 0x1b0a, "(null)" },
    { 0x0DE9, 0x2210, 0x1b0a, "(null)" },
    { 0x0DE9, 0x2228, 0x1b0a, "(null)" },
    { 0x0DE9, 0x2229, 0x1b0a, "(null)" },
    { 0x0DE9, 0x222a, 0x1b0a, "(null)" },
    { 0x0DE9, 0x90b8, 0x1b0a, "(null)" },
    { 0x0DEA, 0x22db, 0x1019, "(null)" },
    { 0x0DEA, 0x0488, 0x1025, "(null)" },
    { 0x0DEA, 0x0505, 0x1025, "(null)" },
    { 0x0DEA, 0x0507, 0x1025, "(null)" },
    { 0x0DEA, 0x0509, 0x1025, "(null)" },
    { 0x0DEA, 0x0512, 0x1025, "(null)" },
    { 0x0DEA, 0x055a, 0x1025, "(null)" },
    { 0x0DEA, 0x0611, 0x1025, "(null)" },
    { 0x0DEA, 0x0d88, 0x105b, "(null)" },
    { 0x0DEA, 0x0d9a, 0x105b, "(null)" },
    { 0x0DEA, 0xff00, 0x105b, "(null)" },
    { 0x0DEA, 0x0925, 0x152d, "(null)" },
    { 0x0DEA, 0x0932, 0x152d, "(null)" },
    { 0x0DEA, 0x0938, 0x152d, "(null)" },
    { 0x0DEA, 0x0945, 0x152d, "(null)" },
    { 0x0DEA, 0x0948, 0x152d, "(null)" },
    { 0x0DEA, 0x0954, 0x152d, "(null)" },
    { 0x0DEA, 0x0956, 0x152d, "(null)" },
    { 0x0DEA, 0x0962, 0x152d, "(null)" },
    { 0x0DEA, 0x0965, 0x152d, "(null)" },
    { 0x0DEA, 0x2512, 0x1558, "(null)" },
    { 0x0DEA, 0x365a, 0x17aa, "(null)" },
    { 0x0DEA, 0x365b, 0x17aa, "(null)" },
    { 0x0DEA, 0x365e, 0x17aa, "(null)" },
    { 0x0DEA, 0x3660, 0x17aa, "(null)" },
    { 0x0DEA, 0x366c, 0x17aa, "(null)" },
    { 0x0DEA, 0x20df, 0x1b0a, "(null)" },
    { 0x0DEA, 0x0011, 0x1bfd, "(null)" },
    { 0x0DEB, 0x3620, 0x17aa, "(null)" },
    { 0x0DEB, 0x3980, 0x17aa, "(null)" },
    { 0x0DEB, 0x3981, 0x17aa, "(null)" },
    { 0x0DEC, 0x4011, 0x1071, "(null)" },
    { 0x0DEC, 0xfc50, 0x1179, "(null)" },
    { 0x0DEC, 0xfc61, 0x1179, "(null)" },
    { 0x0DEC, 0xfc71, 0x1179, "(null)" },
    { 0x0DEC, 0xfc81, 0x1179, "(null)" },
    { 0x0DEC, 0xfcd0, 0x1179, "(null)" },
    { 0x0DEC, 0xfd16, 0x1179, "(null)" },
    { 0x0DEC, 0xfd31, 0x1179, "(null)" },
    { 0x0DEC, 0xfd50, 0x1179, "(null)" },
    { 0x0DEC, 0xfd61, 0x1179, "(null)" },
    { 0x0DEC, 0xfd71, 0x1179, "(null)" },
    { 0x0DEC, 0xfdd0, 0x1179, "(null)" },
    { 0x0DEC, 0xc0a0, 0x144d, "(null)" },
    { 0x0DEC, 0xc0a5, 0x144d, "(null)" },
    { 0x0DEC, 0xc0ae, 0x144d, "(null)" },
    { 0x0DEC, 0xc0b7, 0x144d, "(null)" },
    { 0x0DEC, 0xc0c1, 0x144d, "(null)" },
    { 0x0DED, 0x105c, 0x1043, "(null)" },
    { 0x0DED, 0x0dbd, 0x105b, "(null)" },
    { 0x0DED, 0xfcd0, 0x1179, "(null)" },
    { 0x0DED, 0xfd52, 0x1179, "(null)" },
    { 0x0DED, 0xfdd2, 0x1179, "(null)" },
    { 0x0DED, 0x109c, 0x1462, "(null)" },
    { 0x0DED, 0x10aa, 0x1462, "(null)" },
    { 0x0DED, 0x0056, 0x14c0, "(null)" },
    { 0x0DED, 0x0059, 0x14c0, "(null)" },
    { 0x0DED, 0x005a, 0x14c0, "(null)" },
    { 0x0DED, 0x0873, 0x152d, "(null)" },
    { 0x0DED, 0x0878, 0x152d, "(null)" },
    { 0x0DED, 0x0880, 0x152d, "(null)" },
    { 0x0DED, 0x2500, 0x1558, "(null)" },
    { 0x0DED, 0x5584, 0x1991, "(null)" },
    { 0x0DED, 0x5686, 0x1991, "(null)" },
    { 0x0DED, 0x209f, 0x1b0a, "(null)" },
    { 0x0DED, 0x2002, 0x1bab, "(null)" },
    { 0x0DEE, 0x0370, 0x1025, "(null)" },
    { 0x0DEE, 0x0371, 0x1025, "(null)" },
    { 0x0DEE, 0x0374, 0x1025, "(null)" },
    { 0x0DEE, 0x0375, 0x1025, "(null)" },
    { 0x0DEE, 0x037c, 0x1025, "(null)" },
    { 0x0DEE, 0x037d, 0x1025, "(null)" },
    { 0x0DEE, 0x0417, 0x1025, "(null)" },
    { 0x0DEE, 0x0423, 0x1025, "(null)" },
    { 0x0DEE, 0x055a, 0x1025, "(null)" },
    { 0x0DEE, 0x1552, 0x1043, "(null)" },
    { 0x0DEE, 0x1562, 0x1043, "(null)" },
    { 0x0DEE, 0x1582, 0x1043, "(null)" },
    { 0x0DEE, 0x15a2, 0x1043, "(null)" },
    { 0x0DEF, 0x21f3, 0x17aa, "(null)" },
    { 0x0DEF, 0x21f4, 0x17aa, "(null)" },
    { 0x0DEF, 0x21f5, 0x17aa, "(null)" },
    { 0x0DEF, 0x21f6, 0x17aa, "(null)" },
    { 0x0DEF, 0x21f8, 0x17aa, "(null)" },
    { 0x0DEF, 0x362b, 0x17aa, "(null)" },
    { 0x0DEF, 0x365b, 0x17aa, "(null)" },
    { 0x0DEF, 0x5005, 0x17aa, "(null)" },
    { 0x0DF0, 0x0463, 0x1025, "(null)" },
    { 0x0DF0, 0x0468, 0x1028, "(null)" },
    { 0x0DF0, 0x1482, 0x1043, "(null)" },
    { 0x0DF0, 0x1502, 0x1043, "(null)" },
    { 0x0DF0, 0x1512, 0x1043, "(null)" },
    { 0x0DF0, 0x1522, 0x1043, "(null)" },
    { 0x0DF0, 0x1532, 0x1043, "(null)" },
    { 0x0DF0, 0x1552, 0x1043, "(null)" },
    { 0x0DF0, 0x1582, 0x1043, "(null)" },
    { 0x0DF0, 0x15f2, 0x1043, "(null)" },
    { 0x0DF0, 0x907a, 0x104d, "(null)" },
    { 0x0DF0, 0x907e, 0x104d, "(null)" },
    { 0x0DF0, 0x9280, 0x1071, "(null)" },
    { 0x0DF0, 0x9081, 0x109f, "(null)" },
    { 0x0DF0, 0xc08e, 0x144d, "(null)" },
    { 0x0DF0, 0x1075, 0x1462, "(null)" },
    { 0x0DF0, 0x1082, 0x1462, "(null)" },
    { 0x0DF0, 0x0053, 0x14c0, "(null)" },
    { 0x0DF0, 0x0852, 0x152d, "(null)" },
    { 0x0DF0, 0x0853, 0x152d, "(null)" },
    { 0x0DF0, 0x0855, 0x152d, "(null)" },
    { 0x0DF0, 0x5130, 0x1558, "(null)" },
    { 0x0DF0, 0x7130, 0x1558, "(null)" },
    { 0x0DF0, 0x396c, 0x17aa, "(null)" },
    { 0x0DF0, 0x10e2, 0x17c0, "(null)" },
    { 0x0DF0, 0x0844, 0x1854, "(null)" },
    { 0x0DF0, 0x207c, 0x1b0a, "(null)" },
    { 0x0DF0, 0x9077, 0x1b0a, "(null)" },
    { 0x0DF0, 0x907c, 0x1b0a, "(null)" },
    { 0x0DF0, 0x909a, 0x1b0a, "(null)" },
    { 0x0DF0, 0x5609, 0x1b50, "(null)" },
    { 0x0DF0, 0xa01b, 0x1bcf, "(null)" },
    { 0x0DF1, 0x035a, 0x1025, "(null)" },
    { 0x0DF1, 0x036c, 0x1025, "(null)" },
    { 0x0DF1, 0x036d, 0x1025, "(null)" },
    { 0x0DF1, 0x0370, 0x1025, "(null)" },
    { 0x0DF1, 0x0371, 0x1025, "(null)" },
    { 0x0DF1, 0x0374, 0x1025, "(null)" },
    { 0x0DF1, 0x0375, 0x1025, "(null)" },
    { 0x0DF1, 0x037c, 0x1025, "(null)" },
    { 0x0DF1, 0x037d, 0x1025, "(null)" },
    { 0x0DF1, 0x0417, 0x1025, "(null)" },
    { 0x0DF1, 0x041e, 0x1025, "(null)" },
    { 0x0DF1, 0x0423, 0x1025, "(null)" },
    { 0x0DF1, 0x0434, 0x1025, "(null)" },
    { 0x0DF1, 0x0464, 0x1025, "(null)" },
    { 0x0DF1, 0x0487, 0x1025, "(null)" },
    { 0x0DF1, 0x0488, 0x1025, "(null)" },
    { 0x0DF1, 0x0499, 0x1025, "(null)" },
    { 0x0DF1, 0x049a, 0x1025, "(null)" },
    { 0x0DF1, 0x0468, 0x1028, "(null)" },
    { 0x0DF1, 0x046e, 0x1028, "(null)" },
    { 0x0DF1, 0xc08e, 0x144d, "(null)" },
    { 0x0DF1, 0x0853, 0x152d, "(null)" },
    { 0x0DF1, 0x2036, 0x1b0a, "(null)" },
    { 0x0DF1, 0x207a, 0x1b0a, "(null)" },
    { 0x0DF1, 0x2003, 0x1bfd, "(null)" },
    { 0x0DF2, 0x046e, 0x1028, "(null)" },
    { 0x0DF2, 0x15b2, 0x1043, "(null)" },
    { 0x0DF2, 0x15c2, 0x1043, "(null)" },
    { 0x0DF2, 0x1525, 0x1458, "(null)" },
    { 0x0DF2, 0x1526, 0x1458, "(null)" },
    { 0x0DF2, 0x5162, 0x174b, "(null)" },
    { 0x0DF2, 0xa00a, 0x1bcf, "(null)" },
    { 0x0DF2, 0xa022, 0x1bcf, "(null)" },
    { 0x0DF3, 0xc08b, 0x144d, "(null)" },
    { 0x0DF4, 0x036c, 0x1025, "(null)" },
    { 0x0DF4, 0x036d, 0x1025, "(null)" },
    { 0x0DF4, 0x0371, 0x1025, "(null)" },
    { 0x0DF4, 0x037d, 0x1025, "(null)" },
    { 0x0DF4, 0x041e, 0x1025, "(null)" },
    { 0x0DF4, 0x0434, 0x1025, "(null)" },
    { 0x0DF4, 0x0487, 0x1025, "(null)" },
    { 0x0DF4, 0x0488, 0x1025, "(null)" },
    { 0x0DF4, 0x0500, 0x1025, "(null)" },
    { 0x0DF4, 0x0501, 0x1025, "(null)" },
    { 0x0DF4, 0x0502, 0x1025, "(null)" },
    { 0x0DF4, 0x0503, 0x1025, "(null)" },
    { 0x0DF4, 0x0504, 0x1025, "(null)" },
    { 0x0DF4, 0x0505, 0x1025, "(null)" },
    { 0x0DF4, 0x0506, 0x1025, "(null)" },
    { 0x0DF4, 0x0507, 0x1025, "(null)" },
    { 0x0DF4, 0x0508, 0x1025, "(null)" },
    { 0x0DF4, 0x0509, 0x1025, "(null)" },
    { 0x0DF4, 0x0511, 0x1025, "(null)" },
    { 0x0DF4, 0x0512, 0x1025, "(null)" },
    { 0x0DF4, 0x054e, 0x1025, "(null)" },
    { 0x0DF4, 0x0550, 0x1025, "(null)" },
    { 0x0DF4, 0x055a, 0x1025, "(null)" },
    { 0x0DF4, 0x055c, 0x1025, "(null)" },
    { 0x0DF4, 0x0564, 0x1025, "(null)" },
    { 0x0DF4, 0x0565, 0x1025, "(null)" },
    { 0x0DF4, 0x0566, 0x1025, "(null)" },
    { 0x0DF4, 0x0568, 0x1025, "(null)" },
    { 0x0DF4, 0x056b, 0x1025, "(null)" },
    { 0x0DF4, 0x0570, 0x1025, "(null)" },
    { 0x0DF4, 0x0572, 0x1025, "(null)" },
    { 0x0DF4, 0x0573, 0x1025, "(null)" },
    { 0x0DF4, 0x0574, 0x1025, "(null)" },
    { 0x0DF4, 0x0575, 0x1025, "(null)" },
    { 0x0DF4, 0x0576, 0x1025, "(null)" },
    { 0x0DF4, 0x0578, 0x1025, "(null)" },
    { 0x0DF4, 0x0579, 0x1025, "(null)" },
    { 0x0DF4, 0x057a, 0x1025, "(null)" },
    { 0x0DF4, 0x057b, 0x1025, "(null)" },
    { 0x0DF4, 0x0580, 0x1025, "(null)" },
    { 0x0DF4, 0x0581, 0x1025, "(null)" },
    { 0x0DF4, 0x058b, 0x1025, "(null)" },
    { 0x0DF4, 0x058c, 0x1025, "(null)" },
    { 0x0DF4, 0x04c8, 0x1028, "(null)" },
    { 0x0DF4, 0x050e, 0x1028, "(null)" },
    { 0x0DF4, 0x105c, 0x1043, "(null)" },
    { 0x0DF4, 0x15e2, 0x1043, "(null)" },
    { 0x0DF4, 0x15f2, 0x1043, "(null)" },
    { 0x0DF4, 0x1642, 0x1043, "(null)" },
    { 0x0DF4, 0x1662, 0x1043, "(null)" },
    { 0x0DF4, 0x1672, 0x1043, "(null)" },
    { 0x0DF4, 0x849e, 0x1043, "(null)" },
    { 0x0DF4, 0x84ee, 0x1043, "(null)" },
    { 0x0DF4, 0x907e, 0x104d, "(null)" },
    { 0x0DF4, 0x9086, 0x104d, "(null)" },
    { 0x0DF4, 0x9089, 0x104d, "(null)" },
    { 0x0DF4, 0x908e, 0x104d, "(null)" },
    { 0x0DF4, 0x0001, 0x1179, "(null)" },
    { 0x0DF4, 0x0010, 0x1179, "(null)" },
    { 0x0DF4, 0xfc00, 0x1179, "(null)" },
    { 0x0DF4, 0xfc01, 0x1179, "(null)" },
    { 0x0DF4, 0xfc05, 0x1179, "(null)" },
    { 0x0DF4, 0xfc2a, 0x1179, "(null)" },
    { 0x0DF4, 0xfc31, 0x1179, "(null)" },
    { 0x0DF4, 0xfc35, 0x1179, "(null)" },
    { 0x0DF4, 0xfc50, 0x1179, "(null)" },
    { 0x0DF4, 0xfcd0, 0x1179, "(null)" },
    { 0x0DF4, 0xc0a5, 0x144d, "(null)" },
    { 0x0DF4, 0xc0c0, 0x144d, "(null)" },
    { 0x0DF4, 0xc0c1, 0x144d, "(null)" },
    { 0x0DF4, 0x108d, 0x1462, "(null)" },
    { 0x0DF4, 0x109c, 0x1462, "(null)" },
    { 0x0DF4, 0x10a4, 0x1462, "(null)" },
    { 0x0DF4, 0x10aa, 0x1462, "(null)" },
    { 0x0DF4, 0xaa32, 0x1462, "(null)" },
    { 0x0DF4, 0xaa52, 0x1462, "(null)" },
    { 0x0DF4, 0xaa59, 0x1462, "(null)" },
    { 0x0DF4, 0xac71, 0x1462, "(null)" },
    { 0x0DF4, 0xac72, 0x1462, "(null)" },
    { 0x0DF4, 0xac75, 0x1462, "(null)" },
    { 0x0DF4, 0xae32, 0x1462, "(null)" },
    { 0x0DF4, 0xae33, 0x1462, "(null)" },
    { 0x0DF4, 0x0059, 0x14c0, "(null)" },
    { 0x0DF4, 0x0873, 0x152d, "(null)" },
    { 0x0DF4, 0x0877, 0x152d, "(null)" },
    { 0x0DF4, 0x0952, 0x152d, "(null)" },
    { 0x0DF4, 0x0953, 0x152d, "(null)" },
    { 0x0DF4, 0x2550, 0x1558, "(null)" },
    { 0x0DF4, 0x5140, 0x1558, "(null)" },
    { 0x0DF4, 0x7140, 0x1558, "(null)" },
    { 0x0DF4, 0x397d, 0x17aa, "(null)" },
    { 0x0DF4, 0x397f, 0x17aa, "(null)" },
    { 0x0DF4, 0x3981, 0x17aa, "(null)" },
    { 0x0DF4, 0x10e2, 0x17c0, "(null)" },
    { 0x0DF4, 0x10e5, 0x17c0, "(null)" },
    { 0x0DF4, 0x10e7, 0x17c0, "(null)" },
    { 0x0DF4, 0x10e8, 0x17c0, "(null)" },
    { 0x0DF4, 0x10ec, 0x17c0, "(null)" },
    { 0x0DF4, 0x10ed, 0x17c0, "(null)" },
    { 0x0DF4, 0x0df4, 0x1849, "(null)" },
    { 0x0DF4, 0x0863, 0x1854, "(null)" },
    { 0x0DF4, 0x3012, 0x1854, "(null)" },
    { 0x0DF4, 0x5687, 0x1991, "(null)" },
    { 0x0DF4, 0x208f, 0x1b0a, "(null)" },
    { 0x0DF4, 0x209d, 0x1b0a, "(null)" },
    { 0x0DF4, 0x90ad, 0x1b0a, "(null)" },
    { 0x0DF4, 0x2005, 0x1b61, "(null)" },
    { 0x0DF4, 0x9020, 0x1c06, "(null)" },
    { 0x0DF5, 0x0446, 0x1028, "(null)" },
    { 0x0DF5, 0x04b6, 0x1028, "(null)" },
    { 0x0DF5, 0x04c4, 0x1028, "(null)" },
    { 0x0DF5, 0x04c6, 0x1028, "(null)" },
    { 0x0DF5, 0x04ca, 0x1028, "(null)" },
    { 0x0DF5, 0x0511, 0x1028, "(null)" },
    { 0x0DF5, 0x0512, 0x1028, "(null)" },
    { 0x0DF5, 0x1649, 0x10cf, "(null)" },
    { 0x0DF5, 0x164a, 0x10cf, "(null)" },
    { 0x0DF5, 0xc0ae, 0x144d, "(null)" },
    { 0x0DF5, 0x0059, 0x14c0, "(null)" },
    { 0x0DF5, 0x005a, 0x14c0, "(null)" },
    { 0x0DF5, 0x0062, 0x14c0, "(null)" },
    { 0x0DF5, 0x0067, 0x14c0, "(null)" },
    { 0x0DF5, 0x0068, 0x14c0, "(null)" },
    { 0x0DF5, 0x397d, 0x17aa, "(null)" },
    { 0x0DF5, 0x397f, 0x17aa, "(null)" },
    { 0x0DF5, 0x10e5, 0x17c0, "(null)" },
    { 0x0DF5, 0x5584, 0x1991, "(null)" },
    { 0x0DF5, 0x5685, 0x1991, "(null)" },
    { 0x0DF5, 0x5686, 0x1991, "(null)" },
    { 0x0DF5, 0x00e6, 0x1b0a, "(null)" },
    { 0x0DF5, 0x209c, 0x1b0a, "(null)" },
    { 0x0DF5, 0x2002, 0x1bab, "(null)" },
    { 0x0DF5, 0x2004, 0x1bfd, "(null)" },
    { 0x0DF5, 0x8001, 0x1bfd, "(null)" },
    { 0x0DF5, 0x8003, 0x1bfd, "(null)" },
    { 0x0DF5, 0x9020, 0x1c06, "(null)" },
    { 0x0DF6, 0x1712, 0x1043, "(null)" },
    { 0x0DF6, 0x2525, 0x1458, "(null)" },
    { 0x0DF6, 0x2532, 0x1458, "(null)" },
    { 0x0DF6, 0x0059, 0x14c0, "(null)" },
    { 0x0DF6, 0x005e, 0x14c0, "(null)" },
    { 0x0DF6, 0x3981, 0x17aa, "(null)" },
    { 0x0DF6, 0x20a5, 0x1b0a, "(null)" },
    { 0x0DF6, 0x2002, 0x1bab, "(null)" },
    { 0x0DF7, 0x0488, 0x1025, "(null)" },
    { 0x0DF7, 0x0505, 0x1025, "(null)" },
    { 0x0DF7, 0x0507, 0x1025, "(null)" },
    { 0x0DF7, 0x0509, 0x1025, "(null)" },
    { 0x0DF7, 0x0512, 0x1025, "(null)" },
    { 0x0DF7, 0x053a, 0x1025, "(null)" },
    { 0x0DF7, 0x055a, 0x1025, "(null)" },
    { 0x0DF7, 0x060d, 0x1025, "(null)" },
    { 0x0DF7, 0x0611, 0x1025, "(null)" },
    { 0x0DF7, 0x108c, 0x1462, "(null)" },
    { 0x0DF7, 0x1094, 0x1462, "(null)" },
    { 0x0DF7, 0x005a, 0x14c0, "(null)" },
    { 0x0DF7, 0x397d, 0x17aa, "(null)" },
    { 0x0DF7, 0x397f, 0x17aa, "(null)" },
    { 0x0DF8, 0x0835, 0x103c, "(null)" },
    { 0x0DF8, 0x0835, 0x10de, "(null)" },
    { 0x0DF9, 0x092b, 0x103c, "(null)" },
    { 0x0DFA, 0x04a3, 0x1028, "(null)" },
    { 0x0DFA, 0x14a3, 0x1028, "(null)" },
    { 0x0DFA, 0x0854, 0x103c, "(null)" },
    { 0x0DFA, 0x1631, 0x103c, "(null)" },
    { 0x0DFA, 0x1632, 0x10cf, "(null)" },
    { 0x0DFA, 0x21cf, 0x17aa, "(null)" },
    { 0x0DFA, 0x21d1, 0x17aa, "(null)" },
    { 0x0DFC, 0x0534, 0x1028, "(null)" },
    { 0x0DFC, 0x0535, 0x1028, "(null)" },
    { 0x0DFC, 0x1534, 0x1028, "(null)" },
    { 0x0DFC, 0x1535, 0x1028, "(null)" },
    { 0x0E22, 0x835d, 0x1043, "(null)" },
    { 0x0E22, 0x8386, 0x1043, "(null)" },
    { 0x0E22, 0xc000, 0x1458, "(null)" },
    { 0x0E23, 0xc000, 0x1458, "(null)" },
    { 0x0E24, 0x1006, 0x1019, "(null)" },
    { 0x0E24, 0x8361, 0x1043, "(null)" },
    { 0x0E24, 0x083d, 0x10de, "(null)" },
    { 0x0E24, 0x2320, 0x1462, "(null)" },
    { 0x0E24, 0x2324, 0x1462, "(null)" },
    { 0x0E24, 0x4600, 0x174b, "(null)" },
    { 0x0E24, 0x4602, 0x174b, "(null)" },
    { 0x0E24, 0x907f, 0x1b0a, "(null)" },
    { 0x0E24, 0x9086, 0x1b0a, "(null)" },
    { 0x0E30, 0x7100, 0x1558, "(null)" },
    { 0x0E30, 0x7200, 0x1558, "(null)" },
    { 0x0E30, 0x8687, 0x1558, "(null)" },
    { 0x0E31, 0x5102, 0x1558, "(null)" },
    { 0x0E31, 0x7100, 0x1558, "(null)" },
    { 0x0E31, 0x7200, 0x1558, "(null)" },
    { 0x0E3A, 0x04a4, 0x1028, "(null)" },
    { 0x0E3A, 0x14a4, 0x1028, "(null)" },
    { 0x0E3A, 0x0851, 0x103c, "(null)" },
    { 0x0E3A, 0x1630, 0x103c, "(null)" },
    { 0x0E3A, 0x1633, 0x10cf, "(null)" },
    { 0x0E3B, 0x04a4, 0x1028, "(null)" },
    { 0x0E3B, 0x14a4, 0x1028, "(null)" },
    { 0x0E3B, 0x0852, 0x103c, "(null)" },
    { 0x0E3B, 0x1630, 0x103c, "(null)" },
    { 0x0E3B, 0x1634, 0x10cf, "(null)" },
    { 0x0F00, 0x6025, 0x17aa, "(null)" },
    { 0x0F03, 0x36e8, 0x1458, "(null)" },
    { 0x0FC0, 0x1015, 0x1019, "(null)" },
    { 0x0FC0, 0x8597, 0x1043, "(null)" },
    { 0x0FC0, 0x093d, 0x10de, "(null)" },
    { 0x0FC0, 0x100f, 0x10de, "(null)" },
    { 0x0FC0, 0x275b, 0x1462, "(null)" },
    { 0x0FC0, 0x3b86, 0x1642, "(null)" },
    { 0x0FC0, 0x0640, 0x174b, "(null)" },
    { 0x0FC0, 0xa642, 0x174b, "(null)" },
    { 0x0FC0, 0xa644, 0x174b, "(null)" },
    { 0x0FC0, 0x90c5, 0x1b0a, "(null)" },
    { 0x0FC2, 0x0936, 0x103c, "(null)" },
    { 0x0FC2, 0x83e2, 0x1043, "(null)" },
    { 0x0FC2, 0x8598, 0x1043, "(null)" },
    { 0x0FC2, 0x809e, 0x144d, "(null)" },
    { 0x0FC2, 0x809f, 0x144d, "(null)" },
    { 0x0FC2, 0x2750, 0x1462, "(null)" },
    { 0x0FC2, 0x2751, 0x1462, "(null)" },
    { 0x0FC2, 0x2752, 0x1462, "(null)" },
    { 0x0FC2, 0x2754, 0x1462, "(null)" },
    { 0x0FC2, 0x2755, 0x1462, "(null)" },
    { 0x0FC2, 0x275a, 0x1462, "(null)" },
    { 0x0FC2, 0x275c, 0x1462, "(null)" },
    { 0x0FC2, 0x3b86, 0x1642, "(null)" },
    { 0x0FC2, 0x3b98, 0x1642, "(null)" },
    { 0x0FC2, 0x0630, 0x174b, "(null)" },
    { 0x0FC2, 0xa632, 0x174b, "(null)" },
    { 0x0FC2, 0x6024, 0x17aa, "(null)" },
    { 0x0FC2, 0x6025, 0x17aa, "(null)" },
    { 0x0FC2, 0x1462, 0x275c, "(null)" },
    { 0x0FC6, 0x1017, 0x1019, "(null)" },
    { 0x0FC6, 0x068b, 0x1028, "(null)" },
    { 0x0FC6, 0x0790, 0x1028, "(null)" },
    { 0x0FC6, 0x079a, 0x1028, "(null)" },
    { 0x0FC6, 0x2802, 0x1462, "(null)" },
    { 0x0FC6, 0x2809, 0x1462, "(null)" },
    { 0x0FC6, 0x3c78, 0x1642, "(null)" },
    { 0x0FC8, 0x864e, 0x1043, "(null)" },
    { 0x0FCB, 0x4112, 0x1775, "(null)" },
    { 0x0FCD, 0x1024, 0x152d, "(null)" },
    { 0x0FCD, 0x3800, 0x17aa, "(null)" },
    { 0x0FCD, 0x3801, 0x17aa, "(null)" },
    { 0x0FD1, 0x0686, 0x1025, "(null)" },
    { 0x0FD1, 0x068b, 0x1025, "(null)" },
    { 0x0FD1, 0x0552, 0x1028, "(null)" },
    { 0x0FD1, 0x0566, 0x1028, "(null)" },
    { 0x0FD1, 0x0578, 0x1028, "(null)" },
    { 0x0FD1, 0x181a, 0x103c, "(null)" },
    { 0x0FD1, 0x181b, 0x103c, "(null)" },
    { 0x0FD1, 0x181d, 0x103c, "(null)" },
    { 0x0FD1, 0x189a, 0x103c, "(null)" },
    { 0x0FD1, 0x1597, 0x1043, "(null)" },
    { 0x0FD1, 0x15a7, 0x1043, "(null)" },
    { 0x0FD1, 0x2103, 0x1043, "(null)" },
    { 0x0FD1, 0x2105, 0x1043, "(null)" },
    { 0x0FD1, 0x2141, 0x1043, "(null)" },
    { 0x0FD1, 0x0718, 0x1071, "(null)" },
    { 0x0FD1, 0xc0cc, 0x144d, "(null)" },
    { 0x0FD1, 0xc0d1, 0x144d, "(null)" },
    { 0x0FD1, 0xc634, 0x144d, "(null)" },
    { 0x0FD1, 0xc650, 0x144d, "(null)" },
    { 0x0FD1, 0x2442, 0x1458, "(null)" },
    { 0x0FD1, 0x2542, 0x1458, "(null)" },
    { 0x0FD1, 0x10b8, 0x1462, "(null)" },
    { 0x0FD1, 0x10c7, 0x1462, "(null)" },
    { 0x0FD1, 0x10cd, 0x1462, "(null)" },
    { 0x0FD1, 0xad31, 0x1462, "(null)" },
    { 0x0FD1, 0xaf12, 0x1462, "(null)" },
    { 0x0FD1, 0x0065, 0x14c0, "(null)" },
    { 0x0FD1, 0x0066, 0x14c0, "(null)" },
    { 0x0FD1, 0x0934, 0x152d, "(null)" },
    { 0x0FD1, 0x0943, 0x152d, "(null)" },
    { 0x0FD1, 0x1150, 0x1558, "(null)" },
    { 0x0FD1, 0x1550, 0x1558, "(null)" },
    { 0x0FD1, 0x365b, 0x17aa, "(null)" },
    { 0x0FD1, 0x3970, 0x17aa, "(null)" },
    { 0x0FD1, 0x3971, 0x17aa, "(null)" },
    { 0x0FD1, 0x3972, 0x17aa, "(null)" },
    { 0x0FD1, 0x3977, 0x17aa, "(null)" },
    { 0x0FD1, 0x20dd, 0x1b0a, "(null)" },
    { 0x0FD2, 0x22db, 0x1019, "(null)" },
    { 0x0FD2, 0x0593, 0x1025, "(null)" },
    { 0x0FD2, 0x0646, 0x1025, "(null)" },
    { 0x0FD2, 0x0648, 0x1025, "(null)" },
    { 0x0FD2, 0x066c, 0x1025, "(null)" },
    { 0x0FD2, 0x0679, 0x1025, "(null)" },
    { 0x0FD2, 0x067d, 0x1025, "(null)" },
    { 0x0FD2, 0x0681, 0x1025, "(null)" },
    { 0x0FD2, 0x0682, 0x1025, "(null)" },
    { 0x0FD2, 0x0683, 0x1025, "(null)" },
    { 0x0FD2, 0x0684, 0x1025, "(null)" },
    { 0x0FD2, 0x0686, 0x1025, "(null)" },
    { 0x0FD2, 0x068b, 0x1025, "(null)" },
    { 0x0FD2, 0x069e, 0x1025, "(null)" },
    { 0x0FD2, 0x071b, 0x1025, "(null)" },
    { 0x0FD2, 0x071d, 0x1025, "(null)" },
    { 0x0FD2, 0x0733, 0x1025, "(null)" },
    { 0x0FD2, 0x0734, 0x1025, "(null)" },
    { 0x0FD2, 0x0735, 0x1025, "(null)" },
    { 0x0FD2, 0x0736, 0x1025, "(null)" },
    { 0x0FD2, 0x054b, 0x1028, "(null)" },
    { 0x0FD2, 0x054f, 0x1028, "(null)" },
    { 0x0FD2, 0x055f, 0x1028, "(null)" },
    { 0x0FD2, 0x0595, 0x1028, "(null)" },
    { 0x0FD2, 0x05b2, 0x1028, "(null)" },
    { 0x0FD2, 0x100d, 0x1043, "(null)" },
    { 0x0FD2, 0x10ac, 0x1043, "(null)" },
    { 0x0FD2, 0x10bc, 0x1043, "(null)" },
    { 0x0FD2, 0x10cc, 0x1043, "(null)" },
    { 0x0FD2, 0x1447, 0x1043, "(null)" },
    { 0x0FD2, 0x15a7, 0x1043, "(null)" },
    { 0x0FD2, 0x8533, 0x1043, "(null)" },
    { 0x0FD2, 0x9097, 0x104d, "(null)" },
    { 0x0FD2, 0x0d9a, 0x105b, "(null)" },
    { 0x0FD2, 0xfb01, 0x1179, "(null)" },
    { 0x0FD2, 0xfb05, 0x1179, "(null)" },
    { 0x0FD2, 0xfb12, 0x1179, "(null)" },
    { 0x0FD2, 0xc0d5, 0x144d, "(null)" },
    { 0x0FD2, 0x1542, 0x1458, "(null)" },
    { 0x0FD2, 0x2442, 0x1458, "(null)" },
    { 0x0FD2, 0x10b7, 0x1462, "(null)" },
    { 0x0FD2, 0x10b8, 0x1462, "(null)" },
    { 0x0FD2, 0x10ba, 0x1462, "(null)" },
    { 0x0FD2, 0x10d3, 0x1462, "(null)" },
    { 0x0FD2, 0xad31, 0x1462, "(null)" },
    { 0x0FD2, 0x0066, 0x14c0, "(null)" },
    { 0x0FD2, 0x0926, 0x152d, "(null)" },
    { 0x0FD2, 0x0933, 0x152d, "(null)" },
    { 0x0FD2, 0x0939, 0x152d, "(null)" },
    { 0x0FD2, 0x0942, 0x152d, "(null)" },
    { 0x0FD2, 0x0946, 0x152d, "(null)" },
    { 0x0FD2, 0x0949, 0x152d, "(null)" },
    { 0x0FD2, 0x0955, 0x152d, "(null)" },
    { 0x0FD2, 0x0957, 0x152d, "(null)" },
    { 0x0FD2, 0x0963, 0x152d, "(null)" },
    { 0x0FD2, 0x0966, 0x152d, "(null)" },
    { 0x0FD2, 0x2701, 0x1558, "(null)" },
    { 0x0FD2, 0x3902, 0x17aa, "(null)" },
    { 0x0FD2, 0x3904, 0x17aa, "(null)" },
    { 0x0FD2, 0x3977, 0x17aa, "(null)" },
    { 0x0FD2, 0x5003, 0x17aa, "(null)" },
    { 0x0FD2, 0x5012, 0x17aa, "(null)" },
    { 0x0FD2, 0x0168, 0x1854, "(null)" },
    { 0x0FD2, 0x0185, 0x1854, "(null)" },
    { 0x0FD2, 0x1808, 0x1854, "(null)" },
    { 0x0FD2, 0x20c6, 0x1b0a, "(null)" },
    { 0x0FD2, 0x20dc, 0x1b0a, "(null)" },
    { 0x0FD2, 0x20dd, 0x1b0a, "(null)" },
    { 0x0FD2, 0x20df, 0x1b0a, "(null)" },
    { 0x0FD2, 0x20e4, 0x1b0a, "(null)" },
    { 0x0FD2, 0x20e8, 0x1b0a, "(null)" },
    { 0x0FD2, 0x20ec, 0x1b0a, "(null)" },
    { 0x0FD2, 0x2228, 0x1b0a, "(null)" },
    { 0x0FD2, 0x222a, 0x1b0a, "(null)" },
    { 0x0FD2, 0x222f, 0x1b0a, "(null)" },
    { 0x0FD2, 0x0010, 0x1bfd, "(null)" },
    { 0x0FD3, 0x0713, 0x1025, "(null)" },
    { 0x0FD3, 0x0717, 0x1025, "(null)" },
    { 0x0FD3, 0x104d, 0x1043, "(null)" },
    { 0x0FD3, 0x909a, 0x104d, "(null)" },
    { 0x0FD3, 0x909c, 0x104d, "(null)" },
    { 0x0FD3, 0x175d, 0x10cf, "(null)" },
    { 0x0FD3, 0x1764, 0x10cf, "(null)" },
    { 0x0FD3, 0x1766, 0x10cf, "(null)" },
    { 0x0FD3, 0x1768, 0x10cf, "(null)" },
    { 0x0FD3, 0x0065, 0x14c0, "(null)" },
    { 0x0FD3, 0x0066, 0x14c0, "(null)" },
    { 0x0FD3, 0x006d, 0x14c0, "(null)" },
    { 0x0FD3, 0x0923, 0x152d, "(null)" },
    { 0x0FD3, 0x0924, 0x152d, "(null)" },
    { 0x0FD3, 0x6747, 0x1a58, "(null)" },
    { 0x0FD4, 0x0550, 0x1028, "(null)" },
    { 0x0FD4, 0x0551, 0x1028, "(null)" },
    { 0x0FD4, 0x057b, 0x1028, "(null)" },
    { 0x0FD4, 0x0580, 0x1028, "(null)" },
    { 0x0FD4, 0x05ab, 0x1028, "(null)" },
    { 0x0FD4, 0x102d, 0x1043, "(null)" },
    { 0x0FD4, 0x2115, 0x1043, "(null)" },
    { 0x0FD4, 0x2116, 0x1043, "(null)" },
    { 0x0FD4, 0x2117, 0x1043, "(null)" },
    { 0x0FD4, 0x2118, 0x1043, "(null)" },
    { 0x0FD4, 0x2542, 0x1458, "(null)" },
    { 0x0FD4, 0x6745, 0x1458, "(null)" },
    { 0x0FD4, 0x6746, 0x1458, "(null)" },
    { 0x0FD4, 0x10d7, 0x1462, "(null)" },
    { 0x0FD4, 0x10d8, 0x1462, "(null)" },
    { 0x0FD4, 0x3700, 0x1558, "(null)" },
    { 0x0FD4, 0x5105, 0x1558, "(null)" },
    { 0x0FD4, 0x7102, 0x1558, "(null)" },
    { 0x0FD4, 0x3977, 0x17aa, "(null)" },
    { 0x0FD5, 0x00f2, 0x106b, "(null)" },
    { 0x0FD5, 0x00fc, 0x106b, "(null)" },
    { 0x0FD5, 0x010a, 0x106b, "(null)" },
    { 0x0FD8, 0x0109, 0x106b, "(null)" },
    { 0x0FD9, 0x104d, 0x1043, "(null)" },
    { 0x0FD9, 0x10ac, 0x1043, "(null)" },
    { 0x0FD9, 0x10bd, 0x1043, "(null)" },
    { 0x0FD9, 0x10b8, 0x1462, "(null)" },
    { 0x0FD9, 0x0990, 0x152d, "(null)" },
    { 0x0FD9, 0x0993, 0x152d, "(null)" },
    { 0x0FD9, 0x0997, 0x152d, "(null)" },
    { 0x0FD9, 0x1001, 0x152d, "(null)" },
    { 0x0FD9, 0x1015, 0x152d, "(null)" },
    { 0x0FD9, 0x2707, 0x1558, "(null)" },
    { 0x0FD9, 0x3904, 0x17aa, "(null)" },
    { 0x0FD9, 0x5003, 0x17aa, "(null)" },
    { 0x0FD9, 0x5014, 0x17aa, "(null)" },
    { 0x0FD9, 0x20dc, 0x1b0a, "(null)" },
    { 0x0FD9, 0x20e4, 0x1b0a, "(null)" },
    { 0x0FDF, 0x0686, 0x1025, "(null)" },
    { 0x0FDF, 0x068b, 0x1025, "(null)" },
    { 0x0FDF, 0x100d, 0x1043, "(null)" },
    { 0x0FDF, 0x10cc, 0x1043, "(null)" },
    { 0x0FDF, 0x1477, 0x1043, "(null)" },
    { 0x0FDF, 0x1587, 0x1043, "(null)" },
    { 0x0FDF, 0x2139, 0x1043, "(null)" },
    { 0x0FDF, 0x21ca, 0x1043, "(null)" },
    { 0x0FE0, 0x010b, 0x106b, "(null)" },
    { 0x0FE1, 0x0646, 0x1025, "(null)" },
    { 0x0FE1, 0x0648, 0x1025, "(null)" },
    { 0x0FE1, 0x0679, 0x1025, "(null)" },
    { 0x0FE1, 0x067d, 0x1025, "(null)" },
    { 0x0FE1, 0x0686, 0x1025, "(null)" },
    { 0x0FE1, 0x068b, 0x1025, "(null)" },
    { 0x0FE1, 0x069e, 0x1025, "(null)" },
    { 0x0FE1, 0x0713, 0x1025, "(null)" },
    { 0x0FE1, 0x0717, 0x1025, "(null)" },
    { 0x0FE1, 0x071b, 0x1025, "(null)" },
    { 0x0FE1, 0x071d, 0x1025, "(null)" },
    { 0x0FE1, 0x05b2, 0x1028, "(null)" },
    { 0x0FE1, 0x8585, 0x1043, "(null)" },
    { 0x0FE1, 0x85d3, 0x1043, "(null)" },
    { 0x0FE1, 0x2442, 0x1458, "(null)" },
    { 0x0FE1, 0xa442, 0x1458, "(null)" },
    { 0x0FE1, 0x10b8, 0x1462, "(null)" },
    { 0x0FE1, 0x1013, 0x152d, "(null)" },
    { 0x0FE1, 0x1056, 0x152d, "(null)" },
    { 0x0FE1, 0x20dc, 0x1b0a, "(null)" },
    { 0x0FE1, 0x20e4, 0x1b0a, "(null)" },
    { 0x0FE2, 0x4002, 0x1071, "(null)" },
    { 0x0FE2, 0x4033, 0x1071, "(null)" },
    { 0x0FE2, 0x4037, 0x1071, "(null)" },
    { 0x0FE2, 0x4038, 0x1071, "(null)" },
    { 0x0FE2, 0x4039, 0x1071, "(null)" },
    { 0x0FE2, 0x403d, 0x1071, "(null)" },
    { 0x0FE2, 0x8338, 0x10f7, "(null)" },
    { 0x0FE2, 0x0081, 0x14c0, "(null)" },
    { 0x0FE2, 0x1043, 0x152d, "(null)" },
    { 0x0FE2, 0x1076, 0x152d, "(null)" },
    { 0x0FE2, 0x8400, 0x1558, "(null)" },
    { 0x0FE2, 0x1704, 0x172f, "(null)" },
    { 0x0FE2, 0x1705, 0x172f, "(null)" },
    { 0x0FE3, 0x999b, 0x1019, "(null)" },
    { 0x0FE3, 0x99a2, 0x1019, "(null)" },
    { 0x0FE3, 0x05d6, 0x1028, "(null)" },
    { 0x0FE3, 0x2b16, 0x103c, "(null)" },
    { 0x0FE3, 0x11ed, 0x1043, "(null)" },
    { 0x0FE3, 0x11fd, 0x1043, "(null)" },
    { 0x0FE3, 0x12dd, 0x1043, "(null)" },
    { 0x0FE3, 0x21ea, 0x1043, "(null)" },
    { 0x0FE3, 0x221a, 0x1043, "(null)" },
    { 0x0FE3, 0x222a, 0x1043, "(null)" },
    { 0x0FE3, 0xfa11, 0x1179, "(null)" },
    { 0x0FE3, 0xfa13, 0x1179, "(null)" },
    { 0x0FE3, 0xfa18, 0x1179, "(null)" },
    { 0x0FE3, 0xfa19, 0x1179, "(null)" },
    { 0x0FE3, 0xfa32, 0x1179, "(null)" },
    { 0x0FE3, 0xfa33, 0x1179, "(null)" },
    { 0x0FE3, 0xfa36, 0x1179, "(null)" },
    { 0x0FE3, 0xfa38, 0x1179, "(null)" },
    { 0x0FE3, 0xfa42, 0x1179, "(null)" },
    { 0x0FE3, 0xfa43, 0x1179, "(null)" },
    { 0x0FE3, 0xfa45, 0x1179, "(null)" },
    { 0x0FE3, 0xfa47, 0x1179, "(null)" },
    { 0x0FE3, 0xfa49, 0x1179, "(null)" },
    { 0x0FE3, 0xfa78, 0x1179, "(null)" },
    { 0x0FE3, 0xfa79, 0x1179, "(null)" },
    { 0x0FE3, 0x2442, 0x1458, "(null)" },
    { 0x0FE3, 0x1002, 0x152d, "(null)" },
    { 0x0FE3, 0x1009, 0x152d, "(null)" },
    { 0x0FE3, 0x3675, 0x17aa, "(null)" },
    { 0x0FE3, 0x3805, 0x17aa, "(null)" },
    { 0x0FE3, 0x3809, 0x17aa, "(null)" },
    { 0x0FE3, 0x5003, 0x17aa, "(null)" },
    { 0x0FE3, 0x501a, 0x17aa, "(null)" },
    { 0x0FE3, 0x0193, 0x1854, "(null)" },
    { 0x0FE3, 0x1051, 0x1854, "(null)" },
    { 0x0FE3, 0x5589, 0x1991, "(null)" },
    { 0x0FE3, 0x20e4, 0x1b0a, "(null)" },
    { 0x0FE3, 0x2106, 0x1b0a, "(null)" },
    { 0x0FE3, 0x2109, 0x1b0a, "(null)" },
    { 0x0FE3, 0x210e, 0x1b0a, "(null)" },
    { 0x0FE3, 0x2202, 0x1b0a, "(null)" },
    { 0x0FE3, 0x2222, 0x1b0a, "(null)" },
    { 0x0FE4, 0x0781, 0x1025, "(null)" },
    { 0x0FE4, 0x0798, 0x1025, "(null)" },
    { 0x0FE4, 0x0799, 0x1025, "(null)" },
    { 0x0FE4, 0x079b, 0x1025, "(null)" },
    { 0x0FE4, 0x079c, 0x1025, "(null)" },
    { 0x0FE4, 0x079d, 0x1025, "(null)" },
    { 0x0FE4, 0x0814, 0x1025, "(null)" },
    { 0x0FE4, 0x0816, 0x1025, "(null)" },
    { 0x0FE4, 0x0830, 0x1025, "(null)" },
    { 0x0FE4, 0x05a9, 0x1028, "(null)" },
    { 0x0FE4, 0x05ac, 0x1028, "(null)" },
    { 0x0FE4, 0x05b0, 0x1028, "(null)" },
    { 0x0FE4, 0x05f6, 0x1028, "(null)" },
    { 0x0FE4, 0x05fa, 0x1028, "(null)" },
    { 0x0FE4, 0x05fc, 0x1028, "(null)" },
    { 0x0FE4, 0x05fe, 0x1028, "(null)" },
    { 0x0FE4, 0x1967, 0x103c, "(null)" },
    { 0x0FE4, 0x1968, 0x103c, "(null)" },
    { 0x0FE4, 0x219b, 0x103c, "(null)" },
    { 0x0FE4, 0x219d, 0x103c, "(null)" },
    { 0x0FE4, 0x11cd, 0x1043, "(null)" },
    { 0x0FE4, 0x127d, 0x1043, "(null)" },
    { 0x0FE4, 0x129d, 0x1043, "(null)" },
    { 0x0FE4, 0x1477, 0x1043, "(null)" },
    { 0x0FE4, 0x0720, 0x1071, "(null)" },
    { 0x0FE4, 0xc740, 0x144d, "(null)" },
    { 0x0FE4, 0x1552, 0x1458, "(null)" },
    { 0x0FE4, 0x2452, 0x1458, "(null)" },
    { 0x0FE4, 0x3552, 0x1458, "(null)" },
    { 0x0FE4, 0x10e3, 0x1462, "(null)" },
    { 0x0FE4, 0x10e6, 0x1462, "(null)" },
    { 0x0FE4, 0x10e7, 0x1462, "(null)" },
    { 0x0FE4, 0x1003, 0x152d, "(null)" },
    { 0x0FE4, 0x1010, 0x152d, "(null)" },
    { 0x0FE4, 0x1029, 0x152d, "(null)" },
    { 0x0FE4, 0x0650, 0x1558, "(null)" },
    { 0x0FE4, 0x0681, 0x1558, "(null)" },
    { 0x0FE4, 0x5182, 0x1558, "(null)" },
    { 0x0FE4, 0x1703, 0x172f, "(null)" },
    { 0x0FE4, 0x05fa, 0x17aa, "(null)" },
    { 0x0FE4, 0x3683, 0x17aa, "(null)" },
    { 0x0FE4, 0x3800, 0x17aa, "(null)" },
    { 0x0FE4, 0x3801, 0x17aa, "(null)" },
    { 0x0FE4, 0x3802, 0x17aa, "(null)" },
    { 0x0FE9, 0x011e, 0x106b, "(null)" },
    { 0x0FE9, 0x0130, 0x106b, "(null)" },
    { 0x0FEA, 0x011f, 0x106b, "(null)" },
    { 0x0FEC, 0x1802, 0x172f, "(null)" },
    { 0x0FED, 0x5530, 0x1b50, "(null)" },
    { 0x0FEE, 0x10e0, 0x1043, "(null)" },
    { 0x0FEE, 0x11be, 0x1043, "(null)" },
    { 0x0FEE, 0x11de, 0x1043, "(null)" },
    { 0x0FEE, 0x133e, 0x1043, "(null)" },
    { 0x0FEE, 0x137e, 0x1043, "(null)" },
    { 0x0FEE, 0x146e, 0x1043, "(null)" },
    { 0x0FF2, 0x099d, 0x10de, "(null)" },
    { 0x0FF2, 0x1012, 0x10de, "(null)" },
    { 0x0FF3, 0x1106, 0x103c, "(null)" },
    { 0x0FF3, 0x1162, 0x103c, "(null)" },
    { 0x0FF3, 0x1106, 0x10de, "(null)" },
    { 0x0FF3, 0x1162, 0x10de, "(null)" },
    { 0x0FF3, 0x1162, 0x15c3, "(null)" },
    { 0x0FF6, 0x05cc, 0x1028, "(null)" },
    { 0x0FF6, 0x060d, 0x1028, "(null)" },
    { 0x0FF6, 0x15cc, 0x1028, "(null)" },
    { 0x0FF6, 0x1909, 0x103c, "(null)" },
    { 0x0FF6, 0x190a, 0x103c, "(null)" },
    { 0x0FF6, 0x197a, 0x103c, "(null)" },
    { 0x0FF6, 0x197b, 0x103c, "(null)" },
    { 0x0FF6, 0x2253, 0x103c, "(null)" },
    { 0x0FF6, 0x2254, 0x103c, "(null)" },
    { 0x0FF6, 0x2255, 0x103c, "(null)" },
    { 0x0FF6, 0x2256, 0x103c, "(null)" },
    { 0x0FF6, 0x8104, 0x103c, "(null)" },
    { 0x0FF6, 0x22fa, 0x1043, "(null)" },
    { 0x0FF6, 0x17ee, 0x10cf, "(null)" },
    { 0x0FF6, 0x5106, 0x1558, "(null)" },
    { 0x0FF6, 0x5281, 0x1558, "(null)" },
    { 0x0FF6, 0x7104, 0x1558, "(null)" },
    { 0x0FF6, 0x7481, 0x1558, "(null)" },
    { 0x0FF6, 0x7500, 0x1558, "(null)" },
    { 0x0FF6, 0x7700, 0x1558, "(null)" },
    { 0x0FF6, 0x2210, 0x17aa, "(null)" },
    { 0x0FF6, 0x2211, 0x17aa, "(null)" },
    { 0x0FF6, 0x221a, 0x17aa, "(null)" },
    { 0x0FF6, 0x221e, 0x17aa, "(null)" },
    { 0x0FF8, 0x176a, 0x10cf, "(null)" },
    { 0x0FF9, 0x096f, 0x10de, "(null)" },
    { 0x0FFA, 0x094b, 0x103c, "(null)" },
    { 0x0FFA, 0x094b, 0x10de, "(null)" },
    { 0x0FFB, 0x053e, 0x1028, "(null)" },
    { 0x0FFB, 0x153e, 0x1028, "(null)" },
    { 0x0FFB, 0x176b, 0x103c, "(null)" },
    { 0x0FFB, 0x175e, 0x10cf, "(null)" },
    { 0x0FFB, 0x175f, 0x10cf, "(null)" },
    { 0x0FFB, 0x10db, 0x1462, "(null)" },
    { 0x0FFB, 0x21f5, 0x17aa, "(null)" },
    { 0x0FFB, 0x21f6, 0x17aa, "(null)" },
    { 0x0FFC, 0x053e, 0x1028, "(null)" },
    { 0x0FFC, 0x153e, 0x1028, "(null)" },
    { 0x0FFC, 0x176b, 0x103c, "(null)" },
    { 0x0FFC, 0x175e, 0x10cf, "(null)" },
    { 0x0FFC, 0x8338, 0x10f7, "(null)" },
    { 0x0FFC, 0x10db, 0x1462, "(null)" },
    { 0x0FFC, 0x5106, 0x1558, "(null)" },
    { 0x0FFC, 0x7104, 0x1558, "(null)" },
    { 0x0FFC, 0x21f5, 0x17aa, "(null)" },
    { 0x0FFC, 0x21f6, 0x17aa, "(null)" },
    { 0x0FFD, 0x0967, 0x103c, "(null)" },
    { 0x0FFD, 0x0967, 0x10de, "(null)" },
    { 0x0FFE, 0x094c, 0x103c, "(null)" },
    { 0x0FFE, 0x094c, 0x10de, "(null)" },
    { 0x0FFF, 0x094a, 0x103c, "(null)" },
    { 0x0FFF, 0x094a, 0x10de, "(null)" },
    { 0x1001, 0x1001, 0x10de, "(null)" },
    { 0x1001, 0x1078, 0x10de, "(null)" },
    { 0x1004, 0x068b, 0x1028, "(null)" },
    { 0x1004, 0x0790, 0x1028, "(null)" },
    { 0x1004, 0x079a, 0x1028, "(null)" },
    { 0x1004, 0x104b, 0x10de, "(null)" },
    { 0x1004, 0x105a, 0x10de, "(null)" },
    { 0x1005, 0x068b, 0x1028, "(null)" },
    { 0x1005, 0x0790, 0x1028, "(null)" },
    { 0x1005, 0x079a, 0x1028, "(null)" },
    { 0x1007, 0x068b, 0x1028, "(null)" },
    { 0x1007, 0x0790, 0x1028, "(null)" },
    { 0x1007, 0x079a, 0x1028, "(null)" },
    { 0x1008, 0x068b, 0x1028, "(null)" },
    { 0x1008, 0x0790, 0x1028, "(null)" },
    { 0x1008, 0x079a, 0x1028, "(null)" },
    { 0x100A, 0x068b, 0x1028, "(null)" },
    { 0x100A, 0x0790, 0x1028, "(null)" },
    { 0x100A, 0x079a, 0x1028, "(null)" },
    { 0x100C, 0x068b, 0x1028, "(null)" },
    { 0x100C, 0x0790, 0x1028, "(null)" },
    { 0x100C, 0x079a, 0x1028, "(null)" },
    { 0x1021, 0x097d, 0x10de, "(null)" },
    { 0x1022, 0x0982, 0x103c, "(null)" },
    { 0x1022, 0x0982, 0x10de, "(null)" },
    { 0x1023, 0x097e, 0x10de, "(null)" },
    { 0x1024, 0x0983, 0x103c, "(null)" },
    { 0x1024, 0x0983, 0x10de, "(null)" },
    { 0x1028, 0x1015, 0x10de, "(null)" },
    { 0x102D, 0x106c, 0x10de, "(null)" },
    { 0x103A, 0x1036, 0x103c, "(null)" },
    { 0x103A, 0x1036, 0x10de, "(null)" },
    { 0x103C, 0x1095, 0x103c, "(null)" },
    { 0x103C, 0x1095, 0x10de, "(null)" },
    { 0x1040, 0x83a0, 0x1043, "(null)" },
    { 0x1040, 0x83bd, 0x1043, "(null)" },
    { 0x1040, 0x83c1, 0x1043, "(null)" },
    { 0x1040, 0x0915, 0x10de, "(null)" },
    { 0x1040, 0xc000, 0x1458, "(null)" },
    { 0x1040, 0x2592, 0x1462, "(null)" },
    { 0x1040, 0x2593, 0x1462, "(null)" },
    { 0x1040, 0x259a, 0x1462, "(null)" },
    { 0x1040, 0x3a98, 0x1642, "(null)" },
    { 0x1040, 0x3b42, 0x1642, "(null)" },
    { 0x1040, 0x3214, 0x174b, "(null)" },
    { 0x1040, 0x90aa, 0x1b0a, "(null)" },
    { 0x1042, 0x2594, 0x1462, "(null)" },
    { 0x1042, 0x2595, 0x1462, "(null)" },
    { 0x1042, 0x2596, 0x1462, "(null)" },
    { 0x1042, 0x3a98, 0x1642, "(null)" },
    { 0x1042, 0x3b42, 0x1642, "(null)" },
    { 0x1042, 0x1214, 0x174b, "(null)" },
    { 0x1042, 0x1222, 0x174b, "(null)" },
    { 0x1048, 0x1014, 0x1019, "(null)" },
    { 0x1048, 0x5afd, 0x107d, "(null)" },
    { 0x1048, 0x2597, 0x1462, "(null)" },
    { 0x1048, 0x2598, 0x1462, "(null)" },
    { 0x1048, 0x2599, 0x1462, "(null)" },
    { 0x1048, 0x3a98, 0x1642, "(null)" },
    { 0x1048, 0x3b42, 0x1642, "(null)" },
    { 0x1048, 0x3c26, 0x1642, "(null)" },
    { 0x1048, 0x0605, 0x174b, "(null)" },
    { 0x1048, 0xa601, 0x174b, "(null)" },
    { 0x1049, 0x1016, 0x1019, "(null)" },
    { 0x1049, 0x83e6, 0x1043, "(null)" },
    { 0x1049, 0x83e7, 0x1043, "(null)" },
    { 0x1049, 0x83ea, 0x1043, "(null)" },
    { 0x1049, 0x83eb, 0x1043, "(null)" },
    { 0x1049, 0x83ec, 0x1043, "(null)" },
    { 0x1049, 0x8473, 0x1043, "(null)" },
    { 0x1049, 0x0977, 0x10de, "(null)" },
    { 0x1049, 0x809c, 0x144d, "(null)" },
    { 0x1049, 0x809d, 0x144d, "(null)" },
    { 0x1049, 0x259d, 0x1462, "(null)" },
    { 0x1049, 0x259e, 0x1462, "(null)" },
    { 0x1049, 0xb591, 0x1462, "(null)" },
    { 0x1049, 0x3a98, 0x1642, "(null)" },
    { 0x1049, 0x3b42, 0x1642, "(null)" },
    { 0x1049, 0x0620, 0x174b, "(null)" },
    { 0x1049, 0xa621, 0x174b, "(null)" },
    { 0x1049, 0xa622, 0x174b, "(null)" },
    { 0x1049, 0x90b7, 0x1b0a, "(null)" },
    { 0x1049, 0x90be, 0x1b0a, "(null)" },
    { 0x1049, 0x1462, 0x259d, "(null)" },
    { 0x1049, 0x1462, 0x259e, "(null)" },
    { 0x104B, 0x1021, 0x1019, "(null)" },
    { 0x104B, 0x0790, 0x1028, "(null)" },
    { 0x104B, 0x844c, 0x1043, "(null)" },
    { 0x104B, 0x846b, 0x1043, "(null)" },
    { 0x104B, 0x102a, 0x10de, "(null)" },
    { 0x104B, 0x80a1, 0x144d, "(null)" },
    { 0x104B, 0x80a3, 0x144d, "(null)" },
    { 0x104B, 0xb590, 0x1462, "(null)" },
    { 0x104B, 0xb592, 0x1462, "(null)" },
    { 0x104B, 0x0625, 0x174b, "(null)" },
    { 0x104B, 0xa625, 0x174b, "(null)" },
    { 0x104C, 0x1027, 0x1019, "(null)" },
    { 0x104C, 0x0790, 0x1028, "(null)" },
    { 0x104C, 0x109b, 0x1028, "(null)" },
    { 0x104C, 0x1086, 0x10de, "(null)" },
    { 0x104C, 0x80a5, 0x144d, "(null)" },
    { 0x104C, 0x80a7, 0x144d, "(null)" },
    { 0x104C, 0x2700, 0x1462, "(null)" },
    { 0x104C, 0x2701, 0x1462, "(null)" },
    { 0x104C, 0x2702, 0x1462, "(null)" },
    { 0x104C, 0xb593, 0x1462, "(null)" },
    { 0x104C, 0xb594, 0x1462, "(null)" },
    { 0x104C, 0xb595, 0x1462, "(null)" },
    { 0x104C, 0xb596, 0x1462, "(null)" },
    { 0x104C, 0xb597, 0x1462, "(null)" },
    { 0x104C, 0xb598, 0x1462, "(null)" },
    { 0x104C, 0xb599, 0x1462, "(null)" },
    { 0x104C, 0x3a98, 0x1642, "(null)" },
    { 0x104C, 0x3b42, 0x1642, "(null)" },
    { 0x104C, 0x214a, 0x174b, "(null)" },
    { 0x104C, 0xa705, 0x174b, "(null)" },
    { 0x1050, 0x0487, 0x1025, "(null)" },
    { 0x1050, 0x0488, 0x1025, "(null)" },
    { 0x1050, 0x0501, 0x1025, "(null)" },
    { 0x1050, 0x0503, 0x1025, "(null)" },
    { 0x1050, 0x0505, 0x1025, "(null)" },
    { 0x1050, 0x0507, 0x1025, "(null)" },
    { 0x1050, 0x0509, 0x1025, "(null)" },
    { 0x1050, 0x0511, 0x1025, "(null)" },
    { 0x1050, 0x0512, 0x1025, "(null)" },
    { 0x1050, 0x053a, 0x1025, "(null)" },
    { 0x1050, 0x054e, 0x1025, "(null)" },
    { 0x1050, 0x0550, 0x1025, "(null)" },
    { 0x1050, 0x055a, 0x1025, "(null)" },
    { 0x1050, 0x055c, 0x1025, "(null)" },
    { 0x1050, 0x0568, 0x1025, "(null)" },
    { 0x1050, 0x056a, 0x1025, "(null)" },
    { 0x1050, 0x056b, 0x1025, "(null)" },
    { 0x1050, 0x056c, 0x1025, "(null)" },
    { 0x1050, 0x0570, 0x1025, "(null)" },
    { 0x1050, 0x0572, 0x1025, "(null)" },
    { 0x1050, 0x0573, 0x1025, "(null)" },
    { 0x1050, 0x0574, 0x1025, "(null)" },
    { 0x1050, 0x0575, 0x1025, "(null)" },
    { 0x1050, 0x0576, 0x1025, "(null)" },
    { 0x1050, 0x0578, 0x1025, "(null)" },
    { 0x1050, 0x0579, 0x1025, "(null)" },
    { 0x1050, 0x057a, 0x1025, "(null)" },
    { 0x1050, 0x057b, 0x1025, "(null)" },
    { 0x1050, 0x0580, 0x1025, "(null)" },
    { 0x1050, 0x0581, 0x1025, "(null)" },
    { 0x1050, 0x058b, 0x1025, "(null)" },
    { 0x1050, 0x058c, 0x1025, "(null)" },
    { 0x1050, 0x0593, 0x1025, "(null)" },
    { 0x1050, 0x060d, 0x1025, "(null)" },
    { 0x1050, 0x060f, 0x1025, "(null)" },
    { 0x1050, 0x0611, 0x1025, "(null)" },
    { 0x1050, 0x1050, 0x1025, "(null)" },
    { 0x1050, 0x0522, 0x1028, "(null)" },
    { 0x1050, 0x0579, 0x1028, "(null)" },
    { 0x1050, 0x184d, 0x103c, "(null)" },
    { 0x1050, 0x338a, 0x103c, "(null)" },
    { 0x1050, 0x338b, 0x103c, "(null)" },
    { 0x1050, 0x338c, 0x103c, "(null)" },
    { 0x1050, 0x1622, 0x1043, "(null)" },
    { 0x1050, 0x1662, 0x1043, "(null)" },
    { 0x1050, 0x1682, 0x1043, "(null)" },
    { 0x1050, 0x16f2, 0x1043, "(null)" },
    { 0x1050, 0x1722, 0x1043, "(null)" },
    { 0x1050, 0x1742, 0x1043, "(null)" },
    { 0x1050, 0x84cf, 0x1043, "(null)" },
    { 0x1050, 0x9089, 0x104d, "(null)" },
    { 0x1050, 0x908a, 0x104d, "(null)" },
    { 0x1050, 0x908b, 0x104d, "(null)" },
    { 0x1050, 0x1635, 0x10cf, "(null)" },
    { 0x1050, 0x1655, 0x10cf, "(null)" },
    { 0x1050, 0xfc01, 0x1179, "(null)" },
    { 0x1050, 0xfc31, 0x1179, "(null)" },
    { 0x1050, 0xfc50, 0x1179, "(null)" },
    { 0x1050, 0xfc61, 0x1179, "(null)" },
    { 0x1050, 0xfc71, 0x1179, "(null)" },
    { 0x1050, 0xfc90, 0x1179, "(null)" },
    { 0x1050, 0xfcc0, 0x1179, "(null)" },
    { 0x1050, 0xfcd0, 0x1179, "(null)" },
    { 0x1050, 0xfce2, 0x1179, "(null)" },
    { 0x1050, 0xfcf2, 0x1179, "(null)" },
    { 0x1050, 0xfd16, 0x1179, "(null)" },
    { 0x1050, 0xfd40, 0x1179, "(null)" },
    { 0x1050, 0xfd50, 0x1179, "(null)" },
    { 0x1050, 0xfd52, 0x1179, "(null)" },
    { 0x1050, 0xfd61, 0x1179, "(null)" },
    { 0x1050, 0xfd71, 0x1179, "(null)" },
    { 0x1050, 0xfdd0, 0x1179, "(null)" },
    { 0x1050, 0xfdd2, 0x1179, "(null)" },
    { 0x1050, 0xc0a0, 0x144d, "(null)" },
    { 0x1050, 0xc0b2, 0x144d, "(null)" },
    { 0x1050, 0xc0b6, 0x144d, "(null)" },
    { 0x1050, 0xc597, 0x144d, "(null)" },
    { 0x1050, 0x1132, 0x1458, "(null)" },
    { 0x1050, 0x108c, 0x1462, "(null)" },
    { 0x1050, 0x1094, 0x1462, "(null)" },
    { 0x1050, 0x0a91, 0x16f3, "(null)" },
    { 0x1050, 0x0c9f, 0x16f3, "(null)" },
    { 0x1050, 0x1050, 0x16f3, "(null)" },
    { 0x1050, 0x3652, 0x17aa, "(null)" },
    { 0x1050, 0x397d, 0x17aa, "(null)" },
    { 0x1050, 0x397f, 0x17aa, "(null)" },
    { 0x1050, 0x10e5, 0x17c0, "(null)" },
    { 0x1050, 0x10ec, 0x17c0, "(null)" },
    { 0x1050, 0x10f3, 0x17c0, "(null)" },
    { 0x1050, 0x0865, 0x1854, "(null)" },
    { 0x1050, 0x0871, 0x1854, "(null)" },
    { 0x1050, 0x1791, 0x1854, "(null)" },
    { 0x1050, 0x3001, 0x1854, "(null)" },
    { 0x1050, 0x3004, 0x1854, "(null)" },
    { 0x1050, 0x5584, 0x1991, "(null)" },
    { 0x1050, 0x2002, 0x1bab, "(null)" },
    { 0x1050, 0x8005, 0x1bfd, "(null)" },
    { 0x1050, 0x1a86, 0x4352, "(null)" },
    { 0x1050, 0x4352, 0x8986, "(null)" },
    { 0x1051, 0x1762, 0x1043, "(null)" },
    { 0x1051, 0xc0b6, 0x144d, "(null)" },
    { 0x1051, 0xc0b7, 0x144d, "(null)" },
    { 0x1051, 0xc606, 0x144d, "(null)" },
    { 0x1051, 0x1094, 0x1462, "(null)" },
    { 0x1051, 0x0892, 0x1854, "(null)" },
    { 0x1051, 0x1797, 0x1854, "(null)" },
    { 0x1051, 0x3006, 0x1854, "(null)" },
    { 0x1051, 0x300c, 0x1854, "(null)" },
    { 0x1051, 0x3011, 0x1854, "(null)" },
    { 0x1052, 0x109c, 0x1462, "(null)" },
    { 0x1052, 0x10aa, 0x1462, "(null)" },
    { 0x1054, 0x0511, 0x1028, "(null)" },
    { 0x1054, 0x1656, 0x10cf, "(null)" },
    { 0x1054, 0x1657, 0x10cf, "(null)" },
    { 0x1054, 0xfcc0, 0x1179, "(null)" },
    { 0x1054, 0x1100, 0x1458, "(null)" },
    { 0x1054, 0x1125, 0x1458, "(null)" },
    { 0x1054, 0x1094, 0x1462, "(null)" },
    { 0x1054, 0x109c, 0x1462, "(null)" },
    { 0x1054, 0x10aa, 0x1462, "(null)" },
    { 0x1054, 0x397d, 0x17aa, "(null)" },
    { 0x1054, 0x397f, 0x17aa, "(null)" },
    { 0x1054, 0x2013, 0x1854, "(null)" },
    { 0x1055, 0x908a, 0x104d, "(null)" },
    { 0x1055, 0x908b, 0x104d, "(null)" },
    { 0x1056, 0x0493, 0x1028, "(null)" },
    { 0x1056, 0x0494, 0x1028, "(null)" },
    { 0x1056, 0x04e4, 0x1028, "(null)" },
    { 0x1056, 0x1493, 0x1028, "(null)" },
    { 0x1056, 0x1494, 0x1028, "(null)" },
    { 0x1056, 0x14e4, 0x1028, "(null)" },
    { 0x1056, 0x1636, 0x10cf, "(null)" },
    { 0x1056, 0x21d2, 0x17aa, "(null)" },
    { 0x1056, 0x21d3, 0x17aa, "(null)" },
    { 0x1057, 0xc0a6, 0x144d, "(null)" },
    { 0x1057, 0xc0af, 0x144d, "(null)" },
    { 0x1057, 0xc0b0, 0x144d, "(null)" },
    { 0x1057, 0x21ce, 0x17aa, "(null)" },
    { 0x1057, 0x21cf, 0x17aa, "(null)" },
    { 0x1057, 0x21d0, 0x17aa, "(null)" },
    { 0x1057, 0x21d1, 0x17aa, "(null)" },
    { 0x1058, 0x2aed, 0x103c, "(null)" },
    { 0x1058, 0x2af1, 0x103c, "(null)" },
    { 0x1058, 0x10ac, 0x1043, "(null)" },
    { 0x1058, 0x10bc, 0x1043, "(null)" },
    { 0x1058, 0x112d, 0x1043, "(null)" },
    { 0x1058, 0x1457, 0x1043, "(null)" },
    { 0x1058, 0x1537, 0x1043, "(null)" },
    { 0x1058, 0x1652, 0x1043, "(null)" },
    { 0x1058, 0x2130, 0x1043, "(null)" },
    { 0x1058, 0x2133, 0x1043, "(null)" },
    { 0x1058, 0x8536, 0x1043, "(null)" },
    { 0x1058, 0xc652, 0x144d, "(null)" },
    { 0x1058, 0xaa5c, 0x1462, "(null)" },
    { 0x1058, 0xaa62, 0x1462, "(null)" },
    { 0x1058, 0xaa63, 0x1462, "(null)" },
    { 0x1058, 0xaa83, 0x1462, "(null)" },
    { 0x1058, 0xac71, 0x1462, "(null)" },
    { 0x1058, 0xac79, 0x1462, "(null)" },
    { 0x1058, 0xac7a, 0x1462, "(null)" },
    { 0x1058, 0xac93, 0x1462, "(null)" },
    { 0x1058, 0x0c9b, 0x16f3, "(null)" },
    { 0x1058, 0x0c9c, 0x16f3, "(null)" },
    { 0x1058, 0x367a, 0x17aa, "(null)" },
    { 0x1058, 0x3682, 0x17aa, "(null)" },
    { 0x1058, 0x3687, 0x17aa, "(null)" },
    { 0x1058, 0x3692, 0x17aa, "(null)" },
    { 0x1058, 0x3695, 0x17aa, "(null)" },
    { 0x1058, 0x36a8, 0x17aa, "(null)" },
    { 0x1058, 0x36ac, 0x17aa, "(null)" },
    { 0x1058, 0x36ad, 0x17aa, "(null)" },
    { 0x1058, 0x3901, 0x17aa, "(null)" },
    { 0x1058, 0x3902, 0x17aa, "(null)" },
    { 0x1058, 0x3903, 0x17aa, "(null)" },
    { 0x1058, 0x3977, 0x17aa, "(null)" },
    { 0x1058, 0x397d, 0x17aa, "(null)" },
    { 0x1058, 0x3983, 0x17aa, "(null)" },
    { 0x1058, 0x5001, 0x17aa, "(null)" },
    { 0x1058, 0x5003, 0x17aa, "(null)" },
    { 0x1058, 0x5005, 0x17aa, "(null)" },
    { 0x1058, 0x5007, 0x17aa, "(null)" },
    { 0x1058, 0x500f, 0x17aa, "(null)" },
    { 0x1058, 0x5012, 0x17aa, "(null)" },
    { 0x1058, 0x705a, 0x17aa, "(null)" },
    { 0x1058, 0x90c2, 0x1b0a, "(null)" },
    { 0x1058, 0x90c7, 0x1b0a, "(null)" },
    { 0x1058, 0x0009, 0x1bfd, "(null)" },
    { 0x1058, 0x3682, 0x705a, "(null)" },
    { 0x1059, 0x300c, 0x1854, "(null)" },
    { 0x1059, 0x3011, 0x1854, "(null)" },
    { 0x1059, 0x3017, 0x1854, "(null)" },
    { 0x105A, 0x0488, 0x1025, "(null)" },
    { 0x105A, 0x0505, 0x1025, "(null)" },
    { 0x105A, 0x0507, 0x1025, "(null)" },
    { 0x105A, 0x0512, 0x1025, "(null)" },
    { 0x105A, 0x055a, 0x1025, "(null)" },
    { 0x105A, 0x0611, 0x1025, "(null)" },
    { 0x105A, 0x0664, 0x1025, "(null)" },
    { 0x105A, 0x0579, 0x1028, "(null)" },
    { 0x105A, 0x1898, 0x103c, "(null)" },
    { 0x105A, 0x2aed, 0x103c, "(null)" },
    { 0x105A, 0x2af1, 0x103c, "(null)" },
    { 0x105A, 0x2111, 0x1043, "(null)" },
    { 0x105A, 0x2112, 0x1043, "(null)" },
    { 0x105A, 0x2129, 0x1043, "(null)" },
    { 0x105A, 0x851d, 0x1043, "(null)" },
    { 0x105A, 0x0930, 0x10de, "(null)" },
    { 0x105A, 0x2661, 0x1462, "(null)" },
    { 0x105B, 0x2afb, 0x103c, "(null)" },
    { 0x105B, 0xaa63, 0x1462, "(null)" },
    { 0x105B, 0xaa83, 0x1462, "(null)" },
    { 0x105B, 0xaa86, 0x1462, "(null)" },
    { 0x105B, 0xac13, 0x1462, "(null)" },
    { 0x105B, 0xac79, 0x1462, "(null)" },
    { 0x105B, 0xac7e, 0x1462, "(null)" },
    { 0x105B, 0xac93, 0x1462, "(null)" },
    { 0x105B, 0xac96, 0x1462, "(null)" },
    { 0x105B, 0x309d, 0x17aa, "(null)" },
    { 0x105B, 0x30b1, 0x17aa, "(null)" },
    { 0x105B, 0x30f3, 0x17aa, "(null)" },
    { 0x105B, 0x36a1, 0x17aa, "(null)" },
    { 0x105B, 0x90c8, 0x1b0a, "(null)" },
    { 0x105B, 0x90cd, 0x1b0a, "(null)" },
    { 0x105B, 0x90ce, 0x1b0a, "(null)" },
    { 0x105B, 0x90d0, 0x1b0a, "(null)" },
    { 0x107C, 0x102f, 0x103c, "(null)" },
    { 0x107C, 0x102f, 0x107c, "(null)" },
    { 0x107C, 0x102f, 0x10de, "(null)" },
    { 0x107D, 0x094e, 0x103c, "(null)" },
    { 0x107D, 0x1154, 0x103c, "(null)" },
    { 0x107D, 0x094e, 0x10de, "(null)" },
    { 0x107D, 0x1154, 0x10de, "(null)" },
    { 0x1080, 0x086a, 0x10de, "(null)" },
    { 0x1080, 0x0947, 0x10de, "(null)" },
    { 0x1081, 0x087e, 0x10de, "(null)" },
    { 0x1082, 0x0873, 0x10de, "(null)" },
    { 0x1082, 0x5207, 0x174b, "(null)" },
    { 0x1084, 0x2570, 0x1462, "(null)" },
    { 0x1084, 0x2571, 0x1462, "(null)" },
    { 0x1084, 0x2572, 0x1462, "(null)" },
    { 0x1084, 0x3a96, 0x1642, "(null)" },
    { 0x1086, 0x8387, 0x1043, "(null)" },
    { 0x1086, 0x2573, 0x1462, "(null)" },
    { 0x1086, 0x1207, 0x174b, "(null)" },
    { 0x1088, 0x0868, 0x10de, "(null)" },
    { 0x1091, 0x084d, 0x10de, "(null)" },
    { 0x1091, 0x0887, 0x10de, "(null)" },
    { 0x1091, 0x088e, 0x10de, "(null)" },
    { 0x1091, 0x0891, 0x10de, "(null)" },
    { 0x1091, 0x0974, 0x10de, "(null)" },
    { 0x1091, 0x098d, 0x10de, "(null)" },
    { 0x1094, 0x084d, 0x10de, "(null)" },
    { 0x1094, 0x0888, 0x10de, "(null)" },
    { 0x1096, 0x0910, 0x103c, "(null)" },
    { 0x1096, 0x0910, 0x10de, "(null)" },
    { 0x1096, 0x0911, 0x10de, "(null)" },
    { 0x109A, 0x04a4, 0x1028, "(null)" },
    { 0x109A, 0x14a4, 0x1028, "(null)" },
    { 0x109A, 0x1630, 0x103c, "(null)" },
    { 0x109A, 0x1754, 0x10cf, "(null)" },
    { 0x109A, 0x0270, 0x1558, "(null)" },
    { 0x109A, 0x5102, 0x1558, "(null)" },
    { 0x109A, 0x5105, 0x1558, "(null)" },
    { 0x109A, 0x7100, 0x1558, "(null)" },
    { 0x109A, 0x7102, 0x1558, "(null)" },
    { 0x109A, 0x7200, 0x1558, "(null)" },
    { 0x109B, 0x0918, 0x10de, "(null)" },
    { 0x10C5, 0x1009, 0x1019, "(null)" },
    { 0x10C5, 0x838d, 0x1043, "(null)" },
    { 0x10C5, 0x839c, 0x1043, "(null)" },
    { 0x10C5, 0x808a, 0x144d, "(null)" },
    { 0x10C5, 0x1834, 0x1462, "(null)" },
    { 0x10C5, 0x1835, 0x1462, "(null)" },
    { 0x10C5, 0x1837, 0x1462, "(null)" },
    { 0x10C5, 0x183b, 0x1462, "(null)" },
    { 0x10C5, 0x3899, 0x1642, "(null)" },
    { 0x10C5, 0x3958, 0x1642, "(null)" },
    { 0x10C5, 0x3150, 0x174b, "(null)" },
    { 0x10C5, 0x908e, 0x1b0a, "(null)" },
    { 0x10C5, 0x90a9, 0x1b0a, "(null)" },
    { 0x10C5, 0x90af, 0x1b0a, "(null)" },
    { 0x10D8, 0x0862, 0x103c, "(null)" },
    { 0x10D8, 0x0862, 0x10de, "(null)" },
    { 0x1140, 0x0799, 0x1019, "(null)" },
    { 0x1140, 0x999f, 0x1019, "(null)" },
    { 0x1140, 0x0600, 0x1025, "(null)" },
    { 0x1140, 0x0606, 0x1025, "(null)" },
    { 0x1140, 0x064a, 0x1025, "(null)" },
    { 0x1140, 0x064c, 0x1025, "(null)" },
    { 0x1140, 0x067a, 0x1025, "(null)" },
    { 0x1140, 0x0680, 0x1025, "(null)" },
    { 0x1140, 0x0686, 0x1025, "(null)" },
    { 0x1140, 0x0689, 0x1025, "(null)" },
    { 0x1140, 0x068b, 0x1025, "(null)" },
    { 0x1140, 0x068d, 0x1025, "(null)" },
    { 0x1140, 0x068e, 0x1025, "(null)" },
    { 0x1140, 0x0691, 0x1025, "(null)" },
    { 0x1140, 0x0692, 0x1025, "(null)" },
    { 0x1140, 0x0694, 0x1025, "(null)" },
    { 0x1140, 0x0702, 0x1025, "(null)" },
    { 0x1140, 0x0719, 0x1025, "(null)" },
    { 0x1140, 0x0725, 0x1025, "(null)" },
    { 0x1140, 0x0728, 0x1025, "(null)" },
    { 0x1140, 0x072b, 0x1025, "(null)" },
    { 0x1140, 0x072e, 0x1025, "(null)" },
    { 0x1140, 0x0732, 0x1025, "(null)" },
    { 0x1140, 0x0763, 0x1025, "(null)" },
    { 0x1140, 0x0773, 0x1025, "(null)" },
    { 0x1140, 0x0774, 0x1025, "(null)" },
    { 0x1140, 0x0776, 0x1025, "(null)" },
    { 0x1140, 0x077a, 0x1025, "(null)" },
    { 0x1140, 0x077b, 0x1025, "(null)" },
    { 0x1140, 0x077c, 0x1025, "(null)" },
    { 0x1140, 0x077d, 0x1025, "(null)" },
    { 0x1140, 0x077e, 0x1025, "(null)" },
    { 0x1140, 0x077f, 0x1025, "(null)" },
    { 0x1140, 0x0781, 0x1025, "(null)" },
    { 0x1140, 0x0798, 0x1025, "(null)" },
    { 0x1140, 0x0799, 0x1025, "(null)" },
    { 0x1140, 0x079b, 0x1025, "(null)" },
    { 0x1140, 0x079c, 0x1025, "(null)" },
    { 0x1140, 0x0807, 0x1025, "(null)" },
    { 0x1140, 0x0821, 0x1025, "(null)" },
    { 0x1140, 0x0823, 0x1025, "(null)" },
    { 0x1140, 0x0830, 0x1025, "(null)" },
    { 0x1140, 0x0833, 0x1025, "(null)" },
    { 0x1140, 0x0837, 0x1025, "(null)" },
    { 0x1140, 0x083e, 0x1025, "(null)" },
    { 0x1140, 0x0841, 0x1025, "(null)" },
    { 0x1140, 0x0853, 0x1025, "(null)" },
    { 0x1140, 0x0854, 0x1025, "(null)" },
    { 0x1140, 0x0855, 0x1025, "(null)" },
    { 0x1140, 0x0856, 0x1025, "(null)" },
    { 0x1140, 0x0857, 0x1025, "(null)" },
    { 0x1140, 0x0858, 0x1025, "(null)" },
    { 0x1140, 0x0863, 0x1025, "(null)" },
    { 0x1140, 0x0868, 0x1025, "(null)" },
    { 0x1140, 0x0869, 0x1025, "(null)" },
    { 0x1140, 0x0873, 0x1025, "(null)" },
    { 0x1140, 0x0878, 0x1025, "(null)" },
    { 0x1140, 0x087b, 0x1025, "(null)" },
    { 0x1140, 0x087f, 0x1025, "(null)" },
    { 0x1140, 0x0881, 0x1025, "(null)" },
    { 0x1140, 0x0885, 0x1025, "(null)" },
    { 0x1140, 0x088a, 0x1025, "(null)" },
    { 0x1140, 0x089b, 0x1025, "(null)" },
    { 0x1140, 0x0921, 0x1025, "(null)" },
    { 0x1140, 0x092e, 0x1025, "(null)" },
    { 0x1140, 0x092f, 0x1025, "(null)" },
    { 0x1140, 0x0932, 0x1025, "(null)" },
    { 0x1140, 0x093a, 0x1025, "(null)" },
    { 0x1140, 0x093c, 0x1025, "(null)" },
    { 0x1140, 0x093f, 0x1025, "(null)" },
    { 0x1140, 0x0941, 0x1025, "(null)" },
    { 0x1140, 0x0945, 0x1025, "(null)" },
    { 0x1140, 0x0954, 0x1025, "(null)" },
    { 0x1140, 0x0965, 0x1025, "(null)" },
    { 0x1140, 0x054d, 0x1028, "(null)" },
    { 0x1140, 0x054e, 0x1028, "(null)" },
    { 0x1140, 0x0554, 0x1028, "(null)" },
    { 0x1140, 0x0557, 0x1028, "(null)" },
    { 0x1140, 0x0562, 0x1028, "(null)" },
    { 0x1140, 0x0565, 0x1028, "(null)" },
    { 0x1140, 0x0568, 0x1028, "(null)" },
    { 0x1140, 0x0590, 0x1028, "(null)" },
    { 0x1140, 0x0592, 0x1028, "(null)" },
    { 0x1140, 0x0594, 0x1028, "(null)" },
    { 0x1140, 0x0595, 0x1028, "(null)" },
    { 0x1140, 0x05a2, 0x1028, "(null)" },
    { 0x1140, 0x05b1, 0x1028, "(null)" },
    { 0x1140, 0x05b3, 0x1028, "(null)" },
    { 0x1140, 0x05da, 0x1028, "(null)" },
    { 0x1140, 0x05de, 0x1028, "(null)" },
    { 0x1140, 0x05e0, 0x1028, "(null)" },
    { 0x1140, 0x05e8, 0x1028, "(null)" },
    { 0x1140, 0x05f4, 0x1028, "(null)" },
    { 0x1140, 0x060f, 0x1028, "(null)" },
    { 0x1140, 0x062f, 0x1028, "(null)" },
    { 0x1140, 0x064e, 0x1028, "(null)" },
    { 0x1140, 0x0652, 0x1028, "(null)" },
    { 0x1140, 0x0653, 0x1028, "(null)" },
    { 0x1140, 0x0655, 0x1028, "(null)" },
    { 0x1140, 0x065e, 0x1028, "(null)" },
    { 0x1140, 0x0662, 0x1028, "(null)" },
    { 0x1140, 0x068d, 0x1028, "(null)" },
    { 0x1140, 0x06ad, 0x1028, "(null)" },
    { 0x1140, 0x06ae, 0x1028, "(null)" },
    { 0x1140, 0x06af, 0x1028, "(null)" },
    { 0x1140, 0x06b0, 0x1028, "(null)" },
    { 0x1140, 0x06c0, 0x1028, "(null)" },
    { 0x1140, 0x06c1, 0x1028, "(null)" },
    { 0x1140, 0x18ef, 0x103c, "(null)" },
    { 0x1140, 0x18f9, 0x103c, "(null)" },
    { 0x1140, 0x18fb, 0x103c, "(null)" },
    { 0x1140, 0x18fd, 0x103c, "(null)" },
    { 0x1140, 0x18ff, 0x103c, "(null)" },
    { 0x1140, 0x218a, 0x103c, "(null)" },
    { 0x1140, 0x21bb, 0x103c, "(null)" },
    { 0x1140, 0x21bc, 0x103c, "(null)" },
    { 0x1140, 0x220e, 0x103c, "(null)" },
    { 0x1140, 0x2210, 0x103c, "(null)" },
    { 0x1140, 0x2212, 0x103c, "(null)" },
    { 0x1140, 0x2214, 0x103c, "(null)" },
    { 0x1140, 0x2218, 0x103c, "(null)" },
    { 0x1140, 0x225b, 0x103c, "(null)" },
    { 0x1140, 0x225d, 0x103c, "(null)" },
    { 0x1140, 0x226d, 0x103c, "(null)" },
    { 0x1140, 0x226f, 0x103c, "(null)" },
    { 0x1140, 0x22d2, 0x103c, "(null)" },
    { 0x1140, 0x22d9, 0x103c, "(null)" },
    { 0x1140, 0x2335, 0x103c, "(null)" },
    { 0x1140, 0x2337, 0x103c, "(null)" },
    { 0x1140, 0x2aef, 0x103c, "(null)" },
    { 0x1140, 0x2af9, 0x103c, "(null)" },
    { 0x1140, 0x10dd, 0x1043, "(null)" },
    { 0x1140, 0x10ed, 0x1043, "(null)" },
    { 0x1140, 0x11fd, 0x1043, "(null)" },
    { 0x1140, 0x124d, 0x1043, "(null)" },
    { 0x1140, 0x126d, 0x1043, "(null)" },
    { 0x1140, 0x131d, 0x1043, "(null)" },
    { 0x1140, 0x13fd, 0x1043, "(null)" },
    { 0x1140, 0x14c7, 0x1043, "(null)" },
    { 0x1140, 0x1507, 0x1043, "(null)" },
    { 0x1140, 0x15ad, 0x1043, "(null)" },
    { 0x1140, 0x15ed, 0x1043, "(null)" },
    { 0x1140, 0x160d, 0x1043, "(null)" },
    { 0x1140, 0x163d, 0x1043, "(null)" },
    { 0x1140, 0x165d, 0x1043, "(null)" },
    { 0x1140, 0x166d, 0x1043, "(null)" },
    { 0x1140, 0x16cd, 0x1043, "(null)" },
    { 0x1140, 0x16dd, 0x1043, "(null)" },
    { 0x1140, 0x170d, 0x1043, "(null)" },
    { 0x1140, 0x176d, 0x1043, "(null)" },
    { 0x1140, 0x178d, 0x1043, "(null)" },
    { 0x1140, 0x179d, 0x1043, "(null)" },
    { 0x1140, 0x2132, 0x1043, "(null)" },
    { 0x1140, 0x2136, 0x1043, "(null)" },
    { 0x1140, 0x21ba, 0x1043, "(null)" },
    { 0x1140, 0x21fa, 0x1043, "(null)" },
    { 0x1140, 0x220a, 0x1043, "(null)" },
    { 0x1140, 0x221a, 0x1043, "(null)" },
    { 0x1140, 0x223a, 0x1043, "(null)" },
    { 0x1140, 0x224a, 0x1043, "(null)" },
    { 0x1140, 0x227a, 0x1043, "(null)" },
    { 0x1140, 0x228a, 0x1043, "(null)" },
    { 0x1140, 0x22fa, 0x1043, "(null)" },
    { 0x1140, 0x232a, 0x1043, "(null)" },
    { 0x1140, 0x233a, 0x1043, "(null)" },
    { 0x1140, 0x235a, 0x1043, "(null)" },
    { 0x1140, 0x236a, 0x1043, "(null)" },
    { 0x1140, 0x238a, 0x1043, "(null)" },
    { 0x1140, 0x8595, 0x1043, "(null)" },
    { 0x1140, 0x85ea, 0x1043, "(null)" },
    { 0x1140, 0x85eb, 0x1043, "(null)" },
    { 0x1140, 0x85ec, 0x1043, "(null)" },
    { 0x1140, 0x85ee, 0x1043, "(null)" },
    { 0x1140, 0x85f3, 0x1043, "(null)" },
    { 0x1140, 0x860e, 0x1043, "(null)" },
    { 0x1140, 0x861a, 0x1043, "(null)" },
    { 0x1140, 0x861b, 0x1043, "(null)" },
    { 0x1140, 0x8628, 0x1043, "(null)" },
    { 0x1140, 0x8643, 0x1043, "(null)" },
    { 0x1140, 0x864c, 0x1043, "(null)" },
    { 0x1140, 0x8652, 0x1043, "(null)" },
    { 0x1140, 0x8660, 0x1043, "(null)" },
    { 0x1140, 0x8661, 0x1043, "(null)" },
    { 0x1140, 0x0dac, 0x105b, "(null)" },
    { 0x1140, 0x0dad, 0x105b, "(null)" },
    { 0x1140, 0x0ef3, 0x105b, "(null)" },
    { 0x1140, 0x17f5, 0x10cf, "(null)" },
    { 0x1140, 0xfa01, 0x1179, "(null)" },
    { 0x1140, 0xfa02, 0x1179, "(null)" },
    { 0x1140, 0xfa03, 0x1179, "(null)" },
    { 0x1140, 0xfa05, 0x1179, "(null)" },
    { 0x1140, 0xfa11, 0x1179, "(null)" },
    { 0x1140, 0xfa13, 0x1179, "(null)" },
    { 0x1140, 0xfa18, 0x1179, "(null)" },
    { 0x1140, 0xfa19, 0x1179, "(null)" },
    { 0x1140, 0xfa21, 0x1179, "(null)" },
    { 0x1140, 0xfa23, 0x1179, "(null)" },
    { 0x1140, 0xfa2a, 0x1179, "(null)" },
    { 0x1140, 0xfa32, 0x1179, "(null)" },
    { 0x1140, 0xfa33, 0x1179, "(null)" },
    { 0x1140, 0xfa36, 0x1179, "(null)" },
    { 0x1140, 0xfa38, 0x1179, "(null)" },
    { 0x1140, 0xfa42, 0x1179, "(null)" },
    { 0x1140, 0xfa43, 0x1179, "(null)" },
    { 0x1140, 0xfa45, 0x1179, "(null)" },
    { 0x1140, 0xfa47, 0x1179, "(null)" },
    { 0x1140, 0xfa49, 0x1179, "(null)" },
    { 0x1140, 0xfa58, 0x1179, "(null)" },
    { 0x1140, 0xfa59, 0x1179, "(null)" },
    { 0x1140, 0xfa88, 0x1179, "(null)" },
    { 0x1140, 0xfa89, 0x1179, "(null)" },
    { 0x1140, 0xb092, 0x144d, "(null)" },
    { 0x1140, 0xb098, 0x144d, "(null)" },
    { 0x1140, 0xc0d5, 0x144d, "(null)" },
    { 0x1140, 0xc0d7, 0x144d, "(null)" },
    { 0x1140, 0xc0e2, 0x144d, "(null)" },
    { 0x1140, 0xc0e3, 0x144d, "(null)" },
    { 0x1140, 0xc0e4, 0x144d, "(null)" },
    { 0x1140, 0xc10d, 0x144d, "(null)" },
    { 0x1140, 0xc652, 0x144d, "(null)" },
    { 0x1140, 0xc709, 0x144d, "(null)" },
    { 0x1140, 0xc711, 0x144d, "(null)" },
    { 0x1140, 0xc736, 0x144d, "(null)" },
    { 0x1140, 0xc737, 0x144d, "(null)" },
    { 0x1140, 0xc745, 0x144d, "(null)" },
    { 0x1140, 0xc750, 0x144d, "(null)" },
    { 0x1140, 0x10b8, 0x1462, "(null)" },
    { 0x1140, 0x10e9, 0x1462, "(null)" },
    { 0x1140, 0x1116, 0x1462, "(null)" },
    { 0x1140, 0xaa33, 0x1462, "(null)" },
    { 0x1140, 0xaaa2, 0x1462, "(null)" },
    { 0x1140, 0xaaa3, 0x1462, "(null)" },
    { 0x1140, 0xacb2, 0x1462, "(null)" },
    { 0x1140, 0xacc1, 0x1462, "(null)" },
    { 0x1140, 0xae61, 0x1462, "(null)" },
    { 0x1140, 0xae65, 0x1462, "(null)" },
    { 0x1140, 0xae6a, 0x1462, "(null)" },
    { 0x1140, 0xae71, 0x1462, "(null)" },
    { 0x1140, 0x0083, 0x14c0, "(null)" },
    { 0x1140, 0x0926, 0x152d, "(null)" },
    { 0x1140, 0x0982, 0x152d, "(null)" },
    { 0x1140, 0x0983, 0x152d, "(null)" },
    { 0x1140, 0x1005, 0x152d, "(null)" },
    { 0x1140, 0x1012, 0x152d, "(null)" },
    { 0x1140, 0x1019, 0x152d, "(null)" },
    { 0x1140, 0x1030, 0x152d, "(null)" },
    { 0x1140, 0x1055, 0x152d, "(null)" },
    { 0x1140, 0x1067, 0x152d, "(null)" },
    { 0x1140, 0x1092, 0x152d, "(null)" },
    { 0x1140, 0x2200, 0x17aa, "(null)" },
    { 0x1140, 0x2213, 0x17aa, "(null)" },
    { 0x1140, 0x2220, 0x17aa, "(null)" },
    { 0x1140, 0x309c, 0x17aa, "(null)" },
    { 0x1140, 0x30b4, 0x17aa, "(null)" },
    { 0x1140, 0x30b7, 0x17aa, "(null)" },
    { 0x1140, 0x30e4, 0x17aa, "(null)" },
    { 0x1140, 0x361b, 0x17aa, "(null)" },
    { 0x1140, 0x361c, 0x17aa, "(null)" },
    { 0x1140, 0x361d, 0x17aa, "(null)" },
    { 0x1140, 0x3656, 0x17aa, "(null)" },
    { 0x1140, 0x365a, 0x17aa, "(null)" },
    { 0x1140, 0x365e, 0x17aa, "(null)" },
    { 0x1140, 0x3661, 0x17aa, "(null)" },
    { 0x1140, 0x366c, 0x17aa, "(null)" },
    { 0x1140, 0x3685, 0x17aa, "(null)" },
    { 0x1140, 0x3686, 0x17aa, "(null)" },
    { 0x1140, 0x3687, 0x17aa, "(null)" },
    { 0x1140, 0x3696, 0x17aa, "(null)" },
    { 0x1140, 0x369b, 0x17aa, "(null)" },
    { 0x1140, 0x369c, 0x17aa, "(null)" },
    { 0x1140, 0x369d, 0x17aa, "(null)" },
    { 0x1140, 0x369e, 0x17aa, "(null)" },
    { 0x1140, 0x36a6, 0x17aa, "(null)" },
    { 0x1140, 0x36a7, 0x17aa, "(null)" },
    { 0x1140, 0x36a9, 0x17aa, "(null)" },
    { 0x1140, 0x36af, 0x17aa, "(null)" },
    { 0x1140, 0x36b0, 0x17aa, "(null)" },
    { 0x1140, 0x36b6, 0x17aa, "(null)" },
    { 0x1140, 0x3800, 0x17aa, "(null)" },
    { 0x1140, 0x3801, 0x17aa, "(null)" },
    { 0x1140, 0x3802, 0x17aa, "(null)" },
    { 0x1140, 0x3803, 0x17aa, "(null)" },
    { 0x1140, 0x3804, 0x17aa, "(null)" },
    { 0x1140, 0x3806, 0x17aa, "(null)" },
    { 0x1140, 0x3808, 0x17aa, "(null)" },
    { 0x1140, 0x380d, 0x17aa, "(null)" },
    { 0x1140, 0x380e, 0x17aa, "(null)" },
    { 0x1140, 0x380f, 0x17aa, "(null)" },
    { 0x1140, 0x3811, 0x17aa, "(null)" },
    { 0x1140, 0x3812, 0x17aa, "(null)" },
    { 0x1140, 0x3813, 0x17aa, "(null)" },
    { 0x1140, 0x3816, 0x17aa, "(null)" },
    { 0x1140, 0x3817, 0x17aa, "(null)" },
    { 0x1140, 0x3818, 0x17aa, "(null)" },
    { 0x1140, 0x381a, 0x17aa, "(null)" },
    { 0x1140, 0x381c, 0x17aa, "(null)" },
    { 0x1140, 0x381d, 0x17aa, "(null)" },
    { 0x1140, 0x3901, 0x17aa, "(null)" },
    { 0x1140, 0x3902, 0x17aa, "(null)" },
    { 0x1140, 0x3903, 0x17aa, "(null)" },
    { 0x1140, 0x3904, 0x17aa, "(null)" },
    { 0x1140, 0x3905, 0x17aa, "(null)" },
    { 0x1140, 0x3907, 0x17aa, "(null)" },
    { 0x1140, 0x3910, 0x17aa, "(null)" },
    { 0x1140, 0x3912, 0x17aa, "(null)" },
    { 0x1140, 0x3913, 0x17aa, "(null)" },
    { 0x1140, 0x3915, 0x17aa, "(null)" },
    { 0x1140, 0x3983, 0x17aa, "(null)" },
    { 0x1140, 0x5001, 0x17aa, "(null)" },
    { 0x1140, 0x5003, 0x17aa, "(null)" },
    { 0x1140, 0x5005, 0x17aa, "(null)" },
    { 0x1140, 0x500d, 0x17aa, "(null)" },
    { 0x1140, 0x5014, 0x17aa, "(null)" },
    { 0x1140, 0x5017, 0x17aa, "(null)" },
    { 0x1140, 0x5019, 0x17aa, "(null)" },
    { 0x1140, 0x501a, 0x17aa, "(null)" },
    { 0x1140, 0x501f, 0x17aa, "(null)" },
    { 0x1140, 0x5025, 0x17aa, "(null)" },
    { 0x1140, 0x5027, 0x17aa, "(null)" },
    { 0x1140, 0x502a, 0x17aa, "(null)" },
    { 0x1140, 0x502b, 0x17aa, "(null)" },
    { 0x1140, 0x502d, 0x17aa, "(null)" },
    { 0x1140, 0x502e, 0x17aa, "(null)" },
    { 0x1140, 0x502f, 0x17aa, "(null)" },
    { 0x1140, 0x5030, 0x17aa, "(null)" },
    { 0x1140, 0x5031, 0x17aa, "(null)" },
    { 0x1140, 0x5032, 0x17aa, "(null)" },
    { 0x1140, 0x5033, 0x17aa, "(null)" },
    { 0x1140, 0x503e, 0x17aa, "(null)" },
    { 0x1140, 0x503f, 0x17aa, "(null)" },
    { 0x1140, 0x5040, 0x17aa, "(null)" },
    { 0x1140, 0x0177, 0x1854, "(null)" },
    { 0x1140, 0x0180, 0x1854, "(null)" },
    { 0x1140, 0x0190, 0x1854, "(null)" },
    { 0x1140, 0x0192, 0x1854, "(null)" },
    { 0x1140, 0x0224, 0x1854, "(null)" },
    { 0x1140, 0x01c0, 0x1b0a, "(null)" },
    { 0x1140, 0x20dd, 0x1b0a, "(null)" },
    { 0x1140, 0x20df, 0x1b0a, "(null)" },
    { 0x1140, 0x210e, 0x1b0a, "(null)" },
    { 0x1140, 0x2202, 0x1b0a, "(null)" },
    { 0x1140, 0x90d7, 0x1b0a, "(null)" },
    { 0x1140, 0x90dd, 0x1b0a, "(null)" },
    { 0x1140, 0x5530, 0x1b50, "(null)" },
    { 0x1140, 0x5031, 0x1b6c, "(null)" },
    { 0x1140, 0x0106, 0x1bab, "(null)" },
    { 0x1140, 0x1013, 0x1d05, "(null)" },
    { 0x1180, 0x068b, 0x1028, "(null)" },
    { 0x1180, 0x0790, 0x1028, "(null)" },
    { 0x1180, 0x079a, 0x1028, "(null)" },
    { 0x1180, 0x0969, 0x10de, "(null)" },
    { 0x1180, 0x0999, 0x10de, "(null)" },
    { 0x1180, 0x100c, 0x10de, "(null)" },
    { 0x1180, 0x1255, 0x174b, "(null)" },
    { 0x1183, 0x068b, 0x1028, "(null)" },
    { 0x1183, 0x0790, 0x1028, "(null)" },
    { 0x1183, 0x079a, 0x1028, "(null)" },
    { 0x1184, 0x068b, 0x1028, "(null)" },
    { 0x1184, 0x0790, 0x1028, "(null)" },
    { 0x1184, 0x079a, 0x1028, "(null)" },
    { 0x1184, 0x1033, 0x10de, "(null)" },
    { 0x1184, 0x1058, 0x10de, "(null)" },
    { 0x1184, 0x4255, 0x174b, "(null)" },
    { 0x1185, 0x068b, 0x1028, "(null)" },
    { 0x1185, 0x0790, 0x1028, "(null)" },
    { 0x1185, 0x079a, 0x1028, "(null)" },
    { 0x1185, 0x6889, 0x103c, "(null)" },
    { 0x1185, 0x098a, 0x10de, "(null)" },
    { 0x1185, 0x106f, 0x10de, "(null)" },
    { 0x1185, 0x2841, 0x1462, "(null)" },
    { 0x1185, 0x3c28, 0x1642, "(null)" },
    { 0x1185, 0x2260, 0x174b, "(null)" },
    { 0x1187, 0x068b, 0x1028, "(null)" },
    { 0x1187, 0x0790, 0x1028, "(null)" },
    { 0x1187, 0x079a, 0x1028, "(null)" },
    { 0x1187, 0x85e9, 0x1043, "(null)" },
    { 0x1187, 0x2849, 0x1462, "(null)" },
    { 0x1187, 0x3d34, 0x1642, "(null)" },
    { 0x1187, 0x3265, 0x174b, "(null)" },
    { 0x1188, 0x068b, 0x1028, "(null)" },
    { 0x1188, 0x0790, 0x1028, "(null)" },
    { 0x1188, 0x079a, 0x1028, "(null)" },
    { 0x1188, 0x095b, 0x10de, "(null)" },
    { 0x1189, 0x064c, 0x1028, "(null)" },
    { 0x1189, 0x068b, 0x1028, "(null)" },
    { 0x1189, 0x0790, 0x1028, "(null)" },
    { 0x1189, 0x079a, 0x1028, "(null)" },
    { 0x1189, 0x097a, 0x10de, "(null)" },
    { 0x1189, 0x1074, 0x10de, "(null)" },
    { 0x1189, 0x1260, 0x174b, "(null)" },
    { 0x118E, 0x064c, 0x1028, "(null)" },
    { 0x118E, 0x068b, 0x1028, "(null)" },
    { 0x118E, 0x0790, 0x1028, "(null)" },
    { 0x118E, 0x079a, 0x1028, "(null)" },
    { 0x118E, 0x6892, 0x103c, "(null)" },
    { 0x118E, 0x8477, 0x1043, "(null)" },
    { 0x118E, 0x8650, 0x1043, "(null)" },
    { 0x118E, 0x098a, 0x10de, "(null)" },
    { 0x118E, 0x106f, 0x10de, "(null)" },
    { 0x118E, 0x284b, 0x1462, "(null)" },
    { 0x118E, 0x6265, 0x174b, "(null)" },
    { 0x118F, 0x0970, 0x10de, "(null)" },
    { 0x118F, 0x097f, 0x10de, "(null)" },
    { 0x1193, 0x068b, 0x1028, "(null)" },
    { 0x1193, 0x0790, 0x1028, "(null)" },
    { 0x1193, 0x079a, 0x1028, "(null)" },
    { 0x1194, 0x1085, 0x10de, "(null)" },
    { 0x1195, 0x068b, 0x1028, "(null)" },
    { 0x1195, 0x0790, 0x1028, "(null)" },
    { 0x1195, 0x079a, 0x1028, "(null)" },
    { 0x1198, 0x05aa, 0x1028, "(null)" },
    { 0x1198, 0x05ab, 0x1028, "(null)" },
    { 0x1198, 0x05ad, 0x1028, "(null)" },
    { 0x1198, 0x05ae, 0x1028, "(null)" },
    { 0x1198, 0x157d, 0x1043, "(null)" },
    { 0x1198, 0xa552, 0x1458, "(null)" },
    { 0x1198, 0xd001, 0x1458, "(null)" },
    { 0x1198, 0x1105, 0x1462, "(null)" },
    { 0x1198, 0x110f, 0x1462, "(null)" },
    { 0x1198, 0x1119, 0x1462, "(null)" },
    { 0x1198, 0x119a, 0x1462, "(null)" },
    { 0x1198, 0xaf18, 0x1462, "(null)" },
    { 0x1198, 0x0270, 0x1558, "(null)" },
    { 0x1198, 0x0376, 0x1558, "(null)" },
    { 0x1198, 0x0377, 0x1558, "(null)" },
    { 0x1198, 0x5281, 0x1558, "(null)" },
    { 0x1198, 0x7481, 0x1558, "(null)" },
    { 0x1199, 0x157d, 0x1043, "(null)" },
    { 0x1199, 0x1456, 0x1458, "(null)" },
    { 0x1199, 0xa552, 0x1458, "(null)" },
    { 0x1199, 0xb556, 0x1458, "(null)" },
    { 0x1199, 0xd001, 0x1458, "(null)" },
    { 0x1199, 0x10fd, 0x1462, "(null)" },
    { 0x1199, 0x1103, 0x1462, "(null)" },
    { 0x1199, 0x1106, 0x1462, "(null)" },
    { 0x1199, 0x1110, 0x1462, "(null)" },
    { 0x1199, 0x111a, 0x1462, "(null)" },
    { 0x1199, 0xaf18, 0x1462, "(null)" },
    { 0x1199, 0x1097, 0x152d, "(null)" },
    { 0x1199, 0x0376, 0x1558, "(null)" },
    { 0x1199, 0x5281, 0x1558, "(null)" },
    { 0x1199, 0x7481, 0x1558, "(null)" },
    { 0x1199, 0x6749, 0x1a58, "(null)" },
    { 0x119A, 0x05aa, 0x1028, "(null)" },
    { 0x119A, 0x05ab, 0x1028, "(null)" },
    { 0x119A, 0x05ad, 0x1028, "(null)" },
    { 0x119A, 0x05ae, 0x1028, "(null)" },
    { 0x119A, 0x1756, 0x1458, "(null)" },
    { 0x119A, 0xa552, 0x1458, "(null)" },
    { 0x119A, 0xb556, 0x1458, "(null)" },
    { 0x119A, 0xd001, 0x1458, "(null)" },
    { 0x119A, 0x1102, 0x1462, "(null)" },
    { 0x119A, 0x1104, 0x1462, "(null)" },
    { 0x119A, 0x0376, 0x1558, "(null)" },
    { 0x119A, 0x5281, 0x1558, "(null)" },
    { 0x119A, 0x7481, 0x1558, "(null)" },
    { 0x119D, 0x0120, 0x106b, "(null)" },
    { 0x119E, 0x0121, 0x106b, "(null)" },
    { 0x119F, 0x05aa, 0x1028, "(null)" },
    { 0x119F, 0x05ab, 0x1028, "(null)" },
    { 0x119F, 0x05ad, 0x1028, "(null)" },
    { 0x119F, 0x05ae, 0x1028, "(null)" },
    { 0x119F, 0x213e, 0x1043, "(null)" },
    { 0x119F, 0x21bb, 0x1043, "(null)" },
    { 0x119F, 0x1756, 0x1458, "(null)" },
    { 0x119F, 0x10ea, 0x1462, "(null)" },
    { 0x119F, 0x0270, 0x1558, "(null)" },
    { 0x119F, 0x0271, 0x1558, "(null)" },
    { 0x119F, 0x0376, 0x1558, "(null)" },
    { 0x119F, 0x0377, 0x1558, "(null)" },
    { 0x119F, 0x5106, 0x1558, "(null)" },
    { 0x119F, 0x7104, 0x1558, "(null)" },
    { 0x11A0, 0x0550, 0x1028, "(null)" },
    { 0x11A0, 0x0551, 0x1028, "(null)" },
    { 0x11A0, 0x057b, 0x1028, "(null)" },
    { 0x11A0, 0x0580, 0x1028, "(null)" },
    { 0x11A0, 0x10bc, 0x1462, "(null)" },
    { 0x11A0, 0x10be, 0x1462, "(null)" },
    { 0x11A0, 0xaf15, 0x1462, "(null)" },
    { 0x11A0, 0x0270, 0x1558, "(null)" },
    { 0x11A0, 0x0271, 0x1558, "(null)" },
    { 0x11A0, 0x0371, 0x1558, "(null)" },
    { 0x11A0, 0x0372, 0x1558, "(null)" },
    { 0x11A0, 0x5105, 0x1558, "(null)" },
    { 0x11A0, 0x7102, 0x1558, "(null)" },
    { 0x11A0, 0x0964, 0x196e, "(null)" },
    { 0x11A1, 0x10ad, 0x1043, "(null)" },
    { 0x11A1, 0x21ab, 0x1043, "(null)" },
    { 0x11A1, 0x10d9, 0x1462, "(null)" },
    { 0x11A1, 0xaf15, 0x1462, "(null)" },
    { 0x11A1, 0x0270, 0x1558, "(null)" },
    { 0x11A1, 0x0271, 0x1558, "(null)" },
    { 0x11A1, 0x0371, 0x1558, "(null)" },
    { 0x11A1, 0x5105, 0x1558, "(null)" },
    { 0x11A1, 0x7102, 0x1558, "(null)" },
    { 0x11A2, 0x010c, 0x106b, "(null)" },
    { 0x11A3, 0x010d, 0x106b, "(null)" },
    { 0x11A7, 0x10d9, 0x1462, "(null)" },
    { 0x11A7, 0xaf15, 0x1462, "(null)" },
    { 0x11A7, 0x5105, 0x1558, "(null)" },
    { 0x11A7, 0x7102, 0x1558, "(null)" },
    { 0x11B4, 0x1096, 0x103c, "(null)" },
    { 0x11B4, 0x1096, 0x10de, "(null)" },
    { 0x11B6, 0x05cd, 0x1028, "(null)" },
    { 0x11B6, 0x15cd, 0x1028, "(null)" },
    { 0x11B6, 0x1022, 0x103c, "(null)" },
    { 0x11B6, 0x190a, 0x103c, "(null)" },
    { 0x11B6, 0x197a, 0x103c, "(null)" },
    { 0x11B6, 0x2255, 0x103c, "(null)" },
    { 0x11B6, 0x2256, 0x103c, "(null)" },
    { 0x11B6, 0x10fc, 0x1462, "(null)" },
    { 0x11B6, 0x10fd, 0x1462, "(null)" },
    { 0x11B6, 0x1152, 0x1462, "(null)" },
    { 0x11B6, 0x118c, 0x1462, "(null)" },
    { 0x11B6, 0x5106, 0x1558, "(null)" },
    { 0x11B6, 0x5281, 0x1558, "(null)" },
    { 0x11B6, 0x7104, 0x1558, "(null)" },
    { 0x11B6, 0x7481, 0x1558, "(null)" },
    { 0x11B6, 0x7500, 0x1558, "(null)" },
    { 0x11B6, 0x7700, 0x1558, "(null)" },
    { 0x11B7, 0x05cd, 0x1028, "(null)" },
    { 0x11B7, 0x15cd, 0x1028, "(null)" },
    { 0x11B7, 0x1023, 0x103c, "(null)" },
    { 0x11B7, 0x190a, 0x103c, "(null)" },
    { 0x11B7, 0x197a, 0x103c, "(null)" },
    { 0x11B7, 0x2255, 0x103c, "(null)" },
    { 0x11B7, 0x2256, 0x103c, "(null)" },
    { 0x11B7, 0x1100, 0x1462, "(null)" },
    { 0x11B7, 0x1153, 0x1462, "(null)" },
    { 0x11B7, 0x118d, 0x1462, "(null)" },
    { 0x11B8, 0x05cd, 0x1028, "(null)" },
    { 0x11B8, 0x15cd, 0x1028, "(null)" },
    { 0x11B8, 0x190a, 0x103c, "(null)" },
    { 0x11B8, 0x197a, 0x103c, "(null)" },
    { 0x11B8, 0x2255, 0x103c, "(null)" },
    { 0x11B8, 0x2256, 0x103c, "(null)" },
    { 0x11B8, 0x0270, 0x1558, "(null)" },
    { 0x11B8, 0x0376, 0x1558, "(null)" },
    { 0x11B8, 0x7500, 0x1558, "(null)" },
    { 0x11B8, 0x7700, 0x1558, "(null)" },
    { 0x11BA, 0x0965, 0x103c, "(null)" },
    { 0x11BA, 0x0965, 0x10de, "(null)" },
    { 0x11BC, 0x053f, 0x1028, "(null)" },
    { 0x11BC, 0x153f, 0x1028, "(null)" },
    { 0x11BC, 0x176c, 0x103c, "(null)" },
    { 0x11BC, 0x1762, 0x10cf, "(null)" },
    { 0x11BC, 0x0270, 0x1558, "(null)" },
    { 0x11BC, 0x0371, 0x1558, "(null)" },
    { 0x11BC, 0x0376, 0x1558, "(null)" },
    { 0x11BD, 0x053f, 0x1028, "(null)" },
    { 0x11BD, 0x153f, 0x1028, "(null)" },
    { 0x11BD, 0x0951, 0x103c, "(null)" },
    { 0x11BD, 0x176c, 0x103c, "(null)" },
    { 0x11BD, 0x1761, 0x10cf, "(null)" },
    { 0x11BD, 0x10db, 0x1462, "(null)" },
    { 0x11BE, 0x053f, 0x1028, "(null)" },
    { 0x11BE, 0x153f, 0x1028, "(null)" },
    { 0x11BE, 0x0950, 0x103c, "(null)" },
    { 0x11BE, 0x176c, 0x103c, "(null)" },
    { 0x11BE, 0x1760, 0x10cf, "(null)" },
    { 0x11BE, 0x10db, 0x1462, "(null)" },
    { 0x11BE, 0x10eb, 0x1462, "(null)" },
    { 0x11BE, 0x5105, 0x1558, "(null)" },
    { 0x11BE, 0x5106, 0x1558, "(null)" },
    { 0x11BE, 0x7102, 0x1558, "(null)" },
    { 0x11BE, 0x7104, 0x1558, "(null)" },
    { 0x11BF, 0x100a, 0x10de, "(null)" },
    { 0x11BF, 0x100d, 0x10de, "(null)" },
    { 0x11C0, 0x068b, 0x1028, "(null)" },
    { 0x11C0, 0x0790, 0x1028, "(null)" },
    { 0x11C0, 0x079a, 0x1028, "(null)" },
    { 0x11C2, 0x068b, 0x1028, "(null)" },
    { 0x11C2, 0x0790, 0x1028, "(null)" },
    { 0x11C2, 0x079a, 0x1028, "(null)" },
    { 0x11C3, 0x068b, 0x1028, "(null)" },
    { 0x11C3, 0x0790, 0x1028, "(null)" },
    { 0x11C3, 0x079a, 0x1028, "(null)" },
    { 0x11C4, 0x1029, 0x10de, "(null)" },
    { 0x11C4, 0x1645, 0x174b, "(null)" },
    { 0x11C4, 0x90cc, 0x1b0a, "(null)" },
    { 0x11C6, 0x068b, 0x1028, "(null)" },
    { 0x11C6, 0x0790, 0x1028, "(null)" },
    { 0x11C6, 0x079a, 0x1028, "(null)" },
    { 0x11C6, 0x1016, 0x10de, "(null)" },
    { 0x11C6, 0x0995, 0x144d, "(null)" },
    { 0x11C8, 0x068b, 0x1028, "(null)" },
    { 0x11C8, 0x0790, 0x1028, "(null)" },
    { 0x11C8, 0x079a, 0x1028, "(null)" },
    { 0x11E0, 0x05aa, 0x1028, "(null)" },
    { 0x11E0, 0x05ab, 0x1028, "(null)" },
    { 0x11E0, 0x05ad, 0x1028, "(null)" },
    { 0x11E0, 0x05ae, 0x1028, "(null)" },
    { 0x11E0, 0x213e, 0x1043, "(null)" },
    { 0x11E0, 0x21bb, 0x1043, "(null)" },
    { 0x11E0, 0xfa76, 0x1179, "(null)" },
    { 0x11E0, 0xfa77, 0x1179, "(null)" },
    { 0x11E0, 0x8801, 0x13fe, "(null)" },
    { 0x11E0, 0x2552, 0x1458, "(null)" },
    { 0x11E0, 0xa552, 0x1458, "(null)" },
    { 0x11E0, 0x10e8, 0x1462, "(null)" },
    { 0x11E0, 0x10ed, 0x1462, "(null)" },
    { 0x11E0, 0x0270, 0x1558, "(null)" },
    { 0x11E0, 0x0271, 0x1558, "(null)" },
    { 0x11E0, 0x0376, 0x1558, "(null)" },
    { 0x11E0, 0x5106, 0x1558, "(null)" },
    { 0x11E0, 0x7104, 0x1558, "(null)" },
    { 0x11E0, 0x1702, 0x172f, "(null)" },
    { 0x11E1, 0x05a9, 0x1028, "(null)" },
    { 0x11E1, 0x05aa, 0x1028, "(null)" },
    { 0x11E1, 0x05ab, 0x1028, "(null)" },
    { 0x11E1, 0x05ac, 0x1028, "(null)" },
    { 0x11E1, 0x05ad, 0x1028, "(null)" },
    { 0x11E1, 0x05ae, 0x1028, "(null)" },
    { 0x11E1, 0x1756, 0x1458, "(null)" },
    { 0x11E1, 0x2552, 0x1458, "(null)" },
    { 0x11E1, 0xa552, 0x1458, "(null)" },
    { 0x11E1, 0x10ee, 0x1462, "(null)" },
    { 0x11E1, 0x0376, 0x1558, "(null)" },
    { 0x11E1, 0x5106, 0x1558, "(null)" },
    { 0x11E1, 0x7104, 0x1558, "(null)" },
    { 0x11E1, 0x1701, 0x172f, "(null)" },
    { 0x11E2, 0x0787, 0x1025, "(null)" },
    { 0x11E2, 0x05a9, 0x1028, "(null)" },
    { 0x11E2, 0x05ac, 0x1028, "(null)" },
    { 0x11E2, 0x119d, 0x1043, "(null)" },
    { 0x11E2, 0x1552, 0x1458, "(null)" },
    { 0x11E2, 0x2452, 0x1458, "(null)" },
    { 0x11E2, 0x3456, 0x1458, "(null)" },
    { 0x11E2, 0xa456, 0x1458, "(null)" },
    { 0x11E2, 0xb552, 0x1458, "(null)" },
    { 0x11E2, 0x10e0, 0x1462, "(null)" },
    { 0x11E2, 0x10e1, 0x1462, "(null)" },
    { 0x11E2, 0x0230, 0x1558, "(null)" },
    { 0x11E2, 0x3537, 0x1558, "(null)" },
    { 0x11E2, 0xb215, 0x19da, "(null)" },
    { 0x11E2, 0x6746, 0x1a58, "(null)" },
    { 0x11E2, 0x6748, 0x1a58, "(null)" },
    { 0x11E2, 0xa748, 0x1a58, "(null)" },
    { 0x11E2, 0x2007, 0x1b61, "(null)" },
    { 0x11E3, 0x073f, 0x1025, "(null)" },
    { 0x11E3, 0x0781, 0x1025, "(null)" },
    { 0x11E3, 0x0787, 0x1025, "(null)" },
    { 0x11E3, 0x082e, 0x1025, "(null)" },
    { 0x11E3, 0x14ad, 0x1043, "(null)" },
    { 0x11E3, 0x22ba, 0x1043, "(null)" },
    { 0x11E3, 0x22ca, 0x1043, "(null)" },
    { 0x11E3, 0x3456, 0x1458, "(null)" },
    { 0x11E3, 0xa456, 0x1458, "(null)" },
    { 0x11E3, 0x10e3, 0x1462, "(null)" },
    { 0x11E3, 0x10fe, 0x1462, "(null)" },
    { 0x11E3, 0x10ff, 0x1462, "(null)" },
    { 0x11E3, 0x1059, 0x152d, "(null)" },
    { 0x11E3, 0x3505, 0x1558, "(null)" },
    { 0x11E3, 0x3683, 0x17aa, "(null)" },
    { 0x11FA, 0x079c, 0x103c, "(null)" },
    { 0x11FA, 0x097c, 0x103c, "(null)" },
    { 0x11FA, 0x097c, 0x10de, "(null)" },
    { 0x11FC, 0x05cc, 0x1028, "(null)" },
    { 0x11FC, 0x15cc, 0x1028, "(null)" },
    { 0x11FC, 0x1028, 0x103c, "(null)" },
    { 0x11FC, 0x1909, 0x103c, "(null)" },
    { 0x11FC, 0x197b, 0x103c, "(null)" },
    { 0x11FC, 0x2253, 0x103c, "(null)" },
    { 0x11FC, 0x2254, 0x103c, "(null)" },
    { 0x11FC, 0x17ef, 0x10cf, "(null)" },
    { 0x11FC, 0x0001, 0x1179, "(null)" },
    { 0x11FC, 0x10fb, 0x1462, "(null)" },
    { 0x11FC, 0x111d, 0x1462, "(null)" },
    { 0x11FC, 0x111e, 0x1462, "(null)" },
    { 0x11FC, 0x1708, 0x172f, "(null)" },
    { 0x11FC, 0x2210, 0x17aa, "(null)" },
    { 0x11FC, 0x2211, 0x17aa, "(null)" },
    { 0x11FC, 0x221a, 0x17aa, "(null)" },
    { 0x11FC, 0x221e, 0x17aa, "(null)" },
    { 0x1200, 0x838b, 0x1043, "(null)" },
    { 0x1200, 0x83ac, 0x1043, "(null)" },
    { 0x1200, 0xc000, 0x1458, "(null)" },
    { 0x1201, 0xc000, 0x1458, "(null)" },
    { 0x1205, 0xc000, 0x1458, "(null)" },
    { 0x1206, 0x0958, 0x10de, "(null)" },
    { 0x1207, 0x0645, 0x174b, "(null)" },
    { 0x1210, 0x10bd, 0x1462, "(null)" },
    { 0x1211, 0x048f, 0x1028, "(null)" },
    { 0x1211, 0x0490, 0x1028, "(null)" },
    { 0x1211, 0x04ba, 0x1028, "(null)" },
    { 0x1211, 0x10a9, 0x1462, "(null)" },
    { 0x1211, 0x0270, 0x1558, "(null)" },
    { 0x1211, 0x0271, 0x1558, "(null)" },
    { 0x1211, 0x5102, 0x1558, "(null)" },
    { 0x1211, 0x7100, 0x1558, "(null)" },
    { 0x1211, 0x7101, 0x1558, "(null)" },
    { 0x1211, 0x7200, 0x1558, "(null)" },
    { 0x1212, 0x0550, 0x1028, "(null)" },
    { 0x1212, 0x0551, 0x1028, "(null)" },
    { 0x1212, 0x057b, 0x1028, "(null)" },
    { 0x1212, 0x0580, 0x1028, "(null)" },
    { 0x1212, 0xc0d0, 0x144d, "(null)" },
    { 0x1212, 0x10cb, 0x1462, "(null)" },
    { 0x1212, 0x0270, 0x1558, "(null)" },
    { 0x1212, 0x0271, 0x1558, "(null)" },
    { 0x1212, 0x5105, 0x1558, "(null)" },
    { 0x1212, 0x7102, 0x1558, "(null)" },
    { 0x1213, 0x2119, 0x1043, "(null)" },
    { 0x1213, 0x2120, 0x1043, "(null)" },
    { 0x1213, 0xfb12, 0x1179, "(null)" },
    { 0x1213, 0xfb18, 0x1179, "(null)" },
    { 0x1213, 0xfb1a, 0x1179, "(null)" },
    { 0x1213, 0x10cb, 0x1462, "(null)" },
    { 0x1213, 0xaf15, 0x1462, "(null)" },
    { 0x1213, 0x0371, 0x1558, "(null)" },
    { 0x1213, 0x5105, 0x1558, "(null)" },
    { 0x1213, 0x7102, 0x1558, "(null)" },
    { 0x1213, 0x8000, 0x1558, "(null)" },
    { 0x1241, 0x091d, 0x10de, "(null)" },
    { 0x1243, 0x1012, 0x1019, "(null)" },
    { 0x1243, 0x8508, 0x1043, "(null)" },
    { 0x1243, 0x2315, 0x1462, "(null)" },
    { 0x1243, 0x2316, 0x1462, "(null)" },
    { 0x1243, 0x2317, 0x1462, "(null)" },
    { 0x1243, 0x2318, 0x1462, "(null)" },
    { 0x1243, 0x3a28, 0x1642, "(null)" },
    { 0x1243, 0x5178, 0x174b, "(null)" },
    { 0x1243, 0x6178, 0x174b, "(null)" },
    { 0x1244, 0x838c, 0x1043, "(null)" },
    { 0x1244, 0xc000, 0x1458, "(null)" },
    { 0x1244, 0x2612, 0x1462, "(null)" },
    { 0x1244, 0x5194, 0x174b, "(null)" },
    { 0x1244, 0x90a2, 0x1b0a, "(null)" },
    { 0x1245, 0xc000, 0x1458, "(null)" },
    { 0x1246, 0x0570, 0x1028, "(null)" },
    { 0x1246, 0x0571, 0x1028, "(null)" },
    { 0x1247, 0x1752, 0x1043, "(null)" },
    { 0x1247, 0x2050, 0x1043, "(null)" },
    { 0x1247, 0x2051, 0x1043, "(null)" },
    { 0x1247, 0x212a, 0x1043, "(null)" },
    { 0x1247, 0x212b, 0x1043, "(null)" },
    { 0x1247, 0x212c, 0x1043, "(null)" },
    { 0x1247, 0x1532, 0x1458, "(null)" },
    { 0x1247, 0x6744, 0x1458, "(null)" },
    { 0x1248, 0x10e7, 0x17c0, "(null)" },
    { 0x1248, 0x10e8, 0x17c0, "(null)" },
    { 0x1248, 0x10ea, 0x17c0, "(null)" },
    { 0x1248, 0x0890, 0x1854, "(null)" },
    { 0x1248, 0x0891, 0x1854, "(null)" },
    { 0x1248, 0x1795, 0x1854, "(null)" },
    { 0x1248, 0x1796, 0x1854, "(null)" },
    { 0x1248, 0x3005, 0x1854, "(null)" },
    { 0x124B, 0x8540, 0x1043, "(null)" },
    { 0x124B, 0x2319, 0x1462, "(null)" },
    { 0x124B, 0x231a, 0x1462, "(null)" },
    { 0x124B, 0x231b, 0x1462, "(null)" },
    { 0x124B, 0x0640, 0x174b, "(null)" },
    { 0x124D, 0x0491, 0x1028, "(null)" },
    { 0x124D, 0x0570, 0x1028, "(null)" },
    { 0x124D, 0x0571, 0x1028, "(null)" },
    { 0x124D, 0x108d, 0x1462, "(null)" },
    { 0x124D, 0x10cc, 0x1462, "(null)" },
    { 0x124D, 0x1248, 0x1462, "(null)" },
    { 0x1251, 0x048f, 0x1028, "(null)" },
    { 0x1251, 0x0490, 0x1028, "(null)" },
    { 0x1251, 0x04ba, 0x1028, "(null)" },
    { 0x1251, 0x13b7, 0x1043, "(null)" },
    { 0x1251, 0x204a, 0x1043, "(null)" },
    { 0x1251, 0x204b, 0x1043, "(null)" },
    { 0x1251, 0x2100, 0x1043, "(null)" },
    { 0x1251, 0x84ba, 0x1043, "(null)" },
    { 0x1251, 0xfc00, 0x1179, "(null)" },
    { 0x1251, 0xfc01, 0x1179, "(null)" },
    { 0x1251, 0xfc05, 0x1179, "(null)" },
    { 0x1251, 0x10a9, 0x1462, "(null)" },
    { 0x1251, 0x5102, 0x1558, "(null)" },
    { 0x1251, 0x7100, 0x1558, "(null)" },
    { 0x1251, 0x7101, 0x1558, "(null)" },
    { 0x1251, 0x7200, 0x1558, "(null)" },
    { 0x1251, 0x8000, 0x1558, "(null)" },
    { 0x1251, 0x1043, 0x84ba, "(null)" },
    { 0x1280, 0x1018, 0x1019, "(null)" },
    { 0x1280, 0x1019, 0x1019, "(null)" },
    { 0x1280, 0x1020, 0x1019, "(null)" },
    { 0x1280, 0x1891, 0x10cf, "(null)" },
    { 0x1280, 0x1032, 0x10de, "(null)" },
    { 0x1280, 0x80a2, 0x144d, "(null)" },
    { 0x1280, 0x80a4, 0x144d, "(null)" },
    { 0x1280, 0x2902, 0x1462, "(null)" },
    { 0x1280, 0x2920, 0x1462, "(null)" },
    { 0x1280, 0x2922, 0x1462, "(null)" },
    { 0x1280, 0x2924, 0x1462, "(null)" },
    { 0x1280, 0x3d06, 0x1642, "(null)" },
    { 0x1281, 0x2929, 0x1462, "(null)" },
    { 0x1281, 0x3261, 0x174b, "(null)" },
    { 0x1281, 0x326a, 0x174b, "(null)" },
    { 0x1286, 0x1025, 0x1019, "(null)" },
    { 0x1286, 0x8641, 0x1043, "(null)" },
    { 0x1286, 0x1087, 0x10de, "(null)" },
    { 0x1286, 0x80a6, 0x144d, "(null)" },
    { 0x1286, 0x80a8, 0x144d, "(null)" },
    { 0x1286, 0x2927, 0x1462, "(null)" },
    { 0x1286, 0x2928, 0x1462, "(null)" },
    { 0x1286, 0x308a, 0x174b, "(null)" },
    { 0x1287, 0x1034, 0x1019, "(null)" },
    { 0x1287, 0x1083, 0x1028, "(null)" },
    { 0x1287, 0x108b, 0x1028, "(null)" },
    { 0x1287, 0x3382, 0x1028, "(null)" },
    { 0x1287, 0x1083, 0x103c, "(null)" },
    { 0x1287, 0x2b4e, 0x103c, "(null)" },
    { 0x1287, 0x82e9, 0x103c, "(null)" },
    { 0x1287, 0x0862, 0x1043, "(null)" },
    { 0x1287, 0x884b, 0x1043, "(null)" },
    { 0x1287, 0x1a01, 0x109f, "(null)" },
    { 0x1287, 0x1a02, 0x109f, "(null)" },
    { 0x1287, 0x80aa, 0x144d, "(null)" },
    { 0x1287, 0x80ac, 0x144d, "(null)" },
    { 0x1287, 0x292a, 0x1462, "(null)" },
    { 0x1287, 0x292b, 0x1462, "(null)" },
    { 0x1287, 0x3131, 0x1462, "(null)" },
    { 0x1287, 0x3380, 0x1462, "(null)" },
    { 0x1287, 0x3383, 0x1462, "(null)" },
    { 0x1287, 0x8a9f, 0x1462, "(null)" },
    { 0x1287, 0x1586, 0x1642, "(null)" },
    { 0x1287, 0x1706, 0x1642, "(null)" },
    { 0x1287, 0x1868, 0x1642, "(null)" },
    { 0x1287, 0x3e56, 0x1642, "(null)" },
    { 0x1287, 0x3f86, 0x1642, "(null)" },
    { 0x1287, 0x324a, 0x174b, "(null)" },
    { 0x1287, 0x326c, 0x174b, "(null)" },
    { 0x1287, 0xa324, 0x174b, "(null)" },
    { 0x1287, 0xb324, 0x174b, "(null)" },
    { 0x1287, 0xffa2, 0x19da, "(null)" },
    { 0x1287, 0x90f5, 0x1b0a, "(null)" },
    { 0x1287, 0x90f6, 0x1b0a, "(null)" },
    { 0x1288, 0x207b, 0x1043, "(null)" },
    { 0x1288, 0x8670, 0x1043, "(null)" },
    { 0x1288, 0x3130, 0x1462, "(null)" },
    { 0x1288, 0x3133, 0x1462, "(null)" },
    { 0x1288, 0x3381, 0x1462, "(null)" },
    { 0x1288, 0x1610, 0x1642, "(null)" },
    { 0x1288, 0x1706, 0x1642, "(null)" },
    { 0x1288, 0x3e56, 0x1642, "(null)" },
    { 0x1288, 0x326b, 0x174b, "(null)" },
    { 0x1288, 0x5326, 0x174b, "(null)" },
    { 0x1288, 0x6326, 0x174b, "(null)" },
    { 0x1288, 0xb324, 0x174b, "(null)" },
    { 0x1289, 0x206b, 0x1043, "(null)" },
    { 0x1289, 0x866f, 0x1043, "(null)" },
    { 0x1289, 0x80a9, 0x144d, "(null)" },
    { 0x128B, 0x0790, 0x1028, "(null)" },
    { 0x128B, 0x118b, 0x1028, "(null)" },
    { 0x128B, 0x8576, 0x1043, "(null)" },
    { 0x128B, 0x85f7, 0x1043, "(null)" },
    { 0x128B, 0x95e7, 0x1043, "(null)" },
    { 0x128B, 0x95f7, 0x1043, "(null)" },
    { 0x1290, 0x193e, 0x103c, "(null)" },
    { 0x1290, 0x2149, 0x103c, "(null)" },
    { 0x1290, 0x2afa, 0x103c, "(null)" },
    { 0x1290, 0x13ad, 0x1043, "(null)" },
    { 0x1290, 0x13cd, 0x1043, "(null)" },
    { 0x1290, 0x403b, 0x1071, "(null)" },
    { 0x1290, 0x403c, 0x1071, "(null)" },
    { 0x1290, 0x0011, 0x1179, "(null)" },
    { 0x1290, 0x0012, 0x1179, "(null)" },
    { 0x1290, 0x0013, 0x1179, "(null)" },
    { 0x1290, 0x10b8, 0x1462, "(null)" },
    { 0x1290, 0x0076, 0x14c0, "(null)" },
    { 0x1290, 0x0077, 0x14c0, "(null)" },
    { 0x1290, 0x0084, 0x14c0, "(null)" },
    { 0x1290, 0xc917, 0x16f8, "(null)" },
    { 0x1290, 0x1707, 0x172f, "(null)" },
    { 0x1290, 0x1709, 0x172f, "(null)" },
    { 0x1290, 0x220d, 0x17aa, "(null)" },
    { 0x1290, 0x220f, 0x17aa, "(null)" },
    { 0x1290, 0x2211, 0x17aa, "(null)" },
    { 0x1290, 0x221d, 0x17aa, "(null)" },
    { 0x1290, 0x221e, 0x17aa, "(null)" },
    { 0x1290, 0x221f, 0x17aa, "(null)" },
    { 0x1290, 0x3800, 0x17aa, "(null)" },
    { 0x1290, 0x5014, 0x17aa, "(null)" },
    { 0x1290, 0x5026, 0x17aa, "(null)" },
    { 0x1290, 0x5027, 0x17aa, "(null)" },
    { 0x1290, 0x5028, 0x17aa, "(null)" },
    { 0x1290, 0xa210, 0x1b72, "(null)" },
    { 0x1291, 0x081d, 0x1025, "(null)" },
    { 0x1291, 0x90b7, 0x104d, "(null)" },
    { 0x1291, 0x90c3, 0x104d, "(null)" },
    { 0x1291, 0x3356, 0x17aa, "(null)" },
    { 0x1292, 0x999b, 0x1019, "(null)" },
    { 0x1292, 0x999c, 0x1019, "(null)" },
    { 0x1292, 0x999f, 0x1019, "(null)" },
    { 0x1292, 0x99a2, 0x1019, "(null)" },
    { 0x1292, 0x99a3, 0x1019, "(null)" },
    { 0x1292, 0x073f, 0x1025, "(null)" },
    { 0x1292, 0x0776, 0x1025, "(null)" },
    { 0x1292, 0x0781, 0x1025, "(null)" },
    { 0x1292, 0x0798, 0x1025, "(null)" },
    { 0x1292, 0x0799, 0x1025, "(null)" },
    { 0x1292, 0x079b, 0x1025, "(null)" },
    { 0x1292, 0x079c, 0x1025, "(null)" },
    { 0x1292, 0x0833, 0x1025, "(null)" },
    { 0x1292, 0x0836, 0x1025, "(null)" },
    { 0x1292, 0x0842, 0x1025, "(null)" },
    { 0x1292, 0x05f5, 0x1028, "(null)" },
    { 0x1292, 0x0607, 0x1028, "(null)" },
    { 0x1292, 0x0616, 0x1028, "(null)" },
    { 0x1292, 0x0638, 0x1028, "(null)" },
    { 0x1292, 0x1961, 0x103c, "(null)" },
    { 0x1292, 0x1963, 0x103c, "(null)" },
    { 0x1292, 0x1964, 0x103c, "(null)" },
    { 0x1292, 0x1966, 0x103c, "(null)" },
    { 0x1292, 0x198c, 0x103c, "(null)" },
    { 0x1292, 0x198d, 0x103c, "(null)" },
    { 0x1292, 0x2165, 0x103c, "(null)" },
    { 0x1292, 0x2166, 0x103c, "(null)" },
    { 0x1292, 0x219a, 0x103c, "(null)" },
    { 0x1292, 0x219c, 0x103c, "(null)" },
    { 0x1292, 0x21b0, 0x103c, "(null)" },
    { 0x1292, 0x21b1, 0x103c, "(null)" },
    { 0x1292, 0x21d9, 0x103c, "(null)" },
    { 0x1292, 0x21da, 0x103c, "(null)" },
    { 0x1292, 0x10cc, 0x1043, "(null)" },
    { 0x1292, 0x122d, 0x1043, "(null)" },
    { 0x1292, 0x123d, 0x1043, "(null)" },
    { 0x1292, 0x124d, 0x1043, "(null)" },
    { 0x1292, 0x126d, 0x1043, "(null)" },
    { 0x1292, 0x130d, 0x1043, "(null)" },
    { 0x1292, 0x131d, 0x1043, "(null)" },
    { 0x1292, 0x139d, 0x1043, "(null)" },
    { 0x1292, 0x13fd, 0x1043, "(null)" },
    { 0x1292, 0x14fd, 0x1043, "(null)" },
    { 0x1292, 0x2130, 0x1043, "(null)" },
    { 0x1292, 0x21ba, 0x1043, "(null)" },
    { 0x1292, 0x21fa, 0x1043, "(null)" },
    { 0x1292, 0x220a, 0x1043, "(null)" },
    { 0x1292, 0x8579, 0x1043, "(null)" },
    { 0x1292, 0x85a1, 0x1043, "(null)" },
    { 0x1292, 0x90b8, 0x104d, "(null)" },
    { 0x1292, 0x90be, 0x104d, "(null)" },
    { 0x1292, 0xfa01, 0x1179, "(null)" },
    { 0x1292, 0xfa02, 0x1179, "(null)" },
    { 0x1292, 0xfa03, 0x1179, "(null)" },
    { 0x1292, 0xfa05, 0x1179, "(null)" },
    { 0x1292, 0xfa11, 0x1179, "(null)" },
    { 0x1292, 0xfa13, 0x1179, "(null)" },
    { 0x1292, 0xfa18, 0x1179, "(null)" },
    { 0x1292, 0xfa19, 0x1179, "(null)" },
    { 0x1292, 0xfa21, 0x1179, "(null)" },
    { 0x1292, 0xfa23, 0x1179, "(null)" },
    { 0x1292, 0xfa2a, 0x1179, "(null)" },
    { 0x1292, 0xfa32, 0x1179, "(null)" },
    { 0x1292, 0xfa33, 0x1179, "(null)" },
    { 0x1292, 0xfa36, 0x1179, "(null)" },
    { 0x1292, 0xfa38, 0x1179, "(null)" },
    { 0x1292, 0xfa42, 0x1179, "(null)" },
    { 0x1292, 0xfa43, 0x1179, "(null)" },
    { 0x1292, 0xfa45, 0x1179, "(null)" },
    { 0x1292, 0xfa47, 0x1179, "(null)" },
    { 0x1292, 0xfa49, 0x1179, "(null)" },
    { 0x1292, 0xfa58, 0x1179, "(null)" },
    { 0x1292, 0xfa59, 0x1179, "(null)" },
    { 0x1292, 0xfa64, 0x1179, "(null)" },
    { 0x1292, 0xfa78, 0x1179, "(null)" },
    { 0x1292, 0xfa79, 0x1179, "(null)" },
    { 0x1292, 0xfa88, 0x1179, "(null)" },
    { 0x1292, 0xfa89, 0x1179, "(null)" },
    { 0x1292, 0xfac1, 0x1179, "(null)" },
    { 0x1292, 0xfad1, 0x1179, "(null)" },
    { 0x1292, 0xc709, 0x144d, "(null)" },
    { 0x1292, 0x3552, 0x1458, "(null)" },
    { 0x1292, 0x10e9, 0x1462, "(null)" },
    { 0x1292, 0xaa33, 0x1462, "(null)" },
    { 0x1292, 0xaa73, 0x1462, "(null)" },
    { 0x1292, 0xaa89, 0x1462, "(null)" },
    { 0x1292, 0xaa8a, 0x1462, "(null)" },
    { 0x1292, 0xaaa1, 0x1462, "(null)" },
    { 0x1292, 0xaaa4, 0x1462, "(null)" },
    { 0x1292, 0xac11, 0x1462, "(null)" },
    { 0x1292, 0xac14, 0x1462, "(null)" },
    { 0x1292, 0xac7c, 0x1462, "(null)" },
    { 0x1292, 0xac91, 0x1462, "(null)" },
    { 0x1292, 0xac94, 0x1462, "(null)" },
    { 0x1292, 0xac95, 0x1462, "(null)" },
    { 0x1292, 0xacb1, 0x1462, "(null)" },
    { 0x1292, 0xae61, 0x1462, "(null)" },
    { 0x1292, 0xae62, 0x1462, "(null)" },
    { 0x1292, 0xae63, 0x1462, "(null)" },
    { 0x1292, 0xae64, 0x1462, "(null)" },
    { 0x1292, 0xaf11, 0x1462, "(null)" },
    { 0x1292, 0xaf13, 0x1462, "(null)" },
    { 0x1292, 0xaf14, 0x1462, "(null)" },
    { 0x1292, 0xaf16, 0x1462, "(null)" },
    { 0x1292, 0xaf17, 0x1462, "(null)" },
    { 0x1292, 0x0063, 0x14c0, "(null)" },
    { 0x1292, 0x0078, 0x14c0, "(null)" },
    { 0x1292, 0x1004, 0x152d, "(null)" },
    { 0x1292, 0x1008, 0x152d, "(null)" },
    { 0x1292, 0x1054, 0x152d, "(null)" },
    { 0x1292, 0x1060, 0x152d, "(null)" },
    { 0x1292, 0x1061, 0x152d, "(null)" },
    { 0x1292, 0x1077, 0x152d, "(null)" },
    { 0x1292, 0x5082, 0x1558, "(null)" },
    { 0x1292, 0x6500, 0x1558, "(null)" },
    { 0x1292, 0x6565, 0x1558, "(null)" },
    { 0x1292, 0x3675, 0x17aa, "(null)" },
    { 0x1292, 0x367c, 0x17aa, "(null)" },
    { 0x1292, 0x3684, 0x17aa, "(null)" },
    { 0x1292, 0x3801, 0x17aa, "(null)" },
    { 0x1292, 0x3802, 0x17aa, "(null)" },
    { 0x1292, 0x3805, 0x17aa, "(null)" },
    { 0x1292, 0x3806, 0x17aa, "(null)" },
    { 0x1292, 0x3809, 0x17aa, "(null)" },
    { 0x1292, 0x380a, 0x17aa, "(null)" },
    { 0x1292, 0x3904, 0x17aa, "(null)" },
    { 0x1292, 0x3912, 0x17aa, "(null)" },
    { 0x1292, 0x5003, 0x17aa, "(null)" },
    { 0x1292, 0x5007, 0x17aa, "(null)" },
    { 0x1292, 0x5014, 0x17aa, "(null)" },
    { 0x1292, 0x5019, 0x17aa, "(null)" },
    { 0x1292, 0x501a, 0x17aa, "(null)" },
    { 0x1292, 0x5023, 0x17aa, "(null)" },
    { 0x1292, 0x502a, 0x17aa, "(null)" },
    { 0x1292, 0x502f, 0x17aa, "(null)" },
    { 0x1292, 0x503e, 0x17aa, "(null)" },
    { 0x1292, 0x740a, 0x17aa, "(null)" },
    { 0x1292, 0x10f5, 0x17c0, "(null)" },
    { 0x1292, 0x0193, 0x1854, "(null)" },
    { 0x1292, 0x0208, 0x1854, "(null)" },
    { 0x1292, 0x1050, 0x1854, "(null)" },
    { 0x1292, 0x20dc, 0x1b0a, "(null)" },
    { 0x1292, 0x20dd, 0x1b0a, "(null)" },
    { 0x1292, 0x2106, 0x1b0a, "(null)" },
    { 0x1292, 0x2109, 0x1b0a, "(null)" },
    { 0x1292, 0x210e, 0x1b0a, "(null)" },
    { 0x1292, 0x2202, 0x1b0a, "(null)" },
    { 0x1292, 0x2222, 0x1b0a, "(null)" },
    { 0x1293, 0x1000, 0x152d, "(null)" },
    { 0x1293, 0x5540, 0x1b50, "(null)" },
    { 0x1295, 0x2b0d, 0x103c, "(null)" },
    { 0x1295, 0x2b0f, 0x103c, "(null)" },
    { 0x1295, 0x2b20, 0x103c, "(null)" },
    { 0x1295, 0x2b21, 0x103c, "(null)" },
    { 0x1295, 0x367a, 0x17aa, "(null)" },
    { 0x1295, 0x367c, 0x17aa, "(null)" },
    { 0x1296, 0xc737, 0x144d, "(null)" },
    { 0x1296, 0x2109, 0x1b0a, "(null)" },
    { 0x1296, 0x2222, 0x1b0a, "(null)" },
    { 0x1298, 0x124d, 0x1043, "(null)" },
    { 0x1298, 0x21fa, 0x1043, "(null)" },
    { 0x1299, 0x093c, 0x1025, "(null)" },
    { 0x1299, 0x0945, 0x1025, "(null)" },
    { 0x1299, 0x096b, 0x1025, "(null)" },
    { 0x1299, 0x0971, 0x1025, "(null)" },
    { 0x1299, 0x0974, 0x1025, "(null)" },
    { 0x1299, 0x0977, 0x1025, "(null)" },
    { 0x1299, 0x0985, 0x1025, "(null)" },
    { 0x1299, 0x0988, 0x1025, "(null)" },
    { 0x1299, 0x098b, 0x1025, "(null)" },
    { 0x1299, 0x098f, 0x1025, "(null)" },
    { 0x1299, 0x0992, 0x1025, "(null)" },
    { 0x1299, 0x099a, 0x1025, "(null)" },
    { 0x1299, 0x099f, 0x1025, "(null)" },
    { 0x1299, 0x100d, 0x1025, "(null)" },
    { 0x1299, 0x101a, 0x1025, "(null)" },
    { 0x1299, 0x1025, 0x1025, "(null)" },
    { 0x1299, 0x1035, 0x1025, "(null)" },
    { 0x1299, 0x103e, 0x1025, "(null)" },
    { 0x1299, 0x1040, 0x1025, "(null)" },
    { 0x1299, 0x1042, 0x1025, "(null)" },
    { 0x1299, 0x1045, 0x1025, "(null)" },
    { 0x1299, 0x107f, 0x1025, "(null)" },
    { 0x1299, 0x0652, 0x1028, "(null)" },
    { 0x1299, 0x0653, 0x1028, "(null)" },
    { 0x1299, 0x0655, 0x1028, "(null)" },
    { 0x1299, 0x0656, 0x1028, "(null)" },
    { 0x1299, 0x065e, 0x1028, "(null)" },
    { 0x1299, 0x0662, 0x1028, "(null)" },
    { 0x1299, 0x06ad, 0x1028, "(null)" },
    { 0x1299, 0x06ae, 0x1028, "(null)" },
    { 0x1299, 0x06af, 0x1028, "(null)" },
    { 0x1299, 0x06b0, 0x1028, "(null)" },
    { 0x1299, 0x06c0, 0x1028, "(null)" },
    { 0x1299, 0x06c1, 0x1028, "(null)" },
    { 0x1299, 0x06f0, 0x1028, "(null)" },
    { 0x1299, 0x06f1, 0x1028, "(null)" },
    { 0x1299, 0x06f2, 0x1028, "(null)" },
    { 0x1299, 0x06f3, 0x1028, "(null)" },
    { 0x1299, 0x100e, 0x1043, "(null)" },
    { 0x1299, 0x1010, 0x1043, "(null)" },
    { 0x1299, 0x102e, 0x1043, "(null)" },
    { 0x1299, 0x103e, 0x1043, "(null)" },
    { 0x1299, 0x104e, 0x1043, "(null)" },
    { 0x1299, 0x105e, 0x1043, "(null)" },
    { 0x1299, 0x16dd, 0x1043, "(null)" },
    { 0x1299, 0x176d, 0x1043, "(null)" },
    { 0x1299, 0x179d, 0x1043, "(null)" },
    { 0x1299, 0x18d0, 0x1043, "(null)" },
    { 0x1299, 0x1a6d, 0x1043, "(null)" },
    { 0x1299, 0x1a7d, 0x1043, "(null)" },
    { 0x1299, 0x1add, 0x1043, "(null)" },
    { 0x1299, 0x1aed, 0x1043, "(null)" },
    { 0x1299, 0x1bad, 0x1043, "(null)" },
    { 0x1299, 0x232a, 0x1043, "(null)" },
    { 0x1299, 0x23aa, 0x1043, "(null)" },
    { 0x1299, 0x23da, 0x1043, "(null)" },
    { 0x1299, 0x23ea, 0x1043, "(null)" },
    { 0x1299, 0x23fa, 0x1043, "(null)" },
    { 0x1299, 0x241a, 0x1043, "(null)" },
    { 0x1299, 0x242a, 0x1043, "(null)" },
    { 0x1299, 0x244a, 0x1043, "(null)" },
    { 0x1299, 0x245a, 0x1043, "(null)" },
    { 0x1299, 0x246a, 0x1043, "(null)" },
    { 0x1299, 0x24aa, 0x1043, "(null)" },
    { 0x1299, 0xf841, 0x1179, "(null)" },
    { 0x1299, 0xf842, 0x1179, "(null)" },
    { 0x1299, 0xf843, 0x1179, "(null)" },
    { 0x1299, 0xc757, 0x144d, "(null)" },
    { 0x1299, 0xc770, 0x144d, "(null)" },
    { 0x1299, 0x1116, 0x1462, "(null)" },
    { 0x1299, 0x1159, 0x1462, "(null)" },
    { 0x1299, 0x1108, 0x152d, "(null)" },
    { 0x1299, 0x1113, 0x152d, "(null)" },
    { 0x1299, 0x1123, 0x152d, "(null)" },
    { 0x1299, 0x1126, 0x152d, "(null)" },
    { 0x1299, 0x30bb, 0x17aa, "(null)" },
    { 0x1299, 0x30da, 0x17aa, "(null)" },
    { 0x1299, 0x30dc, 0x17aa, "(null)" },
    { 0x1299, 0x30dd, 0x17aa, "(null)" },
    { 0x1299, 0x30df, 0x17aa, "(null)" },
    { 0x1299, 0x3117, 0x17aa, "(null)" },
    { 0x1299, 0x361b, 0x17aa, "(null)" },
    { 0x1299, 0x362d, 0x17aa, "(null)" },
    { 0x1299, 0x362e, 0x17aa, "(null)" },
    { 0x1299, 0x3630, 0x17aa, "(null)" },
    { 0x1299, 0x3637, 0x17aa, "(null)" },
    { 0x1299, 0x369b, 0x17aa, "(null)" },
    { 0x1299, 0x36a7, 0x17aa, "(null)" },
    { 0x1299, 0x36af, 0x17aa, "(null)" },
    { 0x1299, 0x36f0, 0x17aa, "(null)" },
    { 0x1299, 0x3801, 0x17aa, "(null)" },
    { 0x1299, 0x380d, 0x17aa, "(null)" },
    { 0x1299, 0x381c, 0x17aa, "(null)" },
    { 0x1299, 0x381d, 0x17aa, "(null)" },
    { 0x1299, 0x381f, 0x17aa, "(null)" },
    { 0x1299, 0x3821, 0x17aa, "(null)" },
    { 0x1299, 0x3822, 0x17aa, "(null)" },
    { 0x1299, 0x3824, 0x17aa, "(null)" },
    { 0x1299, 0x3829, 0x17aa, "(null)" },
    { 0x1299, 0x382b, 0x17aa, "(null)" },
    { 0x1299, 0x39f1, 0x17aa, "(null)" },
    { 0x1299, 0x0260, 0x1854, "(null)" },
    { 0x1299, 0x01c6, 0x1b0a, "(null)" },
    { 0x1299, 0x225c, 0x1b0a, "(null)" },
    { 0x1299, 0x2004, 0x1d05, "(null)" },
    { 0x129A, 0x099e, 0x1025, "(null)" },
    { 0x129A, 0x1014, 0x1025, "(null)" },
    { 0x129A, 0x1015, 0x1025, "(null)" },
    { 0x129A, 0xc782, 0x144d, "(null)" },
    { 0x12B9, 0x1026, 0x103c, "(null)" },
    { 0x12B9, 0x1909, 0x103c, "(null)" },
    { 0x12B9, 0x190a, 0x103c, "(null)" },
    { 0x12B9, 0x197a, 0x103c, "(null)" },
    { 0x12B9, 0x197b, 0x103c, "(null)" },
    { 0x12B9, 0x2253, 0x103c, "(null)" },
    { 0x12B9, 0x2254, 0x103c, "(null)" },
    { 0x12BA, 0x17ed, 0x10cf, "(null)" },
    { 0x1340, 0x0000, 0x0000, "NVIDIA GeForce 830M" },
    { 0x1340, 0x2b2b, 0x103c, "NVIDIA GeForce 830A" },
    { 0x1341, 0x0000, 0x0000, "NVIDIA GeForce 840M" },
    { 0x1341, 0x3697, 0x17aa, "NVIDIA GeForce 840A" },
    { 0x1341, 0x3699, 0x17aa, "NVIDIA GeForce 840A" },
    { 0x1341, 0x369c, 0x17aa, "NVIDIA GeForce 840A" },
    { 0x1341, 0x36af, 0x17aa, "NVIDIA GeForce 840A" },
    { 0x1344, 0x0000, 0x0000, "NVIDIA GeForce 845M" },
    { 0x1346, 0x0000, 0x0000, "NVIDIA GeForce 930M" },
    { 0x1346, 0x30ba, 0x17aa, "NVIDIA GeForce 930A" },
    { 0x1346, 0x362c, 0x17aa, "NVIDIA GeForce 930A" },
    { 0x1346, 0x362f, 0x17aa, "NVIDIA GeForce 930A" },
    { 0x1346, 0x3636, 0x17aa, "NVIDIA GeForce 930A" },
    { 0x1347, 0x0000, 0x0000, "NVIDIA GeForce 940M" },
    { 0x1347, 0x36b9, 0x17aa, "NVIDIA GeForce 940A" },
    { 0x1347, 0x36ba, 0x17aa, "NVIDIA GeForce 940A" },
    { 0x1348, 0x0000, 0x0000, "NVIDIA GeForce 945M" },
    { 0x1348, 0x2b5c, 0x103c, "NVIDIA GeForce 945A" },
    { 0x1349, 0x0000, 0x0000, "NVIDIA GeForce 930M" },
    { 0x1349, 0x3124, 0x17aa, "NVIDIA GeForce 930A" },
    { 0x1349, 0x364b, 0x17aa, "NVIDIA GeForce 930A" },
    { 0x1349, 0x36c3, 0x17aa, "NVIDIA GeForce 930A" },
    { 0x1349, 0x36d1, 0x17aa, "NVIDIA GeForce 930A" },
    { 0x1349, 0x36d8, 0x17aa, "NVIDIA GeForce 930A" },
    { 0x134B, 0x0000, 0x0000, "NVIDIA GeForce 940MX" },
    { 0x134D, 0x0000, 0x0000, "NVIDIA GeForce 940MX" },
    { 0x134E, 0x0000, 0x0000, "NVIDIA GeForce 930MX" },
    { 0x134F, 0x0000, 0x0000, "NVIDIA GeForce 920MX" },
    { 0x137A, 0x0000, 0x0000, "NVIDIA N15M-Q3" },
    { 0x137A, 0x2225, 0x17aa, "Quadro K620M" },
    { 0x137A, 0x2232, 0x17aa, "Quadro M500M" },
    { 0x137A, 0x505a, 0x17aa, "Quadro M500M" },
    { 0x137B, 0x0000, 0x0000, "Quadro M520" },
    { 0x1380, 0x0000, 0x0000, "NVIDIA GeForce GTX 750 Ti" },
    { 0x1381, 0x0000, 0x0000, "NVIDIA GeForce GTX 750" },
    { 0x1382, 0x0000, 0x0000, "NVIDIA GeForce GTX 745" },
    { 0x1390, 0x0000, 0x0000, "NVIDIA GeForce 845M" },
    { 0x1391, 0x0000, 0x0000, "NVIDIA GeForce GTX 850M" },
    { 0x1391, 0x3697, 0x17aa, "NVIDIA GeForce GTX 850A" },
    { 0x1392, 0x0000, 0x0000, "NVIDIA GeForce GTX 860M" },
    { 0x1392, 0x066a, 0x1028, "NVIDIA GeForce GPU" },
    { 0x1392, 0x861e, 0x1043, "NVIDIA GeForce GTX 750 Ti" },
    { 0x1392, 0x86d9, 0x1043, "NVIDIA GeForce GTX 750 Ti" },
    { 0x1393, 0x0000, 0x0000, "NVIDIA GeForce 840M" },
    { 0x1398, 0x0000, 0x0000, "NVIDIA GeForce 845M" },
    { 0x1399, 0x0000, 0x0000, "NVIDIA GeForce 945M" },
    { 0x139A, 0x0000, 0x0000, "NVIDIA GeForce GTX 950M" },
    { 0x139A, 0x362c, 0x17aa, "NVIDIA GeForce GTX 950A" },
    { 0x139A, 0x362f, 0x17aa, "NVIDIA GeForce GTX 950A" },
    { 0x139A, 0x363f, 0x17aa, "NVIDIA GeForce GTX 950A" },
    { 0x139A, 0x3640, 0x17aa, "NVIDIA GeForce GTX 950A" },
    { 0x139A, 0x3647, 0x17aa, "NVIDIA GeForce GTX 950A" },
    { 0x139A, 0x36b9, 0x17aa, "NVIDIA GeForce GTX 950A" },
    { 0x139B, 0x0000, 0x0000, "NVIDIA GeForce GTX 960M" },
    { 0x139B, 0x107a, 0x1025, "NVIDIA GeForce GTX 750 Ti" },
    { 0x139B, 0x06a3, 0x1028, "NVIDIA GeForce GTX 860M" },
    { 0x139B, 0x2b4c, 0x103c, "NVIDIA GeForce GTX 960A" },
    { 0x139B, 0x3649, 0x17aa, "NVIDIA GeForce GTX 750Ti" },
    { 0x139B, 0x36bf, 0x17aa, "NVIDIA GeForce GTX 960A" },
    { 0x139B, 0xc248, 0x19da, "NVIDIA GeForce GTX 750 Ti" },
    { 0x139B, 0x8a75, 0x1afa, "NVIDIA GeForce GTX 750Ti" },
    { 0x139C, 0x0000, 0x0000, "NVIDIA GeForce 940M" },
    { 0x139D, 0x0000, 0x0000, "NVIDIA GeForce GTX 750 Ti" },
    { 0x13B0, 0x0000, 0x0000, "Quadro M2000M" },
    { 0x13B1, 0x0000, 0x0000, "Quadro M1000M" },
    { 0x13B2, 0x0000, 0x0000, "Quadro M600M" },
    { 0x13B3, 0x0000, 0x0000, "Quadro K2200M" },
    { 0x13B4, 0x0000, 0x0000, "Quadro M620" },
    { 0x13B6, 0x0000, 0x0000, "Quadro M1200" },
    { 0x13B9, 0x0000, 0x0000, "NVS 810" },
    { 0x13BA, 0x0000, 0x0000, "Quadro K2200" },
    { 0x13BB, 0x0000, 0x0000, "Quadro K620" },
    { 0x13BC, 0x0000, 0x0000, "Quadro K1200" },
    { 0x13BC, 0x1140, 0x15c3, "EIZO Quadro MED-XN50LP" },
    { 0x13C0, 0x0000, 0x0000, "NVIDIA GeForce GTX 980" },
    { 0x13C2, 0x0000, 0x0000, "NVIDIA GeForce GTX 970" },
    { 0x13D7, 0x0000, 0x0000, "NVIDIA GeForce GTX 980M" },
    { 0x13D8, 0x0000, 0x0000, "NVIDIA GeForce GTX 970M" },
    { 0x13D8, 0x1198, 0x1462, "NVIDIA GeForce GTX 960" },
    { 0x13D8, 0x1199, 0x1462, "NVIDIA GeForce GTX 960" },
    { 0x13D8, 0xb282, 0x19da, "NVIDIA GeForce GTX 960" },
    { 0x13D8, 0xb284, 0x19da, "NVIDIA GeForce GTX 960" },
    { 0x13D8, 0xb286, 0x19da, "NVIDIA GeForce GTX 960" },
    { 0x13D9, 0x0000, 0x0000, "NVIDIA GeForce GTX 965M" },
    { 0x13DA, 0x0000, 0x0000, "NVIDIA GeForce GTX 980" },
    { 0x13F0, 0x0000, 0x0000, "Quadro M5000" },
    { 0x13F1, 0x0000, 0x0000, "Quadro M4000" },
    { 0x13F1, 0x1153, 0x15c3, "EIZO Quadro MED-XN90" },
    { 0x13F2, 0x0000, 0x0000, "Tesla M60" },
    { 0x13F3, 0x0000, 0x0000, "Tesla M6" },
    { 0x13F8, 0x0000, 0x0000, "Quadro M5000M" },
    { 0x13F8, 0x11dd, 0x10de, "Quadro M5000 SE" },
    { 0x13F9, 0x0000, 0x0000, "Quadro M4000M" },
    { 0x13FA, 0x0000, 0x0000, "Quadro M3000M" },
    { 0x13FA, 0x11c9, 0x10de, "Quadro M3000 SE" },
    { 0x13FB, 0x0000, 0x0000, "Quadro M5500" },
    { 0x1401, 0x0000, 0x0000, "NVIDIA GeForce GTX 960" },
    { 0x1402, 0x0000, 0x0000, "NVIDIA GeForce GTX 950" },
    { 0x1406, 0x0000, 0x0000, "NVIDIA GeForce GTX 960" },
    { 0x1407, 0x0000, 0x0000, "NVIDIA GeForce GTX 750" },
    { 0x1427, 0x0000, 0x0000, "NVIDIA GeForce GTX 965M" },
    { 0x1427, 0xd003, 0x1458, "NVIDIA GeForce GTX 950" },
    { 0x1430, 0x0000, 0x0000, "Quadro M2000" },
    { 0x1430, 0x1190, 0x15c3, "EIZO Quadro MED-XN70" },
    { 0x1431, 0x0000, 0x0000, "Tesla M4" },
    { 0x1436, 0x0000, 0x0000, "Quadro M2200" },
    { 0x15F0, 0x0000, 0x0000, "Quadro GP100" },
    { 0x15F7, 0x0000, 0x0000, "Tesla P100-PCIE-12GB" },
    { 0x15F8, 0x0000, 0x0000, "Tesla P100-PCIE-16GB" },
    { 0x15F9, 0x0000, 0x0000, "Tesla P100-SXM2-16GB" },
    { 0x1617, 0x0000, 0x0000, "NVIDIA GeForce GTX 980M" },
    { 0x1618, 0x0000, 0x0000, "NVIDIA GeForce GTX 970M" },
    { 0x1619, 0x0000, 0x0000, "NVIDIA GeForce GTX 965M" },
    { 0x161A, 0x0000, 0x0000, "NVIDIA GeForce GTX 980" },
    { 0x1667, 0x0000, 0x0000, "NVIDIA GeForce GTX 965M" },
    { 0x174D, 0x0000, 0x0000, "NVIDIA GeForce MX130" },
    { 0x174E, 0x0000, 0x0000, "NVIDIA GeForce MX110" },
    { 0x179C, 0x0000, 0x0000, "NVIDIA GeForce 940MX" },
    { 0x17C2, 0x0000, 0x0000, "NVIDIA GeForce GTX TITAN X" },
    { 0x17C8, 0x0000, 0x0000, "NVIDIA GeForce GTX 980 Ti" },
    { 0x17F0, 0x0000, 0x0000, "Quadro M6000" },
    { 0x17F1, 0x0000, 0x0000, "Quadro M6000 24GB" },
    { 0x17FD, 0x0000, 0x0000, "Tesla M40" },
    { 0x17FD, 0x1173, 0x10de, "Tesla M40 24GB" },
    { 0x1B00, 0x0000, 0x0000, "NVIDIA TITAN X (Pascal)" },
    { 0x1B02, 0x0000, 0x0000, "NVIDIA TITAN Xp" },
    { 0x1B02, 0x123e, 0x10de, "NVIDIA TITAN Xp COLLECTORS EDITION" },
    { 0x1B02, 0x123f, 0x10de, "NVIDIA TITAN Xp COLLECTORS EDITION" },
    { 0x1B06, 0x0000, 0x0000, "NVIDIA GeForce GTX 1080 Ti" },
    { 0x1B30, 0x0000, 0x0000, "Quadro P6000" },
    { 0x1B38, 0x0000, 0x0000, "Tesla P40" },
    { 0x1B80, 0x0000, 0x0000, "NVIDIA GeForce GTX 1080" },
    { 0x1B81, 0x0000, 0x0000, "NVIDIA GeForce GTX 1070" },
    { 0x1B82, 0x0000, 0x0000, "NVIDIA GeForce GTX 1070 Ti" },
    { 0x1B83, 0x0000, 0x0000, "NVIDIA GeForce GTX 1060 6GB" },
    { 0x1B84, 0x0000, 0x0000, "NVIDIA GeForce GTX 1060 3GB" },
    { 0x1B87, 0x0000, 0x0000, "NVIDIA P104-100" },
    { 0x1BA0, 0x0000, 0x0000, "NVIDIA GeForce GTX 1080" },
    { 0x1BA0, 0x0887, 0x1028, "NVIDIA GeForce GTX 1080 with Max-Q Design" },
    { 0x1BA1, 0x0000, 0x0000, "NVIDIA GeForce GTX 1070" },
    { 0x1BA1, 0x08a1, 0x1028, "NVIDIA GeForce GTX 1070 with Max-Q Design" },
    { 0x1BA1, 0x08a2, 0x1028, "NVIDIA GeForce GTX 1070 with Max-Q Design" },
    { 0x1BA1, 0x1cce, 0x1043, "NVIDIA GeForce GTX 1070 with Max-Q Design" },
    { 0x1BA1, 0x1651, 0x1458, "NVIDIA GeForce GTX 1070 with Max-Q Design" },
    { 0x1BA1, 0x1653, 0x1458, "NVIDIA GeForce GTX 1070 with Max-Q Design" },
    { 0x1BA1, 0x11e8, 0x1462, "NVIDIA GeForce GTX 1070 with Max-Q Design" },
    { 0x1BA1, 0x11e9, 0x1462, "NVIDIA GeForce GTX 1070 with Max-Q Design" },
    { 0x1BA1, 0x1225, 0x1462, "NVIDIA GeForce GTX 1070 with Max-Q Design" },
    { 0x1BA1, 0x1226, 0x1462, "NVIDIA GeForce GTX 1070 with Max-Q Design" },
    { 0x1BA1, 0x1227, 0x1462, "NVIDIA GeForce GTX 1070 with Max-Q Design" },
    { 0x1BA1, 0x9501, 0x1558, "NVIDIA GeForce GTX 1070 with Max-Q Design" },
    { 0x1BA1, 0x95e1, 0x1558, "NVIDIA GeForce GTX 1070 with Max-Q Design" },
    { 0x1BA1, 0x2000, 0x1a58, "NVIDIA GeForce GTX 1070 with Max-Q Design" },
    { 0x1BA1, 0x1032, 0x1d05, "NVIDIA GeForce GTX 1070 with Max-Q Design" },
    { 0x1BA2, 0x0000, 0x0000, "NVIDIA GeForce GTX 1070" },
    { 0x1BB0, 0x0000, 0x0000, "Quadro P5000" },
    { 0x1BB1, 0x0000, 0x0000, "Quadro P4000" },
    { 0x1BB1, 0x11a3, 0x15c3, "EIZO Quadro MED-XN91" },
    { 0x1BB3, 0x11d8, 0x10de, "Tesla P4" },
    { 0x1BB3, 0x11e0, 0x10de, "Tesla P4" },
    { 0x1BB4, 0x0000, 0x0000, "Tesla P6" },
    { 0x1BB5, 0x0000, 0x0000, "Quadro P5200" },
    { 0x1BB5, 0x2268, 0x17aa, "Quadro P5200 with Max-Q Design" },
    { 0x1BB5, 0x2269, 0x17aa, "Quadro P5200 with Max-Q Design" },
    { 0x1BB6, 0x0000, 0x0000, "Quadro P5000" },
    { 0x1BB7, 0x0000, 0x0000, "Quadro P4000" },
    { 0x1BB7, 0x11e9, 0x1462, "Quadro P4000 with Max-Q Design" },
    { 0x1BB7, 0x9501, 0x1558, "Quadro P4000 with Max-Q Design" },
    { 0x1BB8, 0x0000, 0x0000, "Quadro P3000" },
    { 0x1BB9, 0x0000, 0x0000, "Quadro P4200" },
    { 0x1BB9, 0x95e1, 0x1558, "Quadro P4200 with Max-Q Design" },
    { 0x1BB9, 0x2268, 0x17aa, "Quadro P4200 with Max-Q Design" },
    { 0x1BB9, 0x2269, 0x17aa, "Quadro P4200 with Max-Q Design" },
    { 0x1BBB, 0x0000, 0x0000, "Quadro P3200" },
    { 0x1BBB, 0x225f, 0x17aa, "Quadro P3200 with Max-Q Design" },
    { 0x1BBB, 0x2262, 0x17aa, "Quadro P3200 with Max-Q Design" },
    { 0x1BC7, 0x0000, 0x0000, "NVIDIA P104-101" },
    { 0x1BE0, 0x0000, 0x0000, "NVIDIA GeForce GTX 1080" },
    { 0x1BE0, 0x1221, 0x1025, "NVIDIA GeForce GTX 1080 with Max-Q Design" },
    { 0x1BE0, 0x123e, 0x1025, "NVIDIA GeForce GTX 1080 with Max-Q Design" },
    { 0x1BE0, 0x07c0, 0x1028, "NVIDIA GeForce GTX 1080 with Max-Q Design" },
    { 0x1BE0, 0x0876, 0x1028, "NVIDIA GeForce GTX 1080 with Max-Q Design" },
    { 0x1BE0, 0x088b, 0x1028, "NVIDIA GeForce GTX 1080 with Max-Q Design" },
    { 0x1BE0, 0x1031, 0x1043, "NVIDIA GeForce GTX 1080 with Max-Q Design" },
    { 0x1BE0, 0x1bf0, 0x1043, "NVIDIA GeForce GTX 1080 with Max-Q Design" },
    { 0x1BE0, 0x355b, 0x1458, "NVIDIA GeForce GTX 1080 with Max-Q Design" },
    { 0x1BE1, 0x0000, 0x0000, "NVIDIA GeForce GTX 1070" },
    { 0x1BE1, 0x84db, 0x103c, "NVIDIA GeForce GTX 1070 with Max-Q Design" },
    { 0x1BE1, 0x16f0, 0x1043, "NVIDIA GeForce GTX 1070 with Max-Q Design" },
    { 0x1BE1, 0x2009, 0x3842, "NVIDIA GeForce GTX 1070 with Max-Q Design" },
    { 0x1C02, 0x0000, 0x0000, "NVIDIA GeForce GTX 1060 3GB" },
    { 0x1C03, 0x0000, 0x0000, "NVIDIA GeForce GTX 1060 6GB" },
    { 0x1C04, 0x0000, 0x0000, "NVIDIA GeForce GTX 1060 5GB" },
    { 0x1C06, 0x0000, 0x0000, "NVIDIA GeForce GTX 1060 6GB" },
    { 0x1C07, 0x0000, 0x0000, "NVIDIA P106-100" },
    { 0x1C09, 0x0000, 0x0000, "NVIDIA P106-090" },
    { 0x1C20, 0x0000, 0x0000, "NVIDIA GeForce GTX 1060" },
    { 0x1C20, 0x0802, 0x1028, "NVIDIA GeForce GTX 1060 with Max-Q Design" },
    { 0x1C20, 0x0803, 0x1028, "NVIDIA GeForce GTX 1060 with Max-Q Design" },
    { 0x1C20, 0x0825, 0x1028, "NVIDIA GeForce GTX 1060 with Max-Q Design" },
    { 0x1C20, 0x0827, 0x1028, "NVIDIA GeForce GTX 1060 with Max-Q Design" },
    { 0x1C20, 0x0885, 0x1028, "NVIDIA GeForce GTX 1060 with Max-Q Design" },
    { 0x1C20, 0x0886, 0x1028, "NVIDIA GeForce GTX 1060 with Max-Q Design" },
    { 0x1C20, 0x8467, 0x103c, "NVIDIA GeForce GTX 1060 with Max-Q Design" },
    { 0x1C20, 0x8478, 0x103c, "NVIDIA GeForce GTX 1060 with Max-Q Design" },
    { 0x1C20, 0x8581, 0x103c, "NVIDIA GeForce GTX 1060 with Max-Q Design" },
    { 0x1C20, 0x1244, 0x1462, "NVIDIA GeForce GTX 1060 with Max-Q Design" },
    { 0x1C20, 0x95e5, 0x1558, "NVIDIA GeForce GTX 1060 with Max-Q Design" },
    { 0x1C20, 0x39b9, 0x17aa, "NVIDIA GeForce GTX 1060 with Max-Q Design" },
    { 0x1C20, 0x2000, 0x1a58, "NVIDIA GeForce GTX 1060 with Max-Q Design" },
    { 0x1C20, 0x2001, 0x1a58, "NVIDIA GeForce GTX 1060 with Max-Q Design" },
    { 0x1C20, 0x1059, 0x1d05, "NVIDIA GeForce GTX 1060 with Max-Q Design" },
    { 0x1C21, 0x0000, 0x0000, "NVIDIA GeForce GTX 1050 Ti" },
    { 0x1C22, 0x0000, 0x0000, "NVIDIA GeForce GTX 1050" },
    { 0x1C23, 0x0000, 0x0000, "NVIDIA GeForce GTX 1060" },
    { 0x1C30, 0x0000, 0x0000, "Quadro P2000" },
    { 0x1C30, 0x11b3, 0x15c3, "EIZO Quadro MED-XN71" },
    { 0x1C31, 0x0000, 0x0000, "Quadro P2200" },
    { 0x1C31, 0x131b, 0x15c3, "EIZO Quadro MED-XN72" },
    { 0x1C60, 0x0000, 0x0000, "NVIDIA GeForce GTX 1060" },
    { 0x1C60, 0x8390, 0x103c, "NVIDIA GeForce GTX 1060 with Max-Q Design" },
    { 0x1C60, 0x8467, 0x103c, "NVIDIA GeForce GTX 1060 with Max-Q Design" },
    { 0x1C61, 0x0000, 0x0000, "NVIDIA GeForce GTX 1050 Ti" },
    { 0x1C62, 0x0000, 0x0000, "NVIDIA GeForce GTX 1050" },
    { 0x1C81, 0x0000, 0x0000, "NVIDIA GeForce GTX 1050" },
    { 0x1C82, 0x0000, 0x0000, "NVIDIA GeForce GTX 1050 Ti" },
    { 0x1C83, 0x0000, 0x0000, "NVIDIA GeForce GTX 1050" },
    { 0x1C8C, 0x0000, 0x0000, "NVIDIA GeForce GTX 1050 Ti" },
    { 0x1C8C, 0x087c, 0x1028, "NVIDIA GeForce GTX 1050 Ti with Max-Q Design" },
    { 0x1C8C, 0x8519, 0x103c, "NVIDIA GeForce GTX 1050 Ti with Max-Q Design" },
    { 0x1C8C, 0x856a, 0x103c, "NVIDIA GeForce GTX 1050 Ti with Max-Q Design" },
    { 0x1C8C, 0x123c, 0x1462, "NVIDIA GeForce GTX 1050 Ti with Max-Q Design" },
    { 0x1C8C, 0x126c, 0x1462, "NVIDIA GeForce GTX 1050 Ti with Max-Q Design" },
    { 0x1C8C, 0x2266, 0x17aa, "NVIDIA GeForce GTX 1050 Ti with Max-Q Design" },
    { 0x1C8C, 0x2267, 0x17aa, "NVIDIA GeForce GTX 1050 Ti with Max-Q Design" },
    { 0x1C8C, 0x39ff, 0x17aa, "NVIDIA GeForce GTX 1050 Ti with Max-Q Design" },
    { 0x1C8D, 0x0000, 0x0000, "NVIDIA GeForce GTX 1050" },
    { 0x1C8D, 0x84e9, 0x103c, "NVIDIA GeForce GTX 1050 with Max-Q Design" },
    { 0x1C8D, 0x84eb, 0x103c, "NVIDIA GeForce GTX 1050 with Max-Q Design" },
    { 0x1C8D, 0x856a, 0x103c, "NVIDIA GeForce GTX 1050 with Max-Q Design" },
    { 0x1C8D, 0x114f, 0x1043, "NVIDIA GeForce GTX 1050 with Max-Q Design" },
    { 0x1C8D, 0x1341, 0x1043, "NVIDIA GeForce GTX 1050 with Max-Q Design" },
    { 0x1C8D, 0x1351, 0x1043, "NVIDIA GeForce GTX 1050 with Max-Q Design" },
    { 0x1C8D, 0x1481, 0x1043, "NVIDIA GeForce GTX 1050 with Max-Q Design" },
    { 0x1C8D, 0x14a1, 0x1043, "NVIDIA GeForce GTX 1050 with Max-Q Design" },
    { 0x1C8D, 0x18c1, 0x1043, "NVIDIA GeForce GTX 1050 with Max-Q Design" },
    { 0x1C8D, 0x1b5e, 0x1043, "NVIDIA GeForce GTX 1050 with Max-Q Design" },
    { 0x1C8D, 0x126c, 0x1462, "NVIDIA GeForce GTX 1050 with Max-Q Design" },
    { 0x1C8D, 0x1217, 0x152d, "NVIDIA GeForce GTX 1050 with Max-Q Design" },
    { 0x1C8D, 0x1707, 0x1d72, "NVIDIA GeForce GTX 1050 with Max-Q Design" },
    { 0x1C8F, 0x0000, 0x0000, "NVIDIA GeForce GTX 1050 Ti" },
    { 0x1C8F, 0x123c, 0x1462, "NVIDIA GeForce GTX 1050 Ti with Max-Q Design" },
    { 0x1C8F, 0x126c, 0x1462, "NVIDIA GeForce GTX 1050 Ti with Max-Q Design" },
    { 0x1C8F, 0x126d, 0x1462, "NVIDIA GeForce GTX 1050 Ti with Max-Q Design" },
    { 0x1C8F, 0x1284, 0x1462, "NVIDIA GeForce GTX 1050 Ti with Max-Q Design" },
    { 0x1C8F, 0x1297, 0x1462, "NVIDIA GeForce GTX 1050 Ti with Max-Q Design" },
    { 0x1C90, 0x0000, 0x0000, "NVIDIA GeForce MX150" },
    { 0x1C90, 0x09c1, 0x1028, "NVIDIA GeForce MX250" },
    { 0x1C91, 0x0000, 0x0000, "NVIDIA GeForce GTX 1050" },
    { 0x1C91, 0x856a, 0x103c, "NVIDIA GeForce GTX 1050 with Max-Q Design" },
    { 0x1C91, 0x86e3, 0x103c, "NVIDIA GeForce GTX 1050 with Max-Q Design" },
    { 0x1C91, 0x1232, 0x152d, "NVIDIA GeForce GTX 1050 with Max-Q Design" },
    { 0x1C92, 0x0000, 0x0000, "NVIDIA GeForce GTX 1050" },
    { 0x1C92, 0x149f, 0x1043, "NVIDIA GeForce GTX 1050 with Max-Q Design" },
    { 0x1C92, 0x1b31, 0x1043, "NVIDIA GeForce GTX 1050 with Max-Q Design" },
    { 0x1C92, 0x1245, 0x1462, "NVIDIA GeForce GTX 1050 with Max-Q Design" },
    { 0x1C92, 0x126c, 0x1462, "NVIDIA GeForce GTX 1050 with Max-Q Design" },
    { 0x1C94, 0x0000, 0x0000, "NVIDIA GeForce MX350" },
    { 0x1C96, 0x0000, 0x0000, "NVIDIA GeForce MX350" },
    { 0x1CB1, 0x0000, 0x0000, "Quadro P1000" },
    { 0x1CB1, 0x11bc, 0x15c3, "EIZO Quadro MED-XN51LP" },
    { 0x1CB2, 0x0000, 0x0000, "Quadro P600" },
    { 0x1CB3, 0x0000, 0x0000, "Quadro P400" },
    { 0x1CB3, 0x11be, 0x15c3, "EIZO Quadro MED-XN31LP" },
    { 0x1CB6, 0x0000, 0x0000, "Quadro P620" },
    { 0x1CBA, 0x0000, 0x0000, "Quadro P2000" },
    { 0x1CBA, 0x2266, 0x17aa, "Quadro P2000 with Max-Q Design" },
    { 0x1CBA, 0x2267, 0x17aa, "Quadro P2000 with Max-Q Design" },
    { 0x1CBB, 0x0000, 0x0000, "Quadro P1000" },
    { 0x1CBC, 0x0000, 0x0000, "Quadro P600" },
    { 0x1CBD, 0x0000, 0x0000, "Quadro P620" },
    { 0x1CFA, 0x0000, 0x0000, "Quadro P2000" },
    { 0x1CFB, 0x0000, 0x0000, "Quadro P1000" },
    { 0x1CFB, 0x2600, 0x102b, "Matrox D-Series D1480" },
    { 0x1CFB, 0x2700, 0x102b, "Matrox D-Series D1450" },
    { 0x1D01, 0x0000, 0x0000, "NVIDIA GeForce GT 1030" },
    { 0x1D02, 0x0000, 0x0000, "NVIDIA GeForce GT 1010" },
    { 0x1D10, 0x0000, 0x0000, "NVIDIA GeForce MX150" },
    { 0x1D11, 0x0000, 0x0000, "NVIDIA GeForce MX230" },
    { 0x1D12, 0x0000, 0x0000, "NVIDIA GeForce MX150" },
    { 0x1D13, 0x0000, 0x0000, "NVIDIA GeForce MX250" },
    { 0x1D16, 0x0000, 0x0000, "NVIDIA GeForce MX330" },
    { 0x1D33, 0x0000, 0x0000, "Quadro P500" },
    { 0x1D34, 0x0000, 0x0000, "Quadro P520" },
    { 0x1D52, 0x0000, 0x0000, "NVIDIA GeForce MX250" },
    { 0x1D81, 0x0000, 0x0000, "NVIDIA TITAN V" },
    { 0x1DB1, 0x0000, 0x0000, "Tesla V100-SXM2-16GB" },
    { 0x1DB1, 0x1307, 0x10de, "Tesla V100-SXM2-16GB-LS" },
    { 0x1DB3, 0x0000, 0x0000, "Tesla V100-FHHL-16GB" },
    { 0x1DB4, 0x0000, 0x0000, "Tesla V100-PCIE-16GB" },
    { 0x1DB4, 0x1306, 0x10de, "Tesla V100-PCIE-16GB-LS" },
    { 0x1DB5, 0x0000, 0x0000, "Tesla V100-SXM2-32GB" },
    { 0x1DB5, 0x1308, 0x10de, "Tesla V100-SXM2-32GB-LS" },
    { 0x1DB6, 0x0000, 0x0000, "Tesla V100-PCIE-32GB" },
    { 0x1DB7, 0x0000, 0x0000, "Tesla V100-DGXS-32GB" },
    { 0x1DB8, 0x0000, 0x0000, "Tesla V100-SXM3-32GB" },
    { 0x1DB8, 0x131d, 0x10de, "Tesla V100-SXM3-32GB-H" },
    { 0x1DBA, 0x0000, 0x0000, "Quadro GV100" },
    { 0x1DBA, 0x12eb, 0x10de, "NVIDIA TITAN V JHH Special Edition" },
    { 0x1DF0, 0x0000, 0x0000, "Tesla PG500-216" },
    { 0x1DF2, 0x0000, 0x0000, "Tesla PG503-216" },
    { 0x1DF6, 0x0000, 0x0000, "Tesla V100S-PCIE-32GB" },
    { 0x1E02, 0x0000, 0x0000, "NVIDIA TITAN RTX" },
    { 0x1E04, 0x0000, 0x0000, "NVIDIA GeForce RTX 2080 Ti" },
    { 0x1E07, 0x0000, 0x0000, "NVIDIA GeForce RTX 2080 Ti" },
    { 0x1E09, 0x0000, 0x0000, "NVIDIA CMP 50HX" },
    { 0x1E30, 0x0000, 0x0000, "Quadro RTX 6000" },
    { 0x1E30, 0x129e, 0x1028, "Quadro RTX 8000" },
    { 0x1E30, 0x129e, 0x103c, "Quadro RTX 8000" },
    { 0x1E30, 0x129e, 0x10de, "Quadro RTX 8000" },
    { 0x1E36, 0x0000, 0x0000, "Quadro RTX 6000" },
    { 0x1E78, 0x13d8, 0x10de, "Quadro RTX 8000" },
    { 0x1E78, 0x13d9, 0x10de, "Quadro RTX 6000" },
    { 0x1E81, 0x0000, 0x0000, "NVIDIA GeForce RTX 2080 SUPER" },
    { 0x1E82, 0x0000, 0x0000, "NVIDIA GeForce RTX 2080" },
    { 0x1E84, 0x0000, 0x0000, "NVIDIA GeForce RTX 2070 SUPER" },
    { 0x1E87, 0x0000, 0x0000, "NVIDIA GeForce RTX 2080" },
    { 0x1E89, 0x0000, 0x0000, "NVIDIA GeForce RTX 2060" },
    { 0x1E90, 0x0000, 0x0000, "NVIDIA GeForce RTX 2080" },
    { 0x1E90, 0x1375, 0x1025, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x08a1, 0x1028, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x08a2, 0x1028, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x08ea, 0x1028, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x08eb, 0x1028, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x08ec, 0x1028, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x08ed, 0x1028, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x08ee, 0x1028, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x08ef, 0x1028, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x093b, 0x1028, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x093c, 0x1028, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x8572, 0x103c, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x8573, 0x103c, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x8602, 0x103c, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x8606, 0x103c, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x86c6, 0x103c, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x86c7, 0x103c, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x87a6, 0x103c, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x87a7, 0x103c, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x131f, 0x1043, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x137f, 0x1043, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x141f, 0x1043, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x1751, 0x1043, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x1660, 0x1458, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x1661, 0x1458, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x1662, 0x1458, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x75a6, 0x1458, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x75a7, 0x1458, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x86a6, 0x1458, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x86a7, 0x1458, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x1274, 0x1462, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x1277, 0x1462, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x1220, 0x152d, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x95e1, 0x1558, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x97e1, 0x1558, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x2002, 0x1a58, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x2005, 0x1a58, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x2007, 0x1a58, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x3000, 0x1a58, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x3001, 0x1a58, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x1069, 0x1d05, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E91, 0x0000, 0x0000, "NVIDIA GeForce RTX 2070 Super" },
    { 0x1E91, 0x8607, 0x103c, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x8736, 0x103c, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x8738, 0x103c, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x8772, 0x103c, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x878a, 0x103c, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x878b, 0x103c, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x1e61, 0x1043, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x1511, 0x1458, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x75b3, 0x1458, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x75b4, 0x1458, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x76b2, 0x1458, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x76b3, 0x1458, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x78a2, 0x1458, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x78a3, 0x1458, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x86b2, 0x1458, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x86b3, 0x1458, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x12ae, 0x1462, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x12b0, 0x1462, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x12c6, 0x1462, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x22c3, 0x17aa, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x22c5, 0x17aa, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x2009, 0x1a58, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x200a, 0x1a58, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x3002, 0x1a58, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x3012, 0x8086, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E93, 0x0000, 0x0000, "NVIDIA GeForce RTX 2080 Super" },
    { 0x1E93, 0x1401, 0x1025, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x149c, 0x1025, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x09d2, 0x1028, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x8607, 0x103c, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x86c7, 0x103c, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x8736, 0x103c, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x8738, 0x103c, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x8772, 0x103c, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x87a6, 0x103c, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x87a7, 0x103c, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x75b1, 0x1458, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x75b2, 0x1458, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x76b0, 0x1458, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x76b1, 0x1458, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x78a0, 0x1458, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x78a1, 0x1458, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x86b0, 0x1458, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x86b1, 0x1458, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x12ae, 0x1462, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x12b0, 0x1462, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x12b4, 0x1462, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x12c6, 0x1462, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x50d3, 0x1558, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x70d1, 0x1558, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x22c3, 0x17aa, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x22c5, 0x17aa, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x2009, 0x1a58, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x200a, 0x1a58, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x3002, 0x1a58, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x1089, 0x1d05, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1EB0, 0x0000, 0x0000, "Quadro RTX 5000" },
    { 0x1EB1, 0x0000, 0x0000, "Quadro RTX 4000" },
    { 0x1EB1, 0x12a0, 0x15c3, "EIZO Quadro MED-XN92" },
    { 0x1EB5, 0x0000, 0x0000, "Quadro RTX 5000" },
    { 0x1EB5, 0x1375, 0x1025, "Quadro RTX 5000 with Max-Q Design" },
    { 0x1EB5, 0x1401, 0x1025, "Quadro RTX 5000 with Max-Q Design" },
    { 0x1EB5, 0x149c, 0x1025, "Quadro RTX 5000 with Max-Q Design" },
    { 0x1EB5, 0x09c3, 0x1028, "Quadro RTX 5000 with Max-Q Design" },
    { 0x1EB5, 0x8736, 0x103c, "Quadro RTX 5000 with Max-Q Design" },
    { 0x1EB5, 0x8738, 0x103c, "Quadro RTX 5000 with Max-Q Design" },
    { 0x1EB5, 0x8772, 0x103c, "Quadro RTX 5000 with Max-Q Design" },
    { 0x1EB5, 0x8780, 0x103c, "Quadro RTX 5000 with Max-Q Design" },
    { 0x1EB5, 0x8782, 0x103c, "Quadro RTX 5000 with Max-Q Design" },
    { 0x1EB5, 0x8783, 0x103c, "Quadro RTX 5000 with Max-Q Design" },
    { 0x1EB5, 0x8785, 0x103c, "Quadro RTX 5000 with Max-Q Design" },
    { 0x1EB5, 0x1dd1, 0x1043, "Quadro RTX 5000 with Max-Q Design" },
    { 0x1EB5, 0x1274, 0x1462, "Quadro RTX 5000 with Max-Q Design" },
    { 0x1EB5, 0x12b0, 0x1462, "Quadro RTX 5000 with Max-Q Design" },
    { 0x1EB5, 0x12c6, 0x1462, "Quadro RTX 5000 with Max-Q Design" },
    { 0x1EB5, 0x22b8, 0x17aa, "Quadro RTX 5000 with Max-Q Design" },
    { 0x1EB5, 0x22ba, 0x17aa, "Quadro RTX 5000 with Max-Q Design" },
    { 0x1EB5, 0x2005, 0x1a58, "Quadro RTX 5000 with Max-Q Design" },
    { 0x1EB5, 0x2007, 0x1a58, "Quadro RTX 5000 with Max-Q Design" },
    { 0x1EB5, 0x2008, 0x1a58, "Quadro RTX 5000 with Max-Q Design" },
    { 0x1EB5, 0x200a, 0x1a58, "Quadro RTX 5000 with Max-Q Design" },
    { 0x1EB6, 0x0000, 0x0000, "Quadro RTX 4000" },
    { 0x1EB6, 0x09c3, 0x1028, "Quadro RTX 4000 with Max-Q Design" },
    { 0x1EB6, 0x8736, 0x103c, "Quadro RTX 4000 with Max-Q Design" },
    { 0x1EB6, 0x8738, 0x103c, "Quadro RTX 4000 with Max-Q Design" },
    { 0x1EB6, 0x8772, 0x103c, "Quadro RTX 4000 with Max-Q Design" },
    { 0x1EB6, 0x8780, 0x103c, "Quadro RTX 4000 with Max-Q Design" },
    { 0x1EB6, 0x8782, 0x103c, "Quadro RTX 4000 with Max-Q Design" },
    { 0x1EB6, 0x8783, 0x103c, "Quadro RTX 4000 with Max-Q Design" },
    { 0x1EB6, 0x8785, 0x103c, "Quadro RTX 4000 with Max-Q Design" },
    { 0x1EB6, 0x1274, 0x1462, "Quadro RTX 4000 with Max-Q Design" },
    { 0x1EB6, 0x1277, 0x1462, "Quadro RTX 4000 with Max-Q Design" },
    { 0x1EB6, 0x12b0, 0x1462, "Quadro RTX 4000 with Max-Q Design" },
    { 0x1EB6, 0x12c6, 0x1462, "Quadro RTX 4000 with Max-Q Design" },
    { 0x1EB6, 0x22b8, 0x17aa, "Quadro RTX 4000 with Max-Q Design" },
    { 0x1EB6, 0x22ba, 0x17aa, "Quadro RTX 4000 with Max-Q Design" },
    { 0x1EB8, 0x12a2, 0x10de, "Tesla T4" },
    { 0x1EC2, 0x0000, 0x0000, "NVIDIA GeForce RTX 2070 SUPER" },
    { 0x1EC7, 0x0000, 0x0000, "NVIDIA GeForce RTX 2070 SUPER" },
    { 0x1ED0, 0x0000, 0x0000, "NVIDIA GeForce RTX 2080" },
    { 0x1ED0, 0x132d, 0x1025, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1ED0, 0x08ed, 0x1028, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1ED0, 0x08ee, 0x1028, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1ED0, 0x08ef, 0x1028, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1ED0, 0x8572, 0x103c, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1ED0, 0x8573, 0x103c, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1ED0, 0x8600, 0x103c, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1ED0, 0x8605, 0x103c, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1ED0, 0x138f, 0x1043, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1ED0, 0x15c1, 0x1043, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1ED0, 0x3fee, 0x17aa, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1ED0, 0x3ffe, 0x17aa, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1ED1, 0x0000, 0x0000, "NVIDIA GeForce RTX 2070 Super" },
    { 0x1ED1, 0x1432, 0x1025, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1ED1, 0x8746, 0x103c, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1ED1, 0x878a, 0x103c, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1ED1, 0x165f, 0x1043, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1ED1, 0xc192, 0x144d, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1ED1, 0x3fce, 0x17aa, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1ED1, 0x3fcf, 0x17aa, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1ED1, 0x3fd0, 0x17aa, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1ED3, 0x0000, 0x0000, "NVIDIA GeForce RTX 2080 Super" },
    { 0x1ED3, 0x1432, 0x1025, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1ED3, 0x09d1, 0x1028, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1ED3, 0x8746, 0x103c, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1ED3, 0x878a, 0x103c, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1ED3, 0x1d61, 0x1043, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1ED3, 0x1e51, 0x1043, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1ED3, 0x1f01, 0x1043, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1ED3, 0x3fce, 0x17aa, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1ED3, 0x3fcf, 0x17aa, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1ED3, 0x3fd0, 0x17aa, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1EF5, 0x0000, 0x0000, "Quadro RTX 5000" },
    { 0x1F02, 0x0000, 0x0000, "NVIDIA GeForce RTX 2070" },
    { 0x1F03, 0x0000, 0x0000, "NVIDIA GeForce RTX 2060" },
    { 0x1F06, 0x0000, 0x0000, "NVIDIA GeForce RTX 2060 SUPER" },
    { 0x1F07, 0x0000, 0x0000, "NVIDIA GeForce RTX 2070" },
    { 0x1F08, 0x0000, 0x0000, "NVIDIA GeForce RTX 2060" },
    { 0x1F0A, 0x0000, 0x0000, "NVIDIA GeForce GTX 1650" },
    { 0x1F0B, 0x0000, 0x0000, "NVIDIA CMP 40HX" },
    { 0x1F10, 0x0000, 0x0000, "NVIDIA GeForce RTX 2070" },
    { 0x1F10, 0x132d, 0x1025, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x1342, 0x1025, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x08a1, 0x1028, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x08a2, 0x1028, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x08ea, 0x1028, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x08eb, 0x1028, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x08ec, 0x1028, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x08ed, 0x1028, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x08ee, 0x1028, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x08ef, 0x1028, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x093b, 0x1028, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x093c, 0x1028, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x8572, 0x103c, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x8573, 0x103c, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x8602, 0x103c, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x8606, 0x103c, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x132f, 0x1043, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x136f, 0x1043, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x1881, 0x1043, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x1e6e, 0x1043, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x1658, 0x1458, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x1663, 0x1458, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x1664, 0x1458, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x75a4, 0x1458, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x75a5, 0x1458, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x86a4, 0x1458, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x86a5, 0x1458, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x1274, 0x1462, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x1277, 0x1462, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x95e1, 0x1558, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x97e1, 0x1558, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x2002, 0x1a58, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x2005, 0x1a58, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x2007, 0x1a58, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x3000, 0x1a58, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x3001, 0x1a58, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x105e, 0x1d05, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x1070, 0x1d05, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x2087, 0x1d05, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x2087, 0x8086, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F11, 0x0000, 0x0000, "NVIDIA GeForce RTX 2060" },
    { 0x1F12, 0x0000, 0x0000, "NVIDIA GeForce RTX 2060" },
    { 0x1F12, 0x098f, 0x1028, "NVIDIA GeForce RTX 2060 with Max-Q Design" },
    { 0x1F12, 0x8741, 0x103c, "NVIDIA GeForce RTX 2060 with Max-Q Design" },
    { 0x1F12, 0x8744, 0x103c, "NVIDIA GeForce RTX 2060 with Max-Q Design" },
    { 0x1F12, 0x878e, 0x103c, "NVIDIA GeForce RTX 2060 with Max-Q Design" },
    { 0x1F12, 0x880e, 0x103c, "NVIDIA GeForce RTX 2060 with Max-Q Design" },
    { 0x1F12, 0x1e11, 0x1043, "NVIDIA GeForce RTX 2060 with Max-Q Design" },
    { 0x1F12, 0x1f11, 0x1043, "NVIDIA GeForce RTX 2060 with Max-Q Design" },
    { 0x1F12, 0x12d9, 0x1462, "NVIDIA GeForce RTX 2060 with Max-Q Design" },
    { 0x1F12, 0x3801, 0x17aa, "NVIDIA GeForce RTX 2060 with Max-Q Design" },
    { 0x1F12, 0x3802, 0x17aa, "NVIDIA GeForce RTX 2060 with Max-Q Design" },
    { 0x1F12, 0x3803, 0x17aa, "NVIDIA GeForce RTX 2060 with Max-Q Design" },
    { 0x1F14, 0x0000, 0x0000, "NVIDIA GeForce RTX 2070" },
    { 0x1F14, 0x1401, 0x1025, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x1432, 0x1025, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x1442, 0x1025, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x1446, 0x1025, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x147d, 0x1025, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x09e2, 0x1028, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x09f3, 0x1028, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x8607, 0x103c, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x86c6, 0x103c, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x86c7, 0x103c, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x8736, 0x103c, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x8738, 0x103c, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x8746, 0x103c, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x8772, 0x103c, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x878a, 0x103c, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x878b, 0x103c, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x87a6, 0x103c, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x87a7, 0x103c, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x174f, 0x1043, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x1512, 0x1458, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x75b5, 0x1458, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x75b6, 0x1458, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x76b4, 0x1458, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x76b5, 0x1458, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x78a4, 0x1458, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x78a5, 0x1458, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x86b4, 0x1458, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x86b5, 0x1458, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x12ae, 0x1462, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x12b0, 0x1462, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x12c6, 0x1462, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x50d3, 0x1558, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x70d1, 0x1558, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x200c, 0x1a58, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x2011, 0x1a58, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x3002, 0x1a58, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F15, 0x0000, 0x0000, "NVIDIA GeForce RTX 2060" },
    { 0x1F36, 0x0000, 0x0000, "Quadro RTX 3000" },
    { 0x1F36, 0x0990, 0x1028, "Quadro RTX 3000 with Max-Q Design" },
    { 0x1F36, 0x8736, 0x103c, "Quadro RTX 3000 with Max-Q Design" },
    { 0x1F36, 0x8738, 0x103c, "Quadro RTX 3000 with Max-Q Design" },
    { 0x1F36, 0x8772, 0x103c, "Quadro RTX 3000 with Max-Q Design" },
    { 0x1F36, 0x13cf, 0x1043, "Quadro RTX 3000 with Max-Q Design" },
    { 0x1F36, 0x0032, 0x1414, "Quadro RTX 3000 with Max-Q Design" },
    { 0x1F42, 0x0000, 0x0000, "NVIDIA GeForce RTX 2060 SUPER" },
    { 0x1F47, 0x0000, 0x0000, "NVIDIA GeForce RTX 2060 SUPER" },
    { 0x1F50, 0x0000, 0x0000, "NVIDIA GeForce RTX 2070" },
    { 0x1F50, 0x08ed, 0x1028, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F50, 0x08ee, 0x1028, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F50, 0x08ef, 0x1028, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F50, 0x8572, 0x103c, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F50, 0x8573, 0x103c, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F50, 0x8574, 0x103c, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F50, 0x8600, 0x103c, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F50, 0x8605, 0x103c, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F50, 0x3fee, 0x17aa, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F50, 0x3ffe, 0x17aa, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F51, 0x0000, 0x0000, "NVIDIA GeForce RTX 2060" },
    { 0x1F54, 0x0000, 0x0000, "NVIDIA GeForce RTX 2070" },
    { 0x1F54, 0x878a, 0x103c, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F54, 0x3fce, 0x17aa, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F54, 0x3fcf, 0x17aa, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F54, 0x3fd0, 0x17aa, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F55, 0x0000, 0x0000, "NVIDIA GeForce RTX 2060" },
    { 0x1F76, 0x0000, 0x0000, "Quadro RTX 3000" },
    { 0x1F76, 0x2800, 0x102b, "Matrox D-Series D2450" },
    { 0x1F76, 0x2900, 0x102b, "Matrox D-Series D2480" },
    { 0x1F82, 0x0000, 0x0000, "NVIDIA GeForce GTX 1650" },
    { 0x1F83, 0x0000, 0x0000, "NVIDIA GeForce GTX 1630" },
    { 0x1F91, 0x0000, 0x0000, "NVIDIA GeForce GTX 1650" },
    { 0x1F91, 0x863e, 0x103c, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F91, 0x86e7, 0x103c, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F91, 0x86e8, 0x103c, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F91, 0x12cf, 0x1043, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F91, 0x156f, 0x1043, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F91, 0x0032, 0x1414, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F91, 0xc822, 0x144d, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F91, 0x127e, 0x1462, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F91, 0x1281, 0x1462, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F91, 0x1284, 0x1462, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F91, 0x1285, 0x1462, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F91, 0x129c, 0x1462, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F91, 0x229f, 0x17aa, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F91, 0x3802, 0x17aa, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F91, 0x3806, 0x17aa, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F91, 0x3f1a, 0x17aa, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F91, 0x1001, 0x1a58, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F95, 0x0000, 0x0000, "NVIDIA GeForce GTX 1650 Ti" },
    { 0x1F95, 0x1479, 0x1025, "NVIDIA GeForce GTX 1650 Ti with Max-Q Design" },
    { 0x1F95, 0x147a, 0x1025, "NVIDIA GeForce GTX 1650 Ti with Max-Q Design" },
    { 0x1F95, 0x147b, 0x1025, "NVIDIA GeForce GTX 1650 Ti with Max-Q Design" },
    { 0x1F95, 0x147c, 0x1025, "NVIDIA GeForce GTX 1650 Ti with Max-Q Design" },
    { 0x1F95, 0x86e7, 0x103c, "NVIDIA GeForce GTX 1650 Ti with Max-Q Design" },
    { 0x1F95, 0x86e8, 0x103c, "NVIDIA GeForce GTX 1650 Ti with Max-Q Design" },
    { 0x1F95, 0x8815, 0x103c, "NVIDIA GeForce GTX 1650 Ti with Max-Q Design" },
    { 0x1F95, 0x1dff, 0x1043, "NVIDIA GeForce GTX 1650 Ti with Max-Q Design" },
    { 0x1F95, 0x1e1f, 0x1043, "NVIDIA GeForce GTX 1650 Ti with Max-Q Design" },
    { 0x1F95, 0xc838, 0x144d, "NVIDIA GeForce GTX 1650 Ti with Max-Q Design" },
    { 0x1F95, 0x12bd, 0x1462, "NVIDIA GeForce GTX 1650 Ti with Max-Q Design" },
    { 0x1F95, 0x12c5, 0x1462, "NVIDIA GeForce GTX 1650 Ti with Max-Q Design" },
    { 0x1F95, 0x12d2, 0x1462, "NVIDIA GeForce GTX 1650 Ti with Max-Q Design" },
    { 0x1F95, 0x22c0, 0x17aa, "NVIDIA GeForce GTX 1650 Ti with Max-Q Design" },
    { 0x1F95, 0x22c1, 0x17aa, "NVIDIA GeForce GTX 1650 Ti with Max-Q Design" },
    { 0x1F95, 0x3837, 0x17aa, "NVIDIA GeForce GTX 1650 Ti with Max-Q Design" },
    { 0x1F95, 0x3f95, 0x17aa, "NVIDIA GeForce GTX 1650 Ti with Max-Q Design" },
    { 0x1F95, 0x1003, 0x1a58, "NVIDIA GeForce GTX 1650 Ti with Max-Q Design" },
    { 0x1F95, 0x1006, 0x1a58, "NVIDIA GeForce GTX 1650 Ti with Max-Q Design" },
    { 0x1F95, 0x1007, 0x1a58, "NVIDIA GeForce GTX 1650 Ti with Max-Q Design" },
    { 0x1F95, 0x3e30, 0x1e83, "NVIDIA GeForce GTX 1650 Ti with Max-Q Design" },
    { 0x1F96, 0x0000, 0x0000, "NVIDIA GeForce GTX 1650" },
    { 0x1F96, 0x1297, 0x1462, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F97, 0x0000, 0x0000, "NVIDIA GeForce MX450" },
    { 0x1F98, 0x0000, 0x0000, "NVIDIA GeForce MX450" },
    { 0x1F99, 0x0000, 0x0000, "NVIDIA GeForce GTX 1650" },
    { 0x1F99, 0x1479, 0x1025, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F99, 0x147a, 0x1025, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F99, 0x147b, 0x1025, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F99, 0x147c, 0x1025, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F99, 0x8815, 0x103c, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F99, 0x13b2, 0x1043, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F99, 0x1402, 0x1043, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F99, 0x1902, 0x1043, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F99, 0x12bd, 0x1462, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F99, 0x12c5, 0x1462, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F99, 0x12d2, 0x1462, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F99, 0x22da, 0x17aa, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F99, 0x3f93, 0x17aa, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F99, 0x3e30, 0x1e83, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F9C, 0x0000, 0x0000, "NVIDIA GeForce MX450" },
    { 0x1F9D, 0x0000, 0x0000, "NVIDIA GeForce GTX 1650" },
    { 0x1F9D, 0x128d, 0x1043, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F9D, 0x130d, 0x1043, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F9D, 0x149c, 0x1043, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F9D, 0x185c, 0x1043, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F9D, 0x189c, 0x1043, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F9D, 0x12f4, 0x1462, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F9D, 0x1302, 0x1462, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F9D, 0x131b, 0x1462, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F9D, 0x1326, 0x1462, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F9D, 0x132a, 0x1462, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F9D, 0x132e, 0x1462, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F9F, 0x0000, 0x0000, "NVIDIA GeForce MX550" },
    { 0x1FA0, 0x0000, 0x0000, "NVIDIA GeForce MX550" },
    { 0x1FB0, 0x12db, 0x1028, "NVIDIA T1000" },
    { 0x1FB0, 0x12db, 0x103c, "NVIDIA T1000" },
    { 0x1FB0, 0x8a80, 0x103c, "NVIDIA T1000" },
    { 0x1FB0, 0x12db, 0x10de, "NVIDIA T1000" },
    { 0x1FB0, 0x1485, 0x10de, "NVIDIA DGX Display" },
    { 0x1FB0, 0x12db, 0x17aa, "NVIDIA T1000" },
    { 0x1FB1, 0x1488, 0x1028, "NVIDIA T600" },
    { 0x1FB1, 0x1488, 0x103c, "NVIDIA T600" },
    { 0x1FB1, 0x8a80, 0x103c, "NVIDIA T600" },
    { 0x1FB1, 0x1488, 0x10de, "NVIDIA T600" },
    { 0x1FB1, 0x1488, 0x17aa, "NVIDIA T600" },
    { 0x1FB2, 0x1489, 0x1028, "NVIDIA T400" },
    { 0x1FB2, 0x1489, 0x103c, "NVIDIA T400" },
    { 0x1FB2, 0x8a80, 0x103c, "NVIDIA T400" },
    { 0x1FB2, 0x1489, 0x10de, "NVIDIA T400" },
    { 0x1FB2, 0x1489, 0x17aa, "NVIDIA T400" },
    { 0x1FB6, 0x0000, 0x0000, "NVIDIA T600 Laptop GPU" },
    { 0x1FB7, 0x0000, 0x0000, "NVIDIA T550 Laptop GPU" },
    { 0x1FB8, 0x0000, 0x0000, "Quadro T2000" },
    { 0x1FB8, 0x097e, 0x1028, "Quadro T2000 with Max-Q Design" },
    { 0x1FB8, 0x8736, 0x103c, "Quadro T2000 with Max-Q Design" },
    { 0x1FB8, 0x8738, 0x103c, "Quadro T2000 with Max-Q Design" },
    { 0x1FB8, 0x8772, 0x103c, "Quadro T2000 with Max-Q Design" },
    { 0x1FB8, 0x8780, 0x103c, "Quadro T2000 with Max-Q Design" },
    { 0x1FB8, 0x8782, 0x103c, "Quadro T2000 with Max-Q Design" },
    { 0x1FB8, 0x8783, 0x103c, "Quadro T2000 with Max-Q Design" },
    { 0x1FB8, 0x8785, 0x103c, "Quadro T2000 with Max-Q Design" },
    { 0x1FB8, 0x87f0, 0x103c, "Quadro T2000 with Max-Q Design" },
    { 0x1FB8, 0x1281, 0x1462, "Quadro T2000 with Max-Q Design" },
    { 0x1FB8, 0x12bd, 0x1462, "Quadro T2000 with Max-Q Design" },
    { 0x1FB8, 0x22c0, 0x17aa, "Quadro T2000 with Max-Q Design" },
    { 0x1FB8, 0x22c1, 0x17aa, "Quadro T2000 with Max-Q Design" },
    { 0x1FB9, 0x0000, 0x0000, "Quadro T1000" },
    { 0x1FB9, 0x1479, 0x1025, "Quadro T1000 with Max-Q Design" },
    { 0x1FB9, 0x147a, 0x1025, "Quadro T1000 with Max-Q Design" },
    { 0x1FB9, 0x147b, 0x1025, "Quadro T1000 with Max-Q Design" },
    { 0x1FB9, 0x147c, 0x1025, "Quadro T1000 with Max-Q Design" },
    { 0x1FB9, 0x8736, 0x103c, "Quadro T1000 with Max-Q Design" },
    { 0x1FB9, 0x8738, 0x103c, "Quadro T1000 with Max-Q Design" },
    { 0x1FB9, 0x8772, 0x103c, "Quadro T1000 with Max-Q Design" },
    { 0x1FB9, 0x8780, 0x103c, "Quadro T1000 with Max-Q Design" },
    { 0x1FB9, 0x8782, 0x103c, "Quadro T1000 with Max-Q Design" },
    { 0x1FB9, 0x8783, 0x103c, "Quadro T1000 with Max-Q Design" },
    { 0x1FB9, 0x8785, 0x103c, "Quadro T1000 with Max-Q Design" },
    { 0x1FB9, 0x87f0, 0x103c, "Quadro T1000 with Max-Q Design" },
    { 0x1FB9, 0x12bd, 0x1462, "Quadro T1000 with Max-Q Design" },
    { 0x1FB9, 0x22c0, 0x17aa, "Quadro T1000 with Max-Q Design" },
    { 0x1FB9, 0x22c1, 0x17aa, "Quadro T1000 with Max-Q Design" },
    { 0x1FBA, 0x0000, 0x0000, "NVIDIA T600 Laptop GPU" },
    { 0x1FBB, 0x0000, 0x0000, "NVIDIA T500" },
    { 0x1FBC, 0x0000, 0x0000, "NVIDIA T1200 Laptop GPU" },
    { 0x1FDD, 0x0000, 0x0000, "NVIDIA GeForce GTX 1650" },
    { 0x1FF0, 0x1612, 0x1028, "NVIDIA T1000 8GB" },
    { 0x1FF0, 0x1612, 0x103c, "NVIDIA T1000 8GB" },
    { 0x1FF0, 0x8a80, 0x103c, "NVIDIA T1000 8GB" },
    { 0x1FF0, 0x1612, 0x10de, "NVIDIA T1000 8GB" },
    { 0x1FF0, 0x1612, 0x17aa, "NVIDIA T1000 8GB" },
    { 0x1FF2, 0x1613, 0x1028, "NVIDIA T400 4GB" },
    { 0x1FF2, 0x1613, 0x103c, "NVIDIA T400 4GB" },
    { 0x1FF2, 0x18ff, 0x103c, "NVIDIA T400E" },
    { 0x1FF2, 0x8a80, 0x103c, "NVIDIA T400 4GB" },
    { 0x1FF2, 0x1613, 0x10de, "NVIDIA T400 4GB" },
    { 0x1FF2, 0x18ff, 0x10de, "NVIDIA T400E" },
    { 0x1FF2, 0x1613, 0x17aa, "NVIDIA T400 4GB" },
    { 0x1FF2, 0x18ff, 0x17aa, "NVIDIA T400E" },
    { 0x1FF9, 0x0000, 0x0000, "Quadro T1000" },
    { 0x20B0, 0x0000, 0x0000, "NVIDIA A100-SXM4-40GB" },
    { 0x20B0, 0x1450, 0x10de, "NVIDIA A100-PG509-200" },
    { 0x20B2, 0x1463, 0x10de, "NVIDIA A100-SXM4-80GB" },
    { 0x20B2, 0x147f, 0x10de, "NVIDIA A100-SXM4-80GB" },
    { 0x20B2, 0x1622, 0x10de, "NVIDIA A100-SXM4-80GB" },
    { 0x20B2, 0x1623, 0x10de, "NVIDIA A100-SXM4-80GB" },
    { 0x20B2, 0x1625, 0x10de, "NVIDIA PG509-210" },
    { 0x20B3, 0x14a7, 0x10de, "NVIDIA A100-SXM-64GB" },
    { 0x20B3, 0x14a8, 0x10de, "NVIDIA A100-SXM-64GB" },
    { 0x20B5, 0x1533, 0x10de, "NVIDIA A100 80GB PCIe" },
    { 0x20B5, 0x1642, 0x10de, "NVIDIA A100 80GB PCIe" },
    { 0x20B6, 0x1492, 0x10de, "NVIDIA PG506-232" },
    { 0x20B7, 0x1532, 0x10de, "NVIDIA A30" },
    { 0x20B7, 0x1804, 0x10de, "NVIDIA A30" },
    { 0x20B7, 0x1852, 0x10de, "NVIDIA A30" },
    { 0x20BD, 0x17f4, 0x10de, "NVIDIA A800-SXM4-40GB" },
    { 0x20F1, 0x145f, 0x10de, "NVIDIA A100-PCIE-40GB" },
    { 0x20F3, 0x179b, 0x10de, "NVIDIA A800-SXM4-80GB" },
    { 0x20F3, 0x179c, 0x10de, "NVIDIA A800-SXM4-80GB" },
    { 0x20F3, 0x179d, 0x10de, "NVIDIA A800-SXM4-80GB" },
    { 0x20F3, 0x179e, 0x10de, "NVIDIA A800-SXM4-80GB" },
    { 0x20F3, 0x179f, 0x10de, "NVIDIA A800-SXM4-80GB" },
    { 0x20F3, 0x17a0, 0x10de, "NVIDIA A800-SXM4-80GB" },
    { 0x20F3, 0x17a1, 0x10de, "NVIDIA A800-SXM4-80GB" },
    { 0x20F3, 0x17a2, 0x10de, "NVIDIA A800-SXM4-80GB" },
    { 0x20F5, 0x1799, 0x10de, "NVIDIA A800 80GB PCIe" },
    { 0x20F5, 0x179a, 0x10de, "NVIDIA A800 80GB PCIe LC" },
    { 0x20F6, 0x180a, 0x1028, "NVIDIA A800 40GB Active" },
    { 0x20F6, 0x180a, 0x103c, "NVIDIA A800 40GB Active" },
    { 0x20F6, 0x180a, 0x10de, "NVIDIA A800 40GB Active" },
    { 0x20F6, 0x180a, 0x17aa, "NVIDIA A800 40GB Active" },
    { 0x20FD, 0x17f8, 0x10de, "NVIDIA AX800" },
    { 0x2182, 0x0000, 0x0000, "NVIDIA GeForce GTX 1660 Ti" },
    { 0x2184, 0x0000, 0x0000, "NVIDIA GeForce GTX 1660" },
    { 0x2187, 0x0000, 0x0000, "NVIDIA GeForce GTX 1650 SUPER" },
    { 0x2188, 0x0000, 0x0000, "NVIDIA GeForce GTX 1650" },
    { 0x2189, 0x0000, 0x0000, "NVIDIA CMP 30HX" },
    { 0x2191, 0x0000, 0x0000, "NVIDIA GeForce GTX 1660 Ti" },
    { 0x2191, 0x0949, 0x1028, "NVIDIA GeForce GTX 1660 Ti with Max-Q Design" },
    { 0x2191, 0x85fb, 0x103c, "NVIDIA GeForce GTX 1660 Ti with Max-Q Design" },
    { 0x2191, 0x85fe, 0x103c, "NVIDIA GeForce GTX 1660 Ti with Max-Q Design" },
    { 0x2191, 0x86d6, 0x103c, "NVIDIA GeForce GTX 1660 Ti with Max-Q Design" },
    { 0x2191, 0x8741, 0x103c, "NVIDIA GeForce GTX 1660 Ti with Max-Q Design" },
    { 0x2191, 0x8744, 0x103c, "NVIDIA GeForce GTX 1660 Ti with Max-Q Design" },
    { 0x2191, 0x878d, 0x103c, "NVIDIA GeForce GTX 1660 Ti with Max-Q Design" },
    { 0x2191, 0x87af, 0x103c, "NVIDIA GeForce GTX 1660 Ti with Max-Q Design" },
    { 0x2191, 0x87b3, 0x103c, "NVIDIA GeForce GTX 1660 Ti with Max-Q Design" },
    { 0x2191, 0x171f, 0x1043, "NVIDIA GeForce GTX 1660 Ti with Max-Q Design" },
    { 0x2191, 0x17ef, 0x1043, "NVIDIA GeForce GTX 1660 Ti with Max-Q Design" },
    { 0x2191, 0x18d1, 0x1043, "NVIDIA GeForce GTX 1660 Ti with Max-Q Design" },
    { 0x2191, 0x0032, 0x1414, "NVIDIA GeForce GTX 1660 Ti with Max-Q Design" },
    { 0x2191, 0x128a, 0x1462, "NVIDIA GeForce GTX 1660 Ti with Max-Q Design" },
    { 0x2191, 0x128b, 0x1462, "NVIDIA GeForce GTX 1660 Ti with Max-Q Design" },
    { 0x2191, 0x12c6, 0x1462, "NVIDIA GeForce GTX 1660 Ti with Max-Q Design" },
    { 0x2191, 0x12cb, 0x1462, "NVIDIA GeForce GTX 1660 Ti with Max-Q Design" },
    { 0x2191, 0x12cc, 0x1462, "NVIDIA GeForce GTX 1660 Ti with Max-Q Design" },
    { 0x2191, 0x12d9, 0x1462, "NVIDIA GeForce GTX 1660 Ti with Max-Q Design" },
    { 0x2191, 0x380c, 0x17aa, "NVIDIA GeForce GTX 1660 Ti with Max-Q Design" },
    { 0x2191, 0x381d, 0x17aa, "NVIDIA GeForce GTX 1660 Ti with Max-Q Design" },
    { 0x2191, 0x381e, 0x17aa, "NVIDIA GeForce GTX 1660 Ti with Max-Q Design" },
    { 0x2192, 0x0000, 0x0000, "NVIDIA GeForce GTX 1650 Ti" },
    { 0x21C4, 0x0000, 0x0000, "NVIDIA GeForce GTX 1660 SUPER" },
    { 0x21D1, 0x0000, 0x0000, "NVIDIA GeForce GTX 1660 Ti" },
    { 0x2203, 0x0000, 0x0000, "NVIDIA GeForce RTX 3090 Ti" },
    { 0x2204, 0x0000, 0x0000, "NVIDIA GeForce RTX 3090" },
    { 0x2206, 0x0000, 0x0000, "NVIDIA GeForce RTX 3080" },
    { 0x2207, 0x0000, 0x0000, "NVIDIA GeForce RTX 3070 Ti" },
    { 0x2208, 0x0000, 0x0000, "NVIDIA GeForce RTX 3080 Ti" },
    { 0x220A, 0x0000, 0x0000, "NVIDIA GeForce RTX 3080" },
    { 0x220D, 0x0000, 0x0000, "NVIDIA CMP 90HX" },
    { 0x2216, 0x0000, 0x0000, "NVIDIA GeForce RTX 3080" },
    { 0x2230, 0x1459, 0x1028, "NVIDIA RTX A6000" },
    { 0x2230, 0x1459, 0x103c, "NVIDIA RTX A6000" },
    { 0x2230, 0x1459, 0x10de, "NVIDIA RTX A6000" },
    { 0x2230, 0x1459, 0x17aa, "NVIDIA RTX A6000" },
    { 0x2231, 0x147e, 0x1028, "NVIDIA RTX A5000" },
    { 0x2231, 0x147e, 0x103c, "NVIDIA RTX A5000" },
    { 0x2231, 0x147e, 0x10de, "NVIDIA RTX A5000" },
    { 0x2231, 0x147e, 0x17aa, "NVIDIA RTX A5000" },
    { 0x2232, 0x163c, 0x1028, "NVIDIA RTX A4500" },
    { 0x2232, 0x163c, 0x103c, "NVIDIA RTX A4500" },
    { 0x2232, 0x163c, 0x10de, "NVIDIA RTX A4500" },
    { 0x2232, 0x163c, 0x17aa, "NVIDIA RTX A4500" },
    { 0x2233, 0x165a, 0x1028, "NVIDIA RTX A5500" },
    { 0x2233, 0x165a, 0x103c, "NVIDIA RTX A5500" },
    { 0x2233, 0x165a, 0x10de, "NVIDIA RTX A5500" },
    { 0x2233, 0x165a, 0x17aa, "NVIDIA RTX A5500" },
    { 0x2235, 0x145a, 0x10de, "NVIDIA A40" },
    { 0x2236, 0x1482, 0x10de, "NVIDIA A10" },
    { 0x2237, 0x152f, 0x10de, "NVIDIA A10G" },
    { 0x2238, 0x1677, 0x10de, "NVIDIA A10M" },
    { 0x2321, 0x1839, 0x10de, "NVIDIA H100 NVL" },
    { 0x2322, 0x17a4, 0x10de, "NVIDIA H800 PCIe" },
    { 0x2324, 0x17a6, 0x10de, "NVIDIA H800" },
    { 0x2324, 0x17a8, 0x10de, "NVIDIA H800" },
    { 0x2329, 0x198b, 0x10de, "NVIDIA H20" },
    { 0x2329, 0x198c, 0x10de, "NVIDIA H20" },
    { 0x232C, 0x2063, 0x10de, "NVIDIA H20-3e" },
    { 0x2330, 0x16c0, 0x10de, "NVIDIA H100 80GB HBM3" },
    { 0x2330, 0x16c1, 0x10de, "NVIDIA H100 80GB HBM3" },
    { 0x2331, 0x1626, 0x10de, "NVIDIA H100 PCIe" },
    { 0x2335, 0x18be, 0x10de, "NVIDIA H200" },
    { 0x2335, 0x18bf, 0x10de, "NVIDIA H200" },
    { 0x2339, 0x17fc, 0x10de, "NVIDIA H100" },
    { 0x233A, 0x183a, 0x10de, "NVIDIA H800 NVL" },
    { 0x233B, 0x1996, 0x10de, "NVIDIA H200 NVL" },
    { 0x2342, 0x16eb, 0x10de, "NVIDIA GH200 120GB" },
    { 0x2342, 0x1805, 0x10de, "NVIDIA GH200 120GB" },
    { 0x2342, 0x1809, 0x10de, "NVIDIA GH200 480GB" },
    { 0x2348, 0x18d2, 0x10de, "NVIDIA GH200 144G HBM3e" },
    { 0x2414, 0x0000, 0x0000, "NVIDIA GeForce RTX 3060 Ti" },
    { 0x2420, 0x0000, 0x0000, "NVIDIA GeForce RTX 3080 Ti Laptop GPU" },
    { 0x2438, 0x0000, 0x0000, "NVIDIA RTX A5500 Laptop GPU" },
    { 0x2460, 0x0000, 0x0000, "NVIDIA GeForce RTX 3080 Ti Laptop GPU" },
    { 0x2482, 0x0000, 0x0000, "NVIDIA GeForce RTX 3070 Ti" },
    { 0x2484, 0x0000, 0x0000, "NVIDIA GeForce RTX 3070" },
    { 0x2486, 0x0000, 0x0000, "NVIDIA GeForce RTX 3060 Ti" },
    { 0x2487, 0x0000, 0x0000, "NVIDIA GeForce RTX 3060" },
    { 0x2488, 0x0000, 0x0000, "NVIDIA GeForce RTX 3070" },
    { 0x2489, 0x0000, 0x0000, "NVIDIA GeForce RTX 3060 Ti" },
    { 0x248A, 0x0000, 0x0000, "NVIDIA CMP 70HX" },
    { 0x249C, 0x0000, 0x0000, "NVIDIA GeForce RTX 3080 Laptop GPU" },
    { 0x249C, 0x1194, 0x1d05, "NVIDIA GeForce RTX 3060 Laptop GPU" },
    { 0x249D, 0x0000, 0x0000, "NVIDIA GeForce RTX 3070 Laptop GPU" },
    { 0x24A0, 0x0000, 0x0000, "NVIDIA GeForce RTX 3070 Ti Laptop GPU" },
    { 0x24A0, 0x1192, 0x1d05, "NVIDIA GeForce RTX 3060 Laptop GPU" },
    { 0x24B0, 0x14ad, 0x1028, "NVIDIA RTX A4000" },
    { 0x24B0, 0x14ad, 0x103c, "NVIDIA RTX A4000" },
    { 0x24B0, 0x14ad, 0x10de, "NVIDIA RTX A4000" },
    { 0x24B0, 0x14ad, 0x17aa, "NVIDIA RTX A4000" },
    { 0x24B1, 0x1658, 0x10de, "NVIDIA RTX A4000H" },
    { 0x24B6, 0x0000, 0x0000, "NVIDIA RTX A5000 Laptop GPU" },
    { 0x24B7, 0x0000, 0x0000, "NVIDIA RTX A4000 Laptop GPU" },
    { 0x24B8, 0x0000, 0x0000, "NVIDIA RTX A3000 Laptop GPU" },
    { 0x24B9, 0x0000, 0x0000, "NVIDIA RTX A3000 12GB Laptop GPU" },
    { 0x24BA, 0x0000, 0x0000, "NVIDIA RTX A4500 Laptop GPU" },
    { 0x24BB, 0x0000, 0x0000, "NVIDIA RTX A3000 12GB Laptop GPU" },
    { 0x24C7, 0x0000, 0x0000, "NVIDIA GeForce RTX 3060" },
    { 0x24C9, 0x0000, 0x0000, "NVIDIA GeForce RTX 3060 Ti" },
    { 0x24DC, 0x0000, 0x0000, "NVIDIA GeForce RTX 3080 Laptop GPU" },
    { 0x24DD, 0x0000, 0x0000, "NVIDIA GeForce RTX 3070 Laptop GPU" },
    { 0x24E0, 0x0000, 0x0000, "NVIDIA GeForce RTX 3070 Ti Laptop GPU" },
    { 0x24FA, 0x0000, 0x0000, "NVIDIA RTX A4500 Embedded GPU" },
    { 0x2503, 0x0000, 0x0000, "NVIDIA GeForce RTX 3060" },
    { 0x2504, 0x0000, 0x0000, "NVIDIA GeForce RTX 3060" },
    { 0x2507, 0x0000, 0x0000, "NVIDIA GeForce RTX 3050" },
    { 0x2508, 0x0000, 0x0000, "NVIDIA GeForce RTX 3050 OEM" },
    { 0x2520, 0x0000, 0x0000, "NVIDIA GeForce RTX 3060 Laptop GPU" },
    { 0x2521, 0x0000, 0x0000, "NVIDIA GeForce RTX 3060 Laptop GPU" },
    { 0x2523, 0x0000, 0x0000, "NVIDIA GeForce RTX 3050 Ti Laptop GPU" },
    { 0x2531, 0x151d, 0x1028, "NVIDIA RTX A2000" },
    { 0x2531, 0x151d, 0x103c, "NVIDIA RTX A2000" },
    { 0x2531, 0x151d, 0x10de, "NVIDIA RTX A2000" },
    { 0x2531, 0x151d, 0x17aa, "NVIDIA RTX A2000" },
    { 0x2544, 0x0000, 0x0000, "NVIDIA GeForce RTX 3060" },
    { 0x2560, 0x0000, 0x0000, "NVIDIA GeForce RTX 3060 Laptop GPU" },
    { 0x2563, 0x0000, 0x0000, "NVIDIA GeForce RTX 3050 Ti Laptop GPU" },
    { 0x2571, 0x1611, 0x1028, "NVIDIA RTX A2000 12GB" },
    { 0x2571, 0x1611, 0x103c, "NVIDIA RTX A2000 12GB" },
    { 0x2571, 0x1611, 0x10de, "NVIDIA RTX A2000 12GB" },
    { 0x2571, 0x1611, 0x17aa, "NVIDIA RTX A2000 12GB" },
    { 0x2582, 0x0000, 0x0000, "NVIDIA GeForce RTX 3050" },
    { 0x2584, 0x0000, 0x0000, "NVIDIA GeForce RTX 3050" },
    { 0x25A0, 0x0000, 0x0000, "NVIDIA GeForce RTX 3050 Ti Laptop GPU" },
    { 0x25A0, 0x8928, 0x103c, "NVIDIA GeForce RTX 3050Ti Laptop GPU" },
    { 0x25A0, 0x89f9, 0x103c, "NVIDIA GeForce RTX 3050Ti Laptop GPU" },
    { 0x25A0, 0x1196, 0x1d05, "NVIDIA GeForce RTX 3060 Laptop GPU" },
    { 0x25A2, 0x0000, 0x0000, "NVIDIA GeForce RTX 3050 Laptop GPU" },
    { 0x25A2, 0x0baf, 0x1028, "NVIDIA GeForce RTX 3050 Ti Laptop GPU" },
    { 0x25A2, 0x1195, 0x1d05, "NVIDIA GeForce RTX 3060 Laptop GPU" },
    { 0x25A5, 0x0000, 0x0000, "NVIDIA GeForce RTX 3050 Laptop GPU" },
    { 0x25A6, 0x0000, 0x0000, "NVIDIA GeForce MX570" },
    { 0x25A7, 0x0000, 0x0000, "NVIDIA GeForce RTX 2050" },
    { 0x25A9, 0x0000, 0x0000, "NVIDIA GeForce RTX 2050" },
    { 0x25AA, 0x0000, 0x0000, "NVIDIA GeForce MX570 A" },
    { 0x25AB, 0x0000, 0x0000, "NVIDIA GeForce RTX 3050 4GB Laptop GPU" },
    { 0x25AC, 0x0000, 0x0000, "NVIDIA GeForce RTX 3050 6GB Laptop GPU" },
    { 0x25AD, 0x0000, 0x0000, "NVIDIA GeForce RTX 2050" },
    { 0x25B0, 0x1878, 0x1028, "NVIDIA RTX A1000" },
    { 0x25B0, 0x1878, 0x103c, "NVIDIA RTX A1000" },
    { 0x25B0, 0x8d96, 0x103c, "NVIDIA RTX A1000" },
    { 0x25B0, 0x1878, 0x10de, "NVIDIA RTX A1000" },
    { 0x25B0, 0x1878, 0x17aa, "NVIDIA RTX A1000" },
    { 0x25B2, 0x1879, 0x1028, "NVIDIA RTX A400" },
    { 0x25B2, 0x1879, 0x103c, "NVIDIA RTX A400" },
    { 0x25B2, 0x8d95, 0x103c, "NVIDIA RTX A400" },
    { 0x25B2, 0x1879, 0x10de, "NVIDIA RTX A400" },
    { 0x25B2, 0x1879, 0x17aa, "NVIDIA RTX A400" },
    { 0x25B6, 0x14a9, 0x10de, "NVIDIA A16" },
    { 0x25B6, 0x157e, 0x10de, "NVIDIA A2" },
    { 0x25B8, 0x0000, 0x0000, "NVIDIA RTX A2000 Laptop GPU" },
    { 0x25B9, 0x0000, 0x0000, "NVIDIA RTX A1000 Laptop GPU" },
    { 0x25BA, 0x0000, 0x0000, "NVIDIA RTX A2000 8GB Laptop GPU" },
    { 0x25BB, 0x0000, 0x0000, "NVIDIA RTX A500 Laptop GPU" },
    { 0x25BC, 0x0000, 0x0000, "NVIDIA RTX A1000 6GB Laptop GPU" },
    { 0x25BD, 0x0000, 0x0000, "NVIDIA RTX A500 Laptop GPU" },
    { 0x25E0, 0x0000, 0x0000, "NVIDIA GeForce RTX 3050 Ti Laptop GPU" },
    { 0x25E2, 0x0000, 0x0000, "NVIDIA GeForce RTX 3050 Laptop GPU" },
    { 0x25E5, 0x0000, 0x0000, "NVIDIA GeForce RTX 3050 Laptop GPU" },
    { 0x25EC, 0x0000, 0x0000, "NVIDIA GeForce RTX 3050 6GB Laptop GPU" },
    { 0x25ED, 0x0000, 0x0000, "NVIDIA GeForce RTX 2050" },
    { 0x25F9, 0x0000, 0x0000, "NVIDIA RTX A1000 Embedded GPU" },
    { 0x25FA, 0x0000, 0x0000, "NVIDIA RTX A2000 Embedded GPU" },
    { 0x25FB, 0x0000, 0x0000, "NVIDIA RTX A500 Embedded GPU" },
    { 0x2684, 0x0000, 0x0000, "NVIDIA GeForce RTX 4090" },
    { 0x2685, 0x0000, 0x0000, "NVIDIA GeForce RTX 4090 D" },
    { 0x2689, 0x0000, 0x0000, "NVIDIA GeForce RTX 4070 Ti SUPER" },
    { 0x26B1, 0x16a1, 0x1028, "NVIDIA RTX 6000 Ada Generation" },
    { 0x26B1, 0x16a1, 0x103c, "NVIDIA RTX 6000 Ada Generation" },
    { 0x26B1, 0x16a1, 0x10de, "NVIDIA RTX 6000 Ada Generation" },
    { 0x26B1, 0x16a1, 0x17aa, "NVIDIA RTX 6000 Ada Generation" },
    { 0x26B2, 0x17fa, 0x1028, "NVIDIA RTX 5000 Ada Generation" },
    { 0x26B2, 0x17fa, 0x103c, "NVIDIA RTX 5000 Ada Generation" },
    { 0x26B2, 0x17fa, 0x10de, "NVIDIA RTX 5000 Ada Generation" },
    { 0x26B2, 0x17fa, 0x17aa, "NVIDIA RTX 5000 Ada Generation" },
    { 0x26B3, 0x1934, 0x1028, "NVIDIA RTX 5880 Ada Generation" },
    { 0x26B3, 0x1934, 0x103c, "NVIDIA RTX 5880 Ada Generation" },
    { 0x26B3, 0x1934, 0x10de, "NVIDIA RTX 5880 Ada Generation" },
    { 0x26B3, 0x1934, 0x17aa, "NVIDIA RTX 5880 Ada Generation" },
    { 0x26B5, 0x169d, 0x10de, "NVIDIA L40" },
    { 0x26B5, 0x17da, 0x10de, "NVIDIA L40" },
    { 0x26B9, 0x1851, 0x10de, "NVIDIA L40S" },
    { 0x26B9, 0x18cf, 0x10de, "NVIDIA L40S" },
    { 0x26BA, 0x1957, 0x10de, "NVIDIA L20" },
    { 0x26BA, 0x1990, 0x10de, "NVIDIA L20" },
    { 0x2702, 0x0000, 0x0000, "NVIDIA GeForce RTX 4080 SUPER" },
    { 0x2704, 0x0000, 0x0000, "NVIDIA GeForce RTX 4080" },
    { 0x2705, 0x0000, 0x0000, "NVIDIA GeForce RTX 4070 Ti SUPER" },
    { 0x2709, 0x0000, 0x0000, "NVIDIA GeForce RTX 4070" },
    { 0x2717, 0x0000, 0x0000, "NVIDIA GeForce RTX 4090 Laptop GPU" },
    { 0x2730, 0x0000, 0x0000, "NVIDIA RTX 5000 Ada Generation Laptop GPU" },
    { 0x2757, 0x0000, 0x0000, "NVIDIA GeForce RTX 4090 Laptop GPU" },
    { 0x2770, 0x0000, 0x0000, "NVIDIA RTX 5000 Ada Generation Embedded GPU" },
    { 0x2782, 0x0000, 0x0000, "NVIDIA GeForce RTX 4070 Ti" },
    { 0x2783, 0x0000, 0x0000, "NVIDIA GeForce RTX 4070 SUPER" },
    { 0x2786, 0x0000, 0x0000, "NVIDIA GeForce RTX 4070" },
    { 0x2788, 0x0000, 0x0000, "NVIDIA GeForce RTX 4060 Ti" },
    { 0x27A0, 0x0000, 0x0000, "NVIDIA GeForce RTX 4080 Laptop GPU" },
    { 0x27B0, 0x16fa, 0x1028, "NVIDIA RTX 4000 SFF Ada Generation" },
    { 0x27B0, 0x16fa, 0x103c, "NVIDIA RTX 4000 SFF Ada Generation" },
    { 0x27B0, 0x16fa, 0x10de, "NVIDIA RTX 4000 SFF Ada Generation" },
    { 0x27B0, 0x16fa, 0x17aa, "NVIDIA RTX 4000 SFF Ada Generation" },
    { 0x27B1, 0x180c, 0x1028, "NVIDIA RTX 4500 Ada Generation" },
    { 0x27B1, 0x180c, 0x103c, "NVIDIA RTX 4500 Ada Generation" },
    { 0x27B1, 0x180c, 0x10de, "NVIDIA RTX 4500 Ada Generation" },
    { 0x27B1, 0x180c, 0x17aa, "NVIDIA RTX 4500 Ada Generation" },
    { 0x27B2, 0x181b, 0x1028, "NVIDIA RTX 4000 Ada Generation" },
    { 0x27B2, 0x181b, 0x103c, "NVIDIA RTX 4000 Ada Generation" },
    { 0x27B2, 0x181b, 0x10de, "NVIDIA RTX 4000 Ada Generation" },
    { 0x27B2, 0x181b, 0x17aa, "NVIDIA RTX 4000 Ada Generation" },
    { 0x27B6, 0x1933, 0x10de, "NVIDIA L2" },
    { 0x27B8, 0x16ca, 0x10de, "NVIDIA L4" },
    { 0x27B8, 0x16ee, 0x10de, "NVIDIA L4" },
    { 0x27BA, 0x0000, 0x0000, "NVIDIA RTX 4000 Ada Generation Laptop GPU" },
    { 0x27BB, 0x0000, 0x0000, "NVIDIA RTX 3500 Ada Generation Laptop GPU" },
    { 0x27E0, 0x0000, 0x0000, "NVIDIA GeForce RTX 4080 Laptop GPU" },
    { 0x27FB, 0x0000, 0x0000, "NVIDIA RTX 3500 Ada Generation Embedded GPU" },
    { 0x2803, 0x0000, 0x0000, "NVIDIA GeForce RTX 4060 Ti" },
    { 0x2805, 0x0000, 0x0000, "NVIDIA GeForce RTX 4060 Ti" },
    { 0x2808, 0x0000, 0x0000, "NVIDIA GeForce RTX 4060" },
    { 0x2820, 0x0000, 0x0000, "NVIDIA GeForce RTX 4070 Laptop GPU" },
    { 0x2822, 0x0000, 0x0000, "NVIDIA GeForce RTX 3050 A Laptop GPU" },
    { 0x2838, 0x0000, 0x0000, "NVIDIA RTX 3000 Ada Generation Laptop GPU" },
    { 0x2860, 0x0000, 0x0000, "NVIDIA GeForce RTX 4070 Laptop GPU" },
    { 0x2882, 0x0000, 0x0000, "NVIDIA GeForce RTX 4060" },
    { 0x28A0, 0x0000, 0x0000, "NVIDIA GeForce RTX 4060 Laptop GPU" },
    { 0x28A1, 0x0000, 0x0000, "NVIDIA GeForce RTX 4050 Laptop GPU" },
    { 0x28A3, 0x0000, 0x0000, "NVIDIA GeForce RTX 3050 A Laptop GPU" },
    { 0x28B0, 0x1870, 0x1028, "NVIDIA RTX 2000 Ada Generation" },
    { 0x28B0, 0x1870, 0x103c, "NVIDIA RTX 2000 Ada Generation" },
    { 0x28B0, 0x1871, 0x103c, "NVIDIA RTX 2000E Ada Generation" },
    { 0x28B0, 0x1870, 0x10de, "NVIDIA RTX 2000 Ada Generation" },
    { 0x28B0, 0x1871, 0x10de, "NVIDIA RTX 2000E Ada Generation" },
    { 0x28B0, 0x1870, 0x17aa, "NVIDIA RTX 2000 Ada Generation" },
    { 0x28B0, 0x1871, 0x17aa, "NVIDIA RTX 2000E Ada Generation" },
    { 0x28B8, 0x0000, 0x0000, "NVIDIA RTX 2000 Ada Generation Laptop GPU" },
    { 0x28B9, 0x0000, 0x0000, "NVIDIA RTX 1000 Ada Generation Laptop GPU" },
    { 0x28BA, 0x0000, 0x0000, "NVIDIA RTX 500 Ada Generation Laptop GPU" },
    { 0x28BB, 0x0000, 0x0000, "NVIDIA RTX 500 Ada Generation Laptop GPU" },
    { 0x28E0, 0x0000, 0x0000, "NVIDIA GeForce RTX 4060 Laptop GPU" },
    { 0x28E1, 0x0000, 0x0000, "NVIDIA GeForce RTX 4050 Laptop GPU" },
    { 0x28E3, 0x0000, 0x0000, "NVIDIA GeForce RTX 3050 A Laptop GPU" },
    { 0x28F8, 0x0000, 0x0000, "NVIDIA RTX 2000 Ada Generation Embedded GPU" },
    { 0x2901, 0x1999, 0x10de, "NVIDIA B200" },
    { 0x2901, 0x199b, 0x10de, "NVIDIA B200" },
    { 0x2901, 0x20da, 0x10de, "NVIDIA B200" },
    { 0x2941, 0x2046, 0x10de, "NVIDIA GB200" },
    { 0x2941, 0x20ca, 0x10de, "NVIDIA GB200" },
    { 0x2941, 0x20d5, 0x10de, "NVIDIA GB200" },
    { 0x2941, 0x21c9, 0x10de, "NVIDIA GB200" },
    { 0x2941, 0x21ca, 0x10de, "NVIDIA GB200" },
    { 0x2B85, 0x0000, 0x0000, "NVIDIA GeForce RTX 5090" },
    { 0x2B87, 0x0000, 0x0000, "NVIDIA GeForce RTX 5090 D" },
    { 0x2BB1, 0x204b, 0x1028, "NVIDIA RTX PRO 6000 Blackwell Workstation Edition" },
    { 0x2BB1, 0x204b, 0x103c, "NVIDIA RTX PRO 6000 Blackwell Workstation Edition" },
    { 0x2BB1, 0x204b, 0x10de, "NVIDIA RTX PRO 6000 Blackwell Workstation Edition" },
    { 0x2BB1, 0x204b, 0x17aa, "NVIDIA RTX PRO 6000 Blackwell Workstation Edition" },
    { 0x2BB3, 0x204d, 0x1028, "NVIDIA RTX PRO 5000 Blackwell" },
    { 0x2BB3, 0x204d, 0x103c, "NVIDIA RTX PRO 5000 Blackwell" },
    { 0x2BB3, 0x204d, 0x10de, "NVIDIA RTX PRO 5000 Blackwell" },
    { 0x2BB3, 0x204d, 0x17aa, "NVIDIA RTX PRO 5000 Blackwell" },
    { 0x2BB4, 0x204c, 0x1028, "NVIDIA RTX PRO 6000 Blackwell Max-Q Workstation Edition" },
    { 0x2BB4, 0x204c, 0x103c, "NVIDIA RTX PRO 6000 Blackwell Max-Q Workstation Edition" },
    { 0x2BB4, 0x204c, 0x10de, "NVIDIA RTX PRO 6000 Blackwell Max-Q Workstation Edition" },
    { 0x2BB4, 0x204c, 0x17aa, "NVIDIA RTX PRO 6000 Blackwell Max-Q Workstation Edition" },
    { 0x2C02, 0x0000, 0x0000, "NVIDIA GeForce RTX 5080" },
    { 0x2C05, 0x0000, 0x0000, "NVIDIA GeForce RTX 5070 Ti" },
    { 0x2C18, 0x0000, 0x0000, "NVIDIA GeForce RTX 5090 Laptop GPU" },
    { 0x2C19, 0x0000, 0x0000, "NVIDIA GeForce RTX 5080 Laptop GPU" },
    { 0x2C38, 0x0000, 0x0000, "NVIDIA RTX PRO 5000 Blackwell Generation Laptop GPU" },
    { 0x2C39, 0x0000, 0x0000, "NVIDIA RTX PRO 4000 Blackwell Generation Laptop GPU" },
    { 0x2C58, 0x0000, 0x0000, "NVIDIA GeForce RTX 5090 Laptop GPU" },
    { 0x2C59, 0x0000, 0x0000, "NVIDIA GeForce RTX 5080 Laptop GPU" },
    { 0x2D04, 0x0000, 0x0000, "NVIDIA GeForce RTX 5060 Ti" },
    { 0x2D05, 0x0000, 0x0000, "NVIDIA GeForce RTX 5060" },
    { 0x2D18, 0x0000, 0x0000, "NVIDIA GeForce RTX 5070 Laptop GPU" },
    { 0x2D19, 0x0000, 0x0000, "NVIDIA GeForce RTX 5060 Laptop GPU" },
    { 0x2D39, 0x0000, 0x0000, "NVIDIA RTX PRO 2000 Blackwell Generation Laptop GPU" },
    { 0x2D58, 0x0000, 0x0000, "NVIDIA GeForce RTX 5070 Laptop GPU" },
    { 0x2D59, 0x0000, 0x0000, "NVIDIA GeForce RTX 5060 Laptop GPU" },
    { 0x2DB8, 0x0000, 0x0000, "NVIDIA RTX PRO 1000 Blackwell Generation Laptop GPU" },
    { 0x2DB9, 0x0000, 0x0000, "NVIDIA RTX PRO 500 Blackwell Generation Laptop GPU" },
    { 0x2F04, 0x0000, 0x0000, "NVIDIA GeForce RTX 5070" },
    { 0x2F18, 0x0000, 0x0000, "NVIDIA GeForce RTX 5070 Ti Laptop GPU" },
    { 0x2F38, 0x0000, 0x0000, "NVIDIA RTX PRO 3000 Blackwell Generation Laptop GPU" },
    { 0x2F58, 0x0000, 0x0000, "NVIDIA GeForce RTX 5070 Ti Laptop GPU" },
    { 0x13BD, 0x11cc, 0x10DE, "GRID M10-0B" },
    { 0x13BD, 0x11cd, 0x10DE, "GRID M10-1B" },
    { 0x13BD, 0x11ce, 0x10DE, "GRID M10-0Q" },
    { 0x13BD, 0x11cf, 0x10DE, "GRID M10-1Q" },
    { 0x13BD, 0x11d0, 0x10DE, "GRID M10-2Q" },
    { 0x13BD, 0x11d1, 0x10DE, "GRID M10-4Q" },
    { 0x13BD, 0x11d2, 0x10DE, "GRID M10-8Q" },
    { 0x13BD, 0x11d3, 0x10DE, "GRID M10-1A" },
    { 0x13BD, 0x11d4, 0x10DE, "GRID M10-2A" },
    { 0x13BD, 0x11d5, 0x10DE, "GRID M10-4A" },
    { 0x13BD, 0x11d6, 0x10DE, "GRID M10-8A" },
    { 0x13BD, 0x1286, 0x10DE, "GRID M10-2B" },
    { 0x13BD, 0x12ee, 0x10DE, "GRID M10-2B4" },
    { 0x13BD, 0x1339, 0x10DE, "GRID M10-1B4" },
    { 0x1DB1, 0x1259, 0x10DE, "GRID V100X-1B" },
    { 0x1DB1, 0x125a, 0x10DE, "GRID V100X-1Q" },
    { 0x1DB1, 0x125b, 0x10DE, "GRID V100X-2Q" },
    { 0x1DB1, 0x125c, 0x10DE, "GRID V100X-4Q" },
    { 0x1DB1, 0x125d, 0x10DE, "GRID V100X-8Q" },
    { 0x1DB1, 0x125e, 0x10DE, "GRID V100X-16Q" },
    { 0x1DB1, 0x125f, 0x10DE, "GRID V100X-1A" },
    { 0x1DB1, 0x1260, 0x10DE, "GRID V100X-2A" },
    { 0x1DB1, 0x1261, 0x10DE, "GRID V100X-4A" },
    { 0x1DB1, 0x1262, 0x10DE, "GRID V100X-8A" },
    { 0x1DB1, 0x1263, 0x10DE, "GRID V100X-16A" },
    { 0x1DB1, 0x128e, 0x10DE, "GRID V100X-2B" },
    { 0x1DB1, 0x12f6, 0x10DE, "GRID V100X-2B4" },
    { 0x1DB1, 0x1341, 0x10DE, "GRID V100X-1B4" },
    { 0x1DB1, 0x1378, 0x10DE, "GRID V100X-16C" },
    { 0x1DB1, 0x138e, 0x10DE, "GRID V100X-4C" },
    { 0x1DB1, 0x138f, 0x10DE, "GRID V100X-8C" },
    { 0x1DB3, 0x1290, 0x10DE, "GRID V100L-1B" },
    { 0x1DB3, 0x1291, 0x10DE, "GRID V100L-2B" },
    { 0x1DB3, 0x1292, 0x10DE, "GRID V100L-1Q" },
    { 0x1DB3, 0x1293, 0x10DE, "GRID V100L-2Q" },
    { 0x1DB3, 0x1294, 0x10DE, "GRID V100L-4Q" },
    { 0x1DB3, 0x1295, 0x10DE, "GRID V100L-8Q" },
    { 0x1DB3, 0x1296, 0x10DE, "GRID V100L-16Q" },
    { 0x1DB3, 0x1297, 0x10DE, "GRID V100L-1A" },
    { 0x1DB3, 0x1298, 0x10DE, "GRID V100L-2A" },
    { 0x1DB3, 0x1299, 0x10DE, "GRID V100L-4A" },
    { 0x1DB3, 0x129a, 0x10DE, "GRID V100L-8A" },
    { 0x1DB3, 0x129b, 0x10DE, "GRID V100L-16A" },
    { 0x1DB3, 0x12f9, 0x10DE, "GRID V100L-2B4" },
    { 0x1DB3, 0x1344, 0x10DE, "GRID V100L-1B4" },
    { 0x1DB3, 0x137a, 0x10DE, "GRID V100L-16C" },
    { 0x1DB3, 0x1398, 0x10DE, "GRID V100L-4C" },
    { 0x1DB3, 0x1399, 0x10DE, "GRID V100L-8C" },
    { 0x1DB4, 0x124e, 0x10DE, "GRID V100-1B" },
    { 0x1DB4, 0x124f, 0x10DE, "GRID V100-1Q" },
    { 0x1DB4, 0x1250, 0x10DE, "GRID V100-2Q" },
    { 0x1DB4, 0x1251, 0x10DE, "GRID V100-4Q" },
    { 0x1DB4, 0x1252, 0x10DE, "GRID V100-8Q" },
    { 0x1DB4, 0x1253, 0x10DE, "GRID V100-16Q" },
    { 0x1DB4, 0x1254, 0x10DE, "GRID V100-1A" },
    { 0x1DB4, 0x1255, 0x10DE, "GRID V100-2A" },
    { 0x1DB4, 0x1256, 0x10DE, "GRID V100-4A" },
    { 0x1DB4, 0x1257, 0x10DE, "GRID V100-8A" },
    { 0x1DB4, 0x1258, 0x10DE, "GRID V100-16A" },
    { 0x1DB4, 0x128f, 0x10DE, "GRID V100-2B" },
    { 0x1DB4, 0x12f5, 0x10DE, "GRID V100-2B4" },
    { 0x1DB4, 0x1340, 0x10DE, "GRID V100-1B4" },
    { 0x1DB4, 0x1379, 0x10DE, "GRID V100-16C" },
    { 0x1DB4, 0x1393, 0x10DE, "GRID V100-4C" },
    { 0x1DB4, 0x1394, 0x10DE, "GRID V100-8C" },
    { 0x1DB5, 0x12cb, 0x10DE, "GRID V100DX-1B" },
    { 0x1DB5, 0x12cc, 0x10DE, "GRID V100DX-2B" },
    { 0x1DB5, 0x12cd, 0x10DE, "GRID V100DX-1Q" },
    { 0x1DB5, 0x12ce, 0x10DE, "GRID V100DX-2Q" },
    { 0x1DB5, 0x12cf, 0x10DE, "GRID V100DX-4Q" },
    { 0x1DB5, 0x12d0, 0x10DE, "GRID V100DX-8Q" },
    { 0x1DB5, 0x12d1, 0x10DE, "GRID V100DX-16Q" },
    { 0x1DB5, 0x12d2, 0x10DE, "GRID V100DX-32Q" },
    { 0x1DB5, 0x12d3, 0x10DE, "GRID V100DX-1A" },
    { 0x1DB5, 0x12d4, 0x10DE, "GRID V100DX-2A" },
    { 0x1DB5, 0x12d5, 0x10DE, "GRID V100DX-4A" },
    { 0x1DB5, 0x12d6, 0x10DE, "GRID V100DX-8A" },
    { 0x1DB5, 0x12d7, 0x10DE, "GRID V100DX-16A" },
    { 0x1DB5, 0x12d8, 0x10DE, "GRID V100DX-32A" },
    { 0x1DB5, 0x12f8, 0x10DE, "GRID V100DX-2B4" },
    { 0x1DB5, 0x1343, 0x10DE, "GRID V100DX-1B4" },
    { 0x1DB5, 0x1376, 0x10DE, "GRID V100DX-32C" },
    { 0x1DB5, 0x1390, 0x10DE, "GRID V100DX-4C" },
    { 0x1DB5, 0x1391, 0x10DE, "GRID V100DX-8C" },
    { 0x1DB5, 0x1392, 0x10DE, "GRID V100DX-16C" },
    { 0x1DB6, 0x12bd, 0x10DE, "GRID V100D-1B" },
    { 0x1DB6, 0x12be, 0x10DE, "GRID V100D-2B" },
    { 0x1DB6, 0x12bf, 0x10DE, "GRID V100D-1Q" },
    { 0x1DB6, 0x12c0, 0x10DE, "GRID V100D-2Q" },
    { 0x1DB6, 0x12c1, 0x10DE, "GRID V100D-4Q" },
    { 0x1DB6, 0x12c2, 0x10DE, "GRID V100D-8Q" },
    { 0x1DB6, 0x12c3, 0x10DE, "GRID V100D-16Q" },
    { 0x1DB6, 0x12c4, 0x10DE, "GRID V100D-32Q" },
    { 0x1DB6, 0x12c5, 0x10DE, "GRID V100D-1A" },
    { 0x1DB6, 0x12c6, 0x10DE, "GRID V100D-2A" },
    { 0x1DB6, 0x12c7, 0x10DE, "GRID V100D-4A" },
    { 0x1DB6, 0x12c8, 0x10DE, "GRID V100D-8A" },
    { 0x1DB6, 0x12c9, 0x10DE, "GRID V100D-16A" },
    { 0x1DB6, 0x12ca, 0x10DE, "GRID V100D-32A" },
    { 0x1DB6, 0x12f7, 0x10DE, "GRID V100D-2B4" },
    { 0x1DB6, 0x1342, 0x10DE, "GRID V100D-1B4" },
    { 0x1DB6, 0x1377, 0x10DE, "GRID V100D-32C" },
    { 0x1DB6, 0x1395, 0x10DE, "GRID V100D-4C" },
    { 0x1DB6, 0x1396, 0x10DE, "GRID V100D-8C" },
    { 0x1DB6, 0x1397, 0x10DE, "GRID V100D-16C" },
    { 0x1DB6, 0x13cd, 0x10DE, "GRID GTX V100D-8" },
    { 0x1DB6, 0x13ce, 0x10DE, "GRID GTX V100D-16" },
    { 0x1DB6, 0x13cf, 0x10DE, "GRID GTX V100D-32" },
    { 0x1DF6, 0x13e1, 0x10DE, "GRID V100S-1B" },
    { 0x1DF6, 0x13e3, 0x10DE, "GRID V100S-2B" },
    { 0x1DF6, 0x13e5, 0x10DE, "GRID V100S-1Q" },
    { 0x1DF6, 0x13e6, 0x10DE, "GRID V100S-2Q" },
    { 0x1DF6, 0x13e7, 0x10DE, "GRID V100S-4Q" },
    { 0x1DF6, 0x13e8, 0x10DE, "GRID V100S-8Q" },
    { 0x1DF6, 0x13e9, 0x10DE, "GRID V100S-16Q" },
    { 0x1DF6, 0x13ea, 0x10DE, "GRID V100S-32Q" },
    { 0x1DF6, 0x13eb, 0x10DE, "GRID V100S-1A" },
    { 0x1DF6, 0x13ec, 0x10DE, "GRID V100S-2A" },
    { 0x1DF6, 0x13ed, 0x10DE, "GRID V100S-4A" },
    { 0x1DF6, 0x13ee, 0x10DE, "GRID V100S-8A" },
    { 0x1DF6, 0x13ef, 0x10DE, "GRID V100S-16A" },
    { 0x1DF6, 0x13f0, 0x10DE, "GRID V100S-32A" },
    { 0x1DF6, 0x13f1, 0x10DE, "GRID V100S-4C" },
    { 0x1DF6, 0x13f2, 0x10DE, "GRID V100S-8C" },
    { 0x1DF6, 0x13f3, 0x10DE, "GRID V100S-16C" },
    { 0x1DF6, 0x13f4, 0x10DE, "GRID V100S-32C" },
    { 0x1E30, 0x1325, 0x10DE, "GRID RTX6000-1Q" },
    { 0x1E30, 0x1326, 0x10DE, "GRID RTX6000-2Q" },
    { 0x1E30, 0x1327, 0x10DE, "GRID RTX6000-3Q" },
    { 0x1E30, 0x1328, 0x10DE, "GRID RTX6000-4Q" },
    { 0x1E30, 0x1329, 0x10DE, "GRID RTX6000-6Q" },
    { 0x1E30, 0x132a, 0x10DE, "GRID RTX6000-8Q" },
    { 0x1E30, 0x132b, 0x10DE, "GRID RTX6000-12Q" },
    { 0x1E30, 0x132c, 0x10DE, "GRID RTX6000-24Q" },
    { 0x1E30, 0x132d, 0x10DE, "GRID RTX8000-1Q" },
    { 0x1E30, 0x132e, 0x10DE, "GRID RTX8000-2Q" },
    { 0x1E30, 0x132f, 0x10DE, "GRID RTX8000-3Q" },
    { 0x1E30, 0x1330, 0x10DE, "GRID RTX8000-4Q" },
    { 0x1E30, 0x1331, 0x10DE, "GRID RTX8000-6Q" },
    { 0x1E30, 0x1332, 0x10DE, "GRID RTX8000-8Q" },
    { 0x1E30, 0x1333, 0x10DE, "GRID RTX8000-12Q" },
    { 0x1E30, 0x1334, 0x10DE, "GRID RTX8000-16Q" },
    { 0x1E30, 0x1335, 0x10DE, "GRID RTX8000-24Q" },
    { 0x1E30, 0x1336, 0x10DE, "GRID RTX8000-48Q" },
    { 0x1E30, 0x13b9, 0x10DE, "GRID RTX6000-6" },
    { 0x1E30, 0x13ba, 0x10DE, "GRID RTX6000-12" },
    { 0x1E30, 0x13bb, 0x10DE, "GRID RTX6000-24" },
    { 0x1E30, 0x13bc, 0x10DE, "GRID RTX8000-12" },
    { 0x1E30, 0x13bd, 0x10DE, "GRID RTX8000-24" },
    { 0x1E30, 0x13be, 0x10DE, "GRID RTX8000-48" },
    { 0x1E30, 0x13bf, 0x10DE, "GRID RTX6000-4C" },
    { 0x1E30, 0x13c0, 0x10DE, "GRID RTX6000-6C" },
    { 0x1E30, 0x13c1, 0x10DE, "GRID RTX6000-8C" },
    { 0x1E30, 0x13c2, 0x10DE, "GRID RTX6000-12C" },
    { 0x1E30, 0x13c3, 0x10DE, "GRID RTX6000-24C" },
    { 0x1E30, 0x13c4, 0x10DE, "GRID RTX8000-4C" },
    { 0x1E30, 0x13c5, 0x10DE, "GRID RTX8000-6C" },
    { 0x1E30, 0x13c6, 0x10DE, "GRID RTX8000-8C" },
    { 0x1E30, 0x13c7, 0x10DE, "GRID RTX8000-12C" },
    { 0x1E30, 0x13c8, 0x10DE, "GRID RTX8000-16C" },
    { 0x1E30, 0x13c9, 0x10DE, "GRID RTX8000-24C" },
    { 0x1E30, 0x13ca, 0x10DE, "GRID RTX8000-48C" },
    { 0x1E30, 0x13cb, 0x10DE, "GRID RTX6000-8" },
    { 0x1E30, 0x13cc, 0x10DE, "GRID RTX8000-16" },
    { 0x1E30, 0x1437, 0x10DE, "GRID RTX6000-1B" },
    { 0x1E30, 0x1438, 0x10DE, "GRID RTX6000-2B" },
    { 0x1E30, 0x1439, 0x10DE, "GRID RTX6000-1A" },
    { 0x1E30, 0x143a, 0x10DE, "GRID RTX6000-2A" },
    { 0x1E30, 0x143b, 0x10DE, "GRID RTX6000-3A" },
    { 0x1E30, 0x143c, 0x10DE, "GRID RTX6000-4A" },
    { 0x1E30, 0x143d, 0x10DE, "GRID RTX6000-6A" },
    { 0x1E30, 0x143e, 0x10DE, "GRID RTX6000-8A" },
    { 0x1E30, 0x143f, 0x10DE, "GRID RTX6000-12A" },
    { 0x1E30, 0x1440, 0x10DE, "GRID RTX6000-24A" },
    { 0x1E30, 0x1441, 0x10DE, "GRID RTX8000-1B" },
    { 0x1E30, 0x1442, 0x10DE, "GRID RTX8000-2B" },
    { 0x1E30, 0x1443, 0x10DE, "GRID RTX8000-1A" },
    { 0x1E30, 0x1444, 0x10DE, "GRID RTX8000-2A" },
    { 0x1E30, 0x1445, 0x10DE, "GRID RTX8000-3A" },
    { 0x1E30, 0x1446, 0x10DE, "GRID RTX8000-4A" },
    { 0x1E30, 0x1447, 0x10DE, "GRID RTX8000-6A" },
    { 0x1E30, 0x1448, 0x10DE, "GRID RTX8000-8A" },
    { 0x1E30, 0x1449, 0x10DE, "GRID RTX8000-12A" },
    { 0x1E30, 0x144a, 0x10DE, "GRID RTX8000-16A" },
    { 0x1E30, 0x144b, 0x10DE, "GRID RTX8000-24A" },
    { 0x1E30, 0x144c, 0x10DE, "GRID RTX8000-48A" },
    { 0x1E37, 0x1347, 0x10DE, "GeForce RTX T10x-8" },
    { 0x1E37, 0x1348, 0x10DE, "GeForce RTX T10x-4" },
    { 0x1E37, 0x1349, 0x10DE, "GeForce RTX T10x-2" },
    { 0x1E37, 0x136a, 0x10DE, "GRID RTX T10-4" },
    { 0x1E37, 0x136b, 0x10DE, "GRID RTX T10-8" },
    { 0x1E37, 0x136c, 0x10DE, "GRID RTX T10-16" },
    { 0x1E37, 0x13a4, 0x10DE, "GeForce RTX T10-4" },
    { 0x1E37, 0x13a5, 0x10DE, "GeForce RTX T10-8" },
    { 0x1E37, 0x13a6, 0x10DE, "GeForce RTX T10-16" },
    { 0x1E37, 0x13a7, 0x10DE, "GRID RTX T10x-2" },
    { 0x1E37, 0x13a8, 0x10DE, "GRID RTX T10x-4" },
    { 0x1E37, 0x13a9, 0x10DE, "GRID RTX T10x-8" },
    { 0x1E37, 0x180d, 0x10DE, "NVIDIA GeForce GTX 1060" },
    { 0x1E37, 0x1820, 0x10DE, "NVIDIA GeForce RTX 2080" },
    { 0x1E78, 0x13f7, 0x10DE, "GRID RTX6000P-1B" },
    { 0x1E78, 0x13f8, 0x10DE, "GRID RTX6000P-2B" },
    { 0x1E78, 0x13f9, 0x10DE, "GRID RTX6000P-1Q" },
    { 0x1E78, 0x13fa, 0x10DE, "GRID RTX6000P-2Q" },
    { 0x1E78, 0x13fb, 0x10DE, "GRID RTX6000P-3Q" },
    { 0x1E78, 0x13fc, 0x10DE, "GRID RTX6000P-4Q" },
    { 0x1E78, 0x13fd, 0x10DE, "GRID RTX6000P-6Q" },
    { 0x1E78, 0x13fe, 0x10DE, "GRID RTX6000P-8Q" },
    { 0x1E78, 0x13ff, 0x10DE, "GRID RTX6000P-12Q" },
    { 0x1E78, 0x1400, 0x10DE, "GRID RTX6000P-24Q" },
    { 0x1E78, 0x1401, 0x10DE, "GRID RTX6000P-1A" },
    { 0x1E78, 0x1402, 0x10DE, "GRID RTX6000P-2A" },
    { 0x1E78, 0x1403, 0x10DE, "GRID RTX6000P-3A" },
    { 0x1E78, 0x1404, 0x10DE, "GRID RTX6000P-4A" },
    { 0x1E78, 0x1405, 0x10DE, "GRID RTX6000P-6A" },
    { 0x1E78, 0x1406, 0x10DE, "GRID RTX6000P-8A" },
    { 0x1E78, 0x1407, 0x10DE, "GRID RTX6000P-12A" },
    { 0x1E78, 0x1408, 0x10DE, "GRID RTX6000P-24A" },
    { 0x1E78, 0x1409, 0x10DE, "GRID RTX6000P-6" },
    { 0x1E78, 0x140a, 0x10DE, "GRID RTX6000P-8" },
    { 0x1E78, 0x140b, 0x10DE, "GRID RTX6000P-12" },
    { 0x1E78, 0x140c, 0x10DE, "GRID RTX6000P-24" },
    { 0x1E78, 0x140d, 0x10DE, "GRID RTX6000P-4C" },
    { 0x1E78, 0x140e, 0x10DE, "GRID RTX6000P-6C" },
    { 0x1E78, 0x140f, 0x10DE, "GRID RTX6000P-8C" },
    { 0x1E78, 0x1410, 0x10DE, "GRID RTX6000P-12C" },
    { 0x1E78, 0x1411, 0x10DE, "GRID RTX6000P-24C" },
    { 0x1E78, 0x1412, 0x10DE, "GRID RTX8000P-1B" },
    { 0x1E78, 0x1413, 0x10DE, "GRID RTX8000P-2B" },
    { 0x1E78, 0x1414, 0x10DE, "GRID RTX8000P-1Q" },
    { 0x1E78, 0x1415, 0x10DE, "GRID RTX8000P-2Q" },
    { 0x1E78, 0x1416, 0x10DE, "GRID RTX8000P-3Q" },
    { 0x1E78, 0x1417, 0x10DE, "GRID RTX8000P-4Q" },
    { 0x1E78, 0x1418, 0x10DE, "GRID RTX8000P-6Q" },
    { 0x1E78, 0x1419, 0x10DE, "GRID RTX8000P-8Q" },
    { 0x1E78, 0x141a, 0x10DE, "GRID RTX8000P-12Q" },
    { 0x1E78, 0x141b, 0x10DE, "GRID RTX8000P-16Q" },
    { 0x1E78, 0x141c, 0x10DE, "GRID RTX8000P-24Q" },
    { 0x1E78, 0x141d, 0x10DE, "GRID RTX8000P-48Q" },
    { 0x1E78, 0x141e, 0x10DE, "GRID RTX8000P-1A" },
    { 0x1E78, 0x141f, 0x10DE, "GRID RTX8000P-2A" },
    { 0x1E78, 0x1420, 0x10DE, "GRID RTX8000P-3A" },
    { 0x1E78, 0x1421, 0x10DE, "GRID RTX8000P-4A" },
    { 0x1E78, 0x1422, 0x10DE, "GRID RTX8000P-6A" },
    { 0x1E78, 0x1423, 0x10DE, "GRID RTX8000P-8A" },
    { 0x1E78, 0x1424, 0x10DE, "GRID RTX8000P-12A" },
    { 0x1E78, 0x1425, 0x10DE, "GRID RTX8000P-24A" },
    { 0x1E78, 0x1426, 0x10DE, "GRID RTX8000P-48A" },
    { 0x1E78, 0x1427, 0x10DE, "GRID RTX8000P-12" },
    { 0x1E78, 0x1428, 0x10DE, "GRID RTX8000P-16" },
    { 0x1E78, 0x1429, 0x10DE, "GRID RTX8000P-24" },
    { 0x1E78, 0x142a, 0x10DE, "GRID RTX8000P-48" },
    { 0x1E78, 0x142b, 0x10DE, "GRID RTX8000P-4C" },
    { 0x1E78, 0x142c, 0x10DE, "GRID RTX8000P-6C" },
    { 0x1E78, 0x142d, 0x10DE, "GRID RTX8000P-8C" },
    { 0x1E78, 0x142e, 0x10DE, "GRID RTX8000P-12C" },
    { 0x1E78, 0x142f, 0x10DE, "GRID RTX8000P-16C" },
    { 0x1E78, 0x1430, 0x10DE, "GRID RTX8000P-24C" },
    { 0x1E78, 0x1431, 0x10DE, "GRID RTX8000P-48C" },
    { 0x1E78, 0x1436, 0x10DE, "GRID RTX8000P-16A" },
    { 0x1EB8, 0x1309, 0x10DE, "GRID T4-1B" },
    { 0x1EB8, 0x130a, 0x10DE, "GRID T4-2B" },
    { 0x1EB8, 0x130b, 0x10DE, "GRID T4-2B4" },
    { 0x1EB8, 0x130c, 0x10DE, "GRID T4-1Q" },
    { 0x1EB8, 0x130d, 0x10DE, "GRID T4-2Q" },
    { 0x1EB8, 0x130e, 0x10DE, "GRID T4-4Q" },
    { 0x1EB8, 0x130f, 0x10DE, "GRID T4-8Q" },
    { 0x1EB8, 0x1310, 0x10DE, "GRID T4-16Q" },
    { 0x1EB8, 0x1311, 0x10DE, "GRID T4-1A" },
    { 0x1EB8, 0x1312, 0x10DE, "GRID T4-2A" },
    { 0x1EB8, 0x1313, 0x10DE, "GRID T4-4A" },
    { 0x1EB8, 0x1314, 0x10DE, "GRID T4-8A" },
    { 0x1EB8, 0x1315, 0x10DE, "GRID T4-16A" },
    { 0x1EB8, 0x1345, 0x10DE, "GRID T4-1B4" },
    { 0x1EB8, 0x1367, 0x10DE, "GRID RTX T4-4" },
    { 0x1EB8, 0x1368, 0x10DE, "GRID RTX T4-8" },
    { 0x1EB8, 0x1369, 0x10DE, "GRID RTX T4-16" },
    { 0x1EB8, 0x1375, 0x10DE, "GRID T4-16C" },
    { 0x1EB8, 0x139a, 0x10DE, "GRID T4-4C" },
    { 0x1EB8, 0x139b, 0x10DE, "GRID T4-8C" },
    { 0x20B0, 0x146f, 0x10DE, "GRID A100X-1-5C" },
    { 0x20B0, 0x1470, 0x10DE, "GRID A100X-2-10C" },
    { 0x20B0, 0x1471, 0x10DE, "GRID A100X-3-20C" },
    { 0x20B0, 0x1472, 0x10DE, "GRID A100X-4-20C" },
    { 0x20B0, 0x1473, 0x10DE, "GRID A100X-7-40C" },
    { 0x20B0, 0x1474, 0x10DE, "GRID A100X-4C" },
    { 0x20B0, 0x1475, 0x10DE, "GRID A100X-5C" },
    { 0x20B0, 0x1476, 0x10DE, "GRID A100X-8C" },
    { 0x20B0, 0x1477, 0x10DE, "GRID A100X-10C" },
    { 0x20B0, 0x1478, 0x10DE, "GRID A100X-20C" },
    { 0x20B0, 0x1479, 0x10DE, "GRID A100X-40C" },
    { 0x20B0, 0x160c, 0x10DE, "GRID A100X-1-5CME" },
    { 0x20B0, 0x1840, 0x10DE, "GRID A100X-1-10C" },
    { 0x20B2, 0x1523, 0x10DE, "GRID A100DX-1-10C" },
    { 0x20B2, 0x1524, 0x10DE, "GRID A100DX-2-20C" },
    { 0x20B2, 0x1525, 0x10DE, "GRID A100DX-3-40C" },
    { 0x20B2, 0x1526, 0x10DE, "GRID A100DX-4-40C" },
    { 0x20B2, 0x1527, 0x10DE, "GRID A100DX-7-80C" },
    { 0x20B2, 0x1528, 0x10DE, "GRID A100DX-4C" },
    { 0x20B2, 0x1529, 0x10DE, "GRID A100DX-8C" },
    { 0x20B2, 0x152a, 0x10DE, "GRID A100DX-10C" },
    { 0x20B2, 0x152b, 0x10DE, "GRID A100DX-16C" },
    { 0x20B2, 0x152c, 0x10DE, "GRID A100DX-20C" },
    { 0x20B2, 0x152d, 0x10DE, "GRID A100DX-40C" },
    { 0x20B2, 0x152e, 0x10DE, "GRID A100DX-80C" },
    { 0x20B2, 0x160d, 0x10DE, "GRID A100DX-1-10CME" },
    { 0x20B2, 0x1841, 0x10DE, "GRID A100DX-1-20C" },
    { 0x20B5, 0x1591, 0x10DE, "GRID A100D-1-10C" },
    { 0x20B5, 0x1592, 0x10DE, "GRID A100D-2-20C" },
    { 0x20B5, 0x1593, 0x10DE, "GRID A100D-3-40C" },
    { 0x20B5, 0x1594, 0x10DE, "GRID A100D-4-40C" },
    { 0x20B5, 0x1595, 0x10DE, "GRID A100D-7-80C" },
    { 0x20B5, 0x1596, 0x10DE, "GRID A100D-4C" },
    { 0x20B5, 0x1597, 0x10DE, "GRID A100D-8C" },
    { 0x20B5, 0x1598, 0x10DE, "GRID A100D-10C" },
    { 0x20B5, 0x1599, 0x10DE, "GRID A100D-16C" },
    { 0x20B5, 0x159a, 0x10DE, "GRID A100D-20C" },
    { 0x20B5, 0x159b, 0x10DE, "GRID A100D-40C" },
    { 0x20B5, 0x159c, 0x10DE, "GRID A100D-80C" },
    { 0x20B5, 0x160f, 0x10DE, "GRID A100D-1-10CME" },
    { 0x20B5, 0x183e, 0x10DE, "GRID A100D-1-20C" },
    { 0x20B7, 0x1589, 0x10DE, "NVIDIA A30-1-6C" },
    { 0x20B7, 0x158a, 0x10DE, "NVIDIA A30-2-12C" },
    { 0x20B7, 0x158b, 0x10DE, "NVIDIA A30-4-24C" },
    { 0x20B7, 0x158c, 0x10DE, "NVIDIA A30-4C" },
    { 0x20B7, 0x158d, 0x10DE, "NVIDIA A30-6C" },
    { 0x20B7, 0x158e, 0x10DE, "NVIDIA A30-8C" },
    { 0x20B7, 0x158f, 0x10DE, "NVIDIA A30-12C" },
    { 0x20B7, 0x1590, 0x10DE, "NVIDIA A30-24C" },
    { 0x20B7, 0x1610, 0x10DE, "NVIDIA A30-1-6CME" },
    { 0x20B7, 0x183c, 0x10DE, "NVIDIA A30-2-12CME" },
    { 0x20F1, 0x1493, 0x10DE, "GRID A100-1-5C" },
    { 0x20F1, 0x1494, 0x10DE, "GRID A100-2-10C" },
    { 0x20F1, 0x1495, 0x10DE, "GRID A100-3-20C" },
    { 0x20F1, 0x1496, 0x10DE, "GRID A100-4-20C" },
    { 0x20F1, 0x1497, 0x10DE, "GRID A100-7-40C" },
    { 0x20F1, 0x1498, 0x10DE, "GRID A100-4C" },
    { 0x20F1, 0x1499, 0x10DE, "GRID A100-5C" },
    { 0x20F1, 0x149a, 0x10DE, "GRID A100-8C" },
    { 0x20F1, 0x149b, 0x10DE, "GRID A100-10C" },
    { 0x20F1, 0x149c, 0x10DE, "GRID A100-20C" },
    { 0x20F1, 0x149d, 0x10DE, "GRID A100-40C" },
    { 0x20F1, 0x160e, 0x10DE, "GRID A100-1-5CME" },
    { 0x20F1, 0x183d, 0x10DE, "GRID A100-1-10C" },
    { 0x20F3, 0x17b2, 0x10DE, "GRID A800DX-1-10CME" },
    { 0x20F3, 0x17b3, 0x10DE, "GRID A800DX-1-10C" },
    { 0x20F3, 0x17b4, 0x10DE, "GRID A800DX-2-20C" },
    { 0x20F3, 0x17b5, 0x10DE, "GRID A800DX-3-40C" },
    { 0x20F3, 0x17b6, 0x10DE, "GRID A800DX-4-40C" },
    { 0x20F3, 0x17b7, 0x10DE, "GRID A800DX-7-80C" },
    { 0x20F3, 0x17b8, 0x10DE, "GRID A800DX-4C" },
    { 0x20F3, 0x17b9, 0x10DE, "GRID A800DX-8C" },
    { 0x20F3, 0x17ba, 0x10DE, "GRID A800DX-10C" },
    { 0x20F3, 0x17bb, 0x10DE, "GRID A800DX-16C" },
    { 0x20F3, 0x17bc, 0x10DE, "GRID A800DX-20C" },
    { 0x20F3, 0x17bd, 0x10DE, "GRID A800DX-40C" },
    { 0x20F3, 0x17be, 0x10DE, "GRID A800DX-80C" },
    { 0x20F3, 0x1842, 0x10DE, "GRID A800DX-1-20C" },
    { 0x20F5, 0x17bf, 0x10DE, "GRID A800D-1-10CME" },
    { 0x20F5, 0x17c0, 0x10DE, "GRID A800D-1-10C" },
    { 0x20F5, 0x17c1, 0x10DE, "GRID A800D-2-20C" },
    { 0x20F5, 0x17c2, 0x10DE, "GRID A800D-3-40C" },
    { 0x20F5, 0x17c3, 0x10DE, "GRID A800D-4-40C" },
    { 0x20F5, 0x17c4, 0x10DE, "GRID A800D-7-80C" },
    { 0x20F5, 0x17c5, 0x10DE, "GRID A800D-4C" },
    { 0x20F5, 0x17c6, 0x10DE, "GRID A800D-8C" },
    { 0x20F5, 0x17c7, 0x10DE, "GRID A800D-10C" },
    { 0x20F5, 0x17c8, 0x10DE, "GRID A800D-16C" },
    { 0x20F5, 0x17c9, 0x10DE, "GRID A800D-20C" },
    { 0x20F5, 0x17ca, 0x10DE, "GRID A800D-40C" },
    { 0x20F5, 0x17cb, 0x10DE, "GRID A800D-80C" },
    { 0x20F5, 0x183f, 0x10DE, "GRID A800D-1-20C" },
    { 0x20F6, 0x17cc, 0x10DE, "GRID A800-1-5CME" },
    { 0x20F6, 0x17cd, 0x10DE, "GRID A800-1-5C" },
    { 0x20F6, 0x17ce, 0x10DE, "GRID A800-2-10C" },
    { 0x20F6, 0x17cf, 0x10DE, "GRID A800-3-20C" },
    { 0x20F6, 0x17d0, 0x10DE, "GRID A800-4-20C" },
    { 0x20F6, 0x17d1, 0x10DE, "GRID A800-7-40C" },
    { 0x20F6, 0x17d2, 0x10DE, "GRID A800-4C" },
    { 0x20F6, 0x17d3, 0x10DE, "GRID A800-5C" },
    { 0x20F6, 0x17d4, 0x10DE, "GRID A800-8C" },
    { 0x20F6, 0x17d5, 0x10DE, "GRID A800-10C" },
    { 0x20F6, 0x17d6, 0x10DE, "GRID A800-20C" },
    { 0x20F6, 0x17d7, 0x10DE, "GRID A800-40C" },
    { 0x20F6, 0x1843, 0x10DE, "GRID A800-1-10C" },
    { 0x2230, 0x14fa, 0x10DE, "NVIDIA RTXA6000-1B" },
    { 0x2230, 0x14fb, 0x10DE, "NVIDIA RTXA6000-2B" },
    { 0x2230, 0x14fc, 0x10DE, "NVIDIA RTXA6000-1Q" },
    { 0x2230, 0x14fd, 0x10DE, "NVIDIA RTXA6000-2Q" },
    { 0x2230, 0x14fe, 0x10DE, "NVIDIA RTXA6000-3Q" },
    { 0x2230, 0x14ff, 0x10DE, "NVIDIA RTXA6000-4Q" },
    { 0x2230, 0x1500, 0x10DE, "NVIDIA RTXA6000-6Q" },
    { 0x2230, 0x1501, 0x10DE, "NVIDIA RTXA6000-8Q" },
    { 0x2230, 0x1502, 0x10DE, "NVIDIA RTXA6000-12Q" },
    { 0x2230, 0x1503, 0x10DE, "NVIDIA RTXA6000-16Q" },
    { 0x2230, 0x1504, 0x10DE, "NVIDIA RTXA6000-24Q" },
    { 0x2230, 0x1505, 0x10DE, "NVIDIA RTXA6000-48Q" },
    { 0x2230, 0x1506, 0x10DE, "NVIDIA RTXA6000-1A" },
    { 0x2230, 0x1507, 0x10DE, "NVIDIA RTXA6000-2A" },
    { 0x2230, 0x1508, 0x10DE, "NVIDIA RTXA6000-3A" },
    { 0x2230, 0x1509, 0x10DE, "NVIDIA RTXA6000-4A" },
    { 0x2230, 0x150a, 0x10DE, "NVIDIA RTXA6000-6A" },
    { 0x2230, 0x150b, 0x10DE, "NVIDIA RTXA6000-8A" },
    { 0x2230, 0x150c, 0x10DE, "NVIDIA RTXA6000-12A" },
    { 0x2230, 0x150d, 0x10DE, "NVIDIA RTXA6000-16A" },
    { 0x2230, 0x150e, 0x10DE, "NVIDIA RTXA6000-24A" },
    { 0x2230, 0x150f, 0x10DE, "NVIDIA RTXA6000-48A" },
    { 0x2230, 0x1510, 0x10DE, "NVIDIA RTXA6000-12" },
    { 0x2230, 0x1511, 0x10DE, "NVIDIA RTXA6000-16" },
    { 0x2230, 0x1512, 0x10DE, "NVIDIA RTXA6000-24" },
    { 0x2230, 0x1513, 0x10DE, "NVIDIA RTXA6000-48" },
    { 0x2230, 0x1514, 0x10DE, "NVIDIA RTXA6000-4C" },
    { 0x2230, 0x1515, 0x10DE, "NVIDIA RTXA6000-6C" },
    { 0x2230, 0x1516, 0x10DE, "NVIDIA RTXA6000-8C" },
    { 0x2230, 0x1517, 0x10DE, "NVIDIA RTXA6000-12C" },
    { 0x2230, 0x1518, 0x10DE, "NVIDIA RTXA6000-16C" },
    { 0x2230, 0x1519, 0x10DE, "NVIDIA RTXA6000-24C" },
    { 0x2230, 0x151a, 0x10DE, "NVIDIA RTXA6000-48C" },
    { 0x2231, 0x1562, 0x10DE, "NVIDIA RTXA5000-1B" },
    { 0x2231, 0x1563, 0x10DE, "NVIDIA RTXA5000-2B" },
    { 0x2231, 0x1564, 0x10DE, "NVIDIA RTXA5000-1Q" },
    { 0x2231, 0x1565, 0x10DE, "NVIDIA RTXA5000-2Q" },
    { 0x2231, 0x1566, 0x10DE, "NVIDIA RTXA5000-3Q" },
    { 0x2231, 0x1567, 0x10DE, "NVIDIA RTXA5000-4Q" },
    { 0x2231, 0x1568, 0x10DE, "NVIDIA RTXA5000-6Q" },
    { 0x2231, 0x1569, 0x10DE, "NVIDIA RTXA5000-8Q" },
    { 0x2231, 0x156a, 0x10DE, "NVIDIA RTXA5000-12Q" },
    { 0x2231, 0x156b, 0x10DE, "NVIDIA RTXA5000-24Q" },
    { 0x2231, 0x156c, 0x10DE, "NVIDIA RTXA5000-1A" },
    { 0x2231, 0x156d, 0x10DE, "NVIDIA RTXA5000-2A" },
    { 0x2231, 0x156e, 0x10DE, "NVIDIA RTXA5000-3A" },
    { 0x2231, 0x156f, 0x10DE, "NVIDIA RTXA5000-4A" },
    { 0x2231, 0x1570, 0x10DE, "NVIDIA RTXA5000-6A" },
    { 0x2231, 0x1571, 0x10DE, "NVIDIA RTXA5000-8A" },
    { 0x2231, 0x1572, 0x10DE, "NVIDIA RTXA5000-12A" },
    { 0x2231, 0x1573, 0x10DE, "NVIDIA RTXA5000-24A" },
    { 0x2231, 0x1574, 0x10DE, "NVIDIA RTXA5000-6" },
    { 0x2231, 0x1575, 0x10DE, "NVIDIA RTXA5000-8" },
    { 0x2231, 0x1576, 0x10DE, "NVIDIA RTXA5000-12" },
    { 0x2231, 0x1577, 0x10DE, "NVIDIA RTXA5000-24" },
    { 0x2231, 0x1578, 0x10DE, "NVIDIA RTXA5000-4C" },
    { 0x2231, 0x1579, 0x10DE, "NVIDIA RTXA5000-6C" },
    { 0x2231, 0x157a, 0x10DE, "NVIDIA RTXA5000-8C" },
    { 0x2231, 0x157b, 0x10DE, "NVIDIA RTXA5000-12C" },
    { 0x2231, 0x157c, 0x10DE, "NVIDIA RTXA5000-24C" },
    { 0x2233, 0x165c, 0x10DE, "NVIDIA RTXA5500-1B" },
    { 0x2233, 0x165d, 0x10DE, "NVIDIA RTXA5500-2B" },
    { 0x2233, 0x165e, 0x10DE, "NVIDIA RTXA5500-1Q" },
    { 0x2233, 0x165f, 0x10DE, "NVIDIA RTXA5500-2Q" },
    { 0x2233, 0x1660, 0x10DE, "NVIDIA RTXA5500-3Q" },
    { 0x2233, 0x1661, 0x10DE, "NVIDIA RTXA5500-4Q" },
    { 0x2233, 0x1662, 0x10DE, "NVIDIA RTXA5500-6Q" },
    { 0x2233, 0x1663, 0x10DE, "NVIDIA RTXA5500-8Q" },
    { 0x2233, 0x1664, 0x10DE, "NVIDIA RTXA5500-12Q" },
    { 0x2233, 0x1665, 0x10DE, "NVIDIA RTXA5500-24Q" },
    { 0x2233, 0x1666, 0x10DE, "NVIDIA RTXA5500-1A" },
    { 0x2233, 0x1667, 0x10DE, "NVIDIA RTXA5500-2A" },
    { 0x2233, 0x1668, 0x10DE, "NVIDIA RTXA5500-3A" },
    { 0x2233, 0x1669, 0x10DE, "NVIDIA RTXA5500-4A" },
    { 0x2233, 0x166a, 0x10DE, "NVIDIA RTXA5500-6A" },
    { 0x2233, 0x166b, 0x10DE, "NVIDIA RTXA5500-8A" },
    { 0x2233, 0x166c, 0x10DE, "NVIDIA RTXA5500-12A" },
    { 0x2233, 0x166d, 0x10DE, "NVIDIA RTXA5500-24A" },
    { 0x2233, 0x166e, 0x10DE, "NVIDIA RTXA5500-6" },
    { 0x2233, 0x166f, 0x10DE, "NVIDIA RTXA5500-8" },
    { 0x2233, 0x1670, 0x10DE, "NVIDIA RTXA5500-12" },
    { 0x2233, 0x1671, 0x10DE, "NVIDIA RTXA5500-24" },
    { 0x2233, 0x1672, 0x10DE, "NVIDIA RTXA5500-4C" },
    { 0x2233, 0x1673, 0x10DE, "NVIDIA RTXA5500-6C" },
    { 0x2233, 0x1674, 0x10DE, "NVIDIA RTXA5500-8C" },
    { 0x2233, 0x1675, 0x10DE, "NVIDIA RTXA5500-12C" },
    { 0x2233, 0x1676, 0x10DE, "NVIDIA RTXA5500-24C" },
    { 0x2235, 0x14d5, 0x10DE, "NVIDIA A40-1B" },
    { 0x2235, 0x14d6, 0x10DE, "NVIDIA A40-2B" },
    { 0x2235, 0x14d7, 0x10DE, "NVIDIA A40-1Q" },
    { 0x2235, 0x14d8, 0x10DE, "NVIDIA A40-2Q" },
    { 0x2235, 0x14d9, 0x10DE, "NVIDIA A40-3Q" },
    { 0x2235, 0x14da, 0x10DE, "NVIDIA A40-4Q" },
    { 0x2235, 0x14db, 0x10DE, "NVIDIA A40-6Q" },
    { 0x2235, 0x14dc, 0x10DE, "NVIDIA A40-8Q" },
    { 0x2235, 0x14dd, 0x10DE, "NVIDIA A40-12Q" },
    { 0x2235, 0x14de, 0x10DE, "NVIDIA A40-16Q" },
    { 0x2235, 0x14df, 0x10DE, "NVIDIA A40-24Q" },
    { 0x2235, 0x14e0, 0x10DE, "NVIDIA A40-48Q" },
    { 0x2235, 0x14e1, 0x10DE, "NVIDIA A40-1A" },
    { 0x2235, 0x14e2, 0x10DE, "NVIDIA A40-2A" },
    { 0x2235, 0x14e3, 0x10DE, "NVIDIA A40-3A" },
    { 0x2235, 0x14e4, 0x10DE, "NVIDIA A40-4A" },
    { 0x2235, 0x14e5, 0x10DE, "NVIDIA A40-6A" },
    { 0x2235, 0x14e6, 0x10DE, "NVIDIA A40-8A" },
    { 0x2235, 0x14e7, 0x10DE, "NVIDIA A40-12A" },
    { 0x2235, 0x14e8, 0x10DE, "NVIDIA A40-16A" },
    { 0x2235, 0x14e9, 0x10DE, "NVIDIA A40-24A" },
    { 0x2235, 0x14ea, 0x10DE, "NVIDIA A40-48A" },
    { 0x2235, 0x14eb, 0x10DE, "NVIDIA A40-12" },
    { 0x2235, 0x14ec, 0x10DE, "NVIDIA A40-16" },
    { 0x2235, 0x14ed, 0x10DE, "NVIDIA A40-24" },
    { 0x2235, 0x14ee, 0x10DE, "NVIDIA A40-48" },
    { 0x2235, 0x14f3, 0x10DE, "NVIDIA A40-4C" },
    { 0x2235, 0x14f4, 0x10DE, "NVIDIA A40-6C" },
    { 0x2235, 0x14f5, 0x10DE, "NVIDIA A40-8C" },
    { 0x2235, 0x14f6, 0x10DE, "NVIDIA A40-12C" },
    { 0x2235, 0x14f7, 0x10DE, "NVIDIA A40-16C" },
    { 0x2235, 0x14f8, 0x10DE, "NVIDIA A40-24C" },
    { 0x2235, 0x14f9, 0x10DE, "NVIDIA A40-48C" },
    { 0x2235, 0x1684, 0x10DE, "NVIDIA A40-2" },
    { 0x2235, 0x1685, 0x10DE, "NVIDIA A40-3" },
    { 0x2235, 0x1686, 0x10DE, "NVIDIA A40-4" },
    { 0x2235, 0x1687, 0x10DE, "NVIDIA A40-6" },
    { 0x2235, 0x1688, 0x10DE, "NVIDIA A40-8" },
    { 0x2235, 0x16e7, 0x10DE, "NVIDIA A40-1" },
    { 0x2236, 0x14b6, 0x10DE, "NVIDIA A10-1B" },
    { 0x2236, 0x14b7, 0x10DE, "NVIDIA A10-2B" },
    { 0x2236, 0x14b8, 0x10DE, "NVIDIA A10-1Q" },
    { 0x2236, 0x14b9, 0x10DE, "NVIDIA A10-2Q" },
    { 0x2236, 0x14ba, 0x10DE, "NVIDIA A10-3Q" },
    { 0x2236, 0x14bb, 0x10DE, "NVIDIA A10-4Q" },
    { 0x2236, 0x14bc, 0x10DE, "NVIDIA A10-6Q" },
    { 0x2236, 0x14bd, 0x10DE, "NVIDIA A10-8Q" },
    { 0x2236, 0x14be, 0x10DE, "NVIDIA A10-12Q" },
    { 0x2236, 0x14bf, 0x10DE, "NVIDIA A10-24Q" },
    { 0x2236, 0x14c0, 0x10DE, "NVIDIA A10-1A" },
    { 0x2236, 0x14c1, 0x10DE, "NVIDIA A10-2A" },
    { 0x2236, 0x14c2, 0x10DE, "NVIDIA A10-3A" },
    { 0x2236, 0x14c3, 0x10DE, "NVIDIA A10-4A" },
    { 0x2236, 0x14c4, 0x10DE, "NVIDIA A10-6A" },
    { 0x2236, 0x14c5, 0x10DE, "NVIDIA A10-8A" },
    { 0x2236, 0x14c6, 0x10DE, "NVIDIA A10-12A" },
    { 0x2236, 0x14c7, 0x10DE, "NVIDIA A10-24A" },
    { 0x2236, 0x14c8, 0x10DE, "NVIDIA A10-6" },
    { 0x2236, 0x14c9, 0x10DE, "NVIDIA A10-8" },
    { 0x2236, 0x14ca, 0x10DE, "NVIDIA A10-12" },
    { 0x2236, 0x14cb, 0x10DE, "NVIDIA A10-24" },
    { 0x2236, 0x14d0, 0x10DE, "NVIDIA A10-4C" },
    { 0x2236, 0x14d1, 0x10DE, "NVIDIA A10-6C" },
    { 0x2236, 0x14d2, 0x10DE, "NVIDIA A10-8C" },
    { 0x2236, 0x14d3, 0x10DE, "NVIDIA A10-12C" },
    { 0x2236, 0x14d4, 0x10DE, "NVIDIA A10-24C" },
    { 0x2236, 0x167e, 0x10DE, "NVIDIA A10-2" },
    { 0x2236, 0x167f, 0x10DE, "NVIDIA A10-3" },
    { 0x2236, 0x1680, 0x10DE, "NVIDIA A10-4" },
    { 0x2236, 0x16e8, 0x10DE, "NVIDIA A10-1" },
    { 0x2237, 0x155a, 0x10DE, "NVIDIA A10G-1" },
    { 0x2237, 0x155b, 0x10DE, "NVIDIA A10G-2" },
    { 0x2237, 0x155c, 0x10DE, "NVIDIA A10G-3" },
    { 0x2237, 0x155d, 0x10DE, "NVIDIA A10G-4" },
    { 0x2237, 0x155e, 0x10DE, "NVIDIA A10G-6" },
    { 0x2237, 0x155f, 0x10DE, "NVIDIA A10G-8" },
    { 0x2237, 0x1560, 0x10DE, "NVIDIA A10G-12" },
    { 0x2237, 0x1561, 0x10DE, "NVIDIA A10G-24" },
    { 0x2237, 0x162a, 0x10DE, "NVIDIA A10G-1B" },
    { 0x2237, 0x162b, 0x10DE, "NVIDIA A10G-2B" },
    { 0x2237, 0x162c, 0x10DE, "NVIDIA A10G-1Q" },
    { 0x2237, 0x162d, 0x10DE, "NVIDIA A10G-2Q" },
    { 0x2237, 0x162e, 0x10DE, "NVIDIA A10G-3Q" },
    { 0x2237, 0x162f, 0x10DE, "NVIDIA A10G-4Q" },
    { 0x2237, 0x1630, 0x10DE, "NVIDIA A10G-6Q" },
    { 0x2237, 0x1631, 0x10DE, "NVIDIA A10G-8Q" },
    { 0x2237, 0x1632, 0x10DE, "NVIDIA A10G-12Q" },
    { 0x2237, 0x1633, 0x10DE, "NVIDIA A10G-24Q" },
    { 0x2237, 0x1634, 0x10DE, "NVIDIA A10G-1A" },
    { 0x2237, 0x1635, 0x10DE, "NVIDIA A10G-2A" },
    { 0x2237, 0x1636, 0x10DE, "NVIDIA A10G-3A" },
    { 0x2237, 0x1637, 0x10DE, "NVIDIA A10G-4A" },
    { 0x2237, 0x1638, 0x10DE, "NVIDIA A10G-6A" },
    { 0x2237, 0x1639, 0x10DE, "NVIDIA A10G-8A" },
    { 0x2237, 0x163a, 0x10DE, "NVIDIA A10G-12A" },
    { 0x2237, 0x163b, 0x10DE, "NVIDIA A10G-24A" },
    { 0x2237, 0x1810, 0x10DE, "NVIDIA GeForce RTX 3050" },
    { 0x2237, 0x1811, 0x10DE, "NVIDIA GeForce RTX 3060" },
    { 0x2238, 0x16a3, 0x10DE, "NVIDIA A10M-1B" },
    { 0x2238, 0x16a4, 0x10DE, "NVIDIA A10M-2B" },
    { 0x2238, 0x16a5, 0x10DE, "NVIDIA A10M-1Q" },
    { 0x2238, 0x16a6, 0x10DE, "NVIDIA A10M-2Q" },
    { 0x2238, 0x16a7, 0x10DE, "NVIDIA A10M-4Q" },
    { 0x2238, 0x16a8, 0x10DE, "NVIDIA A10M-5Q" },
    { 0x2238, 0x16a9, 0x10DE, "NVIDIA A10M-10Q" },
    { 0x2238, 0x16aa, 0x10DE, "NVIDIA A10M-20Q" },
    { 0x2238, 0x16ab, 0x10DE, "NVIDIA A10M-1A" },
    { 0x2238, 0x16ac, 0x10DE, "NVIDIA A10M-2A" },
    { 0x2238, 0x16ad, 0x10DE, "NVIDIA A10M-4A" },
    { 0x2238, 0x16ae, 0x10DE, "NVIDIA A10M-5A" },
    { 0x2238, 0x16af, 0x10DE, "NVIDIA A10M-10A" },
    { 0x2238, 0x16b0, 0x10DE, "NVIDIA A10M-20A" },
    { 0x2238, 0x16b1, 0x10DE, "NVIDIA A10M-2" },
    { 0x2238, 0x16b2, 0x10DE, "NVIDIA A10M-4" },
    { 0x2238, 0x16b3, 0x10DE, "NVIDIA A10M-5" },
    { 0x2238, 0x16b4, 0x10DE, "NVIDIA A10M-10" },
    { 0x2238, 0x16b5, 0x10DE, "NVIDIA A10M-20" },
    { 0x2238, 0x16b6, 0x10DE, "NVIDIA A10M-4C" },
    { 0x2238, 0x16b7, 0x10DE, "NVIDIA A10M-5C" },
    { 0x2238, 0x16b8, 0x10DE, "NVIDIA A10M-10C" },
    { 0x2238, 0x16b9, 0x10DE, "NVIDIA A10M-20C" },
    { 0x2238, 0x16e6, 0x10DE, "NVIDIA A10M-1" },
    { 0x230E, 0x20f5, 0x10DE, "NVIDIA H20L-1-15CME" },
    { 0x230E, 0x20f6, 0x10DE, "NVIDIA H20L-1-15C" },
    { 0x230E, 0x20f7, 0x10DE, "NVIDIA H20L-1-30C" },
    { 0x230E, 0x20f8, 0x10DE, "NVIDIA H20L-2-30C" },
    { 0x230E, 0x20f9, 0x10DE, "NVIDIA H20L-3-60C" },
    { 0x230E, 0x20fa, 0x10DE, "NVIDIA H20L-4-60C" },
    { 0x230E, 0x20fb, 0x10DE, "NVIDIA H20L-7-120C" },
    { 0x230E, 0x20fc, 0x10DE, "NVIDIA H20L-4C" },
    { 0x230E, 0x20fd, 0x10DE, "NVIDIA H20L-5C" },
    { 0x230E, 0x20fe, 0x10DE, "NVIDIA H20L-6C" },
    { 0x230E, 0x20ff, 0x10DE, "NVIDIA H20L-8C" },
    { 0x230E, 0x2100, 0x10DE, "NVIDIA H20L-10C" },
    { 0x230E, 0x2101, 0x10DE, "NVIDIA H20L-12C" },
    { 0x230E, 0x2102, 0x10DE, "NVIDIA H20L-15C" },
    { 0x230E, 0x2103, 0x10DE, "NVIDIA H20L-20C" },
    { 0x230E, 0x2104, 0x10DE, "NVIDIA H20L-30C" },
    { 0x230E, 0x2105, 0x10DE, "NVIDIA H20L-40C" },
    { 0x230E, 0x2106, 0x10DE, "NVIDIA H20L-60C" },
    { 0x230E, 0x2107, 0x10DE, "NVIDIA H20L-120C" },
    { 0x2321, 0x1853, 0x10DE, "NVIDIA H100L-1-12CME" },
    { 0x2321, 0x1854, 0x10DE, "NVIDIA H100L-1-12C" },
    { 0x2321, 0x1855, 0x10DE, "NVIDIA H100L-1-24C" },
    { 0x2321, 0x1856, 0x10DE, "NVIDIA H100L-2-24C" },
    { 0x2321, 0x1857, 0x10DE, "NVIDIA H100L-3-47C" },
    { 0x2321, 0x1858, 0x10DE, "NVIDIA H100L-4-47C" },
    { 0x2321, 0x1859, 0x10DE, "NVIDIA H100L-7-94C" },
    { 0x2321, 0x185a, 0x10DE, "NVIDIA H100L-4C" },
    { 0x2321, 0x185b, 0x10DE, "NVIDIA H100L-6C" },
    { 0x2321, 0x185c, 0x10DE, "NVIDIA H100L-11C" },
    { 0x2321, 0x185d, 0x10DE, "NVIDIA H100L-15C" },
    { 0x2321, 0x185e, 0x10DE, "NVIDIA H100L-23C" },
    { 0x2321, 0x185f, 0x10DE, "NVIDIA H100L-47C" },
    { 0x2321, 0x1860, 0x10DE, "NVIDIA H100L-94C" },
    { 0x2322, 0x17e2, 0x10DE, "NVIDIA H800-1-10CME" },
    { 0x2322, 0x17e3, 0x10DE, "NVIDIA H800-1-10C" },
    { 0x2322, 0x17e4, 0x10DE, "NVIDIA H800-2-20C" },
    { 0x2322, 0x17e5, 0x10DE, "NVIDIA H800-3-40C" },
    { 0x2322, 0x17e6, 0x10DE, "NVIDIA H800-4-40C" },
    { 0x2322, 0x17e7, 0x10DE, "NVIDIA H800-7-80C" },
    { 0x2322, 0x17e8, 0x10DE, "NVIDIA H800-4C" },
    { 0x2322, 0x17e9, 0x10DE, "NVIDIA H800-5C" },
    { 0x2322, 0x17ea, 0x10DE, "NVIDIA H800-8C" },
    { 0x2322, 0x17eb, 0x10DE, "NVIDIA H800-10C" },
    { 0x2322, 0x17ec, 0x10DE, "NVIDIA H800-16C" },
    { 0x2322, 0x17ed, 0x10DE, "NVIDIA H800-20C" },
    { 0x2322, 0x17ee, 0x10DE, "NVIDIA H800-40C" },
    { 0x2322, 0x17ef, 0x10DE, "NVIDIA H800-80C" },
    { 0x2322, 0x1845, 0x10DE, "NVIDIA H800-1-20C" },
    { 0x2324, 0x18d5, 0x10DE, "NVIDIA H800XM-1-10CME" },
    { 0x2324, 0x18d6, 0x10DE, "NVIDIA H800XM-1-10C" },
    { 0x2324, 0x18d7, 0x10DE, "NVIDIA H800XM-1-20C" },
    { 0x2324, 0x18d8, 0x10DE, "NVIDIA H800XM-2-20C" },
    { 0x2324, 0x18d9, 0x10DE, "NVIDIA H800XM-3-40C" },
    { 0x2324, 0x18da, 0x10DE, "NVIDIA H800XM-4-40C" },
    { 0x2324, 0x18db, 0x10DE, "NVIDIA H800XM-7-80C" },
    { 0x2324, 0x18dc, 0x10DE, "NVIDIA H800XM-4C" },
    { 0x2324, 0x18dd, 0x10DE, "NVIDIA H800XM-5C" },
    { 0x2324, 0x18de, 0x10DE, "NVIDIA H800XM-8C" },
    { 0x2324, 0x18df, 0x10DE, "NVIDIA H800XM-10C" },
    { 0x2324, 0x18e0, 0x10DE, "NVIDIA H800XM-16C" },
    { 0x2324, 0x18e1, 0x10DE, "NVIDIA H800XM-20C" },
    { 0x2324, 0x18e2, 0x10DE, "NVIDIA H800XM-40C" },
    { 0x2324, 0x18e3, 0x10DE, "NVIDIA H800XM-80C" },
    { 0x2329, 0x2028, 0x10DE, "NVIDIA H20-1-12CME" },
    { 0x2329, 0x2029, 0x10DE, "NVIDIA H20-1-12C" },
    { 0x2329, 0x202a, 0x10DE, "NVIDIA H20-1-24C" },
    { 0x2329, 0x202b, 0x10DE, "NVIDIA H20-2-24C" },
    { 0x2329, 0x202c, 0x10DE, "NVIDIA H20-3-48C" },
    { 0x2329, 0x202d, 0x10DE, "NVIDIA H20-4-48C" },
    { 0x2329, 0x202e, 0x10DE, "NVIDIA H20-7-96C" },
    { 0x2329, 0x202f, 0x10DE, "NVIDIA H20-4C" },
    { 0x2329, 0x2030, 0x10DE, "NVIDIA H20-6C" },
    { 0x2329, 0x2031, 0x10DE, "NVIDIA H20-12C" },
    { 0x2329, 0x2032, 0x10DE, "NVIDIA H20-16C" },
    { 0x2329, 0x2033, 0x10DE, "NVIDIA H20-24C" },
    { 0x2329, 0x2034, 0x10DE, "NVIDIA H20-48C" },
    { 0x2329, 0x2035, 0x10DE, "NVIDIA H20-96C" },
    { 0x2329, 0x2047, 0x10DE, "NVIDIA H20-8C" },
    { 0x2329, 0x2048, 0x10DE, "NVIDIA H20-32C" },
    { 0x232C, 0x2108, 0x10DE, "NVIDIA H20X-1-18CME" },
    { 0x232C, 0x2109, 0x10DE, "NVIDIA H20X-1-18C" },
    { 0x232C, 0x210a, 0x10DE, "NVIDIA H20X-1-35C" },
    { 0x232C, 0x210b, 0x10DE, "NVIDIA H20X-2-35C" },
    { 0x232C, 0x210c, 0x10DE, "NVIDIA H20X-3-71C" },
    { 0x232C, 0x210d, 0x10DE, "NVIDIA H20X-4-71C" },
    { 0x232C, 0x210e, 0x10DE, "NVIDIA H20X-7-141C" },
    { 0x232C, 0x210f, 0x10DE, "NVIDIA H20X-4C" },
    { 0x232C, 0x2110, 0x10DE, "NVIDIA H20X-7C" },
    { 0x232C, 0x2111, 0x10DE, "NVIDIA H20X-8C" },
    { 0x232C, 0x2112, 0x10DE, "NVIDIA H20X-14C" },
    { 0x232C, 0x2113, 0x10DE, "NVIDIA H20X-17C" },
    { 0x232C, 0x2114, 0x10DE, "NVIDIA H20X-28C" },
    { 0x232C, 0x2115, 0x10DE, "NVIDIA H20X-35C" },
    { 0x232C, 0x2116, 0x10DE, "NVIDIA H20X-70C" },
    { 0x232C, 0x2117, 0x10DE, "NVIDIA H20X-141C" },
    { 0x2330, 0x187a, 0x10DE, "NVIDIA H100XM-1-10CME" },
    { 0x2330, 0x187b, 0x10DE, "NVIDIA H100XM-1-10C" },
    { 0x2330, 0x187c, 0x10DE, "NVIDIA H100XM-1-20C" },
    { 0x2330, 0x187d, 0x10DE, "NVIDIA H100XM-2-20C" },
    { 0x2330, 0x187e, 0x10DE, "NVIDIA H100XM-3-40C" },
    { 0x2330, 0x187f, 0x10DE, "NVIDIA H100XM-4-40C" },
    { 0x2330, 0x1880, 0x10DE, "NVIDIA H100XM-7-80C" },
    { 0x2330, 0x1881, 0x10DE, "NVIDIA H100XM-4C" },
    { 0x2330, 0x1882, 0x10DE, "NVIDIA H100XM-5C" },
    { 0x2330, 0x1883, 0x10DE, "NVIDIA H100XM-8C" },
    { 0x2330, 0x1884, 0x10DE, "NVIDIA H100XM-10C" },
    { 0x2330, 0x1885, 0x10DE, "NVIDIA H100XM-16C" },
    { 0x2330, 0x1886, 0x10DE, "NVIDIA H100XM-20C" },
    { 0x2330, 0x1887, 0x10DE, "NVIDIA H100XM-40C" },
    { 0x2330, 0x1888, 0x10DE, "NVIDIA H100XM-80C" },
    { 0x2331, 0x16d3, 0x10DE, "NVIDIA H100-1-10C" },
    { 0x2331, 0x16d4, 0x10DE, "NVIDIA H100-2-20C" },
    { 0x2331, 0x16d5, 0x10DE, "NVIDIA H100-3-40C" },
    { 0x2331, 0x16d6, 0x10DE, "NVIDIA H100-4-40C" },
    { 0x2331, 0x16d7, 0x10DE, "NVIDIA H100-7-80C" },
    { 0x2331, 0x16d8, 0x10DE, "NVIDIA H100-4C" },
    { 0x2331, 0x16d9, 0x10DE, "NVIDIA H100-8C" },
    { 0x2331, 0x16da, 0x10DE, "NVIDIA H100-10C" },
    { 0x2331, 0x16db, 0x10DE, "NVIDIA H100-16C" },
    { 0x2331, 0x16dc, 0x10DE, "NVIDIA H100-20C" },
    { 0x2331, 0x16dd, 0x10DE, "NVIDIA H100-40C" },
    { 0x2331, 0x16de, 0x10DE, "NVIDIA H100-80C" },
    { 0x2331, 0x1798, 0x10DE, "NVIDIA H100-5C" },
    { 0x2331, 0x17f0, 0x10DE, "NVIDIA H100-1-10CME" },
    { 0x2331, 0x1844, 0x10DE, "NVIDIA H100-1-20C" },
    { 0x2335, 0x206e, 0x10DE, "NVIDIA H200X-1-18CME" },
    { 0x2335, 0x206f, 0x10DE, "NVIDIA H200X-1-18C" },
    { 0x2335, 0x2070, 0x10DE, "NVIDIA H200X-1-35C" },
    { 0x2335, 0x2071, 0x10DE, "NVIDIA H200X-2-35C" },
    { 0x2335, 0x2072, 0x10DE, "NVIDIA H200X-3-71C" },
    { 0x2335, 0x2073, 0x10DE, "NVIDIA H200X-4-71C" },
    { 0x2335, 0x2074, 0x10DE, "NVIDIA H200X-7-141C" },
    { 0x2335, 0x2075, 0x10DE, "NVIDIA H200X-4C" },
    { 0x2335, 0x2076, 0x10DE, "NVIDIA H200X-7C" },
    { 0x2335, 0x2077, 0x10DE, "NVIDIA H200X-8C" },
    { 0x2335, 0x2078, 0x10DE, "NVIDIA H200X-14C" },
    { 0x2335, 0x2079, 0x10DE, "NVIDIA H200X-17C" },
    { 0x2335, 0x207a, 0x10DE, "NVIDIA H200X-28C" },
    { 0x2335, 0x207b, 0x10DE, "NVIDIA H200X-35C" },
    { 0x2335, 0x207e, 0x10DE, "NVIDIA H200X-70C" },
    { 0x2335, 0x207f, 0x10DE, "NVIDIA H200X-141C" },
    { 0x2337, 0x18f2, 0x10DE, "NVIDIA H100XS-1-8CME" },
    { 0x2337, 0x18f3, 0x10DE, "NVIDIA H100XS-1-8C" },
    { 0x2337, 0x18f4, 0x10DE, "NVIDIA H100XS-1-16C" },
    { 0x2337, 0x18f5, 0x10DE, "NVIDIA H100XS-2-16C" },
    { 0x2337, 0x18f6, 0x10DE, "NVIDIA H100XS-3-32C" },
    { 0x2337, 0x18f7, 0x10DE, "NVIDIA H100XS-4-32C" },
    { 0x2337, 0x18f8, 0x10DE, "NVIDIA H100XS-7-64C" },
    { 0x2337, 0x18f9, 0x10DE, "NVIDIA H100XS-4C" },
    { 0x2337, 0x18fa, 0x10DE, "NVIDIA H100XS-8C" },
    { 0x2337, 0x18fb, 0x10DE, "NVIDIA H100XS-16C" },
    { 0x2337, 0x18fc, 0x10DE, "NVIDIA H100XS-32C" },
    { 0x2337, 0x18fd, 0x10DE, "NVIDIA H100XS-64C" },
    { 0x2339, 0x18e4, 0x10DE, "NVIDIA H100XL-1-12CME" },
    { 0x2339, 0x18e5, 0x10DE, "NVIDIA H100XL-1-12C" },
    { 0x2339, 0x18e6, 0x10DE, "NVIDIA H100XL-1-24C" },
    { 0x2339, 0x18e7, 0x10DE, "NVIDIA H100XL-2-24C" },
    { 0x2339, 0x18e8, 0x10DE, "NVIDIA H100XL-3-47C" },
    { 0x2339, 0x18e9, 0x10DE, "NVIDIA H100XL-4-47C" },
    { 0x2339, 0x18ea, 0x10DE, "NVIDIA H100XL-7-94C" },
    { 0x2339, 0x18eb, 0x10DE, "NVIDIA H100XL-4C" },
    { 0x2339, 0x18ec, 0x10DE, "NVIDIA H100XL-6C" },
    { 0x2339, 0x18ed, 0x10DE, "NVIDIA H100XL-11C" },
    { 0x2339, 0x18ee, 0x10DE, "NVIDIA H100XL-15C" },
    { 0x2339, 0x18ef, 0x10DE, "NVIDIA H100XL-23C" },
    { 0x2339, 0x18f0, 0x10DE, "NVIDIA H100XL-47C" },
    { 0x2339, 0x18f1, 0x10DE, "NVIDIA H100XL-94C" },
    { 0x233A, 0x1861, 0x10DE, "NVIDIA H800L-1-12CME" },
    { 0x233A, 0x1862, 0x10DE, "NVIDIA H800L-1-12C" },
    { 0x233A, 0x1863, 0x10DE, "NVIDIA H800L-1-24C" },
    { 0x233A, 0x1864, 0x10DE, "NVIDIA H800L-2-24C" },
    { 0x233A, 0x1865, 0x10DE, "NVIDIA H800L-3-47C" },
    { 0x233A, 0x1866, 0x10DE, "NVIDIA H800L-4-47C" },
    { 0x233A, 0x1867, 0x10DE, "NVIDIA H800L-7-94C" },
    { 0x233A, 0x1868, 0x10DE, "NVIDIA H800L-4C" },
    { 0x233A, 0x1869, 0x10DE, "NVIDIA H800L-6C" },
    { 0x233A, 0x186a, 0x10DE, "NVIDIA H800L-11C" },
    { 0x233A, 0x186b, 0x10DE, "NVIDIA H800L-15C" },
    { 0x233A, 0x186c, 0x10DE, "NVIDIA H800L-23C" },
    { 0x233A, 0x186d, 0x10DE, "NVIDIA H800L-47C" },
    { 0x233A, 0x186e, 0x10DE, "NVIDIA H800L-94C" },
    { 0x233B, 0x2081, 0x10DE, "NVIDIA H200-1-18CME" },
    { 0x233B, 0x2082, 0x10DE, "NVIDIA H200-1-18C" },
    { 0x233B, 0x2083, 0x10DE, "NVIDIA H200-1-35C" },
    { 0x233B, 0x2084, 0x10DE, "NVIDIA H200-2-35C" },
    { 0x233B, 0x2085, 0x10DE, "NVIDIA H200-3-71C" },
    { 0x233B, 0x2086, 0x10DE, "NVIDIA H200-4-71C" },
    { 0x233B, 0x2087, 0x10DE, "NVIDIA H200-7-141C" },
    { 0x233B, 0x2088, 0x10DE, "NVIDIA H200-4C" },
    { 0x233B, 0x2089, 0x10DE, "NVIDIA H200-7C" },
    { 0x233B, 0x208a, 0x10DE, "NVIDIA H200-8C" },
    { 0x233B, 0x208b, 0x10DE, "NVIDIA H200-14C" },
    { 0x233B, 0x208c, 0x10DE, "NVIDIA H200-17C" },
    { 0x233B, 0x208d, 0x10DE, "NVIDIA H200-28C" },
    { 0x233B, 0x208e, 0x10DE, "NVIDIA H200-35C" },
    { 0x233B, 0x208f, 0x10DE, "NVIDIA H200-70C" },
    { 0x233B, 0x2090, 0x10DE, "NVIDIA H200-141C" },
    { 0x2342, 0x18c2, 0x10DE, "NVIDIA GH200-1-12CME" },
    { 0x2342, 0x18c3, 0x10DE, "NVIDIA GH200-1-12C" },
    { 0x2342, 0x18c4, 0x10DE, "NVIDIA GH200-1-24C" },
    { 0x2342, 0x18c5, 0x10DE, "NVIDIA GH200-2-24C" },
    { 0x2342, 0x18c6, 0x10DE, "NVIDIA GH200-3-48C" },
    { 0x2342, 0x18c7, 0x10DE, "NVIDIA GH200-4-48C" },
    { 0x2342, 0x18c8, 0x10DE, "NVIDIA GH200-7-96C" },
    { 0x2342, 0x18c9, 0x10DE, "NVIDIA GH200-96C" },
    { 0x2348, 0x20c2, 0x10DE, "NVIDIA GH200L-1-18CME" },
    { 0x2348, 0x20c3, 0x10DE, "NVIDIA GH200L-1-18C" },
    { 0x2348, 0x20c4, 0x10DE, "NVIDIA GH200L-1-36C" },
    { 0x2348, 0x20c5, 0x10DE, "NVIDIA GH200L-2-36C" },
    { 0x2348, 0x20c6, 0x10DE, "NVIDIA GH200L-3-72C" },
    { 0x2348, 0x20c7, 0x10DE, "NVIDIA GH200L-4-72C" },
    { 0x2348, 0x20c8, 0x10DE, "NVIDIA GH200L-7-144C" },
    { 0x2348, 0x20c9, 0x10DE, "NVIDIA GH200L-144C" },
    { 0x25B6, 0x159d, 0x10DE, "NVIDIA A16-1B" },
    { 0x25B6, 0x159e, 0x10DE, "NVIDIA A16-2B" },
    { 0x25B6, 0x159f, 0x10DE, "NVIDIA A16-1Q" },
    { 0x25B6, 0x1600, 0x10DE, "NVIDIA A16-2Q" },
    { 0x25B6, 0x1601, 0x10DE, "NVIDIA A16-4Q" },
    { 0x25B6, 0x1602, 0x10DE, "NVIDIA A16-8Q" },
    { 0x25B6, 0x1603, 0x10DE, "NVIDIA A16-16Q" },
    { 0x25B6, 0x1604, 0x10DE, "NVIDIA A16-1A" },
    { 0x25B6, 0x1605, 0x10DE, "NVIDIA A16-2A" },
    { 0x25B6, 0x1606, 0x10DE, "NVIDIA A16-4A" },
    { 0x25B6, 0x1607, 0x10DE, "NVIDIA A16-8A" },
    { 0x25B6, 0x1608, 0x10DE, "NVIDIA A16-16A" },
    { 0x25B6, 0x1609, 0x10DE, "NVIDIA A16-4C" },
    { 0x25B6, 0x160a, 0x10DE, "NVIDIA A16-8C" },
    { 0x25B6, 0x160b, 0x10DE, "NVIDIA A16-16C" },
    { 0x25B6, 0x1646, 0x10DE, "NVIDIA A2-1B" },
    { 0x25B6, 0x1647, 0x10DE, "NVIDIA A2-2B" },
    { 0x25B6, 0x1648, 0x10DE, "NVIDIA A2-1Q" },
    { 0x25B6, 0x1649, 0x10DE, "NVIDIA A2-2Q" },
    { 0x25B6, 0x164a, 0x10DE, "NVIDIA A2-4Q" },
    { 0x25B6, 0x164b, 0x10DE, "NVIDIA A2-8Q" },
    { 0x25B6, 0x164c, 0x10DE, "NVIDIA A2-16Q" },
    { 0x25B6, 0x164d, 0x10DE, "NVIDIA A2-1A" },
    { 0x25B6, 0x164e, 0x10DE, "NVIDIA A2-2A" },
    { 0x25B6, 0x164f, 0x10DE, "NVIDIA A2-4A" },
    { 0x25B6, 0x1650, 0x10DE, "NVIDIA A2-8A" },
    { 0x25B6, 0x1651, 0x10DE, "NVIDIA A2-16A" },
    { 0x25B6, 0x1652, 0x10DE, "NVIDIA A2-4" },
    { 0x25B6, 0x1653, 0x10DE, "NVIDIA A2-8" },
    { 0x25B6, 0x1654, 0x10DE, "NVIDIA A2-16" },
    { 0x25B6, 0x1655, 0x10DE, "NVIDIA A2-4C" },
    { 0x25B6, 0x1656, 0x10DE, "NVIDIA A2-8C" },
    { 0x25B6, 0x1657, 0x10DE, "NVIDIA A2-16C" },
    { 0x26B1, 0x1708, 0x10DE, "NVIDIA RTX6000-Ada-1B" },
    { 0x26B1, 0x1709, 0x10DE, "NVIDIA RTX6000-Ada-2B" },
    { 0x26B1, 0x170a, 0x10DE, "NVIDIA RTX6000-Ada-1Q" },
    { 0x26B1, 0x170b, 0x10DE, "NVIDIA RTX6000-Ada-2Q" },
    { 0x26B1, 0x170c, 0x10DE, "NVIDIA RTX6000-Ada-3Q" },
    { 0x26B1, 0x170d, 0x10DE, "NVIDIA RTX6000-Ada-4Q" },
    { 0x26B1, 0x170e, 0x10DE, "NVIDIA RTX6000-Ada-6Q" },
    { 0x26B1, 0x170f, 0x10DE, "NVIDIA RTX6000-Ada-8Q" },
    { 0x26B1, 0x1710, 0x10DE, "NVIDIA RTX6000-Ada-12Q" },
    { 0x26B1, 0x1711, 0x10DE, "NVIDIA RTX6000-Ada-16Q" },
    { 0x26B1, 0x1712, 0x10DE, "NVIDIA RTX6000-Ada-24Q" },
    { 0x26B1, 0x1713, 0x10DE, "NVIDIA RTX6000-Ada-48Q" },
    { 0x26B1, 0x1714, 0x10DE, "NVIDIA RTX6000-Ada-1A" },
    { 0x26B1, 0x1715, 0x10DE, "NVIDIA RTX6000-Ada-2A" },
    { 0x26B1, 0x1716, 0x10DE, "NVIDIA RTX6000-Ada-3A" },
    { 0x26B1, 0x1717, 0x10DE, "NVIDIA RTX6000-Ada-4A" },
    { 0x26B1, 0x1718, 0x10DE, "NVIDIA RTX6000-Ada-6A" },
    { 0x26B1, 0x1719, 0x10DE, "NVIDIA RTX6000-Ada-8A" },
    { 0x26B1, 0x171a, 0x10DE, "NVIDIA RTX6000-Ada-12A" },
    { 0x26B1, 0x171b, 0x10DE, "NVIDIA RTX6000-Ada-16A" },
    { 0x26B1, 0x171c, 0x10DE, "NVIDIA RTX6000-Ada-24A" },
    { 0x26B1, 0x171d, 0x10DE, "NVIDIA RTX6000-Ada-48A" },
    { 0x26B1, 0x171e, 0x10DE, "NVIDIA RTX6000-Ada-1" },
    { 0x26B1, 0x171f, 0x10DE, "NVIDIA RTX6000-Ada-2" },
    { 0x26B1, 0x1720, 0x10DE, "NVIDIA RTX6000-Ada-3" },
    { 0x26B1, 0x1721, 0x10DE, "NVIDIA RTX6000-Ada-4" },
    { 0x26B1, 0x1722, 0x10DE, "NVIDIA RTX6000-Ada-6" },
    { 0x26B1, 0x1723, 0x10DE, "NVIDIA RTX6000-Ada-8" },
    { 0x26B1, 0x1724, 0x10DE, "NVIDIA RTX6000-Ada-12" },
    { 0x26B1, 0x1725, 0x10DE, "NVIDIA RTX6000-Ada-16" },
    { 0x26B1, 0x1726, 0x10DE, "NVIDIA RTX6000-Ada-24" },
    { 0x26B1, 0x1727, 0x10DE, "NVIDIA RTX6000-Ada-48" },
    { 0x26B1, 0x1728, 0x10DE, "NVIDIA RTX6000-Ada-4C" },
    { 0x26B1, 0x1729, 0x10DE, "NVIDIA RTX6000-Ada-6C" },
    { 0x26B1, 0x172a, 0x10DE, "NVIDIA RTX6000-Ada-8C" },
    { 0x26B1, 0x172b, 0x10DE, "NVIDIA RTX6000-Ada-12C" },
    { 0x26B1, 0x172c, 0x10DE, "NVIDIA RTX6000-Ada-16C" },
    { 0x26B1, 0x172d, 0x10DE, "NVIDIA RTX6000-Ada-24C" },
    { 0x26B1, 0x172e, 0x10DE, "NVIDIA RTX6000-Ada-48C" },
    { 0x26B2, 0x1821, 0x10DE, "NVIDIA RTX5000-Ada-1B" },
    { 0x26B2, 0x1822, 0x10DE, "NVIDIA RTX5000-Ada-2B" },
    { 0x26B2, 0x1823, 0x10DE, "NVIDIA RTX5000-Ada-1Q" },
    { 0x26B2, 0x1824, 0x10DE, "NVIDIA RTX5000-Ada-2Q" },
    { 0x26B2, 0x1825, 0x10DE, "NVIDIA RTX5000-Ada-4Q" },
    { 0x26B2, 0x1826, 0x10DE, "NVIDIA RTX5000-Ada-8Q" },
    { 0x26B2, 0x1827, 0x10DE, "NVIDIA RTX5000-Ada-16Q" },
    { 0x26B2, 0x1828, 0x10DE, "NVIDIA RTX5000-Ada-32Q" },
    { 0x26B2, 0x1829, 0x10DE, "NVIDIA RTX5000-Ada-1A" },
    { 0x26B2, 0x182a, 0x10DE, "NVIDIA RTX5000-Ada-2A" },
    { 0x26B2, 0x182b, 0x10DE, "NVIDIA RTX5000-Ada-4A" },
    { 0x26B2, 0x182c, 0x10DE, "NVIDIA RTX5000-Ada-8A" },
    { 0x26B2, 0x182d, 0x10DE, "NVIDIA RTX5000-Ada-16A" },
    { 0x26B2, 0x182e, 0x10DE, "NVIDIA RTX5000-Ada-32A" },
    { 0x26B2, 0x182f, 0x10DE, "NVIDIA RTX5000-Ada-1" },
    { 0x26B2, 0x1830, 0x10DE, "NVIDIA RTX5000-Ada-2" },
    { 0x26B2, 0x1831, 0x10DE, "NVIDIA RTX5000-Ada-4" },
    { 0x26B2, 0x1832, 0x10DE, "NVIDIA RTX5000-Ada-8" },
    { 0x26B2, 0x1833, 0x10DE, "NVIDIA RTX5000-Ada-16" },
    { 0x26B2, 0x1834, 0x10DE, "NVIDIA RTX5000-Ada-32" },
    { 0x26B2, 0x1835, 0x10DE, "NVIDIA RTX5000-Ada-4C" },
    { 0x26B2, 0x1836, 0x10DE, "NVIDIA RTX5000-Ada-8C" },
    { 0x26B2, 0x1837, 0x10DE, "NVIDIA RTX5000-Ada-16C" },
    { 0x26B2, 0x1838, 0x10DE, "NVIDIA RTX5000-Ada-32C" },
    { 0x26B3, 0x1958, 0x10DE, "NVIDIA RTX5880-Ada-1B" },
    { 0x26B3, 0x1959, 0x10DE, "NVIDIA RTX5880-Ada-2B" },
    { 0x26B3, 0x195a, 0x10DE, "NVIDIA RTX5880-Ada-1Q" },
    { 0x26B3, 0x195b, 0x10DE, "NVIDIA RTX5880-Ada-2Q" },
    { 0x26B3, 0x195c, 0x10DE, "NVIDIA RTX5880-Ada-3Q" },
    { 0x26B3, 0x195d, 0x10DE, "NVIDIA RTX5880-Ada-4Q" },
    { 0x26B3, 0x195e, 0x10DE, "NVIDIA RTX5880-Ada-6Q" },
    { 0x26B3, 0x195f, 0x10DE, "NVIDIA RTX5880-Ada-8Q" },
    { 0x26B3, 0x1960, 0x10DE, "NVIDIA RTX5880-Ada-12Q" },
    { 0x26B3, 0x1961, 0x10DE, "NVIDIA RTX5880-Ada-16Q" },
    { 0x26B3, 0x1962, 0x10DE, "NVIDIA RTX5880-Ada-24Q" },
    { 0x26B3, 0x1963, 0x10DE, "NVIDIA RTX5880-Ada-48Q" },
    { 0x26B3, 0x1964, 0x10DE, "NVIDIA RTX5880-Ada-1A" },
    { 0x26B3, 0x1965, 0x10DE, "NVIDIA RTX5880-Ada-2A" },
    { 0x26B3, 0x1966, 0x10DE, "NVIDIA RTX5880-Ada-3A" },
    { 0x26B3, 0x1967, 0x10DE, "NVIDIA RTX5880-Ada-4A" },
    { 0x26B3, 0x1968, 0x10DE, "NVIDIA RTX5880-Ada-6A" },
    { 0x26B3, 0x1969, 0x10DE, "NVIDIA RTX5880-Ada-8A" },
    { 0x26B3, 0x196a, 0x10DE, "NVIDIA RTX5880-Ada-12A" },
    { 0x26B3, 0x196b, 0x10DE, "NVIDIA RTX5880-Ada-16A" },
    { 0x26B3, 0x196c, 0x10DE, "NVIDIA RTX5880-Ada-24A" },
    { 0x26B3, 0x196d, 0x10DE, "NVIDIA RTX5880-Ada-48A" },
    { 0x26B3, 0x196e, 0x10DE, "NVIDIA RTX5880-Ada-1" },
    { 0x26B3, 0x196f, 0x10DE, "NVIDIA RTX5880-Ada-2" },
    { 0x26B3, 0x1970, 0x10DE, "NVIDIA RTX5880-Ada-3" },
    { 0x26B3, 0x1971, 0x10DE, "NVIDIA RTX5880-Ada-4" },
    { 0x26B3, 0x1972, 0x10DE, "NVIDIA RTX5880-Ada-6" },
    { 0x26B3, 0x1973, 0x10DE, "NVIDIA RTX5880-Ada-8" },
    { 0x26B3, 0x1974, 0x10DE, "NVIDIA RTX5880-Ada-12" },
    { 0x26B3, 0x1975, 0x10DE, "NVIDIA RTX5880-Ada-16" },
    { 0x26B3, 0x1976, 0x10DE, "NVIDIA RTX5880-Ada-24" },
    { 0x26B3, 0x1977, 0x10DE, "NVIDIA RTX5880-Ada-48" },
    { 0x26B3, 0x1978, 0x10DE, "NVIDIA RTX5880-Ada-4C" },
    { 0x26B3, 0x1979, 0x10DE, "NVIDIA RTX5880-Ada-6C" },
    { 0x26B3, 0x197a, 0x10DE, "NVIDIA RTX5880-Ada-8C" },
    { 0x26B3, 0x197b, 0x10DE, "NVIDIA RTX5880-Ada-12C" },
    { 0x26B3, 0x197c, 0x10DE, "NVIDIA RTX5880-Ada-16C" },
    { 0x26B3, 0x197d, 0x10DE, "NVIDIA RTX5880-Ada-24C" },
    { 0x26B3, 0x197e, 0x10DE, "NVIDIA RTX5880-Ada-48C" },
    { 0x26B5, 0x176d, 0x10DE, "NVIDIA L40-1B" },
    { 0x26B5, 0x176e, 0x10DE, "NVIDIA L40-2B" },
    { 0x26B5, 0x176f, 0x10DE, "NVIDIA L40-1Q" },
    { 0x26B5, 0x1770, 0x10DE, "NVIDIA L40-2Q" },
    { 0x26B5, 0x1771, 0x10DE, "NVIDIA L40-3Q" },
    { 0x26B5, 0x1772, 0x10DE, "NVIDIA L40-4Q" },
    { 0x26B5, 0x1773, 0x10DE, "NVIDIA L40-6Q" },
    { 0x26B5, 0x1774, 0x10DE, "NVIDIA L40-8Q" },
    { 0x26B5, 0x1775, 0x10DE, "NVIDIA L40-12Q" },
    { 0x26B5, 0x1776, 0x10DE, "NVIDIA L40-16Q" },
    { 0x26B5, 0x1777, 0x10DE, "NVIDIA L40-24Q" },
    { 0x26B5, 0x1778, 0x10DE, "NVIDIA L40-48Q" },
    { 0x26B5, 0x1779, 0x10DE, "NVIDIA L40-1A" },
    { 0x26B5, 0x177a, 0x10DE, "NVIDIA L40-2A" },
    { 0x26B5, 0x177b, 0x10DE, "NVIDIA L40-3A" },
    { 0x26B5, 0x177c, 0x10DE, "NVIDIA L40-4A" },
    { 0x26B5, 0x177d, 0x10DE, "NVIDIA L40-6A" },
    { 0x26B5, 0x177e, 0x10DE, "NVIDIA L40-8A" },
    { 0x26B5, 0x177f, 0x10DE, "NVIDIA L40-12A" },
    { 0x26B5, 0x1780, 0x10DE, "NVIDIA L40-16A" },
    { 0x26B5, 0x1781, 0x10DE, "NVIDIA L40-24A" },
    { 0x26B5, 0x1782, 0x10DE, "NVIDIA L40-48A" },
    { 0x26B5, 0x1783, 0x10DE, "NVIDIA L40-1" },
    { 0x26B5, 0x1784, 0x10DE, "NVIDIA L40-2" },
    { 0x26B5, 0x1785, 0x10DE, "NVIDIA L40-3" },
    { 0x26B5, 0x1786, 0x10DE, "NVIDIA L40-4" },
    { 0x26B5, 0x1787, 0x10DE, "NVIDIA L40-6" },
    { 0x26B5, 0x1788, 0x10DE, "NVIDIA L40-8" },
    { 0x26B5, 0x1789, 0x10DE, "NVIDIA L40-12" },
    { 0x26B5, 0x178a, 0x10DE, "NVIDIA L40-16" },
    { 0x26B5, 0x178b, 0x10DE, "NVIDIA L40-24" },
    { 0x26B5, 0x178c, 0x10DE, "NVIDIA L40-48" },
    { 0x26B5, 0x178d, 0x10DE, "NVIDIA L40-4C" },
    { 0x26B5, 0x178e, 0x10DE, "NVIDIA L40-6C" },
    { 0x26B5, 0x178f, 0x10DE, "NVIDIA L40-8C" },
    { 0x26B5, 0x1790, 0x10DE, "NVIDIA L40-12C" },
    { 0x26B5, 0x1791, 0x10DE, "NVIDIA L40-16C" },
    { 0x26B5, 0x1792, 0x10DE, "NVIDIA L40-24C" },
    { 0x26B5, 0x1793, 0x10DE, "NVIDIA L40-48C" },
    { 0x26B5, 0x1818, 0x10DE, "NVIDIA GeForce RTX 3060" },
    { 0x26B5, 0x181a, 0x10DE, "NVIDIA GeForce RTX 3050" },
    { 0x26B8, 0x174e, 0x10DE, "NVIDIA L40G-1B" },
    { 0x26B8, 0x174f, 0x10DE, "NVIDIA L40G-2B" },
    { 0x26B8, 0x1750, 0x10DE, "NVIDIA L40G-1Q" },
    { 0x26B8, 0x1751, 0x10DE, "NVIDIA L40G-2Q" },
    { 0x26B8, 0x1752, 0x10DE, "NVIDIA L40G-3Q" },
    { 0x26B8, 0x1753, 0x10DE, "NVIDIA L40G-4Q" },
    { 0x26B8, 0x1754, 0x10DE, "NVIDIA L40G-6Q" },
    { 0x26B8, 0x1755, 0x10DE, "NVIDIA L40G-8Q" },
    { 0x26B8, 0x1756, 0x10DE, "NVIDIA L40G-12Q" },
    { 0x26B8, 0x1757, 0x10DE, "NVIDIA L40G-24Q" },
    { 0x26B8, 0x1758, 0x10DE, "NVIDIA L40G-1A" },
    { 0x26B8, 0x1759, 0x10DE, "NVIDIA L40G-2A" },
    { 0x26B8, 0x175a, 0x10DE, "NVIDIA L40G-3A" },
    { 0x26B8, 0x175b, 0x10DE, "NVIDIA L40G-4A" },
    { 0x26B8, 0x175c, 0x10DE, "NVIDIA L40G-6A" },
    { 0x26B8, 0x175d, 0x10DE, "NVIDIA L40G-8A" },
    { 0x26B8, 0x175e, 0x10DE, "NVIDIA L40G-12A" },
    { 0x26B8, 0x175f, 0x10DE, "NVIDIA L40G-24A" },
    { 0x26B8, 0x1760, 0x10DE, "NVIDIA L40G-1" },
    { 0x26B8, 0x1761, 0x10DE, "NVIDIA L40G-2" },
    { 0x26B8, 0x1762, 0x10DE, "NVIDIA L40G-3" },
    { 0x26B8, 0x1763, 0x10DE, "NVIDIA L40G-4" },
    { 0x26B8, 0x1764, 0x10DE, "NVIDIA L40G-6" },
    { 0x26B8, 0x1765, 0x10DE, "NVIDIA L40G-8" },
    { 0x26B8, 0x1766, 0x10DE, "NVIDIA L40G-12" },
    { 0x26B8, 0x1767, 0x10DE, "NVIDIA L40G-24" },
    { 0x26B8, 0x1768, 0x10DE, "NVIDIA L40G-4C" },
    { 0x26B8, 0x1769, 0x10DE, "NVIDIA L40G-6C" },
    { 0x26B8, 0x176a, 0x10DE, "NVIDIA L40G-8C" },
    { 0x26B8, 0x176b, 0x10DE, "NVIDIA L40G-12C" },
    { 0x26B8, 0x176c, 0x10DE, "NVIDIA L40G-24C" },
    { 0x26B8, 0x181c, 0x10DE, "NVIDIA GeForce RTX 3060" },
    { 0x26B8, 0x181e, 0x10DE, "NVIDIA GeForce RTX 3050" },
    { 0x26B9, 0x1889, 0x10DE, "NVIDIA L40S-1B" },
    { 0x26B9, 0x188a, 0x10DE, "NVIDIA L40S-2B" },
    { 0x26B9, 0x188b, 0x10DE, "NVIDIA L40S-1Q" },
    { 0x26B9, 0x188c, 0x10DE, "NVIDIA L40S-2Q" },
    { 0x26B9, 0x188d, 0x10DE, "NVIDIA L40S-3Q" },
    { 0x26B9, 0x188e, 0x10DE, "NVIDIA L40S-4Q" },
    { 0x26B9, 0x188f, 0x10DE, "NVIDIA L40S-6Q" },
    { 0x26B9, 0x1890, 0x10DE, "NVIDIA L40S-8Q" },
    { 0x26B9, 0x1891, 0x10DE, "NVIDIA L40S-12Q" },
    { 0x26B9, 0x1892, 0x10DE, "NVIDIA L40S-16Q" },
    { 0x26B9, 0x1893, 0x10DE, "NVIDIA L40S-24Q" },
    { 0x26B9, 0x1894, 0x10DE, "NVIDIA L40S-48Q" },
    { 0x26B9, 0x1895, 0x10DE, "NVIDIA L40S-1A" },
    { 0x26B9, 0x1896, 0x10DE, "NVIDIA L40S-2A" },
    { 0x26B9, 0x1897, 0x10DE, "NVIDIA L40S-3A" },
    { 0x26B9, 0x1898, 0x10DE, "NVIDIA L40S-4A" },
    { 0x26B9, 0x1899, 0x10DE, "NVIDIA L40S-6A" },
    { 0x26B9, 0x189a, 0x10DE, "NVIDIA L40S-8A" },
    { 0x26B9, 0x189b, 0x10DE, "NVIDIA L40S-12A" },
    { 0x26B9, 0x189c, 0x10DE, "NVIDIA L40S-16A" },
    { 0x26B9, 0x189d, 0x10DE, "NVIDIA L40S-24A" },
    { 0x26B9, 0x189e, 0x10DE, "NVIDIA L40S-48A" },
    { 0x26B9, 0x189f, 0x10DE, "NVIDIA GeForce RTX 3050" },
    { 0x26B9, 0x18a0, 0x10DE, "NVIDIA GeForce RTX 3060" },
    { 0x26B9, 0x18a1, 0x10DE, "NVIDIA L40S-1" },
    { 0x26B9, 0x18a2, 0x10DE, "NVIDIA L40S-2" },
    { 0x26B9, 0x18a3, 0x10DE, "NVIDIA L40S-3" },
    { 0x26B9, 0x18a4, 0x10DE, "NVIDIA L40S-4" },
    { 0x26B9, 0x18a5, 0x10DE, "NVIDIA L40S-6" },
    { 0x26B9, 0x18a6, 0x10DE, "NVIDIA L40S-8" },
    { 0x26B9, 0x18a7, 0x10DE, "NVIDIA L40S-12" },
    { 0x26B9, 0x18a8, 0x10DE, "NVIDIA L40S-16" },
    { 0x26B9, 0x18a9, 0x10DE, "NVIDIA L40S-24" },
    { 0x26B9, 0x18aa, 0x10DE, "NVIDIA L40S-48" },
    { 0x26B9, 0x18ab, 0x10DE, "NVIDIA L40S-4C" },
    { 0x26B9, 0x18ac, 0x10DE, "NVIDIA L40S-6C" },
    { 0x26B9, 0x18ad, 0x10DE, "NVIDIA L40S-8C" },
    { 0x26B9, 0x18ae, 0x10DE, "NVIDIA L40S-12C" },
    { 0x26B9, 0x18af, 0x10DE, "NVIDIA L40S-16C" },
    { 0x26B9, 0x18b0, 0x10DE, "NVIDIA L40S-24C" },
    { 0x26B9, 0x18b1, 0x10DE, "NVIDIA L40S-48C" },
    { 0x26BA, 0x1909, 0x10DE, "NVIDIA L20-1B" },
    { 0x26BA, 0x190a, 0x10DE, "NVIDIA L20-2B" },
    { 0x26BA, 0x190b, 0x10DE, "NVIDIA L20-1Q" },
    { 0x26BA, 0x190c, 0x10DE, "NVIDIA L20-2Q" },
    { 0x26BA, 0x190d, 0x10DE, "NVIDIA L20-3Q" },
    { 0x26BA, 0x190e, 0x10DE, "NVIDIA L20-4Q" },
    { 0x26BA, 0x190f, 0x10DE, "NVIDIA L20-6Q" },
    { 0x26BA, 0x1910, 0x10DE, "NVIDIA L20-8Q" },
    { 0x26BA, 0x1911, 0x10DE, "NVIDIA L20-12Q" },
    { 0x26BA, 0x1912, 0x10DE, "NVIDIA L20-16Q" },
    { 0x26BA, 0x1913, 0x10DE, "NVIDIA L20-24Q" },
    { 0x26BA, 0x1914, 0x10DE, "NVIDIA L20-48Q" },
    { 0x26BA, 0x1915, 0x10DE, "NVIDIA L20-1A" },
    { 0x26BA, 0x1916, 0x10DE, "NVIDIA L20-2A" },
    { 0x26BA, 0x1917, 0x10DE, "NVIDIA L20-3A" },
    { 0x26BA, 0x1918, 0x10DE, "NVIDIA L20-4A" },
    { 0x26BA, 0x1919, 0x10DE, "NVIDIA L20-6A" },
    { 0x26BA, 0x191a, 0x10DE, "NVIDIA L20-8A" },
    { 0x26BA, 0x191b, 0x10DE, "NVIDIA L20-12A" },
    { 0x26BA, 0x191c, 0x10DE, "NVIDIA L20-16A" },
    { 0x26BA, 0x191d, 0x10DE, "NVIDIA L20-24A" },
    { 0x26BA, 0x191e, 0x10DE, "NVIDIA L20-48A" },
    { 0x26BA, 0x191f, 0x10DE, "NVIDIA GeForce RTX 3050" },
    { 0x26BA, 0x1920, 0x10DE, "NVIDIA GeForce RTX 3060" },
    { 0x26BA, 0x1921, 0x10DE, "NVIDIA L20-1" },
    { 0x26BA, 0x1922, 0x10DE, "NVIDIA L20-2" },
    { 0x26BA, 0x1923, 0x10DE, "NVIDIA L20-3" },
    { 0x26BA, 0x1924, 0x10DE, "NVIDIA L20-4" },
    { 0x26BA, 0x1925, 0x10DE, "NVIDIA L20-6" },
    { 0x26BA, 0x1926, 0x10DE, "NVIDIA L20-8" },
    { 0x26BA, 0x1927, 0x10DE, "NVIDIA L20-12" },
    { 0x26BA, 0x1928, 0x10DE, "NVIDIA L20-16" },
    { 0x26BA, 0x1929, 0x10DE, "NVIDIA L20-24" },
    { 0x26BA, 0x192a, 0x10DE, "NVIDIA L20-48" },
    { 0x26BA, 0x192b, 0x10DE, "NVIDIA L20-4C" },
    { 0x26BA, 0x192c, 0x10DE, "NVIDIA L20-6C" },
    { 0x26BA, 0x192d, 0x10DE, "NVIDIA L20-8C" },
    { 0x26BA, 0x192e, 0x10DE, "NVIDIA L20-12C" },
    { 0x26BA, 0x192f, 0x10DE, "NVIDIA L20-16C" },
    { 0x26BA, 0x1930, 0x10DE, "NVIDIA L20-24C" },
    { 0x26BA, 0x1931, 0x10DE, "NVIDIA L20-48C" },
    { 0x27B6, 0x1938, 0x10DE, "NVIDIA L2-1B" },
    { 0x27B6, 0x1939, 0x10DE, "NVIDIA L2-2B" },
    { 0x27B6, 0x193a, 0x10DE, "NVIDIA L2-1Q" },
    { 0x27B6, 0x193b, 0x10DE, "NVIDIA L2-2Q" },
    { 0x27B6, 0x193c, 0x10DE, "NVIDIA L2-3Q" },
    { 0x27B6, 0x193d, 0x10DE, "NVIDIA L2-4Q" },
    { 0x27B6, 0x193e, 0x10DE, "NVIDIA L2-6Q" },
    { 0x27B6, 0x193f, 0x10DE, "NVIDIA L2-8Q" },
    { 0x27B6, 0x1940, 0x10DE, "NVIDIA L2-12Q" },
    { 0x27B6, 0x1941, 0x10DE, "NVIDIA L2-24Q" },
    { 0x27B6, 0x1942, 0x10DE, "NVIDIA L2-1A" },
    { 0x27B6, 0x1943, 0x10DE, "NVIDIA L2-2A" },
    { 0x27B6, 0x1944, 0x10DE, "NVIDIA L2-3A" },
    { 0x27B6, 0x1945, 0x10DE, "NVIDIA L2-4A" },
    { 0x27B6, 0x1946, 0x10DE, "NVIDIA L2-6A" },
    { 0x27B6, 0x1947, 0x10DE, "NVIDIA L2-8A" },
    { 0x27B6, 0x1948, 0x10DE, "NVIDIA L2-12A" },
    { 0x27B6, 0x1949, 0x10DE, "NVIDIA L2-24A" },
    { 0x27B6, 0x194a, 0x10DE, "NVIDIA L2-1" },
    { 0x27B6, 0x194b, 0x10DE, "NVIDIA L2-2" },
    { 0x27B6, 0x194c, 0x10DE, "NVIDIA L2-3" },
    { 0x27B6, 0x194d, 0x10DE, "NVIDIA L2-4" },
    { 0x27B6, 0x194e, 0x10DE, "NVIDIA L2-6" },
    { 0x27B6, 0x194f, 0x10DE, "NVIDIA L2-8" },
    { 0x27B6, 0x1950, 0x10DE, "NVIDIA L2-12" },
    { 0x27B6, 0x1951, 0x10DE, "NVIDIA L2-24" },
    { 0x27B6, 0x1952, 0x10DE, "NVIDIA L2-4C" },
    { 0x27B6, 0x1953, 0x10DE, "NVIDIA L2-6C" },
    { 0x27B6, 0x1954, 0x10DE, "NVIDIA L2-8C" },
    { 0x27B6, 0x1955, 0x10DE, "NVIDIA L2-12C" },
    { 0x27B6, 0x1956, 0x10DE, "NVIDIA L2-24C" },
    { 0x27B8, 0x172f, 0x10DE, "NVIDIA L4-1B" },
    { 0x27B8, 0x1730, 0x10DE, "NVIDIA L4-2B" },
    { 0x27B8, 0x1731, 0x10DE, "NVIDIA L4-1Q" },
    { 0x27B8, 0x1732, 0x10DE, "NVIDIA L4-2Q" },
    { 0x27B8, 0x1733, 0x10DE, "NVIDIA L4-3Q" },
    { 0x27B8, 0x1734, 0x10DE, "NVIDIA L4-4Q" },
    { 0x27B8, 0x1735, 0x10DE, "NVIDIA L4-6Q" },
    { 0x27B8, 0x1736, 0x10DE, "NVIDIA L4-8Q" },
    { 0x27B8, 0x1737, 0x10DE, "NVIDIA L4-12Q" },
    { 0x27B8, 0x1738, 0x10DE, "NVIDIA L4-24Q" },
    { 0x27B8, 0x1739, 0x10DE, "NVIDIA L4-1A" },
    { 0x27B8, 0x173a, 0x10DE, "NVIDIA L4-2A" },
    { 0x27B8, 0x173b, 0x10DE, "NVIDIA L4-3A" },
    { 0x27B8, 0x173c, 0x10DE, "NVIDIA L4-4A" },
    { 0x27B8, 0x173d, 0x10DE, "NVIDIA L4-6A" },
    { 0x27B8, 0x173e, 0x10DE, "NVIDIA L4-8A" },
    { 0x27B8, 0x173f, 0x10DE, "NVIDIA L4-12A" },
    { 0x27B8, 0x1740, 0x10DE, "NVIDIA L4-24A" },
    { 0x27B8, 0x1741, 0x10DE, "NVIDIA L4-1" },
    { 0x27B8, 0x1742, 0x10DE, "NVIDIA L4-2" },
    { 0x27B8, 0x1743, 0x10DE, "NVIDIA L4-3" },
    { 0x27B8, 0x1744, 0x10DE, "NVIDIA L4-4" },
    { 0x27B8, 0x1745, 0x10DE, "NVIDIA L4-6" },
    { 0x27B8, 0x1746, 0x10DE, "NVIDIA L4-8" },
    { 0x27B8, 0x1747, 0x10DE, "NVIDIA L4-12" },
    { 0x27B8, 0x1748, 0x10DE, "NVIDIA L4-24" },
    { 0x27B8, 0x1749, 0x10DE, "NVIDIA L4-4C" },
    { 0x27B8, 0x174a, 0x10DE, "NVIDIA L4-6C" },
    { 0x27B8, 0x174b, 0x10DE, "NVIDIA L4-8C" },
    { 0x27B8, 0x174c, 0x10DE, "NVIDIA L4-12C" },
    { 0x27B8, 0x174d, 0x10DE, "NVIDIA L4-24C" },
    { 0x2941, 0x20cb, 0x10DE, "NVIDIA GB200-1-24CME" },
    { 0x2941, 0x20cc, 0x10DE, "NVIDIA GB200-1-24C" },
    { 0x2941, 0x20cd, 0x10DE, "NVIDIA GB200-1-47C" },
    { 0x2941, 0x20ce, 0x10DE, "NVIDIA GB200-2-47C" },
    { 0x2941, 0x20cf, 0x10DE, "NVIDIA GB200-3-95C" },
    { 0x2941, 0x20d0, 0x10DE, "NVIDIA GB200-4-95C" },
    { 0x2941, 0x20d1, 0x10DE, "NVIDIA GB200-7-189C" },
    { 0x2941, 0x20d2, 0x10DE, "NVIDIA GB200-189C" },
};

#endif // G_NV_NAME_RELEASED_H
