"<qt title='Evolvotron User Manual'>\n"
"<h1>Evolvotron User Manual</h1>\n"
"\n"
"<p>\n"
"  Evolvotron is interactive &quot;generative art&quot; software to evolve \n"
"  images/textures/patterns through an iterative process of random \n"
"  mutation and user-selection driven evolution. \n"
"</p>\n"
"<p>\n"
"  On starting the application, a grid of images is displayed. \n"
"  Resize or maximise the application if you like, but the more \n"
"  pixels have to be calculated, the slower it will be. \n"
"  (For the default 2D image mode, you will need a fast machine or patience. \n"
"  For the optional animation mode, you will need both.) \n"
"</p>\n"
"<p>\n"
"  Simply repeat the following until bored: \n"
"  <ul><li>Click (singleclick) on an image you like to \n"
"  spawn the next generation of its mutant offspring. \n"
"  </li><li>Wait until variations on it are regenerated in sufficient \n"
"  detail that you can decide which one you like best again. \n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<p>\n"
"  IMPORTANT: Initially you should select images with some sort of variation. \n"
"  If you select a uniform image, you may get stuck in a degenerate zone with \n"
"  little to mutate and therefore little chance of escape to more interesting \n"
"  images. You can always reset/restart from the &quot;File&quot; menu (the difference is \n"
"  that &quot;reset&quot; also resets the mutation parameters to their default values). \n"
"  Selecting one of the &quot;warp&quot; options from a context menu (right-click on \n"
"  an image) can also help by introducing an additional opportunity for \n"
"  mutation on subsequent spawns. \n"
"</p>\n"
"<p>\n"
"  Note that various spirals, grids and tiles, although complex looking, \n"
"  are actually implemented by a single function node and may leave you stuck too. \n"
"</p>\n"
"<h2>Command Line Options</h2>\n"
"<p>\n"
"  The following are equivalent: \n"
"  <ul><li>evolvotron --grid 12x8 \n"
"  </li><li>evolvotron --grid=12x8 \n"
"  </li><li>evolvotron -g 12x8 \n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<h3>General Options</h3>\n"
"\n"
"<p>\n"
"  <ul><li>-a, --autocool <br>\n"
"  Enable autocooling by default, and cause resets of mutation \n"
"  parameters to re-enable autocooling if it was disabled. \n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<p>\n"
"  <ul><li>-F, --fullscreen <br>\n"
"  Start in &quot;fullscreen&quot; mode (NB for Qt on X11 this means \n"
"  a screen-filling borderless/undecorated window is used; \n"
"  it's not simply maximising the window, and it's not the \n"
"  sort of framebuffer hijacking used by SDL games). The Qt \n"
"  documentation claims some window managers may not be entirely \n"
"  cooperative with this (in which case sorry, you're on your own). \n"
"  evolvotron actions which bring up dialog boxes (e.g save) seem \n"
"  to generally behave fairly sensibly but child windows \n"
"  (e.g enlargements or dialogs) can show some &quot;interesting&quot; behaviour. \n"
"  Fullscreen mode can be toggled within the application using &quot;F&quot; key. \n"
"  The &quot;Esc&quot; key will also exit it. \n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<p>\n"
"  <ul><li>-g, --grid <i>cols</i>x<i>rows</i> <br>\n"
"  Sets size of the grid of image display cells in the main application area (defaults to 5x6) \n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<p>\n"
"  <ul><li>-h, --help <br>\n"
"  Print summary of command line options and exit. \n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<p>\n"
"  <ul><li>-j, --jitter <br>\n"
"  Enable sample jittering. Samples will be made at a random position \n"
"  within a pixel instead of on a regular grid, providing some antialiasing. \n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<p>\n"
"  <ul><li>-m, --multisample <i>multisample grid</i> <br>\n"
"  Enables additional antialiasing passes. \n"
"  Specifing 2 or 3 will provide an additional pass with 2x2 or 3x3 samples per pixel. \n"
"  Specifiying 4 (of higher) will provide a 2x2 and a final 4x4 pass. \n"
"  Specifying 1 provides the default behaviour of one sample per pixel. \n"
"  For best rendering quality also specify -j. \n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<p>\n"
"  <ul><li>-M, --menuhide <br>\n"
"  Start with menu and status bar hidden. Nice with --fullscreen. \n"
"  Hiding can be toggled within the application using ctrl-m. \n"
"  The Esc key will also bring them back. \n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<p>\n"
"  <ul><li>-p, --spheremap <br>\n"
"  Images are produced by sampling the underlying 3D function on the \n"
"  latitude-longitude grid of a sphere. The resulting images should be \n"
"  usable as spheremaps/spherical environment maps. Animations vary \n"
"  the radius of the sphere. NB when in spheremap mode, \n"
"  middle mouse button adjustments do not yet behave like you'd expect. \n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<p>\n"
"  <ul><li>-S, --startup <i>function_filename</i> <br>\n"
"  Specify a function filename (evolvotron's XML format) to load on startup \n"
"  (or reset). The option can be provided multiple times, and this is \n"
"  also the interpretation of any positional arguments. Startup functions \n"
"  are placed in the grid from left to right, top to bottom. \n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<p>\n"
"  <ul><li>-U, --shuffle <br>\n"
"  Use in conjunction with -S / --startup options, to display the specified \n"
"  functions in random order, both on application startup and on each \n"
"  reset of the application. \n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<h3>Animation Options</h3>\n"
"\n"
"<p>\n"
"  <ul><li>-f, --frames <i>frames</i> <br>\n"
"  Number of frames in animations (defaults to 1 i.e no animation) \n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<p>\n"
"  <ul><li>-l, --linear <br>\n"
"  Vary z linearly with time rather than sinusoidally. \n"
"  Sinusoidal variation generally looks better when animations are &quot;bounced&quot; \n"
"  forwards and backwards, but this option is useful when generating slices to \n"
"  use as volumetric textures. \n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<p>\n"
"  <ul><li>-s, --fps <i>framerate</i> <br>\n"
"  Rate at which frames are displayed per second (integer). (Defaults to 8). \n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<h3>Power-user & Debug Options</h3>\n"
"\n"
"<p>\n"
"  Note that the usual Qt/X11 options \n"
"  (for example, -geometry <i>width</i>x<i>height</i> option to set on-screen size in pixels) \n"
"  are processed and removed before evolvotron options are checked. \n"
"</p>\n"
"<p>\n"
"  <ul><li>-D, --debug <br>\n"
"  Puts the certain aspects of the app into a more debug oriented mode. \n"
"  Currently (ie this may change) it simply changes function weightings \n"
"  so virtually all function nodes are FunctionNoiseOneChannel. By itself \n"
"  this is a pretty pointless thing to do, but in conjunction with the -X \n"
"  options it's useful for examining the behaviour of specific functions. \n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<p>\n"
"  <ul><li>-E, --enlargement-threadpool <br>\n"
"  Use a separate thread pool for computing enlargements. \n"
"  Using this option ensures computation of enlargements \n"
"  continue to make some progress even while the main grid \n"
"  is being actively worked on. However, this will be at \n"
"  the expense of main grid rendering performance. \n"
"  Without this option, enlargements' final high-resolution \n"
"  renderings are invariably lower priority than computation \n"
"  for images in the main grid. \n"
"  See also the -N option to control the priority of threads \n"
"  in this pool. \n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<p>\n"
"  <ul><li>-n, --nice <i>niceness</i> <br>\n"
"  Sets additional niceness (relative to the main application thread) \n"
"  of the compute (rendering) thread(s). \n"
"  It's useful to run compute threads at a slightly lower priority \n"
"  (&quot;nice 4\" is the default without this option) than the main (GUI) \n"
"  part of the program (but note that this means other normal/lowish \n"
"  priority tasks running on your machine may slow evolvotron down \n"
"  a bit more than expected). \n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<p>\n"
"  <ul><li>-N, --Nice <i>enlargement niceness</i> <br>\n"
"  Sets additional niceness (relative to the main application thread) \n"
"  of the compute thread(s) computing enlargements (default value is 8). \n"
"  Only effective in conjunction with -E option. \n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<p>\n"
"  <ul><li>-t, --threads <i>threads</i> <br>\n"
"  Sets number of compute threads. \n"
"  If this is not specified, then as many compute threads are created \n"
"  as there are processors on the system (unless this cannot be \n"
"  discovered in which case only a single compute thread is created). \n"
"  Non-linux builds will likely not include code to determine processor count \n"
"  (suitable patches gratefully received). \n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<p>\n"
"  <ul><li>-u, --unwrapped <br>\n"
"  Modifies -F behaviour so that the specified &quot;favourite&quot; function \n"
"  is NOT wrapped by space/colour transforms. NB For functions without leaf nodes \n"
"  or parameters (e.g FunctionSphericalToCartesian) this doesn't \n"
"  leave any scope for variation or future mutation. \n"
"  Function name recognition is case sensitive. \n"
"  Example: \n"
"  <code>evolvotron -F FunctionKaleidoscope -u </code>\n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<p>\n"
"  <ul><li>-v, --verbose <br>\n"
"  Verbose mode, writes various things to application stderr. \n"
"  This is primarily intended to assist debugging. \n"
"  This option used to be useful for getting a list of supported function \n"
"  names for use with the -F option, but those can also be inspected \n"
"  via the Settings dialogs. \n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<p>\n"
"  <ul><li>-x, --favourite <i>functionname</i> <br>\n"
"  Force a specific &quot;favourite&quot; function type to be used at the top level \n"
"  of all function trees. The specified function is still wrapped \n"
"  by spatial and colour warping functions which may disguise \n"
"  it considerably. A list of all the function names understood \n"
"  by evolvotron is output during app startup when the -v option \n"
"  is specified. Function name recognition is case sensitive. \n"
"  Example: \n"
"  <code>evolvotron -F FunctionSpiralLinear </code>\n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<h2>Mouse Control</h2>\n"
"\n"
"<h3>Left-click</h3>\n"
"<p>\n"
"  A left-click on an image in the main window spawns the mutant offspring \n"
"  of that image to all the other (non-locked) displays in the grid. \n"
"</p>\n"
"<h3>Right-click Context Menu</h3>\n"
"<p>\n"
"  Right clicking on an image gets you a few more options: \n"
"</p>\n"
"<p>\n"
"  <ul><li>&quot;Respawn&quot; regenerates just the current image from whatever it was \n"
"  spawned from (and using recolour or warp, if that's what was used \n"
"  to produce it). \n"
"  The main use of this is to make your grid of images look nice \n"
"  for screendumps, by regenerating any which aren't up to scratch. \n"
"  NB May not work as expected after an &quot;undo&quot;. \n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<p>\n"
"  <ul><li>&quot;Spawn&quot; is the same as clicking an image. It generates mutated \n"
"  images to all unlocked images in the grid. \n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<p>\n"
"  <ul><li>&quot;Recolour&quot; to produce different coloured variants of the selected image \n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<p>\n"
"  <ul><li>&quot;Warp&quot;'s sub-options produce variants of the image which have been \n"
"  zoomed/rotated/panned. \n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<p>\n"
"  <ul><li>&quot;Lock&quot; to prevent an image from being overwritten by spawns from other \n"
"  images (select again to toggle). \n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<p>\n"
"  <ul><li>&quot;Enlarge&quot; to produce a blow-up of the image in a single window. \n"
"  Submenu items select either a freely resizable window or \n"
"  a scrollable view of a fixed size image. \n"
"  If the application is running in fullscreen mode (NB this is \n"
"  NOT the same as a simply &quot;maximised&quot; window) then the enlarged \n"
"  image will also be fullscreen (the &quot;Resizeable&quot; mode is probably \n"
"  what you want in this case as the image will automatically be \n"
"  rendered at the correct resolution). \n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<p>\n"
"  <ul><li>&quot;Save image&quot; to save the image in a file (.ppm or .png). \n"
"  You generally want to save an enlarged image: if you \n"
"  save a small image from the grid, the size you see on the screen \n"
"  is the size you get in the file. Save isn't allowed until the \n"
"  full resolution image has been generated; if you try to save too \n"
"  early a dialog box will be displayed telling you to try again later. \n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<p>\n"
"  <ul><li>&quot;Save function&quot; to store the function to an XML file. \n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<p>\n"
"  <ul><li>&quot;Load function&quot; to load a stored function from an XML file. \n"
"  NB if the file was saved from a different version numbered \n"
"  evolvotron, a warning message will be generated. \n"
"  Save/load of functions is an experimental feature and you should \n"
"  not count on future versions of evolvotron being able to load \n"
"  files saved from old versions, or producing the same image \n"
"  from a loaded function. Attempting to load functions from later \n"
"  versions into earlier versions is even less likely to succeed. \n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<p>\n"
"  <ul><li>&quot;Simplify&quot; prunes the function tree of redundant branches where \n"
"  possible (the same action can be applied to all images from \n"
"  the main &quot;Edit&quot; menu). This doesn't change the appearance of \n"
"  the image, but may make it recompute faster. \n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<p>\n"
"  <ul><li>&quot;Properties&quot; brings up a dialog box containing some information \n"
"  about the image (e.g the number of function nodes it contains). \n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<h3>Middle Mouse Button</h3>\n"
"<p>\n"
"  [NB This feature will probably only be of practical use to those with high-end machines]. \n"
"</p>\n"
"<p>\n"
"  You can use the middle mouse button to drag-adjust individual images. \n"
"  This is useful for &quot;final composition&quot; type tweaks, e.g centering an \n"
"  image's most interesting feature, or just for satisfying your curiosity \n"
"  about what's off the edge of the image. \n"
"</p>\n"
"<p>\n"
"  It also works on enlarged images, although it's virtually unusable without \n"
"  a bit of practice on smaller, faster ones (just boldly make the adjustment \n"
"  you want, release the button... and wait). \n"
"</p>\n"
"<p>\n"
"  Changes made can be rolled-back on the main Edit/Undo menu item, \n"
"  one drag-action at a time. \n"
"</p>\n"
"<p>\n"
"  An unmodified middle-mouse drag pans the image around following \n"
"  the mouse motion. \n"
"</p>\n"
"<p>\n"
"  A SHIFT-middle drag zooms the image in and out with scaling \n"
"  proportional to the distance from the centre of the image. Beware of \n"
"  generating huge zooms by clicking too near the centre of the image. \n"
"</p>\n"
"<p>\n"
"  An ALT-SHIFT-middle drag is similar but anisotropic: the scaling \n"
"  may be different in X and Y. Warning: this technique is very \n"
"  sensitive and can be quite tricky to use! In particular, \n"
"  if you initially click near the centre axes of the image the zoom factor \n"
"  can be HUGE, so the best way to start using this is to click about halfway \n"
"  on a diagonal between the image centre and a corner and gently move in and \n"
"  out radially. Dragging from one side of the image to the other flips it over \n"
"  (the degenerate case of infinite zoom at the centre is handled cleanly I think). \n"
"  If it all goes horribly wrong, undo and try again. \n"
"</p>\n"
"<p>\n"
"  A CTRL-middle drag rotates the image about its centre. \n"
"</p>\n"
"<p>\n"
"  A CTRL-ALT-middle drag shears the image (the best way to see what \n"
"  this does is to click in the corner of an image and move the mouse \n"
"  horizontally or vertically). \n"
"</p>\n"
"<h2>Keyboard Control</h2>\n"
"\n"
"<p>\n"
"  There are some keyboard shortcuts. \n"
"</p>\n"
"<h3>Main Window</h3>\n"
"\n"
"<p>\n"
"  <ul><li>&quot;r&quot;/&quot;t&quot;/&quot;x&quot; perform various starts of reset/restart. \n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<p>\n"
"  <ul><li>&quot;q&quot; quits the application. \n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<p>\n"
"  <ul><li>&quot;u&quot; (and also Ctrl-z) does an undo. \n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<p>\n"
"  <ul><li>&quot;f&quot;: full-screen mode (on X11, Qt does this by asking the \n"
"  window manager for a screen-filling undecorated window, and the \n"
"  documentation contains some dire warnings about problems with broken \n"
"  window managers). See also &quot;-F&quot; command line option. \n"
"  Fullscreen mode propagates to enlarged image display windows. \n"
"  NB The application may completely disappear from the screen for \n"
"  a brief interval while switching mode. \n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<p>\n"
"  <ul><li>&quot;m&quot; : hides status and menu-bar hiding, which can be nice when \n"
"  in full-screen or window-maximised mode. See also &quot;-M&quot; \n"
"  command line option. Also note that while the menu bar \n"
"  is hidden, most of these keyboard shortcuts won't function \n"
"  as they're tied to the menu system. \n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<p>\n"
"  <ul><li>Esc : exits full-screen and/or menu-hiding mode, putting the \n"
"  application into its normal default state. \n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<h3>Enlargement Windows</h3>\n"
"<p>\n"
"  The image display windows created by selecting &quot;Enlarge&quot; from a \n"
"  context menu also have a couple of keyboard operations: \n"
"</p>\n"
"<p>\n"
"  <ul><li>&quot;f&quot; : [NB only available with fullscreen build option] toggles \n"
"  full-screen mode. When returning to normal mode, if the main app \n"
"  window was fullscreen then it will also drop back to normal mode. \n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<p>\n"
"  <ul><li>Esc : [NB only available with fullscreen build option] \n"
"  completely closes a fullscreen-mode enlargement window. \n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<h2>Gui Elements</h2>\n"
"\n"
"<h3>Main Menu Bar</h3>\n"
"<p>\n"
"  <ul><li>File menu: \n"
"  Items to restart, reset and quit the application. \n"
"  The difference between restart and reset is that reset \n"
"  sets the mutation parameters back the their default values. \n"
"  The &quot;randomize function weights&quot; version of restart scrambles \n"
"  the relative probability of the various function types (if you \n"
"  think evolvotron just keeps generating the same kinds of \n"
"  images give it a try). The &quot;restart with specifc function&quot; \n"
"  item duplicates the functionality of the &quot;-x&quot; and &quot;-X&quot; command-line \n"
"  options. \n"
"  </li><li>Edit menu: \n"
"  &quot;Undo&quot; lets you undo certain actions: e.g spawn, \n"
"  middle-button adjustment, simplification and lock/unlock. \n"
"  There is a large but limited number of levels of undo. \n"
"  &quot;Simplify&quot; is of curiosity value only: it prunes redundant \n"
"  branches from images (&quot;junk DNA&quot;); this may help them recompute \n"
"  faster but at the cost of there being less mutatable material. \n"
"  </li><li>Settings menu: \n"
"  &quot;Mutations&quot; brings up a dialog to modify the amount \n"
"  of change spawned images are subject to. \n"
"  (See &quot;advanced usage&quot; below.) \n"
"  &quot;Functions&quot; brings up a dialog to modify the relative probability \n"
"  of functions being used. By default all functions are equally \n"
"  likely except for iterative functions and fractals, which are \n"
"  almost but not completely supressed. But if you think there \n"
"  are too many spirals or grids (or not enough fractals) then this \n"
"  is the place to adjust the frequency with which they appear. \n"
"  If the software was built with the fullscreen option, \n"
"  that can also be controlled from this menu. \n"
"  &quot;Favourite&quot; brings up a dialog which allows you to select a specific \n"
"  function type to always be used as the root node of any new functions. \n"
"  The function can be wrapped by some other random stuff, or unwrapped. \n"
"  See also the -X and -x command line options. \n"
"  </li><li>Help menu: \n"
"  Items to bring up documentation, and the usual &quot;About&quot; box \n"
"  (which includes the license). \n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<h3>Status Bar</h3>\n"
"<p>\n"
"  An area on the status bar shows how many compute &quot;tasks&quot; are \n"
"  outstanding (or &quot;Ready&quot; when there are none). When two task \n"
"  totals are reported, the first is for the main grid and the \n"
"  second for any enlargements being computed. \n"
"  Each &quot;task&quot; is the recomputation of an image at some resolution. \n"
"  Tasks are prioritised by their number of pixels (small image \n"
"  implies higher priority). This is why, if the main grid is still \n"
"  recomputing, recalculations of enlargements will appear to freeze \n"
"  after they have reached a certain resolution, at least until other \n"
"  lower resolution tasks have completed. \n"
"</p>\n"
"<p>\n"
"  The status bar also provides some control over the &quot;autocool&quot; \n"
"  mechanism which reduces mutation strength with time. \n"
"  See the advanced usage section below. \n"
"</p>\n"
"<h2>Tips</h2>\n"
"<p>\n"
"  <ul><li>Don't start a session with any preconceived ideas about the kind \n"
"  of image you want to get out of it. You will be disappointed. \n"
"  </li><li>I get the best results when I click the image which most \n"
"  immediately catches my eye as they start appearing. If you stop \n"
"  to think about it too much then things seem to go downhill. \n"
"  </li><li>If you seem to be just getting the same old spirals and grids \n"
"  all the time, stop clicking on spirals and grids! \n"
"  (The same goes for random mush). \n"
"  </li><li>Don't get too hung up on using the warp and middle-mouse drag \n"
"  adjustments every iteration... use those tools for final \n"
"  polishing of your masterpiece. \n"
"  </li><li>You can quickly cycle through a lot of initial images (until \n"
"  you find one with real potential) by bashing on Ctrl-r to \n"
"  repeatedly restart. \n"
"  </li><li>To add variety to an image's mutations, nudge it with a small \n"
"  middle-mouse drag. This introduces a top level transform, and \n"
"  therefore more parameters to be varied. \n"
"  </li><li>Enlargements take a long time to complete their final \n"
"  high-resolution rendering pass (especially with multisampling \n"
"  enabled). Most convenient practice seems to be to go away and \n"
"  leave them to complete, then come back and save them later. \n"
"  Continuing to click away on the main grid effectively starves \n"
"  them of CPU, unless the -E command-line option is used. \n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<h2>Animation</h2>\n"
"<p>\n"
"  As of version 0.2.0 evolvotron contains some experimental support \n"
"  for generation of animations (although so far the results have been \n"
"  pretty disappointing IMHO, but it's still early days). \n"
"</p>\n"
"<p>\n"
"  NB THIS IS EVEN MORE COMPUTATIONALLY AND MEMORY INTENSIVE THAN \n"
"  THE STATIC IMAGE MODE. \n"
"</p>\n"
"<p>\n"
"  Simply supply a -f <i>frames</i> command line option and evolvotron will \n"
"  generate animated sequences with the specified number of frames. \n"
"  These will be displayed at the frame rate specified by the \n"
"  optional -s <i>framerate</i> option (default 8). So &quot;evolvotron -s 24&quot; \n"
"  will generate 3 second long animations. Animations reverse direction \n"
"  at each end to avoid a sudden jump. \n"
"</p>\n"
"<p>\n"
"  If you save an animation as PPM or PNG, multiple files will \n"
"  be saved with .fnnnnnn (where nnnnnn is the zero-filled frame \n"
"  number) inserted in each filename before the filetype qualifier. \n"
"</p>\n"
"<p>\n"
"  For example, if you enter foo.ppm as the filename to save, \n"
"  files foo.f000000.ppm, foo.f000001.ppm... will be saved. \n"
"  If you have the ImageMagick tools you can convert these to \n"
"  an animated GIF playing at approx. 8 frames per second with: \n"
"</p>\n"
"<p>\n"
"  <code>convert -delay 12 foo.f??????.ppm foo.gif </code>\n"
"</p>\n"
"<h2>Advanced Usage</h2>\n"
"<p>\n"
"  Evolvotron's idea of an image is a function which converts \n"
"  XYZ co-ordinates to an RGB colour (however we can only display \n"
"  a 2D plane for now so the input Z is fixed to zero, or varied \n"
"  with time when animating). \n"
"</p>\n"
"<p>\n"
"  The image functions are constructed from trees of function nodes. \n"
"  (In the mathematical expression 1+(2*x) the &quot;+&quot; and the &quot;*&quot; would \n"
"  be function nodes.) Evolvotron's functions tend to correspond to \n"
"  geometric or colour-space operations or anything else which can be \n"
"  applied to a 3D vector. \n"
"</p>\n"
"<p>\n"
"  By mutating the structure of the function tree (adding random \n"
"  branches, for example) and the values of the constant embedded \n"
"  within it, the image can be changed. \n"
"</p>\n"
"<p>\n"
"  The mutation parameters are under control from the dialogs accessible \n"
"  via the Settings menu, and the &quot;autocool&quot; mechanism exposed in the \n"
"  status bar also has some influence. \n"
"</p>\n"
"<p>\n"
"  There are two kinds of mutation: perturbations to the magnitude of constants, \n"
"  and structural mutations which rearrage the function tree of an image. \n"
"  Four types of structural mutations are currently implemented: \n"
"  <ul><li>replacement of a function branch by a new random stub (a &quot;Glitch&quot; mutation). \n"
"  </li><li>a random shuffle of a node's sub-nodes \n"
"  </li><li>insertion of random nodes between a node and it's sub-nodes \n"
"  </li><li>the substitution of a node with one of a different type, \n"
"  with sub-nodes unaffected where possible). \n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<p>\n"
"  The probability (per function node) of these mutations is controlled \n"
"  from spinboxes on the &quot;Mutation Parameters&quot; dialog (expressed as \n"
"  chances-in-a-hundred), as is the size of perturbations to constants. \n"
"</p>\n"
"<p>\n"
"  It is useful to think of the perturbations to constant parameters as \n"
"  being a thermal effect (hence the &quot;heat&quot; and &quot;cool&quot; buttons), while \n"
"  structural alterations are more drastic and are caused by high energy \n"
"  gamma rays or something (hence &quot;irradiate&quot; and &quot;shield&quot; buttons to \n"
"  adjust the probability of structual mutations). \n"
"</p>\n"
"<p>\n"
"  So why would you want to change the mutation parameters from the initial \n"
"  defaults ? Basically, if you're getting too much variation in spawned images \n"
"  (this tends to happen after many generations of images, by which time the \n"
"  function trees have grown quite large and therefore are experiencing a lot \n"
"  of mutations) then cool and/or shield. \n"
"  If all the images look too similar, heat and/or irradiate. \n"
"</p>\n"
"<p>\n"
"  The &quot;autocool&quot; mechanism (enabled from the statusbar or mutation parameters \n"
"  dialog) automatically reduces the strength of mutations from the base \n"
"  values with successive generations. The cooling can be cancelled by \n"
"  disabling autocooling or pressing the &quot;Reheat&quot; button to zero the number \n"
"  of generations counted for cooling. The effect of the cooling is a compound \n"
"  halving of the mutation strength after some number of generations (this number \n"
"  is the &quot;half-life&quot; controllable from the mutation parameters dialog). \n"
"  Note that if autocooling is enabled then eventually, after a number of \n"
"  iterations more than many multiples of the half-life has passes, spawned \n"
"  images will differ very little from their parents (hence the need for &quot;reheat&quot;). \n"
"</p>\n"
"<p>\n"
"  There is also a dialog accessible from &quot;Functions...&quot; on the &quot;Settings&quot; menu. \n"
"  This allows control over the relative proportions in which functions occur. \n"
"  There is a tab showing the relative weighting of all functions (log-2 scale: each \n"
"  tick halves the probability of the function occurring), and additional tabs \n"
"  for various classifications of function for quicker access. \n"
"  The &quot;Randomize&quot; button on each tab assigns random weightings and helps \n"
"  increase the uniqueness of your session. \n"
"</p>\n"
"<p>\n"
"  The &quot;Functions&quot; dialog also has a &quot;Dilution&quot; tab which allows the average \n"
"  function-tree branching ratio to be controlled (by changing the proportion \n"
"  of trivial zero-branch functions added): note that using a high branching \n"
"  ratio results in very complex images which will take a long time to compute, \n"
"  while reducing the ratio results in simple, boring images. \n"
"</p>\n"
"<p>\n"
"  3 types of function node are considered fundamental: constant nodes \n"
"  (which return a constant), identity nodes (which return their \n"
"  position argument) and transform nodes (which transform their positon \n"
"  argument by random parameters). On the &quot;Dilution&quot; tab of the &quot;Functions&quot; \n"
"  dialog there are two slider controls to affect things related to these: \n"
"  <ul><li>&quot;proportion constant&quot; controls the proportion of diluting fundamental nodes \n"
"  which are constants. Changing this from its default value of 0.5 doesn't \n"
"  actually seem to have much effect. \n"
"  </li><li>&quot;proportion transforms&quot; sets the proportion of non-constant nodes diluting \n"
"  which are transforms (as opposed to identity nodes). \n"
"  The main effect of this is that images are less commonly obviously centred \n"
"  on the origin or aligned with the axes. I think this is a good thing, so \n"
"  the value is at 1.0 by default. \n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<h2>Other Executables</h2>\n"
"<p>\n"
"  This release also builds some other command-line driven (non-GUI, non-interactive) utilities. \n"
"  Consult the man pages for full details. \n"
"</p>\n"
"<p>\n"
"  evolvotron_render reads a XML function description from its standard input and renders it to the \n"
"  file specified. \n"
"</p>\n"
"<p>\n"
"  evolvotron_mutate reads an XML function description from its standard input and outputs a mutated version. \n"
"  A command line option allows the &quot;genesis&quot; situation of creating a random function description with no input. \n"
"</p>\n"
"<h3>Examples</h3>\n"
"\n"
"<p>\n"
"  Evolving and mutating on the command line: \n"
"</p>\n"
"<p>\n"
"  <code>evolvotron_mutate -g | tee fn.xml | evolvotron_render /tmp/xxx.ppm ; display /tmp/xxx.ppm </code>\n"
"</p>\n"
"<p>\n"
"  <code>cat fn.xml | evolvotron_mutate | evolvotron_render -j -m 4 /tmp/xxx.ppm ; display /tmp/xxx.ppm </code>\n"
"</p>\n"
"<p>\n"
"  Animating a function ani.xml saved from evolvotron in animation mode: \n"
"</p>\n"
"<p>\n"
"  <code>cat ani.xml | evolvotron_render -f 100 -v -s 256 256 ani.ppm ; animate ani.f??????.ppm </code>\n"
"</p>\n"
"<h2>Future Developments</h2>\n"
"<p>\n"
"  Please check the TODO file first before you send me suggestions! \n"
"</p>\n"
"<p>\n"
"  Please don't ask me to port evolvotron to proprietary platforms. \n"
"  You are of course Free under the terms of the GPL to do so yourself, \n"
"  but please read \n"
"  http://www.fefe.de/nowindows/ \n"
"  first. \n"
"</p>\n"
"<h2>Thanks</h2>\n"
"<p>\n"
"  To those who have contributed feedback, suggestions and patches: \n"
"  <ul><li>Dmitry Kirsanov \n"
"  </li><li>Jonathan Melhuish \n"
"  </li><li>Karl Robillard \n"
"  </li><li>Linc Davis \n"
"  </li><li>Paolo Greppi \n"
"  </li><li>Marcin Wojtczuk \n"
"  </li><li>Michael Sterrett \n"
"  </li><li>Massimiliano Guastafierro \n"
"  </li><li>Goetz Waschk \n"
"  </li><li>Forrest Walter \n"
"</li>\n"
"</ul>\n"
"</p>\n"
"<p>\n"
"  And to the anonymous Linspire reviewer who perhaps came up with the best \n"
"  summary of evolvotron yet: &quot;Fascinating. Utterly pointless, but fascinating.&quot; \n"
"</p>\n"
"<p>\n"
"  The friezegroups wouldn't have been possible without \n"
"  http://michaelshepperd.tripod.com/resources/groups.html \n"
"</p>\n"
"<p>\n"
"  Thanks to www.di.fm, www.somafm.com and Trance4Ever for music to code to. \n"
"</p>\n"
"<p>\n"
"  Thanks especially to a SIGGRAPH conference panel many years ago (likely \n"
"  including Karl Sims, the pioneer in this area) who first got me interested \n"
"  in this stuff. \n"
"</p>\n"
"<h2>Why ?</h2>\n"
"<p>\n"
"  I have always admired those who have the skill to wield a pen or paintbrush \n"
"  and fill a sheet of paper or a canvas with some striking image from their \n"
"  imagination. Unfortunately I lack the patience to learn such skills, \n"
"  and probably the necessary manual dexterity and imagination too. \n"
"</p>\n"
"<p>\n"
"  Evolvotron, and several predecessors developed on and off over a decade \n"
"  since I first came across the idea, are an attempt to compensate for \n"
"  this using the skills I do have i.e some mathematical sensibility \n"
"  and the ability to write working code (well, sometimes). If you like \n"
"  an image it produces, then as far as I'm concerned that's as satisfying \n"
"  a result as if you liked something I'd drawn myself. \n"
"</p>\n"
"<p>\n"
"  Tim Day \n"
