/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.os.Build;
import android.support.v4.widget.EdgeEffectCompatIcs;
import android.support.v4.widget.EdgeEffectCompatLollipop;

public final class EdgeEffectCompat {
    private Object mEdgeEffect;
    private static final EdgeEffectImpl IMPL = Build.VERSION.SDK_INT >= 21 ? new EdgeEffectLollipopImpl() : (Build.VERSION.SDK_INT >= 14 ? new EdgeEffectIcsImpl() : new BaseEdgeEffectImpl());

    public EdgeEffectCompat(Context context) {
        this.mEdgeEffect = IMPL.newEdgeEffect(context);
    }

    public void setSize(int width, int height) {
        IMPL.setSize(this.mEdgeEffect, width, height);
    }

    public boolean isFinished() {
        return IMPL.isFinished(this.mEdgeEffect);
    }

    public void finish() {
        IMPL.finish(this.mEdgeEffect);
    }

    public boolean onPull(float deltaDistance) {
        return IMPL.onPull(this.mEdgeEffect, deltaDistance);
    }

    public boolean onPull(float deltaDistance, float displacement) {
        return IMPL.onPull(this.mEdgeEffect, deltaDistance, displacement);
    }

    public boolean onRelease() {
        return IMPL.onRelease(this.mEdgeEffect);
    }

    public boolean onAbsorb(int velocity) {
        return IMPL.onAbsorb(this.mEdgeEffect, velocity);
    }

    public boolean draw(Canvas canvas) {
        return IMPL.draw(this.mEdgeEffect, canvas);
    }

    static class EdgeEffectLollipopImpl
    extends EdgeEffectIcsImpl {
        EdgeEffectLollipopImpl() {
        }

        @Override
        public boolean onPull(Object edgeEffect, float deltaDistance, float displacement) {
            return EdgeEffectCompatLollipop.onPull(edgeEffect, deltaDistance, displacement);
        }
    }

    static class EdgeEffectIcsImpl
    implements EdgeEffectImpl {
        EdgeEffectIcsImpl() {
        }

        @Override
        public Object newEdgeEffect(Context context) {
            return EdgeEffectCompatIcs.newEdgeEffect(context);
        }

        @Override
        public void setSize(Object edgeEffect, int width, int height) {
            EdgeEffectCompatIcs.setSize(edgeEffect, width, height);
        }

        @Override
        public boolean isFinished(Object edgeEffect) {
            return EdgeEffectCompatIcs.isFinished(edgeEffect);
        }

        @Override
        public void finish(Object edgeEffect) {
            EdgeEffectCompatIcs.finish(edgeEffect);
        }

        @Override
        public boolean onPull(Object edgeEffect, float deltaDistance) {
            return EdgeEffectCompatIcs.onPull(edgeEffect, deltaDistance);
        }

        @Override
        public boolean onRelease(Object edgeEffect) {
            return EdgeEffectCompatIcs.onRelease(edgeEffect);
        }

        @Override
        public boolean onAbsorb(Object edgeEffect, int velocity) {
            return EdgeEffectCompatIcs.onAbsorb(edgeEffect, velocity);
        }

        @Override
        public boolean draw(Object edgeEffect, Canvas canvas) {
            return EdgeEffectCompatIcs.draw(edgeEffect, canvas);
        }

        @Override
        public boolean onPull(Object edgeEffect, float deltaDistance, float displacement) {
            return EdgeEffectCompatIcs.onPull(edgeEffect, deltaDistance);
        }
    }

    static class BaseEdgeEffectImpl
    implements EdgeEffectImpl {
        BaseEdgeEffectImpl() {
        }

        @Override
        public Object newEdgeEffect(Context context) {
            return null;
        }

        @Override
        public void setSize(Object edgeEffect, int width, int height) {
        }

        @Override
        public boolean isFinished(Object edgeEffect) {
            return true;
        }

        @Override
        public void finish(Object edgeEffect) {
        }

        @Override
        public boolean onPull(Object edgeEffect, float deltaDistance) {
            return false;
        }

        @Override
        public boolean onRelease(Object edgeEffect) {
            return false;
        }

        @Override
        public boolean onAbsorb(Object edgeEffect, int velocity) {
            return false;
        }

        @Override
        public boolean draw(Object edgeEffect, Canvas canvas) {
            return false;
        }

        @Override
        public boolean onPull(Object edgeEffect, float deltaDistance, float displacement) {
            return false;
        }
    }

    static interface EdgeEffectImpl {
        public Object newEdgeEffect(Context var1);

        public void setSize(Object var1, int var2, int var3);

        public boolean isFinished(Object var1);

        public void finish(Object var1);

        public boolean onPull(Object var1, float var2);

        public boolean onRelease(Object var1);

        public boolean onAbsorb(Object var1, int var2);

        public boolean draw(Object var1, Canvas var2);

        public boolean onPull(Object var1, float var2, float var3);
    }
}

