/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.janino.JavaSourceClassLoader;
import org.codehaus.janino.util.ClassFile;
import org.codehaus.janino.util.enumerator.EnumeratorSet;
import org.codehaus.janino.util.resource.DirectoryResourceCreator;
import org.codehaus.janino.util.resource.DirectoryResourceFinder;
import org.codehaus.janino.util.resource.PathResourceFinder;
import org.codehaus.janino.util.resource.Resource;
import org.codehaus.janino.util.resource.ResourceCreator;
import org.codehaus.janino.util.resource.ResourceFinder;

public class CachingJavaSourceClassLoader
extends JavaSourceClassLoader {
    private final ResourceFinder classFileCacheResourceFinder;
    private final ResourceCreator classFileCacheResourceCreator;
    private final ResourceFinder sourceFinder;

    public CachingJavaSourceClassLoader(ClassLoader classLoader, ResourceFinder resourceFinder, String string, ResourceFinder resourceFinder2, ResourceCreator resourceCreator, EnumeratorSet enumeratorSet) {
        super(classLoader, resourceFinder, string, enumeratorSet);
        this.classFileCacheResourceFinder = resourceFinder2;
        this.classFileCacheResourceCreator = resourceCreator;
        this.sourceFinder = resourceFinder;
    }

    public CachingJavaSourceClassLoader(ClassLoader classLoader, File[] fileArray, String string, File file, EnumeratorSet enumeratorSet) {
        this(classLoader, fileArray == null ? new DirectoryResourceFinder(new File(".")) : new PathResourceFinder(fileArray), string, new DirectoryResourceFinder(file), new DirectoryResourceCreator(file), enumeratorSet);
    }

    protected Map generateBytecodes(String string) throws ClassNotFoundException {
        Object object;
        Resource resource = this.classFileCacheResourceFinder.findResource(ClassFile.getClassFileResourceName(string));
        if (resource != null) {
            object = this.sourceFinder.findResource(ClassFile.getSourceResourceName(string));
            if (object == null) {
                return null;
            }
            if (object.lastModified() < resource.lastModified()) {
                byte[] byArray;
                try {
                    byArray = CachingJavaSourceClassLoader.readResource(resource);
                }
                catch (IOException iOException) {
                    throw new ClassNotFoundException("Reading class file from \"" + resource + "\"", iOException);
                }
                HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
                hashMap.put(string, byArray);
                return hashMap;
            }
        }
        if ((object = super.generateBytecodes(string)) == null) {
            return null;
        }
        Iterator iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string2 = (String)entry.getKey();
            byte[] byArray = (byte[])entry.getValue();
            try {
                CachingJavaSourceClassLoader.writeResource(this.classFileCacheResourceCreator, ClassFile.getClassFileResourceName(string2), byArray);
            }
            catch (IOException iOException) {
                throw new ClassNotFoundException("Writing class file to \"" + ClassFile.getClassFileResourceName(string2) + "\"", iOException);
            }
        }
        return object;
    }

    private static byte[] readResource(Resource resource) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        InputStream inputStream = resource.open();
        try {
            int n;
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
        return byteArrayOutputStream.toByteArray();
    }

    private static void writeResource(ResourceCreator resourceCreator, String string, byte[] byArray) throws IOException {
        OutputStream outputStream = resourceCreator.createResource(string);
        try {
            outputStream.write(byArray);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                outputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        Object var5_4 = null;
        try {
            outputStream.close();
        }
        catch (IOException iOException) {}
    }
}

