/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.util;

import alt.jiapi.Instrumentor;
import alt.jiapi.instrumentor.Strategy;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.StringTokenizer;

public class SymbolMap {
    private HashMap map = new HashMap();

    public static void main(String[] args) {
        SymbolMap sm = new SymbolMap("alt.jiapi.instrumentor");
        System.out.println(sm);
    }

    public SymbolMap() {
    }

    public SymbolMap(String pkg) {
        this();
        this.addPackage(pkg);
    }

    public void addPackage(String pkg) {
        String classPath = System.getProperty("java.class.path");
        StringTokenizer st = new StringTokenizer(classPath, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String pathItem = st.nextToken();
            this.resolveClassPathItem(pathItem, pkg);
        }
    }

    public void addSymbol(String name, String value) {
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        this.map.put(name, value);
    }

    public String getSymbol(String name) {
        return (String)this.map.get(name);
    }

    private void resolveClassPathItem(String item, String pkg) {
        File f = new File(item);
        if (!f.exists()) {
            return;
        }
        StringTokenizer st = new StringTokenizer(pkg, ".");
        if (f.isDirectory()) {
            String dir = item;
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                f = new File(dir = dir + File.separator + s);
                if (f.exists()) continue;
                return;
            }
            if (!f.isDirectory()) {
                return;
            }
            String[] fileNames = f.list(new Filter(".class"));
            Class<Instrumentor> instrumentorClass = Instrumentor.class;
            Class<Strategy> strategyClass = Strategy.class;
            for (int i = 0; i < fileNames.length; ++i) {
                String fileName = fileNames[i].substring(0, fileNames[i].lastIndexOf(46));
                Class<?> c = null;
                try {
                    c = Class.forName(pkg + "." + fileName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                if (instrumentorClass.isAssignableFrom(c)) {
                    this.map.put(fileName, pkg + "." + fileName);
                }
                if (!strategyClass.isAssignableFrom(c)) continue;
                this.map.put(fileName, pkg + "." + fileName);
            }
        }
    }

    public String toString() {
        return this.map.toString();
    }

    private class Filter
    implements FilenameFilter {
        private String suffix;

        public Filter(String suffix) {
            this.suffix = suffix;
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(this.suffix);
        }
    }
}

