/***************************************************************************
 *                             Ada Web Server                              *
 *                                                                         *
 *                      Copyright (C) 2015, AdaCore                        *
 *                                                                         *
 * This library is free software; you can redistribute it and/or modify    *
 * it under the terms of the GNU General Public License as published by    *
 * the Free Software Foundation; either version 2 of the License, or (at   *
 * your option) any later version.                                         *
 *                                                                         *
 * This library is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       *
 * General Public License for more details.                                *
 *                                                                         *
 * You should have received a copy of the GNU General Public License       *
 * along with this library; if not, write to the Free Software Foundation, *
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.          *
 *                                                                         *
 *                                                                          * 
 *                                                                          * 
 *                                                                          * 
 *                                                                          * 
 *                                                                          * 
 *                                                                          * 
 ***************************************************************************/

/* This wrappers is neccessary because the constants GNUTLS_SEC_PARAM_* changed
 * in GNUTLS version 3.4. We could use this constants directly when decide to
 * complete support of the GNUTLS versions earlier then 3.4.
 */

#include <gnutls/gnutls.h>
#define AWS_EXPORT(c) extern const int _AWS_##c; \
   const int _AWS_##c = c;

AWS_EXPORT(GNUTLS_SEC_PARAM_INSECURE);
AWS_EXPORT(GNUTLS_SEC_PARAM_EXPORT);
AWS_EXPORT(GNUTLS_SEC_PARAM_VERY_WEAK);
AWS_EXPORT(GNUTLS_SEC_PARAM_WEAK);
AWS_EXPORT(GNUTLS_SEC_PARAM_UNKNOWN);
AWS_EXPORT(GNUTLS_SEC_PARAM_LOW);
AWS_EXPORT(GNUTLS_SEC_PARAM_LEGACY);
AWS_EXPORT(GNUTLS_SEC_PARAM_NORMAL);
AWS_EXPORT(GNUTLS_SEC_PARAM_HIGH);
AWS_EXPORT(GNUTLS_SEC_PARAM_ULTRA);
