/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.config.ConfigurationException;

/**
 * Configuration for {@link FIFOPolicy}.
 * <p/>
 * If configured via XML, expects the following:
 * <p/>
 * <pre>
 * <region name="abc">
 *   <attribute name="maxNodes">1000</attribute>
 * </region>
 * </pre>
 * <p/>
 * Requires a "maxNodes" attribute otherwise a ConfigurationException is thrown.
 *
 * @author Daniel Huang (dhuang@jboss.org)
 * @version $Revision: 6120 $
 */
public class FIFOConfiguration extends EvictionPolicyConfigBase
{
   /**
    * The serialVersionUID
    */
   private static final long serialVersionUID = -7229715009546277313L;

   public FIFOConfiguration()
   {
      super();
      // We require that maxNodes is set
      setMaxNodes(-1);
   }

   /**
    * Requires a positive maxNodes value or ConfigurationException
    * is thrown.
    */
   @Override
   public void validate() throws ConfigurationException
   {
      if (getMaxNodes() < 0)
      {
         throw new ConfigurationException("maxNodes must be must be " +
               "configured to a value greater than or equal to 0");
      }
   }

   @Override
   public String toString()
   {
      StringBuilder ret = new StringBuilder();
      ret.append("LFUConfiguration: maxNodes = ").append(getMaxNodes());
      return ret.toString();
   }

   @Override
   protected void setEvictionPolicyClassName()
   {
      setEvictionPolicyClass(FIFOPolicy.class.getName());
   }

   @Override
   public void reset()
   {
      setMaxNodes(-1);
   }

   @Override
   public FIFOConfiguration clone() throws CloneNotSupportedException
   {
      return (FIFOConfiguration) super.clone();
   }


}
