<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/collectors/freebsd.plugin/integrations/zfs.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/collectors/freebsd.plugin/metadata.yaml"
sidebar_label: "zfs"
learn_status: "Published"
learn_rel_path: "Data Collection/FreeBSD"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# zfs


<img src="https://netdata.cloud/img/filesystem.svg" width="150"/>


Plugin: freebsd.plugin
Module: zfs

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

Collect metrics for ZFS filesystem

The plugin uses `sysctl` function to collect necessary data.

This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per zfs instance

These metrics show detailed information about ZFS filesystem.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| zfs.arc_size | arcsz, target, min, max | MiB |
| zfs.l2_size | actual, size | MiB |
| zfs.reads | arc, demand, prefetch, metadata, l2 | reads/s |
| zfs.bytes | read, write | KiB/s |
| zfs.hits | hits, misses | percentage |
| zfs.hits_rate | hits, misses | events/s |
| zfs.dhits | hits, misses | percentage |
| zfs.dhits_rate | hits, misses | events/s |
| zfs.phits | hits, misses | percentage |
| zfs.phits_rate | hits, misses | events/s |
| zfs.mhits | hits, misses | percentage |
| zfs.mhits_rate | hits, misses | events/s |
| zfs.l2hits | hits, misses | percentage |
| zfs.l2hits_rate | hits, misses | events/s |
| zfs.list_hits | mfu, mfu_ghost, mru, mru_ghost | hits/s |
| zfs.arc_size_breakdown | recent, frequent | percentage |
| zfs.memory_ops | throttled | operations/s |
| zfs.important_ops | evict_skip, deleted, mutex_miss, hash_collisions | operations/s |
| zfs.actual_hits | hits, misses | percentage |
| zfs.actual_hits_rate | hits, misses | events/s |
| zfs.demand_data_hits | hits, misses | percentage |
| zfs.demand_data_hits_rate | hits, misses | events/s |
| zfs.prefetch_data_hits | hits, misses | percentage |
| zfs.prefetch_data_hits_rate | hits, misses | events/s |
| zfs.hash_elements | current, max | elements |
| zfs.hash_chains | current, max | chains |
| zfs.trim_bytes | TRIMmed | bytes |
| zfs.trim_requests | successful, failed, unsupported | requests |



## Alerts


The following alerts are available:

| Alert name  | On metric | Description |
|:------------|:----------|:------------|
| [ zfs_memory_throttle ](https://github.com/netdata/netdata/blob/master/health/health.d/zfs.conf) | zfs.memory_ops | number of times ZFS had to limit the ARC growth in the last 10 minutes |


## Setup

### Prerequisites

No action required.

### Configuration

#### File

The configuration file name for this integration is `netdata.conf`.
Configuration for this specific integration is located in the `[plugin:freebsd:zfs_arcstats]` section within that file.

The file format is a modified INI syntax. The general structure is:

```ini
[section1]
    option1 = some value
    option2 = some other value

[section2]
    option3 = some third value
```
You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/configure/nodes.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config netdata.conf
```
#### Options



<details><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| show zero charts | Do not show charts with zero metrics. | no | no |

</details>

#### Examples
There are no configuration examples.


