/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.event;

import java.util.HashMap;
import java.util.Map;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.event.EventManager;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.util.StringUtils;

public class IvyEvent {
    private EventManager source;
    private String name;
    private Map attributes = new HashMap();

    protected IvyEvent(String string) {
        this.source = IvyContext.getContext().getEventManager();
        this.name = string;
    }

    protected final void addAttribute(String string, String string2) {
        this.attributes.put(string, string2);
    }

    protected final void addMDAttributes(ModuleDescriptor moduleDescriptor) {
        this.addMridAttributes(moduleDescriptor.getResolvedModuleRevisionId());
    }

    protected final void addMridAttributes(ModuleRevisionId moduleRevisionId) {
        ModuleId moduleId = moduleRevisionId.getModuleId();
        IvyEvent ivyEvent = this;
        ivyEvent.addAttribute("organisation", moduleId.getOrganisation());
        ivyEvent.addAttribute("module", moduleId.getName());
        this.addAttribute("revision", moduleRevisionId.getRevision());
        this.addAttribute("branch", moduleRevisionId.getBranch());
        this.addAttributes(moduleRevisionId.getQualifiedExtraAttributes());
        this.addAttributes(moduleRevisionId.getExtraAttributes());
    }

    protected final void addConfsAttribute(String[] stringArray) {
        this.addAttribute("conf", StringUtils.join(stringArray, ", "));
    }

    protected final void addAttributes(Map map2) {
        this.attributes.putAll(map2);
    }

    public String toString() {
        IvyEvent ivyEvent = this;
        return this.name + " " + new HashMap(ivyEvent.attributes);
    }

    public boolean equals(Object object) {
        if (!(object instanceof IvyEvent)) {
            return false;
        }
        IvyEvent ivyEvent = (IvyEvent)object;
        return this.source.equals(ivyEvent.source) && this.name.equals(ivyEvent.name) && ((Object)this.attributes).equals(ivyEvent.attributes);
    }

    public int hashCode() {
        int n = 481 + this.source.hashCode();
        n = n * 13 + this.name.hashCode();
        return n * 13 + ((Object)this.attributes).hashCode();
    }
}

