/*###############################################################################
# Linux Management Providers (LMP), PCI provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_PCIBRIDGE_H_
#define OPENDRIM_PCIBRIDGE_H_

#include <Instance.h>

const static char* OpenDRIM_PCIBridge_classnames[] = {"OpenDRIM_PCIBridge"};
static string OpenDRIM_PCIBridge_NAMESPACE = _NAMESPACE;

class OpenDRIM_PCIBridge {

public:
	
	string InstanceID;
	bool InstanceID_isNULL;
	
	string Caption;
	bool Caption_isNULL;
	
	string Description;
	bool Description_isNULL;
	
	string ElementName;
	bool ElementName_isNULL;
	
	string InstallDate;
	bool InstallDate_isNULL;
	
	string Name;
	bool Name_isNULL;
	
	vector<unsigned short> OperationalStatus;
	bool OperationalStatus_isNULL;
	
	vector<string> StatusDescriptions;
	bool StatusDescriptions_isNULL;
	
	string Status;
	bool Status_isNULL;
	
	unsigned short HealthState;
	bool HealthState_isNULL;
	
	unsigned short CommunicationStatus;
	bool CommunicationStatus_isNULL;
	
	unsigned short DetailedStatus;
	bool DetailedStatus_isNULL;
	
	unsigned short OperatingStatus;
	bool OperatingStatus_isNULL;
	
	unsigned short PrimaryStatus;
	bool PrimaryStatus_isNULL;
	
	unsigned short EnabledState;
	bool EnabledState_isNULL;
	
	string OtherEnabledState;
	bool OtherEnabledState_isNULL;
	
	unsigned short RequestedState;
	bool RequestedState_isNULL;
	
	unsigned short EnabledDefault;
	bool EnabledDefault_isNULL;
	
	string TimeOfLastStateChange;
	bool TimeOfLastStateChange_isNULL;
	
	vector<unsigned short> AvailableRequestedStates;
	bool AvailableRequestedStates_isNULL;
	
	unsigned short TransitioningToState;
	bool TransitioningToState_isNULL;
	
	string SystemCreationClassName;
	bool SystemCreationClassName_isNULL;
	
	string SystemName;
	bool SystemName_isNULL;
	
	string CreationClassName;
	bool CreationClassName_isNULL;
	
	string DeviceID;
	bool DeviceID_isNULL;
	
	bool PowerManagementSupported;
	bool PowerManagementSupported_isNULL;
	
	vector<unsigned short> PowerManagementCapabilities;
	bool PowerManagementCapabilities_isNULL;
	
	unsigned short Availability;
	bool Availability_isNULL;
	
	unsigned short StatusInfo;
	bool StatusInfo_isNULL;
	
	unsigned int LastErrorCode;
	bool LastErrorCode_isNULL;
	
	string ErrorDescription;
	bool ErrorDescription_isNULL;
	
	bool ErrorCleared;
	bool ErrorCleared_isNULL;
	
	vector<string> OtherIdentifyingInfo;
	bool OtherIdentifyingInfo_isNULL;
	
	unsigned long long PowerOnHours;
	bool PowerOnHours_isNULL;
	
	unsigned long long TotalPowerOnHours;
	bool TotalPowerOnHours_isNULL;
	
	vector<string> IdentifyingDescriptions;
	bool IdentifyingDescriptions_isNULL;
	
	vector<unsigned short> AdditionalAvailability;
	bool AdditionalAvailability_isNULL;
	
	unsigned long long MaxQuiesceTime;
	bool MaxQuiesceTime_isNULL;
	
	string TimeOfLastReset;
	bool TimeOfLastReset_isNULL;
	
	unsigned short ProtocolSupported;
	bool ProtocolSupported_isNULL;
	
	unsigned int MaxNumberControlled;
	bool MaxNumberControlled_isNULL;
	
	string ProtocolDescription;
	bool ProtocolDescription_isNULL;
	
	unsigned short CommandRegister;
	bool CommandRegister_isNULL;
	
	vector<unsigned short> Capabilities;
	bool Capabilities_isNULL;
	
	vector<string> CapabilityDescriptions;
	bool CapabilityDescriptions_isNULL;
	
	unsigned short DeviceSelectTiming;
	bool DeviceSelectTiming_isNULL;
	
	unsigned char ClassCode;
	bool ClassCode_isNULL;
	
	unsigned char CacheLineSize;
	bool CacheLineSize_isNULL;
	
	unsigned char LatencyTimer;
	bool LatencyTimer_isNULL;
	
	unsigned short InterruptPin;
	bool InterruptPin_isNULL;
	
	unsigned int ExpansionROMBaseAddress;
	bool ExpansionROMBaseAddress_isNULL;
	
	bool SelfTestEnabled;
	bool SelfTestEnabled_isNULL;
	
	vector<unsigned int> BaseAddress;
	bool BaseAddress_isNULL;
	
	unsigned short SubsystemID;
	bool SubsystemID_isNULL;
	
	unsigned short SubsystemVendorID;
	bool SubsystemVendorID_isNULL;
	
	unsigned char MinGrantTime;
	bool MinGrantTime_isNULL;
	
	unsigned char MaxLatency;
	bool MaxLatency_isNULL;
	
	unsigned char BusNumber;
	bool BusNumber_isNULL;
	
	unsigned char DeviceNumber;
	bool DeviceNumber_isNULL;
	
	unsigned char FunctionNumber;
	bool FunctionNumber_isNULL;
	
	unsigned short PCIDeviceID;
	bool PCIDeviceID_isNULL;
	
	unsigned short VendorID;
	bool VendorID_isNULL;
	
	unsigned char RevisionID;
	bool RevisionID_isNULL;
	
	unsigned short BridgeType;
	bool BridgeType_isNULL;
	
	unsigned char SecondaryLatencyTimer;
	bool SecondaryLatencyTimer_isNULL;
	
	unsigned char SubordinateBusNumber;
	bool SubordinateBusNumber_isNULL;
	
	unsigned char SecondayBusNumber;
	bool SecondayBusNumber_isNULL;
	
	unsigned char PrimaryBusNumber;
	bool PrimaryBusNumber_isNULL;
	
	unsigned short SecondaryStatusRegister;
	bool SecondaryStatusRegister_isNULL;
	
	unsigned short SecondaryBusDeviceSelectTiming;
	bool SecondaryBusDeviceSelectTiming_isNULL;
	
	unsigned char IOLimit;
	bool IOLimit_isNULL;
	
	unsigned char IOBase;
	bool IOBase_isNULL;
	
	unsigned short MemoryLimit;
	bool MemoryLimit_isNULL;
	
	unsigned short MemoryBase;
	bool MemoryBase_isNULL;
	
	unsigned short PrefetchMemoryLimit;
	bool PrefetchMemoryLimit_isNULL;
	
	unsigned short PrefetchMemoryBase;
	bool PrefetchMemoryBase_isNULL;
	
	unsigned int PrefetchLimitUpper32;
	bool PrefetchLimitUpper32_isNULL;
	
	unsigned int PrefetchBaseUpper32;
	bool PrefetchBaseUpper32_isNULL;
	
	unsigned short IOLimitUpper16;
	bool IOLimitUpper16_isNULL;
	
	unsigned short IOBaseUpper16;
	bool IOBaseUpper16_isNULL;
	
	OpenDRIM_PCIBridge() {
		InstanceID_isNULL = true;
		Caption_isNULL = true;
		Description_isNULL = true;
		ElementName_isNULL = true;
		InstallDate_isNULL = true;
		Name_isNULL = true;
		OperationalStatus_isNULL = true;
		StatusDescriptions_isNULL = true;
		Status_isNULL = true;
		HealthState_isNULL = true;
		CommunicationStatus_isNULL = true;
		DetailedStatus_isNULL = true;
		OperatingStatus_isNULL = true;
		PrimaryStatus_isNULL = true;
		EnabledState_isNULL = true;
		OtherEnabledState_isNULL = true;
		RequestedState_isNULL = true;
		EnabledDefault_isNULL = true;
		TimeOfLastStateChange_isNULL = true;
		AvailableRequestedStates_isNULL = true;
		TransitioningToState_isNULL = true;
		SystemCreationClassName_isNULL = true;
		SystemName_isNULL = true;
		CreationClassName_isNULL = true;
		DeviceID_isNULL = true;
		PowerManagementSupported_isNULL = true;
		PowerManagementCapabilities_isNULL = true;
		Availability_isNULL = true;
		StatusInfo_isNULL = true;
		LastErrorCode_isNULL = true;
		ErrorDescription_isNULL = true;
		ErrorCleared_isNULL = true;
		OtherIdentifyingInfo_isNULL = true;
		PowerOnHours_isNULL = true;
		TotalPowerOnHours_isNULL = true;
		IdentifyingDescriptions_isNULL = true;
		AdditionalAvailability_isNULL = true;
		MaxQuiesceTime_isNULL = true;
		TimeOfLastReset_isNULL = true;
		ProtocolSupported_isNULL = true;
		MaxNumberControlled_isNULL = true;
		ProtocolDescription_isNULL = true;
		CommandRegister_isNULL = true;
		Capabilities_isNULL = true;
		CapabilityDescriptions_isNULL = true;
		DeviceSelectTiming_isNULL = true;
		ClassCode_isNULL = true;
		CacheLineSize_isNULL = true;
		LatencyTimer_isNULL = true;
		InterruptPin_isNULL = true;
		ExpansionROMBaseAddress_isNULL = true;
		SelfTestEnabled_isNULL = true;
		BaseAddress_isNULL = true;
		SubsystemID_isNULL = true;
		SubsystemVendorID_isNULL = true;
		MinGrantTime_isNULL = true;
		MaxLatency_isNULL = true;
		BusNumber_isNULL = true;
		DeviceNumber_isNULL = true;
		FunctionNumber_isNULL = true;
		PCIDeviceID_isNULL = true;
		VendorID_isNULL = true;
		RevisionID_isNULL = true;
		BridgeType_isNULL = true;
		SecondaryLatencyTimer_isNULL = true;
		SubordinateBusNumber_isNULL = true;
		SecondayBusNumber_isNULL = true;
		PrimaryBusNumber_isNULL = true;
		SecondaryStatusRegister_isNULL = true;
		SecondaryBusDeviceSelectTiming_isNULL = true;
		IOLimit_isNULL = true;
		IOBase_isNULL = true;
		MemoryLimit_isNULL = true;
		MemoryBase_isNULL = true;
		PrefetchMemoryLimit_isNULL = true;
		PrefetchMemoryBase_isNULL = true;
		PrefetchLimitUpper32_isNULL = true;
		PrefetchBaseUpper32_isNULL = true;
		IOLimitUpper16_isNULL = true;
		IOBaseUpper16_isNULL = true;
	}
	
	~OpenDRIM_PCIBridge() {}
	
	string getKeys() const {
		return CF_toLowCase(".SystemCreationClassName=\"" + CF_quoteString(SystemCreationClassName) + "\""".SystemName=\"" + CF_quoteString(SystemName) + "\""".CreationClassName=\"" + CF_quoteString(CreationClassName) + "\""".DeviceID=\"" + CF_quoteString(DeviceID) + "\"");
	}

	int getInstanceID(string& value) const {
		if (InstanceID_isNULL==true)
			return NOT_FOUND;
		value = InstanceID;
		return OK;
	}
	
	int setInstanceID(const string& newValue) {
		InstanceID = newValue;
		InstanceID_isNULL = false;
		return OK;
	}

	int getCaption(string& value) const {
		if (Caption_isNULL==true)
			return NOT_FOUND;
		value = Caption;
		return OK;
	}
	
	int setCaption(const string& newValue) {
		Caption = newValue;
		Caption_isNULL = false;
		return OK;
	}

	int getDescription(string& value) const {
		if (Description_isNULL==true)
			return NOT_FOUND;
		value = Description;
		return OK;
	}
	
	int setDescription(const string& newValue) {
		Description = newValue;
		Description_isNULL = false;
		return OK;
	}

	int getElementName(string& value) const {
		if (ElementName_isNULL==true)
			return NOT_FOUND;
		value = ElementName;
		return OK;
	}
	
	int setElementName(const string& newValue) {
		ElementName = newValue;
		ElementName_isNULL = false;
		return OK;
	}

	int getInstallDate(string& value) const {
		if (InstallDate_isNULL==true)
			return NOT_FOUND;
		value = InstallDate;
		return OK;
	}
	
	int setInstallDate(const string& newValue) {
		InstallDate = newValue;
		InstallDate_isNULL = false;
		return OK;
	}

	int getName(string& value) const {
		if (Name_isNULL==true)
			return NOT_FOUND;
		value = Name;
		return OK;
	}
	
	int setName(const string& newValue) {
		Name = newValue;
		Name_isNULL = false;
		return OK;
	}

	int getOperationalStatus(vector<unsigned short>& value) const {
		if (OperationalStatus_isNULL==true)
			return NOT_FOUND;
		value = OperationalStatus;
		return OK;
	}
	
	int setOperationalStatus(const vector<unsigned short>& newValue) {
		OperationalStatus = newValue;
		OperationalStatus_isNULL = false;
		return OK;
	}

	int getStatusDescriptions(vector<string>& value) const {
		if (StatusDescriptions_isNULL==true)
			return NOT_FOUND;
		value = StatusDescriptions;
		return OK;
	}
	
	int setStatusDescriptions(const vector<string>& newValue) {
		StatusDescriptions = newValue;
		StatusDescriptions_isNULL = false;
		return OK;
	}

	int getStatus(string& value) const {
		if (Status_isNULL==true)
			return NOT_FOUND;
		value = Status;
		return OK;
	}
	
	int setStatus(const string& newValue) {
		Status = newValue;
		Status_isNULL = false;
		return OK;
	}

	int getHealthState(unsigned short& value) const {
		if (HealthState_isNULL==true)
			return NOT_FOUND;
		value = HealthState;
		return OK;
	}
	
	int setHealthState(const unsigned short& newValue) {
		HealthState = newValue;
		HealthState_isNULL = false;
		return OK;
	}

	int getCommunicationStatus(unsigned short& value) const {
		if (CommunicationStatus_isNULL==true)
			return NOT_FOUND;
		value = CommunicationStatus;
		return OK;
	}
	
	int setCommunicationStatus(const unsigned short& newValue) {
		CommunicationStatus = newValue;
		CommunicationStatus_isNULL = false;
		return OK;
	}

	int getDetailedStatus(unsigned short& value) const {
		if (DetailedStatus_isNULL==true)
			return NOT_FOUND;
		value = DetailedStatus;
		return OK;
	}
	
	int setDetailedStatus(const unsigned short& newValue) {
		DetailedStatus = newValue;
		DetailedStatus_isNULL = false;
		return OK;
	}

	int getOperatingStatus(unsigned short& value) const {
		if (OperatingStatus_isNULL==true)
			return NOT_FOUND;
		value = OperatingStatus;
		return OK;
	}
	
	int setOperatingStatus(const unsigned short& newValue) {
		OperatingStatus = newValue;
		OperatingStatus_isNULL = false;
		return OK;
	}

	int getPrimaryStatus(unsigned short& value) const {
		if (PrimaryStatus_isNULL==true)
			return NOT_FOUND;
		value = PrimaryStatus;
		return OK;
	}
	
	int setPrimaryStatus(const unsigned short& newValue) {
		PrimaryStatus = newValue;
		PrimaryStatus_isNULL = false;
		return OK;
	}

	int getEnabledState(unsigned short& value) const {
		if (EnabledState_isNULL==true)
			return NOT_FOUND;
		value = EnabledState;
		return OK;
	}
	
	int setEnabledState(const unsigned short& newValue) {
		EnabledState = newValue;
		EnabledState_isNULL = false;
		return OK;
	}

	int getOtherEnabledState(string& value) const {
		if (OtherEnabledState_isNULL==true)
			return NOT_FOUND;
		value = OtherEnabledState;
		return OK;
	}
	
	int setOtherEnabledState(const string& newValue) {
		OtherEnabledState = newValue;
		OtherEnabledState_isNULL = false;
		return OK;
	}

	int getRequestedState(unsigned short& value) const {
		if (RequestedState_isNULL==true)
			return NOT_FOUND;
		value = RequestedState;
		return OK;
	}
	
	int setRequestedState(const unsigned short& newValue) {
		RequestedState = newValue;
		RequestedState_isNULL = false;
		return OK;
	}

	int getEnabledDefault(unsigned short& value) const {
		if (EnabledDefault_isNULL==true)
			return NOT_FOUND;
		value = EnabledDefault;
		return OK;
	}
	
	int setEnabledDefault(const unsigned short& newValue) {
		EnabledDefault = newValue;
		EnabledDefault_isNULL = false;
		return OK;
	}

	int getTimeOfLastStateChange(string& value) const {
		if (TimeOfLastStateChange_isNULL==true)
			return NOT_FOUND;
		value = TimeOfLastStateChange;
		return OK;
	}
	
	int setTimeOfLastStateChange(const string& newValue) {
		TimeOfLastStateChange = newValue;
		TimeOfLastStateChange_isNULL = false;
		return OK;
	}

	int getAvailableRequestedStates(vector<unsigned short>& value) const {
		if (AvailableRequestedStates_isNULL==true)
			return NOT_FOUND;
		value = AvailableRequestedStates;
		return OK;
	}
	
	int setAvailableRequestedStates(const vector<unsigned short>& newValue) {
		AvailableRequestedStates = newValue;
		AvailableRequestedStates_isNULL = false;
		return OK;
	}

	int getTransitioningToState(unsigned short& value) const {
		if (TransitioningToState_isNULL==true)
			return NOT_FOUND;
		value = TransitioningToState;
		return OK;
	}
	
	int setTransitioningToState(const unsigned short& newValue) {
		TransitioningToState = newValue;
		TransitioningToState_isNULL = false;
		return OK;
	}

	int getSystemCreationClassName(string& value) const {
		if (SystemCreationClassName_isNULL==true)
			return NOT_FOUND;
		value = SystemCreationClassName;
		return OK;
	}
	
	int setSystemCreationClassName(const string& newValue) {
		SystemCreationClassName = newValue;
		SystemCreationClassName_isNULL = false;
		return OK;
	}

	int getSystemName(string& value) const {
		if (SystemName_isNULL==true)
			return NOT_FOUND;
		value = SystemName;
		return OK;
	}
	
	int setSystemName(const string& newValue) {
		SystemName = newValue;
		SystemName_isNULL = false;
		return OK;
	}

	int getCreationClassName(string& value) const {
		if (CreationClassName_isNULL==true)
			return NOT_FOUND;
		value = CreationClassName;
		return OK;
	}
	
	int setCreationClassName(const string& newValue) {
		CreationClassName = newValue;
		CreationClassName_isNULL = false;
		return OK;
	}

	int getDeviceID(string& value) const {
		if (DeviceID_isNULL==true)
			return NOT_FOUND;
		value = DeviceID;
		return OK;
	}
	
	int setDeviceID(const string& newValue) {
		DeviceID = newValue;
		DeviceID_isNULL = false;
		return OK;
	}

	int getPowerManagementSupported(bool& value) const {
		if (PowerManagementSupported_isNULL==true)
			return NOT_FOUND;
		value = PowerManagementSupported;
		return OK;
	}
	
	int setPowerManagementSupported(const bool& newValue) {
		PowerManagementSupported = newValue;
		PowerManagementSupported_isNULL = false;
		return OK;
	}

	int getPowerManagementCapabilities(vector<unsigned short>& value) const {
		if (PowerManagementCapabilities_isNULL==true)
			return NOT_FOUND;
		value = PowerManagementCapabilities;
		return OK;
	}
	
	int setPowerManagementCapabilities(const vector<unsigned short>& newValue) {
		PowerManagementCapabilities = newValue;
		PowerManagementCapabilities_isNULL = false;
		return OK;
	}

	int getAvailability(unsigned short& value) const {
		if (Availability_isNULL==true)
			return NOT_FOUND;
		value = Availability;
		return OK;
	}
	
	int setAvailability(const unsigned short& newValue) {
		Availability = newValue;
		Availability_isNULL = false;
		return OK;
	}

	int getStatusInfo(unsigned short& value) const {
		if (StatusInfo_isNULL==true)
			return NOT_FOUND;
		value = StatusInfo;
		return OK;
	}
	
	int setStatusInfo(const unsigned short& newValue) {
		StatusInfo = newValue;
		StatusInfo_isNULL = false;
		return OK;
	}

	int getLastErrorCode(unsigned int& value) const {
		if (LastErrorCode_isNULL==true)
			return NOT_FOUND;
		value = LastErrorCode;
		return OK;
	}
	
	int setLastErrorCode(const unsigned int& newValue) {
		LastErrorCode = newValue;
		LastErrorCode_isNULL = false;
		return OK;
	}

	int getErrorDescription(string& value) const {
		if (ErrorDescription_isNULL==true)
			return NOT_FOUND;
		value = ErrorDescription;
		return OK;
	}
	
	int setErrorDescription(const string& newValue) {
		ErrorDescription = newValue;
		ErrorDescription_isNULL = false;
		return OK;
	}

	int getErrorCleared(bool& value) const {
		if (ErrorCleared_isNULL==true)
			return NOT_FOUND;
		value = ErrorCleared;
		return OK;
	}
	
	int setErrorCleared(const bool& newValue) {
		ErrorCleared = newValue;
		ErrorCleared_isNULL = false;
		return OK;
	}

	int getOtherIdentifyingInfo(vector<string>& value) const {
		if (OtherIdentifyingInfo_isNULL==true)
			return NOT_FOUND;
		value = OtherIdentifyingInfo;
		return OK;
	}
	
	int setOtherIdentifyingInfo(const vector<string>& newValue) {
		OtherIdentifyingInfo = newValue;
		OtherIdentifyingInfo_isNULL = false;
		return OK;
	}

	int getPowerOnHours(unsigned long long& value) const {
		if (PowerOnHours_isNULL==true)
			return NOT_FOUND;
		value = PowerOnHours;
		return OK;
	}
	
	int setPowerOnHours(const unsigned long long& newValue) {
		PowerOnHours = newValue;
		PowerOnHours_isNULL = false;
		return OK;
	}

	int getTotalPowerOnHours(unsigned long long& value) const {
		if (TotalPowerOnHours_isNULL==true)
			return NOT_FOUND;
		value = TotalPowerOnHours;
		return OK;
	}
	
	int setTotalPowerOnHours(const unsigned long long& newValue) {
		TotalPowerOnHours = newValue;
		TotalPowerOnHours_isNULL = false;
		return OK;
	}

	int getIdentifyingDescriptions(vector<string>& value) const {
		if (IdentifyingDescriptions_isNULL==true)
			return NOT_FOUND;
		value = IdentifyingDescriptions;
		return OK;
	}
	
	int setIdentifyingDescriptions(const vector<string>& newValue) {
		IdentifyingDescriptions = newValue;
		IdentifyingDescriptions_isNULL = false;
		return OK;
	}

	int getAdditionalAvailability(vector<unsigned short>& value) const {
		if (AdditionalAvailability_isNULL==true)
			return NOT_FOUND;
		value = AdditionalAvailability;
		return OK;
	}
	
	int setAdditionalAvailability(const vector<unsigned short>& newValue) {
		AdditionalAvailability = newValue;
		AdditionalAvailability_isNULL = false;
		return OK;
	}

	int getMaxQuiesceTime(unsigned long long& value) const {
		if (MaxQuiesceTime_isNULL==true)
			return NOT_FOUND;
		value = MaxQuiesceTime;
		return OK;
	}
	
	int setMaxQuiesceTime(const unsigned long long& newValue) {
		MaxQuiesceTime = newValue;
		MaxQuiesceTime_isNULL = false;
		return OK;
	}

	int getTimeOfLastReset(string& value) const {
		if (TimeOfLastReset_isNULL==true)
			return NOT_FOUND;
		value = TimeOfLastReset;
		return OK;
	}
	
	int setTimeOfLastReset(const string& newValue) {
		TimeOfLastReset = newValue;
		TimeOfLastReset_isNULL = false;
		return OK;
	}

	int getProtocolSupported(unsigned short& value) const {
		if (ProtocolSupported_isNULL==true)
			return NOT_FOUND;
		value = ProtocolSupported;
		return OK;
	}
	
	int setProtocolSupported(const unsigned short& newValue) {
		ProtocolSupported = newValue;
		ProtocolSupported_isNULL = false;
		return OK;
	}

	int getMaxNumberControlled(unsigned int& value) const {
		if (MaxNumberControlled_isNULL==true)
			return NOT_FOUND;
		value = MaxNumberControlled;
		return OK;
	}
	
	int setMaxNumberControlled(const unsigned int& newValue) {
		MaxNumberControlled = newValue;
		MaxNumberControlled_isNULL = false;
		return OK;
	}

	int getProtocolDescription(string& value) const {
		if (ProtocolDescription_isNULL==true)
			return NOT_FOUND;
		value = ProtocolDescription;
		return OK;
	}
	
	int setProtocolDescription(const string& newValue) {
		ProtocolDescription = newValue;
		ProtocolDescription_isNULL = false;
		return OK;
	}

	int getCommandRegister(unsigned short& value) const {
		if (CommandRegister_isNULL==true)
			return NOT_FOUND;
		value = CommandRegister;
		return OK;
	}
	
	int setCommandRegister(const unsigned short& newValue) {
		CommandRegister = newValue;
		CommandRegister_isNULL = false;
		return OK;
	}

	int getCapabilities(vector<unsigned short>& value) const {
		if (Capabilities_isNULL==true)
			return NOT_FOUND;
		value = Capabilities;
		return OK;
	}
	
	int setCapabilities(const vector<unsigned short>& newValue) {
		Capabilities = newValue;
		Capabilities_isNULL = false;
		return OK;
	}

	int getCapabilityDescriptions(vector<string>& value) const {
		if (CapabilityDescriptions_isNULL==true)
			return NOT_FOUND;
		value = CapabilityDescriptions;
		return OK;
	}
	
	int setCapabilityDescriptions(const vector<string>& newValue) {
		CapabilityDescriptions = newValue;
		CapabilityDescriptions_isNULL = false;
		return OK;
	}

	int getDeviceSelectTiming(unsigned short& value) const {
		if (DeviceSelectTiming_isNULL==true)
			return NOT_FOUND;
		value = DeviceSelectTiming;
		return OK;
	}
	
	int setDeviceSelectTiming(const unsigned short& newValue) {
		DeviceSelectTiming = newValue;
		DeviceSelectTiming_isNULL = false;
		return OK;
	}

	int getClassCode(unsigned char& value) const {
		if (ClassCode_isNULL==true)
			return NOT_FOUND;
		value = ClassCode;
		return OK;
	}
	
	int setClassCode(const unsigned char& newValue) {
		ClassCode = newValue;
		ClassCode_isNULL = false;
		return OK;
	}

	int getCacheLineSize(unsigned char& value) const {
		if (CacheLineSize_isNULL==true)
			return NOT_FOUND;
		value = CacheLineSize;
		return OK;
	}
	
	int setCacheLineSize(const unsigned char& newValue) {
		CacheLineSize = newValue;
		CacheLineSize_isNULL = false;
		return OK;
	}

	int getLatencyTimer(unsigned char& value) const {
		if (LatencyTimer_isNULL==true)
			return NOT_FOUND;
		value = LatencyTimer;
		return OK;
	}
	
	int setLatencyTimer(const unsigned char& newValue) {
		LatencyTimer = newValue;
		LatencyTimer_isNULL = false;
		return OK;
	}

	int getInterruptPin(unsigned short& value) const {
		if (InterruptPin_isNULL==true)
			return NOT_FOUND;
		value = InterruptPin;
		return OK;
	}
	
	int setInterruptPin(const unsigned short& newValue) {
		InterruptPin = newValue;
		InterruptPin_isNULL = false;
		return OK;
	}

	int getExpansionROMBaseAddress(unsigned int& value) const {
		if (ExpansionROMBaseAddress_isNULL==true)
			return NOT_FOUND;
		value = ExpansionROMBaseAddress;
		return OK;
	}
	
	int setExpansionROMBaseAddress(const unsigned int& newValue) {
		ExpansionROMBaseAddress = newValue;
		ExpansionROMBaseAddress_isNULL = false;
		return OK;
	}

	int getSelfTestEnabled(bool& value) const {
		if (SelfTestEnabled_isNULL==true)
			return NOT_FOUND;
		value = SelfTestEnabled;
		return OK;
	}
	
	int setSelfTestEnabled(const bool& newValue) {
		SelfTestEnabled = newValue;
		SelfTestEnabled_isNULL = false;
		return OK;
	}

	int getBaseAddress(vector<unsigned int>& value) const {
		if (BaseAddress_isNULL==true)
			return NOT_FOUND;
		value = BaseAddress;
		return OK;
	}
	
	int setBaseAddress(const vector<unsigned int>& newValue) {
		BaseAddress = newValue;
		BaseAddress_isNULL = false;
		return OK;
	}

	int getSubsystemID(unsigned short& value) const {
		if (SubsystemID_isNULL==true)
			return NOT_FOUND;
		value = SubsystemID;
		return OK;
	}
	
	int setSubsystemID(const unsigned short& newValue) {
		SubsystemID = newValue;
		SubsystemID_isNULL = false;
		return OK;
	}

	int getSubsystemVendorID(unsigned short& value) const {
		if (SubsystemVendorID_isNULL==true)
			return NOT_FOUND;
		value = SubsystemVendorID;
		return OK;
	}
	
	int setSubsystemVendorID(const unsigned short& newValue) {
		SubsystemVendorID = newValue;
		SubsystemVendorID_isNULL = false;
		return OK;
	}

	int getMinGrantTime(unsigned char& value) const {
		if (MinGrantTime_isNULL==true)
			return NOT_FOUND;
		value = MinGrantTime;
		return OK;
	}
	
	int setMinGrantTime(const unsigned char& newValue) {
		MinGrantTime = newValue;
		MinGrantTime_isNULL = false;
		return OK;
	}

	int getMaxLatency(unsigned char& value) const {
		if (MaxLatency_isNULL==true)
			return NOT_FOUND;
		value = MaxLatency;
		return OK;
	}
	
	int setMaxLatency(const unsigned char& newValue) {
		MaxLatency = newValue;
		MaxLatency_isNULL = false;
		return OK;
	}

	int getBusNumber(unsigned char& value) const {
		if (BusNumber_isNULL==true)
			return NOT_FOUND;
		value = BusNumber;
		return OK;
	}
	
	int setBusNumber(const unsigned char& newValue) {
		BusNumber = newValue;
		BusNumber_isNULL = false;
		return OK;
	}

	int getDeviceNumber(unsigned char& value) const {
		if (DeviceNumber_isNULL==true)
			return NOT_FOUND;
		value = DeviceNumber;
		return OK;
	}
	
	int setDeviceNumber(const unsigned char& newValue) {
		DeviceNumber = newValue;
		DeviceNumber_isNULL = false;
		return OK;
	}

	int getFunctionNumber(unsigned char& value) const {
		if (FunctionNumber_isNULL==true)
			return NOT_FOUND;
		value = FunctionNumber;
		return OK;
	}
	
	int setFunctionNumber(const unsigned char& newValue) {
		FunctionNumber = newValue;
		FunctionNumber_isNULL = false;
		return OK;
	}

	int getPCIDeviceID(unsigned short& value) const {
		if (PCIDeviceID_isNULL==true)
			return NOT_FOUND;
		value = PCIDeviceID;
		return OK;
	}
	
	int setPCIDeviceID(const unsigned short& newValue) {
		PCIDeviceID = newValue;
		PCIDeviceID_isNULL = false;
		return OK;
	}

	int getVendorID(unsigned short& value) const {
		if (VendorID_isNULL==true)
			return NOT_FOUND;
		value = VendorID;
		return OK;
	}
	
	int setVendorID(const unsigned short& newValue) {
		VendorID = newValue;
		VendorID_isNULL = false;
		return OK;
	}

	int getRevisionID(unsigned char& value) const {
		if (RevisionID_isNULL==true)
			return NOT_FOUND;
		value = RevisionID;
		return OK;
	}
	
	int setRevisionID(const unsigned char& newValue) {
		RevisionID = newValue;
		RevisionID_isNULL = false;
		return OK;
	}

	int getBridgeType(unsigned short& value) const {
		if (BridgeType_isNULL==true)
			return NOT_FOUND;
		value = BridgeType;
		return OK;
	}
	
	int setBridgeType(const unsigned short& newValue) {
		BridgeType = newValue;
		BridgeType_isNULL = false;
		return OK;
	}

	int getSecondaryLatencyTimer(unsigned char& value) const {
		if (SecondaryLatencyTimer_isNULL==true)
			return NOT_FOUND;
		value = SecondaryLatencyTimer;
		return OK;
	}
	
	int setSecondaryLatencyTimer(const unsigned char& newValue) {
		SecondaryLatencyTimer = newValue;
		SecondaryLatencyTimer_isNULL = false;
		return OK;
	}

	int getSubordinateBusNumber(unsigned char& value) const {
		if (SubordinateBusNumber_isNULL==true)
			return NOT_FOUND;
		value = SubordinateBusNumber;
		return OK;
	}
	
	int setSubordinateBusNumber(const unsigned char& newValue) {
		SubordinateBusNumber = newValue;
		SubordinateBusNumber_isNULL = false;
		return OK;
	}

	int getSecondayBusNumber(unsigned char& value) const {
		if (SecondayBusNumber_isNULL==true)
			return NOT_FOUND;
		value = SecondayBusNumber;
		return OK;
	}
	
	int setSecondayBusNumber(const unsigned char& newValue) {
		SecondayBusNumber = newValue;
		SecondayBusNumber_isNULL = false;
		return OK;
	}

	int getPrimaryBusNumber(unsigned char& value) const {
		if (PrimaryBusNumber_isNULL==true)
			return NOT_FOUND;
		value = PrimaryBusNumber;
		return OK;
	}
	
	int setPrimaryBusNumber(const unsigned char& newValue) {
		PrimaryBusNumber = newValue;
		PrimaryBusNumber_isNULL = false;
		return OK;
	}

	int getSecondaryStatusRegister(unsigned short& value) const {
		if (SecondaryStatusRegister_isNULL==true)
			return NOT_FOUND;
		value = SecondaryStatusRegister;
		return OK;
	}
	
	int setSecondaryStatusRegister(const unsigned short& newValue) {
		SecondaryStatusRegister = newValue;
		SecondaryStatusRegister_isNULL = false;
		return OK;
	}

	int getSecondaryBusDeviceSelectTiming(unsigned short& value) const {
		if (SecondaryBusDeviceSelectTiming_isNULL==true)
			return NOT_FOUND;
		value = SecondaryBusDeviceSelectTiming;
		return OK;
	}
	
	int setSecondaryBusDeviceSelectTiming(const unsigned short& newValue) {
		SecondaryBusDeviceSelectTiming = newValue;
		SecondaryBusDeviceSelectTiming_isNULL = false;
		return OK;
	}

	int getIOLimit(unsigned char& value) const {
		if (IOLimit_isNULL==true)
			return NOT_FOUND;
		value = IOLimit;
		return OK;
	}
	
	int setIOLimit(const unsigned char& newValue) {
		IOLimit = newValue;
		IOLimit_isNULL = false;
		return OK;
	}

	int getIOBase(unsigned char& value) const {
		if (IOBase_isNULL==true)
			return NOT_FOUND;
		value = IOBase;
		return OK;
	}
	
	int setIOBase(const unsigned char& newValue) {
		IOBase = newValue;
		IOBase_isNULL = false;
		return OK;
	}

	int getMemoryLimit(unsigned short& value) const {
		if (MemoryLimit_isNULL==true)
			return NOT_FOUND;
		value = MemoryLimit;
		return OK;
	}
	
	int setMemoryLimit(const unsigned short& newValue) {
		MemoryLimit = newValue;
		MemoryLimit_isNULL = false;
		return OK;
	}

	int getMemoryBase(unsigned short& value) const {
		if (MemoryBase_isNULL==true)
			return NOT_FOUND;
		value = MemoryBase;
		return OK;
	}
	
	int setMemoryBase(const unsigned short& newValue) {
		MemoryBase = newValue;
		MemoryBase_isNULL = false;
		return OK;
	}

	int getPrefetchMemoryLimit(unsigned short& value) const {
		if (PrefetchMemoryLimit_isNULL==true)
			return NOT_FOUND;
		value = PrefetchMemoryLimit;
		return OK;
	}
	
	int setPrefetchMemoryLimit(const unsigned short& newValue) {
		PrefetchMemoryLimit = newValue;
		PrefetchMemoryLimit_isNULL = false;
		return OK;
	}

	int getPrefetchMemoryBase(unsigned short& value) const {
		if (PrefetchMemoryBase_isNULL==true)
			return NOT_FOUND;
		value = PrefetchMemoryBase;
		return OK;
	}
	
	int setPrefetchMemoryBase(const unsigned short& newValue) {
		PrefetchMemoryBase = newValue;
		PrefetchMemoryBase_isNULL = false;
		return OK;
	}

	int getPrefetchLimitUpper32(unsigned int& value) const {
		if (PrefetchLimitUpper32_isNULL==true)
			return NOT_FOUND;
		value = PrefetchLimitUpper32;
		return OK;
	}
	
	int setPrefetchLimitUpper32(const unsigned int& newValue) {
		PrefetchLimitUpper32 = newValue;
		PrefetchLimitUpper32_isNULL = false;
		return OK;
	}

	int getPrefetchBaseUpper32(unsigned int& value) const {
		if (PrefetchBaseUpper32_isNULL==true)
			return NOT_FOUND;
		value = PrefetchBaseUpper32;
		return OK;
	}
	
	int setPrefetchBaseUpper32(const unsigned int& newValue) {
		PrefetchBaseUpper32 = newValue;
		PrefetchBaseUpper32_isNULL = false;
		return OK;
	}

	int getIOLimitUpper16(unsigned short& value) const {
		if (IOLimitUpper16_isNULL==true)
			return NOT_FOUND;
		value = IOLimitUpper16;
		return OK;
	}
	
	int setIOLimitUpper16(const unsigned short& newValue) {
		IOLimitUpper16 = newValue;
		IOLimitUpper16_isNULL = false;
		return OK;
	}

	int getIOBaseUpper16(unsigned short& value) const {
		if (IOBaseUpper16_isNULL==true)
			return NOT_FOUND;
		value = IOBaseUpper16;
		return OK;
	}
	
	int setIOBaseUpper16(const unsigned short& newValue) {
		IOBaseUpper16 = newValue;
		IOBaseUpper16_isNULL = false;
		return OK;
	}

};

class OpenDRIM_PCIBridge_RequestStateChange_In {

public:

	unsigned short RequestedState;
	bool RequestedState_isNULL;

	Objectpath Job;
	bool Job_isNULL;

	string TimeoutPeriod;
	bool TimeoutPeriod_isNULL;

	OpenDRIM_PCIBridge_RequestStateChange_In() {
		RequestedState_isNULL = true;
		Job_isNULL = true;
		TimeoutPeriod_isNULL = true;
	}

	~OpenDRIM_PCIBridge_RequestStateChange_In() {}

	int getRequestedState(unsigned short& value) const {
		if (RequestedState_isNULL == true)
			return NOT_FOUND;
		value = RequestedState;
		return OK;
	}
	int setRequestedState(const unsigned short&  newValue) {
		RequestedState = newValue;
		RequestedState_isNULL = false;
		return OK;
	}

	int getJob(Objectpath& value) const {
		if (Job_isNULL == true)
			return NOT_FOUND;
		value = Job;
		return OK;
	}
	int setJob(const Objectpath&  newValue) {
		Job = newValue;
		Job_isNULL = false;
		return OK;
	}

	int getTimeoutPeriod(string& value) const {
		if (TimeoutPeriod_isNULL == true)
			return NOT_FOUND;
		value = TimeoutPeriod;
		return OK;
	}
	int setTimeoutPeriod(const string&  newValue) {
		TimeoutPeriod = newValue;
		TimeoutPeriod_isNULL = false;
		return OK;
	}

};

class OpenDRIM_PCIBridge_RequestStateChange_Out {

public:

	Objectpath Job;
	bool Job_isNULL;

	OpenDRIM_PCIBridge_RequestStateChange_Out() {
		Job_isNULL = true;
	}

	~OpenDRIM_PCIBridge_RequestStateChange_Out() {}

	int getJob(Objectpath& value) const {
		if (Job_isNULL == true)
			return NOT_FOUND;
		value = Job;
		return OK;
	}
	int setJob(const Objectpath&  newValue) {
		Job = newValue;
		Job_isNULL = false;
		return OK;
	}

};

class OpenDRIM_PCIBridge_SetPowerState_In {

public:

	unsigned short PowerState;
	bool PowerState_isNULL;

	string Time;
	bool Time_isNULL;

	OpenDRIM_PCIBridge_SetPowerState_In() {
		PowerState_isNULL = true;
		Time_isNULL = true;
	}

	~OpenDRIM_PCIBridge_SetPowerState_In() {}

	int getPowerState(unsigned short& value) const {
		if (PowerState_isNULL == true)
			return NOT_FOUND;
		value = PowerState;
		return OK;
	}
	int setPowerState(const unsigned short&  newValue) {
		PowerState = newValue;
		PowerState_isNULL = false;
		return OK;
	}

	int getTime(string& value) const {
		if (Time_isNULL == true)
			return NOT_FOUND;
		value = Time;
		return OK;
	}
	int setTime(const string&  newValue) {
		Time = newValue;
		Time_isNULL = false;
		return OK;
	}

};

class OpenDRIM_PCIBridge_EnableDevice_In {

public:

	bool Enabled;
	bool Enabled_isNULL;

	OpenDRIM_PCIBridge_EnableDevice_In() {
		Enabled_isNULL = true;
	}

	~OpenDRIM_PCIBridge_EnableDevice_In() {}

	int getEnabled(bool& value) const {
		if (Enabled_isNULL == true)
			return NOT_FOUND;
		value = Enabled;
		return OK;
	}
	int setEnabled(const bool&  newValue) {
		Enabled = newValue;
		Enabled_isNULL = false;
		return OK;
	}

};

class OpenDRIM_PCIBridge_OnlineDevice_In {

public:

	bool Online;
	bool Online_isNULL;

	OpenDRIM_PCIBridge_OnlineDevice_In() {
		Online_isNULL = true;
	}

	~OpenDRIM_PCIBridge_OnlineDevice_In() {}

	int getOnline(bool& value) const {
		if (Online_isNULL == true)
			return NOT_FOUND;
		value = Online;
		return OK;
	}
	int setOnline(const bool&  newValue) {
		Online = newValue;
		Online_isNULL = false;
		return OK;
	}

};

class OpenDRIM_PCIBridge_QuiesceDevice_In {

public:

	bool Quiesce;
	bool Quiesce_isNULL;

	OpenDRIM_PCIBridge_QuiesceDevice_In() {
		Quiesce_isNULL = true;
	}

	~OpenDRIM_PCIBridge_QuiesceDevice_In() {}

	int getQuiesce(bool& value) const {
		if (Quiesce_isNULL == true)
			return NOT_FOUND;
		value = Quiesce;
		return OK;
	}
	int setQuiesce(const bool&  newValue) {
		Quiesce = newValue;
		Quiesce_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_PCIBRIDGE_H_*/
