/*###############################################################################
# Linux Management Providers (LMP), Sensors provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_ASSOCIATEDSENSORACCESS_H_
#define OPENDRIM_ASSOCIATEDSENSORACCESS_H_

#include "Sensors_Common.h"

#include "OpenDRIM_AssociatedSensor.h"
#include "assocOpenDRIM_AssociatedSensor.h"

int Sensors_OpenDRIM_AssociatedSensor_load(const CMPIBroker* broker, string& errorMessage);

int Sensors_OpenDRIM_AssociatedSensor_unload(string& errorMessage);

int Sensors_OpenDRIM_AssociatedSensor_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_AssociatedSensor>& instances, const char** properties, string& errorMessage, const string& discriminant);

int Sensors_OpenDRIM_AssociatedSensor_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_AssociatedSensor& instance, const char** properties, string& errorMessage);

int Sensors_OpenDRIM_AssociatedSensor_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_AssociatedSensor& newInstance, const OpenDRIM_AssociatedSensor& oldInstance, const char** properties, string& errorMessage);

int Sensors_OpenDRIM_AssociatedSensor_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_AssociatedSensor& instance, string& errorMessage);

int Sensors_OpenDRIM_AssociatedSensor_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_AssociatedSensor& instance, string& errorMessage);

int Sensors_OpenDRIM_AssociatedSensor_associatorAntecedentToDependent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Antecedent_instance, const char** properties, vector<Instance>& Dependent_associatedInstances, string& errorMessage, const string& discriminant);

int Sensors_OpenDRIM_AssociatedSensor_associatorDependentToAntecedent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Dependent_instance, const char** properties, vector<Instance>& Antecedent_associatedInstances, string& errorMessage, const string& discriminant);

int Sensors_OpenDRIM_AssociatedSensor_referenceAntecedentToDependent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Antecedent_instance, const vector<Instance>& Dependent_instances, vector<OpenDRIM_AssociatedSensor>& OpenDRIM_AssociatedSensor_instances, const char** properties, string& errorMessage, const string& discriminant);

int Sensors_OpenDRIM_AssociatedSensor_referenceDependentToAntecedent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Dependent_instance, const vector<Instance>& Antecedent_instances, vector<OpenDRIM_AssociatedSensor>& OpenDRIM_AssociatedSensor_instances, const char** properties, string& errorMessage, const string& discriminant);

int Sensors_OpenDRIM_AssociatedSensor_populate(OpenDRIM_AssociatedSensor& instance, string& errorMessage);

#endif /*OPENDRIM_ASSOCIATEDSENSORACCESS_H_*/
