/*###############################################################################
# Linux Management Providers (LMP), Sensors provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_SENSORCONFORMSTOPROFILEACCESS_H_
#define OPENDRIM_SENSORCONFORMSTOPROFILEACCESS_H_

#include "Sensors_Common.h"

#include "OpenDRIM_SensorConformsToProfile.h"
#include "assocOpenDRIM_SensorConformsToProfile.h"

int Sensors_OpenDRIM_SensorConformsToProfile_load(const CMPIBroker* broker, string& errorMessage);

int Sensors_OpenDRIM_SensorConformsToProfile_unload(string& errorMessage);

int Sensors_OpenDRIM_SensorConformsToProfile_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_SensorConformsToProfile>& instances, const char** properties, string& errorMessage, const string& discriminant);

int Sensors_OpenDRIM_SensorConformsToProfile_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_SensorConformsToProfile& instance, const char** properties, string& errorMessage);

int Sensors_OpenDRIM_SensorConformsToProfile_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SensorConformsToProfile& newInstance, const OpenDRIM_SensorConformsToProfile& oldInstance, const char** properties, string& errorMessage);

int Sensors_OpenDRIM_SensorConformsToProfile_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SensorConformsToProfile& instance, string& errorMessage);

int Sensors_OpenDRIM_SensorConformsToProfile_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SensorConformsToProfile& instance, string& errorMessage);

int Sensors_OpenDRIM_SensorConformsToProfile_associatorConformantStandardToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ConformantStandard_instance, const char** properties, vector<Instance>& ManagedElement_associatedInstances, string& errorMessage, const string& discriminant);

int Sensors_OpenDRIM_SensorConformsToProfile_associatorManagedElementToConformantStandard(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const char** properties, vector<Instance>& ConformantStandard_associatedInstances, string& errorMessage, const string& discriminant);

int Sensors_OpenDRIM_SensorConformsToProfile_referenceConformantStandardToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ConformantStandard_instance, const vector<Instance>& ManagedElement_instances, vector<OpenDRIM_SensorConformsToProfile>& OpenDRIM_SensorConformsToProfile_instances, const char** properties, string& errorMessage, const string& discriminant);

int Sensors_OpenDRIM_SensorConformsToProfile_referenceManagedElementToConformantStandard(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const vector<Instance>& ConformantStandard_instances, vector<OpenDRIM_SensorConformsToProfile>& OpenDRIM_SensorConformsToProfile_instances, const char** properties, string& errorMessage, const string& discriminant);

int Sensors_OpenDRIM_SensorConformsToProfile_populate(OpenDRIM_SensorConformsToProfile& instance, string& errorMessage);

#endif /*OPENDRIM_SENSORCONFORMSTOPROFILEACCESS_H_*/
