/*
 *  Copyright (c) 2009 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "Thread.h"

using namespace GTLTest;

#ifdef OPENGTL_HAVE_PTHREAD

#include <pthread.h>

struct Thread::Private {
  pthread_t thread_id;
  bool running;
  static void* runThread(void* thread);
};

Thread::Thread() : d(new Private)
{
  d->running = false;
}

Thread::~Thread()
{
  
}

void* Thread::Private::runThread(void* _thread)
{
  Thread* thread = static_cast<Thread*>(_thread);
  thread->d->running = true;
  thread->run();
  thread->d->running = false;
  return NULL;
}

void Thread::start()
{
  pthread_create(&d->thread_id, NULL, &Thread::Private::runThread, (void*)this);
}

void Thread::wait()
{
  void* exit_status;
  pthread_join(d->thread_id, &exit_status);
}

bool Thread::isRunning() const
{
  return d->running;
}

#else

#error "Unsupported platform"

#endif
