﻿Android
--------

Open Overlay Router includes support for Android devices operating as LISP mobile 
nodes (LISP-MN). There are two implementations of Open Overlay Router merged in a 
single application, for rooted devices and for non-rooted devices. The application 
automatically selects the implementation to run according to the features of the 
device. It is expected that in the future the version executed in rooted devices  
will provide features beyond those available on the non-root devices, however on 
the current version there is just one root-only feature, support for IPv6 RLOCs. 
In both editions, there is a limit of one single EID (IPv4 or IPv6) mapped to one 
or more RLOC interfaces. Even though several interfaces can be managed by Open Overlay 
Router at the same time, they can only be used in an active-backup fashion (no more 
than one interface used at once).

Installation
------------

OOR requires a device with Android 4.0 or higher. Please note that due to a bug on 
Android 4.4.0 and onwards,  OOR will not work properly in no rooted devices with 
Android 4.4.0, 4.4.1, 4.4.2 or 4.4.3. The bug was fixed on Android 4.4.4. To ease 
the installation process we strongly recommend installing OOR through Google Play 
(search for “open overlay router”), however you can also download a precompiled APK 
package file from the Open Overlay Router website or compile the app from sources 
yourself. In any case, if you choose to install OOR without using Google Play, the 
device must be configured to allow the installation of packages from "unknown sources" 
(System Settings -> Security -> Device Administration)

To build Open Overlay Router for Android from source code we recomend you to use 
Android Studio with the Native Development Kit

  * Android Studio: [https://developer.android.com/studio/index.html]

To get the latest version of the OOR source from Github:

    git clone git://github.com/OpenOverlayRouter/oor.git

Import the android folder to Android Studio and select Build APK from the Build menu. 
To install the application, connect your device to the pc, select Run in the Run 
menu and select the device you want to install and run the application.

Running Open Overlay Router
---------------------------

Open Overlay Router Android application allows you to start and stop the oor daemon 
and edit the most important parameters of the configuration file. To access the full
list of configurable parameters you have to edit manually the configuration file
located in /sdcard/oor.conf.  Manually edited parameters not present in the 
graphical configuration interface will be overwritten when using the graphical 
configuration editor. 

** Once OOR is running, the source address of the generated traffic is your EID. It 
is possible that the DNS server used by your device doesn't reply to unknow addresses 
like your new EID. We are working to try to fix this problem in a new release.**

Due to the large amount of data generated by the oor daemon, it is recommended 
to set "log level" to 0 when not debugging.
