/* SPDX-License-Identifier: (GPL-2.0 OR BSD-3-Clause) */
/*
 * Copyright (c) 2020-2024, STMicroelectronics
 */
#ifndef _DT_BINDINGS_FIREWALL_STM32MP25_RIFSC_H
#define _DT_BINDINGS_FIREWALL_STM32MP25_RIFSC_H

/* RIFSC ID */
#define STM32MP25_RIFSC_TIM1_ID			0
#define STM32MP25_RIFSC_TIM2_ID			1
#define STM32MP25_RIFSC_TIM3_ID			2
#define STM32MP25_RIFSC_TIM4_ID			3
#define STM32MP25_RIFSC_TIM5_ID			4
#define STM32MP25_RIFSC_TIM6_ID			5
#define STM32MP25_RIFSC_TIM7_ID			6
#define STM32MP25_RIFSC_TIM8_ID			7
#define STM32MP25_RIFSC_TIM10_ID		8
#define STM32MP25_RIFSC_TIM11_ID		9
#define STM32MP25_RIFSC_TIM12_ID		10
#define STM32MP25_RIFSC_TIM13_ID		11
#define STM32MP25_RIFSC_TIM14_ID		12
#define STM32MP25_RIFSC_TIM15_ID		13
#define STM32MP25_RIFSC_TIM16_ID		14
#define STM32MP25_RIFSC_TIM17_ID		15
#define STM32MP25_RIFSC_TIM20_ID		16
#define STM32MP25_RIFSC_LPTIM1_ID		17
#define STM32MP25_RIFSC_LPTIM2_ID		18
#define STM32MP25_RIFSC_LPTIM3_ID		19
#define STM32MP25_RIFSC_LPTIM4_ID		20
#define STM32MP25_RIFSC_LPTIM5_ID		21
#define STM32MP25_RIFSC_SPI1_ID			22
#define STM32MP25_RIFSC_SPI2_ID			23
#define STM32MP25_RIFSC_SPI3_ID			24
#define STM32MP25_RIFSC_SPI4_ID			25
#define STM32MP25_RIFSC_SPI5_ID			26
#define STM32MP25_RIFSC_SPI6_ID			27
#define STM32MP25_RIFSC_SPI7_ID			28
#define STM32MP25_RIFSC_SPI8_ID			29
#define STM32MP25_RIFSC_SPDIFRX_ID		30
#define STM32MP25_RIFSC_USART1_ID		31
#define STM32MP25_RIFSC_USART2_ID		32
#define STM32MP25_RIFSC_USART3_ID		33
#define STM32MP25_RIFSC_UART4_ID		34
#define STM32MP25_RIFSC_UART5_ID		35
#define STM32MP25_RIFSC_USART6_ID		36
#define STM32MP25_RIFSC_UART7_ID		37
#define STM32MP25_RIFSC_UART8_ID		38
#define STM32MP25_RIFSC_UART9_ID		39
#define STM32MP25_RIFSC_LPUART1_ID		40
#define STM32MP25_RIFSC_I2C1_ID			41
#define STM32MP25_RIFSC_I2C2_ID			42
#define STM32MP25_RIFSC_I2C3_ID			43
#define STM32MP25_RIFSC_I2C4_ID			44
#define STM32MP25_RIFSC_I2C5_ID			45
#define STM32MP25_RIFSC_I2C6_ID			46
#define STM32MP25_RIFSC_I2C7_ID			47
#define STM32MP25_RIFSC_I2C8_ID			48
#define STM32MP25_RIFSC_SAI1_ID			49
#define STM32MP25_RIFSC_SAI2_ID			50
#define STM32MP25_RIFSC_SAI3_ID			51
#define STM32MP25_RIFSC_SAI4_ID			52
#define STM32MP25_RIFSC_MDF1_ID			54
#define STM32MP25_RIFSC_ADF1_ID			55
#define STM32MP25_RIFSC_FDCAN_ID		56
#define STM32MP25_RIFSC_HDP_ID			57
#define STM32MP25_RIFSC_ADC12_ID		58
#define STM32MP25_RIFSC_ADC3_ID			59
#define STM32MP25_RIFSC_ETH1_ID			60
#define STM32MP25_RIFSC_ETH2_ID			61
#define STM32MP25_RIFSC_USBH_ID			63
#define STM32MP25_RIFSC_USB3DR_ID		66
#define STM32MP25_RIFSC_COMBOPHY_ID		67
#define STM32MP25_RIFSC_PCIE_ID			68
#define STM32MP25_RIFSC_UCPD1_ID		69
#define STM32MP25_RIFSC_ETHSW_DEIP_ID		70
#define STM32MP25_RIFSC_ETHSW_ACM_CFG_ID	71
#define STM32MP25_RIFSC_ETHSW_ACM_MSGBUF_ID	72
#define STM32MP25_RIFSC_STGEN_ID		73
#define STM32MP25_RIFSC_OCTOSPI1_ID		74
#define STM32MP25_RIFSC_OCTOSPI2_ID		75
#define STM32MP25_RIFSC_SDMMC1_ID		76
#define STM32MP25_RIFSC_SDMMC2_ID		77
#define STM32MP25_RIFSC_SDMMC3_ID		78
#define STM32MP25_RIFSC_GPU_ID			79
#define STM32MP25_RIFSC_LTDC_CMN_ID		80
#define STM32MP25_RIFSC_DSI_CMN_ID		81
#define STM32MP25_RIFSC_LVDS_ID			84
#define STM32MP25_RIFSC_CSI_ID			86
#define STM32MP25_RIFSC_DCMIPP_ID		87
#define STM32MP25_RIFSC_DCMI_PSSI_ID		88
#define STM32MP25_RIFSC_VDEC_ID			89
#define STM32MP25_RIFSC_VENC_ID			90
#define STM32MP25_RIFSC_RNG_ID			92
#define STM32MP25_RIFSC_PKA_ID			93
#define STM32MP25_RIFSC_SAES_ID			94
#define STM32MP25_RIFSC_HASH_ID			95
#define STM32MP25_RIFSC_CRYP1_ID		96
#define STM32MP25_RIFSC_CRYP2_ID		97
#define STM32MP25_RIFSC_IWDG1_ID		98
#define STM32MP25_RIFSC_IWDG2_ID		99
#define STM32MP25_RIFSC_IWDG3_ID		100
#define STM32MP25_RIFSC_IWDG4_ID		101
#define STM32MP25_RIFSC_IWDG5_ID		102
#define STM32MP25_RIFSC_WWDG1_ID		103
#define STM32MP25_RIFSC_WWDG2_ID		104
#define STM32MP25_RIFSC_VREFBUF_ID		106
#define STM32MP25_RIFSC_DTS_ID			107
#define STM32MP25_RIFSC_RAMCFG_ID		108
#define STM32MP25_RIFSC_CRC_ID			109
#define STM32MP25_RIFSC_SERC_ID			110
#define STM32MP25_RIFSC_OCTOSPIM_ID		111
#define STM32MP25_RIFSC_GICV2M_ID		112
#define STM32MP25_RIFSC_I3C1_ID			114
#define STM32MP25_RIFSC_I3C2_ID			115
#define STM32MP25_RIFSC_I3C3_ID			116
#define STM32MP25_RIFSC_I3C4_ID			117
#define STM32MP25_RIFSC_ICACHE_DCACHE_ID	118
#define STM32MP25_RIFSC_LTDC_L0L1_ID		119
#define STM32MP25_RIFSC_LTDC_L2_ID		120
#define STM32MP25_RIFSC_LTDC_ROT_ID		121
#define STM32MP25_RIFSC_DSI_TRIG_ID		122
#define STM32MP25_RIFSC_DSI_RDFIFO_ID		123
#define STM32MP25_RIFSC_OTFDEC1_ID		125
#define STM32MP25_RIFSC_OTFDEC2_ID		126
#define STM32MP25_RIFSC_IAC_ID			127

/* Global lock bindings */
#define RIFSC_RIMU_GLOCK			1
#define RIFSC_RISUP_GLOCK			2

/* masters ID */
#define RIMU_ID(idx)		(idx)

/* master configuration modes */
#define RIF_CIDSEL_P	0x0 /* config from RISUP */
#define RIF_CIDSEL_M	0x1 /* config from RIMU */

#define RIFSC_RIMC_MODE_SHIFT		2
#define RIFSC_RIMC_MCID_SHIFT		4
#define RIFSC_RIMC_MSEC_SHIFT		8
#define RIFSC_RIMC_MPRIV_SHIFT		9
#define RIFSC_RIMC_M_ID_SHIFT		16
#define RIFSC_RIMC_ATTRx_SHIFT		0

#define RIMUPROT(rimuid, mcid, msec, mpriv, mode) \
	(((rimuid) << RIFSC_RIMC_M_ID_SHIFT) | \
	 ((mpriv) << RIFSC_RIMC_MPRIV_SHIFT) | \
	 ((msec) << RIFSC_RIMC_MSEC_SHIFT) | \
	 ((mcid) << RIFSC_RIMC_MCID_SHIFT) | \
	 ((mode) << RIFSC_RIMC_MODE_SHIFT))

#endif /* _DT_BINDINGS_FIREWALL_STM32MP25_RIFSC_H */

