/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#ifndef USERLISTICONFORMAT_H
#define USERLISTICONFORMAT_H

#include <QByteArray>
#include <QString>

/**
	@author Anistratov Oleg <ower86@gmail.com>
*/
class UserListIconFormat
{
  private:
    int m_totalWidth;
    int m_totalHeight;

    int m_statusWidth;
    int m_statusHeight;
    int m_statusXoffset;
    int m_statusYoffset;

    int m_genderWidth;
    int m_genderHeight;
    int m_genderXoffset;
    int m_genderYoffset;

    int m_avatarWidth;
    int m_avatarHeight;
    int m_avatarXoffset;
    int m_avatarYoffset;

    QString m_text;

  public:
    UserListIconFormat(int = 32 + 32 + 5 , int = 33,
                       int = 22, int = 22, int = 10, int = 10,
                       int = 32, int = 32, int =  0, int =  0,
                       int = 32, int = 32, int =  0, int =  0);
    ~UserListIconFormat();

    int  totalWidth   () const {return m_totalWidth;}
    int  totalHeight  () const {return m_totalHeight;}

    int  statusWidth  () const {return m_statusWidth;}
    int  statusHeight () const {return m_statusHeight;}
    int  statusXoffset() const {return m_statusXoffset;}
    int  statusYoffset() const {return m_statusYoffset;}

    int  genderWidth  () const {return m_genderWidth;}
    int  genderHeight () const {return m_genderHeight;}
    int  genderXoffset() const {return m_genderXoffset;}
    int  genderYoffset() const {return m_genderYoffset;}

    int  avatarWidth  () const {return m_avatarWidth;}
    int  avatarHeight () const {return m_avatarHeight;}
    int  avatarXoffset() const {return m_avatarXoffset;}
    int  avatarYoffset() const {return m_avatarYoffset;}

    void setTotalWidth   (int theValue){m_totalWidth    = theValue;}
    void setTotalHeight  (int theValue){m_totalHeight   = theValue;}
    void setStatusWidth  (int theValue){m_statusWidth   = theValue;}
    void setStatusHeight (int theValue){m_statusHeight  = theValue;}
    void setStatusXoffset(int theValue){m_statusXoffset = theValue;}
    void setStatusYoffset(int theValue){m_statusYoffset = theValue;}

    void setGenderWidth  (int theValue){m_genderWidth   = theValue;}
    void setGenderHeight (int theValue){m_genderHeight  = theValue;}
    void setGenderXoffset(int theValue){m_genderXoffset = theValue;}
    void setGenderYoffset(int theValue){m_genderYoffset = theValue;}

    void setAvatarWidth  (int theValue){m_avatarWidth   = theValue;}
    void setAvatarHeight (int theValue){m_avatarHeight  = theValue;}
    void setAvatarXoffset(int theValue){m_avatarXoffset = theValue;}
    void setAvatarYoffset(int theValue){m_avatarYoffset = theValue;}

    QByteArray save() const;
    bool restore(const QByteArray&);

    void setText(const QString& theValue){m_text = theValue;}
    QString text() const {return m_text;}
};

#endif
