;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
; File:        wxFormBuilder.iss
; Author:      Ryan Pusztai & Ryan Mulder
; Date:        02/07/2006
; Copyright:   (c) 2007 Ryan Pusztai <rpusztai@gmail.com>
;              (c) 2007 Ryan Mulder <rjmyst3@gmail.com>
; License:     wxWindows license
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


; MyAppVer gets parsed from source file
#define MyAppName "wxFormBuilder"
#define MyAppPublisher "Jose Antonio Hurtado"
#define MyAppURL "http://wxformbuilder.org"
#define MyAppExeName "wxFormBuilder.exe"

; The #define Arch is expected to be supplied externally and must contain a MinGW-w64 architecture.
; If the architecture is 64 bit, enable 64 bit mode and enforce a 64 bit environment, otherwise
; assume 32 bit and run in default mode.
#define MyAppArchitecture
#define MySetupArchitecture
#ifdef Arch
  #if Arch == "x86_64"
    #define MyAppArchitecture "x64"
    #define MySetupArchitecture "-x64"
  #else
    #define MySetupArchitecture "-x86"
  #endif
#endif

#define protected RootSourceDir "..\..\.."
#define protected RootInstallDir AddBackslash(RootSourceDir) + "_install"

#define protected FileHandle
#define protected FileVersionPrefix "project(wxFormBuilder VERSION "
#define protected FileVersionPostfix " LANGUAGES"

#sub ProcessVersionLine
  #define private FileLine = FileRead(FileHandle)
  #define private FileVersionPrefixPos = Pos(FileVersionPrefix, FileLine)
  #if FileVersionPrefixPos > 0
    #define private FileVersionTemp Copy(FileLine, FileVersionPrefixPos + Len(FileVersionPrefix))
    #define public MyAppVer Copy(FileVersionTemp, 1, RPos(FileVersionPostfix, FileVersionTemp) - 1)
  #endif
#endsub

#for {FileHandle = FileOpen(AddBackslash(RootSourceDir) + "CMakeLists.txt"); FileHandle && !FileEof(FileHandle) && !Defined(MyAppVer); ""} ProcessVersionLine
#if FileHandle
  #expr FileClose(FileHandle)
#endif


[Setup]
AppName={#MyAppName}
AppVersion={#MyAppVer}
AppVerName={#MyAppName} {#MyAppVer}
AppPublisher={#MyAppPublisher}
AppPublisherURL={#MyAppURL}
AppSupportURL={#MyAppURL}
AppUpdatesURL={#MyAppURL}
VersionInfoVersion={#MyAppVer}
VersionInfoDescription={#MyAppName}
ArchitecturesAllowed={#MyAppArchitecture}
ArchitecturesInstallIn64BitMode={#MyAppArchitecture}
MinVersion=6.1sp1
OutputDir=.
OutputBaseFilename={#MyAppName}-{#MyAppVer}{#MySetupArchitecture}
Compression=lzma/ultra
SolidCompression=true
InternalCompressLevel=ultra
WizardStyle=modern
InfoAfterFile={#RootInstallDir}\CHANGELOG.md
LicenseFile={#RootInstallDir}\LICENSE
SetupIconFile=support\wxFormBuilder.ico
ShowLanguageDialog=yes
DefaultDirName={commonpf}\{#MyAppName}
DisableDirPage=false
DefaultGroupName={#MyAppName}
DisableProgramGroupPage=false
AppendDefaultGroupName=false
AllowNoIcons=true
ChangesAssociations=true
UninstallDisplayIcon={app}\wxFormBuilder.exe


[Types]
Name: "full"; Description: "Full installation"
Name: "custom"; Description: "Custom installation"; Flags: iscustom


[Components]
Name: main; Description: wxFormBuilder (required); Types: full custom; Flags: fixed checkablealone
Name: runtime; Description: Compiler Runtime (required); Types: full custom; Flags: fixed checkablealone


[Tasks]
Name: desktopicon; Description: {cm:CreateDesktopIcon}; GroupDescription: {cm:AdditionalIcons}; Flags: unchecked


[Files]
#define protected PluginsBaseDir "plugins"

#define protected FindHandle
#define protected FindResult

#sub ProcessFoundPlugin
  #define private FileName FindGetFileName(FindHandle)
  #if FileName != "." && FileName != ".."
    #define private PluginsSourceDir AddBackslash(RootInstallDir) + AddBackslash(PluginsBaseDir) + FileName
    #define private PluginsDestDir AddBackslash(PluginsBaseDir) + FileName
    Source: {#PluginsSourceDir}\lib{#FileName}.dll; DestDir: {app}\{#PluginsDestDir}; Flags: ignoreversion; Components: main
    Source: {#PluginsSourceDir}\icons\*; DestDir: {app}\{#PluginsDestDir}\icons; Flags: recursesubdirs createallsubdirs; Components: main
    Source: {#PluginsSourceDir}\xml\*; DestDir: {app}\{#PluginsDestDir}\xml; Flags: recursesubdirs createallsubdirs; Components: main
  #endif
#endsub

Source: {#RootInstallDir}\CHANGELOG.md; DestDir: {app}; Components: main
Source: {#RootInstallDir}\LICENSE; DestDir: {app}; Components: main
Source: {#RootInstallDir}\wxFormBuilder.exe; DestDir: {app}; Flags: ignoreversion; Components: main
Source: {#RootInstallDir}\resources\*; DestDir: {app}\resources; Flags: recursesubdirs createallsubdirs; Components: main
#for {FindHandle = FindResult = FindFirst(AddBackslash(RootInstallDir) + AddBackslash(PluginsBaseDir) + "*", faDirectory); FindResult; FindResult = FindNext(FindHandle)} ProcessFoundPlugin
#if FindHandle
  #expr FindClose(FindHandle)
#endif

Source: {#RootInstallDir}\wx*.dll; DestDir: {app}; Components: main

Source: {#RootInstallDir}\lib*.dll; DestDir: {app}; Components: runtime
Source: {#RootInstallDir}\zlib1.dll; DestDir: {app}; Components: runtime


[Icons]
Name: {group}\{#MyAppName}; Filename: {app}\{#MyAppExeName}
;Name: {group}\{#MyAppName} Help; Filename: {app}\{#MyAppName}.hlp
Name: {group}\{cm:UninstallProgram,{#MyAppName}}; Filename: {uninstallexe}
Name: {autodesktop}\{#MyAppName}; Filename: {app}\{#MyAppExeName}; Tasks: desktopicon


[Registry]
Root: HKLM; Subkey: SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\{#MyAppExeName}; ValueType: string; ValueData: {app}\{#MyAppExeName}; Flags: uninsdeletekey
Root: HKCR; SubKey: .fbp; ValueType: string; ValueData: {#MyAppName}.Project; Flags: uninsdeletekey
Root: HKCR; SubKey: {#MyAppName}.Project\DefaultIcon; ValueType: string; ValueName: ; ValueData: {app}\{#MyAppExeName}; Flags: uninsdeletekey
Root: HKCR; SubKey: {#MyAppName}.Project; ValueType: string; ValueData: {#MyAppName} Project File; Flags: uninsdeletekey
Root: HKCR; SubKey: {#MyAppName}.Project\Shell\Open\Command; ValueType: string; ValueData: """{app}\{#MyAppExeName}"" ""%1"""; Flags: uninsdeletevalue


[Run]
Filename: {app}\{#MyAppExeName}; Description: {cm:LaunchProgram,{#MyAppName}}; Flags: nowait postinstall skipifsilent


; Debug output of preprocessor up to current line, at end == complete file
;#expr SaveToFile("preprocessed.iss")
