### This script walks through all *.py that are included in the binary
### package and replaces the build-specify timestamp and build path
### generated by Cheetah.  This makes the building of the package
### reproducible.  This script is intended to be called in the
### override_dh_auto_install rule.

import os
import re
import sys
import time
import fnmatch
import fileinput
import debian.changelog as dch
from dateutil import parser

ch = dch.Changelog (open ('debian/changelog', 'r'))
dt = ch [0].date
ts = time.mktime (parser.parse (dt).timetuple ())

for dName, sdName, fList in os.walk ('debian/xmds2'):
    for fileName in fList:
        if fnmatch.fnmatch (fileName, '*.py'):
            fname = os.path.join (dName, fileName)
            for line in fileinput.input (fname, inplace = True):
                outline = line
                if re.match ("^__CHEETAH_srcLastModified__ = .*$", line):
                    outline = "__CHEETAH_srcLastModified__ = '%s'\n" % dt
                m = re.match ("^__CHEETAH_src__ = '.*/(.*)'$", line)
                if m:
                    outline = "__CHEETAH_src__ = '%s'\n" % m.group (1)
                sys.stdout.write (outline)
