#!/usr/bin/perl
# Make diff of 3 files
# GNU (C) Gaspar Sinai  <gsinai@yudit.org>
# Tokyo 2002-04-10

$PLANE1="JISX0213-1.TXT";
$VERSION="Version 1.1";
$date = `date '+%Y-%m-%d'`;

$BASE=0x80000040;
$START=$BASE;
#
# Make a Yudit Ligature Map
#
$arg=$ARGV[0];

if ($arg ne "cluster" && $arg ne "cpp" && $arg ne "jis" && $arg ne "sjis")
{
  die "usage: $0 {cluster|cpp|mys}" 
}

#
# SJIS is KEY
#
%JISMAP=();
%KUTENMAP=();
%UMAP=();

%ALLJ=();
%ALLU=();

&makeMap ($PLANE1);
if ($arg eq "cpp")
{
  print "// END OF $0\n";
}
else
{
  print "# END OF $0\n";
}

sub makeMap 
{
  open (P1, "<$_[0]") || die "Can not open $_[0]"; 
  while (<P1>)
  {
    chomp;
    next if (/UNASSIGNED .* JIS /);
    
    if (/^0x([0-9A-F]+)[ \t]+0x([0-9A-F]+)[ \t]+0x([0-9A-F]+)[ \t]+0x([0-9A-F]+)[ \t]+0x([0-9A-F]+)[ \t]+(.*)/)
    {
      $SJ=hex($1);
      $JISMAP{($SJ)}=sprintf ("%04X", hex($2));
      $UMAP{($SJ)}=sprintf ("%08X+%08X+%08X", hex($3), hex($4), hex($5));
      &printmap ($SJ, hex($2), hex($3), hex($4), hex($5));     
      $KT=$6;
      $KT=$1 if ($KT=~/(\d+-\d+-\d+)/);
      $KUTENMAP{$SJ}=$KT;
    }
    elsif (/^0x([0-9A-F]+)[ \t]+0x([0-9A-F]+)[ \t]+0x([0-9A-F]+)[ \t]+0x([0-9A-F]+)[ \t]+(.*)/)
    {
      $SJ=hex($1);
      $JISMAP{($SJ)}=sprintf ("%04X", hex($2));
      $UMAP{($SJ)}=sprintf ("%08X+%08X", hex($3), hex($4));
      &printmap ($SJ, hex($2), hex($3), hex($4));     
      $KT=$5;
      $KT=$1 if ($KT=~/(\d+-\d+-\d+)/);
      $KUTENMAP{$SJ}=$KT;
    }
    elsif (/^0x([0-9A-F]+)[ \t]+0x([0-9A-F]+)[ \t]+0x([0-9A-F]+)[ \t]+(.*)/)
    {
      $SJ=hex($1);
      $JISMAP{($SJ)}=sprintf ("%04X", hex($2));
      $UMAP{($SJ)}=sprintf ("%08X", hex($3));
      $KT=$4;
      $KT=$1 if ($KT=~/(\d+-\d+-\d+)/);
      $KUTENMAP{$SJ}=$KT;
    }
    elsif (/^0x([0-9A-F]+)[ \t]+0x([0-9A-F]+)[ \t]+(.*)/)
    {
      $SJ=hex($1);
      $JISMAP{($SJ)}=sprintf ("%04X", hex($2));
      $UMAP{($SJ)}="";
      $KT=$3;
      $KT=$1 if ($KT=~/(\d+-\d+-\d+)/);
      $KUTENMAP{$SJ}=$KT;
    }
  }
  close (P1);
}

sub 
printmap 
{
  ($s, $j, @p) = @_;
  # Done - tone marks
  return if ($p[$#p] == 0x200C);
  die "too many combinations" if ($#p != 1); 
  if ($arg eq "cluster")
  {
    if ($START == $BASE)
    {
       print "# Generated by $0 at $date\n";
       print "# Add this to bin/cluster/cluster.template\n";
    }
    printf ("%04X %04X -> %08X %08X %08X\n", 
      $p[0], $p[1], $p[0], $p[1], $BASE++); 
  }
  elsif ($arg eq "cpp")
  {
    if ($START == $BASE)
    {
       print "// Generated by $0 at $date\n";
       print "// Add this to stoolkit/SCluster.cpp expandYuditLigatures\n";
    }
    $c = sprintf ("0x%08X", $BASE++); 
    $jp = sprintf ("0x%04X", $j); 
    $f = sprintf ("0x%04X", $p[0]);
    $s = sprintf ("0x%04X", $p[1]);
print <<EOD;
  case $c: /* JIS X 0213: $jp */
    decd->append ($f);
    decd->append ($s);
    break;
EOD
  }
  elsif ($arg eq "jis")
  {
    if ($START == $BASE)
    {
       print "# Generated by $0 at $date\n";
       print "# Add this to mytool/mys/jis-0213-1.mys\n";
    }
    printf ("%04X -> %08X\n", $j, $BASE++);
  }
  elsif ($arg eq "sjis")
  {
    if ($START == $BASE)
    {
       print "# Generated by $0 at $date\n";
       print "# Add this to mytool/mys/shift-jis-3.mys\n";
    }
    printf ("%04X -> %08X\n", $s, $BASE++);
  }
}
