package ONVIF::Device::Types::RecordingJobStateInformation;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %RecordingToken_of :ATTR(:get<RecordingToken>);
my %State_of :ATTR(:get<State>);
my %Sources_of :ATTR(:get<Sources>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        RecordingToken
        State
        Sources
        Extension

    ) ],
    {
        'RecordingToken' => \%RecordingToken_of,
        'State' => \%State_of,
        'Sources' => \%Sources_of,
        'Extension' => \%Extension_of,
    },
    {
        'RecordingToken' => 'ONVIF::Device::Types::RecordingReference',
        'State' => 'ONVIF::Device::Types::RecordingJobState',
        'Sources' => 'ONVIF::Device::Types::RecordingJobStateSource',
        'Extension' => 'ONVIF::Device::Types::RecordingJobStateInformationExtension',
    },
    {

        'RecordingToken' => 'RecordingToken',
        'State' => 'State',
        'Sources' => 'Sources',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Device::Types::RecordingJobStateInformation

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
RecordingJobStateInformation from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * RecordingToken


=item * State


=item * Sources


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Device::Types::RecordingJobStateInformation
   RecordingToken => $some_value, # RecordingReference
   State => $some_value, # RecordingJobState
   Sources =>  { # ONVIF::Device::Types::RecordingJobStateSource
     SourceToken =>  { # ONVIF::Device::Types::SourceReference
       Token => $some_value, # ReferenceToken
     },
     State => $some_value, # RecordingJobState
     Tracks =>  { # ONVIF::Device::Types::RecordingJobStateTracks
       Track =>  { # ONVIF::Device::Types::RecordingJobStateTrack
         SourceTag =>  $some_value, # string
         Destination => $some_value, # TrackReference
         Error =>  $some_value, # string
         State => $some_value, # RecordingJobState
       },
     },
   },
   Extension =>  { # ONVIF::Device::Types::RecordingJobStateInformationExtension
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

