/* GNU Mailutils -- a suite of utilities for electronic mail
   Copyright (C) 2025 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with GNU Mailutils.  If not, see <http://www.gnu.org/licenses/>. */

#include <assert.h>
#include <mailutils/mailutils.h>

int
main (int argc, char **argv)
{
  mu_mailbox_t mbox;
  mu_stream_t str;
  mu_message_t msg;
  
  assert (argc == 3);
  mu_set_program_name (argv[0]);
  mu_register_all_mailer_formats ();

  MU_ASSERT (mu_mailbox_create (&mbox, argv[1]));
  MU_ASSERT (mu_mailbox_open (mbox, MU_STREAM_APPEND));

  MU_ASSERT (mu_file_stream_create (&str, argv[2], MU_STREAM_READ));
  MU_ASSERT (mu_stream_to_message (str, &msg));
  mu_stream_unref (str);
  MU_ASSERT (mu_mailbox_append_message (mbox, msg));

  mu_mailbox_close (mbox);
  mu_mailbox_destroy (&mbox);
  mu_message_destroy (&msg, mu_message_get_owner (msg));

  return 0;
}
	     
