---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, équations, 
              structures, indices, exposants, indice à gauche, 
              exposant à gauche
---

# Comment obtenir des indices ou exposants à gauche ?

Il est parfois nécessaire de placer des 
[indices ou exposants](/4_domaines_specialises/mathematiques/structures/indices/start)
devant un symbole, par exemple pour la transposée d'une matrice. 
Voici quelques méthodes sur ce sujet.


## Avec des commandes de base

La solution de base consiste à placer ceux-ci sur un groupe vide, 
afin d'éviter qu'ils n'aillent se coller au symbole précédent. 
Dans certains cas, il sera intéressant d'ajuster l'espace manuellement, 
par exemple avec la commande `\!`. Voici un exemple de cette méthode :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\Huge
\[  A {}^t M \neq A{}^t\!M  \]
\end{document}
```

L'inconvénient est que cette méthode n'est pas générale.
Elle ne positionne pas bien l'élement mis en indice ou en exposant 
en ne considérant pas la taille de l'élément qui sert de référence à l'indice
ou l'exposant. En voici un exemple :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}

\begin{document}
\[
  {}^t
  \begin{bmatrix}
    a & b \\  c & d \\
  \end{bmatrix}
  =
  \begin{bmatrix}
    a & c \\  b & d \\
  \end{bmatrix}
\]
\end{document}
```

Pour contourner cette difficulté, il est possible de définir une commande
`\transposee` utilisant la commande `\vphantom`.

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}

  \newcommand{\transposee}[1]{{\vphantom{#1}}^{\mathit t}{#1}}

\begin{document}
\[
  \transposee{
  \begin{bmatrix}
    a & b \\ c & d \\
  \end{bmatrix}
  }
  =
  \begin{bmatrix}
    a & c \\  b & d \\
  \end{bmatrix}
\]
\end{document}
```


## Avec l'extension <ctanpkg:mathtools>

Pour des symboles qui ne sont pas des grands opérateurs, 
l'extension <ctanpkg:mathtools> (ou <ctanpkg:amsmath>) met à disposition 
la commande `\prescript` qui fournit un alignement sur la droite, 
plus satisfaisant que celui de la solution du groupe vide.

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}

\begin{document}
\LARGE 
\[  {}^{12}_3 C \neq \prescript{12}{3}{C}  \]
\end{document}
```

Dans le cas des grands opérateurs (le symbole de sommation ou de produit 
par exemple), <ctanpkg:mathtools> propose la commande `\sideset` 
dont voici un exemple :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}

\begin{document}
\[  \sideset{_a^b}{_c^d}\prod  \]
\end{document}
```

La [documentation](texdoc:amsldoc) de l'extension <ctanpkg:amsmath> 
(appelée par <ctanpkg:mathtools>) donne d'ailleurs un exemple compliqué 
à traiter si `\sideset` n'est pas utilisé (mettre un prime sur le symbole
de sommation alors que ce dernier a des éléments sous lui) :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}

\begin{document}
\[
  \sideset{}{'}\sum_{n<k,\; \text{$n$ impair}} nE_n
\]
\end{document}
```

Cette commande peut être utilisée dans la définition de la commande 
`\transposee` vue plus haut. Il faut cependant rester ici prudent, 
les auteurs de l'extension indiquant que la commande `\sideset` devrait 
être limitée aux seuls grands opérateurs.

```{noedit}
\newcommand{\transposee}[1]{\sideset{^{\mathit{t}}}{}{#1}}
```


## Avec l'extension <ctanpkg:chemsym>

```{warning}
Pour des raisons de licence, <ctanpkg:chemsym> est absent de la distribution 
TeX Live.
```

Dans un domaine un peu différent, celui de la 
[chimie](/4_domaines_specialises/sciences/chimie/start), 
l'extension <ctanpkg:chemsym> permet de définir et d'utiliser 
des symboles chimiques plus facilement. Elle permet en particulier de définir
des commandes simplifiant la saisie de quelques symboles qui ont des exposants
à gauche (avec des méthodes similaires à celles présentées en début 
de cette page). L'exemple ci-dessous est repris 
de la [documentation](texdoc:chemsym) de l'extension.

```{noedit}
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{chemsym}

  \newcommand{\hH}{\kemtkn{{}^2H}}

\begin{document}
Voici une des notations du deutérium : \hH.
\end{document}
```


:::{sources}
- [Indices et exposants en folie](https://www.elzevir.fr/imj/latex/tips.html#indices), 
  par Manuel Pégourié-Gonnard
:::