/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.plan;

import com.intellij.database.dialects.base.plan.RawPlanData;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Base64;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import org.codehaus.jettison.json.JSONObject;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPlanModelBuilder<Data extends RawPlanData, State> {
    protected static final Logger LOG = Logger.getInstance(AbstractPlanModelBuilder.class);
    private static final JBTreeTraverser<NodeDesc> TRAVERSER = JBTreeTraverser.from(desc -> desc.children);
    protected final Logger myLogger;
    private final EnumSet<PlanModel.Feature> myUnsupportedFeatures;
    private final List<NodeDesc> myNodes;
    private final Map<State, NodeDesc> myReady;
    private NodeDesc myRoot;
    private boolean myValid;
    protected Data myData;
    protected boolean myActual;

    protected AbstractPlanModelBuilder(@NotNull EnumSet<PlanModel.Feature> unsupportedFeatures) {
        if (unsupportedFeatures == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(0);
        }
        this.myLogger = Logger.getInstance(this.getClass());
        this.myNodes = new ArrayList<NodeDesc>();
        this.myReady = new HashMap<State, NodeDesc>();
        this.myUnsupportedFeatures = unsupportedFeatures;
    }

    @NotNull
    public PlanModel build(@NotNull Data data) {
        if (data == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(1);
        }
        this.myData = data;
        this.parseData();
        return new PlanModel(this.getRootNode(), this.myActual, this.myUnsupportedFeatures);
    }

    @NotNull
    public abstract Data createData();

    protected abstract void parseData();

    protected boolean openNode(@Nullable State key2) {
        NodeDesc prev;
        NodeDesc existing = key2 == null ? null : this.myReady.get(key2);
        NodeDesc node = new NodeDesc();
        if (existing != null) {
            boolean recursion = this.myNodes.contains(existing);
            node.lazy = () -> existing.node == null ? null : new PlanModel.RefNode(existing.node, recursion ? PlanModel.NodeType.RECURSION : PlanModel.NodeType.REUSE);
        }
        if ((prev = (NodeDesc)ContainerUtil.getLastItem(this.myNodes)) != null) {
            prev.children.add(node);
        }
        if (existing != null) {
            return false;
        }
        this.myNodes.add(node);
        if (key2 != null) {
            this.myReady.put(key2, node);
        }
        return true;
    }

    protected PlanModel.GenericNode removePrevNode() {
        NodeDesc desc = this.removePrevNodeImpl();
        return desc == null ? null : desc.node;
    }

    protected PlanModel.GenericNode mergeLastChild() {
        NodeDesc me = (NodeDesc)ContainerUtil.getLastItem(this.myNodes);
        if (me == null) {
            return null;
        }
        if (me.children.isEmpty()) {
            return null;
        }
        NodeDesc desc = me.children.remove(me.children.size() - 1);
        if (desc == null) {
            return null;
        }
        me.children.addAll(desc.children);
        return desc.node;
    }

    private NodeDesc removePrevNodeImpl() {
        if (this.myNodes.size() < 2) {
            return null;
        }
        NodeDesc parent = this.myNodes.get(this.myNodes.size() - 2);
        List<NodeDesc> children2 = parent.children;
        if (children2.size() < 2) {
            return null;
        }
        return children2.remove(children2.size() - 2);
    }

    protected void wrapPrevNode() {
        NodeDesc prev = this.removePrevNodeImpl();
        if (prev == null) {
            return;
        }
        NodeDesc me = this.myNodes.get(this.myNodes.size() - 1);
        me.children.add(prev);
    }

    protected void closeNode(@NotNull PlanModel.GenericNode node) {
        if (node == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(2);
        }
        NodeDesc current = (NodeDesc)ContainerUtil.getLastItem(this.myNodes);
        assert (current != null);
        current.node = node;
        this.myNodes.remove(this.myNodes.size() - 1);
        if (this.myNodes.isEmpty()) {
            assert (this.myRoot == null);
            this.myRoot = current;
        }
    }

    protected void addLazyNode(@NotNull Supplier<PlanModel.GenericNode> lazy, boolean secondPass) {
        if (lazy == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(3);
        }
        NodeDesc newNode = new NodeDesc();
        newNode.lazy = lazy;
        newNode.onSecondPass = secondPass;
        NodeDesc prev = (NodeDesc)ContainerUtil.getLastItem(this.myNodes);
        if (prev == null) {
            this.myRoot = newNode;
        } else {
            prev.children.add(newNode);
        }
    }

    private void expandNodes() {
        JBIterable traversal = ((JBTreeTraverser)TRAVERSER.withRoot((Object)this.myRoot)).bfsTraversal();
        for (NodeDesc desc : traversal) {
            this.processLazyNode(desc, false);
        }
        for (NodeDesc desc : traversal) {
            this.processLazyNode(desc, true);
        }
        for (NodeDesc parent : traversal) {
            if (parent.node.getChildren().length != 0) continue;
            PlanModel.GenericNode[] children2 = new PlanModel.GenericNode[parent.children.size()];
            for (int i2 = 0; i2 < parent.children.size(); ++i2) {
                children2[i2] = parent.children.get((int)i2).node;
            }
            parent.node.setChildren(children2);
        }
        this.detectCycles();
        this.myValid = true;
    }

    private void processLazyNode(@NotNull NodeDesc desc, boolean secondPass) {
        if (desc == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(4);
        }
        if (desc.node != null || desc.onSecondPass && !secondPass) {
            return;
        }
        assert (this.myNodes.isEmpty());
        this.myNodes.add(desc);
        desc.node = desc.lazy.get();
        assert (this.myNodes.size() == 1);
        this.myNodes.clear();
    }

    @NotNull
    protected PlanModel.GenericNode getRootNode() {
        assert (this.myNodes.isEmpty());
        if (this.myRoot == null) {
            this.myRoot = new NodeDesc();
            this.myRoot.node = new PlanModel.GenericNode(PlanModel.NodeType.ROOT, null);
        } else if (!this.myValid) {
            this.expandNodes();
        }
        PlanModel.GenericNode genericNode = this.myRoot.node;
        if (genericNode == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(5);
        }
        return genericNode;
    }

    protected void resetRoot() {
        this.getRootNode();
        this.myRoot = null;
        this.myValid = false;
    }

    @NotNull
    protected PlanModel.GenericNode createNode(final @Nullable State state, @NotNull PlanModel.NodeType type, @Nullable String typeStr) throws PlanRetrievalException {
        if (type == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(6);
        }
        if (typeStr != null && AbstractPlanModelBuilder.isSame(type, typeStr)) {
            typeStr = null;
        }
        PlanModel.GenericNode node = PlanModel.createNode(type, typeStr);
        if (state != null) {
            node.accept(new PlanModel.PlanVisitor(){

                @Override
                public void visit(@NotNull PlanModel.GenericNode node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    AbstractPlanModelBuilder.this.parseNode(state, node);
                }

                @Override
                public void visit(@NotNull PlanModel.GenericAccessNode node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    AbstractPlanModelBuilder.this.parseNode(state, node);
                }

                @Override
                public void visit(@NotNull PlanModel.IndexScanNode node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    AbstractPlanModelBuilder.this.parseNode(state, node);
                }

                @Override
                public void visit(@NotNull PlanModel.SubQueryNode node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    AbstractPlanModelBuilder.this.parseNode(state, node);
                }

                @Override
                public void visit(@NotNull PlanModel.RefNode node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    throw new IllegalStateException("Should not be called");
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dialects/base/plan/AbstractPlanModelBuilder$1", "visit"));
                }
            });
        }
        PlanModel.GenericNode genericNode = node;
        if (genericNode == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(7);
        }
        return genericNode;
    }

    private static boolean isSame(@NotNull PlanModel.NodeType type, @NotNull String typeStr) {
        if (type == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(8);
        }
        if (typeStr == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(9);
        }
        return typeStr.equalsIgnoreCase(type.display) || type == PlanModel.NodeType.INTERSECT && typeStr.equalsIgnoreCase("intersect");
    }

    @NlsSafe
    @NotNull
    protected abstract String parseRawDescription(@NotNull State var1);

    @Nullable
    protected abstract String parseAccessRelation(@NotNull State var1);

    @Nullable
    protected abstract BigDecimal parsePlanNumRows(@NotNull State var1);

    @Nullable
    protected BigDecimal parseActualNumRows(@NotNull State state) {
        if (state == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(10);
        }
        return null;
    }

    @Nullable
    protected abstract String parseAccessIndex(@NotNull State var1);

    protected abstract void parsePlan(@NotNull State var1);

    protected abstract void parseSubPlans(@NotNull State var1);

    protected abstract void parseStatement(@NotNull State var1);

    protected void parseNode(@NotNull State state, @NotNull PlanModel.GenericNode node) {
        if (state == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(11);
        }
        if (node == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(12);
        }
        node.setPlanNumRows(this.parsePlanNumRows(state));
        node.setTotalCost(this.parseTotalCost(state));
        node.setStartupCost(this.parseStartupCost(state));
        this.parseActualInfo(state, node);
        node.setRawDescription(this.parseRawDescription(state));
    }

    protected void parseActualInfo(@NotNull State state, @NotNull PlanModel.GenericNode node) {
        if (state == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(13);
        }
        if (node == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(14);
        }
        node.setActualNumRows(this.parseActualNumRows(state));
        node.setActualTotalTime(this.parseActualTotalTime(state));
        node.setActualStartupTime(this.parseActualStartupTime(state));
    }

    @Nullable
    protected abstract Double parseTotalCost(@NotNull State var1);

    @Nullable
    protected Double parseActualTotalTime(@NotNull State state) {
        if (state == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(15);
        }
        return null;
    }

    @Nullable
    protected abstract Double parseStartupCost(@NotNull State var1);

    @Nullable
    protected Double parseActualStartupTime(@NotNull State state) {
        if (state == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(16);
        }
        return null;
    }

    protected void parseNode(@NotNull State state, @NotNull PlanModel.SubQueryNode node) {
        if (state == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(17);
        }
        if (node == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(18);
        }
        node.setCorrelated(this.parseSubqueryCorrelated(state));
        node.setScalar(this.parseSubqueryScalar(state));
        this.parseDown(state, node);
    }

    protected abstract boolean parseSubqueryCorrelated(@NotNull State var1);

    protected abstract boolean parseSubqueryScalar(@NotNull State var1);

    protected void parseNode(@NotNull State state, @NotNull PlanModel.GenericAccessNode node) {
        if (state == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(19);
        }
        if (node == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(20);
        }
        node.setRelation(this.parseAccessRelation(state));
        this.parseDown(state, node);
    }

    protected void parseNode(@NotNull State state, @NotNull PlanModel.IndexScanNode node) {
        if (state == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(21);
        }
        if (node == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(22);
        }
        node.setIndex(this.parseAccessIndex(state));
        this.parseDown(state, node);
    }

    protected void parseDown(@NotNull State state, @NotNull PlanModel.IndexScanNode node) {
        if (state == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(23);
        }
        if (node == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(24);
        }
        this.parseNode(state, (PlanModel.GenericAccessNode)node);
    }

    protected void parseDown(@NotNull State state, @NotNull PlanModel.GenericAccessNode node) {
        if (state == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(25);
        }
        if (node == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(26);
        }
        this.parseNode(state, (PlanModel.GenericNode)node);
    }

    protected void parseDown(@NotNull State state, @NotNull PlanModel.SubQueryNode node) {
        if (state == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(27);
        }
        if (node == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(28);
        }
        this.parseNode(state, (PlanModel.GenericNode)node);
    }

    @Contract(value="->fail")
    protected void unsupportedFormat() {
        this.unsupportedFormat(null);
    }

    @Contract(value="_->fail")
    protected void unsupportedFormat(@Nullable String comment) {
        this.unsupportedFormat(null, comment);
    }

    @Contract(value="_,_->fail")
    protected void unsupportedFormat(Throwable e, @Nullable String comment) {
        this.myLogger.error("Database returned plan in unsupported format" + (String)(comment == null ? "" : ": " + comment), new Attachment[]{new Attachment("raw_plan.txt", ((RawPlanData)this.myData).dump())});
        throw new PlanRetrievalException("Database returned plan in unsupported format" + (String)(comment == null ? "" : ": " + comment), e);
    }

    public static String randomShorterUUID() {
        UUID uuid = UUID.randomUUID();
        return Base64.getEncoder().encodeToString(ByteBuffer.allocate(16).putLong(uuid.getLeastSignificantBits()).putLong(uuid.getMostSignificantBits()).array());
    }

    private void detectCycles() {
        HashMap<PlanModel.GenericNode, Integer> colors = new HashMap<PlanModel.GenericNode, Integer>();
        ArrayList<PlanModel.GenericNode> stack = new ArrayList<PlanModel.GenericNode>();
        stack.add(this.myRoot.node);
        colors.put(this.myRoot.node, 0);
        while (!stack.isEmpty()) {
            PlanModel.GenericNode node = (PlanModel.GenericNode)stack.get(stack.size() - 1);
            int color = (Integer)colors.get(node);
            colors.put(node, color + 1);
            if (color != 0) {
                stack.remove(stack.size() - 1);
                continue;
            }
            colors.put(node, 1);
            for (PlanModel.GenericNode child : node.getChildren()) {
                Integer c2 = (Integer)colors.get(child);
                if (c2 == null) {
                    colors.put(child, 0);
                    stack.add(child);
                    continue;
                }
                if (c2 != 1) continue;
                StringBuilder sb = new StringBuilder();
                boolean add = false;
                sb.append((Object)child.getType());
                for (PlanModel.GenericNode item : stack) {
                    if (add) {
                        sb.append("\n -> ").append((Object)item.getType());
                    }
                    if (item != child) continue;
                    add = !add;
                }
                sb.append("\n -> cycle");
                throw new PlanRetrievalException("Cycle detected\n" + String.valueOf(sb));
            }
        }
    }

    public static BigDecimal optBig(@NotNull JSONObject obj2, @NotNull String key2, @Nullable BigDecimal def) {
        if (obj2 == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(29);
        }
        if (key2 == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(30);
        }
        return obj2.opt(key2) == null ? def : new BigDecimal(obj2.optString(key2, "-1"));
    }

    public static Double optDouble(@NotNull JSONObject obj2, @NotNull String key2, @Nullable Double def) {
        if (obj2 == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(31);
        }
        if (key2 == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(32);
        }
        return obj2.opt(key2) == null ? def : Double.valueOf(obj2.optDouble(key2, -1.0));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unsupportedFeatures";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: 
            case 12: 
            case 14: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lazy";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desc";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/base/plan/AbstractPlanModelBuilder";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeStr";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/base/plan/AbstractPlanModelBuilder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootNode";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "closeNode";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addLazyNode";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processLazyNode";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createNode";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isSame";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseActualNumRows";
                break;
            }
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "parseNode";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parseActualInfo";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parseActualTotalTime";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "parseActualStartupTime";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "parseDown";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "optBig";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "optDouble";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7 -> new IllegalStateException(string);
        };
    }

    private static final class NodeDesc {
        public PlanModel.GenericNode node;
        public Supplier<PlanModel.GenericNode> lazy;
        public boolean onSecondPass;
        public List<NodeDesc> children = new SmartList();

        private NodeDesc() {
        }
    }
}

