/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.Geom;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.aes.AestheticsDefaults;
import org.jetbrains.letsPlot.core.plot.base.geom.legend.GenericLegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.render.LegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.core.plot.base.render.svg.LinePath;
import org.jetbrains.letsPlot.core.plot.base.tooltip.GeomTargetCollector;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.slim.SvgSlimElements;
import org.jetbrains.letsPlot.datamodel.svg.dom.slim.SvgSlimGroup;
import org.jetbrains.letsPlot.datamodel.svg.dom.slim.SvgSlimObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J0\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H$J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012H\u0004J\u0014\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/GeomBase;", "Lorg/jetbrains/letsPlot/core/plot/base/Geom;", "()V", "legendKeyElementFactory", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "build", "", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "buildIntern", "getGeomTargetCollector", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetCollector;", "preferableNullDomain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "aes", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "Companion", "plot-base"})
public abstract class GeomBase
implements Geom {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        return new GenericLegendKeyElementFactory();
    }

    @Override
    public void build(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics2, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        this.buildIntern(root, aesthetics2, pos, coord, ctx2);
    }

    @NotNull
    public DoubleSpan preferableNullDomain(@NotNull Aes<?> aes2) {
        Intrinsics.checkNotNullParameter(aes2, (String)"aes");
        return new DoubleSpan(-0.5, 0.5);
    }

    @NotNull
    protected final GeomTargetCollector getGeomTargetCollector(@NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        return ctx2.getTargetCollector();
    }

    protected abstract void buildIntern(@NotNull SvgRoot var1, @NotNull Aesthetics var2, @NotNull PositionAdjustment var3, @NotNull CoordinateSystem var4, @NotNull GeomContext var5);

    @Override
    @NotNull
    public List<Aes<?>> getWontRender() {
        return Geom.DefaultImpls.getWontRender(this);
    }

    @Override
    public boolean rangeIncludesZero(@NotNull Aes<?> aes2) {
        return Geom.DefaultImpls.rangeIncludesZero(this, aes2);
    }

    @Override
    @NotNull
    public AestheticsDefaults updateAestheticsDefaults(@NotNull AestheticsDefaults aestheticDefaults) {
        return Geom.DefaultImpls.updateAestheticsDefaults(this, aestheticDefaults);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/GeomBase$Companion;", "", "()V", "layerAesBounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "overallAesBounds", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "wrap", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgGElement;", "slimGroup", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/slim/SvgSlimGroup;", "o", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/slim/SvgSlimObject;", "appendNodes", "", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "paths", "", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/LinePath;", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SvgGElement wrap(@NotNull SvgSlimGroup slimGroup) {
            Intrinsics.checkNotNullParameter((Object)slimGroup, (String)"slimGroup");
            SvgGElement g = new SvgGElement();
            g.setPrebuiltSubtree(true);
            g.children().add(slimGroup.asDummySvgNode());
            return g;
        }

        @NotNull
        public final SvgGElement wrap(@NotNull SvgSlimObject o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            SvgSlimGroup slimGroup = SvgSlimElements.INSTANCE.g(1);
            o.appendTo(slimGroup);
            return this.wrap(slimGroup);
        }

        @NotNull
        public final DoubleRectangle overallAesBounds(@NotNull GeomContext ctx2) {
            Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
            return ctx2.getFlipped() ? ctx2.getAesBounds().flip() : ctx2.getAesBounds();
        }

        @NotNull
        public final DoubleRectangle layerAesBounds(@NotNull Aesthetics aesthetics2) {
            Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
            DoubleSpan doubleSpan = aesthetics2.range(Aes.Companion.getX());
            Intrinsics.checkNotNull((Object)doubleSpan);
            DoubleSpan doubleSpan2 = aesthetics2.range(Aes.Companion.getY());
            Intrinsics.checkNotNull((Object)doubleSpan2);
            return new DoubleRectangle(doubleSpan, doubleSpan2);
        }

        public final void appendNodes(@NotNull SvgRoot $this$appendNodes, @NotNull List<LinePath> paths) {
            Intrinsics.checkNotNullParameter((Object)$this$appendNodes, (String)"<this>");
            Intrinsics.checkNotNullParameter(paths, (String)"paths");
            for (LinePath path2 : paths) {
                $this$appendNodes.add(path2.getRootGroup());
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

