/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.documentation.comments;

import com.intellij.httpClient.http.request.documentation.comments.psi.HttpDocElementType;
import com.intellij.httpClient.http.request.documentation.comments.psi.impl.HttpDocConnectionTimeoutTagImpl;
import com.intellij.httpClient.http.request.documentation.comments.psi.impl.HttpDocNameTagImpl;
import com.intellij.httpClient.http.request.documentation.comments.psi.impl.HttpDocNoAutoEncodingTagImpl;
import com.intellij.httpClient.http.request.documentation.comments.psi.impl.HttpDocNoCookieJarTagImpl;
import com.intellij.httpClient.http.request.documentation.comments.psi.impl.HttpDocNoLogResponseTagImpl;
import com.intellij.httpClient.http.request.documentation.comments.psi.impl.HttpDocNoRedirectTagImpl;
import com.intellij.httpClient.http.request.documentation.comments.psi.impl.HttpDocSocketTimeoutTagImpl;
import com.intellij.httpClient.http.request.documentation.comments.psi.impl.HttpDocUnknownTagImpl;
import com.intellij.httpClient.http.request.documentation.comments.psi.impl.HttpDocUseOsCredentialsTagImpl;
import com.intellij.httpClient.http.request.psi.HttpRequestTokenType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;

public interface HttpDocCommentElementTypes {
    public static final IElementType COMMENT_TAG = new HttpDocElementType("COMMENT_TAG");
    public static final IElementType CONNECTION_TIMEOUT_TAG = new HttpDocElementType("CONNECTION_TIMEOUT_TAG");
    public static final IElementType NAME_TAG = new HttpDocElementType("NAME_TAG");
    public static final IElementType NO_AUTO_ENCODING_TAG = new HttpDocElementType("NO_AUTO_ENCODING_TAG");
    public static final IElementType NO_COOKIE_JAR_TAG = new HttpDocElementType("NO_COOKIE_JAR_TAG");
    public static final IElementType NO_LOG_RESPONSE_TAG = new HttpDocElementType("NO_LOG_RESPONSE_TAG");
    public static final IElementType NO_REDIRECT_TAG = new HttpDocElementType("NO_REDIRECT_TAG");
    public static final IElementType SOCKET_TIMEOUT_TAG = new HttpDocElementType("SOCKET_TIMEOUT_TAG");
    public static final IElementType UNKNOWN_TAG = new HttpDocElementType("UNKNOWN_TAG");
    public static final IElementType USE_OS_CREDENTIALS_TAG = new HttpDocElementType("USE_OS_CREDENTIALS_TAG");
    public static final IElementType COMMENT_START = new HttpRequestTokenType("COMMENT_START");
    public static final IElementType COMMENT_TEXT = new HttpRequestTokenType("COMMENT_TEXT");
    public static final IElementType CONNECTION_TIMEOUT = new HttpRequestTokenType("CONNECTION_TIMEOUT");
    public static final IElementType EQUAL = new HttpRequestTokenType("=");
    public static final IElementType INTEGER = new HttpRequestTokenType("INTEGER");
    public static final IElementType NAME = new HttpRequestTokenType("NAME");
    public static final IElementType NO_AUTO_ENCODING = new HttpRequestTokenType("NO_AUTO_ENCODING");
    public static final IElementType NO_COOKIE_JAR = new HttpRequestTokenType("NO_COOKIE_JAR");
    public static final IElementType NO_LOG_RESPONSE = new HttpRequestTokenType("NO_LOG_RESPONSE");
    public static final IElementType NO_REDIRECT = new HttpRequestTokenType("NO_REDIRECT");
    public static final IElementType TIMEOUT = new HttpRequestTokenType("TIMEOUT");
    public static final IElementType TIME_SUFFIX = new HttpRequestTokenType("TIME_SUFFIX");
    public static final IElementType UNKNOWN = new HttpRequestTokenType("UNKNOWN");
    public static final IElementType USE_OS_CREDENTIALS = new HttpRequestTokenType("USE_OS_CREDENTIALS");

    public static class Factory {
        public static PsiElement createElement(ASTNode node) {
            IElementType type = node.getElementType();
            if (type == CONNECTION_TIMEOUT_TAG) {
                return new HttpDocConnectionTimeoutTagImpl(node);
            }
            if (type == NAME_TAG) {
                return new HttpDocNameTagImpl(node);
            }
            if (type == NO_AUTO_ENCODING_TAG) {
                return new HttpDocNoAutoEncodingTagImpl(node);
            }
            if (type == NO_COOKIE_JAR_TAG) {
                return new HttpDocNoCookieJarTagImpl(node);
            }
            if (type == NO_LOG_RESPONSE_TAG) {
                return new HttpDocNoLogResponseTagImpl(node);
            }
            if (type == NO_REDIRECT_TAG) {
                return new HttpDocNoRedirectTagImpl(node);
            }
            if (type == SOCKET_TIMEOUT_TAG) {
                return new HttpDocSocketTimeoutTagImpl(node);
            }
            if (type == UNKNOWN_TAG) {
                return new HttpDocUnknownTagImpl(node);
            }
            if (type == USE_OS_CREDENTIALS_TAG) {
                return new HttpDocUseOsCredentialsTagImpl(node);
            }
            throw new AssertionError((Object)("Unknown element type: " + String.valueOf(type)));
        }
    }
}

