/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors;

import org.eclipse.jface.resource.ImageDescriptor;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseObject;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNode;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeObject;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorInput;

public class ObjectEditorInput
extends DatabaseEditorInput<DBNDatabaseNode> {
    private DBXTreeObject editorMeta;

    public ObjectEditorInput(@NotNull DBNDatabaseObject dbmNode) {
        super((DBNDatabaseNode)dbmNode);
    }

    public ObjectEditorInput(@NotNull DBNDatabaseNode dbmNode, @NotNull DBXTreeObject meta) {
        super(dbmNode);
        this.editorMeta = meta;
    }

    @Nullable
    public DBXTreeObject getEditorMeta() {
        DBXTreeNode dBXTreeNode;
        if (this.editorMeta != null) {
            return this.editorMeta;
        }
        DBNDatabaseNode node = this.getNavigatorNode();
        if (node != null && (dBXTreeNode = node.getMeta()) instanceof DBXTreeObject) {
            DBXTreeObject meta = (DBXTreeObject)dBXTreeNode;
            return meta;
        }
        return null;
    }

    public ImageDescriptor getImageDescriptor() {
        DBXTreeObject meta = this.getEditorMeta();
        return meta == null ? null : DBeaverIcons.getImageDescriptor((DBPImage)meta.getDefaultIcon());
    }

    public String getToolTipText() {
        DBXTreeObject meta = this.getEditorMeta();
        return meta == null ? "" : meta.getDescription();
    }

    public boolean equals(Object obj) {
        return obj instanceof ObjectEditorInput && super.equals(obj) && this.getEditorMeta() == ((ObjectEditorInput)((Object)obj)).getEditorMeta();
    }
}

