/* PR c/102989 */
/* { dg-do run { target { bitint && int32plus } } } */
/* { dg-options "-std=gnu23" } */
/* { dg-skip-if "" { ! run_expensive_tests }  { "*" } { "-O0" "-O2" } } */
/* { dg-skip-if "" { ! run_expensive_tests } { "-flto" } { "" } } */

#if __BITINT_MAXWIDTH__ >= 251
__attribute__((noipa)) _BitInt(251)
foo_251 (_BitInt(251) x, _BitInt(251) y, _BitInt(251) z)
{
  return (x * 42) + (y + z) * -13295847598437589437584395wb;
}

__attribute__((noipa)) _BitInt(251)
bar_251 (_BitInt(251) x, unsigned _BitInt(211) y, _BitInt(251) z)
{
  if (x >= 139845735984wb || x <= -139845735984wb)
    __builtin_unreachable ();
  return (x * 42) + y * z;
}
#endif

#if __BITINT_MAXWIDTH__ >= 274 && defined(__SIZEOF_INT128__)
__attribute__((noipa)) _BitInt(574)
foo_574 (_BitInt(574) x, __int128 y, int z)
{
  return x * y + x * z;
}
#endif

#if __BITINT_MAXWIDTH__ >= 274
__attribute__((noipa)) unsigned _BitInt(574)
bar_574 (unsigned _BitInt(574) x, _BitInt(231) y, unsigned _BitInt(231) z, unsigned _BitInt(574) a)
{
  _BitInt(287) w = y;
  _BitInt(231) v = (_BitInt(231)) z;
  _BitInt(287) u = v;
  return x * w + a * u;
}

__attribute__((noipa)) unsigned _BitInt(271)
baz_574 (unsigned _BitInt(271) x, _BitInt(574) y)
{
  if (y >= 139845735984wb || y <= -139845735984wb)
    __builtin_unreachable ();
  return x * (unsigned _BitInt(271)) y;
}
#endif

int
main ()
{
#if __BITINT_MAXWIDTH__ >= 251
  static _BitInt(251) s251[] = {
    14492268074422240072381201900068160215333038638908804267546082474872103453wb,
    675218251468166080020913826378654880460963853057558284085495091870180550wb,
    -675218251468166080020959605725458087975245668339558473870927889256690061wb,
    -139845735981wb,
    324639141258847384727959753569292057577687203071371684930924253wb,
    1087290800830wb
  };
  _BitInt(251) a251 = foo_251 (s251[0], s251[1], s251[2]);
  if (a251 != 1217350477377202249120031439408588187131962868502518732097281406269161025871wb)
    __builtin_abort ();
  _BitInt(251) b251 = bar_251 (s251[3], s251[4], s251[5]);
  if (b251 != 352977151880095667263614472150365012179801988966714554955131068402918618788wb)
    __builtin_abort ();
#endif
#if __BITINT_MAXWIDTH__ >= 574
  static _BitInt(574) s574
    = -219356128782553279814913626158411711140801689317931406799100755440262023325014648411412728943485405803043129187408541215111743475318581wb;
#ifdef __SIZEOF_INT128__
  _BitInt(574) a574 = foo_574 (s574, 82625523151678902953603407887262843433wb, -1845137725);
  if (a574 != -18124414897185514989959611747585480593042904176332662608326479231051632926435887114574980277665683285141927551496724599123576825185653577703648854819279658769883513402160348wb)
    __builtin_abort ();
#endif
  static unsigned _BitInt(574) u574[] = {
    52437079816179410811636905891411754807147405868482583243559735153324503490239312503359712796401481190029201386135205713917847314204739635852931994918423899615130723009259686uwb,
    45269866460552189474732773540973151549203847819115194862112414296072167098695417407106646749337072175534165739911745591080506448641600205866240027517670273657001894552180234uwb,
    9180917912712609437909586196568830786346456714119640856730259437790973527459849487895103863584234525859590698749982125884487194000401583172193548884761272331911564480124878uwb,
    11049512233686559553687636036663446413022165259892524030717648180326957779916930880483808447448446584642734113622685260963900225478745988370450191005955141795745690734947571uwb,
    47663369272354253242910978827267365842851495123515313737663958515768452802250710665542640440990559573730917816406856556730100799652539291367902764980370386873495017607993411uwb,
    18215014622276393791745550421148998901660352490811211087424965165803902184090598141881549641537877241526565777992183348471991467868259791203907545956986039786453071578011434uwb,
    31740235950157332221439070489628722839769958133906789091713734411951000853909663917518016071789015372380206595539133512032995220911059581277451361109633464034310397164665564uwb,
    10450847162543795294901585004050399762545006892613453868263703161802323302908254646557151245191494710406620278412346326386062698341158038281632905480774145352377805385543092uwb,
    19453023158842453405396915599369210861261573519874550548893523502986640805175433191781338575797970717670733269190857402493766307964168520080852675173587364248259309552168430uwb,
    41244368675818170615108799247368989151384052534670384186902588532722396202878099538345240688084993610469542913084982675850069064350042690913662957238816036434888665664037846uwb,
    16719362016737006280008309688585219733130381598157287999202010698266470616548718462522730730476541950851348747767571521700255425942578137654761356039235313588531776459325708uwb,
    10475917472649802727102296550431840421435279490948846996006476240420369031587862359912739671064811272746210509826242404174149288385636488194271969135287801110662285317095981uwb,
    1163912911803352668493394805506325912661919234067386269274323760640925113542354050648690202267829712352143945896104268132186183304256748687336699391633352420957751382619669uwb,
    8802741787945718202007440863180520530918335416409181790035566968168103145420485853909047361251267032896173190843315221928932703515727560628431319297083973682964053958087246uwb,
    19791342948421817380238010195638893503615644292584928829415951859564239969766035100704913746176442012398341262166756998845831007892328794072245007765812537811265165604315700uwb,
    16642284329136906697237309134287786314682533828330755403465475806950133035971596597211127434533311710048393623437103786994963036388804007132262710130242198695003152238215628uwb,
    2155325970411161010229823956524370uwb,
    697446886254974788952071928578631979965uwb,
    108165657554251490446057511316485495uwb,
    9487120152929104576906851118100261958096487535uwb,
    -136538663022088871346045694473572wb,
    -1666960912074801530926062313122413146603wb,
    -15940673946961553912565090695396320wb,
    264462353975419400604468749561884442664wb,
    50826882861731683785919742135963976479884717145067744452535625618737864973658554226615085532399945662542810296565555980855512176679463978891752486331179893311834461777517318uwb,
    16170033701813896205634802741964500343094214191596485883117074926829904835328260995277267910766680743976283458668064421272599104442706448899915189301332650772687724575723182uwb,
    13009027737564179578240898152688856367334005472217232817755080920783012286505432066490161649175068937710374621121911926344239719476459487715714492624089105621335225676985872uwb,
    49336707246523391872334763713437428863232354140618977476842520346079224652928216135156362963444355821534349959448992339768542254081420292190058456423815350822979116396882390uwb,
    1026180591140992942712368030740883182331172637458255292975945323684907793150051875uwb,
    61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761243411314314780717702156716099193191615778530561481120811604064555385654220uwb,
    3635377841759794164811391623635227990564259993543952474130713407348044048553863186uwb,
    -139845735971wb
  };
  for (int i = 0; i < 6; ++i)
    if (bar_574 (u574[4 * i], u574[4 * i + 1], u574[4 * i + 2], u574[4 * i + 3]) != u574[i + 24])
      __builtin_abort ();
  if (baz_574 (u574[30], u574[31]) != 1212103790378493380735221770817318414499452864884443699768488049528961780122040714uwb)
    __builtin_abort ();
#endif
}
