/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.lib.ErrorGatherer;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.StaticError;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltPackage;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.StylesheetModule;
import net.sf.saxon.trace.XSLTTraceCodeInjector;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.PackageLibrary;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.linked.DocumentImpl;
import net.sf.saxon.tree.linked.ElementImpl;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.NestedIntegerValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XsltCompiler {
    private Processor processor;
    private Configuration config;
    private CompilerInfo compilerInfo;

    protected XsltCompiler(Processor processor) {
        this.processor = processor;
        this.config = processor.getUnderlyingConfiguration();
        this.compilerInfo = new CompilerInfo(this.config.getDefaultXsltCompilerInfo());
        this.compilerInfo.setGenerateByteCode(this.config.isGenerateByteCode(50));
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public void setURIResolver(URIResolver resolver) {
        this.compilerInfo.setURIResolver(resolver);
    }

    public void setParameter(QName name, XdmValue value) {
        this.compilerInfo.setParameter(name.getStructuredQName(), value.getUnderlyingValue());
    }

    public URIResolver getURIResolver() {
        return this.compilerInfo.getURIResolver();
    }

    public void setErrorListener(ErrorListener listener) {
        this.compilerInfo.setErrorListener(listener);
    }

    public ErrorListener getErrorListener() {
        return this.compilerInfo.getErrorListener();
    }

    public void setSchemaAware(boolean schemaAware) {
        this.compilerInfo.setSchemaAware(schemaAware);
    }

    public boolean isSchemaAware() {
        return this.compilerInfo.isSchemaAware();
    }

    public void declareCollation(String uri, Collator collation) {
        this.getProcessor().declareCollation(uri, collation);
    }

    public void declareDefaultCollation(String uri) {
        StringCollator c;
        try {
            c = this.getProcessor().getUnderlyingConfiguration().getCollation(uri);
        }
        catch (XPathException e) {
            c = null;
        }
        if (c == null) {
            throw new IllegalStateException("Unknown collation " + uri);
        }
        this.compilerInfo.setDefaultCollation(uri);
    }

    public void setXsltLanguageVersion(String version) {
        DecimalValue v;
        try {
            v = (DecimalValue)DecimalValue.makeDecimalValue(version, true).asAtomic();
        }
        catch (ValidationException ve) {
            throw new IllegalArgumentException(ve);
        }
        if (!(DecimalValue.ZERO.equals(v) || DecimalValue.TWO.equals(v) || DecimalValue.THREE.equals(v))) {
            throw new IllegalArgumentException("LanguageVersion " + v);
        }
        this.compilerInfo.setXsltVersion(v);
    }

    public String getXsltLanguageVersion() {
        return this.compilerInfo.getXsltVersion().toString();
    }

    public void setCompileWithTracing(boolean option) {
        if (option) {
            this.compilerInfo.setCodeInjector(new XSLTTraceCodeInjector());
        } else {
            this.compilerInfo.setCodeInjector(null);
        }
    }

    public boolean isCompileWithTracing() {
        return this.compilerInfo.isCompileWithTracing();
    }

    public void setGenerateByteCode(boolean option) {
        this.compilerInfo.setGenerateByteCode(option);
    }

    public boolean isGenerateByteCode() {
        return this.compilerInfo.isGenerateByteCode();
    }

    public Source getAssociatedStylesheet(Source source, String media, String title, String charset) throws SaxonApiException {
        try {
            return StylesheetModule.getAssociatedStylesheet(this.config, this.compilerInfo.getURIResolver(), source, media, title, charset);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public XsltPackage compilePackage(Source source) throws SaxonApiException {
        try {
            Compilation compilation = new Compilation(this.config, this.compilerInfo);
            XsltPackage pack = new XsltPackage(this.processor, compilation.compilePackage(source));
            if (compilation.getErrorCount() > 0) {
                throw new SaxonApiException("Package compilation failed: " + compilation.getErrorCount() + " errors reported");
            }
            return pack;
        }
        catch (XPathException e) {
            throw new SaxonApiException(e.getMessage());
        }
    }

    public Iterable<XsltPackage> compilePackages(Iterable<Source> sources) throws SaxonApiException, XPathException {
        ArrayList<DocumentImpl> sourcesCopy = new ArrayList<DocumentImpl>();
        Compilation compilation = new Compilation(this.config, this.compilerInfo);
        this.compilerInfo.setPackageLibrary(new PackageLibrary());
        ArrayList<XsltPackage> result = new ArrayList<XsltPackage>();
        for (Source s : sources) {
            DocumentImpl document = StylesheetModule.loadStylesheetModule(s, true, compilation, NestedIntegerValue.TWO);
            ElementImpl packageElement = document.getDocumentElement();
            String packageName = packageElement.getAttributeValue("", "name");
            if (packageName == null) {
                throw new SaxonApiException("Outermost element must be an xsl:package element with a name attribute");
            }
            sourcesCopy.add(document);
        }
        while (!sourcesCopy.isEmpty()) {
            DocumentImpl compiled = null;
            for (DocumentImpl doc : sourcesCopy) {
                NodeInfo current;
                AxisIterator iter = doc.iterateAxis((byte)4, new NameTest(1, 204, this.config.getNamePool()));
                boolean canCompile = true;
                while ((current = iter.next()) != null) {
                    String usedPackageName = current.getAttributeValue("", "name");
                    if (this.compilerInfo.getPackageLibrary().getPackage(usedPackageName) != null) continue;
                    canCompile = false;
                    break;
                }
                if (!canCompile) continue;
                XsltPackage packagei = this.compilePackage(doc);
                this.compilerInfo.getPackageLibrary().addPackage(packagei.getName(), packagei.getUnderlyingPreparedPackage());
                result.add(packagei);
                compiled = doc;
                break;
            }
            if (compiled == null) {
                throw new SaxonApiException("Unable to compile any of the packages supplied");
            }
            sourcesCopy.remove(compiled);
        }
        return result;
    }

    public void importPackage(XsltPackage thePackage) throws SaxonApiException {
        if (thePackage.getProcessor() != this.processor) {
            throw new SaxonApiException("The imported package and the XsltCompiler must belong to the same Processor");
        }
        this.compilerInfo.getPackageLibrary().addPackage(thePackage.getName(), thePackage.getUnderlyingPreparedPackage());
    }

    public XsltExecutable compile(Source source) throws SaxonApiException {
        try {
            PreparedStylesheet pss = Compilation.compileSingletonPackage(this.config, this.compilerInfo, source);
            return new XsltExecutable(this.processor, pss);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public CompilerInfo getUnderlyingCompilerInfo() {
        return this.compilerInfo;
    }

    public void setErrorList(List<StaticError> errorList) {
        this.compilerInfo.setErrorListener(new ErrorGatherer(errorList));
    }
}

