//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/config/filter/fault/v2/fault.proto

package faultv2

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on FaultDelay with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *FaultDelay) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on FaultDelay with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in FaultDelayMultiError, or
// nil if none found.
func (m *FaultDelay) ValidateAll() error {
	return m.validate(true)
}

func (m *FaultDelay) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Type

	if all {
		switch v := interface{}(m.GetPercentage()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, FaultDelayValidationError{
					field:  "Percentage",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, FaultDelayValidationError{
					field:  "Percentage",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetPercentage()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return FaultDelayValidationError{
				field:  "Percentage",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	oneofFaultDelaySecifierPresent := false
	switch v := m.FaultDelaySecifier.(type) {
	case *FaultDelay_FixedDelay:
		if v == nil {
			err := FaultDelayValidationError{
				field:  "FaultDelaySecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofFaultDelaySecifierPresent = true

		if d := m.GetFixedDelay(); d != nil {
			dur, err := d.AsDuration(), d.CheckValid()
			if err != nil {
				err = FaultDelayValidationError{
					field:  "FixedDelay",
					reason: "value is not a valid duration",
					cause:  err,
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			} else {

				gt := time.Duration(0*time.Second + 0*time.Nanosecond)

				if dur <= gt {
					err := FaultDelayValidationError{
						field:  "FixedDelay",
						reason: "value must be greater than 0s",
					}
					if !all {
						return err
					}
					errors = append(errors, err)
				}

			}
		}

	case *FaultDelay_HeaderDelay_:
		if v == nil {
			err := FaultDelayValidationError{
				field:  "FaultDelaySecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofFaultDelaySecifierPresent = true

		if all {
			switch v := interface{}(m.GetHeaderDelay()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, FaultDelayValidationError{
						field:  "HeaderDelay",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, FaultDelayValidationError{
						field:  "HeaderDelay",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetHeaderDelay()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return FaultDelayValidationError{
					field:  "HeaderDelay",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofFaultDelaySecifierPresent {
		err := FaultDelayValidationError{
			field:  "FaultDelaySecifier",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return FaultDelayMultiError(errors)
	}

	return nil
}

// FaultDelayMultiError is an error wrapping multiple validation errors
// returned by FaultDelay.ValidateAll() if the designated constraints aren't met.
type FaultDelayMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m FaultDelayMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m FaultDelayMultiError) AllErrors() []error { return m }

// FaultDelayValidationError is the validation error returned by
// FaultDelay.Validate if the designated constraints aren't met.
type FaultDelayValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e FaultDelayValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e FaultDelayValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e FaultDelayValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e FaultDelayValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e FaultDelayValidationError) ErrorName() string { return "FaultDelayValidationError" }

// Error satisfies the builtin error interface
func (e FaultDelayValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sFaultDelay.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = FaultDelayValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = FaultDelayValidationError{}

// Validate checks the field values on FaultRateLimit with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *FaultRateLimit) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on FaultRateLimit with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in FaultRateLimitMultiError,
// or nil if none found.
func (m *FaultRateLimit) ValidateAll() error {
	return m.validate(true)
}

func (m *FaultRateLimit) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetPercentage()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, FaultRateLimitValidationError{
					field:  "Percentage",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, FaultRateLimitValidationError{
					field:  "Percentage",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetPercentage()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return FaultRateLimitValidationError{
				field:  "Percentage",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	oneofLimitTypePresent := false
	switch v := m.LimitType.(type) {
	case *FaultRateLimit_FixedLimit_:
		if v == nil {
			err := FaultRateLimitValidationError{
				field:  "LimitType",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofLimitTypePresent = true

		if all {
			switch v := interface{}(m.GetFixedLimit()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, FaultRateLimitValidationError{
						field:  "FixedLimit",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, FaultRateLimitValidationError{
						field:  "FixedLimit",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetFixedLimit()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return FaultRateLimitValidationError{
					field:  "FixedLimit",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *FaultRateLimit_HeaderLimit_:
		if v == nil {
			err := FaultRateLimitValidationError{
				field:  "LimitType",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofLimitTypePresent = true

		if all {
			switch v := interface{}(m.GetHeaderLimit()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, FaultRateLimitValidationError{
						field:  "HeaderLimit",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, FaultRateLimitValidationError{
						field:  "HeaderLimit",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetHeaderLimit()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return FaultRateLimitValidationError{
					field:  "HeaderLimit",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofLimitTypePresent {
		err := FaultRateLimitValidationError{
			field:  "LimitType",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return FaultRateLimitMultiError(errors)
	}

	return nil
}

// FaultRateLimitMultiError is an error wrapping multiple validation errors
// returned by FaultRateLimit.ValidateAll() if the designated constraints
// aren't met.
type FaultRateLimitMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m FaultRateLimitMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m FaultRateLimitMultiError) AllErrors() []error { return m }

// FaultRateLimitValidationError is the validation error returned by
// FaultRateLimit.Validate if the designated constraints aren't met.
type FaultRateLimitValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e FaultRateLimitValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e FaultRateLimitValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e FaultRateLimitValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e FaultRateLimitValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e FaultRateLimitValidationError) ErrorName() string { return "FaultRateLimitValidationError" }

// Error satisfies the builtin error interface
func (e FaultRateLimitValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sFaultRateLimit.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = FaultRateLimitValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = FaultRateLimitValidationError{}

// Validate checks the field values on FaultDelay_HeaderDelay with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *FaultDelay_HeaderDelay) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on FaultDelay_HeaderDelay with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// FaultDelay_HeaderDelayMultiError, or nil if none found.
func (m *FaultDelay_HeaderDelay) ValidateAll() error {
	return m.validate(true)
}

func (m *FaultDelay_HeaderDelay) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return FaultDelay_HeaderDelayMultiError(errors)
	}

	return nil
}

// FaultDelay_HeaderDelayMultiError is an error wrapping multiple validation
// errors returned by FaultDelay_HeaderDelay.ValidateAll() if the designated
// constraints aren't met.
type FaultDelay_HeaderDelayMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m FaultDelay_HeaderDelayMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m FaultDelay_HeaderDelayMultiError) AllErrors() []error { return m }

// FaultDelay_HeaderDelayValidationError is the validation error returned by
// FaultDelay_HeaderDelay.Validate if the designated constraints aren't met.
type FaultDelay_HeaderDelayValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e FaultDelay_HeaderDelayValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e FaultDelay_HeaderDelayValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e FaultDelay_HeaderDelayValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e FaultDelay_HeaderDelayValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e FaultDelay_HeaderDelayValidationError) ErrorName() string {
	return "FaultDelay_HeaderDelayValidationError"
}

// Error satisfies the builtin error interface
func (e FaultDelay_HeaderDelayValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sFaultDelay_HeaderDelay.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = FaultDelay_HeaderDelayValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = FaultDelay_HeaderDelayValidationError{}

// Validate checks the field values on FaultRateLimit_FixedLimit with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *FaultRateLimit_FixedLimit) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on FaultRateLimit_FixedLimit with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// FaultRateLimit_FixedLimitMultiError, or nil if none found.
func (m *FaultRateLimit_FixedLimit) ValidateAll() error {
	return m.validate(true)
}

func (m *FaultRateLimit_FixedLimit) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetLimitKbps() < 1 {
		err := FaultRateLimit_FixedLimitValidationError{
			field:  "LimitKbps",
			reason: "value must be greater than or equal to 1",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return FaultRateLimit_FixedLimitMultiError(errors)
	}

	return nil
}

// FaultRateLimit_FixedLimitMultiError is an error wrapping multiple validation
// errors returned by FaultRateLimit_FixedLimit.ValidateAll() if the
// designated constraints aren't met.
type FaultRateLimit_FixedLimitMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m FaultRateLimit_FixedLimitMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m FaultRateLimit_FixedLimitMultiError) AllErrors() []error { return m }

// FaultRateLimit_FixedLimitValidationError is the validation error returned by
// FaultRateLimit_FixedLimit.Validate if the designated constraints aren't met.
type FaultRateLimit_FixedLimitValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e FaultRateLimit_FixedLimitValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e FaultRateLimit_FixedLimitValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e FaultRateLimit_FixedLimitValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e FaultRateLimit_FixedLimitValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e FaultRateLimit_FixedLimitValidationError) ErrorName() string {
	return "FaultRateLimit_FixedLimitValidationError"
}

// Error satisfies the builtin error interface
func (e FaultRateLimit_FixedLimitValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sFaultRateLimit_FixedLimit.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = FaultRateLimit_FixedLimitValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = FaultRateLimit_FixedLimitValidationError{}

// Validate checks the field values on FaultRateLimit_HeaderLimit with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *FaultRateLimit_HeaderLimit) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on FaultRateLimit_HeaderLimit with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// FaultRateLimit_HeaderLimitMultiError, or nil if none found.
func (m *FaultRateLimit_HeaderLimit) ValidateAll() error {
	return m.validate(true)
}

func (m *FaultRateLimit_HeaderLimit) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return FaultRateLimit_HeaderLimitMultiError(errors)
	}

	return nil
}

// FaultRateLimit_HeaderLimitMultiError is an error wrapping multiple
// validation errors returned by FaultRateLimit_HeaderLimit.ValidateAll() if
// the designated constraints aren't met.
type FaultRateLimit_HeaderLimitMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m FaultRateLimit_HeaderLimitMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m FaultRateLimit_HeaderLimitMultiError) AllErrors() []error { return m }

// FaultRateLimit_HeaderLimitValidationError is the validation error returned
// by FaultRateLimit_HeaderLimit.Validate if the designated constraints aren't met.
type FaultRateLimit_HeaderLimitValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e FaultRateLimit_HeaderLimitValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e FaultRateLimit_HeaderLimitValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e FaultRateLimit_HeaderLimitValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e FaultRateLimit_HeaderLimitValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e FaultRateLimit_HeaderLimitValidationError) ErrorName() string {
	return "FaultRateLimit_HeaderLimitValidationError"
}

// Error satisfies the builtin error interface
func (e FaultRateLimit_HeaderLimitValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sFaultRateLimit_HeaderLimit.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = FaultRateLimit_HeaderLimitValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = FaultRateLimit_HeaderLimitValidationError{}
